/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import org.jfree.layouting.DocumentContextUtility;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.input.style.CSSDeclarationRule;
import org.jfree.layouting.input.style.CSSPageAreaRule;
import org.jfree.layouting.input.style.CSSPageRule;
import org.jfree.layouting.input.style.CSSStyleRule;
import org.jfree.layouting.input.style.PageAreaType;
import org.jfree.layouting.input.style.PseudoPage;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.StyleRule;
import org.jfree.layouting.input.style.selectors.CSSSelector;
import org.jfree.layouting.input.style.selectors.SelectorWeight;
import org.jfree.layouting.input.style.values.CSSInheritValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.DocumentContext;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.context.LayoutStyle;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.CSSStyleRuleComparator;
import org.jfree.layouting.layouter.style.LayoutStyleImpl;
import org.jfree.layouting.layouter.style.resolver.AbstractStyleResolver;
import org.jfree.layouting.layouter.style.resolver.ResolverFactory;
import org.jfree.layouting.layouter.style.resolver.StyleResolver;
import org.jfree.layouting.layouter.style.resolver.StyleRuleMatcher;
import org.jfree.layouting.namespace.NamespaceCollection;
import org.jfree.layouting.namespace.NamespaceDefinition;
import org.jfree.layouting.util.AttributeMap;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class DefaultStyleResolver
extends AbstractStyleResolver {
    private boolean strictStyleMode;
    private StyleRuleMatcher styleRuleMatcher;
    private StyleKey[] inheritedKeys;

    public void initialize(LayoutProcess layoutProcess) {
        super.initialize(layoutProcess);
        DocumentContext documentContext = layoutProcess.getDocumentContext();
        this.styleRuleMatcher = DocumentContextUtility.getStyleRuleMatcher(documentContext);
        this.styleRuleMatcher.initialize(layoutProcess);
        this.strictStyleMode = Boolean.TRUE.equals(documentContext.getMetaAttribute("strict-style-mode"));
        this.loadInitialStyle();
    }

    protected void resolveOutOfContext(LayoutElement layoutElement) {
        this.resolveStyle(layoutElement);
    }

    public boolean isPseudoElementStyleResolvable(LayoutElement layoutElement, String string) {
        return this.styleRuleMatcher.isMatchingPseudoElement(layoutElement, string);
    }

    public void resolveStyle(LayoutElement layoutElement) {
        Object object;
        LayoutStyle layoutStyle;
        Object object2;
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        StyleKey[] styleKeyArray = this.getKeys();
        LayoutElement layoutElement2 = layoutElement.getParent();
        LayoutStyle layoutStyle2 = this.getInitialStyle();
        if (!layoutContext.copyFrom(layoutStyle2)) {
            DebugLog.log((Object)"Failed to use fast-copy");
            for (int i = 0; i < styleKeyArray.length; ++i) {
                object2 = styleKeyArray[i];
                layoutContext.setValue((StyleKey)object2, layoutStyle2.getValue((StyleKey)object2));
            }
        }
        if (layoutElement2 != null) {
            layoutStyle = layoutElement2.getLayoutContext();
            object2 = this.getInheritedKeys();
            for (int i = 0; i < ((StyleKey[])object2).length; ++i) {
                object = object2[i];
                layoutContext.setValue((StyleKey)object, layoutStyle.getValue((StyleKey)object));
            }
        } else {
            layoutStyle = layoutStyle2;
        }
        this.performSelectionStep(layoutElement, layoutContext);
        object2 = layoutContext.getAttributes();
        Object object3 = ((AttributeMap)object2).getAttribute("http://jfreereport.sourceforge.net/namespaces/layout", "style");
        this.addStyleFromAttribute(layoutElement, object3);
        if (this.strictStyleMode) {
            this.performStrictStyleAttr(layoutElement);
        } else {
            this.performCompleteStyleAttr(layoutElement);
        }
        object = CSSInheritValue.getInstance();
        for (int i = 0; i < styleKeyArray.length; ++i) {
            StyleKey styleKey = styleKeyArray[i];
            CSSValue cSSValue = layoutContext.getValue(styleKey);
            if (!object.equals(cSSValue)) continue;
            layoutContext.setValue(styleKey, layoutStyle.getValue(styleKey));
        }
        ResolverFactory.getInstance().performResolve(this.getLayoutProcess(), layoutElement);
    }

    private StyleKey[] getInheritedKeys() {
        if (this.inheritedKeys == null) {
            StyleKey[] styleKeyArray = this.getKeys();
            ArrayList<StyleKey> arrayList = new ArrayList<StyleKey>();
            for (int i = 0; i < styleKeyArray.length; ++i) {
                StyleKey styleKey = styleKeyArray[i];
                if (!styleKey.isInherited()) continue;
                arrayList.add(styleKey);
            }
            this.inheritedKeys = arrayList.toArray(new StyleKey[arrayList.size()]);
        }
        return this.inheritedKeys;
    }

    private void performStrictStyleAttr(LayoutElement layoutElement) {
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        String string = layoutContext.getNamespace();
        if (string == null) {
            return;
        }
        NamespaceCollection namespaceCollection = this.getNamespaces();
        NamespaceDefinition namespaceDefinition = namespaceCollection.getDefinition(string);
        if (namespaceDefinition == null) {
            return;
        }
        AttributeMap attributeMap = layoutContext.getAttributes();
        String[] stringArray = namespaceDefinition.getStyleAttribute(layoutContext.getTagName());
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            Object object = attributeMap.getAttribute(string, string2);
            this.addStyleFromAttribute(layoutElement, object);
        }
    }

    private void performCompleteStyleAttr(LayoutElement layoutElement) {
        NamespaceCollection namespaceCollection = this.getNamespaces();
        String[] stringArray = namespaceCollection.getNamespaces();
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        AttributeMap attributeMap = layoutContext.getAttributes();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            NamespaceDefinition namespaceDefinition = namespaceCollection.getDefinition(string);
            if (namespaceDefinition == null) continue;
            String[] stringArray2 = namespaceDefinition.getStyleAttribute(layoutContext.getTagName());
            for (int j = 0; j < stringArray2.length; ++j) {
                String string2 = stringArray2[j];
                Object object = attributeMap.getAttribute(string, string2);
                this.addStyleFromAttribute(layoutElement, object);
            }
        }
    }

    private void addStyleFromAttribute(LayoutElement layoutElement, Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof String) {
            String string = (String)object;
            try {
                LayoutProcess layoutProcess = this.getLayoutProcess();
                byte[] byArray = string.getBytes("UTF-8");
                ResourceKey resourceKey = DocumentContextUtility.getBaseResource(layoutProcess.getDocumentContext());
                ResourceManager resourceManager = layoutProcess.getResourceManager();
                ResourceKey resourceKey2 = resourceManager.createKey((Object)byArray);
                Resource resource = resourceManager.create(resourceKey2, resourceKey, StyleRule.class);
                CSSDeclarationRule cSSDeclarationRule = (CSSDeclarationRule)resource.getResource();
                if (cSSDeclarationRule != null) {
                    this.copyStyleInformation(layoutElement.getLayoutContext(), cSSDeclarationRule, layoutElement);
                }
            }
            catch (Exception exception) {
                DebugLog.log((Object)"Unable to handle style attribute value.", (Throwable)exception);
            }
        } else if (object instanceof CSSDeclarationRule) {
            CSSDeclarationRule cSSDeclarationRule = (CSSDeclarationRule)object;
            this.copyStyleInformation(layoutElement.getLayoutContext(), cSSDeclarationRule, layoutElement);
        }
    }

    private void performSelectionStep(LayoutElement layoutElement, LayoutStyle layoutStyle) {
        CSSStyleRule[] cSSStyleRuleArray = this.styleRuleMatcher.getMatchingRules(layoutElement);
        Arrays.sort(cSSStyleRuleArray, new CSSStyleRuleComparator());
        SelectorWeight selectorWeight = null;
        for (int i = 0; i < cSSStyleRuleArray.length; ++i) {
            CSSStyleRule cSSStyleRule = cSSStyleRuleArray[i];
            CSSSelector cSSSelector = cSSStyleRule.getSelector();
            SelectorWeight selectorWeight2 = cSSSelector.getWeight();
            if (selectorWeight != null && selectorWeight.compareTo(selectorWeight2) > 0) {
                selectorWeight = selectorWeight2;
                continue;
            }
            selectorWeight = selectorWeight2;
            this.copyStyleInformation(layoutStyle, cSSStyleRule, layoutElement);
        }
    }

    public StyleResolver deriveInstance() {
        return this;
    }

    public State saveState() throws StateException {
        DefaultStyleResolverState defaultStyleResolverState = new DefaultStyleResolverState();
        this.fillState(defaultStyleResolverState);
        defaultStyleResolverState.setRuleMatcher(this.styleRuleMatcher);
        defaultStyleResolverState.setStrictStyleMode(this.strictStyleMode);
        return defaultStyleResolverState;
    }

    public LayoutStyle resolvePageStyle(CSSValue cSSValue, PseudoPage[] pseudoPageArray, PageAreaType pageAreaType) {
        LayoutStyleImpl layoutStyleImpl = new LayoutStyleImpl();
        CSSPageRule[] cSSPageRuleArray = this.styleRuleMatcher.getPageRule(cSSValue, pseudoPageArray);
        for (int i = 0; i < cSSPageRuleArray.length; ++i) {
            CSSPageRule cSSPageRule = cSSPageRuleArray[i];
            this.copyStyleInformation(layoutStyleImpl, cSSPageRule, null);
            int n = cSSPageRule.getRuleCount();
            for (int j = 0; j < n; ++j) {
                CSSPageAreaRule cSSPageAreaRule = cSSPageRule.getRule(j);
                if (!cSSPageAreaRule.getPageArea().equals(pageAreaType)) continue;
                this.copyStyleInformation(layoutStyleImpl, cSSPageAreaRule, null);
            }
        }
        return layoutStyleImpl;
    }

    private static class DefaultStyleResolverState
    extends AbstractStyleResolver.AbstractStyleResolverState {
        private boolean strictStyleMode;
        private StyleRuleMatcher ruleMatcher;

        private DefaultStyleResolverState() {
        }

        public boolean isStrictStyleMode() {
            return this.strictStyleMode;
        }

        public void setStrictStyleMode(boolean bl) {
            this.strictStyleMode = bl;
        }

        public StyleRuleMatcher getRuleMatcher() {
            return this.ruleMatcher;
        }

        public void setRuleMatcher(StyleRuleMatcher styleRuleMatcher) {
            this.ruleMatcher = styleRuleMatcher;
        }

        protected AbstractStyleResolver create() {
            return new DefaultStyleResolver();
        }

        protected void fill(AbstractStyleResolver abstractStyleResolver, LayoutProcess layoutProcess) {
            super.fill(abstractStyleResolver, layoutProcess);
            DefaultStyleResolver defaultStyleResolver = (DefaultStyleResolver)abstractStyleResolver;
            defaultStyleResolver.styleRuleMatcher = this.ruleMatcher;
            defaultStyleResolver.strictStyleMode = this.strictStyleMode;
        }
    }
}

