/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import org.netbeans.lib.profiler.ui.swing.ProfilerColumnModel;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;

class ProfilerTableActions {
    private final ProfilerTable table;

    static void install(ProfilerTable profilerTable) {
        new ProfilerTableActions(profilerTable).install();
    }

    private ProfilerTableActions(ProfilerTable profilerTable) {
        this.table = profilerTable;
    }

    private void install() {
        ActionMap actionMap = this.table.getActionMap();
        actionMap.put("selectNextColumn", this.selectNextColumnAction());
        actionMap.put("selectPreviousColumn", this.selectPreviousColumnAction());
        actionMap.put("selectNextColumnCell", this.createNextCellAction());
        actionMap.put("selectPreviousColumnCell", this.createPreviousCellAction());
        actionMap.put("selectFirstColumn", this.selectFirstColumnAction());
        actionMap.put("selectLastColumn", this.selectLastColumnAction());
        actionMap.put("selectNextRowCell", this.selectNextRowAction());
        actionMap.put("selectPreviousRowCell", this.selectPreviousRowAction());
        actionMap.put("selectNextRowExtendSelection", actionMap.get("selectNextRow"));
        actionMap.put("selectPreviousRowExtendSelection", actionMap.get("selectPreviousRow"));
        actionMap.put("selectNextColumnExtendSelection", actionMap.get("selectNextColumn"));
        actionMap.put("selectPreviousColumnExtendSelection", actionMap.get("selectPreviousColumn"));
        actionMap.put("selectLastColumnExtendSelection", actionMap.get("selectLastColumn"));
        actionMap.put("selectFirstColumnExtendSelection", actionMap.get("selectFirstColumn"));
    }

    private Action selectNextRowAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfilerColumnModel profilerColumnModel = ProfilerTableActions.this.table._getColumnModel();
                if (ProfilerTableActions.this.table.getRowCount() == 0 || profilerColumnModel.getVisibleColumnCount() == 0) {
                    return;
                }
                int n = ProfilerTableActions.this.table.getSelectedRow();
                if (n == -1) {
                    ProfilerTableActions.this.table.selectColumn(profilerColumnModel.getFirstVisibleColumn(), false);
                    ProfilerTableActions.this.table.selectRow(0, true);
                } else {
                    if (++n == ProfilerTableActions.this.table.getRowCount()) {
                        n = 0;
                        int n2 = ProfilerTableActions.this.table.getSelectedColumn();
                        if (n2 == -1) {
                            n2 = profilerColumnModel.getFirstVisibleColumn();
                        }
                        n2 = profilerColumnModel.getNextVisibleColumn(n2);
                        ProfilerTableActions.this.table.selectColumn(n2, false);
                    }
                    ProfilerTableActions.this.table.selectRow(n, true);
                }
            }
        };
    }

    private Action selectPreviousRowAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfilerColumnModel profilerColumnModel = ProfilerTableActions.this.table._getColumnModel();
                if (ProfilerTableActions.this.table.getRowCount() == 0 || profilerColumnModel.getVisibleColumnCount() == 0) {
                    return;
                }
                int n = ProfilerTableActions.this.table.getSelectedRow();
                if (n == -1) {
                    ProfilerTableActions.this.table.selectColumn(profilerColumnModel.getLastVisibleColumn(), false);
                    ProfilerTableActions.this.table.selectRow(ProfilerTableActions.this.table.getRowCount() - 1, true);
                } else {
                    if (--n == -1) {
                        n = ProfilerTableActions.this.table.getRowCount() - 1;
                        int n2 = ProfilerTableActions.this.table.getSelectedColumn();
                        if (n2 == -1) {
                            n2 = profilerColumnModel.getLastVisibleColumn();
                        }
                        n2 = profilerColumnModel.getPreviousVisibleColumn(n2);
                        ProfilerTableActions.this.table.selectColumn(n2, false);
                    }
                    ProfilerTableActions.this.table.selectRow(n, true);
                }
            }
        };
    }

    private Action selectFirstColumnAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfilerColumnModel profilerColumnModel = ProfilerTableActions.this.table._getColumnModel();
                if (ProfilerTableActions.this.table.getRowCount() == 0 || profilerColumnModel.getVisibleColumnCount() == 0) {
                    return;
                }
                int n = ProfilerTableActions.this.table.getSelectedRow();
                ProfilerTableActions.this.table.selectColumn(profilerColumnModel.getFirstVisibleColumn(), n != -1);
                if (n == -1) {
                    ProfilerTableActions.this.table.selectRow(0, true);
                }
            }
        };
    }

    private Action selectLastColumnAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfilerColumnModel profilerColumnModel = ProfilerTableActions.this.table._getColumnModel();
                if (ProfilerTableActions.this.table.getRowCount() == 0 || profilerColumnModel.getVisibleColumnCount() == 0) {
                    return;
                }
                int n = ProfilerTableActions.this.table.getSelectedRow();
                ProfilerTableActions.this.table.selectColumn(profilerColumnModel.getLastVisibleColumn(), n != -1);
                if (n == -1) {
                    ProfilerTableActions.this.table.selectRow(0, true);
                }
            }
        };
    }

    private Action selectNextColumnAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfilerColumnModel profilerColumnModel = ProfilerTableActions.this.table._getColumnModel();
                if (ProfilerTableActions.this.table.getRowCount() == 0 || profilerColumnModel.getVisibleColumnCount() == 0) {
                    return;
                }
                int n = ProfilerTableActions.this.table.getSelectedColumn();
                if (n == -1) {
                    ProfilerTableActions.this.table.selectColumn(profilerColumnModel.getFirstVisibleColumn(), false);
                    ProfilerTableActions.this.table.selectRow(0, true);
                } else {
                    int n2 = profilerColumnModel.getNextVisibleColumn(n);
                    if (n2 > n) {
                        ProfilerTableActions.this.table.selectColumn(n2, true);
                    }
                }
            }
        };
    }

    private Action selectPreviousColumnAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfilerColumnModel profilerColumnModel = ProfilerTableActions.this.table._getColumnModel();
                if (ProfilerTableActions.this.table.getRowCount() == 0 || profilerColumnModel.getVisibleColumnCount() == 0) {
                    return;
                }
                int n = ProfilerTableActions.this.table.getSelectedColumn();
                if (n == -1) {
                    ProfilerTableActions.this.table.selectColumn(profilerColumnModel.getFirstVisibleColumn(), false);
                    ProfilerTableActions.this.table.selectRow(0, true);
                } else {
                    int n2 = profilerColumnModel.getPreviousVisibleColumn(n);
                    if (n2 < n) {
                        ProfilerTableActions.this.table.selectColumn(n2, true);
                    }
                }
            }
        };
    }

    private Action createNextCellAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfilerColumnModel profilerColumnModel = ProfilerTableActions.this.table._getColumnModel();
                if (ProfilerTableActions.this.table.getRowCount() == 0 || profilerColumnModel.getVisibleColumnCount() == 0) {
                    return;
                }
                int n = ProfilerTableActions.this.table.getSelectedColumn();
                if (n == -1) {
                    ProfilerTableActions.this.table.selectColumn(profilerColumnModel.getFirstVisibleColumn(), false);
                    ProfilerTableActions.this.table.selectRow(0, true);
                } else {
                    int n2;
                    int n3;
                    boolean bl;
                    int n4 = profilerColumnModel.getNextVisibleColumn(n);
                    boolean bl2 = bl = n4 <= n && ProfilerTableActions.this.table.getRowCount() > 1;
                    if (n4 != n) {
                        ProfilerTableActions.this.table.selectColumn(n4, !bl);
                    }
                    if (bl && (n3 = ProfilerTableActions.this.table.getSelectedRow()) != (n2 = ProfilerTableActions.this.getNextRow(n3))) {
                        ProfilerTableActions.this.table.selectRow(n2, true);
                    }
                }
            }
        };
    }

    private Action createPreviousCellAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfilerColumnModel profilerColumnModel = ProfilerTableActions.this.table._getColumnModel();
                if (ProfilerTableActions.this.table.getRowCount() == 0 || profilerColumnModel.getVisibleColumnCount() == 0) {
                    return;
                }
                int n = ProfilerTableActions.this.table.getSelectedColumn();
                if (n == -1) {
                    ProfilerTableActions.this.table.selectColumn(profilerColumnModel.getFirstVisibleColumn(), false);
                    ProfilerTableActions.this.table.selectRow(0, true);
                } else {
                    int n2;
                    int n3;
                    boolean bl;
                    int n4 = profilerColumnModel.getPreviousVisibleColumn(n);
                    boolean bl2 = bl = n4 >= n && ProfilerTableActions.this.table.getRowCount() > 1;
                    if (n4 != n) {
                        ProfilerTableActions.this.table.selectColumn(n4, !bl);
                    }
                    if (bl && (n3 = ProfilerTableActions.this.table.getSelectedRow()) != (n2 = ProfilerTableActions.this.getPreviousRow(n3))) {
                        ProfilerTableActions.this.table.selectRow(n2, true);
                    }
                }
            }
        };
    }

    private int getNextRow(int n) {
        return ++n == this.table.getRowCount() ? 0 : n;
    }

    private int getPreviousRow(int n) {
        return --n == -1 ? this.table.getRowCount() - 1 : n;
    }
}

