#ifndef _ELDBUS_MODEL_METHOD_EO_H_
#define _ELDBUS_MODEL_METHOD_EO_H_

#ifndef _ELDBUS_MODEL_METHOD_EO_CLASS_TYPE
#define _ELDBUS_MODEL_METHOD_EO_CLASS_TYPE

typedef Eo Eldbus_Model_Method;

#endif

#ifndef _ELDBUS_MODEL_METHOD_EO_TYPES
#define _ELDBUS_MODEL_METHOD_EO_TYPES


#endif
#define ELDBUS_MODEL_METHOD_CLASS eldbus_model_method_class_get()

EAPI const Eo_Class *eldbus_model_method_class_get(void) EINA_CONST;

/**
 * @brief Custom Eldbus_Model_Method constructor.
 *
 * @param[in] method The introspected method
 *
 * @since 1.16
 *
 * @ingroup Eldbus_Model_Method
 */
EOAPI void eldbus_model_method_constructor(Eldbus_Proxy *proxy, const Eldbus_Introspection_Method *method);

/**
 * @brief Calls the method. The properties must have been set.
 *
 * The event EMODEL_EVENT_PROPERTIES_CHANGED is raised for output arguments
 * (properties).
 *
 * The event ELDBUS_MODEL_METHOD_EVENT_METHOD_CALLED is raised for a successful
 * call. Otherwise the event EMODEL_EVENT_LOAD_STATUS with the status set to
 * EMODEL_LOAD_STATUS_ERROR is raised.
 *
 * @return #Emodel_Load_Status on success, #EMODEL_LOAD_STATUS_ERROR otherwise.
 *
 * @since 1.16
 *
 * @ingroup Eldbus_Model_Method
 */
EOAPI Efl_Model_Load_Status eldbus_model_method_call(void);

EOAPI extern const Eo_Event_Description _ELDBUS_MODEL_METHOD_EVENT_SUCCESSFUL_CALL;

/** Event dispatched for a successful method call.
 *
 * @ingroup Eldbus_Model_Method
 */
#define ELDBUS_MODEL_METHOD_EVENT_SUCCESSFUL_CALL (&(_ELDBUS_MODEL_METHOD_EVENT_SUCCESSFUL_CALL))

#endif
