/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.rmi.registry;

import com.sun.jndi.rmi.registry.RegistryContext;
import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

class BindingEnumeration
implements NamingEnumeration {
    private RegistryContext ctx;
    private final String[] names;
    private int nextName;

    BindingEnumeration(RegistryContext ctx, String[] names) {
        this.ctx = new RegistryContext(ctx);
        this.names = names;
        this.nextName = 0;
    }

    protected void finalize() {
        this.ctx.close();
    }

    @Override
    public boolean hasMore() {
        if (this.nextName >= this.names.length) {
            this.ctx.close();
        }
        return this.nextName < this.names.length;
    }

    public Object next() throws NamingException {
        if (!this.hasMore()) {
            throw new NoSuchElementException();
        }
        String name = this.names[this.nextName++];
        Name cname = new CompositeName().add(name);
        Object obj = this.ctx.lookup(cname);
        String cnameStr = cname.toString();
        Binding binding = new Binding(cnameStr, obj);
        binding.setNameInNamespace(cnameStr);
        return binding;
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMore();
    }

    @Override
    public Object nextElement() {
        try {
            return this.next();
        }
        catch (NamingException e) {
            throw new NoSuchElementException("javax.naming.NamingException was thrown");
        }
    }

    @Override
    public void close() {
        this.finalize();
    }
}

