/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import jdk.nashorn.internal.codegen.Compiler;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.ObjectClassGenerator;
import jdk.nashorn.internal.lookup.Lookup;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptObject;

public final class AllocationStrategy
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private final int fieldCount;
    private final boolean dualFields;
    private transient String allocatorClassName;
    private transient MethodHandle allocator;

    public AllocationStrategy(int fieldCount, boolean dualFields) {
        this.fieldCount = fieldCount;
        this.dualFields = dualFields;
    }

    private String getAllocatorClassName() {
        if (this.allocatorClassName == null) {
            this.allocatorClassName = Compiler.binaryName(ObjectClassGenerator.getClassName(this.fieldCount, this.dualFields)).intern();
        }
        return this.allocatorClassName;
    }

    PropertyMap getAllocatorMap() {
        return PropertyMap.newMap(null, this.getAllocatorClassName(), 0, this.fieldCount, 0);
    }

    ScriptObject allocate(PropertyMap map) {
        try {
            if (this.allocator == null) {
                this.allocator = Lookup.MH.findStatic(LOOKUP, Context.forStructureClass(this.getAllocatorClassName()), CompilerConstants.ALLOCATE.symbolName(), Lookup.MH.type(ScriptObject.class, PropertyMap.class));
            }
            return this.allocator.invokeExact(map);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public String toString() {
        return "AllocationStrategy[fieldCount=" + this.fieldCount + "]";
    }
}

