#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: hackage-security
version: 0.5.1.0
id: hackage-security-0.5.1.0-a06ad09b94489212e6dbfb158698f8c5
key: hacka_8B51BAtW1foA90aTN0U3Jl
license: BSD3
copyright: Copyright 2015 Well-Typed LLP
maintainer: edsko@well-typed.com
homepage: https://github.com/well-typed/hackage-security
synopsis: Hackage security library
description:
    The hackage security library provides both server and
    client utilities for securing the Hackage package server
    (<http://hackage.haskell.org/>).  It is based on The Update
    Framework (<http://theupdateframework.com/>), a set of
    recommendations developed by security researchers at
    various universities in the US as well as developers on the
    Tor project (<https://www.torproject.org/>).
    .
    The current implementation supports only index signing,
    thereby enabling untrusted mirrors. It does not yet provide
    facilities for author package signing.
    .
    The library has two main entry points:
    "Hackage.Security.Client" is the main entry point for
    clients (the typical example being @cabal@), and
    "Hackage.Security.Server" is the main entry point for
    servers (the typical example being @hackage-server@).
    .
    This is a beta release.
category: Distribution
author: Edsko de Vries
exposed: True
exposed-modules:
    Hackage.Security.Client Hackage.Security.Client.Formats
    Hackage.Security.Client.Repository
    Hackage.Security.Client.Repository.Cache
    Hackage.Security.Client.Repository.Local
    Hackage.Security.Client.Repository.Remote
    Hackage.Security.Client.Repository.HttpLib
    Hackage.Security.Client.Verify Hackage.Security.JSON
    Hackage.Security.Key.Env Hackage.Security.Server
    Hackage.Security.Trusted Hackage.Security.TUF.FileMap
    Hackage.Security.Util.Checked Hackage.Security.Util.IO
    Hackage.Security.Util.Lens Hackage.Security.Util.Path
    Hackage.Security.Util.Pretty Hackage.Security.Util.Some
    Text.JSON.Canonical
hidden-modules: Hackage.Security.Key Hackage.Security.Trusted.TCB
                Hackage.Security.TUF Hackage.Security.TUF.Common
                Hackage.Security.TUF.FileInfo Hackage.Security.TUF.Header
                Hackage.Security.TUF.Layout.Cache Hackage.Security.TUF.Layout.Index
                Hackage.Security.TUF.Layout.Repo Hackage.Security.TUF.Mirrors
                Hackage.Security.TUF.Paths Hackage.Security.TUF.Patterns
                Hackage.Security.TUF.Root Hackage.Security.TUF.Signed
                Hackage.Security.TUF.Snapshot Hackage.Security.TUF.Targets
                Hackage.Security.TUF.Timestamp Hackage.Security.Util.Base64
                Hackage.Security.Util.JSON Hackage.Security.Util.Stack
                Hackage.Security.Util.TypedEmbedded Prelude
trusted: False
import-dirs: /usr/lib/ghc-7.10.3/site-local/hackage-security-0.5.1.0
library-dirs: /usr/lib/ghc-7.10.3/site-local/hackage-security-0.5.1.0
data-dir: /usr/share/arm-linux-ghc-7.10.3/hackage-security-0.5.1.0
hs-libraries: HShackage-security-0.5.1.0-8B51BAtW1foA90aTN0U3Jl
depends:
    Cabal-1.22.5.0-9b2e7feff1fc55070a0a783f283ee9b6
    base-4.8.2.0-2f1f71a7fcf013cd47fd21f489064f9a
    base16-bytestring-0.1.1.6-2ce49c0fdad8d57abae997bf0287241a
    base64-bytestring-1.0.0.1-7819850819049320f81b6417431cc8a5
    bytestring-0.10.6.0-3b51e35daa3fe2a56ecd3687fb389cdc
    containers-0.5.6.2-169e53288f333dd2f0207994fd53822f
    cryptohash-sha256-0.11.7.1-d05ddf3572b6806eea150b3a8e81838f
    directory-1.2.2.0-17b2023f9d7e8036d19e6b52b4f75c98
    ed25519-0.0.5.0-ac82093bde15ea4a6d36ab3500bf2ce3
    filepath-1.4.0.0-73e0bec80594160bf6dd6cb25217c6bf
    ghc-prim-0.4.0.0-bf246eb9fdda7435f0c147a313ce59fb
    mtl-2.2.1-c516313407bc17046965067cb7cbb6a0
    network-2.6.2.1-602ee4a12c5a174f6683a75303a065d3
    network-uri-2.6.1.0-0e39aca8530572505c01ef548c540bd6
    parsec-3.1.9-3365ddffd9ca11d2f0b377e002b54baf
    pretty-1.1.2.0-b06321e1e395640194b358a5374c465f
    tar-0.5.0.3-0a1915ca475d218d70c2c2cc2299db4e
    template-haskell-2.10.0.0-4b92ab565139fd81021b60a162b59eb8
    time-1.5.0.1-cf94b0d806e26f6c4e356671290061b2
    transformers-0.4.2.0-252429dba576bc247c1932da496e0a3f
    zlib-0.6.1.1-863f5ed4c9ef7e591295c362d5c5d2a5
haddock-interfaces: /usr/share/doc/haskell-hackage-security/html/hackage-security.haddock
haddock-html: /usr/share/doc/haskell-hackage-security/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
