/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.layouts.Layouts;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class)})
public abstract class ArraySliceNode
extends RubyNode {
    final int from;
    final int to;

    public ArraySliceNode(RubyContext context, SourceSection sourceSection, int from, int to) {
        super(context, sourceSection);
        assert (from >= 0);
        assert (to <= 0);
        this.from = from;
        this.to = to;
    }

    @Specialization(guards={"isNullArray(array)"})
    public DynamicObject sliceNull(DynamicObject array) {
        CompilerDirectives.transferToInterpreter();
        return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), null, 0);
    }

    @Specialization(guards={"isIntArray(array)"})
    public DynamicObject sliceIntegerFixnum(DynamicObject array) {
        CompilerDirectives.transferToInterpreter();
        int to = Layouts.ARRAY.getSize(array) + this.to;
        if (this.from >= to) {
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), null, 0);
        }
        return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), ArrayUtils.extractRange((int[])Layouts.ARRAY.getStore(array), this.from, to), to - this.from);
    }

    @Specialization(guards={"isLongArray(array)"})
    public DynamicObject sliceLongFixnum(DynamicObject array) {
        CompilerDirectives.transferToInterpreter();
        int to = Layouts.ARRAY.getSize(array) + this.to;
        if (this.from >= to) {
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), null, 0);
        }
        return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), ArrayUtils.extractRange((long[])Layouts.ARRAY.getStore(array), this.from, to), to - this.from);
    }

    @Specialization(guards={"isDoubleArray(array)"})
    public DynamicObject sliceFloat(DynamicObject array) {
        CompilerDirectives.transferToInterpreter();
        int to = Layouts.ARRAY.getSize(array) + this.to;
        if (this.from >= to) {
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), null, 0);
        }
        return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), ArrayUtils.extractRange((double[])Layouts.ARRAY.getStore(array), this.from, to), to - this.from);
    }

    @Specialization(guards={"isObjectArray(array)"})
    public DynamicObject sliceObject(DynamicObject array) {
        CompilerDirectives.transferToInterpreter();
        int to = Layouts.ARRAY.getSize(array) + this.to;
        if (this.from >= to) {
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), null, 0);
        }
        return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), ArrayUtils.extractRange((Object[])Layouts.ARRAY.getStore(array), this.from, to), to - this.from);
    }
}

