/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.ImportConflictBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeCollisionException;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.CompoundNameVector;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.HashtableOfType;
import org.eclipse.jdt.internal.compiler.util.ObjectVector;
import org.eclipse.jdt.internal.compiler.util.SimpleNameVector;

public class CompilationUnitScope
extends Scope {
    public LookupEnvironment environment;
    public CompilationUnitDeclaration referenceContext;
    public char[][] currentPackageName;
    public PackageBinding fPackage;
    public ImportBinding[] imports;
    public int importPtr;
    public HashtableOfObject typeOrPackageCache;
    public SourceTypeBinding[] topLevelTypes;
    private CompoundNameVector qualifiedReferences;
    private SimpleNameVector simpleNameReferences;
    private SimpleNameVector rootReferences;
    private ObjectVector referencedTypes;
    private ObjectVector referencedSuperTypes;
    HashtableOfType constantPoolNameUsage;
    private int captureID = 1;
    private ImportBinding[] tempImports;
    public boolean suppressImportErrors;
    private boolean skipCachingImports;
    boolean connectingHierarchy;

    public CompilationUnitScope(CompilationUnitDeclaration compilationUnitDeclaration, LookupEnvironment lookupEnvironment) {
        super(4, null);
        this.environment = lookupEnvironment;
        this.referenceContext = compilationUnitDeclaration;
        compilationUnitDeclaration.scope = this;
        char[][] cArray = this.currentPackageName = compilationUnitDeclaration.currentPackage == null ? CharOperation.NO_CHAR_CHAR : compilationUnitDeclaration.currentPackage.tokens;
        if (this.compilerOptions().produceReferenceInfo) {
            this.qualifiedReferences = new CompoundNameVector();
            this.simpleNameReferences = new SimpleNameVector();
            this.rootReferences = new SimpleNameVector();
            this.referencedTypes = new ObjectVector();
            this.referencedSuperTypes = new ObjectVector();
        } else {
            this.qualifiedReferences = null;
            this.simpleNameReferences = null;
            this.rootReferences = null;
            this.referencedTypes = null;
            this.referencedSuperTypes = null;
        }
    }

    void buildFieldsAndMethods() {
        int n = this.topLevelTypes.length;
        for (int i = 0; i < n; ++i) {
            this.topLevelTypes[i].scope.buildFieldsAndMethods();
        }
    }

    void buildTypeBindings(AccessRestriction accessRestriction) {
        Object object;
        this.topLevelTypes = new SourceTypeBinding[0];
        boolean bl = false;
        if (this.referenceContext.compilationResult.compilationUnit != null && (object = this.referenceContext.compilationResult.compilationUnit.getPackageName()) != null && !CharOperation.equals(this.currentPackageName, object)) {
            if (this.referenceContext.currentPackage != null || this.referenceContext.types != null || this.referenceContext.imports != null) {
                this.problemReporter().packageIsNotExpectedPackage(this.referenceContext);
            }
            char[][] cArray = this.currentPackageName = ((char[][])object).length == 0 ? CharOperation.NO_CHAR_CHAR : object;
        }
        if (this.currentPackageName == CharOperation.NO_CHAR_CHAR) {
            this.fPackage = this.environment.defaultPackage;
        } else {
            this.fPackage = this.environment.createPackage(this.currentPackageName);
            if (this.fPackage == null) {
                if (this.referenceContext.currentPackage != null) {
                    this.problemReporter().packageCollidesWithType(this.referenceContext);
                }
                this.fPackage = this.environment.defaultPackage;
                return;
            }
            if (this.referenceContext.isPackageInfo()) {
                if (this.referenceContext.types == null || this.referenceContext.types.length == 0) {
                    this.referenceContext.types = new TypeDeclaration[1];
                    this.referenceContext.createPackageInfoType();
                    bl = true;
                }
                if (this.referenceContext.currentPackage != null && this.referenceContext.currentPackage.annotations != null) {
                    this.referenceContext.types[0].annotations = this.referenceContext.currentPackage.annotations;
                }
            }
            this.recordQualifiedReference(this.currentPackageName);
        }
        object = this.referenceContext.types;
        int n = object == null ? 0 : ((char[][])object).length;
        this.topLevelTypes = new SourceTypeBinding[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Object object2;
            char[] cArray = object[i];
            if (this.environment.isProcessingAnnotations && this.environment.isMissingType(cArray.name)) {
                throw new SourceTypeCollisionException();
            }
            ReferenceBinding referenceBinding = this.fPackage.getType0(cArray.name);
            this.recordSimpleReference(cArray.name);
            if (referenceBinding != null && referenceBinding.isValidBinding() && !(referenceBinding instanceof UnresolvedReferenceBinding)) {
                if (this.environment.isProcessingAnnotations) {
                    throw new SourceTypeCollisionException();
                }
                this.problemReporter().duplicateTypes(this.referenceContext, (TypeDeclaration)cArray);
                continue;
            }
            if (this.fPackage != this.environment.defaultPackage && this.fPackage.getPackage(cArray.name) != null) {
                this.problemReporter().typeCollidesWithPackage(this.referenceContext, (TypeDeclaration)cArray);
            }
            if ((cArray.modifiers & 1) != 0 && (object2 = this.referenceContext.getMainTypeName()) != null && !CharOperation.equals((char[])object2, cArray.name)) {
                this.problemReporter().publicClassMustMatchFileName(this.referenceContext, (TypeDeclaration)cArray);
            }
            object2 = new ClassScope(this, (TypeDeclaration)cArray);
            SourceTypeBinding sourceTypeBinding = ((ClassScope)object2).buildType(null, this.fPackage, accessRestriction);
            if (bl && i == 0) {
                sourceTypeBinding.modifiers |= 0x1000;
            }
            if (sourceTypeBinding == null) continue;
            this.topLevelTypes[n2++] = sourceTypeBinding;
        }
        if (n2 != this.topLevelTypes.length) {
            this.topLevelTypes = new SourceTypeBinding[n2];
            System.arraycopy(this.topLevelTypes, 0, this.topLevelTypes, 0, n2);
        }
    }

    void checkAndSetImports() {
        if (this.referenceContext.imports == null) {
            this.imports = this.getDefaultImports();
            return;
        }
        int n = this.referenceContext.imports.length;
        int n2 = n + 1;
        for (int i = 0; i < n; ++i) {
            ImportReference importReference = this.referenceContext.imports[i];
            if ((importReference.bits & 0x20000) == 0 || !CharOperation.equals(TypeConstants.JAVA_LANG, importReference.tokens) || importReference.isStatic()) continue;
            --n2;
            break;
        }
        ImportBinding[] importBindingArray = new ImportBinding[n2];
        importBindingArray[0] = this.getDefaultImports()[0];
        int n3 = 1;
        block1: for (int i = 0; i < n; ++i) {
            ImportReference importReference = this.referenceContext.imports[i];
            char[][] cArray = importReference.tokens;
            for (int j = 0; j < n3; ++j) {
                ImportBinding importBinding = importBindingArray[j];
                if (importBinding.onDemand == ((importReference.bits & 0x20000) != 0) && importBinding.isStatic() == importReference.isStatic() && CharOperation.equals(cArray, importBindingArray[j].compoundName)) continue block1;
            }
            if ((importReference.bits & 0x20000) != 0) {
                Binding binding;
                if (CharOperation.equals(cArray, this.currentPackageName) || !(binding = this.findImport(cArray, cArray.length)).isValidBinding() || importReference.isStatic() && binding instanceof PackageBinding) continue;
                importBindingArray[n3++] = new ImportBinding(cArray, true, binding, importReference);
                continue;
            }
            importBindingArray[n3++] = new ImportBinding(cArray, false, null, importReference);
        }
        if (importBindingArray.length > n3) {
            ImportBinding[] importBindingArray2 = importBindingArray;
            importBindingArray = new ImportBinding[n3];
            System.arraycopy(importBindingArray2, 0, importBindingArray, 0, n3);
        }
        this.imports = importBindingArray;
    }

    void checkParameterizedTypes() {
        if (this.compilerOptions().sourceLevel < 0x310000L) {
            return;
        }
        int n = this.topLevelTypes.length;
        for (int i = 0; i < n; ++i) {
            ClassScope classScope = this.topLevelTypes[i].scope;
            classScope.checkParameterizedTypeBounds();
            classScope.checkParameterizedSuperTypeCollisions();
        }
    }

    public char[] computeConstantPoolName(LocalTypeBinding localTypeBinding) {
        char[] cArray;
        boolean bl;
        if (localTypeBinding.constantPoolName != null) {
            return localTypeBinding.constantPoolName;
        }
        if (this.constantPoolNameUsage == null) {
            this.constantPoolNameUsage = new HashtableOfType();
        }
        SourceTypeBinding sourceTypeBinding = localTypeBinding.scope.outerMostClassScope().enclosingSourceType();
        int n = 0;
        boolean bl2 = bl = this.compilerOptions().complianceLevel >= 0x310000L;
        while (true) {
            cArray = localTypeBinding.isMemberType() ? (n == 0 ? CharOperation.concat(localTypeBinding.enclosingType().constantPoolName(), localTypeBinding.sourceName, '$') : CharOperation.concat(localTypeBinding.enclosingType().constantPoolName(), '$', String.valueOf(n).toCharArray(), '$', localTypeBinding.sourceName)) : (localTypeBinding.isAnonymousType() ? (bl ? CharOperation.concat(localTypeBinding.enclosingType.constantPoolName(), String.valueOf(n + 1).toCharArray(), '$') : CharOperation.concat(sourceTypeBinding.constantPoolName(), String.valueOf(n + 1).toCharArray(), '$')) : (bl ? CharOperation.concat(CharOperation.concat(localTypeBinding.enclosingType().constantPoolName(), String.valueOf(n + 1).toCharArray(), '$'), localTypeBinding.sourceName) : CharOperation.concat(sourceTypeBinding.constantPoolName(), '$', String.valueOf(n + 1).toCharArray(), '$', localTypeBinding.sourceName)));
            if (this.constantPoolNameUsage.get(cArray) == null) break;
            ++n;
        }
        this.constantPoolNameUsage.put(cArray, localTypeBinding);
        return cArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectTypeHierarchy() {
        this.connectingHierarchy = true;
        try {
            int n = this.topLevelTypes.length;
            for (int i = 0; i < n; ++i) {
                this.topLevelTypes[i].scope.connectTypeHierarchy();
            }
        }
        finally {
            this.connectingHierarchy = false;
        }
    }

    void faultInImports() {
        Object object;
        int n;
        int n2;
        int n3;
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = bl = !this.suppressImportErrors;
        if (this.typeOrPackageCache != null && !this.skipCachingImports) {
            return;
        }
        if (this.referenceContext.imports == null) {
            this.typeOrPackageCache = new HashtableOfObject(1);
            return;
        }
        int n4 = this.referenceContext.imports.length;
        HashtableOfType hashtableOfType = null;
        for (n3 = 0; n3 < n4; ++n3) {
            if ((this.referenceContext.imports[n3].bits & 0x20000) != 0) continue;
            hashtableOfType = new HashtableOfType(this.topLevelTypes.length + n4);
            n2 = this.topLevelTypes.length;
            for (n = 0; n < n2; ++n) {
                hashtableOfType.put(this.topLevelTypes[n].sourceName, this.topLevelTypes[n]);
            }
            break;
        }
        n3 = n4 + 1;
        for (n = 0; n < n4; ++n) {
            ImportReference importReference = this.referenceContext.imports[n];
            if ((importReference.bits & 0x20000) == 0 || !CharOperation.equals(TypeConstants.JAVA_LANG, importReference.tokens) || importReference.isStatic()) continue;
            --n3;
            break;
        }
        this.tempImports = new ImportBinding[n3];
        this.tempImports[0] = this.getDefaultImports()[0];
        this.importPtr = 1;
        block3: for (n = 0; n < n4; ++n) {
            ImportReference importReference = this.referenceContext.imports[n];
            object = importReference.tokens;
            for (int i = 0; i < this.importPtr; ++i) {
                ImportBinding importBinding = this.tempImports[i];
                if (importBinding.onDemand != ((importReference.bits & 0x20000) != 0) || importBinding.isStatic() != importReference.isStatic() || !CharOperation.equals(object, importBinding.compoundName)) continue;
                this.problemReporter().unusedImport(importReference);
                continue block3;
            }
            if ((importReference.bits & 0x20000) != 0) {
                if (CharOperation.equals(object, this.currentPackageName)) {
                    this.problemReporter().unusedImport(importReference);
                    continue;
                }
                Binding binding = this.findImport((char[][])object, ((char[][])object).length);
                if (!binding.isValidBinding()) {
                    this.problemReporter().importProblem(importReference, binding);
                    continue;
                }
                if (importReference.isStatic() && binding instanceof PackageBinding) {
                    this.problemReporter().cannotImportPackage(importReference);
                    continue;
                }
                this.recordImportBinding(new ImportBinding((char[][])object, true, binding, importReference));
                continue;
            }
            Binding binding = this.findSingleImport((char[][])object, 13, importReference.isStatic());
            if (!binding.isValidBinding() && binding.problemId() != 3) {
                bl2 = true;
                if (!bl) continue;
                this.problemReporter().importProblem(importReference, binding);
                continue;
            }
            if (binding instanceof PackageBinding) {
                this.problemReporter().cannotImportPackage(importReference);
                continue;
            }
            if (this.checkAndRecordImportBinding(binding, hashtableOfType, importReference, (char[][])object) == -1 || !importReference.isStatic()) continue;
            if (binding.kind() == 1) {
                this.checkMoreStaticBindings((char[][])object, hashtableOfType, 12, importReference);
                continue;
            }
            if (binding.kind() != 8) continue;
            this.checkMoreStaticBindings((char[][])object, hashtableOfType, 4, importReference);
        }
        if (this.tempImports.length > this.importPtr) {
            this.tempImports = new ImportBinding[this.importPtr];
            System.arraycopy(this.tempImports, 0, this.tempImports, 0, this.importPtr);
        }
        this.imports = this.tempImports;
        n = this.imports.length;
        this.typeOrPackageCache = new HashtableOfObject(n);
        for (n2 = 0; n2 < n; ++n2) {
            object = this.imports[n2];
            if ((object.onDemand || !(object.resolvedImport instanceof ReferenceBinding)) && !(object instanceof ImportConflictBinding)) continue;
            this.typeOrPackageCache.put(object.compoundName[object.compoundName.length - 1], object);
        }
        this.skipCachingImports = this.suppressImportErrors && bl2;
    }

    public void faultInTypes() {
        this.faultInImports();
        int n = this.topLevelTypes.length;
        for (int i = 0; i < n; ++i) {
            this.topLevelTypes[i].faultInTypesForFieldsAndMethods();
        }
    }

    public Binding findImport(char[][] cArray, boolean bl, boolean bl2) {
        if (bl2) {
            return this.findImport(cArray, cArray.length);
        }
        return this.findSingleImport(cArray, 13, bl);
    }

    private Binding findImport(char[][] cArray, int n) {
        Binding binding;
        int n2;
        Binding binding2;
        block12: {
            this.recordQualifiedReference(cArray);
            binding2 = this.environment.getTopLevelPackage(cArray[0]);
            n2 = 1;
            if (binding2 != null) {
                binding = binding2;
                while (n2 < n) {
                    if ((binding2 = ((PackageBinding)binding).getTypeOrPackage(cArray[n2++])) == null || !binding2.isValidBinding()) {
                        binding2 = null;
                    } else if (binding2 instanceof PackageBinding) {
                        binding = (PackageBinding)binding2;
                        continue;
                    }
                    break block12;
                }
                return binding;
            }
        }
        if (binding2 == null) {
            if (this.compilerOptions().complianceLevel >= 0x300000L) {
                return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), null, 1);
            }
            binding = this.findType(cArray[0], this.environment.defaultPackage, this.environment.defaultPackage);
            if (binding == null || !binding.isValidBinding()) {
                return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), null, 1);
            }
            n2 = 1;
        } else {
            binding = (ReferenceBinding)binding2;
        }
        while (n2 < n) {
            char[] cArray2;
            if (!((ReferenceBinding)(binding = (ReferenceBinding)this.environment.convertToRawType((TypeBinding)binding, false))).canBeSeenBy(this.fPackage)) {
                return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), (ReferenceBinding)binding, 2);
            }
            if ((binding = ((ReferenceBinding)binding).getMemberType(cArray2 = cArray[n2++])) != null) continue;
            return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), null, 1);
        }
        if (!((ReferenceBinding)binding).canBeSeenBy(this.fPackage)) {
            return new ProblemReferenceBinding(cArray, (ReferenceBinding)binding, 2);
        }
        return binding;
    }

    private Binding findSingleImport(char[][] cArray, int n, boolean bl) {
        if (cArray.length == 1) {
            if (this.compilerOptions().complianceLevel >= 0x300000L) {
                return new ProblemReferenceBinding(cArray, null, 1);
            }
            ReferenceBinding referenceBinding = this.findType(cArray[0], this.environment.defaultPackage, this.fPackage);
            if (referenceBinding == null) {
                return new ProblemReferenceBinding(cArray, null, 1);
            }
            return referenceBinding;
        }
        if (bl) {
            return this.findSingleStaticImport(cArray, n);
        }
        return this.findImport(cArray, cArray.length);
    }

    private Binding findSingleStaticImport(char[][] cArray, int n) {
        MethodBinding methodBinding;
        FieldBinding fieldBinding;
        Binding binding = this.findImport(cArray, cArray.length - 1);
        if (!binding.isValidBinding()) {
            return binding;
        }
        char[] cArray2 = cArray[cArray.length - 1];
        if (binding instanceof PackageBinding) {
            Binding binding2 = ((PackageBinding)binding).getTypeOrPackage(cArray2);
            if (binding2 != null && binding2 instanceof ReferenceBinding) {
                return new ProblemReferenceBinding(cArray, (ReferenceBinding)binding2, 14);
            }
            return binding;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)binding;
        FieldBinding fieldBinding2 = fieldBinding = (n & 1) != 0 ? this.findField(referenceBinding, cArray2, null, true) : null;
        if (fieldBinding != null) {
            if (fieldBinding.problemId() == 3 && ((ProblemFieldBinding)fieldBinding).closestMatch.isStatic()) {
                return fieldBinding;
            }
            if (fieldBinding.isValidBinding() && fieldBinding.isStatic() && fieldBinding.canBeSeenBy(referenceBinding, null, this)) {
                return fieldBinding;
            }
        }
        MethodBinding methodBinding2 = methodBinding = (n & 8) != 0 ? this.findStaticMethod(referenceBinding, cArray2) : null;
        if (methodBinding != null) {
            return methodBinding;
        }
        if ((referenceBinding = this.findMemberType(cArray2, referenceBinding)) == null || !referenceBinding.isStatic()) {
            if (fieldBinding != null && !fieldBinding.isValidBinding() && fieldBinding.problemId() != 1) {
                return fieldBinding;
            }
            return new ProblemReferenceBinding(cArray, referenceBinding, 1);
        }
        if (referenceBinding.isValidBinding() && !referenceBinding.canBeSeenBy(this.fPackage)) {
            return new ProblemReferenceBinding(cArray, referenceBinding, 2);
        }
        if (referenceBinding.problemId() == 2) {
            return new ProblemReferenceBinding(cArray, ((ProblemReferenceBinding)referenceBinding).closestMatch, 2);
        }
        return referenceBinding;
    }

    private MethodBinding findStaticMethod(ReferenceBinding referenceBinding, char[] cArray) {
        if (!referenceBinding.canBeSeenBy(this)) {
            return null;
        }
        do {
            referenceBinding.initializeForStaticImports();
            MethodBinding[] methodBindingArray = referenceBinding.getMethods(cArray);
            if (methodBindingArray == Binding.NO_METHODS) continue;
            int n = methodBindingArray.length;
            while (--n >= 0) {
                MethodBinding methodBinding = methodBindingArray[n];
                if (!methodBinding.isStatic() || !methodBinding.canBeSeenBy(this.fPackage)) continue;
                return methodBinding;
            }
        } while ((referenceBinding = referenceBinding.superclass()) != null);
        return null;
    }

    ImportBinding[] getDefaultImports() {
        if (this.environment.defaultImports != null) {
            return this.environment.defaultImports;
        }
        Binding binding = this.environment.getTopLevelPackage(TypeConstants.JAVA);
        if (binding != null) {
            binding = binding.getTypeOrPackage(TypeConstants.JAVA_LANG[1]);
        }
        if (binding == null || !binding.isValidBinding()) {
            this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_LANG_OBJECT, this.referenceContext, this.environment.missingClassFileLocation);
            MissingTypeBinding missingTypeBinding = this.environment.createMissingType(null, TypeConstants.JAVA_LANG_OBJECT);
            binding = missingTypeBinding.fPackage;
        }
        this.environment.defaultImports = new ImportBinding[]{new ImportBinding(TypeConstants.JAVA_LANG, true, binding, null)};
        return this.environment.defaultImports;
    }

    public final Binding getImport(char[][] cArray, boolean bl, boolean bl2) {
        if (bl) {
            return this.findImport(cArray, cArray.length);
        }
        return this.findSingleImport(cArray, 13, bl2);
    }

    public int nextCaptureID() {
        return this.captureID++;
    }

    @Override
    public ProblemReporter problemReporter() {
        ProblemReporter problemReporter = this.referenceContext.problemReporter;
        problemReporter.referenceContext = this.referenceContext;
        return problemReporter;
    }

    void recordQualifiedReference(char[][] object) {
        if (this.qualifiedReferences == null) {
            return;
        }
        int n = ((char[][])object).length;
        if (n > 1) {
            this.recordRootReference(object[0]);
            while (!this.qualifiedReferences.contains((char[][])object)) {
                this.qualifiedReferences.add((char[][])object);
                if (n == 2) {
                    this.recordSimpleReference(object[0]);
                    this.recordSimpleReference(object[1]);
                    return;
                }
                this.recordSimpleReference(object[--n]);
                char[][] cArray = object;
                char[][] cArrayArray = new char[n][];
                object = cArrayArray;
                System.arraycopy(cArray, 0, cArrayArray, 0, n);
            }
        } else if (n == 1) {
            this.recordRootReference(object[0]);
            this.recordSimpleReference(object[0]);
        }
    }

    void recordReference(char[][] cArray, char[] cArray2) {
        this.recordQualifiedReference(cArray);
        if (cArray.length == 0) {
            this.recordRootReference(cArray2);
        }
        this.recordSimpleReference(cArray2);
    }

    void recordReference(ReferenceBinding referenceBinding, char[] cArray) {
        ReferenceBinding referenceBinding2 = this.typeToRecord(referenceBinding);
        if (referenceBinding2 != null) {
            this.recordReference(referenceBinding2.compoundName, cArray);
        }
    }

    void recordRootReference(char[] cArray) {
        if (this.rootReferences == null) {
            return;
        }
        if (!this.rootReferences.contains(cArray)) {
            this.rootReferences.add(cArray);
        }
    }

    void recordSimpleReference(char[] cArray) {
        if (this.simpleNameReferences == null) {
            return;
        }
        if (!this.simpleNameReferences.contains(cArray)) {
            this.simpleNameReferences.add(cArray);
        }
    }

    void recordSuperTypeReference(TypeBinding typeBinding) {
        if (this.referencedSuperTypes == null) {
            return;
        }
        ReferenceBinding referenceBinding = this.typeToRecord(typeBinding);
        if (referenceBinding != null && !this.referencedSuperTypes.containsIdentical(referenceBinding)) {
            this.referencedSuperTypes.add(referenceBinding);
        }
    }

    public void recordTypeConversion(TypeBinding typeBinding, TypeBinding typeBinding2) {
        this.recordSuperTypeReference(typeBinding2);
    }

    void recordTypeReference(TypeBinding typeBinding) {
        if (this.referencedTypes == null) {
            return;
        }
        ReferenceBinding referenceBinding = this.typeToRecord(typeBinding);
        if (referenceBinding != null && !this.referencedTypes.containsIdentical(referenceBinding)) {
            this.referencedTypes.add(referenceBinding);
        }
    }

    void recordTypeReferences(TypeBinding[] typeBindingArray) {
        if (this.referencedTypes == null) {
            return;
        }
        if (typeBindingArray == null || typeBindingArray.length == 0) {
            return;
        }
        int n = typeBindingArray.length;
        for (int i = 0; i < n; ++i) {
            ReferenceBinding referenceBinding = this.typeToRecord(typeBindingArray[i]);
            if (referenceBinding == null || this.referencedTypes.containsIdentical(referenceBinding)) continue;
            this.referencedTypes.add(referenceBinding);
        }
    }

    Binding resolveSingleImport(ImportBinding importBinding, int n) {
        if (importBinding.resolvedImport == null) {
            importBinding.resolvedImport = this.findSingleImport(importBinding.compoundName, n, importBinding.isStatic());
            if (!importBinding.resolvedImport.isValidBinding() || importBinding.resolvedImport instanceof PackageBinding) {
                if (importBinding.resolvedImport.problemId() == 3) {
                    return importBinding.resolvedImport;
                }
                if (this.imports != null) {
                    ImportBinding[] importBindingArray = new ImportBinding[this.imports.length - 1];
                    int n2 = 0;
                    int n3 = this.imports.length;
                    for (int i = 0; i < n3; ++i) {
                        if (this.imports[i] == importBinding) continue;
                        importBindingArray[n2++] = this.imports[i];
                    }
                    this.imports = importBindingArray;
                }
                return null;
            }
        }
        return importBinding.resolvedImport;
    }

    public void storeDependencyInfo() {
        int n;
        ReferenceBinding referenceBinding;
        int n2;
        for (n2 = 0; n2 < this.referencedSuperTypes.size; ++n2) {
            ReferenceBinding[] referenceBindingArray;
            ReferenceBinding referenceBinding2 = (ReferenceBinding)this.referencedSuperTypes.elementAt(n2);
            if (!this.referencedTypes.containsIdentical(referenceBinding2)) {
                this.referencedTypes.add(referenceBinding2);
            }
            if (!referenceBinding2.isLocalType() && (referenceBinding = referenceBinding2.enclosingType()) != null) {
                this.recordSuperTypeReference(referenceBinding);
            }
            if ((referenceBinding = referenceBinding2.superclass()) != null) {
                this.recordSuperTypeReference(referenceBinding);
            }
            if ((referenceBindingArray = referenceBinding2.superInterfaces()) == null) continue;
            int n3 = referenceBindingArray.length;
            for (n = 0; n < n3; ++n) {
                this.recordSuperTypeReference(referenceBindingArray[n]);
            }
        }
        int n4 = this.referencedTypes.size;
        for (n2 = 0; n2 < n4; ++n2) {
            referenceBinding = (ReferenceBinding)this.referencedTypes.elementAt(n2);
            if (referenceBinding.isLocalType()) continue;
            this.recordQualifiedReference(referenceBinding.isMemberType() ? CharOperation.splitOn('.', referenceBinding.readableName()) : referenceBinding.compoundName);
        }
        n2 = this.qualifiedReferences.size;
        char[][][] cArrayArray = new char[n2][][];
        for (int i = 0; i < n2; ++i) {
            cArrayArray[i] = this.qualifiedReferences.elementAt(i);
        }
        this.referenceContext.compilationResult.qualifiedReferences = cArrayArray;
        n2 = this.simpleNameReferences.size;
        char[][] cArrayArray2 = new char[n2][];
        for (int i = 0; i < n2; ++i) {
            cArrayArray2[i] = this.simpleNameReferences.elementAt(i);
        }
        this.referenceContext.compilationResult.simpleNameReferences = cArrayArray2;
        n2 = this.rootReferences.size;
        char[][] cArrayArray3 = new char[n2][];
        for (n = 0; n < n2; ++n) {
            cArrayArray3[n] = this.rootReferences.elementAt(n);
        }
        this.referenceContext.compilationResult.rootReferences = cArrayArray3;
    }

    public String toString() {
        return "--- CompilationUnit Scope : " + new String(this.referenceContext.getFileName());
    }

    private ReferenceBinding typeToRecord(TypeBinding typeBinding) {
        while (typeBinding.isArrayType()) {
            typeBinding = ((ArrayBinding)typeBinding).leafComponentType();
        }
        switch (typeBinding.kind()) {
            case 132: 
            case 516: 
            case 4100: 
            case 8196: 
            case 32772: 
            case 65540: {
                return null;
            }
            case 260: 
            case 1028: {
                typeBinding = typeBinding.erasure();
            }
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
        if (referenceBinding.isLocalType()) {
            return null;
        }
        return referenceBinding;
    }

    public void verifyMethods(MethodVerifier methodVerifier) {
        int n = this.topLevelTypes.length;
        for (int i = 0; i < n; ++i) {
            this.topLevelTypes[i].verifyMethods(methodVerifier);
        }
    }

    private void recordImportBinding(ImportBinding importBinding) {
        if (this.tempImports.length == this.importPtr) {
            this.tempImports = new ImportBinding[this.importPtr + 1];
            System.arraycopy(this.tempImports, 0, this.tempImports, 0, this.importPtr);
        }
        this.tempImports[this.importPtr++] = importBinding;
    }

    private void checkMoreStaticBindings(char[][] cArray, HashtableOfType hashtableOfType, int n, ImportReference importReference) {
        Binding binding = this.findSingleStaticImport(cArray, n);
        if (!binding.isValidBinding()) {
            if (binding.problemId() == 3) {
                this.checkAndRecordImportBinding(binding, hashtableOfType, importReference, cArray);
            }
        } else {
            this.checkAndRecordImportBinding(binding, hashtableOfType, importReference, cArray);
        }
        if ((n & 8) != 0 && binding.kind() == 8) {
            this.checkMoreStaticBindings(cArray, hashtableOfType, n &= 0xFFFFFFF7, importReference);
        }
    }

    private int checkAndRecordImportBinding(Binding binding, HashtableOfType hashtableOfType, ImportReference importReference, char[][] cArray) {
        ReferenceBinding referenceBinding = null;
        if (binding instanceof MethodBinding && (!(referenceBinding = (ReferenceBinding)this.getType(cArray, cArray.length)).isValidBinding() || importReference.isStatic() && !referenceBinding.isStatic())) {
            referenceBinding = null;
        }
        char[] cArray2 = cArray[cArray.length - 1];
        if (binding instanceof ReferenceBinding || referenceBinding != null) {
            ReferenceBinding referenceBinding2;
            ReferenceBinding referenceBinding3;
            ReferenceBinding referenceBinding4 = referenceBinding == null ? (ReferenceBinding)binding : referenceBinding;
            ReferenceBinding referenceBinding5 = referenceBinding3 = referenceBinding4.problemId() == 3 ? ((ProblemReferenceBinding)referenceBinding4).closestMatch : referenceBinding4;
            if (importReference.isTypeUseDeprecated(referenceBinding3, this)) {
                this.problemReporter().deprecatedType(referenceBinding3, importReference);
            }
            if ((referenceBinding2 = hashtableOfType.get(cArray2)) != null) {
                int n;
                if (TypeBinding.equalsEquals(referenceBinding2, referenceBinding4)) {
                    for (int i = 0; i < this.importPtr; ++i) {
                        ImportBinding importBinding = this.tempImports[i];
                        if (importBinding instanceof ImportConflictBinding) {
                            ImportConflictBinding importConflictBinding = (ImportConflictBinding)importBinding;
                            if (!TypeBinding.equalsEquals(importConflictBinding.conflictingTypeBinding, referenceBinding4) || importReference.isStatic()) continue;
                            this.problemReporter().duplicateImport(importReference);
                            this.recordImportBinding(new ImportBinding(cArray, false, binding, importReference));
                            continue;
                        }
                        if (importBinding.resolvedImport != referenceBinding4 || importReference.isStatic() == importBinding.isStatic()) continue;
                        this.problemReporter().duplicateImport(importReference);
                        this.recordImportBinding(new ImportBinding(cArray, false, binding, importReference));
                    }
                    return -1;
                }
                int n2 = this.topLevelTypes.length;
                for (n = 0; n < n2; ++n) {
                    if (!CharOperation.equals(this.topLevelTypes[n].sourceName, referenceBinding2.sourceName)) continue;
                    this.problemReporter().conflictingImport(importReference);
                    return -1;
                }
                if (importReference.isStatic() && binding instanceof ReferenceBinding && this.compilerOptions().sourceLevel >= 0x340000L) {
                    for (n = 0; n < this.importPtr; ++n) {
                        ImportBinding importBinding = this.tempImports[n];
                        if (!importBinding.isStatic() || !(importBinding.resolvedImport instanceof ReferenceBinding) || binding == importBinding.resolvedImport || !CharOperation.equals(cArray2, importBinding.compoundName[importBinding.compoundName.length - 1])) continue;
                        ReferenceBinding referenceBinding6 = (ReferenceBinding)importBinding.resolvedImport;
                        importBinding.resolvedImport = new ProblemReferenceBinding(new char[][]{cArray2}, referenceBinding6, 3);
                        return -1;
                    }
                }
                this.problemReporter().duplicateImport(importReference);
                return -1;
            }
            hashtableOfType.put(cArray2, referenceBinding4);
        } else if (binding instanceof FieldBinding) {
            for (int i = 0; i < this.importPtr; ++i) {
                ImportBinding importBinding = this.tempImports[i];
                if (!importBinding.isStatic() || !(importBinding.resolvedImport instanceof FieldBinding) || binding == importBinding.resolvedImport || !CharOperation.equals(cArray2, importBinding.compoundName[importBinding.compoundName.length - 1])) continue;
                if (this.compilerOptions().sourceLevel >= 0x340000L) {
                    FieldBinding fieldBinding = (FieldBinding)importBinding.resolvedImport;
                    importBinding.resolvedImport = new ProblemFieldBinding(fieldBinding, fieldBinding.declaringClass, cArray2, 3);
                    return -1;
                }
                this.problemReporter().duplicateImport(importReference);
                return -1;
            }
        }
        if (referenceBinding == null) {
            this.recordImportBinding(new ImportBinding(cArray, false, binding, importReference));
        } else {
            this.recordImportBinding(new ImportConflictBinding(cArray, binding, referenceBinding, importReference));
        }
        return this.importPtr;
    }

    @Override
    public boolean hasDefaultNullnessFor(int n) {
        if (this.fPackage != null) {
            return (this.fPackage.defaultNullness & n) != 0;
        }
        return false;
    }
}

