/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.ui;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.snapshot.Snapshot;
import com.sun.tools.visualvm.core.ui.DataSourceViewPlugin;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataSourceViewPluginProvider<X extends DataSource> {
    private final Map<X, DataSourceViewPlugin> pluginsCache = new HashMap<X, DataSourceViewPlugin>();

    protected abstract boolean supportsPluginFor(X var1);

    protected abstract DataSourceViewPlugin createPlugin(X var1);

    protected boolean supportsSavePluginFor(X dataSource, Class<? extends Snapshot> snapshotClass) {
        return false;
    }

    protected void savePlugin(X dataSource, Snapshot snapshot) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final DataSourceViewPlugin getCachedPlugin(X dataSource) {
        Map<X, DataSourceViewPlugin> map = this.pluginsCache;
        synchronized (map) {
            return this.pluginsCache.get(dataSource);
        }
    }

    void pluginWillBeAdded(DataSourceViewPlugin plugin) {
    }

    void pluginAdded(DataSourceViewPlugin plugin) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pluginRemoved(DataSourceViewPlugin plugin) {
        Map<X, DataSourceViewPlugin> map = this.pluginsCache;
        synchronized (map) {
            this.pluginsCache.remove(plugin.getDataSource());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final DataSourceViewPlugin getPlugin(X dataSource) {
        Map<X, DataSourceViewPlugin> map = this.pluginsCache;
        synchronized (map) {
            DataSourceViewPlugin plugin = this.getCachedPlugin(dataSource);
            if (plugin == null) {
                plugin = this.createPlugin(dataSource);
                if (plugin == null) {
                    throw new NullPointerException("DataSourceViewPluginProvider provides null plugin: " + this);
                }
                plugin.setController(this);
                this.pluginsCache.put(dataSource, plugin);
            }
            return plugin;
        }
    }
}

