/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.threads;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.RowFilter;
import javax.swing.SortOrder;
import javax.swing.border.CompoundBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.results.DataManagerListener;
import org.netbeans.lib.profiler.results.threads.ThreadData;
import org.netbeans.lib.profiler.results.threads.ThreadsDataManager;
import org.netbeans.lib.profiler.ui.Formatters;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.FlatToolBar;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableContainer;
import org.netbeans.lib.profiler.ui.swing.renderer.NumberRenderer;
import org.netbeans.lib.profiler.ui.threads.NameStateRenderer;
import org.netbeans.lib.profiler.ui.threads.ThreadStateIcon;
import org.netbeans.lib.profiler.ui.threads.ThreadTimeRelRenderer;
import org.netbeans.lib.profiler.ui.threads.TimelineHeaderRenderer;
import org.netbeans.lib.profiler.ui.threads.TimelineRenderer;
import org.netbeans.lib.profiler.ui.threads.ViewManager;
import org.netbeans.modules.profiler.api.icons.Icons;

public class ThreadsPanel
extends JPanel {
    private static final String LAYOUT_ENABLED = "ENABLED";
    private static final String LAYOUT_DISABLED = "DISABLED";
    private final ThreadsDataManager dataManager;
    private final ViewManager viewManager;
    private ProfilerToolbar threadsToolbar;
    private ProfilerTable threadsTable;
    private ProfilerTableContainer threadsTableContainer;
    private JComboBox threadStateFilter;
    private JPanel legendPanel;
    private Component fitAct;
    private JPanel contentPanel;
    private JPanel notificationPanel;
    private JButton enableThreadsMonitoringButton;
    private JLabel enableThreadsMonitoringLabel1;
    private JLabel enableThreadsMonitoringLabel2;
    private ThreadTimeRelRenderer timeRelRenderer;
    private long lastTimestamp;

    private static ResourceBundle BUNDLE() {
        return ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.threads.Bundle");
    }

    public ThreadsPanel(ThreadsDataManager threadsDataManager, Action action) {
        this.dataManager = threadsDataManager;
        this.viewManager = new ViewManager(1, threadsDataManager){

            @Override
            public void columnWidthChanged(int n, int n2, int n3) {
                if (n == 1 && this.isFit()) {
                    ThreadsPanel.this.threadsTable.updateColumnPreferredWidth(1);
                }
                super.columnWidthChanged(n, n2, n3);
            }

            @Override
            public void columnOffsetChanged(int n, int n2, int n3) {
                super.columnOffsetChanged(n, n2, n3);
                if (n == 1) {
                    ThreadsPanel.this.repaintTimeline();
                }
            }

            @Override
            public void zoomChanged(double d, double d2) {
                super.zoomChanged(d, d2);
                ThreadsPanel.this.repaintTimeline();
            }
        };
        this.initUI(action);
    }

    private void initUI(Action action) {
        this.setOpaque(true);
        this.setBackground(new HTMLTextArea().getBackground());
        final AbstractTableModel abstractTableModel = new AbstractTableModel(){

            @Override
            public String getColumnName(int n) {
                if (n == 0) {
                    return ThreadsPanel.BUNDLE().getString("COL_Name");
                }
                if (n == 1) {
                    return ThreadsPanel.BUNDLE().getString("COL_Timeline");
                }
                if (n == 2) {
                    return CommonConstants.THREAD_STATUS_RUNNING_STRING;
                }
                if (n == 3) {
                    return CommonConstants.THREAD_STATUS_SLEEPING_STRING;
                }
                if (n == 4) {
                    return CommonConstants.THREAD_STATUS_WAIT_STRING;
                }
                if (n == 5) {
                    return CommonConstants.THREAD_STATUS_PARK_STRING;
                }
                if (n == 6) {
                    return CommonConstants.THREAD_STATUS_MONITOR_STRING;
                }
                if (n == 7) {
                    return ThreadsPanel.BUNDLE().getString("COL_Total");
                }
                return null;
            }

            @Override
            public Class<?> getColumnClass(int n) {
                if (n == 0) {
                    return ThreadData.class;
                }
                if (n == 1) {
                    return ViewManager.RowView.class;
                }
                return Long.class;
            }

            @Override
            public int getRowCount() {
                return ThreadsPanel.this.dataManager.getThreadsCount();
            }

            @Override
            public int getColumnCount() {
                return 8;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                if (n2 == 0) {
                    return this.getData(n);
                }
                if (n2 == 1) {
                    return ThreadsPanel.this.viewManager.getRowView(n);
                }
                if (n2 == 2) {
                    return this.getData(n).getRunningTime(ThreadsPanel.this.lastTimestamp);
                }
                if (n2 == 3) {
                    return this.getData(n).getSleepingTime(ThreadsPanel.this.lastTimestamp);
                }
                if (n2 == 4) {
                    return this.getData(n).getWaitTime(ThreadsPanel.this.lastTimestamp);
                }
                if (n2 == 5) {
                    return this.getData(n).getParkTime(ThreadsPanel.this.lastTimestamp);
                }
                if (n2 == 6) {
                    return this.getData(n).getMonitorTime(ThreadsPanel.this.lastTimestamp);
                }
                if (n2 == 7) {
                    return this.getData(n).getTotalTime(ThreadsPanel.this.lastTimestamp);
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            private ThreadData getData(int n) {
                return ThreadsPanel.this.dataManager.getThreadData(n);
            }
        };
        this.threadsTable = new ProfilerTable(abstractTableModel, true, true, new int[]{1}){

            @Override
            protected int computeColumnPreferredWidth(int n, int n2, int n3, int n4) {
                if (n != 1) {
                    return super.computeColumnPreferredWidth(n, n2, n3, n4);
                }
                ThreadsPanel.this.viewManager.update();
                if (ThreadsPanel.this.viewManager.isFit()) {
                    return this.getTableHeader().getHeaderRect((int)n2).width;
                }
                return ThreadsPanel.this.viewManager.getViewWidth();
            }
        };
        this.threadsTable.setColumnToolTips(new String[]{ThreadsPanel.BUNDLE().getString("DESC_Name"), ThreadsPanel.BUNDLE().getString("DESC_Timeline"), ThreadsPanel.BUNDLE().getString("DESC_Running"), ThreadsPanel.BUNDLE().getString("DESC_Sleeping"), ThreadsPanel.BUNDLE().getString("DESC_Wait"), ThreadsPanel.BUNDLE().getString("DESC_Park"), ThreadsPanel.BUNDLE().getString("DESC_Monitor"), ThreadsPanel.BUNDLE().getString("DESC_Total")});
        this.threadsTable.setDefaultSortOrder(1, SortOrder.ASCENDING);
        this.threadsTable.setSortColumn(1);
        this.threadsTable.setFitWidthColumn(1);
        NameStateRenderer nameStateRenderer = new NameStateRenderer();
        nameStateRenderer.setText("THREADnameTOsetupCOLUMNwidth");
        this.threadsTable.setDefaultColumnWidth(0, nameStateRenderer.getPreferredSize().width);
        this.threadsTable.setDefaultRenderer(ThreadData.class, nameStateRenderer);
        this.threadsTable.setDefaultRenderer(ViewManager.RowView.class, new TimelineRenderer(this.viewManager));
        JTableHeader jTableHeader = this.threadsTable.getTableHeader();
        TableCellRenderer tableCellRenderer = jTableHeader.getDefaultRenderer();
        jTableHeader.setDefaultRenderer(new TimelineHeaderRenderer(tableCellRenderer, 1, this.viewManager));
        Long l = new Long(123456789L);
        this.timeRelRenderer = new ThreadTimeRelRenderer(this.dataManager);
        this.timeRelRenderer.setValue(l, -1);
        this.threadsTable.setDefaultColumnWidth(this.timeRelRenderer.getPreferredSize().width);
        this.threadsTable.setDefaultRenderer(Long.class, this.timeRelRenderer);
        NumberRenderer numberRenderer = new NumberRenderer(Formatters.millisecondsFormat());
        numberRenderer.setValue(l, -1);
        this.threadsTable.setDefaultColumnWidth(7, numberRenderer.getPreferredSize().width);
        this.threadsTable.setColumnRenderer(7, numberRenderer);
        this.threadsTable.setColumnVisibility(3, false);
        this.threadsTable.setColumnVisibility(4, false);
        this.threadsTable.setColumnVisibility(5, false);
        this.threadsTable.setColumnVisibility(6, false);
        this.threadsTableContainer = new ProfilerTableContainer(this.threadsTable, false, this.viewManager);
        this.legendPanel = new JPanel(new FlowLayout(4, 7, 8));
        this.legendPanel.setOpaque(false);
        ThreadStateIcon threadStateIcon = new ThreadStateIcon(1, 18, 9);
        JLabel jLabel = new JLabel(CommonConstants.THREAD_STATUS_RUNNING_STRING, threadStateIcon, 10);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.legendPanel.add(jLabel);
        ThreadStateIcon threadStateIcon2 = new ThreadStateIcon(2, 18, 9);
        JLabel jLabel2 = new JLabel(CommonConstants.THREAD_STATUS_SLEEPING_STRING, threadStateIcon2, 10);
        jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.legendPanel.add(jLabel2);
        ThreadStateIcon threadStateIcon3 = new ThreadStateIcon(4, 18, 9);
        JLabel jLabel3 = new JLabel(CommonConstants.THREAD_STATUS_WAIT_STRING, threadStateIcon3, 10);
        jLabel3.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.legendPanel.add(jLabel3);
        ThreadStateIcon threadStateIcon4 = new ThreadStateIcon(5, 18, 9);
        JLabel jLabel4 = new JLabel(CommonConstants.THREAD_STATUS_PARK_STRING, threadStateIcon4, 10);
        jLabel4.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.legendPanel.add(jLabel4);
        ThreadStateIcon threadStateIcon5 = new ThreadStateIcon(3, 18, 9);
        JLabel jLabel5 = new JLabel(CommonConstants.THREAD_STATUS_MONITOR_STRING, threadStateIcon5, 10);
        jLabel5.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.legendPanel.add(jLabel5);
        this.threadsToolbar = ProfilerToolbar.create(true);
        if (action != null) {
            this.threadsToolbar.add(action);
            this.threadsToolbar.addSeparator();
        }
        final Action action2 = this.viewManager.zoomInAction();
        this.threadsToolbar.add(new JButton(action2){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                super.fireActionPerformed(actionEvent);
                Object object = action2.getValue("newOffset");
                if (object != null) {
                    int n = (Integer)object;
                    ThreadsPanel.this.threadsTable.setColumnOffset(1, n);
                }
                abstractTableModel.fireTableDataChanged();
            }

            @Override
            public boolean isEnabled() {
                return ThreadsPanel.this.threadsTable.isShowing() && super.isEnabled();
            }
        });
        final Action action3 = this.viewManager.zoomOutAction();
        this.threadsToolbar.add(new JButton(action3){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                super.fireActionPerformed(actionEvent);
                Object object = action3.getValue("newOffset");
                if (object != null) {
                    int n = (Integer)object;
                    ThreadsPanel.this.threadsTable.setColumnOffset(1, n);
                }
                abstractTableModel.fireTableDataChanged();
            }

            @Override
            public boolean isEnabled() {
                return ThreadsPanel.this.threadsTable.isShowing() && super.isEnabled();
            }
        });
        this.fitAct = this.threadsToolbar.add(new JToggleButton(this.viewManager.fitAction()){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                super.fireActionPerformed(actionEvent);
                abstractTableModel.fireTableDataChanged();
            }
        });
        this.fitAct.setEnabled(false);
        this.threadsToolbar.addSeparator();
        this.threadsToolbar.addSpace(3);
        this.threadsToolbar.add(new JLabel(ThreadsPanel.BUNDLE().getString("LBL_View")){

            @Override
            public boolean isEnabled() {
                return ThreadsPanel.this.threadsTable.isShowing() && super.isEnabled();
            }
        });
        this.threadsToolbar.addSpace(5);
        this.threadStateFilter = new JComboBox(new String[]{ThreadsPanel.BUNDLE().getString("OPT_AllThreads"), ThreadsPanel.BUNDLE().getString("OPT_LiveThreads"), ThreadsPanel.BUNDLE().getString("OPT_FinishedThreads")}){

            @Override
            public Dimension getMaximumSize() {
                return super.getPreferredSize();
            }

            @Override
            protected void fireActionEvent() {
                super.fireActionEvent();
                ThreadsPanel.this.updateFilter();
            }

            @Override
            public boolean isEnabled() {
                return ThreadsPanel.this.threadsTable.isShowing() && super.isEnabled();
            }
        };
        this.threadsToolbar.add(this.threadStateFilter);
        this.contentPanel = new JPanel(new BorderLayout());
        this.contentPanel.setOpaque(true);
        this.contentPanel.setBackground(this.getBackground());
        this.contentPanel.add((Component)this.threadsTableContainer, "Center");
        this.contentPanel.add((Component)this.legendPanel, "South");
        CompoundBorder compoundBorder = new CompoundBorder(new FlatToolBar.FlatRolloverButtonBorder(Color.GRAY, Color.LIGHT_GRAY), new FlatToolBar.FlatMarginBorder());
        this.enableThreadsMonitoringLabel1 = new JLabel(ThreadsPanel.BUNDLE().getString("MSG_ThreadsDisabled"));
        this.enableThreadsMonitoringLabel1.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 3));
        this.enableThreadsMonitoringLabel1.setForeground(Color.DARK_GRAY);
        this.enableThreadsMonitoringButton = new JButton(Icons.getIcon((String)"ProfilerIcons.ViewThreads32"));
        this.enableThreadsMonitoringButton.setToolTipText(ThreadsPanel.BUNDLE().getString("DESC_ThreadsDisabled"));
        this.enableThreadsMonitoringButton.setContentAreaFilled(false);
        this.enableThreadsMonitoringButton.setMargin(new Insets(3, 3, 3, 3));
        this.enableThreadsMonitoringButton.setVerticalTextPosition(3);
        this.enableThreadsMonitoringButton.setHorizontalTextPosition(0);
        this.enableThreadsMonitoringButton.setRolloverEnabled(true);
        this.enableThreadsMonitoringButton.setBorder(compoundBorder);
        this.enableThreadsMonitoringButton.getAccessibleContext().setAccessibleName(ThreadsPanel.BUNDLE().getString("DESC_ThreadsDisabled"));
        this.enableThreadsMonitoringLabel2 = new JLabel(ThreadsPanel.BUNDLE().getString("MSG_NoProfiling"));
        this.enableThreadsMonitoringLabel2.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 0));
        this.enableThreadsMonitoringLabel2.setForeground(Color.DARK_GRAY);
        this.enableThreadsMonitoringLabel2.setVisible(false);
        this.notificationPanel = new JPanel(new FlowLayout(3, 0, 15));
        this.notificationPanel.setBackground(this.threadsTable.getBackground());
        UIUtils.decorateProfilerPanel(this.notificationPanel);
        this.notificationPanel.add(this.enableThreadsMonitoringLabel1);
        this.notificationPanel.add(this.enableThreadsMonitoringButton);
        this.notificationPanel.add(this.enableThreadsMonitoringLabel2);
        this.setLayout(new CardLayout());
        this.add((Component)this.notificationPanel, LAYOUT_DISABLED);
        this.add((Component)this.contentPanel, LAYOUT_ENABLED);
        this.dataManager.addDataListener(new DataManagerListener(){
            private boolean firstChange = true;

            public void dataChanged() {
                ThreadsPanel.this.lastTimestamp = ThreadsPanel.this.dataManager.getEndTime();
                if (this.firstChange) {
                    this.firstChange = false;
                    ThreadsPanel.this.repaintTimeline();
                }
                abstractTableModel.fireTableDataChanged();
            }

            public void dataReset() {
                ThreadsPanel.this.viewManager.reset();
                this.firstChange = true;
                ThreadsPanel.this.timeRelRenderer.setBasis(0L);
                abstractTableModel.fireTableDataChanged();
            }
        });
        this.updateFilter();
    }

    private void repaintTimeline() {
        JTableHeader jTableHeader = this.threadsTable.getTableHeader();
        TableColumn tableColumn = jTableHeader.getDraggedColumn();
        if (tableColumn != null && tableColumn.getModelIndex() == 1) {
            jTableHeader.repaint();
        } else {
            int n = this.threadsTable.convertColumnIndexToView(1);
            jTableHeader.repaint(jTableHeader.getHeaderRect(n));
        }
    }

    private void updateFilter() {
        RowFilter rowFilter = null;
        switch (this.threadStateFilter.getSelectedIndex()) {
            case 1: {
                rowFilter = new RowFilter(){

                    public boolean include(RowFilter.Entry entry) {
                        ThreadData threadData = (ThreadData)entry.getValue(0);
                        return ThreadData.isAliveState((int)threadData.getLastState());
                    }
                };
                break;
            }
            case 2: {
                rowFilter = new RowFilter(){

                    public boolean include(RowFilter.Entry entry) {
                        ThreadData threadData = (ThreadData)entry.getValue(0);
                        return !ThreadData.isAliveState((int)threadData.getLastState());
                    }
                };
            }
        }
        TableRowSorter tableRowSorter = (TableRowSorter)this.threadsTable.getRowSorter();
        tableRowSorter.setRowFilter(rowFilter);
    }

    public Component getToolbar() {
        return this.threadsToolbar.getComponent();
    }

    public BufferedImage getCurrentViewScreenshot(boolean bl) {
        return this.threadsTableContainer.createTableScreenshot(bl);
    }

    public boolean fitsVisibleArea() {
        return !this.threadsTableContainer.tableNeedsScrolling();
    }

    public boolean hasView() {
        return this.threadsTableContainer.isShowing();
    }

    public void threadsMonitoringDisabled() {
        ((CardLayout)this.getLayout()).show(this, LAYOUT_DISABLED);
        this.fitAct.setEnabled(false);
        this.threadsToolbar.getComponent().repaint();
    }

    public void threadsMonitoringEnabled() {
        ((CardLayout)this.getLayout()).show(this, LAYOUT_ENABLED);
        this.fitAct.setEnabled(true);
        this.threadsToolbar.getComponent().repaint();
    }

    public void profilingSessionStarted() {
        this.enableThreadsMonitoringButton.setEnabled(true);
        this.enableThreadsMonitoringButton.setVisible(true);
        this.enableThreadsMonitoringLabel1.setVisible(true);
        this.enableThreadsMonitoringLabel2.setVisible(false);
    }

    public void profilingSessionFinished() {
        this.enableThreadsMonitoringButton.setEnabled(false);
        this.enableThreadsMonitoringButton.setVisible(false);
        this.enableThreadsMonitoringLabel1.setVisible(false);
        this.enableThreadsMonitoringLabel2.setVisible(true);
    }

    public void addThreadsMonitoringActionListener(ActionListener actionListener) {
        this.enableThreadsMonitoringButton.addActionListener(actionListener);
    }
}

