/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.impldeps;

import java.io.Closeable;
import java.io.File;
import java.util.Collection;
import org.gradle.api.internal.impldeps.GradleImplDepsJarType;
import org.gradle.api.internal.impldeps.GradleImplDepsRelocatedJarCreator;
import org.gradle.api.internal.impldeps.RelocatedJarCreator;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.filelock.LockOptions;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.logging.ProgressLoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GradleImplDepsProvider
implements Closeable {
    public static final String CACHE_KEY = "generated-gradle-jars";
    public static final String CACHE_DISPLAY_NAME = "Generated Gradle JARs cache";
    private static final Logger LOGGER = LoggerFactory.getLogger(GradleImplDepsProvider.class);
    private final String gradleVersion;
    private PersistentCache cache;
    private RelocatedJarCreator relocatedJarCreator;

    public GradleImplDepsProvider(CacheRepository cacheRepository, ProgressLoggerFactory progressLoggerFactory, String gradleVersion) {
        this.relocatedJarCreator = new GradleImplDepsRelocatedJarCreator(progressLoggerFactory);
        this.gradleVersion = gradleVersion;
        this.cache = cacheRepository.cache(CACHE_KEY).withDisplayName(CACHE_DISPLAY_NAME).withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.None)).open();
    }

    public File getFile(final Collection<File> classpath, GradleImplDepsJarType gradleImplDepsJarType) {
        if (gradleImplDepsJarType != null) {
            final File implDepsJarFile = this.jarFile(this.cache, gradleImplDepsJarType.getIdentifier());
            if (!implDepsJarFile.exists()) {
                this.cache.useCache(String.format("Generating %s", implDepsJarFile.getName()), new Runnable(){

                    public void run() {
                        if (!implDepsJarFile.exists()) {
                            GradleImplDepsProvider.this.relocatedJarCreator.create(implDepsJarFile, classpath);
                        }
                    }
                });
            }
            LOGGER.debug("Using Gradle impl deps JAR file: {}", (Object)implDepsJarFile);
            return implDepsJarFile;
        }
        return null;
    }

    @Override
    public void close() {
        this.cache.close();
    }

    private File jarFile(PersistentCache cache, String name) {
        return new File(cache.getBaseDir(), String.format("gradle-%s-%s.jar", name, this.gradleVersion));
    }
}

