/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transfer;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.artifacts.ivyservice.CacheLockingManager;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.DefaultExternalResourceCachePolicy;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.ExternalResourceCachePolicy;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.resources.ResourceException;
import org.gradle.internal.Factory;
import org.gradle.internal.hash.HashUtil;
import org.gradle.internal.hash.HashValue;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.ResourceExceptions;
import org.gradle.internal.resource.cached.CachedExternalResource;
import org.gradle.internal.resource.cached.CachedExternalResourceIndex;
import org.gradle.internal.resource.local.DefaultLocallyAvailableExternalResource;
import org.gradle.internal.resource.local.DefaultLocallyAvailableResource;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.local.LocallyAvailableResourceCandidates;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.metadata.ExternalResourceMetaDataCompare;
import org.gradle.internal.resource.transfer.CacheAwareExternalResourceAccessor;
import org.gradle.internal.resource.transport.ExternalResourceRepository;
import org.gradle.util.BuildCommencedTimeProvider;
import org.gradle.util.GFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCacheAwareExternalResourceAccessor
implements CacheAwareExternalResourceAccessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCacheAwareExternalResourceAccessor.class);
    private final ExternalResourceRepository delegate;
    private final CachedExternalResourceIndex<String> cachedExternalResourceIndex;
    private final BuildCommencedTimeProvider timeProvider;
    private final TemporaryFileProvider temporaryFileProvider;
    private final CacheLockingManager cacheLockingManager;
    private final ExternalResourceCachePolicy externalResourceCachePolicy = new DefaultExternalResourceCachePolicy();

    public DefaultCacheAwareExternalResourceAccessor(ExternalResourceRepository delegate, CachedExternalResourceIndex<String> cachedExternalResourceIndex, BuildCommencedTimeProvider timeProvider, TemporaryFileProvider temporaryFileProvider, CacheLockingManager cacheLockingManager) {
        this.delegate = delegate;
        this.cachedExternalResourceIndex = cachedExternalResourceIndex;
        this.timeProvider = timeProvider;
        this.temporaryFileProvider = temporaryFileProvider;
        this.cacheLockingManager = cacheLockingManager;
    }

    @Override
    public LocallyAvailableExternalResource getResource(URI location, CacheAwareExternalResourceAccessor.ResourceFileStore fileStore, @Nullable LocallyAvailableResourceCandidates localCandidates) throws IOException {
        boolean hasLocalCandidates;
        boolean isUnchanged;
        LOGGER.debug("Constructing external resource: {}", (Object)location);
        CachedExternalResource cached = this.cachedExternalResourceIndex.lookup(location.toString());
        if (cached == null && (localCandidates == null || localCandidates.isNone())) {
            return this.copyToCache(location, fileStore, this.delegate.withProgressLogging().getResource(location));
        }
        if (cached != null && !this.externalResourceCachePolicy.mustRefreshExternalResource(this.getAgeMillis(this.timeProvider, cached))) {
            return new DefaultLocallyAvailableExternalResource(location, (LocallyAvailableResource)new DefaultLocallyAvailableResource(cached.getCachedFile()), cached.getExternalResourceMetaData());
        }
        final ExternalResourceMetaData remoteMetaData = this.delegate.getResourceMetaData(location);
        if (remoteMetaData == null) {
            return null;
        }
        if (cached != null && (isUnchanged = ExternalResourceMetaDataCompare.isDefinitelyUnchanged((ExternalResourceMetaData)cached.getExternalResourceMetaData(), (Factory)new Factory<ExternalResourceMetaData>(){

            public ExternalResourceMetaData create() {
                return remoteMetaData;
            }
        }))) {
            LOGGER.info("Cached resource {} is up-to-date (lastModified: {}).", (Object)location, (Object)cached.getExternalLastModified());
            return new DefaultLocallyAvailableExternalResource(location, (LocallyAvailableResource)new DefaultLocallyAvailableResource(cached.getCachedFile()), cached.getExternalResourceMetaData());
        }
        boolean bl = hasLocalCandidates = localCandidates != null && !localCandidates.isNone();
        if (hasLocalCandidates) {
            LocallyAvailableResource local;
            HashValue remoteChecksum = remoteMetaData.getSha1();
            if (remoteChecksum == null) {
                remoteChecksum = this.getResourceSha1(location);
            }
            if (remoteChecksum != null && (local = localCandidates.findByHashValue(remoteChecksum)) != null) {
                LOGGER.info("Found locally available resource with matching checksum: [{}, {}]", (Object)location, (Object)local.getFile());
                LocallyAvailableExternalResource resource = this.copyCandidateToCache(location, fileStore, remoteMetaData, remoteChecksum, local);
                if (resource != null) {
                    return resource;
                }
            }
        }
        return this.copyToCache(location, fileStore, this.delegate.withProgressLogging().getResource(location));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashValue getResourceSha1(URI location) {
        HashValue hashValue;
        URI sha1Location = new URI(location.toASCIIString() + ".sha1");
        ExternalResource resource = this.delegate.getResource(sha1Location);
        if (resource == null) {
            return null;
        }
        try {
            hashValue = (HashValue)resource.withContent((Transformer)new Transformer<HashValue, InputStream>(){

                public HashValue transform(InputStream inputStream) {
                    try {
                        String sha = IOUtils.toString((InputStream)inputStream, (String)"us-ascii");
                        return HashValue.parse((String)sha);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException((Throwable)e);
                    }
                }
            });
        }
        catch (Throwable throwable) {
            try {
                resource.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new ResourceException(location, String.format("Failed to download SHA1 for resource '%s'.", location), (Throwable)e);
            }
        }
        resource.close();
        return hashValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocallyAvailableExternalResource copyCandidateToCache(URI source, CacheAwareExternalResourceAccessor.ResourceFileStore fileStore, ExternalResourceMetaData remoteMetaData, HashValue remoteChecksum, LocallyAvailableResource local) throws IOException {
        File destination = this.temporaryFileProvider.createTemporaryFile("gradle_download", "bin", new String[0]);
        try {
            Files.copy((File)local.getFile(), (File)destination);
            HashValue localChecksum = HashUtil.createHash((File)destination, (String)"SHA1");
            if (!localChecksum.equals((Object)remoteChecksum)) {
                LocallyAvailableExternalResource locallyAvailableExternalResource = null;
                return locallyAvailableExternalResource;
            }
            LocallyAvailableExternalResource locallyAvailableExternalResource = this.moveIntoCache(source, destination, fileStore, remoteMetaData);
            return locallyAvailableExternalResource;
        }
        finally {
            destination.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocallyAvailableExternalResource copyToCache(URI source, CacheAwareExternalResourceAccessor.ResourceFileStore fileStore, ExternalResource resource) {
        if (resource == null) {
            return null;
        }
        File destination = this.temporaryFileProvider.createTemporaryFile("gradle_download", "bin", new String[0]);
        try {
            DownloadToFileAction downloadAction = new DownloadToFileAction(destination);
            try {
                try {
                    LOGGER.debug("Downloading {} to {}", (Object)source, (Object)destination);
                    if (destination.getParentFile() != null) {
                        GFileUtils.mkdirs((File)destination.getParentFile());
                    }
                    resource.withContent((ExternalResource.ContentAction)downloadAction);
                }
                finally {
                    resource.close();
                }
            }
            catch (Exception e) {
                throw ResourceExceptions.getFailed((URI)source, (Throwable)e);
            }
            LocallyAvailableExternalResource locallyAvailableExternalResource = this.moveIntoCache(source, destination, fileStore, downloadAction.metaData);
            return locallyAvailableExternalResource;
        }
        finally {
            destination.delete();
        }
    }

    private LocallyAvailableExternalResource moveIntoCache(final URI source, final File destination, final CacheAwareExternalResourceAccessor.ResourceFileStore fileStore, final ExternalResourceMetaData metaData) {
        return (LocallyAvailableExternalResource)this.cacheLockingManager.useCache(String.format("Store %s", source), (Factory)new Factory<LocallyAvailableExternalResource>(){

            public LocallyAvailableExternalResource create() {
                LocallyAvailableResource cachedResource = fileStore.moveIntoCache(destination);
                File fileInFileStore = cachedResource.getFile();
                DefaultCacheAwareExternalResourceAccessor.this.cachedExternalResourceIndex.store(source.toString(), fileInFileStore, metaData);
                return new DefaultLocallyAvailableExternalResource(source, cachedResource, metaData);
            }
        });
    }

    public long getAgeMillis(BuildCommencedTimeProvider timeProvider, CachedExternalResource cached) {
        return timeProvider.getCurrentTime() - cached.getCachedAt();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DownloadToFileAction
    implements ExternalResource.ContentAction<Object> {
        private final File destination;
        private ExternalResourceMetaData metaData;

        public DownloadToFileAction(File destination) {
            this.destination = destination;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object execute(InputStream inputStream, ExternalResourceMetaData metaData) throws IOException {
            this.metaData = metaData;
            FileOutputStream outputStream = new FileOutputStream(this.destination);
            try {
                IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
            }
            finally {
                outputStream.close();
            }
            return null;
        }
    }
}

