/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal.inet;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.gradle.messaging.remote.internal.inet.InetEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiChoiceAddress
implements InetEndpoint {
    private final UUID canonicalAddress;
    private final int port;
    private final List<InetAddress> candidates;

    public MultiChoiceAddress(UUID canonicalAddress, int port, List<InetAddress> candidates) {
        this.canonicalAddress = canonicalAddress;
        this.port = port;
        this.candidates = new ArrayList<InetAddress>(candidates);
    }

    @Override
    public String getDisplayName() {
        return String.format("[%s port:%s, addresses:%s]", this.canonicalAddress, this.port, this.candidates);
    }

    public UUID getCanonicalAddress() {
        return this.canonicalAddress;
    }

    @Override
    public List<InetAddress> getCandidates() {
        return this.candidates;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiChoiceAddress other = (MultiChoiceAddress)o;
        return other.canonicalAddress.equals(this.canonicalAddress) && this.port == other.port && this.candidates.equals(other.candidates);
    }

    public int hashCode() {
        return this.canonicalAddress.hashCode();
    }

    public MultiChoiceAddress addAddresses(Iterable<InetAddress> candidates) {
        return new MultiChoiceAddress(this.canonicalAddress, this.port, Lists.newArrayList((Iterable)Iterables.concat(candidates, this.candidates)));
    }
}

