/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import java.util.EnumSet;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.rules.AbstractFileSnapshotTaskStateChanges;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.TaskExecution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputFilesTaskStateChanges
extends AbstractFileSnapshotTaskStateChanges {
    private final TaskExecution previousExecution;
    private final TaskExecution currentExecution;
    private final TaskInternal task;
    private final FileCollectionSnapshotter outputFilesSnapshotter;
    private final FileCollectionSnapshot outputFilesBefore;

    public OutputFilesTaskStateChanges(TaskExecution previousExecution, TaskExecution currentExecution, TaskInternal task, FileCollectionSnapshotter outputFilesSnapshotter) {
        super(task.getName());
        this.previousExecution = previousExecution;
        this.currentExecution = currentExecution;
        this.task = task;
        this.outputFilesSnapshotter = outputFilesSnapshotter;
        this.outputFilesBefore = this.createSnapshot(outputFilesSnapshotter, task.getOutputs().getFiles());
    }

    @Override
    protected String getInputFileType() {
        return "Output";
    }

    @Override
    public FileCollectionSnapshot getPrevious() {
        return this.previousExecution.getOutputFilesSnapshot();
    }

    @Override
    public FileCollectionSnapshot getCurrent() {
        return this.outputFilesBefore;
    }

    @Override
    protected FileCollectionSnapshot.ChangeIterator<String> getChanges() {
        return this.getCurrent().iterateContentChangesSince(this.getPrevious(), EnumSet.of(FileCollectionSnapshot.ChangeFilter.IgnoreAddedFiles));
    }

    @Override
    public void saveCurrent() {
        FileCollectionSnapshot lastExecutionOutputFiles = this.previousExecution == null || this.previousExecution.getOutputFilesSnapshot() == null ? this.outputFilesSnapshotter.emptySnapshot() : this.previousExecution.getOutputFilesSnapshot();
        FileCollectionSnapshot newOutputFiles = lastExecutionOutputFiles.updateFrom(this.outputFilesBefore);
        FileCollectionSnapshot outputFilesAfter = this.createSnapshot(this.outputFilesSnapshotter, this.task.getOutputs().getFiles());
        this.currentExecution.setOutputFilesSnapshot(outputFilesAfter.applyAllChangesSince(this.outputFilesBefore, newOutputFiles));
    }

    @Override
    protected boolean isAllowSnapshotReuse() {
        return false;
    }
}

