/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.DefaultFileSnapshotterSerializer;
import org.gradle.api.internal.changedetection.state.DirSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotImpl;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.FileHashSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshotter;
import org.gradle.api.internal.changedetection.state.IncrementalFileSnapshot;
import org.gradle.api.internal.changedetection.state.MissingFileSnapshot;
import org.gradle.api.internal.changedetection.state.TaskArtifactStateCacheAccess;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SerializerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractFileCollectionSnapshotter
implements FileCollectionSnapshotter {
    protected final FileSnapshotter snapshotter;
    protected final StringInterner stringInterner;
    protected final FileResolver fileResolver;
    protected TaskArtifactStateCacheAccess cacheAccess;

    public AbstractFileCollectionSnapshotter(FileSnapshotter snapshotter, TaskArtifactStateCacheAccess cacheAccess, StringInterner stringInterner, FileResolver fileResolver) {
        this.snapshotter = snapshotter;
        this.cacheAccess = cacheAccess;
        this.stringInterner = stringInterner;
        this.fileResolver = fileResolver;
    }

    @Override
    public void registerSerializers(SerializerRegistry registry) {
        registry.register(FileCollectionSnapshotImpl.class, (Serializer)new DefaultFileSnapshotterSerializer(this.stringInterner));
    }

    @Override
    public FileCollectionSnapshot emptySnapshot() {
        return new FileCollectionSnapshotImpl(Collections.<String, IncrementalFileSnapshot>emptyMap());
    }

    @Override
    public FileCollectionSnapshot snapshot(FileCollection input, boolean allowReuse) {
        final LinkedList fileTreeElements = Lists.newLinkedList();
        final ArrayList missingFiles = Lists.newArrayList();
        this.visitFiles(input, fileTreeElements, missingFiles, allowReuse);
        if (fileTreeElements.isEmpty() && missingFiles.isEmpty()) {
            return this.emptySnapshot();
        }
        final HashMap<String, IncrementalFileSnapshot> snapshots = new HashMap<String, IncrementalFileSnapshot>();
        this.cacheAccess.useCache("Create file snapshot", new Runnable(){

            public void run() {
                String absolutePath;
                for (FileTreeElement fileDetails : fileTreeElements) {
                    absolutePath = AbstractFileCollectionSnapshotter.this.getInternedAbsolutePath(fileDetails.getFile());
                    if (snapshots.containsKey(absolutePath)) continue;
                    if (fileDetails.isDirectory()) {
                        snapshots.put(absolutePath, DirSnapshot.getInstance());
                        continue;
                    }
                    snapshots.put(absolutePath, new FileHashSnapshot(AbstractFileCollectionSnapshotter.this.snapshotter.snapshot(fileDetails).getHash(), fileDetails.getLastModified()));
                }
                for (File missingFile : missingFiles) {
                    absolutePath = AbstractFileCollectionSnapshotter.this.getInternedAbsolutePath(missingFile);
                    if (snapshots.containsKey(absolutePath)) continue;
                    snapshots.put(absolutePath, MissingFileSnapshot.getInstance());
                }
            }
        });
        return new FileCollectionSnapshotImpl(snapshots);
    }

    private String getInternedAbsolutePath(File file) {
        return this.stringInterner.intern(file.getAbsolutePath());
    }

    protected abstract void visitFiles(FileCollection var1, List<FileTreeElement> var2, List<File> var3, boolean var4);
}

