/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.FileSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshotter;
import org.gradle.api.internal.hash.Hasher;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentStore;
import org.gradle.internal.hash.HashUtil;
import org.gradle.internal.hash.HashValue;
import org.gradle.internal.resource.TextResource;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HashValueSerializer;
import org.gradle.internal.serialize.Serializer;

public class CachingFileSnapshotter
implements FileSnapshotter {
    private final PersistentIndexedCache<String, FileInfo> cache;
    private final Hasher hasher;
    private final StringInterner stringInterner;

    public CachingFileSnapshotter(Hasher hasher, PersistentStore store, StringInterner stringInterner) {
        this.hasher = hasher;
        this.cache = store.createCache("fileHashes", String.class, new FileInfoSerializer());
        this.stringInterner = stringInterner;
    }

    public FileSnapshot snapshot(TextResource resource) {
        File file = resource.getFile();
        if (file != null) {
            return this.snapshot(file);
        }
        final HashValue md5 = HashUtil.createHash((String)resource.getText(), (String)"md5");
        return new FileSnapshot(){

            public HashValue getHash() {
                return md5;
            }
        };
    }

    public HashValue hash(File file) {
        return this.snapshot(file).getHash();
    }

    public FileInfo snapshot(File file) {
        return this.snapshot(file, file.length(), file.lastModified());
    }

    public FileInfo snapshot(FileTreeElement file) {
        return this.snapshot(file.getFile(), file.getSize(), file.getLastModified());
    }

    private FileInfo snapshot(File file, long length, long timestamp) {
        String absolutePath = file.getAbsolutePath();
        FileInfo info = this.cache.get(absolutePath);
        if (info != null && length == info.length && timestamp == info.timestamp) {
            return info;
        }
        HashValue hash = this.hasher.hash(file);
        info = new FileInfo(hash, length, timestamp);
        this.cache.put(this.stringInterner.intern(absolutePath), info);
        return info;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileInfoSerializer
    implements Serializer<FileInfo> {
        private final HashValueSerializer hashValueSerializer = new HashValueSerializer();

        private FileInfoSerializer() {
        }

        public FileInfo read(Decoder decoder) throws Exception {
            HashValue hash = this.hashValueSerializer.read(decoder);
            long timestamp = decoder.readLong();
            long length = decoder.readLong();
            return new FileInfo(hash, length, timestamp);
        }

        public void write(Encoder encoder, FileInfo value) throws Exception {
            this.hashValueSerializer.write(encoder, value.hash);
            encoder.writeLong(value.timestamp);
            encoder.writeLong(value.length);
        }
    }

    public static class FileInfo
    implements FileSnapshot {
        private final HashValue hash;
        private final long timestamp;
        private final long length;

        public FileInfo(HashValue hash, long length, long timestamp) {
            this.hash = hash;
            this.length = length;
            this.timestamp = timestamp;
        }

        public HashValue getHash() {
            return this.hash;
        }
    }
}

