/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.gradle.api.Action;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.messaging.remote.ObjectConnection;
import org.gradle.process.internal.DefaultWorkerProcessBuilder;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.SingleUseWorkerProcessBuilder;
import org.gradle.process.internal.WorkerProcess;
import org.gradle.process.internal.WorkerProcessContext;
import org.gradle.process.internal.WorkerProcessException;
import org.gradle.process.internal.WorkerProcessSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultSingleUseWorkerProcessBuilder<T>
implements SingleUseWorkerProcessBuilder<T> {
    private final Class<T> protocolType;
    private final Class<? extends T> workerImplementation;
    private final DefaultWorkerProcessBuilder builder;

    public DefaultSingleUseWorkerProcessBuilder(Class<T> protocolType, Class<? extends T> workerImplementation, DefaultWorkerProcessBuilder builder) {
        this.protocolType = protocolType;
        this.workerImplementation = workerImplementation;
        this.builder = builder;
        builder.worker(new WorkerAction(workerImplementation));
        builder.setImplementationClasspath(ClasspathUtil.getClasspath((ClassLoader)workerImplementation.getClassLoader()));
    }

    @Override
    public WorkerProcessSettings setBaseName(String baseName) {
        this.builder.setBaseName(baseName);
        return this;
    }

    @Override
    public String getBaseName() {
        return this.builder.getBaseName();
    }

    @Override
    public WorkerProcessSettings applicationClasspath(Iterable<File> files) {
        this.builder.applicationClasspath((Iterable)files);
        return this;
    }

    @Override
    public Set<File> getApplicationClasspath() {
        return this.builder.getApplicationClasspath();
    }

    @Override
    public WorkerProcessSettings sharedPackages(String ... packages) {
        this.builder.sharedPackages(packages);
        return this;
    }

    @Override
    public WorkerProcessSettings sharedPackages(Iterable<String> packages) {
        this.builder.sharedPackages((Iterable)packages);
        return this;
    }

    @Override
    public Set<String> getSharedPackages() {
        return this.builder.getSharedPackages();
    }

    @Override
    public JavaExecHandleBuilder getJavaCommand() {
        return this.builder.getJavaCommand();
    }

    @Override
    public LogLevel getLogLevel() {
        return this.builder.getLogLevel();
    }

    @Override
    public WorkerProcessSettings setLogLevel(LogLevel logLevel) {
        this.builder.setLogLevel(logLevel);
        return this;
    }

    @Override
    public T build() {
        return this.protocolType.cast(Proxy.newProxyInstance(this.protocolType.getClassLoader(), new Class[]{this.protocolType}, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                WorkerProcess workerProcess = DefaultSingleUseWorkerProcessBuilder.this.builder.build();
                workerProcess.start();
                ObjectConnection connection = workerProcess.getConnection();
                RequestProtocol requestProtocol = (RequestProtocol)connection.addOutgoing(RequestProtocol.class);
                Receiver receiver = new Receiver();
                connection.addIncoming(ResponseProtocol.class, (Object)receiver);
                connection.useJavaSerializationForParameters(DefaultSingleUseWorkerProcessBuilder.this.workerImplementation.getClassLoader());
                connection.connect();
                requestProtocol.run(method.getName(), method.getParameterTypes(), args);
                workerProcess.waitForStop();
                return receiver.getResult();
            }
        }));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WorkerAction
    implements Action<WorkerProcessContext>,
    Serializable,
    RequestProtocol {
        private final Class<?> workerImplementation;
        private CountDownLatch completed;
        private ResponseProtocol responder;

        WorkerAction(Class<?> workerImplementation) {
            this.workerImplementation = workerImplementation;
        }

        public void execute(WorkerProcessContext workerProcessContext) {
            this.completed = new CountDownLatch(1);
            ObjectConnection connection = workerProcessContext.getServerConnection();
            connection.addIncoming(RequestProtocol.class, (Object)this);
            this.responder = (ResponseProtocol)connection.addOutgoing(ResponseProtocol.class);
            connection.connect();
            try {
                this.completed.await();
            }
            catch (InterruptedException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(String methodName, Class<?>[] paramTypes, Object[] args) {
            try {
                Object result;
                Object implementation = this.workerImplementation.newInstance();
                Method method = this.workerImplementation.getDeclaredMethod(methodName, paramTypes);
                try {
                    result = method.invoke(implementation, args);
                }
                catch (InvocationTargetException e) {
                    Throwable failure = e.getCause();
                    if (failure instanceof NoClassDefFoundError) {
                        this.responder.infrastructureFailed(failure);
                    } else {
                        this.responder.failed(failure);
                    }
                    this.completed.countDown();
                    return;
                }
                this.responder.completed(result);
            }
            catch (Throwable t) {
                this.responder.infrastructureFailed(t);
            }
            finally {
                this.completed.countDown();
            }
        }
    }

    private class Receiver
    implements ResponseProtocol {
        private final CountDownLatch received = new CountDownLatch(1);
        private Object result;
        private Throwable failure;

        private Receiver() {
        }

        Object getResult() throws Throwable {
            this.received.await();
            if (this.failure != null) {
                throw this.failure;
            }
            return this.result;
        }

        public void completed(Object result) {
            this.result = result;
            this.received.countDown();
        }

        public void infrastructureFailed(Throwable failure) {
            this.failed((Throwable)((Object)new WorkerProcessException(String.format("Failed to run %s", DefaultSingleUseWorkerProcessBuilder.this.builder.getBaseName()), failure)));
        }

        public void failed(Throwable failure) {
            this.failure = failure;
            this.received.countDown();
        }
    }

    static interface ResponseProtocol {
        public void completed(Object var1);

        public void failed(Throwable var1);

        public void infrastructureFailed(Throwable var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface RequestProtocol {
        public void run(String var1, Class<?>[] var2, Object[] var3);
    }
}

