/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationProcessor;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.BuildOperationWorker;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.nativeplatform.internal.StaticLibraryArchiverSpec;
import org.gradle.nativeplatform.toolchain.internal.ArgsTransformer;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolContext;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocation;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocationWorker;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.EscapeUserArgs;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualCppOptionsFileArgsWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LibExeStaticLibraryArchiver
implements Compiler<StaticLibraryArchiverSpec> {
    private final CommandLineToolInvocationWorker commandLineToolInvocationWorker;
    private final Transformer<StaticLibraryArchiverSpec, StaticLibraryArchiverSpec> specTransformer;
    private final ArgsTransformer<StaticLibraryArchiverSpec> argsTransformer;
    private final CommandLineToolContext invocationContext;
    private final BuildOperationProcessor buildOperationProcessor;

    LibExeStaticLibraryArchiver(BuildOperationProcessor buildOperationProcessor, CommandLineToolInvocationWorker commandLineToolInvocationWorker, CommandLineToolContext invocationContext, Transformer<StaticLibraryArchiverSpec, StaticLibraryArchiverSpec> specTransformer) {
        this.buildOperationProcessor = buildOperationProcessor;
        this.specTransformer = specTransformer;
        this.argsTransformer = new LibExeSpecToArguments();
        this.commandLineToolInvocationWorker = commandLineToolInvocationWorker;
        this.invocationContext = invocationContext;
    }

    public WorkResult execute(final StaticLibraryArchiverSpec spec) {
        StaticLibraryArchiverSpec transformedSpec = (StaticLibraryArchiverSpec)this.specTransformer.transform((Object)spec);
        List args = (List)this.argsTransformer.transform(transformedSpec);
        this.invocationContext.getArgAction().execute((Object)args);
        new VisualCppOptionsFileArgsWriter(spec.getTempDir()).execute(args);
        final CommandLineToolInvocation invocation = this.invocationContext.createInvocation(String.format("archiving %s", spec.getOutputFile().getName()), args, spec.getOperationLogger());
        this.buildOperationProcessor.run((BuildOperationWorker)this.commandLineToolInvocationWorker, (Action)new Action<BuildOperationQueue<CommandLineToolInvocation>>(){

            public void execute(BuildOperationQueue<CommandLineToolInvocation> buildQueue) {
                buildQueue.setLogLocation(spec.getOperationLogger().getLogLocation());
                buildQueue.add((BuildOperation)invocation);
            }
        });
        return new SimpleWorkResult(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LibExeSpecToArguments
    implements ArgsTransformer<StaticLibraryArchiverSpec> {
        private LibExeSpecToArguments() {
        }

        public List<String> transform(StaticLibraryArchiverSpec spec) {
            ArrayList<String> args = new ArrayList<String>();
            args.add("/OUT:" + spec.getOutputFile().getAbsolutePath());
            args.add("/NOLOGO");
            args.addAll(EscapeUserArgs.escapeUserArgs(spec.getAllArgs()));
            for (File file : spec.getObjectFiles()) {
                args.add(file.getAbsolutePath());
            }
            return args;
        }
    }
}

