/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.internal;

import org.gradle.api.internal.DefaultNamedDomainObjectSet;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioProject;
import org.gradle.ide.visualstudio.internal.ExecutableVisualStudioProjectConfiguration;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectConfiguration;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectMapper;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.NativeComponentSpec;
import org.gradle.nativeplatform.NativeExecutableBinarySpec;
import org.gradle.platform.base.internal.DefaultComponentSpecIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualStudioProjectRegistry
extends DefaultNamedDomainObjectSet<DefaultVisualStudioProject> {
    private final ProjectIdentifier projectIdentifier;
    private final FileResolver fileResolver;
    private final VisualStudioProjectMapper projectMapper;

    public VisualStudioProjectRegistry(ProjectIdentifier projectIdentifier, FileResolver fileResolver, VisualStudioProjectMapper projectMapper, Instantiator instantiator) {
        super(DefaultVisualStudioProject.class, instantiator);
        this.projectIdentifier = projectIdentifier;
        this.fileResolver = fileResolver;
        this.projectMapper = projectMapper;
    }

    public VisualStudioProjectConfiguration getProjectConfiguration(NativeBinarySpec nativeBinary) {
        String projectName = this.projectName(nativeBinary);
        return ((DefaultVisualStudioProject)this.getByName(projectName)).getConfiguration(nativeBinary);
    }

    public VisualStudioProjectConfiguration addProjectConfiguration(NativeBinarySpec nativeBinary) {
        VisualStudioProjectMapper.ProjectConfigurationNames names = this.projectMapper.mapToConfiguration(nativeBinary);
        DefaultVisualStudioProject project = this.getOrCreateProject(nativeBinary.getComponent(), names.project);
        VisualStudioProjectConfiguration configuration = this.createVisualStudioProjectConfiguration(nativeBinary, project, names.configuration, names.platform);
        project.addConfiguration(nativeBinary, configuration);
        return configuration;
    }

    private VisualStudioProjectConfiguration createVisualStudioProjectConfiguration(NativeBinarySpec nativeBinary, DefaultVisualStudioProject project, String configuration, String platform) {
        Class type = nativeBinary instanceof NativeExecutableBinarySpec ? ExecutableVisualStudioProjectConfiguration.class : VisualStudioProjectConfiguration.class;
        return (VisualStudioProjectConfiguration)this.getInstantiator().newInstance(type, new Object[]{project, configuration, platform, nativeBinary});
    }

    private DefaultVisualStudioProject getOrCreateProject(NativeComponentSpec nativeComponent, String vsProjectName) {
        DefaultVisualStudioProject vsProject = (DefaultVisualStudioProject)this.findByName(vsProjectName);
        if (vsProject == null) {
            vsProject = (DefaultVisualStudioProject)this.getInstantiator().newInstance(DefaultVisualStudioProject.class, new Object[]{new DefaultComponentSpecIdentifier(this.projectIdentifier.getPath(), vsProjectName), nativeComponent, this.fileResolver, this.getInstantiator()});
            this.add(vsProject);
        }
        return vsProject;
    }

    private String projectName(NativeBinarySpec nativeBinary) {
        return this.projectMapper.mapToConfiguration((NativeBinarySpec)nativeBinary).project;
    }
}

