/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.Arrays;
import javax.json.JsonException;
import javax.json.stream.JsonLocation;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParsingException;
import org.glassfish.json.JsonLocationImpl;
import org.glassfish.json.JsonMessages;
import org.glassfish.json.api.BufferPool;

final class JsonTokenizer
implements Closeable {
    private static final int[] HEX;
    private static final int HEX_LENGTH;
    private final BufferPool bufferPool;
    private final Reader reader;
    private char[] buf;
    private int readBegin;
    private int readEnd;
    private int storeBegin;
    private int storeEnd;
    private long lineNo = 1L;
    private long lastLineOffset = 0L;
    private long bufferOffset = 0L;
    private boolean minus;
    private boolean fracOrExp;
    private BigDecimal bd;

    JsonTokenizer(Reader reader, BufferPool bufferPool) {
        this.reader = reader;
        this.bufferPool = bufferPool;
        this.buf = bufferPool.take();
    }

    private void readString() {
        int n;
        boolean bl = true;
        this.storeBegin = this.storeEnd = this.readBegin;
        block4: while (true) {
            if (bl) {
                while (this.readBegin < this.readEnd && (n = this.buf[this.readBegin]) >= 32 && n != 92) {
                    if (n == 34) {
                        this.storeEnd = this.readBegin++;
                        return;
                    }
                    ++this.readBegin;
                }
                this.storeEnd = this.readBegin;
            }
            if ((n = this.read()) >= 32 && n != 34 && n != 92) {
                if (!bl) {
                    this.buf[this.storeEnd] = (char)n;
                }
                ++this.storeEnd;
                continue;
            }
            switch (n) {
                case 92: {
                    bl = false;
                    this.unescape();
                    continue block4;
                }
                case 34: {
                    return;
                }
            }
            break;
        }
        throw this.unexpectedChar(n);
    }

    private void unescape() {
        int n = this.read();
        switch (n) {
            case 98: {
                this.buf[this.storeEnd++] = 8;
                break;
            }
            case 116: {
                this.buf[this.storeEnd++] = 9;
                break;
            }
            case 110: {
                this.buf[this.storeEnd++] = 10;
                break;
            }
            case 102: {
                this.buf[this.storeEnd++] = 12;
                break;
            }
            case 114: {
                this.buf[this.storeEnd++] = 13;
                break;
            }
            case 34: 
            case 47: 
            case 92: {
                this.buf[this.storeEnd++] = (char)n;
                break;
            }
            case 117: {
                int n2 = 0;
                for (int i = 0; i < 4; ++i) {
                    int n3;
                    int n4 = this.read();
                    int n5 = n3 = n4 >= 0 && n4 < HEX_LENGTH ? HEX[n4] : -1;
                    if (n3 < 0) {
                        throw this.unexpectedChar(n4);
                    }
                    n2 = n2 << 4 | n3;
                }
                this.buf[this.storeEnd++] = (char)n2;
                break;
            }
            default: {
                throw this.unexpectedChar(n);
            }
        }
    }

    private int readNumberChar() {
        if (this.readBegin < this.readEnd) {
            return this.buf[this.readBegin++];
        }
        this.storeEnd = this.readBegin;
        return this.read();
    }

    private void readNumber(int n) {
        int n2;
        this.storeBegin = this.storeEnd = this.readBegin - 1;
        if (n == 45) {
            this.minus = true;
            n = this.readNumberChar();
            if (n < 48 || n > 57) {
                throw this.unexpectedChar(n);
            }
        }
        if (n == 48) {
            n = this.readNumberChar();
        } else {
            while ((n = this.readNumberChar()) >= 48 && n <= 57) {
            }
        }
        if (n == 46) {
            this.fracOrExp = true;
            n2 = 0;
            do {
                n = this.readNumberChar();
                ++n2;
            } while (n >= 48 && n <= 57);
            if (n2 == 1) {
                throw this.unexpectedChar(n);
            }
        }
        if (n == 101 || n == 69) {
            this.fracOrExp = true;
            n = this.readNumberChar();
            if (n == 43 || n == 45) {
                n = this.readNumberChar();
            }
            n2 = 0;
            while (n >= 48 && n <= 57) {
                n = this.readNumberChar();
                ++n2;
            }
            if (n2 == 0) {
                throw this.unexpectedChar(n);
            }
        }
        --this.readBegin;
        this.storeEnd = this.readBegin;
    }

    private void readTrue() {
        int n = this.read();
        if (n != 114) {
            throw this.expectedChar(n, 'r');
        }
        int n2 = this.read();
        if (n2 != 117) {
            throw this.expectedChar(n2, 'u');
        }
        int n3 = this.read();
        if (n3 != 101) {
            throw this.expectedChar(n3, 'e');
        }
    }

    private void readFalse() {
        int n = this.read();
        if (n != 97) {
            throw this.expectedChar(n, 'a');
        }
        int n2 = this.read();
        if (n2 != 108) {
            throw this.expectedChar(n2, 'l');
        }
        int n3 = this.read();
        if (n3 != 115) {
            throw this.expectedChar(n3, 's');
        }
        int n4 = this.read();
        if (n4 != 101) {
            throw this.expectedChar(n4, 'e');
        }
    }

    private void readNull() {
        int n = this.read();
        if (n != 117) {
            throw this.expectedChar(n, 'u');
        }
        int n2 = this.read();
        if (n2 != 108) {
            throw this.expectedChar(n2, 'l');
        }
        int n3 = this.read();
        if (n3 != 108) {
            throw this.expectedChar(n3, 'l');
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    JsonToken nextToken() {
        this.reset();
        int n = this.read();
        while (n == 32 || n == 9 || n == 10 || n == 13) {
            block19: {
                if (n == 13) {
                    ++this.lineNo;
                    n = this.read();
                    if (n == 10) {
                        this.lastLineOffset = this.bufferOffset + (long)this.readBegin;
                        break block19;
                    } else {
                        this.lastLineOffset = this.bufferOffset + (long)this.readBegin - 1L;
                        continue;
                    }
                }
                if (n == 10) {
                    ++this.lineNo;
                    this.lastLineOffset = this.bufferOffset + (long)this.readBegin;
                }
            }
            n = this.read();
        }
        switch (n) {
            case 34: {
                this.readString();
                return JsonToken.STRING;
            }
            case 123: {
                return JsonToken.CURLYOPEN;
            }
            case 91: {
                return JsonToken.SQUAREOPEN;
            }
            case 58: {
                return JsonToken.COLON;
            }
            case 44: {
                return JsonToken.COMMA;
            }
            case 116: {
                this.readTrue();
                return JsonToken.TRUE;
            }
            case 102: {
                this.readFalse();
                return JsonToken.FALSE;
            }
            case 110: {
                this.readNull();
                return JsonToken.NULL;
            }
            case 93: {
                return JsonToken.SQUARECLOSE;
            }
            case 125: {
                return JsonToken.CURLYCLOSE;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.readNumber(n);
                return JsonToken.NUMBER;
            }
            case -1: {
                return JsonToken.EOF;
            }
        }
        throw this.unexpectedChar(n);
    }

    JsonLocation getLastCharLocation() {
        return new JsonLocationImpl(this.lineNo, this.bufferOffset + (long)this.readBegin - this.lastLineOffset, this.bufferOffset + (long)this.readBegin - 1L);
    }

    JsonLocation getLocation() {
        return new JsonLocationImpl(this.lineNo, this.bufferOffset + (long)this.readBegin - this.lastLineOffset + 1L, this.bufferOffset + (long)this.readBegin);
    }

    private int read() {
        try {
            if (this.readBegin == this.readEnd) {
                int n = this.fillBuf();
                if (n == -1) {
                    return -1;
                }
                assert (n != 0);
                this.readBegin = this.storeEnd;
                this.readEnd = this.readBegin + n;
            }
            return this.buf[this.readBegin++];
        }
        catch (IOException iOException) {
            throw new JsonException(JsonMessages.TOKENIZER_IO_ERR(), iOException);
        }
    }

    private int fillBuf() throws IOException {
        if (this.storeEnd != 0) {
            int n = this.storeEnd - this.storeBegin;
            if (n > 0) {
                if (n == this.buf.length) {
                    char[] cArray = Arrays.copyOf(this.buf, 2 * this.buf.length);
                    this.bufferPool.recycle(this.buf);
                    this.buf = cArray;
                } else {
                    System.arraycopy(this.buf, this.storeBegin, this.buf, 0, n);
                    this.storeEnd = n;
                    this.storeBegin = 0;
                    this.bufferOffset += (long)(this.readBegin - this.storeEnd);
                }
            } else {
                this.storeEnd = 0;
                this.storeBegin = 0;
                this.bufferOffset += (long)this.readBegin;
            }
        } else {
            this.bufferOffset += (long)this.readBegin;
        }
        return this.reader.read(this.buf, this.storeEnd, this.buf.length - this.storeEnd);
    }

    private void reset() {
        if (this.storeEnd != 0) {
            this.storeBegin = 0;
            this.storeEnd = 0;
            this.bd = null;
            this.minus = false;
            this.fracOrExp = false;
        }
    }

    String getValue() {
        return new String(this.buf, this.storeBegin, this.storeEnd - this.storeBegin);
    }

    BigDecimal getBigDecimal() {
        if (this.bd == null) {
            this.bd = new BigDecimal(this.buf, this.storeBegin, this.storeEnd - this.storeBegin);
        }
        return this.bd;
    }

    int getInt() {
        int n = this.storeEnd - this.storeBegin;
        if (!this.fracOrExp && (n <= 9 || this.minus && n == 10)) {
            int n2;
            int n3 = 0;
            int n4 = n2 = this.minus ? 1 : 0;
            while (n2 < n) {
                n3 = n3 * 10 + (this.buf[this.storeBegin + n2] - 48);
                ++n2;
            }
            return this.minus ? -n3 : n3;
        }
        return this.getBigDecimal().intValue();
    }

    boolean isDefinitelyInt() {
        int n = this.storeEnd - this.storeBegin;
        return !this.fracOrExp && (n <= 9 || this.minus && n == 10);
    }

    boolean isIntegral() {
        return !this.fracOrExp || this.getBigDecimal().scale() == 0;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        this.bufferPool.recycle(this.buf);
    }

    private JsonParsingException unexpectedChar(int n) {
        JsonLocation jsonLocation = this.getLastCharLocation();
        return new JsonParsingException(JsonMessages.TOKENIZER_UNEXPECTED_CHAR(n, jsonLocation), jsonLocation);
    }

    private JsonParsingException expectedChar(int n, char c) {
        JsonLocation jsonLocation = this.getLastCharLocation();
        return new JsonParsingException(JsonMessages.TOKENIZER_EXPECTED_CHAR(n, jsonLocation, c), jsonLocation);
    }

    static {
        int n;
        HEX = new int[128];
        Arrays.fill(HEX, -1);
        for (n = 48; n <= 57; ++n) {
            JsonTokenizer.HEX[n] = n - 48;
        }
        for (n = 65; n <= 70; ++n) {
            JsonTokenizer.HEX[n] = 10 + n - 65;
        }
        for (n = 97; n <= 102; ++n) {
            JsonTokenizer.HEX[n] = 10 + n - 97;
        }
        HEX_LENGTH = HEX.length;
    }

    static enum JsonToken {
        CURLYOPEN(JsonParser.Event.START_OBJECT, false),
        SQUAREOPEN(JsonParser.Event.START_ARRAY, false),
        COLON(null, false),
        COMMA(null, false),
        STRING(JsonParser.Event.VALUE_STRING, true),
        NUMBER(JsonParser.Event.VALUE_NUMBER, true),
        TRUE(JsonParser.Event.VALUE_TRUE, true),
        FALSE(JsonParser.Event.VALUE_FALSE, true),
        NULL(JsonParser.Event.VALUE_NULL, true),
        CURLYCLOSE(JsonParser.Event.END_OBJECT, false),
        SQUARECLOSE(JsonParser.Event.END_ARRAY, false),
        EOF(null, false);

        private final JsonParser.Event event;
        private final boolean value;

        private JsonToken(JsonParser.Event event, boolean bl) {
            this.event = event;
            this.value = bl;
        }

        JsonParser.Event getEvent() {
            return this.event;
        }

        boolean isValue() {
            return this.value;
        }
    }
}

