/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.OpenFileAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListenerAdapter;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.OsmExporter;
import org.openstreetmap.josm.io.OsmImporter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class AutosaveTask
extends TimerTask
implements MapView.LayerChangeListener,
DataSetListenerAdapter.Listener {
    private static final char[] ILLEGAL_CHARACTERS = new char[]{'/', '\n', '\r', '\t', '\u0000', '\f', '`', '?', '*', '\\', '<', '>', '|', '\"', ':'};
    private static final String AUTOSAVE_DIR = "autosave";
    private static final String DELETED_LAYERS_DIR = "autosave/deleted_layers";
    public static final BooleanProperty PROP_AUTOSAVE_ENABLED = new BooleanProperty("autosave.enabled", true);
    public static final IntegerProperty PROP_FILES_PER_LAYER = new IntegerProperty("autosave.filesPerLayer", 1);
    public static final IntegerProperty PROP_DELETED_LAYERS = new IntegerProperty("autosave.deletedLayersBackupCount", 5);
    public static final IntegerProperty PROP_INTERVAL = new IntegerProperty("autosave.interval", 300);
    public static final IntegerProperty PROP_INDEX_LIMIT = new IntegerProperty("autosave.index-limit", 1000);
    public static final BooleanProperty PROP_NOTIFICATION = new BooleanProperty("autosave.notification", false);
    private final DataSetListenerAdapter datasetAdapter = new DataSetListenerAdapter(this);
    private final Set<DataSet> changedDatasets = new HashSet<DataSet>();
    private final List<AutosaveLayerInfo> layersInfo = new ArrayList<AutosaveLayerInfo>();
    private Timer timer;
    private final Object layersLock = new Object();
    private final Deque<File> deletedLayers = new LinkedList<File>();
    private final File autosaveDir = new File(Main.pref.getUserDataDirectory(), "autosave");
    private final File deletedLayersDir = new File(Main.pref.getUserDataDirectory(), "autosave/deleted_layers");

    public void schedule() {
        if (PROP_INTERVAL.get() > 0) {
            if (!this.autosaveDir.exists() && !this.autosaveDir.mkdirs()) {
                Main.warn(I18n.tr("Unable to create directory {0}, autosave will be disabled", this.autosaveDir.getAbsolutePath()));
                return;
            }
            if (!this.deletedLayersDir.exists() && !this.deletedLayersDir.mkdirs()) {
                Main.warn(I18n.tr("Unable to create directory {0}, autosave will be disabled", this.deletedLayersDir.getAbsolutePath()));
                return;
            }
            File[] fileArray = this.deletedLayersDir.listFiles();
            if (fileArray != null) {
                for (File file : fileArray) {
                    this.deletedLayers.add(file);
                }
            }
            this.timer = new Timer(true);
            this.timer.schedule((TimerTask)this, 1000L, (long)PROP_INTERVAL.get().intValue() * 1000L);
            MapView.addLayerChangeListener(this);
            if (Main.isDisplayingMapView()) {
                for (OsmDataLayer osmDataLayer : Main.map.mapView.getLayersOfType(OsmDataLayer.class)) {
                    this.registerNewlayer(osmDataLayer);
                }
            }
        }
    }

    private static String getFileName(String string, int n) {
        String string2 = string;
        for (char c : ILLEGAL_CHARACTERS) {
            string2 = string2.replaceAll(Pattern.quote(String.valueOf(c)), '&' + String.valueOf((int)c) + ';');
        }
        if (n != 0) {
            string2 = string2 + '_' + n;
        }
        return string2;
    }

    private void setLayerFileName(AutosaveLayerInfo autosaveLayerInfo) {
        int n = 0;
        while (true) {
            String string = AutosaveTask.getFileName(autosaveLayerInfo.layer.getName(), n);
            boolean bl = false;
            for (AutosaveLayerInfo autosaveLayerInfo2 : this.layersInfo) {
                if (autosaveLayerInfo2 == autosaveLayerInfo || !string.equals(autosaveLayerInfo2.layerFileName)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                autosaveLayerInfo.layerFileName = string;
                return;
            }
            ++n;
        }
    }

    private File getNewLayerFile(AutosaveLayerInfo autosaveLayerInfo) {
        int n = 0;
        Date date = new Date();
        while (true) {
            String string = String.format("%1$s_%2$tY%2$tm%2$td_%2$tH%2$tM%2$tS%2$tL%3$s", autosaveLayerInfo.layerFileName, date, n == 0 ? "" : Integer.valueOf(95 + n));
            File file = new File(this.autosaveDir, string + "." + Main.pref.get("autosave.extension", "osm"));
            try {
                if (file.createNewFile()) {
                    File file2 = new File(this.autosaveDir, string + ".pid");
                    try (PrintStream printStream = new PrintStream(file2, "UTF-8");){
                        printStream.println(ManagementFactory.getRuntimeMXBean().getName());
                    }
                    catch (Exception exception) {
                        Main.error(exception);
                    }
                    return file;
                }
                Main.warn(I18n.tr("Unable to create file {0}, other filename will be used", file.getAbsolutePath()));
                if (n > PROP_INDEX_LIMIT.get()) {
                    throw new IOException("index limit exceeded");
                }
            }
            catch (IOException iOException) {
                Main.error(I18n.tr("IOError while creating file, autosave will be skipped: {0}", iOException.getMessage()));
                return null;
            }
            ++n;
        }
    }

    private void savelayer(AutosaveLayerInfo autosaveLayerInfo) {
        File file;
        if (!autosaveLayerInfo.layer.getName().equals(autosaveLayerInfo.layerName)) {
            this.setLayerFileName(autosaveLayerInfo);
            autosaveLayerInfo.layerName = autosaveLayerInfo.layer.getName();
        }
        if (this.changedDatasets.remove(((AutosaveLayerInfo)autosaveLayerInfo).layer.data) && (file = this.getNewLayerFile(autosaveLayerInfo)) != null) {
            autosaveLayerInfo.backupFiles.add(file);
            new OsmExporter().exportData(file, autosaveLayerInfo.layer, true);
        }
        while (autosaveLayerInfo.backupFiles.size() > PROP_FILES_PER_LAYER.get()) {
            file = (File)autosaveLayerInfo.backupFiles.remove();
            if (!Utils.deleteFile(file, I18n.marktr("Unable to delete old backup file {0}"))) continue;
            Utils.deleteFile(this.getPidFile(file), I18n.marktr("Unable to delete old backup file {0}"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.layersLock;
        synchronized (object) {
            try {
                for (AutosaveLayerInfo autosaveLayerInfo : this.layersInfo) {
                    this.savelayer(autosaveLayerInfo);
                }
                this.changedDatasets.clear();
                if (PROP_NOTIFICATION.get().booleanValue() && !this.layersInfo.isEmpty()) {
                    this.displayNotification();
                }
            }
            catch (Exception exception) {
                Main.error("Autosave failed:");
                Main.error(exception);
            }
        }
    }

    protected void displayNotification() {
        GuiHelper.runInEDT(new Runnable(){

            @Override
            public void run() {
                new Notification(I18n.tr("Your work has been saved automatically.", new Object[0])).setDuration(Notification.TIME_SHORT).show();
            }
        });
    }

    @Override
    public void activeLayerChange(Layer layer, Layer layer2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNewlayer(OsmDataLayer osmDataLayer) {
        Object object = this.layersLock;
        synchronized (object) {
            osmDataLayer.data.addDataSetListener(this.datasetAdapter);
            AutosaveLayerInfo autosaveLayerInfo = new AutosaveLayerInfo();
            autosaveLayerInfo.layer = osmDataLayer;
            this.layersInfo.add(autosaveLayerInfo);
        }
    }

    @Override
    public void layerAdded(Layer layer) {
        if (layer instanceof OsmDataLayer) {
            this.registerNewlayer((OsmDataLayer)layer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layerRemoved(Layer layer) {
        if (layer instanceof OsmDataLayer) {
            Object object = this.layersLock;
            synchronized (object) {
                OsmDataLayer osmDataLayer = (OsmDataLayer)layer;
                osmDataLayer.data.removeDataSetListener(this.datasetAdapter);
                Iterator<AutosaveLayerInfo> iterator = this.layersInfo.iterator();
                while (iterator.hasNext()) {
                    AutosaveLayerInfo autosaveLayerInfo = iterator.next();
                    if (autosaveLayerInfo.layer != osmDataLayer) continue;
                    this.savelayer(autosaveLayerInfo);
                    File file = (File)autosaveLayerInfo.backupFiles.pollLast();
                    if (file != null) {
                        this.moveToDeletedLayersFolder(file);
                    }
                    for (File file2 : autosaveLayerInfo.backupFiles) {
                        if (!Utils.deleteFile(file2)) continue;
                        Utils.deleteFile(this.getPidFile(file2));
                    }
                    iterator.remove();
                }
            }
        }
    }

    @Override
    public void processDatasetEvent(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
        this.changedDatasets.add(abstractDatasetChangedEvent.getDataset());
    }

    private File getPidFile(File file) {
        return new File(this.autosaveDir, file.getName().replaceFirst("[.][^.]+$", ".pid"));
    }

    public List<File> getUnsavedLayersFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = this.autosaveDir.listFiles(OsmImporter.FILE_FILTER);
        if (fileArray == null) {
            return arrayList;
        }
        for (File file : fileArray) {
            if (!file.isFile()) continue;
            boolean bl = false;
            File file2 = this.getPidFile(file);
            if (file2.exists()) {
                try (BufferedReader bufferedReader = Files.newBufferedReader(file2.toPath(), StandardCharsets.UTF_8);){
                    String string = bufferedReader.readLine();
                    if (string != null) {
                        String string2 = string.split("@")[0];
                        bl = AutosaveTask.jvmPerfDataFileExists(string2);
                    }
                }
                catch (Exception exception) {
                    Main.error(exception);
                }
            }
            if (bl) continue;
            arrayList.add(file);
        }
        return arrayList;
    }

    private static boolean jvmPerfDataFileExists(final String string) {
        File file = new File(System.getProperty("java.io.tmpdir") + File.separator + "hsperfdata_" + System.getProperty("user.name"));
        if (file.exists() && file.canRead()) {
            File[] fileArray = file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.getName().equals(string) && file.isFile();
                }
            });
            return fileArray != null && fileArray.length == 1;
        }
        return false;
    }

    public void recoverUnsavedLayers() {
        List<File> list = this.getUnsavedLayersFiles();
        final OpenFileAction.OpenFileTask openFileTask = new OpenFileAction.OpenFileTask(list, null, I18n.tr("Restoring files", new Object[0]));
        Main.worker.submit(openFileTask);
        Main.worker.submit(new Runnable(){

            @Override
            public void run() {
                for (File file : openFileTask.getSuccessfullyOpenedFiles()) {
                    AutosaveTask.this.moveToDeletedLayersFolder(file);
                }
            }
        });
    }

    private void moveToDeletedLayersFolder(File file) {
        File file2;
        File file3 = new File(this.deletedLayersDir, file.getName());
        File file4 = this.getPidFile(file);
        if (file3.exists()) {
            this.deletedLayers.remove(file3);
            Utils.deleteFile(file3, I18n.marktr("Unable to delete old backup file {0}"));
        }
        if (file.renameTo(file3)) {
            this.deletedLayers.add(file3);
            Utils.deleteFile(file4);
        } else {
            Main.warn(String.format("Could not move autosaved file %s to %s folder", file.getName(), this.deletedLayersDir.getName()));
            if (Utils.deleteFile(file, I18n.marktr("Unable to delete backup file {0}"))) {
                Utils.deleteFile(file4, I18n.marktr("Unable to delete PID file {0}"));
            }
        }
        while (this.deletedLayers.size() > PROP_DELETED_LAYERS.get() && (file2 = this.deletedLayers.remove()) != null) {
            Utils.deleteFile(file2, I18n.marktr("Unable to delete archived backup file {0}"));
        }
    }

    public void discardUnsavedLayers() {
        for (File file : this.getUnsavedLayersFiles()) {
            this.moveToDeletedLayersFolder(file);
        }
    }

    private static class AutosaveLayerInfo {
        private OsmDataLayer layer;
        private String layerName;
        private String layerFileName;
        private final Deque<File> backupFiles = new LinkedList<File>();

        private AutosaveLayerInfo() {
        }
    }
}

