/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.awt.Point;
import java.awt.Rectangle;

public class LineClip {
    private Point p1;
    private Point p2;
    private final Rectangle clipBounds;

    public LineClip(Point point, Point point2, Rectangle rectangle) {
        this.p1 = point;
        this.p2 = point2;
        this.clipBounds = rectangle;
    }

    public boolean execute() {
        if (this.clipBounds == null) {
            return false;
        }
        return this.cohenSutherland(this.p1.x, this.p1.y, this.p2.x, this.p2.y, this.clipBounds.x, this.clipBounds.y, this.clipBounds.x + this.clipBounds.width, this.clipBounds.y + this.clipBounds.height);
    }

    public Point getP1() {
        return this.p1;
    }

    public Point getP2() {
        return this.p2;
    }

    private boolean cohenSutherland(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8) {
        boolean bl = false;
        boolean bl2 = false;
        int n = LineClip.computeOutCode(l, l2, l5, l6, l7, l8);
        int n2 = LineClip.computeOutCode(l3, l4, l5, l6, l7, l8);
        do {
            int n3;
            if ((n | n2) == 0) {
                bl = true;
                bl2 = true;
                continue;
            }
            if ((n & n2) > 0) {
                bl2 = true;
                continue;
            }
            long l9 = 0L;
            long l10 = 0L;
            int n4 = n3 = n != 0 ? n : n2;
            if ((n3 & 2) > 0) {
                l9 = l + (l3 - l) * (l8 - l2) / (l4 - l2);
                l10 = l8;
            } else if ((n3 & 8) > 0) {
                l9 = l + (l3 - l) * (l6 - l2) / (l4 - l2);
                l10 = l6;
            } else if ((n3 & 4) > 0) {
                l10 = l2 + (l4 - l2) * (l7 - l) / (l3 - l);
                l9 = l7;
            } else if ((n3 & 1) > 0) {
                l10 = l2 + (l4 - l2) * (l5 - l) / (l3 - l);
                l9 = l5;
            }
            if (n3 == n) {
                l = l9;
                l2 = l10;
                n = LineClip.computeOutCode(l, l2, l5, l6, l7, l8);
                continue;
            }
            l3 = l9;
            l4 = l10;
            n2 = LineClip.computeOutCode(l3, l4, l5, l6, l7, l8);
        } while (!bl2);
        if (bl) {
            this.p1 = new Point((int)l, (int)l2);
            this.p2 = new Point((int)l3, (int)l4);
            return true;
        }
        return false;
    }

    private static int computeOutCode(long l, long l2, long l3, long l4, long l5, long l6) {
        int n = 0;
        if (l2 > l6) {
            n |= 2;
        } else if (l2 < l4) {
            n |= 8;
        }
        if (l > l5) {
            n |= 4;
        } else if (l < l3) {
            n |= 1;
        }
        return n;
    }
}

