/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.LassoModeAction;
import org.openstreetmap.josm.actions.mapmode.DeleteAction;
import org.openstreetmap.josm.actions.mapmode.DrawAction;
import org.openstreetmap.josm.actions.mapmode.ExtrudeAction;
import org.openstreetmap.josm.actions.mapmode.ImproveWayAccuracyAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.actions.mapmode.ParallelWayAction;
import org.openstreetmap.josm.actions.mapmode.SelectAction;
import org.openstreetmap.josm.actions.mapmode.ZoomAction;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.ViewportData;
import org.openstreetmap.josm.gui.FileDrop;
import org.openstreetmap.josm.gui.HideableButton;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MapStatus;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.ScrollViewport;
import org.openstreetmap.josm.gui.dialogs.ChangesetDialog;
import org.openstreetmap.josm.gui.dialogs.CommandStackDialog;
import org.openstreetmap.josm.gui.dialogs.ConflictDialog;
import org.openstreetmap.josm.gui.dialogs.DialogsPanel;
import org.openstreetmap.josm.gui.dialogs.FilterDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.MapPaintDialog;
import org.openstreetmap.josm.gui.dialogs.MinimapDialog;
import org.openstreetmap.josm.gui.dialogs.NotesDialog;
import org.openstreetmap.josm.gui.dialogs.RelationListDialog;
import org.openstreetmap.josm.gui.dialogs.SelectionListDialog;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.UserListDialog;
import org.openstreetmap.josm.gui.dialogs.ValidatorDialog;
import org.openstreetmap.josm.gui.dialogs.properties.PropertiesDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.util.AdvancedKeyPressDetector;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class MapFrame
extends JPanel
implements Destroyable,
MapView.LayerChangeListener {
    public MapMode mapMode;
    public final MapView mapView;
    public final transient AdvancedKeyPressDetector keyDetector = new AdvancedKeyPressDetector();
    private JComponent sideToolBar = new JToolBar(1);
    private final ButtonGroup toolBarActionsGroup = new ButtonGroup();
    private final JToolBar toolBarActions = new JToolBar(1);
    private final JToolBar toolBarToggle = new JToolBar(1);
    private final List<ToggleDialog> allDialogs = new ArrayList<ToggleDialog>();
    private final List<MapMode> mapModes = new ArrayList<MapMode>();
    private final List<IconToggleButton> allDialogButtons = new ArrayList<IconToggleButton>();
    public final List<IconToggleButton> allMapModeButtons = new ArrayList<IconToggleButton>();
    private final ListAllButtonsAction listAllDialogsAction = new ListAllButtonsAction(this.allDialogButtons);
    private final ListAllButtonsAction listAllMapModesAction = new ListAllButtonsAction(this.allMapModeButtons);
    private final JButton listAllToggleDialogsButton = new JButton(this.listAllDialogsAction);
    private final JButton listAllMapModesButton = new JButton(this.listAllMapModesAction);
    public ConflictDialog conflictDialog;
    public FilterDialog filterDialog;
    public RelationListDialog relationListDialog;
    public ValidatorDialog validatorDialog;
    public SelectionListDialog selectionListDialog;
    public PropertiesDialog propertiesDialog;
    public MapPaintDialog mapPaintDialog;
    public NotesDialog noteDialog;
    public final SelectAction mapModeSelect;
    public final DrawAction mapModeDraw;
    public final ZoomAction mapModeZoom;
    public LassoModeAction mapModeSelectLasso;
    private final transient Map<Layer, MapMode> lastMapMode;
    public MapStatus statusLine;
    private final JSplitPane splitPane;
    private final JPanel leftPanel;
    private final DialogsPanel dialogsPanel;
    public static final int DEF_TOGGLE_DLG_WIDTH = 330;
    private static final CopyOnWriteArrayList<MapModeChangeListener> mapModeChangeListeners = new CopyOnWriteArrayList();
    private transient Preferences.PreferenceChangedListener sidetoolbarPreferencesChangedListener;

    public MapFrame(JPanel jPanel, ViewportData viewportData) {
        boolean bl;
        this.listAllDialogsAction.setButton(this.listAllToggleDialogsButton);
        this.listAllMapModesAction.setButton(this.listAllMapModesButton);
        this.lastMapMode = new HashMap<Layer, MapMode>();
        this.setSize(400, 400);
        this.setLayout(new BorderLayout());
        this.mapView = new MapView(jPanel, viewportData);
        if (!GraphicsEnvironment.isHeadless()) {
            new FileDrop(this.mapView);
        }
        this.splitPane = new JSplitPane(1, true);
        this.leftPanel = new JPanel(new GridBagLayout());
        this.leftPanel.add((Component)this.mapView, GBC.std().fill());
        this.splitPane.setLeftComponent(this.leftPanel);
        this.dialogsPanel = new DialogsPanel(this.splitPane);
        this.splitPane.setRightComponent(this.dialogsPanel);
        this.splitPane.setResizeWeight(1.0);
        this.splitPane.setDividerSize(5);
        this.splitPane.setBorder(null);
        this.splitPane.setUI(new BasicSplitPaneUI(){

            @Override
            public BasicSplitPaneDivider createDefaultDivider() {
                return new BasicSplitPaneDivider(this){

                    @Override
                    public void setBorder(Border border) {
                    }
                };
            }
        });
        this.splitPane.getInputMap(1).put(KeyStroke.getKeyStroke(117, 0), new Object());
        this.splitPane.getInputMap(1).put(KeyStroke.getKeyStroke(119, 0), new Object());
        this.add((Component)this.splitPane, "Center");
        this.dialogsPanel.setLayout(new BoxLayout(this.dialogsPanel, 1));
        this.dialogsPanel.setPreferredSize(new Dimension(Main.pref.getInteger("toggleDialogs.width", 330), 0));
        this.dialogsPanel.setMinimumSize(new Dimension(24, 0));
        this.mapView.setMinimumSize(new Dimension(10, 0));
        this.mapModeSelect = new SelectAction(this);
        this.addMapMode(new IconToggleButton(this.mapModeSelect));
        this.mapModeSelectLasso = new LassoModeAction();
        this.addMapMode(new IconToggleButton(this.mapModeSelectLasso, true));
        this.mapModeDraw = new DrawAction(this);
        this.addMapMode(new IconToggleButton(this.mapModeDraw));
        this.mapModeZoom = new ZoomAction(this);
        this.addMapMode(new IconToggleButton(this.mapModeZoom));
        this.addMapMode(new IconToggleButton(new DeleteAction(this), true));
        this.addMapMode(new IconToggleButton(new ParallelWayAction(this), true));
        this.addMapMode(new IconToggleButton(new ExtrudeAction(this), true));
        this.addMapMode(new IconToggleButton(new ImproveWayAccuracyAction(Main.map), false));
        this.toolBarActionsGroup.setSelected(this.allMapModeButtons.get(0).getModel(), true);
        this.toolBarActions.setFloatable(false);
        LayerListDialog.createInstance(this);
        this.addToggleDialog(LayerListDialog.getInstance());
        this.propertiesDialog = new PropertiesDialog();
        this.addToggleDialog(this.propertiesDialog);
        this.selectionListDialog = new SelectionListDialog();
        this.addToggleDialog(this.selectionListDialog);
        this.relationListDialog = new RelationListDialog();
        this.addToggleDialog(this.relationListDialog);
        this.addToggleDialog(new MinimapDialog());
        this.addToggleDialog(new CommandStackDialog());
        this.addToggleDialog(new UserListDialog());
        this.conflictDialog = new ConflictDialog();
        this.addToggleDialog(this.conflictDialog);
        this.validatorDialog = new ValidatorDialog();
        this.addToggleDialog(this.validatorDialog);
        this.filterDialog = new FilterDialog();
        this.addToggleDialog(this.filterDialog);
        this.addToggleDialog(new ChangesetDialog(), true);
        this.mapPaintDialog = new MapPaintDialog();
        this.addToggleDialog(this.mapPaintDialog);
        this.noteDialog = new NotesDialog();
        this.addToggleDialog(this.noteDialog);
        this.toolBarToggle.setFloatable(false);
        this.statusLine = new MapStatus(this);
        MapView.addLayerChangeListener(this);
        boolean bl2 = bl = Shortcut.findShortcut(9, 0) != null;
        if (bl) {
            for (JComponent jComponent : this.allDialogButtons) {
                jComponent.setFocusTraversalKeysEnabled(false);
            }
            for (JComponent jComponent : this.allMapModeButtons) {
                jComponent.setFocusTraversalKeysEnabled(false);
            }
        }
        if (Main.pref.getBoolean("debug.advanced-keypress-detector.enable", true)) {
            this.keyDetector.register();
        }
    }

    public boolean selectSelectTool(boolean bl) {
        if (bl && !Main.pref.getBoolean("modeless", false)) {
            return false;
        }
        return this.selectMapMode(this.mapModeSelect);
    }

    public boolean selectDrawTool(boolean bl) {
        if (bl && !Main.pref.getBoolean("modeless", false)) {
            return false;
        }
        return this.selectMapMode(this.mapModeDraw);
    }

    public boolean selectZoomTool(boolean bl) {
        if (bl && !Main.pref.getBoolean("modeless", false)) {
            return false;
        }
        return this.selectMapMode(this.mapModeZoom);
    }

    @Override
    public void destroy() {
        int n;
        MapView.removeLayerChangeListener(this);
        this.dialogsPanel.destroy();
        Main.pref.removePreferenceChangeListener(this.sidetoolbarPreferencesChangedListener);
        for (n = 0; n < this.toolBarActions.getComponentCount(); ++n) {
            if (!(this.toolBarActions.getComponent(n) instanceof Destroyable)) continue;
            ((Destroyable)((Object)this.toolBarActions.getComponent(n))).destroy();
        }
        for (n = 0; n < this.toolBarToggle.getComponentCount(); ++n) {
            if (!(this.toolBarToggle.getComponent(n) instanceof Destroyable)) continue;
            ((Destroyable)((Object)this.toolBarToggle.getComponent(n))).destroy();
        }
        this.statusLine.destroy();
        this.mapView.destroy();
        this.keyDetector.unregister();
    }

    public Action getDefaultButtonAction() {
        return ((AbstractButton)this.toolBarActions.getComponent(0)).getAction();
    }

    public void initializeDialogsPane() {
        this.dialogsPanel.initialize(this.allDialogs);
    }

    public IconToggleButton addToggleDialog(ToggleDialog toggleDialog) {
        return this.addToggleDialog(toggleDialog, false);
    }

    public IconToggleButton addToggleDialog(ToggleDialog toggleDialog, boolean bl) {
        IconToggleButton iconToggleButton = new IconToggleButton(toggleDialog.getToggleAction(), bl);
        iconToggleButton.setShowHideButtonListener(toggleDialog);
        iconToggleButton.setInheritsPopupMenu(true);
        toggleDialog.setButton(iconToggleButton);
        this.toolBarToggle.add(iconToggleButton);
        this.allDialogs.add(toggleDialog);
        this.allDialogButtons.add(iconToggleButton);
        iconToggleButton.applyButtonHiddenPreferences();
        if (this.dialogsPanel.initialized) {
            this.dialogsPanel.add(toggleDialog);
        }
        return iconToggleButton;
    }

    public void addMapMode(IconToggleButton iconToggleButton) {
        if (!(iconToggleButton.getAction() instanceof MapMode)) {
            throw new IllegalArgumentException("MapMode action must be subclass of MapMode");
        }
        this.mapModes.add((MapMode)iconToggleButton.getAction());
        this.allMapModeButtons.add(iconToggleButton);
        this.toolBarActionsGroup.add(iconToggleButton);
        this.toolBarActions.add(iconToggleButton);
        iconToggleButton.applyButtonHiddenPreferences();
        iconToggleButton.setInheritsPopupMenu(true);
    }

    @Override
    public void setVisible(boolean bl) {
        boolean bl2 = this.isVisible();
        super.setVisible(bl);
        if (bl2 != bl) {
            this.firePropertyChange("visible", bl2, bl);
        }
    }

    public boolean selectMapMode(MapMode mapMode) {
        return this.selectMapMode(mapMode, this.mapView.getActiveLayer());
    }

    public boolean selectMapMode(MapMode mapMode, Layer layer) {
        if (mapMode == null || !mapMode.layerIsSupported(layer)) {
            return false;
        }
        MapMode mapMode2 = this.mapMode;
        if (mapMode == mapMode2) {
            return true;
        }
        if (mapMode2 != null) {
            mapMode2.exitMode();
        }
        this.mapMode = mapMode;
        mapMode.enterMode();
        this.lastMapMode.put(layer, mapMode);
        MapFrame.fireMapModeChanged(mapMode2, mapMode);
        return true;
    }

    public void fillPanel(Container container) {
        container.add((Component)this, "Center");
        if (Main.pref.getBoolean("sidetoolbar.mapmodes.visible", true)) {
            this.toolBarActions.setAlignmentX(0.5f);
            this.toolBarActions.setBorder(null);
            this.toolBarActions.setInheritsPopupMenu(true);
            this.sideToolBar.add(this.toolBarActions);
            this.listAllMapModesButton.setAlignmentX(0.5f);
            this.listAllMapModesButton.setBorder(null);
            this.listAllMapModesButton.setFont(this.listAllMapModesButton.getFont().deriveFont(0));
            this.listAllMapModesButton.setInheritsPopupMenu(true);
            this.sideToolBar.add(this.listAllMapModesButton);
        }
        if (Main.pref.getBoolean("sidetoolbar.toggledialogs.visible", true)) {
            ((JToolBar)this.sideToolBar).addSeparator(new Dimension(0, 18));
            this.toolBarToggle.setAlignmentX(0.5f);
            this.toolBarToggle.setBorder(null);
            this.toolBarToggle.setInheritsPopupMenu(true);
            this.sideToolBar.add(this.toolBarToggle);
            this.listAllToggleDialogsButton.setAlignmentX(0.5f);
            this.listAllToggleDialogsButton.setBorder(null);
            this.listAllToggleDialogsButton.setFont(this.listAllToggleDialogsButton.getFont().deriveFont(0));
            this.listAllToggleDialogsButton.setInheritsPopupMenu(true);
            this.sideToolBar.add(this.listAllToggleDialogsButton);
        }
        this.sideToolBar.setComponentPopupMenu(new SideToolbarPopupMenu());
        ((JToolBar)this.sideToolBar).setFloatable(false);
        this.sideToolBar.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        if (Main.pref.getBoolean("sidetoolbar.scrollable", true)) {
            final ScrollViewport scrollViewport = new ScrollViewport(this.sideToolBar, 3);
            scrollViewport.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                    scrollViewport.scroll(0, mouseWheelEvent.getUnitsToScroll() * 5);
                }
            });
            this.sideToolBar = scrollViewport;
        }
        this.sideToolBar.setVisible(Main.pref.getBoolean("sidetoolbar.visible", true));
        this.sidetoolbarPreferencesChangedListener = new Preferences.PreferenceChangedListener(){

            @Override
            public void preferenceChanged(Preferences.PreferenceChangeEvent preferenceChangeEvent) {
                if ("sidetoolbar.visible".equals(preferenceChangeEvent.getKey())) {
                    MapFrame.this.sideToolBar.setVisible(Main.pref.getBoolean("sidetoolbar.visible"));
                }
            }
        };
        Main.pref.addPreferenceChangeListener(this.sidetoolbarPreferencesChangedListener);
        container.add((Component)this.sideToolBar, "West");
        if (this.statusLine != null && Main.pref.getBoolean("statusline.visible", true)) {
            container.add((Component)this.statusLine, "South");
        }
    }

    public void validateToolBarsVisibility() {
        for (IconToggleButton iconToggleButton : this.allDialogButtons) {
            iconToggleButton.applyButtonHiddenPreferences();
        }
        this.toolBarToggle.repaint();
        for (IconToggleButton iconToggleButton : this.allMapModeButtons) {
            iconToggleButton.applyButtonHiddenPreferences();
        }
        this.toolBarActions.repaint();
    }

    public <T> T getToggleDialog(Class<T> clazz) {
        return this.dialogsPanel.getToggleDialog(clazz);
    }

    public void setDialogsPanelVisible(boolean bl) {
        this.rememberToggleDialogWidth();
        this.dialogsPanel.setVisible(bl);
        this.splitPane.setDividerLocation(bl ? this.splitPane.getWidth() - Main.pref.getInteger("toggleDialogs.width", 330) : 0);
        this.splitPane.setDividerSize(bl ? 5 : 0);
    }

    public void rememberToggleDialogWidth() {
        if (this.dialogsPanel.isVisible()) {
            Main.pref.putInteger("toggleDialogs.width", this.splitPane.getWidth() - this.splitPane.getDividerLocation());
        }
    }

    public void removeTopPanel(Class<?> clazz) {
        int n = this.leftPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.leftPanel.getComponent(i);
            if (!clazz.isInstance(component)) continue;
            this.leftPanel.remove(i);
            this.leftPanel.doLayout();
            return;
        }
    }

    public <T> T getTopPanel(Class<T> clazz) {
        int n = this.leftPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.leftPanel.getComponent(i);
            if (!clazz.isInstance(component)) continue;
            return clazz.cast(component);
        }
        return null;
    }

    public void addTopPanel(Component component) {
        this.leftPanel.add(component, GBC.eol().fill(2), this.leftPanel.getComponentCount() - 1);
        this.leftPanel.doLayout();
        component.doLayout();
    }

    public static void addMapModeChangeListener(MapModeChangeListener mapModeChangeListener) {
        if (mapModeChangeListener != null) {
            mapModeChangeListeners.addIfAbsent(mapModeChangeListener);
        }
    }

    public static void removeMapModeChangeListener(MapModeChangeListener mapModeChangeListener) {
        mapModeChangeListeners.remove(mapModeChangeListener);
    }

    protected static void fireMapModeChanged(MapMode mapMode, MapMode mapMode2) {
        for (MapModeChangeListener mapModeChangeListener : mapModeChangeListeners) {
            mapModeChangeListener.mapModeChange(mapMode, mapMode2);
        }
    }

    @Override
    public void activeLayerChange(Layer layer, Layer layer2) {
        boolean bl = false;
        if (this.mapMode == null || !this.mapMode.layerIsSupported(layer2)) {
            MapMode mapMode = this.getLastMapMode(layer2);
            boolean bl2 = bl = mapMode != this.mapMode;
            if (mapMode != null) {
                this.selectMapMode(mapMode, layer2);
            } else if (this.mapMode != null) {
                this.mapMode.exitMode();
            }
        }
        if (layer != null) {
            if (!bl && this.mapMode != null) {
                this.mapMode.exitMode();
                this.mapMode.enterMode();
            }
            Main.map.mapView.preferenceChanged(null);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MapFrame.this.validateToolBarsVisibility();
            }
        });
    }

    private MapMode getLastMapMode(Layer layer) {
        Action action;
        MapMode mapMode = this.lastMapMode.get(layer);
        if (mapMode == null && (action = this.getDefaultButtonAction()) instanceof MapMode && ((MapMode)action).layerIsSupported(layer)) {
            mapMode = (MapMode)action;
        }
        return mapMode;
    }

    @Override
    public void layerAdded(Layer layer) {
    }

    @Override
    public void layerRemoved(Layer layer) {
        this.lastMapMode.remove(layer);
    }

    public static interface MapModeChangeListener {
        public void mapModeChange(MapMode var1, MapMode var2);
    }

    class ListAllButtonsAction
    extends AbstractAction {
        private JButton button;
        private final transient Collection<? extends HideableButton> buttons;

        ListAllButtonsAction(Collection<? extends HideableButton> collection) {
            this.buttons = collection;
        }

        public void setButton(JButton jButton) {
            this.button = jButton;
            ImageIcon imageIcon = ImageProvider.get("audio-fwd");
            this.putValue("SmallIcon", imageIcon);
            jButton.setPreferredSize(new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight() + 64));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            Object object = this.buttons.iterator();
            while (object.hasNext()) {
                HideableButton hideableButton;
                final HideableButton hideableButton2 = hideableButton = object.next();
                jPopupMenu.add(new JCheckBoxMenuItem(new AbstractAction(){
                    {
                        this.putValue("Name", hideableButton2.getActionName());
                        this.putValue("SmallIcon", hideableButton2.getIcon());
                        this.putValue("SwingSelectedKey", hideableButton2.isButtonVisible());
                        this.putValue("ShortDescription", I18n.tr("Hide or show this toggle button", new Object[0]));
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (((Boolean)this.getValue("SwingSelectedKey")).booleanValue()) {
                            hideableButton2.showButton();
                        } else {
                            hideableButton2.hideButton();
                        }
                        MapFrame.this.validateToolBarsVisibility();
                    }
                }));
            }
            object = this.button.getBounds();
            jPopupMenu.show(this.button, ((Rectangle)object).x + ((Rectangle)object).width, 0);
        }
    }

    private final class SideToolbarPopupMenu
    extends JPopupMenu {
        private static final int staticMenuEntryCount = 2;
        private final JCheckBoxMenuItem doNotHide = new JCheckBoxMenuItem(new AbstractAction(I18n.tr("Do not hide toolbar", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ((JCheckBoxMenuItem)actionEvent.getSource()).getState();
                Main.pref.put("sidetoolbar.always-visible", bl);
            }
        });

        private SideToolbarPopupMenu() {
            this.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    final Component component = ((JPopupMenu)popupMenuEvent.getSource()).getInvoker();
                    if (component instanceof IconToggleButton) {
                        SideToolbarPopupMenu.this.insert(new JPopupMenu.Separator(), 0);
                        SideToolbarPopupMenu.this.insert(new AbstractAction(){
                            {
                                this.putValue("Name", I18n.tr("Hide this button", new Object[0]));
                                this.putValue("ShortDescription", I18n.tr("Click the arrow at the bottom to show it again.", new Object[0]));
                            }

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                ((IconToggleButton)component).setButtonHidden(true);
                                MapFrame.this.validateToolBarsVisibility();
                            }
                        }, 0);
                    }
                    SideToolbarPopupMenu.this.doNotHide.setSelected(Main.pref.getBoolean("sidetoolbar.always-visible", true));
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    while (SideToolbarPopupMenu.this.getComponentCount() > 2) {
                        SideToolbarPopupMenu.this.remove(0);
                    }
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }
            });
            this.add(new AbstractAction(I18n.tr("Hide edit toolbar", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Main.pref.put("sidetoolbar.visible", false);
                }
            });
            this.add(this.doNotHide);
        }
    }
}

