/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.oauth.OAuthParameters;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.oauth.AdvancedOAuthPropertiesPanel;
import org.openstreetmap.josm.gui.oauth.OAuthAuthorizationWizard;
import org.openstreetmap.josm.gui.oauth.TestAccessTokenTask;
import org.openstreetmap.josm.gui.preferences.server.OAuthAccessTokenHolder;
import org.openstreetmap.josm.gui.preferences.server.OsmApiUrlInputPanel;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.UserCancelException;

public class OAuthAuthenticationPreferencesPanel
extends JPanel
implements PropertyChangeListener {
    private JPanel pnlAuthorisationMessage;
    private NotYetAuthorisedPanel pnlNotYetAuthorised;
    private AlreadyAuthorisedPanel pnlAlreadyAuthorised;
    private AdvancedOAuthPropertiesPanel pnlAdvancedProperties;
    private String apiUrl;
    private JCheckBox cbShowAdvancedParameters;
    private JCheckBox cbSaveToPreferences;

    public OAuthAuthenticationPreferencesPanel() {
        this.build();
        this.refreshView();
    }

    protected JPanel buildAdvancedPropertiesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.cbShowAdvancedParameters = new JCheckBox();
        jPanel.add((Component)this.cbShowAdvancedParameters, gridBagConstraints);
        this.cbShowAdvancedParameters.setSelected(false);
        this.cbShowAdvancedParameters.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                OAuthAuthenticationPreferencesPanel.this.pnlAdvancedProperties.setVisible(itemEvent.getStateChange() == 1);
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        JMultilineLabel jMultilineLabel = new JMultilineLabel(I18n.tr("Display Advanced OAuth Parameters", new Object[0]));
        jMultilineLabel.setFont(jMultilineLabel.getFont().deriveFont(0));
        jPanel.add((Component)jMultilineLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlAdvancedProperties = new AdvancedOAuthPropertiesPanel();
        jPanel.add((Component)this.pnlAdvancedProperties, gridBagConstraints);
        this.pnlAdvancedProperties.initFromPreferences(Main.pref);
        this.pnlAdvancedProperties.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY, 1), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        this.pnlAdvancedProperties.setVisible(false);
        return jPanel;
    }

    protected final void build() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.pnlAuthorisationMessage = new JPanel(new BorderLayout());
        this.add((Component)this.pnlAuthorisationMessage, gridBagConstraints);
        this.pnlAlreadyAuthorised = new AlreadyAuthorisedPanel();
        this.pnlNotYetAuthorised = new NotYetAuthorisedPanel();
    }

    protected void refreshView() {
        this.pnlAuthorisationMessage.removeAll();
        if (OAuthAccessTokenHolder.getInstance().containsAccessToken()) {
            this.pnlAuthorisationMessage.add((Component)this.pnlAlreadyAuthorised, "Center");
            this.pnlAlreadyAuthorised.refreshView();
            this.pnlAlreadyAuthorised.revalidate();
        } else {
            this.pnlAuthorisationMessage.add((Component)this.pnlNotYetAuthorised, "Center");
            this.pnlNotYetAuthorised.revalidate();
        }
        this.repaint();
    }

    public void setApiUrl(String string) {
        this.apiUrl = string;
        this.pnlAdvancedProperties.setApiUrl(string);
    }

    public void initFromPreferences() {
        this.setApiUrl(OsmApi.getOsmApi().getServerUrl().trim());
        this.refreshView();
    }

    public void saveToPreferences() {
        OAuthAccessTokenHolder.getInstance().setSaveToPreferences(this.cbSaveToPreferences.isSelected());
        OAuthAccessTokenHolder.getInstance().save(Main.pref, CredentialsManager.getInstance());
        this.pnlAdvancedProperties.rememberPreferences(Main.pref);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!propertyChangeEvent.getPropertyName().equals(OsmApiUrlInputPanel.API_URL_PROP)) {
            return;
        }
        this.setApiUrl((String)propertyChangeEvent.getNewValue());
    }

    private class TestAuthorisationAction
    extends AbstractAction {
        TestAuthorisationAction() {
            this.putValue("Name", I18n.tr("Test Access Token", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Click test access to the OSM server with the current access token", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("oauth", "oauth-small"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OAuthToken oAuthToken = OAuthAccessTokenHolder.getInstance().getAccessToken();
            OAuthParameters oAuthParameters = OAuthParameters.createFromPreferences(Main.pref);
            TestAccessTokenTask testAccessTokenTask = new TestAccessTokenTask(OAuthAuthenticationPreferencesPanel.this, OAuthAuthenticationPreferencesPanel.this.apiUrl, oAuthParameters, oAuthToken);
            Main.worker.submit(testAccessTokenTask);
        }
    }

    private class RenewAuthorisationAction
    extends AuthoriseNowAction {
        RenewAuthorisationAction() {
            this.putValue("Name", I18n.tr("New Access Token", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Click to step through the OAuth authorization process and generate a new Access Token", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("oauth", "oauth-small"));
        }
    }

    private class AuthoriseNowAction
    extends AbstractAction {
        AuthoriseNowAction() {
            this.putValue("Name", I18n.tr("Authorize now", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Click to step through the OAuth authorization process", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("oauth", "oauth-small"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OAuthAuthorizationWizard oAuthAuthorizationWizard = new OAuthAuthorizationWizard(OAuthAuthenticationPreferencesPanel.this, OAuthAuthenticationPreferencesPanel.this.apiUrl, Main.worker);
            try {
                oAuthAuthorizationWizard.showDialog();
            }
            catch (UserCancelException userCancelException) {
                Main.trace(userCancelException.toString());
                return;
            }
            OAuthAuthenticationPreferencesPanel.this.pnlAdvancedProperties.setAdvancedParameters(oAuthAuthorizationWizard.getOAuthParameters());
            OAuthAuthenticationPreferencesPanel.this.refreshView();
        }
    }

    private class AlreadyAuthorisedPanel
    extends JPanel {
        private JosmTextField tfAccessTokenKey;
        private JosmTextField tfAccessTokenSecret;

        AlreadyAuthorisedPanel() {
            this.build();
            this.refreshView();
        }

        protected void build() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(0, 0, 3, 3);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 2;
            JMultilineLabel jMultilineLabel = new JMultilineLabel(I18n.tr("You already have an Access Token to access the OSM server using OAuth.", new Object[0]));
            this.add((Component)jMultilineLabel, gridBagConstraints);
            jMultilineLabel.setFont(jMultilineLabel.getFont().deriveFont(0));
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            this.add((Component)new JLabel(I18n.tr("Access Token Key:", new Object[0])), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            this.tfAccessTokenKey = new JosmTextField();
            this.add((Component)this.tfAccessTokenKey, gridBagConstraints);
            this.tfAccessTokenKey.setEditable(false);
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            this.add((Component)new JLabel(I18n.tr("Access Token Secret:", new Object[0])), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            this.tfAccessTokenSecret = new JosmTextField();
            this.add((Component)this.tfAccessTokenSecret, gridBagConstraints);
            this.tfAccessTokenSecret.setEditable(false);
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)(OAuthAuthenticationPreferencesPanel.this.cbSaveToPreferences = new JCheckBox(I18n.tr("Save to preferences", new Object[0]))), gridBagConstraints);
            OAuthAuthenticationPreferencesPanel.this.cbSaveToPreferences.setSelected(OAuthAccessTokenHolder.getInstance().isSaveToPreferences());
            JPanel jPanel = new JPanel(new FlowLayout(0));
            jPanel.add(new SideButton(new RenewAuthorisationAction()));
            jPanel.add(new SideButton(new TestAuthorisationAction()));
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)jPanel, gridBagConstraints);
            gridBagConstraints.gridy = 5;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)OAuthAuthenticationPreferencesPanel.this.buildAdvancedPropertiesPanel(), gridBagConstraints);
            gridBagConstraints.gridy = 6;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)new JPanel(), gridBagConstraints);
        }

        protected final void refreshView() {
            String string = OAuthAccessTokenHolder.getInstance().getAccessTokenKey();
            this.tfAccessTokenKey.setText(string == null ? "" : string);
            string = OAuthAccessTokenHolder.getInstance().getAccessTokenSecret();
            this.tfAccessTokenSecret.setText(string == null ? "" : string);
            OAuthAuthenticationPreferencesPanel.this.cbSaveToPreferences.setSelected(OAuthAccessTokenHolder.getInstance().isSaveToPreferences());
        }
    }

    private class NotYetAuthorisedPanel
    extends JPanel {
        NotYetAuthorisedPanel() {
            this.build();
        }

        protected void build() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(0, 0, 3, 0);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            JMultilineLabel jMultilineLabel = new JMultilineLabel(I18n.tr("You do not have an Access Token yet to access the OSM server using OAuth. Please authorize first.", new Object[0]));
            this.add((Component)jMultilineLabel, gridBagConstraints);
            jMultilineLabel.setFont(jMultilineLabel.getFont().deriveFont(0));
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            this.add((Component)new SideButton(new AuthoriseNowAction()), gridBagConstraints);
            gridBagConstraints.gridy = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)new JPanel(), gridBagConstraints);
        }
    }
}

