/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.runtime.ThreadContext;

public class UnboxedBoolean
extends ImmutableLiteral {
    private final boolean truthy;
    public static final UnboxedBoolean TRUE = new UnboxedBoolean(true);
    public static final UnboxedBoolean FALSE = new UnboxedBoolean(false);

    public UnboxedBoolean(boolean truthy) {
        this.truthy = truthy;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.UNBOXED_BOOLEAN;
    }

    @Override
    public Object createCacheObject(ThreadContext context) {
        return context.runtime.newBoolean(this.isTrue());
    }

    public boolean isTrue() {
        return this.truthy;
    }

    public boolean isFalse() {
        return !this.truthy;
    }

    public boolean equals(Object other) {
        return other instanceof UnboxedBoolean && this.truthy == ((UnboxedBoolean)other).truthy;
    }

    public int hashCode() {
        return 287 + (this.truthy ? 1 : 0);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.UnboxedBoolean(this);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.truthy);
    }

    public static UnboxedBoolean decode(IRReaderDecoder d) {
        return d.decodeBoolean() ? TRUE : FALSE;
    }

    public String toString() {
        return this.isTrue() ? "true" : "false";
    }
}

