/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.format.nodes.write;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import org.jruby.truffle.format.nodes.PackNode;
import org.jruby.truffle.format.runtime.exceptions.NoImplicitConversionException;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.util.ByteList;
import org.jruby.util.Pack;

@NodeChildren(value={@NodeChild(value="value", type=PackNode.class)})
public abstract class WriteBase64StringNode
extends PackNode {
    private final int length;
    private final boolean ignoreStar;

    public WriteBase64StringNode(RubyContext context, int length, boolean ignoreStar) {
        super(context);
        this.length = length;
        this.ignoreStar = ignoreStar;
    }

    @Specialization
    public Object write(long bytes) {
        throw new NoImplicitConversionException(bytes, "String");
    }

    @Specialization
    public Object write(VirtualFrame frame, ByteList bytes) {
        this.writeBytes(frame, this.encode(bytes));
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    private byte[] encode(ByteList bytes) {
        ByteList output = new ByteList();
        Pack.encodeUM(null, (ByteList)bytes, (int)this.length, (boolean)this.ignoreStar, (char)'m', (ByteList)output);
        return output.bytes();
    }
}

