/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.BDFontMetrics;
import java.awt.BDGraphicsConfiguration;
import java.awt.BDGraphicsEnvironment;
import java.awt.BDImage;
import java.awt.BDImageConsumer;
import java.awt.BDRootWindow;
import java.awt.BDToolkit;
import java.awt.BDWindowGraphics;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.videolan.BDJXletContext;
import org.videolan.Logger;
import sun.awt.image.ByteArrayImageSource;
import sun.awt.image.FileImageSource;
import sun.awt.image.URLImageSource;

abstract class BDToolkitBase
extends Toolkit {
    private EventQueue eventQueue = new EventQueue();
    private BDGraphicsEnvironment localEnv = new BDGraphicsEnvironment();
    private BDGraphicsConfiguration defaultGC = (BDGraphicsConfiguration)this.localEnv.getDefaultScreenDevice().getDefaultConfiguration();
    private static Hashtable cachedImages = new Hashtable();
    private static final Logger logger = Logger.getLogger(BDToolkit.class.getName());
    private static final Map contextMap = Collections.synchronizedMap(new WeakHashMap());

    public static void setFocusedWindow(Window window) {
    }

    public static void shutdownDisc() {
        try {
            Toolkit toolkit = BDToolkitBase.getDefaultToolkit();
            if (toolkit instanceof BDToolkit) {
                ((BDToolkit)toolkit).shutdown();
            }
        }
        catch (Throwable t) {
            logger.error("shutdownDisc() failed: " + t + "\n" + Logger.dumpStack(t));
        }
    }

    protected void shutdown() {
        cachedImages.clear();
        contextMap.clear();
    }

    public Dimension getScreenSize() {
        Rectangle dims = this.defaultGC.getBounds();
        return new Dimension(dims.width, dims.height);
    }

    Graphics getGraphics(Window window) {
        if (!(window instanceof BDRootWindow)) {
            logger.error("getGraphics(): not BDRootWindow");
            throw new Error("Not implemented");
        }
        return new BDWindowGraphics((BDRootWindow)window);
    }

    GraphicsEnvironment getLocalGraphicsEnvironment() {
        return this.localEnv;
    }

    public int getScreenResolution() {
        return 72;
    }

    public ColorModel getColorModel() {
        return this.defaultGC.getColorModel();
    }

    public String[] getFontList() {
        return BDFontMetrics.getFontList();
    }

    public FontMetrics getFontMetrics(Font font) {
        return BDFontMetrics.getFontMetrics(font);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCache(BDImage image) {
        Hashtable hashtable = cachedImages;
        synchronized (hashtable) {
            Iterator i = cachedImages.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                if (entry.getValue() != image) continue;
                i.remove();
                return;
            }
        }
    }

    public Image getImage(String filename) {
        if (cachedImages.containsKey(filename)) {
            return (Image)cachedImages.get(filename);
        }
        Image newImage = this.createImage(filename);
        if (newImage != null) {
            cachedImages.put(filename, newImage);
        }
        return newImage;
    }

    public Image getImage(URL url) {
        if (cachedImages.containsKey(url)) {
            return (Image)cachedImages.get(url);
        }
        Image newImage = this.createImage(url);
        if (newImage != null) {
            cachedImages.put(url, newImage);
        }
        return newImage;
    }

    public Image createImage(String filename) {
        String home;
        if (!new File(filename).isAbsolute() && (home = BDJXletContext.getCurrentXletHome()) != null) {
            String homeFile = home + filename;
            if (new File(homeFile).exists()) {
                logger.warning("resource translated to " + homeFile);
                filename = homeFile;
            } else {
                logger.error("resource " + homeFile + " does not exist");
            }
        }
        FileImageSource ip = new FileImageSource(filename);
        Image newImage = this.createImage(ip);
        return newImage;
    }

    public Image createImage(URL url) {
        URLImageSource ip = new URLImageSource(url);
        Image newImage = this.createImage(ip);
        return newImage;
    }

    public Image createImage(byte[] imagedata, int imageoffset, int imagelength) {
        ByteArrayImageSource ip = new ByteArrayImageSource(imagedata, imageoffset, imagelength);
        Image newImage = this.createImage(ip);
        return newImage;
    }

    public Image createImage(ImageProducer producer) {
        return new BDImageConsumer(producer);
    }

    public Image createImage(Component component, int width, int height) {
        return new BDImage(component, width, height, this.defaultGC);
    }

    public boolean prepareImage(Image image, int width, int height, ImageObserver observer) {
        if (!(image instanceof BDImageConsumer)) {
            return true;
        }
        BDImageConsumer img = (BDImageConsumer)image;
        return img.prepareImage(observer);
    }

    public int checkImage(Image image, int width, int height, ImageObserver observer) {
        if (!(image instanceof BDImageConsumer)) {
            return 32;
        }
        BDImageConsumer img = (BDImageConsumer)image;
        return img.checkImage(observer);
    }

    public void beep() {
    }

    public static void addComponent(Component component) {
        BDJXletContext context = BDJXletContext.getCurrentContext();
        if (context == null) {
            logger.warning("addComponent() outside of app context");
            return;
        }
        contextMap.put(component, context);
    }

    public static EventQueue getEventQueue(Component component) {
        if (component != null) {
            do {
                BDJXletContext ctx;
                if ((ctx = (BDJXletContext)contextMap.get(component)) == null) continue;
                EventQueue eq = ctx.getEventQueue();
                if (eq == null) {
                    logger.warning("getEventQueue() failed: no context event queue");
                }
                return eq;
            } while ((component = component.getParent()) != null);
            logger.warning("getEventQueue() failed: no context");
            return null;
        }
        logger.warning("getEventQueue() failed: no component");
        return null;
    }

    protected EventQueue getSystemEventQueueImpl() {
        EventQueue eq;
        BDJXletContext ctx = BDJXletContext.getCurrentContext();
        if (ctx != null && (eq = ctx.getEventQueue()) != null) {
            return eq;
        }
        logger.warning("getSystemEventQueue(): no context   from:" + logger.dumpStack());
        return this.eventQueue;
    }
}

