/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.controller.Controller;
import freemind.controller.filter.Filter;
import freemind.controller.filter.FilterInfo;
import freemind.extensions.DontSaveMarker;
import freemind.extensions.NodeHook;
import freemind.extensions.PermanentNodeHook;
import freemind.main.FreeMindMain;
import freemind.main.HtmlTools;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.main.XMLElement;
import freemind.modes.ArrowLinkAdapter;
import freemind.modes.HistoryInformation;
import freemind.modes.MindIcon;
import freemind.modes.MindMap;
import freemind.modes.MindMapCloud;
import freemind.modes.MindMapEdge;
import freemind.modes.MindMapLinkRegistry;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.attributes.Attribute;
import freemind.modes.attributes.NodeAttributeTableModel;
import freemind.preferences.FreemindPropertyListener;
import freemind.view.mindmapview.NodeView;
import freemind.view.mindmapview.NodeViewVisitor;
import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class NodeAdapter
implements MindMapNode {
    static final int SHIFT = -2;
    public static final int HGAP = 20;
    public static final int VGAP = 3;
    public static final int LEFT_POSITION = -1;
    public static final int RIGHT_POSITION = 1;
    public static final int UNKNOWN_POSITION = 0;
    private HashSet activatedHooks;
    private List hooks;
    protected Object userObject = "no text";
    private String xmlText = "no text";
    private String link = null;
    private TreeMap toolTip = null;
    protected String style;
    protected Vector icons = null;
    protected TreeMap stateIcons = null;
    protected MindMapCloud cloud;
    protected Color color;
    protected Color backgroundColor;
    protected boolean folded;
    private int position = 0;
    private int vGap = 3;
    private int hGap = 20;
    private int shiftY = 0;
    protected List children;
    private MindMapNode preferredChild;
    protected Font font;
    protected boolean underlined = false;
    private FilterInfo filterInfo = new FilterInfo();
    private MindMapNode parent;
    private MindMapEdge edge;
    private Collection views = null;
    private FreeMindMain frame;
    private static final boolean ALLOWSCHILDREN = true;
    private static final boolean ISLEAF = false;
    private static final NodeAttributeTableModel EMTPY_ATTRIBUTES = new NodeAttributeTableModel(null){

        @Override
        public void insertRow(int index, String name, String value) {
            throw new IllegalArgumentException("Can't set attributes in the EMTPY_ATTRIBUTES table.");
        }

        @Override
        public void addRowNoUndo(Attribute newAttribute) {
            throw new IllegalArgumentException("Can't set attributes in the EMTPY_ATTRIBUTES table.");
        }

        @Override
        public Vector getAttributes() {
            return new Vector();
        }
    };
    private HistoryInformation historyInformation = null;
    protected static Logger logger;
    private MindMap map = null;
    private NodeAttributeTableModel attributes;
    private String noteText;
    private String xmlNoteText;
    private static FreemindPropertyListener sSaveIdPropertyChangeListener;
    private static boolean sSaveOnlyIntrinsicallyNeededIds;
    EventListenerList listenerList = new EventListenerList();

    protected NodeAdapter(FreeMindMain frame, MindMap map) {
        this(null, frame, map);
    }

    protected NodeAdapter(Object userObject, FreeMindMain frame, MindMap map) {
        this.frame = frame;
        this.setText((String)userObject);
        this.hooks = null;
        this.activatedHooks = null;
        if (logger == null) {
            logger = frame.getLogger(this.getClass().getName());
        }
        this.setHistoryInformation(new HistoryInformation());
        this.map = map;
        this.attributes = EMTPY_ATTRIBUTES;
        if (sSaveIdPropertyChangeListener == null) {
            sSaveIdPropertyChangeListener = new FreemindPropertyListener(){

                @Override
                public void propertyChanged(String propertyName, String newValue, String oldValue) {
                    if (propertyName.equals("save_only_intrisically_needed_ids")) {
                        sSaveOnlyIntrinsicallyNeededIds = Boolean.valueOf(newValue);
                    }
                }
            };
            Controller.addPropertyChangeListenerAndPropagate(sSaveIdPropertyChangeListener);
        }
    }

    public void setMap(MindMap map) {
        this.map = map;
        map.getRegistry().registrySubtree(this, true);
    }

    @Override
    public String getText() {
        String string = "";
        if (this.userObject != null) {
            string = this.userObject.toString();
        }
        return string;
    }

    @Override
    public final void setText(String text) {
        if (text == null) {
            this.userObject = null;
            this.xmlText = null;
            return;
        }
        this.userObject = HtmlTools.makeValidXml(text);
        this.xmlText = HtmlTools.getInstance().toXhtml((String)this.userObject);
    }

    @Override
    public final String getXmlText() {
        return this.xmlText;
    }

    @Override
    public final void setXmlText(String pXmlText) {
        this.xmlText = HtmlTools.makeValidXml(pXmlText);
        this.userObject = HtmlTools.getInstance().toHtml(this.xmlText);
    }

    @Override
    public final String getXmlNoteText() {
        return this.xmlNoteText;
    }

    @Override
    public final String getNoteText() {
        return this.noteText;
    }

    @Override
    public final void setXmlNoteText(String pXmlNoteText) {
        if (pXmlNoteText == null) {
            this.xmlNoteText = null;
            this.noteText = null;
            return;
        }
        this.xmlNoteText = HtmlTools.makeValidXml(pXmlNoteText);
        this.noteText = HtmlTools.getInstance().toHtml(this.xmlNoteText);
    }

    @Override
    public final void setNoteText(String pNoteText) {
        if (pNoteText == null) {
            this.xmlNoteText = null;
            this.noteText = null;
            return;
        }
        this.noteText = HtmlTools.makeValidXml(pNoteText);
        this.xmlNoteText = HtmlTools.getInstance().toXhtml(this.noteText);
    }

    @Override
    public String getPlainTextContent() {
        return this.toString();
    }

    @Override
    public String getLink() {
        return this.link;
    }

    @Override
    public String getShortText(ModeController controller) {
        String adaptedText = this.getPlainTextContent();
        if (adaptedText.length() > 40) {
            adaptedText = adaptedText.substring(0, 40) + " ...";
        }
        return adaptedText;
    }

    @Override
    public void setLink(String link) {
        if (link != null && link.startsWith("#")) {
            this.getMap().getLinkRegistry().registerLocalHyperlinkId(link.substring(1));
        }
        this.link = link;
    }

    @Override
    public FilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    public FreeMindMain getFrame() {
        return this.frame;
    }

    @Override
    public Collection getViewers() {
        if (this.views == null) {
            this.views = new LinkedList();
        }
        return this.views;
    }

    @Override
    public void addViewer(NodeView viewer) {
        this.getViewers().add(viewer);
        this.addTreeModelListener(viewer);
    }

    @Override
    public void removeViewer(NodeView viewer) {
        this.getViewers().remove(viewer);
        this.removeTreeModelListener(viewer);
    }

    @Override
    public TreePath getPath() {
        Vector pathVector = new Vector();
        this.addToPathVector(pathVector);
        TreePath treePath = new TreePath(pathVector.toArray());
        return treePath;
    }

    @Override
    public MindMapEdge getEdge() {
        return this.edge;
    }

    public void setEdge(MindMapEdge edge) {
        this.edge = edge;
    }

    @Override
    public MindMapCloud getCloud() {
        return this.cloud;
    }

    @Override
    public void setCloud(MindMapCloud cloud) {
        if (cloud != null && this.cloud == null) {
            this.changeChildCloudIterativeLevels(1);
        } else if (cloud == null && this.cloud != null) {
            this.changeChildCloudIterativeLevels(-1);
        }
        this.cloud = cloud;
    }

    private void changeChildCloudIterativeLevels(int deltaLevel) {
        ListIterator e = this.childrenUnfolded();
        while (e.hasNext()) {
            NodeAdapter childNode = (NodeAdapter)e.next();
            MindMapCloud childCloud = childNode.getCloud();
            if (childCloud != null) {
                childCloud.changeIterativeLevel(deltaLevel);
            }
            childNode.changeChildCloudIterativeLevels(deltaLevel);
        }
    }

    @Override
    public String getStyle() {
        String returnedString = this.style;
        if (this.style == null) {
            String stdstyle;
            returnedString = this.isRoot() ? this.getFrame().getProperty("standardrootnodestyle") : ((stdstyle = this.getFrame().getProperty("standardnodestyle")).equals("as_parent") ? this.getParentNode().getStyle() : stdstyle);
        } else if (this.isRoot() && this.style.equals("as_parent")) {
            returnedString = this.getFrame().getProperty("standardrootnodestyle");
        } else if (this.style.equals("as_parent")) {
            returnedString = this.getParentNode().getStyle();
        }
        if (returnedString.equals("combined")) {
            if (this.isFolded()) {
                return "bubble";
            }
            return "fork";
        }
        return returnedString;
    }

    @Override
    public boolean hasStyle() {
        return this.style != null;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setStyle(String style) {
        this.style = style;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public void establishOwnFont() {
        this.font = this.font != null ? this.font : this.getFrame().getController().getDefaultFont();
    }

    public void setBold(boolean bold) {
        if (bold != this.isBold()) {
            this.toggleBold();
        }
    }

    public void toggleBold() {
        this.establishOwnFont();
        this.setFont(this.getFrame().getController().getFontThroughMap(new Font(this.font.getFamily(), this.font.getStyle() ^ 1, this.font.getSize())));
    }

    public void setItalic(boolean italic) {
        if (italic != this.isItalic()) {
            this.toggleItalic();
        }
    }

    public void toggleItalic() {
        this.establishOwnFont();
        this.setFont(this.getFrame().getController().getFontThroughMap(new Font(this.font.getFamily(), this.font.getStyle() ^ 2, this.font.getSize())));
    }

    public void setUnderlined(boolean underlined) {
        this.underlined = underlined;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
    }

    @Override
    public MindMapNode getParentNode() {
        return this.parent;
    }

    @Override
    public void setFontSize(int fontSize) {
        this.establishOwnFont();
        this.setFont(this.getFrame().getController().getFontThroughMap(new Font(this.font.getFamily(), this.font.getStyle(), fontSize)));
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public String getFontSize() {
        if (this.getFont() != null) {
            return new Integer(this.getFont().getSize()).toString();
        }
        return this.getFrame().getProperty("defaultfontsize");
    }

    @Override
    public String getFontFamilyName() {
        if (this.getFont() != null) {
            return this.getFont().getFamily();
        }
        return this.getFrame().getProperty("defaultfont");
    }

    @Override
    public boolean isBold() {
        return this.font != null ? this.font.isBold() : false;
    }

    @Override
    public boolean isItalic() {
        return this.font != null ? this.font.isItalic() : false;
    }

    @Override
    public boolean isUnderlined() {
        return this.underlined;
    }

    @Override
    public boolean isFolded() {
        return this.folded;
    }

    @Override
    public List getIcons() {
        if (this.icons == null) {
            return Collections.EMPTY_LIST;
        }
        return this.icons;
    }

    @Override
    public MindMap getMap() {
        return this.map;
    }

    @Override
    public void addIcon(MindIcon _icon, int position) {
        this.createIcons();
        if (position == -1) {
            this.icons.add(_icon);
        } else {
            this.icons.add(position, _icon);
        }
        this.getMap().getRegistry().addIcon(_icon);
    }

    @Override
    public int removeIcon(int position) {
        this.createIcons();
        if (position == -1) {
            position = this.icons.size() - 1;
        }
        this.icons.remove(position);
        int returnSize = this.icons.size();
        if (returnSize == 0) {
            this.icons = null;
        }
        return returnSize;
    }

    public boolean hasFoldedStrictDescendant() {
        ListIterator e = this.childrenUnfolded();
        while (e.hasNext()) {
            NodeAdapter child = (NodeAdapter)e.next();
            if (!child.isFolded() && !child.hasFoldedStrictDescendant()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasFoldedParents() {
        if (this.isRoot()) {
            return false;
        }
        if (this.getParentNode().isFolded()) {
            return true;
        }
        return this.getParentNode().hasFoldedParents();
    }

    @Override
    public void setFolded(boolean folded) {
        this.folded = folded;
    }

    @Override
    public MindMapNode shallowCopy() {
        try {
            StringWriter writer = new StringWriter();
            this.save(writer, this.getMap().getLinkRegistry(), true, false);
            String result = writer.toString();
            HashMap IDToTarget = new HashMap();
            MindMapNode copy = this.getModeController().createNodeTreeFromXml(new StringReader(result), IDToTarget);
            copy.setFolded(false);
            return copy;
        }
        catch (Exception e) {
            Resources.getInstance().logException(e);
            return null;
        }
    }

    @Override
    public String toString() {
        return this.getText();
    }

    @Override
    public boolean isDescendantOf(MindMapNode pParentNode) {
        if (this.isRoot()) {
            return false;
        }
        if (pParentNode == this.getParentNode()) {
            return true;
        }
        return this.getParentNode().isDescendantOf(pParentNode);
    }

    @Override
    public boolean isRoot() {
        return this.parent == null;
    }

    @Override
    public boolean isDescendantOfOrEqual(MindMapNode pParentNode) {
        if (this == pParentNode) {
            return true;
        }
        return this.isDescendantOf(pParentNode);
    }

    @Override
    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    @Override
    public int getChildPosition(MindMapNode childNode) {
        int position = 0;
        ListIterator i = this.children.listIterator();
        while (i.hasNext()) {
            if ((MindMapNode)i.next() == childNode) {
                return position;
            }
            ++position;
        }
        return -1;
    }

    @Override
    public ListIterator childrenUnfolded() {
        return this.children != null ? this.children.listIterator() : Collections.EMPTY_LIST.listIterator();
    }

    @Override
    public ListIterator sortedChildrenUnfolded() {
        if (this.children == null) {
            return null;
        }
        LinkedList sorted = new LinkedList(this.children);
        Collections.sort(sorted, new Comparator(){

            public int compare(Object pO1, Object pO2) {
                return this.comp(((MindMapNode)pO2).isLeft(), ((MindMapNode)pO1).isLeft());
            }

            private int comp(boolean pLeft, boolean pLeft2) {
                if (pLeft == pLeft2) {
                    return 0;
                }
                if (pLeft) {
                    return 1;
                }
                return -1;
            }
        });
        return sorted.listIterator();
    }

    @Override
    public ListIterator childrenFolded() {
        if (this.isFolded()) {
            return Collections.EMPTY_LIST.listIterator();
        }
        return this.childrenUnfolded();
    }

    @Override
    public List getChildren() {
        return Collections.unmodifiableList(this.children != null ? this.children : Collections.EMPTY_LIST);
    }

    public Enumeration children() {
        throw new UnsupportedOperationException("Use childrenFolded or childrenUnfolded instead");
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.children.indexOf((MindMapNode)node);
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    @Override
    public boolean isLeft() {
        if (this.getParent() != null && !this.getParentNode().isRoot()) {
            return this.getParentNode().isLeft();
        }
        if (this.position == 0 && !this.isRoot()) {
            this.setLeft(this.getParentNode().isLeft());
        }
        return this.position == -1;
    }

    @Override
    public void setLeft(boolean isLeft) {
        int n = this.position = isLeft ? -1 : 1;
        if (!this.isRoot()) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                NodeAdapter child = (NodeAdapter)this.getChildAt(i);
                child.position = this.position;
            }
        }
    }

    @Override
    public boolean isNewChildLeft() {
        if (!this.isRoot()) {
            return this.isLeft();
        }
        int rightChildrenCount = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (!((MindMapNode)this.getChildAt(i)).isLeft()) {
                ++rightChildrenCount;
            }
            if (rightChildrenCount <= this.getChildCount() / 2) continue;
            return true;
        }
        return false;
    }

    @Override
    public void insert(MutableTreeNode child, int index) {
        logger.finest("Insert at " + index + " the node " + child);
        MindMapNode childNode = (MindMapNode)child;
        if (index < 0) {
            index = this.getChildCount();
            this.children.add(index, child);
        } else {
            this.children.add(index, child);
            this.preferredChild = childNode;
        }
        child.setParent(this);
        this.recursiveCallAddChildren(this, childNode);
    }

    @Override
    public void remove(int index) {
        MutableTreeNode node = (MutableTreeNode)this.children.get(index);
        this.remove(node);
    }

    @Override
    public void remove(MutableTreeNode node) {
        if (node == this.preferredChild) {
            int index = this.children.indexOf(node);
            this.preferredChild = this.children.size() > index + 1 ? (MindMapNode)this.children.get(index + 1) : (index > 0 ? (MindMapNode)this.children.get(index - 1) : null);
        }
        node.setParent(null);
        this.children.remove(node);
        this.recursiveCallRemoveChildren(this, (MindMapNode)node, this);
    }

    private void recursiveCallAddChildren(MindMapNode node, MindMapNode addedChild) {
        if (node instanceof MindMapNode) {
            for (PermanentNodeHook hook : node.getActivatedHooks()) {
                if (addedChild.getParentNode() == node) {
                    hook.onAddChild(addedChild);
                }
                hook.onAddChildren(addedChild);
            }
        }
        if (!node.isRoot() && node.getParentNode() != null) {
            this.recursiveCallAddChildren(node.getParentNode(), addedChild);
        }
    }

    private void recursiveCallRemoveChildren(MindMapNode node, MindMapNode removedChild, MindMapNode oldDad) {
        for (PermanentNodeHook hook : node.getActivatedHooks()) {
            if (removedChild.getParentNode() == node) {
                hook.onRemoveChild(removedChild);
            }
            hook.onRemoveChildren(removedChild, oldDad);
        }
        if (!node.isRoot() && node.getParentNode() != null) {
            this.recursiveCallRemoveChildren(node.getParentNode(), removedChild, oldDad);
        }
    }

    @Override
    public void removeFromParent() {
        this.parent.remove(this);
    }

    @Override
    public void setParent(MutableTreeNode newParent) {
        this.parent = (MindMapNode)newParent;
    }

    public void setParent(MindMapNode newParent) {
        this.parent = newParent;
    }

    @Override
    public void setUserObject(Object object) {
        this.setText((String)object);
    }

    private void addToPathVector(Vector pathVector) {
        pathVector.add(0, this);
        if (this.parent != null) {
            ((NodeAdapter)this.parent).addToPathVector(pathVector);
        }
    }

    @Override
    public int getNodeLevel() {
        int level = 0;
        MindMapNode parent = this;
        while (!parent.isRoot()) {
            if (parent.isVisible()) {
                ++level;
            }
            parent = parent.getParentNode();
        }
        return level;
    }

    @Override
    public PermanentNodeHook addHook(PermanentNodeHook hook) {
        if (hook == null) {
            throw new IllegalArgumentException("Added null hook.");
        }
        this.createHooks();
        this.hooks.add(hook);
        return hook;
    }

    @Override
    public void invokeHook(NodeHook hook) {
        hook.startupMapHook();
        hook.setNode(this);
        try {
            hook.invoke(this);
        }
        catch (Exception e) {
            Resources.getInstance().logException(e);
            return;
        }
        if (hook instanceof PermanentNodeHook) {
            this.createActivatedHooks();
            this.activatedHooks.add(hook);
        } else {
            hook.shutdownMapHook();
        }
    }

    private void createActivatedHooks() {
        if (this.activatedHooks == null) {
            this.activatedHooks = new HashSet();
        }
    }

    private void createToolTip() {
        if (this.toolTip == null) {
            this.toolTip = new TreeMap();
        }
    }

    private void createHooks() {
        if (this.hooks == null) {
            this.hooks = new Vector();
        }
    }

    private void createStateIcons() {
        if (this.stateIcons == null) {
            this.stateIcons = new TreeMap();
        }
    }

    private void createIcons() {
        if (this.icons == null) {
            this.icons = new Vector();
        }
    }

    @Override
    public List getHooks() {
        if (this.hooks == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.hooks);
    }

    @Override
    public Collection getActivatedHooks() {
        if (this.activatedHooks == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(this.activatedHooks);
    }

    @Override
    public void removeHook(PermanentNodeHook hook) {
        String name = hook.getName();
        this.createActivatedHooks();
        if (this.activatedHooks.contains(hook)) {
            this.activatedHooks.remove(hook);
            if (this.activatedHooks.size() == 0) {
                this.activatedHooks = null;
            }
            hook.shutdownMapHook();
        }
        this.createHooks();
        this.hooks.remove(hook);
        if (this.hooks.size() == 0) {
            this.hooks = null;
        }
        logger.fine("Removed hook " + name + " at " + hook + ".");
    }

    @Override
    public void removeAllHooks() {
        int timeout = this.getHooks().size() * 2;
        while (this.getHooks().size() > 0 && timeout-- > 0) {
            PermanentNodeHook hook = (PermanentNodeHook)this.getHooks().get(0);
            try {
                this.removeHook(hook);
            }
            catch (Exception e) {
                Resources.getInstance().logException(e);
            }
        }
    }

    @Override
    public SortedMap getToolTip() {
        if (this.toolTip == null) {
            return new TreeMap();
        }
        return Collections.unmodifiableSortedMap(this.toolTip);
    }

    @Override
    public void setToolTip(String key, String string) {
        this.createToolTip();
        if (string == null) {
            if (this.toolTip.containsKey(key)) {
                this.toolTip.remove(key);
            }
            if (this.toolTip.size() == 0) {
                this.toolTip = null;
            }
        } else {
            this.toolTip.put(key, string);
        }
    }

    @Override
    public String getObjectId(ModeController controller) {
        return controller.getNodeID(this);
    }

    @Override
    public XMLElement save(Writer writer, MindMapLinkRegistry registry, boolean saveInvisible, boolean saveChildren) throws IOException {
        XMLElement edge;
        XMLElement htmlElement;
        this.getModeController().firePreSaveEvent(this);
        XMLElement node = new XMLElement();
        node.setName("node");
        String text = this.toString().replace('\u0000', ' ');
        if (!HtmlTools.isHtmlNode(text)) {
            node.setAttribute("TEXT", text);
        } else {
            htmlElement = new XMLElement();
            htmlElement.setName("richcontent");
            htmlElement.setAttribute("TYPE", "NODE");
            htmlElement.setEncodedContent(NodeAdapter.convertToEncodedContent(this.getXmlText()));
            node.addChild(htmlElement);
        }
        if (this.getXmlNoteText() != null) {
            htmlElement = new XMLElement();
            htmlElement.setName("richcontent");
            htmlElement.setAttribute("TYPE", "NOTE");
            htmlElement.setEncodedContent(NodeAdapter.convertToEncodedContent(this.getXmlNoteText()));
            node.addChild(htmlElement);
        }
        if (this.getAdditionalInfo() != null) {
            node.setAttribute("ENCRYPTED_CONTENT", this.getAdditionalInfo());
        }
        if ((edge = this.getEdge().save()) != null) {
            node.addChild(edge);
        }
        if (this.getCloud() != null) {
            XMLElement cloud = this.getCloud().save();
            node.addChild(cloud);
        }
        Vector linkVector = registry.getAllLinksFromMe(this);
        for (int i = 0; i < linkVector.size(); ++i) {
            if (!(linkVector.get(i) instanceof ArrowLinkAdapter)) continue;
            XMLElement arrowLinkElement = ((ArrowLinkAdapter)linkVector.get(i)).save();
            node.addChild(arrowLinkElement);
        }
        Vector targetVector = registry.getAllLinksIntoMe(this);
        for (int i = 0; i < targetVector.size(); ++i) {
            if (!(targetVector.get(i) instanceof ArrowLinkAdapter)) continue;
            XMLElement arrowLinkTargetElement = ((ArrowLinkAdapter)targetVector.get(i)).createArrowLinkTarget(registry).save();
            node.addChild(arrowLinkTargetElement);
        }
        if (this.isFolded()) {
            node.setAttribute("FOLDED", "true");
        }
        if (!this.isRoot() && this.getParentNode().isRoot()) {
            node.setAttribute("POSITION", this.isLeft() ? "left" : "right");
        }
        String label = registry.getLabel(this);
        if ((!sSaveOnlyIntrinsicallyNeededIds || registry.isTargetOfLocalHyperlinks(label) || registry.getAllLinksIntoMe(this).size() > 0) && label != null) {
            node.setAttribute("ID", label);
        }
        if (this.color != null) {
            node.setAttribute("COLOR", Tools.colorToXml(this.getColor()));
        }
        if (this.getBackgroundColor() != null) {
            node.setAttribute("BACKGROUND_COLOR", Tools.colorToXml(this.getBackgroundColor()));
        }
        if (this.style != null) {
            node.setAttribute("STYLE", this.getStyle());
        }
        if (this.vGap != 3) {
            node.setAttribute("VGAP", Integer.toString(this.vGap));
        }
        if (this.hGap != 20) {
            node.setAttribute("HGAP", Integer.toString(this.hGap));
        }
        if (this.shiftY != 0) {
            node.setAttribute("VSHIFT", Integer.toString(this.shiftY));
        }
        if (this.getLink() != null) {
            node.setAttribute("LINK", this.getLink());
        }
        if (this.historyInformation != null) {
            node.setAttribute("CREATED", Tools.dateToString(this.getHistoryInformation().getCreatedAt()));
            node.setAttribute("MODIFIED", Tools.dateToString(this.getHistoryInformation().getLastModifiedAt()));
        }
        if (this.font != null) {
            XMLElement fontElement = new XMLElement();
            fontElement.setName("font");
            if (this.font != null) {
                fontElement.setAttribute("NAME", this.font.getFamily());
            }
            if (this.font.getSize() != 0) {
                fontElement.setAttribute("SIZE", Integer.toString(this.font.getSize()));
            }
            if (this.isBold()) {
                fontElement.setAttribute("BOLD", "true");
            }
            if (this.isItalic()) {
                fontElement.setAttribute("ITALIC", "true");
            }
            if (this.isUnderlined()) {
                fontElement.setAttribute("UNDERLINE", "true");
            }
            node.addChild(fontElement);
        }
        for (int i = 0; i < this.getIcons().size(); ++i) {
            XMLElement iconElement = new XMLElement();
            iconElement.setName("icon");
            iconElement.setAttribute("BUILTIN", ((MindIcon)this.getIcons().get(i)).getName());
            node.addChild(iconElement);
        }
        for (PermanentNodeHook permHook : this.getActivatedHooks()) {
            if (permHook instanceof DontSaveMarker) continue;
            XMLElement hookElement = new XMLElement();
            hookElement.setName("hook");
            permHook.save(hookElement);
            node.addChild(hookElement);
        }
        this.attributes.save(node);
        if (saveChildren && this.childrenUnfolded().hasNext()) {
            node.writeWithoutClosingTag(writer);
            this.saveChildren(writer, registry, this, saveInvisible);
            node.writeClosingTag(writer);
        } else {
            node.write(writer);
        }
        return node;
    }

    public static String convertToEncodedContent(String xmlText2) {
        String replace = HtmlTools.makeValidXml(xmlText2);
        return HtmlTools.unicodeToHTMLUnicodeEntity(replace, true);
    }

    public ModeController getModeController() {
        return this.map.getModeController();
    }

    private void saveChildren(Writer writer, MindMapLinkRegistry registry, NodeAdapter node, boolean saveHidden) throws IOException {
        ListIterator e = node.childrenUnfolded();
        while (e.hasNext()) {
            NodeAdapter child = (NodeAdapter)e.next();
            if (saveHidden || child.isVisible()) {
                child.save(writer, registry, saveHidden, true);
                continue;
            }
            this.saveChildren(writer, registry, child, saveHidden);
        }
    }

    @Override
    public int getShiftY() {
        return this.shiftY;
    }

    @Override
    public boolean hasExactlyOneVisibleChild() {
        int count = 0;
        ListIterator i = this.childrenUnfolded();
        while (i.hasNext()) {
            if (((MindMapNode)i.next()).isVisible()) {
                ++count;
            }
            if (count != 2) continue;
            return false;
        }
        return count == 1;
    }

    @Override
    public boolean hasVisibleChilds() {
        ListIterator i = this.childrenUnfolded();
        while (i.hasNext()) {
            if (!((MindMapNode)i.next()).isVisible()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int calcShiftY() {
        try {
            return this.shiftY + (this.parent.hasExactlyOneVisibleChild() ? -2 : 0);
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    @Override
    public void setShiftY(int shiftY) {
        this.shiftY = shiftY;
    }

    @Override
    public void setAdditionalInfo(String info) {
    }

    @Override
    public String getAdditionalInfo() {
        return null;
    }

    @Override
    public synchronized void setStateIcon(String key, ImageIcon icon) {
        this.createStateIcons();
        if (icon != null) {
            this.stateIcons.put(key, icon);
            this.getMap().getRegistry().addIcon(MindIcon.factory(key, icon));
        } else if (this.stateIcons.containsKey(key)) {
            this.stateIcons.remove(key);
        }
        if (this.stateIcons.size() == 0) {
            this.stateIcons = null;
        }
    }

    @Override
    public Map getStateIcons() {
        if (this.stateIcons == null) {
            return Collections.EMPTY_MAP;
        }
        return Collections.unmodifiableSortedMap(this.stateIcons);
    }

    @Override
    public HistoryInformation getHistoryInformation() {
        return this.historyInformation;
    }

    @Override
    public void setHistoryInformation(HistoryInformation historyInformation) {
        this.historyInformation = historyInformation;
    }

    @Override
    public int getHGap() {
        return this.hGap;
    }

    @Override
    public void setHGap(int gap) {
        this.hGap = gap;
    }

    @Override
    public int getVGap() {
        return this.vGap;
    }

    @Override
    public void setVGap(int gap) {
        this.vGap = Math.max(gap, 0);
    }

    @Override
    public boolean isVisible() {
        Filter filter = this.getMap().getFilter();
        return filter == null || filter.isVisible(this);
    }

    @Override
    public NodeAttributeTableModel getAttributes() {
        return this.attributes;
    }

    @Override
    public void createAttributeTableModel() {
        if (this.attributes == EMTPY_ATTRIBUTES) {
            this.attributes = new NodeAttributeTableModel(this);
            if (this.views == null) {
                return;
            }
            for (NodeView view : this.views) {
                view.createAttributeView();
            }
        }
    }

    @Override
    public int getAttributeTableLength() {
        return this.attributes.getRowCount();
    }

    @Override
    public Attribute getAttribute(int pPosition) {
        return new Attribute(this.attributes.getAttribute(pPosition));
    }

    @Override
    public List getAttributeKeyList() {
        Vector<String> returnValue = new Vector<String>();
        if (this.attributes != null) {
            for (Attribute attr : this.attributes.getAttributes()) {
                returnValue.add(attr.getName());
            }
        }
        return returnValue;
    }

    @Override
    public int getAttributePosition(String pKey) {
        if (pKey == null) {
            return -1;
        }
        int pos = 0;
        for (Attribute attr : this.attributes.getAttributes()) {
            if (pKey.equals(attr.getName())) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    @Override
    public String getAttribute(String pKey) {
        int attributePosition = this.getAttributePosition(pKey);
        if (attributePosition < 0) {
            return null;
        }
        return this.getAttribute(attributePosition).getValue();
    }

    @Override
    public void setAttribute(int pPosition, Attribute pAttribute) {
        this.createAttributeTableModel();
        this.attributes.setName(pPosition, pAttribute.getName());
        this.attributes.setValue(pPosition, pAttribute.getValue());
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    @Override
    public EventListenerList getListeners() {
        return this.listenerList;
    }

    @Override
    public void acceptViewVisitor(NodeViewVisitor visitor) {
        Iterator iterator = this.views.iterator();
        while (iterator.hasNext()) {
            visitor.visit((NodeView)iterator.next());
        }
    }

    static {
        sSaveOnlyIntrinsicallyNeededIds = false;
    }
}

