/*
 * This declarations of the PIC18F66K80 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2014.
 *
 * This file is generated automatically by the cinc2h.pl, 2014-07-08 08:41:51 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC18F66K80_H__
#define __PIC18F66K80_H__

//==============================================================================

//==============================================================================
//
//	Register Definitions
//
//==============================================================================


//==============================================================================
//        RXERRCNT Bits

extern __at(0x0E41) __sfr RXERRCNT;

typedef struct
  {
  unsigned REC0                 : 1;
  unsigned REC1                 : 1;
  unsigned REC2                 : 1;
  unsigned REC3                 : 1;
  unsigned REC4                 : 1;
  unsigned REC5                 : 1;
  unsigned REC6                 : 1;
  unsigned REC7                 : 1;
  } __RXERRCNTbits_t;

extern __at(0x0E41) volatile __RXERRCNTbits_t RXERRCNTbits;

#define _REC0                   0x01
#define _REC1                   0x02
#define _REC2                   0x04
#define _REC3                   0x08
#define _REC4                   0x10
#define _REC5                   0x20
#define _REC6                   0x40
#define _REC7                   0x80

//==============================================================================


//==============================================================================
//        TXERRCNT Bits

extern __at(0x0E42) __sfr TXERRCNT;

typedef struct
  {
  unsigned TEC0                 : 1;
  unsigned TEC1                 : 1;
  unsigned TEC2                 : 1;
  unsigned TEC3                 : 1;
  unsigned TEC4                 : 1;
  unsigned TEC5                 : 1;
  unsigned TEC6                 : 1;
  unsigned TEC7                 : 1;
  } __TXERRCNTbits_t;

extern __at(0x0E42) volatile __TXERRCNTbits_t TXERRCNTbits;

#define _TEC0                   0x01
#define _TEC1                   0x02
#define _TEC2                   0x04
#define _TEC3                   0x08
#define _TEC4                   0x10
#define _TEC5                   0x20
#define _TEC6                   0x40
#define _TEC7                   0x80

//==============================================================================


//==============================================================================
//        BRGCON1 Bits

extern __at(0x0E43) __sfr BRGCON1;

typedef union
  {
  struct
    {
    unsigned BRP0               : 1;
    unsigned BRP1               : 1;
    unsigned BRP2               : 1;
    unsigned BRP3               : 1;
    unsigned BRP4               : 1;
    unsigned BRP5               : 1;
    unsigned SJW0               : 1;
    unsigned SJW1               : 1;
    };

  struct
    {
    unsigned BRP                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned SJW                : 2;
    };
  } __BRGCON1bits_t;

extern __at(0x0E43) volatile __BRGCON1bits_t BRGCON1bits;

#define _BRP0                   0x01
#define _BRP1                   0x02
#define _BRP2                   0x04
#define _BRP3                   0x08
#define _BRP4                   0x10
#define _BRP5                   0x20
#define _SJW0                   0x40
#define _SJW1                   0x80

//==============================================================================


//==============================================================================
//        BRGCON2 Bits

extern __at(0x0E44) __sfr BRGCON2;

typedef union
  {
  struct
    {
    unsigned PRSEG0             : 1;
    unsigned PRSEG1             : 1;
    unsigned PRSEG2             : 1;
    unsigned SEG1PH0            : 1;
    unsigned SEG1PH1            : 1;
    unsigned SEG1PH2            : 1;
    unsigned SAM                : 1;
    unsigned SEG2PHTS           : 1;
    };

  struct
    {
    unsigned PRSEG              : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned SEG1PH             : 3;
    unsigned                    : 2;
    };
  } __BRGCON2bits_t;

extern __at(0x0E44) volatile __BRGCON2bits_t BRGCON2bits;

#define _PRSEG0                 0x01
#define _PRSEG1                 0x02
#define _PRSEG2                 0x04
#define _SEG1PH0                0x08
#define _SEG1PH1                0x10
#define _SEG1PH2                0x20
#define _SAM                    0x40
#define _SEG2PHTS               0x80

//==============================================================================


//==============================================================================
//        BRGCON3 Bits

extern __at(0x0E45) __sfr BRGCON3;

typedef union
  {
  struct
    {
    unsigned SEG2PH0            : 1;
    unsigned SEG2PH1            : 1;
    unsigned SEG2PH2            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned WAKFIL             : 1;
    unsigned WAKDIS             : 1;
    };

  struct
    {
    unsigned SEG2PH             : 3;
    unsigned                    : 5;
    };
  } __BRGCON3bits_t;

extern __at(0x0E45) volatile __BRGCON3bits_t BRGCON3bits;

#define _SEG2PH0                0x01
#define _SEG2PH1                0x02
#define _SEG2PH2                0x04
#define _WAKFIL                 0x40
#define _WAKDIS                 0x80

//==============================================================================


//==============================================================================
//        RXFCON0 Bits

extern __at(0x0E46) __sfr RXFCON0;

typedef struct
  {
  unsigned RXF0EN               : 1;
  unsigned RXF1EN               : 1;
  unsigned RXF2EN               : 1;
  unsigned RXF3EN               : 1;
  unsigned RXF4EN               : 1;
  unsigned RXF5EN               : 1;
  unsigned RXF6EN               : 1;
  unsigned RXF7EN               : 1;
  } __RXFCON0bits_t;

extern __at(0x0E46) volatile __RXFCON0bits_t RXFCON0bits;

#define _RXF0EN                 0x01
#define _RXF1EN                 0x02
#define _RXF2EN                 0x04
#define _RXF3EN                 0x08
#define _RXF4EN                 0x10
#define _RXF5EN                 0x20
#define _RXF6EN                 0x40
#define _RXF7EN                 0x80

//==============================================================================


//==============================================================================
//        RXFCON1 Bits

extern __at(0x0E47) __sfr RXFCON1;

typedef struct
  {
  unsigned RXF8EN               : 1;
  unsigned RXF9EN               : 1;
  unsigned RXF10EN              : 1;
  unsigned RXF11EN              : 1;
  unsigned RXF12EN              : 1;
  unsigned RXF13EN              : 1;
  unsigned RXF14EN              : 1;
  unsigned RXF15EN              : 1;
  } __RXFCON1bits_t;

extern __at(0x0E47) volatile __RXFCON1bits_t RXFCON1bits;

#define _RXF8EN                 0x01
#define _RXF9EN                 0x02
#define _RXF10EN                0x04
#define _RXF11EN                0x08
#define _RXF12EN                0x10
#define _RXF13EN                0x20
#define _RXF14EN                0x40
#define _RXF15EN                0x80

//==============================================================================


//==============================================================================
//        RXF6SIDH Bits

extern __at(0x0E48) __sfr RXF6SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __RXF6SIDHbits_t;

extern __at(0x0E48) volatile __RXF6SIDHbits_t RXF6SIDHbits;

#define _RXF6SIDH_SID3          0x01
#define _RXF6SIDH_SID4          0x02
#define _RXF6SIDH_SID5          0x04
#define _RXF6SIDH_SID6          0x08
#define _RXF6SIDH_SID7          0x10
#define _RXF6SIDH_SID8          0x20
#define _RXF6SIDH_SID9          0x40
#define _RXF6SIDH_SID10         0x80

//==============================================================================


//==============================================================================
//        RXF6SIDL Bits

extern __at(0x0E49) __sfr RXF6SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDEN             : 1;
    unsigned                    : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __RXF6SIDLbits_t;

extern __at(0x0E49) volatile __RXF6SIDLbits_t RXF6SIDLbits;

#define _RXF6SIDL_EID16         0x01
#define _RXF6SIDL_EID17         0x02
#define _RXF6SIDL_EXIDEN        0x08
#define _RXF6SIDL_SID0          0x20
#define _RXF6SIDL_SID1          0x40
#define _RXF6SIDL_SID2          0x80

//==============================================================================


//==============================================================================
//        RXF6EIDH Bits

extern __at(0x0E4A) __sfr RXF6EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __RXF6EIDHbits_t;

extern __at(0x0E4A) volatile __RXF6EIDHbits_t RXF6EIDHbits;

#define _RXF6EIDH_EID8          0x01
#define _RXF6EIDH_EID9          0x02
#define _RXF6EIDH_EID10         0x04
#define _RXF6EIDH_EID11         0x08
#define _RXF6EIDH_EID12         0x10
#define _RXF6EIDH_EID13         0x20
#define _RXF6EIDH_EID14         0x40
#define _RXF6EIDH_EID15         0x80

//==============================================================================


//==============================================================================
//        RXF6EIDL Bits

extern __at(0x0E4B) __sfr RXF6EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __RXF6EIDLbits_t;

extern __at(0x0E4B) volatile __RXF6EIDLbits_t RXF6EIDLbits;

#define _RXF6EIDL_EID0          0x01
#define _RXF6EIDL_EID1          0x02
#define _RXF6EIDL_EID2          0x04
#define _RXF6EIDL_EID3          0x08
#define _RXF6EIDL_EID4          0x10
#define _RXF6EIDL_EID5          0x20
#define _RXF6EIDL_EID6          0x40
#define _RXF6EIDL_EID7          0x80

//==============================================================================


//==============================================================================
//        RXF7SIDH Bits

extern __at(0x0E4C) __sfr RXF7SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __RXF7SIDHbits_t;

extern __at(0x0E4C) volatile __RXF7SIDHbits_t RXF7SIDHbits;

#define _RXF7SIDH_SID3          0x01
#define _RXF7SIDH_SID4          0x02
#define _RXF7SIDH_SID5          0x04
#define _RXF7SIDH_SID6          0x08
#define _RXF7SIDH_SID7          0x10
#define _RXF7SIDH_SID8          0x20
#define _RXF7SIDH_SID9          0x40
#define _RXF7SIDH_SID10         0x80

//==============================================================================


//==============================================================================
//        RXF7SIDL Bits

extern __at(0x0E4D) __sfr RXF7SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDEN             : 1;
    unsigned                    : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __RXF7SIDLbits_t;

extern __at(0x0E4D) volatile __RXF7SIDLbits_t RXF7SIDLbits;

#define _RXF7SIDL_EID16         0x01
#define _RXF7SIDL_EID17         0x02
#define _RXF7SIDL_EXIDEN        0x08
#define _RXF7SIDL_SID0          0x20
#define _RXF7SIDL_SID1          0x40
#define _RXF7SIDL_SID2          0x80

//==============================================================================


//==============================================================================
//        RXF7EIDH Bits

extern __at(0x0E4E) __sfr RXF7EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __RXF7EIDHbits_t;

extern __at(0x0E4E) volatile __RXF7EIDHbits_t RXF7EIDHbits;

#define _RXF7EIDH_EID8          0x01
#define _RXF7EIDH_EID9          0x02
#define _RXF7EIDH_EID10         0x04
#define _RXF7EIDH_EID11         0x08
#define _RXF7EIDH_EID12         0x10
#define _RXF7EIDH_EID13         0x20
#define _RXF7EIDH_EID14         0x40
#define _RXF7EIDH_EID15         0x80

//==============================================================================


//==============================================================================
//        RXF7EIDL Bits

extern __at(0x0E4F) __sfr RXF7EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __RXF7EIDLbits_t;

extern __at(0x0E4F) volatile __RXF7EIDLbits_t RXF7EIDLbits;

#define _RXF7EIDL_EID0          0x01
#define _RXF7EIDL_EID1          0x02
#define _RXF7EIDL_EID2          0x04
#define _RXF7EIDL_EID3          0x08
#define _RXF7EIDL_EID4          0x10
#define _RXF7EIDL_EID5          0x20
#define _RXF7EIDL_EID6          0x40
#define _RXF7EIDL_EID7          0x80

//==============================================================================


//==============================================================================
//        RXF8SIDH Bits

extern __at(0x0E50) __sfr RXF8SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __RXF8SIDHbits_t;

extern __at(0x0E50) volatile __RXF8SIDHbits_t RXF8SIDHbits;

#define _RXF8SIDH_SID3          0x01
#define _RXF8SIDH_SID4          0x02
#define _RXF8SIDH_SID5          0x04
#define _RXF8SIDH_SID6          0x08
#define _RXF8SIDH_SID7          0x10
#define _RXF8SIDH_SID8          0x20
#define _RXF8SIDH_SID9          0x40
#define _RXF8SIDH_SID10         0x80

//==============================================================================


//==============================================================================
//        RXF8SIDL Bits

extern __at(0x0E51) __sfr RXF8SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDEN             : 1;
    unsigned                    : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __RXF8SIDLbits_t;

extern __at(0x0E51) volatile __RXF8SIDLbits_t RXF8SIDLbits;

#define _RXF8SIDL_EID16         0x01
#define _RXF8SIDL_EID17         0x02
#define _RXF8SIDL_EXIDEN        0x08
#define _RXF8SIDL_SID0          0x20
#define _RXF8SIDL_SID1          0x40
#define _RXF8SIDL_SID2          0x80

//==============================================================================


//==============================================================================
//        RXF8EIDH Bits

extern __at(0x0E52) __sfr RXF8EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __RXF8EIDHbits_t;

extern __at(0x0E52) volatile __RXF8EIDHbits_t RXF8EIDHbits;

#define _RXF8EIDH_EID8          0x01
#define _RXF8EIDH_EID9          0x02
#define _RXF8EIDH_EID10         0x04
#define _RXF8EIDH_EID11         0x08
#define _RXF8EIDH_EID12         0x10
#define _RXF8EIDH_EID13         0x20
#define _RXF8EIDH_EID14         0x40
#define _RXF8EIDH_EID15         0x80

//==============================================================================


//==============================================================================
//        RXF8EIDL Bits

extern __at(0x0E53) __sfr RXF8EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __RXF8EIDLbits_t;

extern __at(0x0E53) volatile __RXF8EIDLbits_t RXF8EIDLbits;

#define _RXF8EIDL_EID0          0x01
#define _RXF8EIDL_EID1          0x02
#define _RXF8EIDL_EID2          0x04
#define _RXF8EIDL_EID3          0x08
#define _RXF8EIDL_EID4          0x10
#define _RXF8EIDL_EID5          0x20
#define _RXF8EIDL_EID6          0x40
#define _RXF8EIDL_EID7          0x80

//==============================================================================


//==============================================================================
//        RXF9SIDH Bits

extern __at(0x0E54) __sfr RXF9SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __RXF9SIDHbits_t;

extern __at(0x0E54) volatile __RXF9SIDHbits_t RXF9SIDHbits;

#define _RXF9SIDH_SID3          0x01
#define _RXF9SIDH_SID4          0x02
#define _RXF9SIDH_SID5          0x04
#define _RXF9SIDH_SID6          0x08
#define _RXF9SIDH_SID7          0x10
#define _RXF9SIDH_SID8          0x20
#define _RXF9SIDH_SID9          0x40
#define _RXF9SIDH_SID10         0x80

//==============================================================================


//==============================================================================
//        RXF9SIDL Bits

extern __at(0x0E55) __sfr RXF9SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDEN             : 1;
    unsigned                    : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __RXF9SIDLbits_t;

extern __at(0x0E55) volatile __RXF9SIDLbits_t RXF9SIDLbits;

#define _RXF9SIDL_EID16         0x01
#define _RXF9SIDL_EID17         0x02
#define _RXF9SIDL_EXIDEN        0x08
#define _RXF9SIDL_SID0          0x20
#define _RXF9SIDL_SID1          0x40
#define _RXF9SIDL_SID2          0x80

//==============================================================================


//==============================================================================
//        RXF9EIDH Bits

extern __at(0x0E56) __sfr RXF9EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __RXF9EIDHbits_t;

extern __at(0x0E56) volatile __RXF9EIDHbits_t RXF9EIDHbits;

#define _RXF9EIDH_EID8          0x01
#define _RXF9EIDH_EID9          0x02
#define _RXF9EIDH_EID10         0x04
#define _RXF9EIDH_EID11         0x08
#define _RXF9EIDH_EID12         0x10
#define _RXF9EIDH_EID13         0x20
#define _RXF9EIDH_EID14         0x40
#define _RXF9EIDH_EID15         0x80

//==============================================================================


//==============================================================================
//        RXF9EIDL Bits

extern __at(0x0E57) __sfr RXF9EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __RXF9EIDLbits_t;

extern __at(0x0E57) volatile __RXF9EIDLbits_t RXF9EIDLbits;

#define _RXF9EIDL_EID0          0x01
#define _RXF9EIDL_EID1          0x02
#define _RXF9EIDL_EID2          0x04
#define _RXF9EIDL_EID3          0x08
#define _RXF9EIDL_EID4          0x10
#define _RXF9EIDL_EID5          0x20
#define _RXF9EIDL_EID6          0x40
#define _RXF9EIDL_EID7          0x80

//==============================================================================


//==============================================================================
//        RXF10SIDH Bits

extern __at(0x0E58) __sfr RXF10SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __RXF10SIDHbits_t;

extern __at(0x0E58) volatile __RXF10SIDHbits_t RXF10SIDHbits;

#define _RXF10SIDH_SID3         0x01
#define _RXF10SIDH_SID4         0x02
#define _RXF10SIDH_SID5         0x04
#define _RXF10SIDH_SID6         0x08
#define _RXF10SIDH_SID7         0x10
#define _RXF10SIDH_SID8         0x20
#define _RXF10SIDH_SID9         0x40
#define _RXF10SIDH_SID10        0x80

//==============================================================================


//==============================================================================
//        RXF10SIDL Bits

extern __at(0x0E59) __sfr RXF10SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDEN             : 1;
    unsigned                    : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __RXF10SIDLbits_t;

extern __at(0x0E59) volatile __RXF10SIDLbits_t RXF10SIDLbits;

#define _RXF10SIDL_EID16        0x01
#define _RXF10SIDL_EID17        0x02
#define _RXF10SIDL_EXIDEN       0x08
#define _RXF10SIDL_SID0         0x20
#define _RXF10SIDL_SID1         0x40
#define _RXF10SIDL_SID2         0x80

//==============================================================================


//==============================================================================
//        RXF10EIDH Bits

extern __at(0x0E5A) __sfr RXF10EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __RXF10EIDHbits_t;

extern __at(0x0E5A) volatile __RXF10EIDHbits_t RXF10EIDHbits;

#define _RXF10EIDH_EID8         0x01
#define _RXF10EIDH_EID9         0x02
#define _RXF10EIDH_EID10        0x04
#define _RXF10EIDH_EID11        0x08
#define _RXF10EIDH_EID12        0x10
#define _RXF10EIDH_EID13        0x20
#define _RXF10EIDH_EID14        0x40
#define _RXF10EIDH_EID15        0x80

//==============================================================================


//==============================================================================
//        RXF10EIDL Bits

extern __at(0x0E5B) __sfr RXF10EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __RXF10EIDLbits_t;

extern __at(0x0E5B) volatile __RXF10EIDLbits_t RXF10EIDLbits;

#define _RXF10EIDL_EID0         0x01
#define _RXF10EIDL_EID1         0x02
#define _RXF10EIDL_EID2         0x04
#define _RXF10EIDL_EID3         0x08
#define _RXF10EIDL_EID4         0x10
#define _RXF10EIDL_EID5         0x20
#define _RXF10EIDL_EID6         0x40
#define _RXF10EIDL_EID7         0x80

//==============================================================================


//==============================================================================
//        RXF11SIDH Bits

extern __at(0x0E5C) __sfr RXF11SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __RXF11SIDHbits_t;

extern __at(0x0E5C) volatile __RXF11SIDHbits_t RXF11SIDHbits;

#define _RXF11SIDH_SID3         0x01
#define _RXF11SIDH_SID4         0x02
#define _RXF11SIDH_SID5         0x04
#define _RXF11SIDH_SID6         0x08
#define _RXF11SIDH_SID7         0x10
#define _RXF11SIDH_SID8         0x20
#define _RXF11SIDH_SID9         0x40
#define _RXF11SIDH_SID10        0x80

//==============================================================================


//==============================================================================
//        RXF11SIDL Bits

extern __at(0x0E5D) __sfr RXF11SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDEN             : 1;
    unsigned                    : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __RXF11SIDLbits_t;

extern __at(0x0E5D) volatile __RXF11SIDLbits_t RXF11SIDLbits;

#define _RXF11SIDL_EID16        0x01
#define _RXF11SIDL_EID17        0x02
#define _RXF11SIDL_EXIDEN       0x08
#define _RXF11SIDL_SID0         0x20
#define _RXF11SIDL_SID1         0x40
#define _RXF11SIDL_SID2         0x80

//==============================================================================


//==============================================================================
//        RXF11EIDH Bits

extern __at(0x0E5E) __sfr RXF11EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __RXF11EIDHbits_t;

extern __at(0x0E5E) volatile __RXF11EIDHbits_t RXF11EIDHbits;

#define _RXF11EIDH_EID8         0x01
#define _RXF11EIDH_EID9         0x02
#define _RXF11EIDH_EID10        0x04
#define _RXF11EIDH_EID11        0x08
#define _RXF11EIDH_EID12        0x10
#define _RXF11EIDH_EID13        0x20
#define _RXF11EIDH_EID14        0x40
#define _RXF11EIDH_EID15        0x80

//==============================================================================


//==============================================================================
//        RXF11EIDL Bits

extern __at(0x0E5F) __sfr RXF11EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __RXF11EIDLbits_t;

extern __at(0x0E5F) volatile __RXF11EIDLbits_t RXF11EIDLbits;

#define _RXF11EIDL_EID0         0x01
#define _RXF11EIDL_EID1         0x02
#define _RXF11EIDL_EID2         0x04
#define _RXF11EIDL_EID3         0x08
#define _RXF11EIDL_EID4         0x10
#define _RXF11EIDL_EID5         0x20
#define _RXF11EIDL_EID6         0x40
#define _RXF11EIDL_EID7         0x80

//==============================================================================


//==============================================================================
//        RXF12SIDH Bits

extern __at(0x0E60) __sfr RXF12SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __RXF12SIDHbits_t;

extern __at(0x0E60) volatile __RXF12SIDHbits_t RXF12SIDHbits;

#define _RXF12SIDH_SID3         0x01
#define _RXF12SIDH_SID4         0x02
#define _RXF12SIDH_SID5         0x04
#define _RXF12SIDH_SID6         0x08
#define _RXF12SIDH_SID7         0x10
#define _RXF12SIDH_SID8         0x20
#define _RXF12SIDH_SID9         0x40
#define _RXF12SIDH_SID10        0x80

//==============================================================================


//==============================================================================
//        RXF12SIDL Bits

extern __at(0x0E61) __sfr RXF12SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDEN             : 1;
    unsigned                    : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __RXF12SIDLbits_t;

extern __at(0x0E61) volatile __RXF12SIDLbits_t RXF12SIDLbits;

#define _RXF12SIDL_EID16        0x01
#define _RXF12SIDL_EID17        0x02
#define _RXF12SIDL_EXIDEN       0x08
#define _RXF12SIDL_SID0         0x20
#define _RXF12SIDL_SID1         0x40
#define _RXF12SIDL_SID2         0x80

//==============================================================================


//==============================================================================
//        RXF12EIDH Bits

extern __at(0x0E62) __sfr RXF12EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __RXF12EIDHbits_t;

extern __at(0x0E62) volatile __RXF12EIDHbits_t RXF12EIDHbits;

#define _RXF12EIDH_EID8         0x01
#define _RXF12EIDH_EID9         0x02
#define _RXF12EIDH_EID10        0x04
#define _RXF12EIDH_EID11        0x08
#define _RXF12EIDH_EID12        0x10
#define _RXF12EIDH_EID13        0x20
#define _RXF12EIDH_EID14        0x40
#define _RXF12EIDH_EID15        0x80

//==============================================================================


//==============================================================================
//        RXF12EIDL Bits

extern __at(0x0E63) __sfr RXF12EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __RXF12EIDLbits_t;

extern __at(0x0E63) volatile __RXF12EIDLbits_t RXF12EIDLbits;

#define _RXF12EIDL_EID0         0x01
#define _RXF12EIDL_EID1         0x02
#define _RXF12EIDL_EID2         0x04
#define _RXF12EIDL_EID3         0x08
#define _RXF12EIDL_EID4         0x10
#define _RXF12EIDL_EID5         0x20
#define _RXF12EIDL_EID6         0x40
#define _RXF12EIDL_EID7         0x80

//==============================================================================


//==============================================================================
//        RXF13SIDH Bits

extern __at(0x0E64) __sfr RXF13SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __RXF13SIDHbits_t;

extern __at(0x0E64) volatile __RXF13SIDHbits_t RXF13SIDHbits;

#define _RXF13SIDH_SID3         0x01
#define _RXF13SIDH_SID4         0x02
#define _RXF13SIDH_SID5         0x04
#define _RXF13SIDH_SID6         0x08
#define _RXF13SIDH_SID7         0x10
#define _RXF13SIDH_SID8         0x20
#define _RXF13SIDH_SID9         0x40
#define _RXF13SIDH_SID10        0x80

//==============================================================================


//==============================================================================
//        RXF13SIDL Bits

extern __at(0x0E65) __sfr RXF13SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDEN             : 1;
    unsigned                    : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __RXF13SIDLbits_t;

extern __at(0x0E65) volatile __RXF13SIDLbits_t RXF13SIDLbits;

#define _RXF13SIDL_EID16        0x01
#define _RXF13SIDL_EID17        0x02
#define _RXF13SIDL_EXIDEN       0x08
#define _RXF13SIDL_SID0         0x20
#define _RXF13SIDL_SID1         0x40
#define _RXF13SIDL_SID2         0x80

//==============================================================================


//==============================================================================
//        RXF13EIDH Bits

extern __at(0x0E66) __sfr RXF13EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __RXF13EIDHbits_t;

extern __at(0x0E66) volatile __RXF13EIDHbits_t RXF13EIDHbits;

#define _RXF13EIDH_EID8         0x01
#define _RXF13EIDH_EID9         0x02
#define _RXF13EIDH_EID10        0x04
#define _RXF13EIDH_EID11        0x08
#define _RXF13EIDH_EID12        0x10
#define _RXF13EIDH_EID13        0x20
#define _RXF13EIDH_EID14        0x40
#define _RXF13EIDH_EID15        0x80

//==============================================================================


//==============================================================================
//        RXF13EIDL Bits

extern __at(0x0E67) __sfr RXF13EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __RXF13EIDLbits_t;

extern __at(0x0E67) volatile __RXF13EIDLbits_t RXF13EIDLbits;

#define _RXF13EIDL_EID0         0x01
#define _RXF13EIDL_EID1         0x02
#define _RXF13EIDL_EID2         0x04
#define _RXF13EIDL_EID3         0x08
#define _RXF13EIDL_EID4         0x10
#define _RXF13EIDL_EID5         0x20
#define _RXF13EIDL_EID6         0x40
#define _RXF13EIDL_EID7         0x80

//==============================================================================


//==============================================================================
//        RXF14SIDH Bits

extern __at(0x0E68) __sfr RXF14SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __RXF14SIDHbits_t;

extern __at(0x0E68) volatile __RXF14SIDHbits_t RXF14SIDHbits;

#define _RXF14SIDH_SID3         0x01
#define _RXF14SIDH_SID4         0x02
#define _RXF14SIDH_SID5         0x04
#define _RXF14SIDH_SID6         0x08
#define _RXF14SIDH_SID7         0x10
#define _RXF14SIDH_SID8         0x20
#define _RXF14SIDH_SID9         0x40
#define _RXF14SIDH_SID10        0x80

//==============================================================================


//==============================================================================
//        RXF14SIDL Bits

extern __at(0x0E69) __sfr RXF14SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDEN             : 1;
    unsigned                    : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __RXF14SIDLbits_t;

extern __at(0x0E69) volatile __RXF14SIDLbits_t RXF14SIDLbits;

#define _RXF14SIDL_EID16        0x01
#define _RXF14SIDL_EID17        0x02
#define _RXF14SIDL_EXIDEN       0x08
#define _RXF14SIDL_SID0         0x20
#define _RXF14SIDL_SID1         0x40
#define _RXF14SIDL_SID2         0x80

//==============================================================================


//==============================================================================
//        RXF14EIDH Bits

extern __at(0x0E6A) __sfr RXF14EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __RXF14EIDHbits_t;

extern __at(0x0E6A) volatile __RXF14EIDHbits_t RXF14EIDHbits;

#define _RXF14EIDH_EID8         0x01
#define _RXF14EIDH_EID9         0x02
#define _RXF14EIDH_EID10        0x04
#define _RXF14EIDH_EID11        0x08
#define _RXF14EIDH_EID12        0x10
#define _RXF14EIDH_EID13        0x20
#define _RXF14EIDH_EID14        0x40
#define _RXF14EIDH_EID15        0x80

//==============================================================================


//==============================================================================
//        RXF14EIDL Bits

extern __at(0x0E6B) __sfr RXF14EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __RXF14EIDLbits_t;

extern __at(0x0E6B) volatile __RXF14EIDLbits_t RXF14EIDLbits;

#define _RXF14EIDL_EID0         0x01
#define _RXF14EIDL_EID1         0x02
#define _RXF14EIDL_EID2         0x04
#define _RXF14EIDL_EID3         0x08
#define _RXF14EIDL_EID4         0x10
#define _RXF14EIDL_EID5         0x20
#define _RXF14EIDL_EID6         0x40
#define _RXF14EIDL_EID7         0x80

//==============================================================================


//==============================================================================
//        RXF15SIDH Bits

extern __at(0x0E6C) __sfr RXF15SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __RXF15SIDHbits_t;

extern __at(0x0E6C) volatile __RXF15SIDHbits_t RXF15SIDHbits;

#define _RXF15SIDH_SID3         0x01
#define _RXF15SIDH_SID4         0x02
#define _RXF15SIDH_SID5         0x04
#define _RXF15SIDH_SID6         0x08
#define _RXF15SIDH_SID7         0x10
#define _RXF15SIDH_SID8         0x20
#define _RXF15SIDH_SID9         0x40
#define _RXF15SIDH_SID10        0x80

//==============================================================================


//==============================================================================
//        RXF15SIDL Bits

extern __at(0x0E6D) __sfr RXF15SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDEN             : 1;
    unsigned                    : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __RXF15SIDLbits_t;

extern __at(0x0E6D) volatile __RXF15SIDLbits_t RXF15SIDLbits;

#define _RXF15SIDL_EID16        0x01
#define _RXF15SIDL_EID17        0x02
#define _RXF15SIDL_EXIDEN       0x08
#define _RXF15SIDL_SID0         0x20
#define _RXF15SIDL_SID1         0x40
#define _RXF15SIDL_SID2         0x80

//==============================================================================


//==============================================================================
//        RXF15EIDH Bits

extern __at(0x0E6E) __sfr RXF15EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __RXF15EIDHbits_t;

extern __at(0x0E6E) volatile __RXF15EIDHbits_t RXF15EIDHbits;

#define _RXF15EIDH_EID8         0x01
#define _RXF15EIDH_EID9         0x02
#define _RXF15EIDH_EID10        0x04
#define _RXF15EIDH_EID11        0x08
#define _RXF15EIDH_EID12        0x10
#define _RXF15EIDH_EID13        0x20
#define _RXF15EIDH_EID14        0x40
#define _RXF15EIDH_EID15        0x80

//==============================================================================


//==============================================================================
//        RXF15EIDL Bits

extern __at(0x0E6F) __sfr RXF15EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __RXF15EIDLbits_t;

extern __at(0x0E6F) volatile __RXF15EIDLbits_t RXF15EIDLbits;

#define _RXF15EIDL_EID0         0x01
#define _RXF15EIDL_EID1         0x02
#define _RXF15EIDL_EID2         0x04
#define _RXF15EIDL_EID3         0x08
#define _RXF15EIDL_EID4         0x10
#define _RXF15EIDL_EID5         0x20
#define _RXF15EIDL_EID6         0x40
#define _RXF15EIDL_EID7         0x80

//==============================================================================


//==============================================================================
//        SDFLC Bits

extern __at(0x0E70) __sfr SDFLC;

typedef union
  {
  struct
    {
    unsigned FLC0               : 1;
    unsigned FLC1               : 1;
    unsigned FLC2               : 1;
    unsigned FLC3               : 1;
    unsigned FLC4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned FLC                : 5;
    unsigned                    : 3;
    };
  } __SDFLCbits_t;

extern __at(0x0E70) volatile __SDFLCbits_t SDFLCbits;

#define _FLC0                   0x01
#define _FLC1                   0x02
#define _FLC2                   0x04
#define _FLC3                   0x08
#define _FLC4                   0x10

//==============================================================================


//==============================================================================
//        RXFBCON0 Bits

extern __at(0x0E71) __sfr RXFBCON0;

typedef union
  {
  struct
    {
    unsigned F0BP_0             : 1;
    unsigned F0BP_1             : 1;
    unsigned F0BP_2             : 1;
    unsigned F0BP_3             : 1;
    unsigned F1BP_0             : 1;
    unsigned F1BP_1             : 1;
    unsigned F1BP_2             : 1;
    unsigned F1BP_3             : 1;
    };

  struct
    {
    unsigned F0BP_              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned F1BP_              : 4;
    };
  } __RXFBCON0bits_t;

extern __at(0x0E71) volatile __RXFBCON0bits_t RXFBCON0bits;

#define _F0BP_0                 0x01
#define _F0BP_1                 0x02
#define _F0BP_2                 0x04
#define _F0BP_3                 0x08
#define _F1BP_0                 0x10
#define _F1BP_1                 0x20
#define _F1BP_2                 0x40
#define _F1BP_3                 0x80

//==============================================================================


//==============================================================================
//        RXFBCON1 Bits

extern __at(0x0E72) __sfr RXFBCON1;

typedef union
  {
  struct
    {
    unsigned F2BP_0             : 1;
    unsigned F2BP_1             : 1;
    unsigned F2BP_2             : 1;
    unsigned F2BP_3             : 1;
    unsigned F3BP_0             : 1;
    unsigned F3BP_1             : 1;
    unsigned F3BP_2             : 1;
    unsigned F3BP_3             : 1;
    };

  struct
    {
    unsigned F2BP_              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned F3BP_              : 4;
    };
  } __RXFBCON1bits_t;

extern __at(0x0E72) volatile __RXFBCON1bits_t RXFBCON1bits;

#define _F2BP_0                 0x01
#define _F2BP_1                 0x02
#define _F2BP_2                 0x04
#define _F2BP_3                 0x08
#define _F3BP_0                 0x10
#define _F3BP_1                 0x20
#define _F3BP_2                 0x40
#define _F3BP_3                 0x80

//==============================================================================


//==============================================================================
//        RXFBCON2 Bits

extern __at(0x0E73) __sfr RXFBCON2;

typedef union
  {
  struct
    {
    unsigned F4BP_0             : 1;
    unsigned F4BP_1             : 1;
    unsigned F4BP_2             : 1;
    unsigned F4BP_3             : 1;
    unsigned F5BP_0             : 1;
    unsigned F5BP_1             : 1;
    unsigned F5BP_2             : 1;
    unsigned F5BP_3             : 1;
    };

  struct
    {
    unsigned F4BP_              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned F5BP_              : 4;
    };
  } __RXFBCON2bits_t;

extern __at(0x0E73) volatile __RXFBCON2bits_t RXFBCON2bits;

#define _F4BP_0                 0x01
#define _F4BP_1                 0x02
#define _F4BP_2                 0x04
#define _F4BP_3                 0x08
#define _F5BP_0                 0x10
#define _F5BP_1                 0x20
#define _F5BP_2                 0x40
#define _F5BP_3                 0x80

//==============================================================================


//==============================================================================
//        RXFBCON3 Bits

extern __at(0x0E74) __sfr RXFBCON3;

typedef union
  {
  struct
    {
    unsigned F6BP_0             : 1;
    unsigned F6BP_1             : 1;
    unsigned F6BP_2             : 1;
    unsigned F6BP_3             : 1;
    unsigned F7BP_0             : 1;
    unsigned F7BP_1             : 1;
    unsigned F7BP_2             : 1;
    unsigned F7BP_3             : 1;
    };

  struct
    {
    unsigned F6BP_              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned F7BP_              : 4;
    };
  } __RXFBCON3bits_t;

extern __at(0x0E74) volatile __RXFBCON3bits_t RXFBCON3bits;

#define _F6BP_0                 0x01
#define _F6BP_1                 0x02
#define _F6BP_2                 0x04
#define _F6BP_3                 0x08
#define _F7BP_0                 0x10
#define _F7BP_1                 0x20
#define _F7BP_2                 0x40
#define _F7BP_3                 0x80

//==============================================================================


//==============================================================================
//        RXFBCON4 Bits

extern __at(0x0E75) __sfr RXFBCON4;

typedef union
  {
  struct
    {
    unsigned F8BP_0             : 1;
    unsigned F8BP_1             : 1;
    unsigned F8BP_2             : 1;
    unsigned F8BP_3             : 1;
    unsigned F9BP_0             : 1;
    unsigned F9BP_1             : 1;
    unsigned F9BP_2             : 1;
    unsigned F9BP_3             : 1;
    };

  struct
    {
    unsigned F8BP_              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned F9BP_              : 4;
    };
  } __RXFBCON4bits_t;

extern __at(0x0E75) volatile __RXFBCON4bits_t RXFBCON4bits;

#define _F8BP_0                 0x01
#define _F8BP_1                 0x02
#define _F8BP_2                 0x04
#define _F8BP_3                 0x08
#define _F9BP_0                 0x10
#define _F9BP_1                 0x20
#define _F9BP_2                 0x40
#define _F9BP_3                 0x80

//==============================================================================


//==============================================================================
//        RXFBCON5 Bits

extern __at(0x0E76) __sfr RXFBCON5;

typedef union
  {
  struct
    {
    unsigned F10BP_0            : 1;
    unsigned F10BP_1            : 1;
    unsigned F10BP_2            : 1;
    unsigned F10BP_3            : 1;
    unsigned F11BP_0            : 1;
    unsigned F11BP_1            : 1;
    unsigned F11BP_2            : 1;
    unsigned F11BP_3            : 1;
    };

  struct
    {
    unsigned F10BP_             : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned F11BP_             : 4;
    };
  } __RXFBCON5bits_t;

extern __at(0x0E76) volatile __RXFBCON5bits_t RXFBCON5bits;

#define _F10BP_0                0x01
#define _F10BP_1                0x02
#define _F10BP_2                0x04
#define _F10BP_3                0x08
#define _F11BP_0                0x10
#define _F11BP_1                0x20
#define _F11BP_2                0x40
#define _F11BP_3                0x80

//==============================================================================


//==============================================================================
//        RXFBCON6 Bits

extern __at(0x0E77) __sfr RXFBCON6;

typedef union
  {
  struct
    {
    unsigned F12BP_0            : 1;
    unsigned F12BP_1            : 1;
    unsigned F12BP_2            : 1;
    unsigned F12BP_3            : 1;
    unsigned F13BP_0            : 1;
    unsigned F13BP_1            : 1;
    unsigned F13BP_2            : 1;
    unsigned F13BP_3            : 1;
    };

  struct
    {
    unsigned F12BP_             : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned F13BP_             : 4;
    };
  } __RXFBCON6bits_t;

extern __at(0x0E77) volatile __RXFBCON6bits_t RXFBCON6bits;

#define _F12BP_0                0x01
#define _F12BP_1                0x02
#define _F12BP_2                0x04
#define _F12BP_3                0x08
#define _F13BP_0                0x10
#define _F13BP_1                0x20
#define _F13BP_2                0x40
#define _F13BP_3                0x80

//==============================================================================


//==============================================================================
//        RXFBCON7 Bits

extern __at(0x0E78) __sfr RXFBCON7;

typedef union
  {
  struct
    {
    unsigned F14BP_0            : 1;
    unsigned F14BP_1            : 1;
    unsigned F14BP_2            : 1;
    unsigned F14BP_3            : 1;
    unsigned F15BP_0            : 1;
    unsigned F15BP_1            : 1;
    unsigned F15BP_2            : 1;
    unsigned F15BP_3            : 1;
    };

  struct
    {
    unsigned F14BP_             : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned F15BP_             : 4;
    };
  } __RXFBCON7bits_t;

extern __at(0x0E78) volatile __RXFBCON7bits_t RXFBCON7bits;

#define _F14BP_0                0x01
#define _F14BP_1                0x02
#define _F14BP_2                0x04
#define _F14BP_3                0x08
#define _F15BP_0                0x10
#define _F15BP_1                0x20
#define _F15BP_2                0x40
#define _F15BP_3                0x80

//==============================================================================


//==============================================================================
//        MSEL0 Bits

extern __at(0x0E79) __sfr MSEL0;

typedef union
  {
  struct
    {
    unsigned FIL0_0             : 1;
    unsigned FIL0_1             : 1;
    unsigned FIL1_0             : 1;
    unsigned FIL1_1             : 1;
    unsigned FIL2_0             : 1;
    unsigned FIL2_1             : 1;
    unsigned FIL3_0             : 1;
    unsigned FIL3_1             : 1;
    };

  struct
    {
    unsigned FIL0_              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned FIL1_              : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned FIL2_              : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned FIL3_              : 2;
    };
  } __MSEL0bits_t;

extern __at(0x0E79) volatile __MSEL0bits_t MSEL0bits;

#define _FIL0_0                 0x01
#define _FIL0_1                 0x02
#define _FIL1_0                 0x04
#define _FIL1_1                 0x08
#define _FIL2_0                 0x10
#define _FIL2_1                 0x20
#define _FIL3_0                 0x40
#define _FIL3_1                 0x80

//==============================================================================


//==============================================================================
//        MSEL1 Bits

extern __at(0x0E7A) __sfr MSEL1;

typedef union
  {
  struct
    {
    unsigned FIL4_0             : 1;
    unsigned FIL4_1             : 1;
    unsigned FIL5_0             : 1;
    unsigned FIL5_1             : 1;
    unsigned FIL6_0             : 1;
    unsigned FIL6_1             : 1;
    unsigned FIL7_0             : 1;
    unsigned FIL7_1             : 1;
    };

  struct
    {
    unsigned FIL4_              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned FIL5_              : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned FIL6_              : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned FIL7_              : 2;
    };
  } __MSEL1bits_t;

extern __at(0x0E7A) volatile __MSEL1bits_t MSEL1bits;

#define _FIL4_0                 0x01
#define _FIL4_1                 0x02
#define _FIL5_0                 0x04
#define _FIL5_1                 0x08
#define _FIL6_0                 0x10
#define _FIL6_1                 0x20
#define _FIL7_0                 0x40
#define _FIL7_1                 0x80

//==============================================================================


//==============================================================================
//        MSEL2 Bits

extern __at(0x0E7B) __sfr MSEL2;

typedef union
  {
  struct
    {
    unsigned FIL8_0             : 1;
    unsigned FIL8_1             : 1;
    unsigned FIL9_0             : 1;
    unsigned FIL9_1             : 1;
    unsigned FIL10_0            : 1;
    unsigned FIL10_1            : 1;
    unsigned FIL11_0            : 1;
    unsigned FIL11_1            : 1;
    };

  struct
    {
    unsigned FIL8_              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned FIL9_              : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned FIL10_             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned FIL11_             : 2;
    };
  } __MSEL2bits_t;

extern __at(0x0E7B) volatile __MSEL2bits_t MSEL2bits;

#define _FIL8_0                 0x01
#define _FIL8_1                 0x02
#define _FIL9_0                 0x04
#define _FIL9_1                 0x08
#define _FIL10_0                0x10
#define _FIL10_1                0x20
#define _FIL11_0                0x40
#define _FIL11_1                0x80

//==============================================================================


//==============================================================================
//        MSEL3 Bits

extern __at(0x0E7C) __sfr MSEL3;

typedef union
  {
  struct
    {
    unsigned FIL12_0            : 1;
    unsigned FIL12_1            : 1;
    unsigned FIL13_0            : 1;
    unsigned FIL13_1            : 1;
    unsigned FIL14_0            : 1;
    unsigned FIL14_1            : 1;
    unsigned FIL15_0            : 1;
    unsigned FIL15_1            : 1;
    };

  struct
    {
    unsigned FIL12_             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned FIL13_             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned FIL14_             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned FIL15_             : 2;
    };
  } __MSEL3bits_t;

extern __at(0x0E7C) volatile __MSEL3bits_t MSEL3bits;

#define _FIL12_0                0x01
#define _FIL12_1                0x02
#define _FIL13_0                0x04
#define _FIL13_1                0x08
#define _FIL14_0                0x10
#define _FIL14_1                0x20
#define _FIL15_0                0x40
#define _FIL15_1                0x80

//==============================================================================


//==============================================================================
//        BSEL0 Bits

extern __at(0x0E7D) __sfr BSEL0;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned B0TXEN               : 1;
  unsigned B1TXEN               : 1;
  unsigned B2TXEN               : 1;
  unsigned B3TXEN               : 1;
  unsigned B4TXEN               : 1;
  unsigned B5TXEN               : 1;
  } __BSEL0bits_t;

extern __at(0x0E7D) volatile __BSEL0bits_t BSEL0bits;

#define _B0TXEN                 0x04
#define _B1TXEN                 0x08
#define _B2TXEN                 0x10
#define _B3TXEN                 0x20
#define _B4TXEN                 0x40
#define _B5TXEN                 0x80

//==============================================================================


//==============================================================================
//        BIE0 Bits

extern __at(0x0E7E) __sfr BIE0;

typedef struct
  {
  unsigned RXB0IE               : 1;
  unsigned RXB1IE               : 1;
  unsigned B0IE                 : 1;
  unsigned B1IE                 : 1;
  unsigned B2IE                 : 1;
  unsigned B3IE                 : 1;
  unsigned B4IE                 : 1;
  unsigned B5IE                 : 1;
  } __BIE0bits_t;

extern __at(0x0E7E) volatile __BIE0bits_t BIE0bits;

#define _RXB0IE                 0x01
#define _RXB1IE                 0x02
#define _B0IE                   0x04
#define _B1IE                   0x08
#define _B2IE                   0x10
#define _B3IE                   0x20
#define _B4IE                   0x40
#define _B5IE                   0x80

//==============================================================================


//==============================================================================
//        TXBIE Bits

extern __at(0x0E7F) __sfr TXBIE;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned TXB0IE               : 1;
  unsigned TXB1IE               : 1;
  unsigned TXB2IE               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __TXBIEbits_t;

extern __at(0x0E7F) volatile __TXBIEbits_t TXBIEbits;

#define _TXBIE_TXB0IE           0x04
#define _TXBIE_TXB1IE           0x08
#define _TXBIE_TXB2IE           0x10

//==============================================================================


//==============================================================================
//        B0CON Bits

extern __at(0x0E80) __sfr B0CON;

typedef union
  {
  struct
    {
    unsigned FILHIT0_TXPRI0     : 1;
    unsigned FILHIT1_TXPRI1     : 1;
    unsigned FILHIT2_RTREN      : 1;
    unsigned FILHIT3_TXREQ      : 1;
    unsigned FILHIT4_TXERR      : 1;
    unsigned RXRTRRO_TXLARB     : 1;
    unsigned RXM1_TXABT         : 1;
    unsigned RXFUL_TXBIF        : 1;
    };

  struct
    {
    unsigned FILHIT0            : 1;
    unsigned FILHIT1            : 1;
    unsigned FILHIT2            : 1;
    unsigned FILHIT3            : 1;
    unsigned FILHIT4            : 1;
    unsigned RXRTRRO            : 1;
    unsigned RXM1               : 1;
    unsigned RXFUL              : 1;
    };

  struct
    {
    unsigned TXPRI0             : 1;
    unsigned TXPRI1             : 1;
    unsigned RTREN              : 1;
    unsigned TXREQ              : 1;
    unsigned TXERR              : 1;
    unsigned TXLARB             : 1;
    unsigned TXABT              : 1;
    unsigned TXBIF              : 1;
    };

  struct
    {
    unsigned FILHIT             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned TXPRI              : 2;
    unsigned                    : 6;
    };
  } __B0CONbits_t;

extern __at(0x0E80) volatile __B0CONbits_t B0CONbits;

#define _FILHIT0_TXPRI0         0x01
#define _FILHIT0                0x01
#define _TXPRI0                 0x01
#define _FILHIT1_TXPRI1         0x02
#define _FILHIT1                0x02
#define _TXPRI1                 0x02
#define _FILHIT2_RTREN          0x04
#define _FILHIT2                0x04
#define _RTREN                  0x04
#define _FILHIT3_TXREQ          0x08
#define _FILHIT3                0x08
#define _TXREQ                  0x08
#define _FILHIT4_TXERR          0x10
#define _FILHIT4                0x10
#define _TXERR                  0x10
#define _RXRTRRO_TXLARB         0x20
#define _RXRTRRO                0x20
#define _TXLARB                 0x20
#define _RXM1_TXABT             0x40
#define _RXM1                   0x40
#define _TXABT                  0x40
#define _RXFUL_TXBIF            0x80
#define _RXFUL                  0x80
#define _TXBIF                  0x80

//==============================================================================


//==============================================================================
//        B0SIDH Bits

extern __at(0x0E81) __sfr B0SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __B0SIDHbits_t;

extern __at(0x0E81) volatile __B0SIDHbits_t B0SIDHbits;

#define _SID3                   0x01
#define _SID4                   0x02
#define _SID5                   0x04
#define _SID6                   0x08
#define _SID7                   0x10
#define _SID8                   0x20
#define _SID9                   0x40
#define _SID10                  0x80

//==============================================================================


//==============================================================================
//        B0SIDL Bits

extern __at(0x0E82) __sfr B0SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDE              : 1;
    unsigned SRR                : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __B0SIDLbits_t;

extern __at(0x0E82) volatile __B0SIDLbits_t B0SIDLbits;

#define _EID16                  0x01
#define _EID17                  0x02
#define _EXIDE                  0x08
#define _SRR                    0x10
#define _SID0                   0x20
#define _SID1                   0x40
#define _SID2                   0x80

//==============================================================================


//==============================================================================
//        B0EIDH Bits

extern __at(0x0E83) __sfr B0EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __B0EIDHbits_t;

extern __at(0x0E83) volatile __B0EIDHbits_t B0EIDHbits;

#define _EID8                   0x01
#define _EID9                   0x02
#define _EID10                  0x04
#define _EID11                  0x08
#define _EID12                  0x10
#define _EID13                  0x20
#define _EID14                  0x40
#define _EID15                  0x80

//==============================================================================


//==============================================================================
//        B0EIDL Bits

extern __at(0x0E84) __sfr B0EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __B0EIDLbits_t;

extern __at(0x0E84) volatile __B0EIDLbits_t B0EIDLbits;

#define _EID0                   0x01
#define _EID1                   0x02
#define _EID2                   0x04
#define _EID3                   0x08
#define _EID4                   0x10
#define _EID5                   0x20
#define _EID6                   0x40
#define _EID7                   0x80

//==============================================================================


//==============================================================================
//        B0DLC Bits

extern __at(0x0E85) __sfr B0DLC;

typedef union
  {
  struct
    {
    unsigned DLC0               : 1;
    unsigned DLC1               : 1;
    unsigned DLC2               : 1;
    unsigned DLC3               : 1;
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RXRTR_TXRTR        : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RXRTR              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TXRTR              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DLC                : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned RB                 : 2;
    unsigned                    : 2;
    };
  } __B0DLCbits_t;

extern __at(0x0E85) volatile __B0DLCbits_t B0DLCbits;

#define _DLC0                   0x01
#define _DLC1                   0x02
#define _DLC2                   0x04
#define _DLC3                   0x08
#define _RB0                    0x10
#define _RB1                    0x20
#define _RXRTR_TXRTR            0x40
#define _RXRTR                  0x40
#define _TXRTR                  0x40

//==============================================================================


//==============================================================================
//        B0D0 Bits

extern __at(0x0E86) __sfr B0D0;

typedef struct
  {
  unsigned B0D00                : 1;
  unsigned B0D01                : 1;
  unsigned B0D02                : 1;
  unsigned B0D03                : 1;
  unsigned B0D04                : 1;
  unsigned B0D05                : 1;
  unsigned B0D06                : 1;
  unsigned B0D07                : 1;
  } __B0D0bits_t;

extern __at(0x0E86) volatile __B0D0bits_t B0D0bits;

#define _B0D00                  0x01
#define _B0D01                  0x02
#define _B0D02                  0x04
#define _B0D03                  0x08
#define _B0D04                  0x10
#define _B0D05                  0x20
#define _B0D06                  0x40
#define _B0D07                  0x80

//==============================================================================


//==============================================================================
//        B0D1 Bits

extern __at(0x0E87) __sfr B0D1;

typedef struct
  {
  unsigned B0D10                : 1;
  unsigned B0D11                : 1;
  unsigned B0D12                : 1;
  unsigned B0D13                : 1;
  unsigned B0D14                : 1;
  unsigned B0D15                : 1;
  unsigned B0D16                : 1;
  unsigned B0D17                : 1;
  } __B0D1bits_t;

extern __at(0x0E87) volatile __B0D1bits_t B0D1bits;

#define _B0D10                  0x01
#define _B0D11                  0x02
#define _B0D12                  0x04
#define _B0D13                  0x08
#define _B0D14                  0x10
#define _B0D15                  0x20
#define _B0D16                  0x40
#define _B0D17                  0x80

//==============================================================================


//==============================================================================
//        B0D2 Bits

extern __at(0x0E88) __sfr B0D2;

typedef struct
  {
  unsigned B0D20                : 1;
  unsigned B0D21                : 1;
  unsigned B0D22                : 1;
  unsigned B0D23                : 1;
  unsigned B0D24                : 1;
  unsigned B0D25                : 1;
  unsigned B0D26                : 1;
  unsigned B0D27                : 1;
  } __B0D2bits_t;

extern __at(0x0E88) volatile __B0D2bits_t B0D2bits;

#define _B0D20                  0x01
#define _B0D21                  0x02
#define _B0D22                  0x04
#define _B0D23                  0x08
#define _B0D24                  0x10
#define _B0D25                  0x20
#define _B0D26                  0x40
#define _B0D27                  0x80

//==============================================================================


//==============================================================================
//        B0D3 Bits

extern __at(0x0E89) __sfr B0D3;

typedef struct
  {
  unsigned B0D30                : 1;
  unsigned B0D31                : 1;
  unsigned B0D32                : 1;
  unsigned B0D33                : 1;
  unsigned B0D34                : 1;
  unsigned B0D35                : 1;
  unsigned B0D36                : 1;
  unsigned B0D37                : 1;
  } __B0D3bits_t;

extern __at(0x0E89) volatile __B0D3bits_t B0D3bits;

#define _B0D30                  0x01
#define _B0D31                  0x02
#define _B0D32                  0x04
#define _B0D33                  0x08
#define _B0D34                  0x10
#define _B0D35                  0x20
#define _B0D36                  0x40
#define _B0D37                  0x80

//==============================================================================


//==============================================================================
//        B0D4 Bits

extern __at(0x0E8A) __sfr B0D4;

typedef struct
  {
  unsigned B0D40                : 1;
  unsigned B0D41                : 1;
  unsigned B0D42                : 1;
  unsigned B0D43                : 1;
  unsigned B0D44                : 1;
  unsigned B0D45                : 1;
  unsigned B0D46                : 1;
  unsigned B0D47                : 1;
  } __B0D4bits_t;

extern __at(0x0E8A) volatile __B0D4bits_t B0D4bits;

#define _B0D40                  0x01
#define _B0D41                  0x02
#define _B0D42                  0x04
#define _B0D43                  0x08
#define _B0D44                  0x10
#define _B0D45                  0x20
#define _B0D46                  0x40
#define _B0D47                  0x80

//==============================================================================


//==============================================================================
//        B0D5 Bits

extern __at(0x0E8B) __sfr B0D5;

typedef struct
  {
  unsigned B0D50                : 1;
  unsigned B0D51                : 1;
  unsigned B0D52                : 1;
  unsigned B0D53                : 1;
  unsigned B0D54                : 1;
  unsigned B0D55                : 1;
  unsigned B0D56                : 1;
  unsigned B0D57                : 1;
  } __B0D5bits_t;

extern __at(0x0E8B) volatile __B0D5bits_t B0D5bits;

#define _B0D50                  0x01
#define _B0D51                  0x02
#define _B0D52                  0x04
#define _B0D53                  0x08
#define _B0D54                  0x10
#define _B0D55                  0x20
#define _B0D56                  0x40
#define _B0D57                  0x80

//==============================================================================


//==============================================================================
//        B0D6 Bits

extern __at(0x0E8C) __sfr B0D6;

typedef struct
  {
  unsigned B0D60                : 1;
  unsigned B0D61                : 1;
  unsigned B0D62                : 1;
  unsigned B0D63                : 1;
  unsigned B0D64                : 1;
  unsigned B0D65                : 1;
  unsigned B0D66                : 1;
  unsigned B0D67                : 1;
  } __B0D6bits_t;

extern __at(0x0E8C) volatile __B0D6bits_t B0D6bits;

#define _B0D60                  0x01
#define _B0D61                  0x02
#define _B0D62                  0x04
#define _B0D63                  0x08
#define _B0D64                  0x10
#define _B0D65                  0x20
#define _B0D66                  0x40
#define _B0D67                  0x80

//==============================================================================


//==============================================================================
//        B0D7 Bits

extern __at(0x0E8D) __sfr B0D7;

typedef struct
  {
  unsigned B0D70                : 1;
  unsigned B0D71                : 1;
  unsigned B0D72                : 1;
  unsigned B0D73                : 1;
  unsigned B0D74                : 1;
  unsigned B0D75                : 1;
  unsigned B0D76                : 1;
  unsigned B0D77                : 1;
  } __B0D7bits_t;

extern __at(0x0E8D) volatile __B0D7bits_t B0D7bits;

#define _B0D70                  0x01
#define _B0D71                  0x02
#define _B0D72                  0x04
#define _B0D73                  0x08
#define _B0D74                  0x10
#define _B0D75                  0x20
#define _B0D76                  0x40
#define _B0D77                  0x80

//==============================================================================


//==============================================================================
//        CANSTAT_RO9 Bits

extern __at(0x0E8E) __sfr CANSTAT_RO9;

typedef union
  {
  struct
    {
    unsigned EICODE0            : 1;
    unsigned EICODE1_ICODE0     : 1;
    unsigned EICODE2_ICODE1     : 1;
    unsigned EICODE3_ICODE2     : 1;
    unsigned EICODE4            : 1;
    unsigned OPMODE0            : 1;
    unsigned OPMODE1            : 1;
    unsigned OPMODE2            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned EICODE1            : 1;
    unsigned EICODE2            : 1;
    unsigned EICODE3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ICODE0             : 1;
    unsigned ICODE1             : 1;
    unsigned ICODE2             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned EICODE             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ICODE              : 3;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 5;
    unsigned OPMODE             : 3;
    };
  } __CANSTAT_RO9bits_t;

extern __at(0x0E8E) volatile __CANSTAT_RO9bits_t CANSTAT_RO9bits;

#define _CANSTAT_RO9_EICODE0    0x01
#define _CANSTAT_RO9_EICODE1_ICODE0 0x02
#define _CANSTAT_RO9_EICODE1    0x02
#define _CANSTAT_RO9_ICODE0     0x02
#define _CANSTAT_RO9_EICODE2_ICODE1 0x04
#define _CANSTAT_RO9_EICODE2    0x04
#define _CANSTAT_RO9_ICODE1     0x04
#define _CANSTAT_RO9_EICODE3_ICODE2 0x08
#define _CANSTAT_RO9_EICODE3    0x08
#define _CANSTAT_RO9_ICODE2     0x08
#define _CANSTAT_RO9_EICODE4    0x10
#define _CANSTAT_RO9_OPMODE0    0x20
#define _CANSTAT_RO9_OPMODE1    0x40
#define _CANSTAT_RO9_OPMODE2    0x80

//==============================================================================


//==============================================================================
//        CANCON_RO9 Bits

extern __at(0x0E8F) __sfr CANCON_RO9;

typedef union
  {
  struct
    {
    unsigned FP0                : 1;
    unsigned WIN0_FP1           : 1;
    unsigned WIN1_FP2           : 1;
    unsigned WIN2_FP3           : 1;
    unsigned ABAT               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WIN0               : 1;
    unsigned WIN1               : 1;
    unsigned WIN2               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned FP1                : 1;
    unsigned FP2                : 1;
    unsigned FP3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned FP                 : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WIN                : 3;
    unsigned                    : 4;
    };
  } __CANCON_RO9bits_t;

extern __at(0x0E8F) volatile __CANCON_RO9bits_t CANCON_RO9bits;

#define _CANCON_RO9_FP0         0x01
#define _CANCON_RO9_WIN0_FP1    0x02
#define _CANCON_RO9_WIN0        0x02
#define _CANCON_RO9_FP1         0x02
#define _CANCON_RO9_WIN1_FP2    0x04
#define _CANCON_RO9_WIN1        0x04
#define _CANCON_RO9_FP2         0x04
#define _CANCON_RO9_WIN2_FP3    0x08
#define _CANCON_RO9_WIN2        0x08
#define _CANCON_RO9_FP3         0x08
#define _CANCON_RO9_ABAT        0x10

//==============================================================================


//==============================================================================
//        B1CON Bits

extern __at(0x0E90) __sfr B1CON;

typedef union
  {
  struct
    {
    unsigned FILHIT0_TXPRI0     : 1;
    unsigned FILHIT1_TXPRI1     : 1;
    unsigned FILHIT2_RTREN      : 1;
    unsigned FILHIT3_TXREQ      : 1;
    unsigned FILHIT4_TXERR      : 1;
    unsigned RXRTRRO_TXLARB     : 1;
    unsigned RXM1_TXABT         : 1;
    unsigned RXFUL_TXBIF        : 1;
    };

  struct
    {
    unsigned FILHIT0            : 1;
    unsigned FILHIT1            : 1;
    unsigned FILHIT2            : 1;
    unsigned FILHIT3            : 1;
    unsigned FILHIT4            : 1;
    unsigned RXRTRRO            : 1;
    unsigned RXM1               : 1;
    unsigned RXFUL              : 1;
    };

  struct
    {
    unsigned TXPRI0             : 1;
    unsigned TXPRI1             : 1;
    unsigned RTREN              : 1;
    unsigned TXREQ              : 1;
    unsigned TXERR              : 1;
    unsigned TXLARB             : 1;
    unsigned TXABT              : 1;
    unsigned TXBIF              : 1;
    };

  struct
    {
    unsigned FILHIT             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned TXPRI              : 2;
    unsigned                    : 6;
    };
  } __B1CONbits_t;

extern __at(0x0E90) volatile __B1CONbits_t B1CONbits;

#define _B1CON_FILHIT0_TXPRI0   0x01
#define _B1CON_FILHIT0          0x01
#define _B1CON_TXPRI0           0x01
#define _B1CON_FILHIT1_TXPRI1   0x02
#define _B1CON_FILHIT1          0x02
#define _B1CON_TXPRI1           0x02
#define _B1CON_FILHIT2_RTREN    0x04
#define _B1CON_FILHIT2          0x04
#define _B1CON_RTREN            0x04
#define _B1CON_FILHIT3_TXREQ    0x08
#define _B1CON_FILHIT3          0x08
#define _B1CON_TXREQ            0x08
#define _B1CON_FILHIT4_TXERR    0x10
#define _B1CON_FILHIT4          0x10
#define _B1CON_TXERR            0x10
#define _B1CON_RXRTRRO_TXLARB   0x20
#define _B1CON_RXRTRRO          0x20
#define _B1CON_TXLARB           0x20
#define _B1CON_RXM1_TXABT       0x40
#define _B1CON_RXM1             0x40
#define _B1CON_TXABT            0x40
#define _B1CON_RXFUL_TXBIF      0x80
#define _B1CON_RXFUL            0x80
#define _B1CON_TXBIF            0x80

//==============================================================================


//==============================================================================
//        B1SIDH Bits

extern __at(0x0E91) __sfr B1SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __B1SIDHbits_t;

extern __at(0x0E91) volatile __B1SIDHbits_t B1SIDHbits;

#define _B1SIDH_SID3            0x01
#define _B1SIDH_SID4            0x02
#define _B1SIDH_SID5            0x04
#define _B1SIDH_SID6            0x08
#define _B1SIDH_SID7            0x10
#define _B1SIDH_SID8            0x20
#define _B1SIDH_SID9            0x40
#define _B1SIDH_SID10           0x80

//==============================================================================


//==============================================================================
//        B1SIDL Bits

extern __at(0x0E92) __sfr B1SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDE              : 1;
    unsigned SRR                : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __B1SIDLbits_t;

extern __at(0x0E92) volatile __B1SIDLbits_t B1SIDLbits;

#define _B1SIDL_EID16           0x01
#define _B1SIDL_EID17           0x02
#define _B1SIDL_EXIDE           0x08
#define _B1SIDL_SRR             0x10
#define _B1SIDL_SID0            0x20
#define _B1SIDL_SID1            0x40
#define _B1SIDL_SID2            0x80

//==============================================================================


//==============================================================================
//        B1EIDH Bits

extern __at(0x0E93) __sfr B1EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __B1EIDHbits_t;

extern __at(0x0E93) volatile __B1EIDHbits_t B1EIDHbits;

#define _B1EIDH_EID8            0x01
#define _B1EIDH_EID9            0x02
#define _B1EIDH_EID10           0x04
#define _B1EIDH_EID11           0x08
#define _B1EIDH_EID12           0x10
#define _B1EIDH_EID13           0x20
#define _B1EIDH_EID14           0x40
#define _B1EIDH_EID15           0x80

//==============================================================================


//==============================================================================
//        B1EIDL Bits

extern __at(0x0E94) __sfr B1EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __B1EIDLbits_t;

extern __at(0x0E94) volatile __B1EIDLbits_t B1EIDLbits;

#define _B1EIDL_EID0            0x01
#define _B1EIDL_EID1            0x02
#define _B1EIDL_EID2            0x04
#define _B1EIDL_EID3            0x08
#define _B1EIDL_EID4            0x10
#define _B1EIDL_EID5            0x20
#define _B1EIDL_EID6            0x40
#define _B1EIDL_EID7            0x80

//==============================================================================


//==============================================================================
//        B1DLC Bits

extern __at(0x0E95) __sfr B1DLC;

typedef union
  {
  struct
    {
    unsigned DLC0               : 1;
    unsigned DLC1               : 1;
    unsigned DLC2               : 1;
    unsigned DLC3               : 1;
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RXRTR_TXRTR        : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RXRTR              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TXRTR              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DLC                : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned RB                 : 2;
    unsigned                    : 2;
    };
  } __B1DLCbits_t;

extern __at(0x0E95) volatile __B1DLCbits_t B1DLCbits;

#define _B1DLC_DLC0             0x01
#define _B1DLC_DLC1             0x02
#define _B1DLC_DLC2             0x04
#define _B1DLC_DLC3             0x08
#define _B1DLC_RB0              0x10
#define _B1DLC_RB1              0x20
#define _B1DLC_RXRTR_TXRTR      0x40
#define _B1DLC_RXRTR            0x40
#define _B1DLC_TXRTR            0x40

//==============================================================================


//==============================================================================
//        B1D0 Bits

extern __at(0x0E96) __sfr B1D0;

typedef struct
  {
  unsigned B1D00                : 1;
  unsigned B1D01                : 1;
  unsigned B1D02                : 1;
  unsigned B1D03                : 1;
  unsigned B1D04                : 1;
  unsigned B1D05                : 1;
  unsigned B1D06                : 1;
  unsigned B1D07                : 1;
  } __B1D0bits_t;

extern __at(0x0E96) volatile __B1D0bits_t B1D0bits;

#define _B1D00                  0x01
#define _B1D01                  0x02
#define _B1D02                  0x04
#define _B1D03                  0x08
#define _B1D04                  0x10
#define _B1D05                  0x20
#define _B1D06                  0x40
#define _B1D07                  0x80

//==============================================================================


//==============================================================================
//        B1D1 Bits

extern __at(0x0E97) __sfr B1D1;

typedef struct
  {
  unsigned B1D10                : 1;
  unsigned B1D11                : 1;
  unsigned B1D12                : 1;
  unsigned B1D13                : 1;
  unsigned B1D14                : 1;
  unsigned B1D15                : 1;
  unsigned B1D16                : 1;
  unsigned B1D17                : 1;
  } __B1D1bits_t;

extern __at(0x0E97) volatile __B1D1bits_t B1D1bits;

#define _B1D10                  0x01
#define _B1D11                  0x02
#define _B1D12                  0x04
#define _B1D13                  0x08
#define _B1D14                  0x10
#define _B1D15                  0x20
#define _B1D16                  0x40
#define _B1D17                  0x80

//==============================================================================


//==============================================================================
//        B1D2 Bits

extern __at(0x0E98) __sfr B1D2;

typedef struct
  {
  unsigned B1D20                : 1;
  unsigned B1D21                : 1;
  unsigned B1D22                : 1;
  unsigned B1D23                : 1;
  unsigned B1D24                : 1;
  unsigned B1D25                : 1;
  unsigned B1D26                : 1;
  unsigned B1D27                : 1;
  } __B1D2bits_t;

extern __at(0x0E98) volatile __B1D2bits_t B1D2bits;

#define _B1D20                  0x01
#define _B1D21                  0x02
#define _B1D22                  0x04
#define _B1D23                  0x08
#define _B1D24                  0x10
#define _B1D25                  0x20
#define _B1D26                  0x40
#define _B1D27                  0x80

//==============================================================================


//==============================================================================
//        B1D3 Bits

extern __at(0x0E99) __sfr B1D3;

typedef struct
  {
  unsigned B1D30                : 1;
  unsigned B1D31                : 1;
  unsigned B1D32                : 1;
  unsigned B1D33                : 1;
  unsigned B1D34                : 1;
  unsigned B1D35                : 1;
  unsigned B1D36                : 1;
  unsigned B1D37                : 1;
  } __B1D3bits_t;

extern __at(0x0E99) volatile __B1D3bits_t B1D3bits;

#define _B1D30                  0x01
#define _B1D31                  0x02
#define _B1D32                  0x04
#define _B1D33                  0x08
#define _B1D34                  0x10
#define _B1D35                  0x20
#define _B1D36                  0x40
#define _B1D37                  0x80

//==============================================================================


//==============================================================================
//        B1D4 Bits

extern __at(0x0E9A) __sfr B1D4;

typedef struct
  {
  unsigned B1D40                : 1;
  unsigned B1D41                : 1;
  unsigned B1D42                : 1;
  unsigned B1D43                : 1;
  unsigned B1D44                : 1;
  unsigned B1D45                : 1;
  unsigned B1D46                : 1;
  unsigned B1D47                : 1;
  } __B1D4bits_t;

extern __at(0x0E9A) volatile __B1D4bits_t B1D4bits;

#define _B1D40                  0x01
#define _B1D41                  0x02
#define _B1D42                  0x04
#define _B1D43                  0x08
#define _B1D44                  0x10
#define _B1D45                  0x20
#define _B1D46                  0x40
#define _B1D47                  0x80

//==============================================================================


//==============================================================================
//        B1D5 Bits

extern __at(0x0E9B) __sfr B1D5;

typedef struct
  {
  unsigned B1D50                : 1;
  unsigned B1D51                : 1;
  unsigned B1D52                : 1;
  unsigned B1D53                : 1;
  unsigned B1D54                : 1;
  unsigned B1D55                : 1;
  unsigned B1D56                : 1;
  unsigned B1D57                : 1;
  } __B1D5bits_t;

extern __at(0x0E9B) volatile __B1D5bits_t B1D5bits;

#define _B1D50                  0x01
#define _B1D51                  0x02
#define _B1D52                  0x04
#define _B1D53                  0x08
#define _B1D54                  0x10
#define _B1D55                  0x20
#define _B1D56                  0x40
#define _B1D57                  0x80

//==============================================================================


//==============================================================================
//        B1D6 Bits

extern __at(0x0E9C) __sfr B1D6;

typedef struct
  {
  unsigned B1D60                : 1;
  unsigned B1D61                : 1;
  unsigned B1D62                : 1;
  unsigned B1D63                : 1;
  unsigned B1D64                : 1;
  unsigned B1D65                : 1;
  unsigned B1D66                : 1;
  unsigned B1D67                : 1;
  } __B1D6bits_t;

extern __at(0x0E9C) volatile __B1D6bits_t B1D6bits;

#define _B1D60                  0x01
#define _B1D61                  0x02
#define _B1D62                  0x04
#define _B1D63                  0x08
#define _B1D64                  0x10
#define _B1D65                  0x20
#define _B1D66                  0x40
#define _B1D67                  0x80

//==============================================================================


//==============================================================================
//        B1D7 Bits

extern __at(0x0E9D) __sfr B1D7;

typedef struct
  {
  unsigned B1D70                : 1;
  unsigned B1D71                : 1;
  unsigned B1D72                : 1;
  unsigned B1D73                : 1;
  unsigned B1D74                : 1;
  unsigned B1D75                : 1;
  unsigned B1D76                : 1;
  unsigned B1D77                : 1;
  } __B1D7bits_t;

extern __at(0x0E9D) volatile __B1D7bits_t B1D7bits;

#define _B1D70                  0x01
#define _B1D71                  0x02
#define _B1D72                  0x04
#define _B1D73                  0x08
#define _B1D74                  0x10
#define _B1D75                  0x20
#define _B1D76                  0x40
#define _B1D77                  0x80

//==============================================================================


//==============================================================================
//        CANSTAT_RO8 Bits

extern __at(0x0E9E) __sfr CANSTAT_RO8;

typedef union
  {
  struct
    {
    unsigned EICODE0            : 1;
    unsigned EICODE1_ICODE0     : 1;
    unsigned EICODE2_ICODE1     : 1;
    unsigned EICODE3_ICODE2     : 1;
    unsigned EICODE4            : 1;
    unsigned OPMODE0            : 1;
    unsigned OPMODE1            : 1;
    unsigned OPMODE2            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned EICODE1            : 1;
    unsigned EICODE2            : 1;
    unsigned EICODE3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ICODE0             : 1;
    unsigned ICODE1             : 1;
    unsigned ICODE2             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned EICODE             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ICODE              : 3;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 5;
    unsigned OPMODE             : 3;
    };
  } __CANSTAT_RO8bits_t;

extern __at(0x0E9E) volatile __CANSTAT_RO8bits_t CANSTAT_RO8bits;

#define _CANSTAT_RO8_EICODE0    0x01
#define _CANSTAT_RO8_EICODE1_ICODE0 0x02
#define _CANSTAT_RO8_EICODE1    0x02
#define _CANSTAT_RO8_ICODE0     0x02
#define _CANSTAT_RO8_EICODE2_ICODE1 0x04
#define _CANSTAT_RO8_EICODE2    0x04
#define _CANSTAT_RO8_ICODE1     0x04
#define _CANSTAT_RO8_EICODE3_ICODE2 0x08
#define _CANSTAT_RO8_EICODE3    0x08
#define _CANSTAT_RO8_ICODE2     0x08
#define _CANSTAT_RO8_EICODE4    0x10
#define _CANSTAT_RO8_OPMODE0    0x20
#define _CANSTAT_RO8_OPMODE1    0x40
#define _CANSTAT_RO8_OPMODE2    0x80

//==============================================================================


//==============================================================================
//        CANCON_RO8 Bits

extern __at(0x0E9F) __sfr CANCON_RO8;

typedef union
  {
  struct
    {
    unsigned FP0                : 1;
    unsigned WIN0_FP1           : 1;
    unsigned WIN1_FP2           : 1;
    unsigned WIN2_FP3           : 1;
    unsigned ABAT               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WIN0               : 1;
    unsigned WIN1               : 1;
    unsigned WIN2               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned FP1                : 1;
    unsigned FP2                : 1;
    unsigned FP3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned FP                 : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WIN                : 3;
    unsigned                    : 4;
    };
  } __CANCON_RO8bits_t;

extern __at(0x0E9F) volatile __CANCON_RO8bits_t CANCON_RO8bits;

#define _CANCON_RO8_FP0         0x01
#define _CANCON_RO8_WIN0_FP1    0x02
#define _CANCON_RO8_WIN0        0x02
#define _CANCON_RO8_FP1         0x02
#define _CANCON_RO8_WIN1_FP2    0x04
#define _CANCON_RO8_WIN1        0x04
#define _CANCON_RO8_FP2         0x04
#define _CANCON_RO8_WIN2_FP3    0x08
#define _CANCON_RO8_WIN2        0x08
#define _CANCON_RO8_FP3         0x08
#define _CANCON_RO8_ABAT        0x10

//==============================================================================


//==============================================================================
//        B2CON Bits

extern __at(0x0EA0) __sfr B2CON;

typedef union
  {
  struct
    {
    unsigned FILHIT0_TXPRI0     : 1;
    unsigned FILHIT1_TXPRI1     : 1;
    unsigned FILHIT2_RTREN      : 1;
    unsigned FILHIT3_TXREQ      : 1;
    unsigned FILHIT4_TXERR      : 1;
    unsigned RXRTRRO_TXLARB     : 1;
    unsigned RXM1_TXABT         : 1;
    unsigned RXFUL_TXBIF        : 1;
    };

  struct
    {
    unsigned FILHIT0            : 1;
    unsigned FILHIT1            : 1;
    unsigned FILHIT2            : 1;
    unsigned FILHIT3            : 1;
    unsigned FILHIT4            : 1;
    unsigned RXRTRRO            : 1;
    unsigned RXM1               : 1;
    unsigned RXFUL              : 1;
    };

  struct
    {
    unsigned TXPRI0             : 1;
    unsigned TXPRI1             : 1;
    unsigned RTREN              : 1;
    unsigned TXREQ              : 1;
    unsigned TXERR              : 1;
    unsigned TXLARB             : 1;
    unsigned TXABT              : 1;
    unsigned TXBIF              : 1;
    };

  struct
    {
    unsigned FILHIT             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned TXPRI              : 2;
    unsigned                    : 6;
    };
  } __B2CONbits_t;

extern __at(0x0EA0) volatile __B2CONbits_t B2CONbits;

#define _B2CON_FILHIT0_TXPRI0   0x01
#define _B2CON_FILHIT0          0x01
#define _B2CON_TXPRI0           0x01
#define _B2CON_FILHIT1_TXPRI1   0x02
#define _B2CON_FILHIT1          0x02
#define _B2CON_TXPRI1           0x02
#define _B2CON_FILHIT2_RTREN    0x04
#define _B2CON_FILHIT2          0x04
#define _B2CON_RTREN            0x04
#define _B2CON_FILHIT3_TXREQ    0x08
#define _B2CON_FILHIT3          0x08
#define _B2CON_TXREQ            0x08
#define _B2CON_FILHIT4_TXERR    0x10
#define _B2CON_FILHIT4          0x10
#define _B2CON_TXERR            0x10
#define _B2CON_RXRTRRO_TXLARB   0x20
#define _B2CON_RXRTRRO          0x20
#define _B2CON_TXLARB           0x20
#define _B2CON_RXM1_TXABT       0x40
#define _B2CON_RXM1             0x40
#define _B2CON_TXABT            0x40
#define _B2CON_RXFUL_TXBIF      0x80
#define _B2CON_RXFUL            0x80
#define _B2CON_TXBIF            0x80

//==============================================================================


//==============================================================================
//        B2SIDH Bits

extern __at(0x0EA1) __sfr B2SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __B2SIDHbits_t;

extern __at(0x0EA1) volatile __B2SIDHbits_t B2SIDHbits;

#define _B2SIDH_SID3            0x01
#define _B2SIDH_SID4            0x02
#define _B2SIDH_SID5            0x04
#define _B2SIDH_SID6            0x08
#define _B2SIDH_SID7            0x10
#define _B2SIDH_SID8            0x20
#define _B2SIDH_SID9            0x40
#define _B2SIDH_SID10           0x80

//==============================================================================


//==============================================================================
//        B2SIDL Bits

extern __at(0x0EA2) __sfr B2SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDE              : 1;
    unsigned SRR                : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __B2SIDLbits_t;

extern __at(0x0EA2) volatile __B2SIDLbits_t B2SIDLbits;

#define _B2SIDL_EID16           0x01
#define _B2SIDL_EID17           0x02
#define _B2SIDL_EXIDE           0x08
#define _B2SIDL_SRR             0x10
#define _B2SIDL_SID0            0x20
#define _B2SIDL_SID1            0x40
#define _B2SIDL_SID2            0x80

//==============================================================================


//==============================================================================
//        B2EIDH Bits

extern __at(0x0EA3) __sfr B2EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __B2EIDHbits_t;

extern __at(0x0EA3) volatile __B2EIDHbits_t B2EIDHbits;

#define _B2EIDH_EID8            0x01
#define _B2EIDH_EID9            0x02
#define _B2EIDH_EID10           0x04
#define _B2EIDH_EID11           0x08
#define _B2EIDH_EID12           0x10
#define _B2EIDH_EID13           0x20
#define _B2EIDH_EID14           0x40
#define _B2EIDH_EID15           0x80

//==============================================================================


//==============================================================================
//        B2EIDL Bits

extern __at(0x0EA4) __sfr B2EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __B2EIDLbits_t;

extern __at(0x0EA4) volatile __B2EIDLbits_t B2EIDLbits;

#define _B2EIDL_EID0            0x01
#define _B2EIDL_EID1            0x02
#define _B2EIDL_EID2            0x04
#define _B2EIDL_EID3            0x08
#define _B2EIDL_EID4            0x10
#define _B2EIDL_EID5            0x20
#define _B2EIDL_EID6            0x40
#define _B2EIDL_EID7            0x80

//==============================================================================


//==============================================================================
//        B2DLC Bits

extern __at(0x0EA5) __sfr B2DLC;

typedef union
  {
  struct
    {
    unsigned DLC0               : 1;
    unsigned DLC1               : 1;
    unsigned DLC2               : 1;
    unsigned DLC3               : 1;
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RXRTR_TXRTR        : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RXRTR              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TXRTR              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DLC                : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned RB                 : 2;
    unsigned                    : 2;
    };
  } __B2DLCbits_t;

extern __at(0x0EA5) volatile __B2DLCbits_t B2DLCbits;

#define _B2DLC_DLC0             0x01
#define _B2DLC_DLC1             0x02
#define _B2DLC_DLC2             0x04
#define _B2DLC_DLC3             0x08
#define _B2DLC_RB0              0x10
#define _B2DLC_RB1              0x20
#define _B2DLC_RXRTR_TXRTR      0x40
#define _B2DLC_RXRTR            0x40
#define _B2DLC_TXRTR            0x40

//==============================================================================


//==============================================================================
//        B2D0 Bits

extern __at(0x0EA6) __sfr B2D0;

typedef struct
  {
  unsigned B2D00                : 1;
  unsigned B2D01                : 1;
  unsigned B2D02                : 1;
  unsigned B2D03                : 1;
  unsigned B2D04                : 1;
  unsigned B2D05                : 1;
  unsigned B2D06                : 1;
  unsigned B2D07                : 1;
  } __B2D0bits_t;

extern __at(0x0EA6) volatile __B2D0bits_t B2D0bits;

#define _B2D00                  0x01
#define _B2D01                  0x02
#define _B2D02                  0x04
#define _B2D03                  0x08
#define _B2D04                  0x10
#define _B2D05                  0x20
#define _B2D06                  0x40
#define _B2D07                  0x80

//==============================================================================


//==============================================================================
//        B2D1 Bits

extern __at(0x0EA7) __sfr B2D1;

typedef struct
  {
  unsigned B2D10                : 1;
  unsigned B2D11                : 1;
  unsigned B2D12                : 1;
  unsigned B2D13                : 1;
  unsigned B2D14                : 1;
  unsigned B2D15                : 1;
  unsigned B2D16                : 1;
  unsigned B2D17                : 1;
  } __B2D1bits_t;

extern __at(0x0EA7) volatile __B2D1bits_t B2D1bits;

#define _B2D10                  0x01
#define _B2D11                  0x02
#define _B2D12                  0x04
#define _B2D13                  0x08
#define _B2D14                  0x10
#define _B2D15                  0x20
#define _B2D16                  0x40
#define _B2D17                  0x80

//==============================================================================


//==============================================================================
//        B2D2 Bits

extern __at(0x0EA8) __sfr B2D2;

typedef struct
  {
  unsigned B2D20                : 1;
  unsigned B2D21                : 1;
  unsigned B2D22                : 1;
  unsigned B2D23                : 1;
  unsigned B2D24                : 1;
  unsigned B2D25                : 1;
  unsigned B2D26                : 1;
  unsigned B2D27                : 1;
  } __B2D2bits_t;

extern __at(0x0EA8) volatile __B2D2bits_t B2D2bits;

#define _B2D20                  0x01
#define _B2D21                  0x02
#define _B2D22                  0x04
#define _B2D23                  0x08
#define _B2D24                  0x10
#define _B2D25                  0x20
#define _B2D26                  0x40
#define _B2D27                  0x80

//==============================================================================


//==============================================================================
//        B2D3 Bits

extern __at(0x0EA9) __sfr B2D3;

typedef struct
  {
  unsigned B2D30                : 1;
  unsigned B2D31                : 1;
  unsigned B2D32                : 1;
  unsigned B2D33                : 1;
  unsigned B2D34                : 1;
  unsigned B2D35                : 1;
  unsigned B2D36                : 1;
  unsigned B2D37                : 1;
  } __B2D3bits_t;

extern __at(0x0EA9) volatile __B2D3bits_t B2D3bits;

#define _B2D30                  0x01
#define _B2D31                  0x02
#define _B2D32                  0x04
#define _B2D33                  0x08
#define _B2D34                  0x10
#define _B2D35                  0x20
#define _B2D36                  0x40
#define _B2D37                  0x80

//==============================================================================


//==============================================================================
//        B2D4 Bits

extern __at(0x0EAA) __sfr B2D4;

typedef struct
  {
  unsigned B2D40                : 1;
  unsigned B2D41                : 1;
  unsigned B2D42                : 1;
  unsigned B2D43                : 1;
  unsigned B2D44                : 1;
  unsigned B2D45                : 1;
  unsigned B2D46                : 1;
  unsigned B2D47                : 1;
  } __B2D4bits_t;

extern __at(0x0EAA) volatile __B2D4bits_t B2D4bits;

#define _B2D40                  0x01
#define _B2D41                  0x02
#define _B2D42                  0x04
#define _B2D43                  0x08
#define _B2D44                  0x10
#define _B2D45                  0x20
#define _B2D46                  0x40
#define _B2D47                  0x80

//==============================================================================


//==============================================================================
//        B2D5 Bits

extern __at(0x0EAB) __sfr B2D5;

typedef struct
  {
  unsigned B2D50                : 1;
  unsigned B2D51                : 1;
  unsigned B2D52                : 1;
  unsigned B2D53                : 1;
  unsigned B2D54                : 1;
  unsigned B2D55                : 1;
  unsigned B2D56                : 1;
  unsigned B2D57                : 1;
  } __B2D5bits_t;

extern __at(0x0EAB) volatile __B2D5bits_t B2D5bits;

#define _B2D50                  0x01
#define _B2D51                  0x02
#define _B2D52                  0x04
#define _B2D53                  0x08
#define _B2D54                  0x10
#define _B2D55                  0x20
#define _B2D56                  0x40
#define _B2D57                  0x80

//==============================================================================


//==============================================================================
//        B2D6 Bits

extern __at(0x0EAC) __sfr B2D6;

typedef struct
  {
  unsigned B2D60                : 1;
  unsigned B2D61                : 1;
  unsigned B2D62                : 1;
  unsigned B2D63                : 1;
  unsigned B2D64                : 1;
  unsigned B2D65                : 1;
  unsigned B2D66                : 1;
  unsigned B2D67                : 1;
  } __B2D6bits_t;

extern __at(0x0EAC) volatile __B2D6bits_t B2D6bits;

#define _B2D60                  0x01
#define _B2D61                  0x02
#define _B2D62                  0x04
#define _B2D63                  0x08
#define _B2D64                  0x10
#define _B2D65                  0x20
#define _B2D66                  0x40
#define _B2D67                  0x80

//==============================================================================


//==============================================================================
//        B2D7 Bits

extern __at(0x0EAD) __sfr B2D7;

typedef struct
  {
  unsigned B2D70                : 1;
  unsigned B2D71                : 1;
  unsigned B2D72                : 1;
  unsigned B2D73                : 1;
  unsigned B2D74                : 1;
  unsigned B2D75                : 1;
  unsigned B2D76                : 1;
  unsigned B2D77                : 1;
  } __B2D7bits_t;

extern __at(0x0EAD) volatile __B2D7bits_t B2D7bits;

#define _B2D70                  0x01
#define _B2D71                  0x02
#define _B2D72                  0x04
#define _B2D73                  0x08
#define _B2D74                  0x10
#define _B2D75                  0x20
#define _B2D76                  0x40
#define _B2D77                  0x80

//==============================================================================


//==============================================================================
//        CANSTAT_RO7 Bits

extern __at(0x0EAE) __sfr CANSTAT_RO7;

typedef union
  {
  struct
    {
    unsigned EICODE0            : 1;
    unsigned EICODE1_ICODE0     : 1;
    unsigned EICODE2_ICODE1     : 1;
    unsigned EICODE3_ICODE2     : 1;
    unsigned EICODE4            : 1;
    unsigned OPMODE0            : 1;
    unsigned OPMODE1            : 1;
    unsigned OPMODE2            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned EICODE1            : 1;
    unsigned EICODE2            : 1;
    unsigned EICODE3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ICODE0             : 1;
    unsigned ICODE1             : 1;
    unsigned ICODE2             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned EICODE             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ICODE              : 3;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 5;
    unsigned OPMODE             : 3;
    };
  } __CANSTAT_RO7bits_t;

extern __at(0x0EAE) volatile __CANSTAT_RO7bits_t CANSTAT_RO7bits;

#define _CANSTAT_RO7_EICODE0    0x01
#define _CANSTAT_RO7_EICODE1_ICODE0 0x02
#define _CANSTAT_RO7_EICODE1    0x02
#define _CANSTAT_RO7_ICODE0     0x02
#define _CANSTAT_RO7_EICODE2_ICODE1 0x04
#define _CANSTAT_RO7_EICODE2    0x04
#define _CANSTAT_RO7_ICODE1     0x04
#define _CANSTAT_RO7_EICODE3_ICODE2 0x08
#define _CANSTAT_RO7_EICODE3    0x08
#define _CANSTAT_RO7_ICODE2     0x08
#define _CANSTAT_RO7_EICODE4    0x10
#define _CANSTAT_RO7_OPMODE0    0x20
#define _CANSTAT_RO7_OPMODE1    0x40
#define _CANSTAT_RO7_OPMODE2    0x80

//==============================================================================


//==============================================================================
//        CANCON_RO7 Bits

extern __at(0x0EAF) __sfr CANCON_RO7;

typedef union
  {
  struct
    {
    unsigned FP0                : 1;
    unsigned WIN0_FP1           : 1;
    unsigned WIN1_FP2           : 1;
    unsigned WIN2_FP3           : 1;
    unsigned ABAT               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WIN0               : 1;
    unsigned WIN1               : 1;
    unsigned WIN2               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned FP1                : 1;
    unsigned FP2                : 1;
    unsigned FP3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned FP                 : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WIN                : 3;
    unsigned                    : 4;
    };
  } __CANCON_RO7bits_t;

extern __at(0x0EAF) volatile __CANCON_RO7bits_t CANCON_RO7bits;

#define _CANCON_RO7_FP0         0x01
#define _CANCON_RO7_WIN0_FP1    0x02
#define _CANCON_RO7_WIN0        0x02
#define _CANCON_RO7_FP1         0x02
#define _CANCON_RO7_WIN1_FP2    0x04
#define _CANCON_RO7_WIN1        0x04
#define _CANCON_RO7_FP2         0x04
#define _CANCON_RO7_WIN2_FP3    0x08
#define _CANCON_RO7_WIN2        0x08
#define _CANCON_RO7_FP3         0x08
#define _CANCON_RO7_ABAT        0x10

//==============================================================================


//==============================================================================
//        B3CON Bits

extern __at(0x0EB0) __sfr B3CON;

typedef union
  {
  struct
    {
    unsigned FILHIT0_TXPRI0     : 1;
    unsigned FILHIT1_TXPRI1     : 1;
    unsigned FILHIT2_RTREN      : 1;
    unsigned FILHIT3_TXREQ      : 1;
    unsigned FILHIT4_TXERR      : 1;
    unsigned RXRTRRO_TXLARB     : 1;
    unsigned RXM1_TXABT         : 1;
    unsigned RXFUL_TXBIF        : 1;
    };

  struct
    {
    unsigned FILHIT0            : 1;
    unsigned FILHIT1            : 1;
    unsigned FILHIT2            : 1;
    unsigned FILHIT3            : 1;
    unsigned FILHIT4            : 1;
    unsigned RXRTRRO            : 1;
    unsigned RXM1               : 1;
    unsigned RXFUL              : 1;
    };

  struct
    {
    unsigned TXPRI0             : 1;
    unsigned TXPRI1             : 1;
    unsigned RTREN              : 1;
    unsigned TXREQ              : 1;
    unsigned TXERR              : 1;
    unsigned TXLARB             : 1;
    unsigned TXABT              : 1;
    unsigned TXBIF              : 1;
    };

  struct
    {
    unsigned FILHIT             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned TXPRI              : 2;
    unsigned                    : 6;
    };
  } __B3CONbits_t;

extern __at(0x0EB0) volatile __B3CONbits_t B3CONbits;

#define _B3CON_FILHIT0_TXPRI0   0x01
#define _B3CON_FILHIT0          0x01
#define _B3CON_TXPRI0           0x01
#define _B3CON_FILHIT1_TXPRI1   0x02
#define _B3CON_FILHIT1          0x02
#define _B3CON_TXPRI1           0x02
#define _B3CON_FILHIT2_RTREN    0x04
#define _B3CON_FILHIT2          0x04
#define _B3CON_RTREN            0x04
#define _B3CON_FILHIT3_TXREQ    0x08
#define _B3CON_FILHIT3          0x08
#define _B3CON_TXREQ            0x08
#define _B3CON_FILHIT4_TXERR    0x10
#define _B3CON_FILHIT4          0x10
#define _B3CON_TXERR            0x10
#define _B3CON_RXRTRRO_TXLARB   0x20
#define _B3CON_RXRTRRO          0x20
#define _B3CON_TXLARB           0x20
#define _B3CON_RXM1_TXABT       0x40
#define _B3CON_RXM1             0x40
#define _B3CON_TXABT            0x40
#define _B3CON_RXFUL_TXBIF      0x80
#define _B3CON_RXFUL            0x80
#define _B3CON_TXBIF            0x80

//==============================================================================


//==============================================================================
//        B3SIDH Bits

extern __at(0x0EB1) __sfr B3SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __B3SIDHbits_t;

extern __at(0x0EB1) volatile __B3SIDHbits_t B3SIDHbits;

#define _B3SIDH_SID3            0x01
#define _B3SIDH_SID4            0x02
#define _B3SIDH_SID5            0x04
#define _B3SIDH_SID6            0x08
#define _B3SIDH_SID7            0x10
#define _B3SIDH_SID8            0x20
#define _B3SIDH_SID9            0x40
#define _B3SIDH_SID10           0x80

//==============================================================================


//==============================================================================
//        B3SIDL Bits

extern __at(0x0EB2) __sfr B3SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDE              : 1;
    unsigned SRR                : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __B3SIDLbits_t;

extern __at(0x0EB2) volatile __B3SIDLbits_t B3SIDLbits;

#define _B3SIDL_EID16           0x01
#define _B3SIDL_EID17           0x02
#define _B3SIDL_EXIDE           0x08
#define _B3SIDL_SRR             0x10
#define _B3SIDL_SID0            0x20
#define _B3SIDL_SID1            0x40
#define _B3SIDL_SID2            0x80

//==============================================================================


//==============================================================================
//        B3EIDH Bits

extern __at(0x0EB3) __sfr B3EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __B3EIDHbits_t;

extern __at(0x0EB3) volatile __B3EIDHbits_t B3EIDHbits;

#define _B3EIDH_EID8            0x01
#define _B3EIDH_EID9            0x02
#define _B3EIDH_EID10           0x04
#define _B3EIDH_EID11           0x08
#define _B3EIDH_EID12           0x10
#define _B3EIDH_EID13           0x20
#define _B3EIDH_EID14           0x40
#define _B3EIDH_EID15           0x80

//==============================================================================


//==============================================================================
//        B3EIDL Bits

extern __at(0x0EB4) __sfr B3EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __B3EIDLbits_t;

extern __at(0x0EB4) volatile __B3EIDLbits_t B3EIDLbits;

#define _B3EIDL_EID0            0x01
#define _B3EIDL_EID1            0x02
#define _B3EIDL_EID2            0x04
#define _B3EIDL_EID3            0x08
#define _B3EIDL_EID4            0x10
#define _B3EIDL_EID5            0x20
#define _B3EIDL_EID6            0x40
#define _B3EIDL_EID7            0x80

//==============================================================================


//==============================================================================
//        B3DLC Bits

extern __at(0x0EB5) __sfr B3DLC;

typedef union
  {
  struct
    {
    unsigned DLC0               : 1;
    unsigned DLC1               : 1;
    unsigned DLC2               : 1;
    unsigned DLC3               : 1;
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RXRTR_TXRTR        : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RXRTR              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TXRTR              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DLC                : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned RB                 : 2;
    unsigned                    : 2;
    };
  } __B3DLCbits_t;

extern __at(0x0EB5) volatile __B3DLCbits_t B3DLCbits;

#define _B3DLC_DLC0             0x01
#define _B3DLC_DLC1             0x02
#define _B3DLC_DLC2             0x04
#define _B3DLC_DLC3             0x08
#define _B3DLC_RB0              0x10
#define _B3DLC_RB1              0x20
#define _B3DLC_RXRTR_TXRTR      0x40
#define _B3DLC_RXRTR            0x40
#define _B3DLC_TXRTR            0x40

//==============================================================================


//==============================================================================
//        B3D0 Bits

extern __at(0x0EB6) __sfr B3D0;

typedef struct
  {
  unsigned B3D00                : 1;
  unsigned B3D01                : 1;
  unsigned B3D02                : 1;
  unsigned B3D03                : 1;
  unsigned B3D04                : 1;
  unsigned B3D05                : 1;
  unsigned B3D06                : 1;
  unsigned B3D07                : 1;
  } __B3D0bits_t;

extern __at(0x0EB6) volatile __B3D0bits_t B3D0bits;

#define _B3D00                  0x01
#define _B3D01                  0x02
#define _B3D02                  0x04
#define _B3D03                  0x08
#define _B3D04                  0x10
#define _B3D05                  0x20
#define _B3D06                  0x40
#define _B3D07                  0x80

//==============================================================================


//==============================================================================
//        B3D1 Bits

extern __at(0x0EB7) __sfr B3D1;

typedef struct
  {
  unsigned B3D10                : 1;
  unsigned B3D11                : 1;
  unsigned B3D12                : 1;
  unsigned B3D13                : 1;
  unsigned B3D14                : 1;
  unsigned B3D15                : 1;
  unsigned B3D16                : 1;
  unsigned B3D17                : 1;
  } __B3D1bits_t;

extern __at(0x0EB7) volatile __B3D1bits_t B3D1bits;

#define _B3D10                  0x01
#define _B3D11                  0x02
#define _B3D12                  0x04
#define _B3D13                  0x08
#define _B3D14                  0x10
#define _B3D15                  0x20
#define _B3D16                  0x40
#define _B3D17                  0x80

//==============================================================================


//==============================================================================
//        B3D2 Bits

extern __at(0x0EB8) __sfr B3D2;

typedef struct
  {
  unsigned B3D20                : 1;
  unsigned B3D21                : 1;
  unsigned B3D22                : 1;
  unsigned B3D23                : 1;
  unsigned B3D24                : 1;
  unsigned B3D25                : 1;
  unsigned B3D26                : 1;
  unsigned B3D27                : 1;
  } __B3D2bits_t;

extern __at(0x0EB8) volatile __B3D2bits_t B3D2bits;

#define _B3D20                  0x01
#define _B3D21                  0x02
#define _B3D22                  0x04
#define _B3D23                  0x08
#define _B3D24                  0x10
#define _B3D25                  0x20
#define _B3D26                  0x40
#define _B3D27                  0x80

//==============================================================================


//==============================================================================
//        B3D3 Bits

extern __at(0x0EB9) __sfr B3D3;

typedef struct
  {
  unsigned B3D30                : 1;
  unsigned B3D31                : 1;
  unsigned B3D32                : 1;
  unsigned B3D33                : 1;
  unsigned B3D34                : 1;
  unsigned B3D35                : 1;
  unsigned B3D36                : 1;
  unsigned B3D37                : 1;
  } __B3D3bits_t;

extern __at(0x0EB9) volatile __B3D3bits_t B3D3bits;

#define _B3D30                  0x01
#define _B3D31                  0x02
#define _B3D32                  0x04
#define _B3D33                  0x08
#define _B3D34                  0x10
#define _B3D35                  0x20
#define _B3D36                  0x40
#define _B3D37                  0x80

//==============================================================================


//==============================================================================
//        B3D4 Bits

extern __at(0x0EBA) __sfr B3D4;

typedef struct
  {
  unsigned B3D40                : 1;
  unsigned B3D41                : 1;
  unsigned B3D42                : 1;
  unsigned B3D43                : 1;
  unsigned B3D44                : 1;
  unsigned B3D45                : 1;
  unsigned B3D46                : 1;
  unsigned B3D47                : 1;
  } __B3D4bits_t;

extern __at(0x0EBA) volatile __B3D4bits_t B3D4bits;

#define _B3D40                  0x01
#define _B3D41                  0x02
#define _B3D42                  0x04
#define _B3D43                  0x08
#define _B3D44                  0x10
#define _B3D45                  0x20
#define _B3D46                  0x40
#define _B3D47                  0x80

//==============================================================================


//==============================================================================
//        B3D5 Bits

extern __at(0x0EBB) __sfr B3D5;

typedef struct
  {
  unsigned B3D50                : 1;
  unsigned B3D51                : 1;
  unsigned B3D52                : 1;
  unsigned B3D53                : 1;
  unsigned B3D54                : 1;
  unsigned B3D55                : 1;
  unsigned B3D56                : 1;
  unsigned B3D57                : 1;
  } __B3D5bits_t;

extern __at(0x0EBB) volatile __B3D5bits_t B3D5bits;

#define _B3D50                  0x01
#define _B3D51                  0x02
#define _B3D52                  0x04
#define _B3D53                  0x08
#define _B3D54                  0x10
#define _B3D55                  0x20
#define _B3D56                  0x40
#define _B3D57                  0x80

//==============================================================================


//==============================================================================
//        B3D6 Bits

extern __at(0x0EBC) __sfr B3D6;

typedef struct
  {
  unsigned B3D60                : 1;
  unsigned B3D61                : 1;
  unsigned B3D62                : 1;
  unsigned B3D63                : 1;
  unsigned B3D64                : 1;
  unsigned B3D65                : 1;
  unsigned B3D66                : 1;
  unsigned B3D67                : 1;
  } __B3D6bits_t;

extern __at(0x0EBC) volatile __B3D6bits_t B3D6bits;

#define _B3D60                  0x01
#define _B3D61                  0x02
#define _B3D62                  0x04
#define _B3D63                  0x08
#define _B3D64                  0x10
#define _B3D65                  0x20
#define _B3D66                  0x40
#define _B3D67                  0x80

//==============================================================================


//==============================================================================
//        B3D7 Bits

extern __at(0x0EBD) __sfr B3D7;

typedef struct
  {
  unsigned B3D70                : 1;
  unsigned B3D71                : 1;
  unsigned B3D72                : 1;
  unsigned B3D73                : 1;
  unsigned B3D74                : 1;
  unsigned B3D75                : 1;
  unsigned B3D76                : 1;
  unsigned B3D77                : 1;
  } __B3D7bits_t;

extern __at(0x0EBD) volatile __B3D7bits_t B3D7bits;

#define _B3D70                  0x01
#define _B3D71                  0x02
#define _B3D72                  0x04
#define _B3D73                  0x08
#define _B3D74                  0x10
#define _B3D75                  0x20
#define _B3D76                  0x40
#define _B3D77                  0x80

//==============================================================================


//==============================================================================
//        CANSTAT_RO6 Bits

extern __at(0x0EBE) __sfr CANSTAT_RO6;

typedef union
  {
  struct
    {
    unsigned EICODE0            : 1;
    unsigned EICODE1_ICODE0     : 1;
    unsigned EICODE2_ICODE1     : 1;
    unsigned EICODE3_ICODE2     : 1;
    unsigned EICODE4            : 1;
    unsigned OPMODE0            : 1;
    unsigned OPMODE1            : 1;
    unsigned OPMODE2            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned EICODE1            : 1;
    unsigned EICODE2            : 1;
    unsigned EICODE3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ICODE0             : 1;
    unsigned ICODE1             : 1;
    unsigned ICODE2             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned EICODE             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ICODE              : 3;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 5;
    unsigned OPMODE             : 3;
    };
  } __CANSTAT_RO6bits_t;

extern __at(0x0EBE) volatile __CANSTAT_RO6bits_t CANSTAT_RO6bits;

#define _CANSTAT_RO6_EICODE0    0x01
#define _CANSTAT_RO6_EICODE1_ICODE0 0x02
#define _CANSTAT_RO6_EICODE1    0x02
#define _CANSTAT_RO6_ICODE0     0x02
#define _CANSTAT_RO6_EICODE2_ICODE1 0x04
#define _CANSTAT_RO6_EICODE2    0x04
#define _CANSTAT_RO6_ICODE1     0x04
#define _CANSTAT_RO6_EICODE3_ICODE2 0x08
#define _CANSTAT_RO6_EICODE3    0x08
#define _CANSTAT_RO6_ICODE2     0x08
#define _CANSTAT_RO6_EICODE4    0x10
#define _CANSTAT_RO6_OPMODE0    0x20
#define _CANSTAT_RO6_OPMODE1    0x40
#define _CANSTAT_RO6_OPMODE2    0x80

//==============================================================================


//==============================================================================
//        CANCON_RO6 Bits

extern __at(0x0EBF) __sfr CANCON_RO6;

typedef union
  {
  struct
    {
    unsigned FP0                : 1;
    unsigned WIN0_FP1           : 1;
    unsigned WIN1_FP2           : 1;
    unsigned WIN2_FP3           : 1;
    unsigned ABAT               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WIN0               : 1;
    unsigned WIN1               : 1;
    unsigned WIN2               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned FP1                : 1;
    unsigned FP2                : 1;
    unsigned FP3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned FP                 : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WIN                : 3;
    unsigned                    : 4;
    };
  } __CANCON_RO6bits_t;

extern __at(0x0EBF) volatile __CANCON_RO6bits_t CANCON_RO6bits;

#define _CANCON_RO6_FP0         0x01
#define _CANCON_RO6_WIN0_FP1    0x02
#define _CANCON_RO6_WIN0        0x02
#define _CANCON_RO6_FP1         0x02
#define _CANCON_RO6_WIN1_FP2    0x04
#define _CANCON_RO6_WIN1        0x04
#define _CANCON_RO6_FP2         0x04
#define _CANCON_RO6_WIN2_FP3    0x08
#define _CANCON_RO6_WIN2        0x08
#define _CANCON_RO6_FP3         0x08
#define _CANCON_RO6_ABAT        0x10

//==============================================================================


//==============================================================================
//        B4CON Bits

extern __at(0x0EC0) __sfr B4CON;

typedef union
  {
  struct
    {
    unsigned FILHIT0_TXPRI0     : 1;
    unsigned FILHIT1_TXPRI1     : 1;
    unsigned FILHIT2_RTREN      : 1;
    unsigned FILHIT3_TXREQ      : 1;
    unsigned FILHIT4_TXERR      : 1;
    unsigned RXRTRRO_TXLARB     : 1;
    unsigned RXM1_TXABT         : 1;
    unsigned RXFUL_TXBIF        : 1;
    };

  struct
    {
    unsigned FILHIT0            : 1;
    unsigned FILHIT1            : 1;
    unsigned FILHIT2            : 1;
    unsigned FILHIT3            : 1;
    unsigned FILHIT4            : 1;
    unsigned RXRTRRO            : 1;
    unsigned RXM1               : 1;
    unsigned RXFUL              : 1;
    };

  struct
    {
    unsigned TXPRI0             : 1;
    unsigned TXPRI1             : 1;
    unsigned RTREN              : 1;
    unsigned TXREQ              : 1;
    unsigned TXERR              : 1;
    unsigned TXLARB             : 1;
    unsigned TXABT              : 1;
    unsigned TXBIF              : 1;
    };

  struct
    {
    unsigned FILHIT             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned TXPRI              : 2;
    unsigned                    : 6;
    };
  } __B4CONbits_t;

extern __at(0x0EC0) volatile __B4CONbits_t B4CONbits;

#define _B4CON_FILHIT0_TXPRI0   0x01
#define _B4CON_FILHIT0          0x01
#define _B4CON_TXPRI0           0x01
#define _B4CON_FILHIT1_TXPRI1   0x02
#define _B4CON_FILHIT1          0x02
#define _B4CON_TXPRI1           0x02
#define _B4CON_FILHIT2_RTREN    0x04
#define _B4CON_FILHIT2          0x04
#define _B4CON_RTREN            0x04
#define _B4CON_FILHIT3_TXREQ    0x08
#define _B4CON_FILHIT3          0x08
#define _B4CON_TXREQ            0x08
#define _B4CON_FILHIT4_TXERR    0x10
#define _B4CON_FILHIT4          0x10
#define _B4CON_TXERR            0x10
#define _B4CON_RXRTRRO_TXLARB   0x20
#define _B4CON_RXRTRRO          0x20
#define _B4CON_TXLARB           0x20
#define _B4CON_RXM1_TXABT       0x40
#define _B4CON_RXM1             0x40
#define _B4CON_TXABT            0x40
#define _B4CON_RXFUL_TXBIF      0x80
#define _B4CON_RXFUL            0x80
#define _B4CON_TXBIF            0x80

//==============================================================================


//==============================================================================
//        B4SIDH Bits

extern __at(0x0EC1) __sfr B4SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __B4SIDHbits_t;

extern __at(0x0EC1) volatile __B4SIDHbits_t B4SIDHbits;

#define _B4SIDH_SID3            0x01
#define _B4SIDH_SID4            0x02
#define _B4SIDH_SID5            0x04
#define _B4SIDH_SID6            0x08
#define _B4SIDH_SID7            0x10
#define _B4SIDH_SID8            0x20
#define _B4SIDH_SID9            0x40
#define _B4SIDH_SID10           0x80

//==============================================================================


//==============================================================================
//        B4SIDL Bits

extern __at(0x0EC2) __sfr B4SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDE              : 1;
    unsigned SRR                : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __B4SIDLbits_t;

extern __at(0x0EC2) volatile __B4SIDLbits_t B4SIDLbits;

#define _B4SIDL_EID16           0x01
#define _B4SIDL_EID17           0x02
#define _B4SIDL_EXIDE           0x08
#define _B4SIDL_SRR             0x10
#define _B4SIDL_SID0            0x20
#define _B4SIDL_SID1            0x40
#define _B4SIDL_SID2            0x80

//==============================================================================


//==============================================================================
//        B4EIDH Bits

extern __at(0x0EC3) __sfr B4EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __B4EIDHbits_t;

extern __at(0x0EC3) volatile __B4EIDHbits_t B4EIDHbits;

#define _B4EIDH_EID8            0x01
#define _B4EIDH_EID9            0x02
#define _B4EIDH_EID10           0x04
#define _B4EIDH_EID11           0x08
#define _B4EIDH_EID12           0x10
#define _B4EIDH_EID13           0x20
#define _B4EIDH_EID14           0x40
#define _B4EIDH_EID15           0x80

//==============================================================================


//==============================================================================
//        B4EIDL Bits

extern __at(0x0EC4) __sfr B4EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __B4EIDLbits_t;

extern __at(0x0EC4) volatile __B4EIDLbits_t B4EIDLbits;

#define _B4EIDL_EID0            0x01
#define _B4EIDL_EID1            0x02
#define _B4EIDL_EID2            0x04
#define _B4EIDL_EID3            0x08
#define _B4EIDL_EID4            0x10
#define _B4EIDL_EID5            0x20
#define _B4EIDL_EID6            0x40
#define _B4EIDL_EID7            0x80

//==============================================================================


//==============================================================================
//        B4DLC Bits

extern __at(0x0EC5) __sfr B4DLC;

typedef union
  {
  struct
    {
    unsigned DLC0               : 1;
    unsigned DLC1               : 1;
    unsigned DLC2               : 1;
    unsigned DLC3               : 1;
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RXRTR_TXRTR        : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RXRTR              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TXRTR              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DLC                : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned RB                 : 2;
    unsigned                    : 2;
    };
  } __B4DLCbits_t;

extern __at(0x0EC5) volatile __B4DLCbits_t B4DLCbits;

#define _B4DLC_DLC0             0x01
#define _B4DLC_DLC1             0x02
#define _B4DLC_DLC2             0x04
#define _B4DLC_DLC3             0x08
#define _B4DLC_RB0              0x10
#define _B4DLC_RB1              0x20
#define _B4DLC_RXRTR_TXRTR      0x40
#define _B4DLC_RXRTR            0x40
#define _B4DLC_TXRTR            0x40

//==============================================================================


//==============================================================================
//        B4D0 Bits

extern __at(0x0EC6) __sfr B4D0;

typedef struct
  {
  unsigned B4D00                : 1;
  unsigned B4D01                : 1;
  unsigned B4D02                : 1;
  unsigned B4D03                : 1;
  unsigned B4D04                : 1;
  unsigned B4D05                : 1;
  unsigned B4D06                : 1;
  unsigned B4D07                : 1;
  } __B4D0bits_t;

extern __at(0x0EC6) volatile __B4D0bits_t B4D0bits;

#define _B4D00                  0x01
#define _B4D01                  0x02
#define _B4D02                  0x04
#define _B4D03                  0x08
#define _B4D04                  0x10
#define _B4D05                  0x20
#define _B4D06                  0x40
#define _B4D07                  0x80

//==============================================================================


//==============================================================================
//        B4D1 Bits

extern __at(0x0EC7) __sfr B4D1;

typedef struct
  {
  unsigned B4D10                : 1;
  unsigned B4D11                : 1;
  unsigned B4D12                : 1;
  unsigned B4D13                : 1;
  unsigned B4D14                : 1;
  unsigned B4D15                : 1;
  unsigned B4D16                : 1;
  unsigned B4D17                : 1;
  } __B4D1bits_t;

extern __at(0x0EC7) volatile __B4D1bits_t B4D1bits;

#define _B4D10                  0x01
#define _B4D11                  0x02
#define _B4D12                  0x04
#define _B4D13                  0x08
#define _B4D14                  0x10
#define _B4D15                  0x20
#define _B4D16                  0x40
#define _B4D17                  0x80

//==============================================================================


//==============================================================================
//        B4D2 Bits

extern __at(0x0EC8) __sfr B4D2;

typedef struct
  {
  unsigned B4D20                : 1;
  unsigned B4D21                : 1;
  unsigned B4D22                : 1;
  unsigned B4D23                : 1;
  unsigned B4D24                : 1;
  unsigned B4D25                : 1;
  unsigned B4D26                : 1;
  unsigned B4D27                : 1;
  } __B4D2bits_t;

extern __at(0x0EC8) volatile __B4D2bits_t B4D2bits;

#define _B4D20                  0x01
#define _B4D21                  0x02
#define _B4D22                  0x04
#define _B4D23                  0x08
#define _B4D24                  0x10
#define _B4D25                  0x20
#define _B4D26                  0x40
#define _B4D27                  0x80

//==============================================================================


//==============================================================================
//        B4D3 Bits

extern __at(0x0EC9) __sfr B4D3;

typedef struct
  {
  unsigned B4D30                : 1;
  unsigned B4D31                : 1;
  unsigned B4D32                : 1;
  unsigned B4D33                : 1;
  unsigned B4D34                : 1;
  unsigned B4D35                : 1;
  unsigned B4D36                : 1;
  unsigned B4D37                : 1;
  } __B4D3bits_t;

extern __at(0x0EC9) volatile __B4D3bits_t B4D3bits;

#define _B4D30                  0x01
#define _B4D31                  0x02
#define _B4D32                  0x04
#define _B4D33                  0x08
#define _B4D34                  0x10
#define _B4D35                  0x20
#define _B4D36                  0x40
#define _B4D37                  0x80

//==============================================================================


//==============================================================================
//        B4D4 Bits

extern __at(0x0ECA) __sfr B4D4;

typedef struct
  {
  unsigned B4D40                : 1;
  unsigned B4D41                : 1;
  unsigned B4D42                : 1;
  unsigned B4D43                : 1;
  unsigned B4D44                : 1;
  unsigned B4D45                : 1;
  unsigned B4D46                : 1;
  unsigned B4D47                : 1;
  } __B4D4bits_t;

extern __at(0x0ECA) volatile __B4D4bits_t B4D4bits;

#define _B4D40                  0x01
#define _B4D41                  0x02
#define _B4D42                  0x04
#define _B4D43                  0x08
#define _B4D44                  0x10
#define _B4D45                  0x20
#define _B4D46                  0x40
#define _B4D47                  0x80

//==============================================================================


//==============================================================================
//        B4D5 Bits

extern __at(0x0ECB) __sfr B4D5;

typedef struct
  {
  unsigned B4D50                : 1;
  unsigned B4D51                : 1;
  unsigned B4D52                : 1;
  unsigned B4D53                : 1;
  unsigned B4D54                : 1;
  unsigned B4D55                : 1;
  unsigned B4D56                : 1;
  unsigned B4D57                : 1;
  } __B4D5bits_t;

extern __at(0x0ECB) volatile __B4D5bits_t B4D5bits;

#define _B4D50                  0x01
#define _B4D51                  0x02
#define _B4D52                  0x04
#define _B4D53                  0x08
#define _B4D54                  0x10
#define _B4D55                  0x20
#define _B4D56                  0x40
#define _B4D57                  0x80

//==============================================================================


//==============================================================================
//        B4D6 Bits

extern __at(0x0ECC) __sfr B4D6;

typedef struct
  {
  unsigned B4D60                : 1;
  unsigned B4D61                : 1;
  unsigned B4D62                : 1;
  unsigned B4D63                : 1;
  unsigned B4D64                : 1;
  unsigned B4D65                : 1;
  unsigned B4D66                : 1;
  unsigned B4D67                : 1;
  } __B4D6bits_t;

extern __at(0x0ECC) volatile __B4D6bits_t B4D6bits;

#define _B4D60                  0x01
#define _B4D61                  0x02
#define _B4D62                  0x04
#define _B4D63                  0x08
#define _B4D64                  0x10
#define _B4D65                  0x20
#define _B4D66                  0x40
#define _B4D67                  0x80

//==============================================================================


//==============================================================================
//        B4D7 Bits

extern __at(0x0ECD) __sfr B4D7;

typedef struct
  {
  unsigned B4D70                : 1;
  unsigned B4D71                : 1;
  unsigned B4D72                : 1;
  unsigned B4D73                : 1;
  unsigned B4D74                : 1;
  unsigned B4D75                : 1;
  unsigned B4D76                : 1;
  unsigned B4D77                : 1;
  } __B4D7bits_t;

extern __at(0x0ECD) volatile __B4D7bits_t B4D7bits;

#define _B4D70                  0x01
#define _B4D71                  0x02
#define _B4D72                  0x04
#define _B4D73                  0x08
#define _B4D74                  0x10
#define _B4D75                  0x20
#define _B4D76                  0x40
#define _B4D77                  0x80

//==============================================================================


//==============================================================================
//        CANSTAT_RO5 Bits

extern __at(0x0ECE) __sfr CANSTAT_RO5;

typedef union
  {
  struct
    {
    unsigned EICODE0            : 1;
    unsigned EICODE1_ICODE0     : 1;
    unsigned EICODE2_ICODE1     : 1;
    unsigned EICODE3_ICODE2     : 1;
    unsigned EICODE4            : 1;
    unsigned OPMODE0            : 1;
    unsigned OPMODE1            : 1;
    unsigned OPMODE2            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned EICODE1            : 1;
    unsigned EICODE2            : 1;
    unsigned EICODE3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ICODE0             : 1;
    unsigned ICODE1             : 1;
    unsigned ICODE2             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned EICODE             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ICODE              : 3;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 5;
    unsigned OPMODE             : 3;
    };
  } __CANSTAT_RO5bits_t;

extern __at(0x0ECE) volatile __CANSTAT_RO5bits_t CANSTAT_RO5bits;

#define _CANSTAT_RO5_EICODE0    0x01
#define _CANSTAT_RO5_EICODE1_ICODE0 0x02
#define _CANSTAT_RO5_EICODE1    0x02
#define _CANSTAT_RO5_ICODE0     0x02
#define _CANSTAT_RO5_EICODE2_ICODE1 0x04
#define _CANSTAT_RO5_EICODE2    0x04
#define _CANSTAT_RO5_ICODE1     0x04
#define _CANSTAT_RO5_EICODE3_ICODE2 0x08
#define _CANSTAT_RO5_EICODE3    0x08
#define _CANSTAT_RO5_ICODE2     0x08
#define _CANSTAT_RO5_EICODE4    0x10
#define _CANSTAT_RO5_OPMODE0    0x20
#define _CANSTAT_RO5_OPMODE1    0x40
#define _CANSTAT_RO5_OPMODE2    0x80

//==============================================================================


//==============================================================================
//        CANCON_RO5 Bits

extern __at(0x0ECF) __sfr CANCON_RO5;

typedef union
  {
  struct
    {
    unsigned FP0                : 1;
    unsigned WIN0_FP1           : 1;
    unsigned WIN1_FP2           : 1;
    unsigned WIN2_FP3           : 1;
    unsigned ABAT               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WIN0               : 1;
    unsigned WIN1               : 1;
    unsigned WIN2               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned FP1                : 1;
    unsigned FP2                : 1;
    unsigned FP3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned FP                 : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WIN                : 3;
    unsigned                    : 4;
    };
  } __CANCON_RO5bits_t;

extern __at(0x0ECF) volatile __CANCON_RO5bits_t CANCON_RO5bits;

#define _CANCON_RO5_FP0         0x01
#define _CANCON_RO5_WIN0_FP1    0x02
#define _CANCON_RO5_WIN0        0x02
#define _CANCON_RO5_FP1         0x02
#define _CANCON_RO5_WIN1_FP2    0x04
#define _CANCON_RO5_WIN1        0x04
#define _CANCON_RO5_FP2         0x04
#define _CANCON_RO5_WIN2_FP3    0x08
#define _CANCON_RO5_WIN2        0x08
#define _CANCON_RO5_FP3         0x08
#define _CANCON_RO5_ABAT        0x10

//==============================================================================


//==============================================================================
//        B5CON Bits

extern __at(0x0ED0) __sfr B5CON;

typedef union
  {
  struct
    {
    unsigned FILHIT0_TXPRI0     : 1;
    unsigned FILHIT1_TXPRI1     : 1;
    unsigned FILHIT2_RTREN      : 1;
    unsigned FILHIT3_TXREQ      : 1;
    unsigned FILHIT4_TXERR      : 1;
    unsigned RXRTRRO_TXLARB     : 1;
    unsigned RXM1_TXABT         : 1;
    unsigned RXFUL_TXBIF        : 1;
    };

  struct
    {
    unsigned FILHIT0            : 1;
    unsigned FILHIT1            : 1;
    unsigned FILHIT2            : 1;
    unsigned FILHIT3            : 1;
    unsigned FILHIT4            : 1;
    unsigned RXRTRRO            : 1;
    unsigned RXM1               : 1;
    unsigned RXFUL              : 1;
    };

  struct
    {
    unsigned TXPRI0             : 1;
    unsigned TXPRI1             : 1;
    unsigned RTREN              : 1;
    unsigned TXREQ              : 1;
    unsigned TXERR              : 1;
    unsigned TXLARB             : 1;
    unsigned TXABT              : 1;
    unsigned TXBIF              : 1;
    };

  struct
    {
    unsigned FILHIT             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned TXPRI              : 2;
    unsigned                    : 6;
    };
  } __B5CONbits_t;

extern __at(0x0ED0) volatile __B5CONbits_t B5CONbits;

#define _B5CON_FILHIT0_TXPRI0   0x01
#define _B5CON_FILHIT0          0x01
#define _B5CON_TXPRI0           0x01
#define _B5CON_FILHIT1_TXPRI1   0x02
#define _B5CON_FILHIT1          0x02
#define _B5CON_TXPRI1           0x02
#define _B5CON_FILHIT2_RTREN    0x04
#define _B5CON_FILHIT2          0x04
#define _B5CON_RTREN            0x04
#define _B5CON_FILHIT3_TXREQ    0x08
#define _B5CON_FILHIT3          0x08
#define _B5CON_TXREQ            0x08
#define _B5CON_FILHIT4_TXERR    0x10
#define _B5CON_FILHIT4          0x10
#define _B5CON_TXERR            0x10
#define _B5CON_RXRTRRO_TXLARB   0x20
#define _B5CON_RXRTRRO          0x20
#define _B5CON_TXLARB           0x20
#define _B5CON_RXM1_TXABT       0x40
#define _B5CON_RXM1             0x40
#define _B5CON_TXABT            0x40
#define _B5CON_RXFUL_TXBIF      0x80
#define _B5CON_RXFUL            0x80
#define _B5CON_TXBIF            0x80

//==============================================================================


//==============================================================================
//        B5SIDH Bits

extern __at(0x0ED1) __sfr B5SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __B5SIDHbits_t;

extern __at(0x0ED1) volatile __B5SIDHbits_t B5SIDHbits;

#define _B5SIDH_SID3            0x01
#define _B5SIDH_SID4            0x02
#define _B5SIDH_SID5            0x04
#define _B5SIDH_SID6            0x08
#define _B5SIDH_SID7            0x10
#define _B5SIDH_SID8            0x20
#define _B5SIDH_SID9            0x40
#define _B5SIDH_SID10           0x80

//==============================================================================


//==============================================================================
//        B5SIDL Bits

extern __at(0x0ED2) __sfr B5SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDE              : 1;
    unsigned SRR                : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __B5SIDLbits_t;

extern __at(0x0ED2) volatile __B5SIDLbits_t B5SIDLbits;

#define _B5SIDL_EID16           0x01
#define _B5SIDL_EID17           0x02
#define _B5SIDL_EXIDE           0x08
#define _B5SIDL_SRR             0x10
#define _B5SIDL_SID0            0x20
#define _B5SIDL_SID1            0x40
#define _B5SIDL_SID2            0x80

//==============================================================================


//==============================================================================
//        B5EIDH Bits

extern __at(0x0ED3) __sfr B5EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __B5EIDHbits_t;

extern __at(0x0ED3) volatile __B5EIDHbits_t B5EIDHbits;

#define _B5EIDH_EID8            0x01
#define _B5EIDH_EID9            0x02
#define _B5EIDH_EID10           0x04
#define _B5EIDH_EID11           0x08
#define _B5EIDH_EID12           0x10
#define _B5EIDH_EID13           0x20
#define _B5EIDH_EID14           0x40
#define _B5EIDH_EID15           0x80

//==============================================================================


//==============================================================================
//        B5EIDL Bits

extern __at(0x0ED4) __sfr B5EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __B5EIDLbits_t;

extern __at(0x0ED4) volatile __B5EIDLbits_t B5EIDLbits;

#define _B5EIDL_EID0            0x01
#define _B5EIDL_EID1            0x02
#define _B5EIDL_EID2            0x04
#define _B5EIDL_EID3            0x08
#define _B5EIDL_EID4            0x10
#define _B5EIDL_EID5            0x20
#define _B5EIDL_EID6            0x40
#define _B5EIDL_EID7            0x80

//==============================================================================


//==============================================================================
//        B5DLC Bits

extern __at(0x0ED5) __sfr B5DLC;

typedef union
  {
  struct
    {
    unsigned DLC0               : 1;
    unsigned DLC1               : 1;
    unsigned DLC2               : 1;
    unsigned DLC3               : 1;
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RXRTR_TXRTR        : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RXRTR              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TXRTR              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DLC                : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned RB                 : 2;
    unsigned                    : 2;
    };
  } __B5DLCbits_t;

extern __at(0x0ED5) volatile __B5DLCbits_t B5DLCbits;

#define _B5DLC_DLC0             0x01
#define _B5DLC_DLC1             0x02
#define _B5DLC_DLC2             0x04
#define _B5DLC_DLC3             0x08
#define _B5DLC_RB0              0x10
#define _B5DLC_RB1              0x20
#define _B5DLC_RXRTR_TXRTR      0x40
#define _B5DLC_RXRTR            0x40
#define _B5DLC_TXRTR            0x40

//==============================================================================


//==============================================================================
//        B5D0 Bits

extern __at(0x0ED6) __sfr B5D0;

typedef struct
  {
  unsigned B5D00                : 1;
  unsigned B5D01                : 1;
  unsigned B5D02                : 1;
  unsigned B5D03                : 1;
  unsigned B5D04                : 1;
  unsigned B5D05                : 1;
  unsigned B5D06                : 1;
  unsigned B5D07                : 1;
  } __B5D0bits_t;

extern __at(0x0ED6) volatile __B5D0bits_t B5D0bits;

#define _B5D00                  0x01
#define _B5D01                  0x02
#define _B5D02                  0x04
#define _B5D03                  0x08
#define _B5D04                  0x10
#define _B5D05                  0x20
#define _B5D06                  0x40
#define _B5D07                  0x80

//==============================================================================


//==============================================================================
//        B5D1 Bits

extern __at(0x0ED7) __sfr B5D1;

typedef struct
  {
  unsigned B5D10                : 1;
  unsigned B5D11                : 1;
  unsigned B5D12                : 1;
  unsigned B5D13                : 1;
  unsigned B5D14                : 1;
  unsigned B5D15                : 1;
  unsigned B5D16                : 1;
  unsigned B5D17                : 1;
  } __B5D1bits_t;

extern __at(0x0ED7) volatile __B5D1bits_t B5D1bits;

#define _B5D10                  0x01
#define _B5D11                  0x02
#define _B5D12                  0x04
#define _B5D13                  0x08
#define _B5D14                  0x10
#define _B5D15                  0x20
#define _B5D16                  0x40
#define _B5D17                  0x80

//==============================================================================


//==============================================================================
//        B5D2 Bits

extern __at(0x0ED8) __sfr B5D2;

typedef struct
  {
  unsigned B5D20                : 1;
  unsigned B5D21                : 1;
  unsigned B5D22                : 1;
  unsigned B5D23                : 1;
  unsigned B5D24                : 1;
  unsigned B5D25                : 1;
  unsigned B5D26                : 1;
  unsigned B5D27                : 1;
  } __B5D2bits_t;

extern __at(0x0ED8) volatile __B5D2bits_t B5D2bits;

#define _B5D20                  0x01
#define _B5D21                  0x02
#define _B5D22                  0x04
#define _B5D23                  0x08
#define _B5D24                  0x10
#define _B5D25                  0x20
#define _B5D26                  0x40
#define _B5D27                  0x80

//==============================================================================


//==============================================================================
//        B5D3 Bits

extern __at(0x0ED9) __sfr B5D3;

typedef struct
  {
  unsigned B5D30                : 1;
  unsigned B5D31                : 1;
  unsigned B5D32                : 1;
  unsigned B5D33                : 1;
  unsigned B5D34                : 1;
  unsigned B5D35                : 1;
  unsigned B5D36                : 1;
  unsigned B5D37                : 1;
  } __B5D3bits_t;

extern __at(0x0ED9) volatile __B5D3bits_t B5D3bits;

#define _B5D30                  0x01
#define _B5D31                  0x02
#define _B5D32                  0x04
#define _B5D33                  0x08
#define _B5D34                  0x10
#define _B5D35                  0x20
#define _B5D36                  0x40
#define _B5D37                  0x80

//==============================================================================


//==============================================================================
//        B5D4 Bits

extern __at(0x0EDA) __sfr B5D4;

typedef struct
  {
  unsigned B5D40                : 1;
  unsigned B5D41                : 1;
  unsigned B5D42                : 1;
  unsigned B5D43                : 1;
  unsigned B5D44                : 1;
  unsigned B5D45                : 1;
  unsigned B5D46                : 1;
  unsigned B5D47                : 1;
  } __B5D4bits_t;

extern __at(0x0EDA) volatile __B5D4bits_t B5D4bits;

#define _B5D40                  0x01
#define _B5D41                  0x02
#define _B5D42                  0x04
#define _B5D43                  0x08
#define _B5D44                  0x10
#define _B5D45                  0x20
#define _B5D46                  0x40
#define _B5D47                  0x80

//==============================================================================


//==============================================================================
//        B5D5 Bits

extern __at(0x0EDB) __sfr B5D5;

typedef struct
  {
  unsigned B5D50                : 1;
  unsigned B5D51                : 1;
  unsigned B5D52                : 1;
  unsigned B5D53                : 1;
  unsigned B5D54                : 1;
  unsigned B5D55                : 1;
  unsigned B5D56                : 1;
  unsigned B5D57                : 1;
  } __B5D5bits_t;

extern __at(0x0EDB) volatile __B5D5bits_t B5D5bits;

#define _B5D50                  0x01
#define _B5D51                  0x02
#define _B5D52                  0x04
#define _B5D53                  0x08
#define _B5D54                  0x10
#define _B5D55                  0x20
#define _B5D56                  0x40
#define _B5D57                  0x80

//==============================================================================


//==============================================================================
//        B5D6 Bits

extern __at(0x0EDC) __sfr B5D6;

typedef struct
  {
  unsigned B5D60                : 1;
  unsigned B5D61                : 1;
  unsigned B5D62                : 1;
  unsigned B5D63                : 1;
  unsigned B5D64                : 1;
  unsigned B5D65                : 1;
  unsigned B5D66                : 1;
  unsigned B5D67                : 1;
  } __B5D6bits_t;

extern __at(0x0EDC) volatile __B5D6bits_t B5D6bits;

#define _B5D60                  0x01
#define _B5D61                  0x02
#define _B5D62                  0x04
#define _B5D63                  0x08
#define _B5D64                  0x10
#define _B5D65                  0x20
#define _B5D66                  0x40
#define _B5D67                  0x80

//==============================================================================


//==============================================================================
//        B5D7 Bits

extern __at(0x0EDD) __sfr B5D7;

typedef struct
  {
  unsigned B5D70                : 1;
  unsigned B5D71                : 1;
  unsigned B5D72                : 1;
  unsigned B5D73                : 1;
  unsigned B5D74                : 1;
  unsigned B5D75                : 1;
  unsigned B5D76                : 1;
  unsigned B5D77                : 1;
  } __B5D7bits_t;

extern __at(0x0EDD) volatile __B5D7bits_t B5D7bits;

#define _B5D70                  0x01
#define _B5D71                  0x02
#define _B5D72                  0x04
#define _B5D73                  0x08
#define _B5D74                  0x10
#define _B5D75                  0x20
#define _B5D76                  0x40
#define _B5D77                  0x80

//==============================================================================


//==============================================================================
//        CANSTAT_RO4 Bits

extern __at(0x0EDE) __sfr CANSTAT_RO4;

typedef union
  {
  struct
    {
    unsigned EICODE0            : 1;
    unsigned EICODE1_ICODE0     : 1;
    unsigned EICODE2_ICODE1     : 1;
    unsigned EICODE3_ICODE2     : 1;
    unsigned EICODE4            : 1;
    unsigned OPMODE0            : 1;
    unsigned OPMODE1            : 1;
    unsigned OPMODE2            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned EICODE1            : 1;
    unsigned EICODE2            : 1;
    unsigned EICODE3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ICODE0             : 1;
    unsigned ICODE1             : 1;
    unsigned ICODE2             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned EICODE             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ICODE              : 3;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 5;
    unsigned OPMODE             : 3;
    };
  } __CANSTAT_RO4bits_t;

extern __at(0x0EDE) volatile __CANSTAT_RO4bits_t CANSTAT_RO4bits;

#define _CANSTAT_RO4_EICODE0    0x01
#define _CANSTAT_RO4_EICODE1_ICODE0 0x02
#define _CANSTAT_RO4_EICODE1    0x02
#define _CANSTAT_RO4_ICODE0     0x02
#define _CANSTAT_RO4_EICODE2_ICODE1 0x04
#define _CANSTAT_RO4_EICODE2    0x04
#define _CANSTAT_RO4_ICODE1     0x04
#define _CANSTAT_RO4_EICODE3_ICODE2 0x08
#define _CANSTAT_RO4_EICODE3    0x08
#define _CANSTAT_RO4_ICODE2     0x08
#define _CANSTAT_RO4_EICODE4    0x10
#define _CANSTAT_RO4_OPMODE0    0x20
#define _CANSTAT_RO4_OPMODE1    0x40
#define _CANSTAT_RO4_OPMODE2    0x80

//==============================================================================


//==============================================================================
//        CANCON_RO4 Bits

extern __at(0x0EDF) __sfr CANCON_RO4;

typedef union
  {
  struct
    {
    unsigned FP0                : 1;
    unsigned WIN0_FP1           : 1;
    unsigned WIN1_FP2           : 1;
    unsigned WIN2_FP3           : 1;
    unsigned ABAT               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WIN0               : 1;
    unsigned WIN1               : 1;
    unsigned WIN2               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned FP1                : 1;
    unsigned FP2                : 1;
    unsigned FP3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned FP                 : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WIN                : 3;
    unsigned                    : 4;
    };
  } __CANCON_RO4bits_t;

extern __at(0x0EDF) volatile __CANCON_RO4bits_t CANCON_RO4bits;

#define _CANCON_RO4_FP0         0x01
#define _CANCON_RO4_WIN0_FP1    0x02
#define _CANCON_RO4_WIN0        0x02
#define _CANCON_RO4_FP1         0x02
#define _CANCON_RO4_WIN1_FP2    0x04
#define _CANCON_RO4_WIN1        0x04
#define _CANCON_RO4_FP2         0x04
#define _CANCON_RO4_WIN2_FP3    0x08
#define _CANCON_RO4_WIN2        0x08
#define _CANCON_RO4_FP3         0x08
#define _CANCON_RO4_ABAT        0x10

//==============================================================================


//==============================================================================
//        RXF0SIDH Bits

extern __at(0x0EE0) __sfr RXF0SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __RXF0SIDHbits_t;

extern __at(0x0EE0) volatile __RXF0SIDHbits_t RXF0SIDHbits;

#define _RXF0SIDH_SID3          0x01
#define _RXF0SIDH_SID4          0x02
#define _RXF0SIDH_SID5          0x04
#define _RXF0SIDH_SID6          0x08
#define _RXF0SIDH_SID7          0x10
#define _RXF0SIDH_SID8          0x20
#define _RXF0SIDH_SID9          0x40
#define _RXF0SIDH_SID10         0x80

//==============================================================================


//==============================================================================
//        RXF0SIDL Bits

extern __at(0x0EE1) __sfr RXF0SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDEN             : 1;
    unsigned                    : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __RXF0SIDLbits_t;

extern __at(0x0EE1) volatile __RXF0SIDLbits_t RXF0SIDLbits;

#define _RXF0SIDL_EID16         0x01
#define _RXF0SIDL_EID17         0x02
#define _RXF0SIDL_EXIDEN        0x08
#define _RXF0SIDL_SID0          0x20
#define _RXF0SIDL_SID1          0x40
#define _RXF0SIDL_SID2          0x80

//==============================================================================


//==============================================================================
//        RXF0EIDH Bits

extern __at(0x0EE2) __sfr RXF0EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __RXF0EIDHbits_t;

extern __at(0x0EE2) volatile __RXF0EIDHbits_t RXF0EIDHbits;

#define _RXF0EIDH_EID8          0x01
#define _RXF0EIDH_EID9          0x02
#define _RXF0EIDH_EID10         0x04
#define _RXF0EIDH_EID11         0x08
#define _RXF0EIDH_EID12         0x10
#define _RXF0EIDH_EID13         0x20
#define _RXF0EIDH_EID14         0x40
#define _RXF0EIDH_EID15         0x80

//==============================================================================


//==============================================================================
//        RXF0EIDL Bits

extern __at(0x0EE3) __sfr RXF0EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __RXF0EIDLbits_t;

extern __at(0x0EE3) volatile __RXF0EIDLbits_t RXF0EIDLbits;

#define _RXF0EIDL_EID0          0x01
#define _RXF0EIDL_EID1          0x02
#define _RXF0EIDL_EID2          0x04
#define _RXF0EIDL_EID3          0x08
#define _RXF0EIDL_EID4          0x10
#define _RXF0EIDL_EID5          0x20
#define _RXF0EIDL_EID6          0x40
#define _RXF0EIDL_EID7          0x80

//==============================================================================


//==============================================================================
//        RXF1SIDH Bits

extern __at(0x0EE4) __sfr RXF1SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __RXF1SIDHbits_t;

extern __at(0x0EE4) volatile __RXF1SIDHbits_t RXF1SIDHbits;

#define _RXF1SIDH_SID3          0x01
#define _RXF1SIDH_SID4          0x02
#define _RXF1SIDH_SID5          0x04
#define _RXF1SIDH_SID6          0x08
#define _RXF1SIDH_SID7          0x10
#define _RXF1SIDH_SID8          0x20
#define _RXF1SIDH_SID9          0x40
#define _RXF1SIDH_SID10         0x80

//==============================================================================


//==============================================================================
//        RXF1SIDL Bits

extern __at(0x0EE5) __sfr RXF1SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDEN             : 1;
    unsigned                    : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __RXF1SIDLbits_t;

extern __at(0x0EE5) volatile __RXF1SIDLbits_t RXF1SIDLbits;

#define _RXF1SIDL_EID16         0x01
#define _RXF1SIDL_EID17         0x02
#define _RXF1SIDL_EXIDEN        0x08
#define _RXF1SIDL_SID0          0x20
#define _RXF1SIDL_SID1          0x40
#define _RXF1SIDL_SID2          0x80

//==============================================================================


//==============================================================================
//        RXF1EIDH Bits

extern __at(0x0EE6) __sfr RXF1EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __RXF1EIDHbits_t;

extern __at(0x0EE6) volatile __RXF1EIDHbits_t RXF1EIDHbits;

#define _RXF1EIDH_EID8          0x01
#define _RXF1EIDH_EID9          0x02
#define _RXF1EIDH_EID10         0x04
#define _RXF1EIDH_EID11         0x08
#define _RXF1EIDH_EID12         0x10
#define _RXF1EIDH_EID13         0x20
#define _RXF1EIDH_EID14         0x40
#define _RXF1EIDH_EID15         0x80

//==============================================================================


//==============================================================================
//        RXF1EIDL Bits

extern __at(0x0EE7) __sfr RXF1EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __RXF1EIDLbits_t;

extern __at(0x0EE7) volatile __RXF1EIDLbits_t RXF1EIDLbits;

#define _RXF1EIDL_EID0          0x01
#define _RXF1EIDL_EID1          0x02
#define _RXF1EIDL_EID2          0x04
#define _RXF1EIDL_EID3          0x08
#define _RXF1EIDL_EID4          0x10
#define _RXF1EIDL_EID5          0x20
#define _RXF1EIDL_EID6          0x40
#define _RXF1EIDL_EID7          0x80

//==============================================================================


//==============================================================================
//        RXF2SIDH Bits

extern __at(0x0EE8) __sfr RXF2SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __RXF2SIDHbits_t;

extern __at(0x0EE8) volatile __RXF2SIDHbits_t RXF2SIDHbits;

#define _RXF2SIDH_SID3          0x01
#define _RXF2SIDH_SID4          0x02
#define _RXF2SIDH_SID5          0x04
#define _RXF2SIDH_SID6          0x08
#define _RXF2SIDH_SID7          0x10
#define _RXF2SIDH_SID8          0x20
#define _RXF2SIDH_SID9          0x40
#define _RXF2SIDH_SID10         0x80

//==============================================================================


//==============================================================================
//        RXF2SIDL Bits

extern __at(0x0EE9) __sfr RXF2SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDEN             : 1;
    unsigned                    : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __RXF2SIDLbits_t;

extern __at(0x0EE9) volatile __RXF2SIDLbits_t RXF2SIDLbits;

#define _RXF2SIDL_EID16         0x01
#define _RXF2SIDL_EID17         0x02
#define _RXF2SIDL_EXIDEN        0x08
#define _RXF2SIDL_SID0          0x20
#define _RXF2SIDL_SID1          0x40
#define _RXF2SIDL_SID2          0x80

//==============================================================================


//==============================================================================
//        RXF2EIDH Bits

extern __at(0x0EEA) __sfr RXF2EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __RXF2EIDHbits_t;

extern __at(0x0EEA) volatile __RXF2EIDHbits_t RXF2EIDHbits;

#define _RXF2EIDH_EID8          0x01
#define _RXF2EIDH_EID9          0x02
#define _RXF2EIDH_EID10         0x04
#define _RXF2EIDH_EID11         0x08
#define _RXF2EIDH_EID12         0x10
#define _RXF2EIDH_EID13         0x20
#define _RXF2EIDH_EID14         0x40
#define _RXF2EIDH_EID15         0x80

//==============================================================================


//==============================================================================
//        RXF2EIDL Bits

extern __at(0x0EEB) __sfr RXF2EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __RXF2EIDLbits_t;

extern __at(0x0EEB) volatile __RXF2EIDLbits_t RXF2EIDLbits;

#define _RXF2EIDL_EID0          0x01
#define _RXF2EIDL_EID1          0x02
#define _RXF2EIDL_EID2          0x04
#define _RXF2EIDL_EID3          0x08
#define _RXF2EIDL_EID4          0x10
#define _RXF2EIDL_EID5          0x20
#define _RXF2EIDL_EID6          0x40
#define _RXF2EIDL_EID7          0x80

//==============================================================================


//==============================================================================
//        RXF3SIDH Bits

extern __at(0x0EEC) __sfr RXF3SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __RXF3SIDHbits_t;

extern __at(0x0EEC) volatile __RXF3SIDHbits_t RXF3SIDHbits;

#define _RXF3SIDH_SID3          0x01
#define _RXF3SIDH_SID4          0x02
#define _RXF3SIDH_SID5          0x04
#define _RXF3SIDH_SID6          0x08
#define _RXF3SIDH_SID7          0x10
#define _RXF3SIDH_SID8          0x20
#define _RXF3SIDH_SID9          0x40
#define _RXF3SIDH_SID10         0x80

//==============================================================================


//==============================================================================
//        RXF3SIDL Bits

extern __at(0x0EED) __sfr RXF3SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDEN             : 1;
    unsigned                    : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __RXF3SIDLbits_t;

extern __at(0x0EED) volatile __RXF3SIDLbits_t RXF3SIDLbits;

#define _RXF3SIDL_EID16         0x01
#define _RXF3SIDL_EID17         0x02
#define _RXF3SIDL_EXIDEN        0x08
#define _RXF3SIDL_SID0          0x20
#define _RXF3SIDL_SID1          0x40
#define _RXF3SIDL_SID2          0x80

//==============================================================================


//==============================================================================
//        RXF3EIDH Bits

extern __at(0x0EEE) __sfr RXF3EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __RXF3EIDHbits_t;

extern __at(0x0EEE) volatile __RXF3EIDHbits_t RXF3EIDHbits;

#define _RXF3EIDH_EID8          0x01
#define _RXF3EIDH_EID9          0x02
#define _RXF3EIDH_EID10         0x04
#define _RXF3EIDH_EID11         0x08
#define _RXF3EIDH_EID12         0x10
#define _RXF3EIDH_EID13         0x20
#define _RXF3EIDH_EID14         0x40
#define _RXF3EIDH_EID15         0x80

//==============================================================================


//==============================================================================
//        RXF3EIDL Bits

extern __at(0x0EEF) __sfr RXF3EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __RXF3EIDLbits_t;

extern __at(0x0EEF) volatile __RXF3EIDLbits_t RXF3EIDLbits;

#define _RXF3EIDL_EID0          0x01
#define _RXF3EIDL_EID1          0x02
#define _RXF3EIDL_EID2          0x04
#define _RXF3EIDL_EID3          0x08
#define _RXF3EIDL_EID4          0x10
#define _RXF3EIDL_EID5          0x20
#define _RXF3EIDL_EID6          0x40
#define _RXF3EIDL_EID7          0x80

//==============================================================================


//==============================================================================
//        RXF4SIDH Bits

extern __at(0x0EF0) __sfr RXF4SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __RXF4SIDHbits_t;

extern __at(0x0EF0) volatile __RXF4SIDHbits_t RXF4SIDHbits;

#define _RXF4SIDH_SID3          0x01
#define _RXF4SIDH_SID4          0x02
#define _RXF4SIDH_SID5          0x04
#define _RXF4SIDH_SID6          0x08
#define _RXF4SIDH_SID7          0x10
#define _RXF4SIDH_SID8          0x20
#define _RXF4SIDH_SID9          0x40
#define _RXF4SIDH_SID10         0x80

//==============================================================================


//==============================================================================
//        RXF4SIDL Bits

extern __at(0x0EF1) __sfr RXF4SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDEN             : 1;
    unsigned                    : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __RXF4SIDLbits_t;

extern __at(0x0EF1) volatile __RXF4SIDLbits_t RXF4SIDLbits;

#define _RXF4SIDL_EID16         0x01
#define _RXF4SIDL_EID17         0x02
#define _RXF4SIDL_EXIDEN        0x08
#define _RXF4SIDL_SID0          0x20
#define _RXF4SIDL_SID1          0x40
#define _RXF4SIDL_SID2          0x80

//==============================================================================


//==============================================================================
//        RXF4EIDH Bits

extern __at(0x0EF2) __sfr RXF4EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __RXF4EIDHbits_t;

extern __at(0x0EF2) volatile __RXF4EIDHbits_t RXF4EIDHbits;

#define _RXF4EIDH_EID8          0x01
#define _RXF4EIDH_EID9          0x02
#define _RXF4EIDH_EID10         0x04
#define _RXF4EIDH_EID11         0x08
#define _RXF4EIDH_EID12         0x10
#define _RXF4EIDH_EID13         0x20
#define _RXF4EIDH_EID14         0x40
#define _RXF4EIDH_EID15         0x80

//==============================================================================


//==============================================================================
//        RXF4EIDL Bits

extern __at(0x0EF3) __sfr RXF4EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __RXF4EIDLbits_t;

extern __at(0x0EF3) volatile __RXF4EIDLbits_t RXF4EIDLbits;

#define _RXF4EIDL_EID0          0x01
#define _RXF4EIDL_EID1          0x02
#define _RXF4EIDL_EID2          0x04
#define _RXF4EIDL_EID3          0x08
#define _RXF4EIDL_EID4          0x10
#define _RXF4EIDL_EID5          0x20
#define _RXF4EIDL_EID6          0x40
#define _RXF4EIDL_EID7          0x80

//==============================================================================


//==============================================================================
//        RXF5SIDH Bits

extern __at(0x0EF4) __sfr RXF5SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __RXF5SIDHbits_t;

extern __at(0x0EF4) volatile __RXF5SIDHbits_t RXF5SIDHbits;

#define _RXF5SIDH_SID3          0x01
#define _RXF5SIDH_SID4          0x02
#define _RXF5SIDH_SID5          0x04
#define _RXF5SIDH_SID6          0x08
#define _RXF5SIDH_SID7          0x10
#define _RXF5SIDH_SID8          0x20
#define _RXF5SIDH_SID9          0x40
#define _RXF5SIDH_SID10         0x80

//==============================================================================


//==============================================================================
//        RXF5SIDL Bits

extern __at(0x0EF5) __sfr RXF5SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDEN             : 1;
    unsigned                    : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __RXF5SIDLbits_t;

extern __at(0x0EF5) volatile __RXF5SIDLbits_t RXF5SIDLbits;

#define _RXF5SIDL_EID16         0x01
#define _RXF5SIDL_EID17         0x02
#define _RXF5SIDL_EXIDEN        0x08
#define _RXF5SIDL_SID0          0x20
#define _RXF5SIDL_SID1          0x40
#define _RXF5SIDL_SID2          0x80

//==============================================================================


//==============================================================================
//        RXF5EIDH Bits

extern __at(0x0EF6) __sfr RXF5EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __RXF5EIDHbits_t;

extern __at(0x0EF6) volatile __RXF5EIDHbits_t RXF5EIDHbits;

#define _RXF5EIDH_EID8          0x01
#define _RXF5EIDH_EID9          0x02
#define _RXF5EIDH_EID10         0x04
#define _RXF5EIDH_EID11         0x08
#define _RXF5EIDH_EID12         0x10
#define _RXF5EIDH_EID13         0x20
#define _RXF5EIDH_EID14         0x40
#define _RXF5EIDH_EID15         0x80

//==============================================================================


//==============================================================================
//        RXF5EIDL Bits

extern __at(0x0EF7) __sfr RXF5EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __RXF5EIDLbits_t;

extern __at(0x0EF7) volatile __RXF5EIDLbits_t RXF5EIDLbits;

#define _RXF5EIDL_EID0          0x01
#define _RXF5EIDL_EID1          0x02
#define _RXF5EIDL_EID2          0x04
#define _RXF5EIDL_EID3          0x08
#define _RXF5EIDL_EID4          0x10
#define _RXF5EIDL_EID5          0x20
#define _RXF5EIDL_EID6          0x40
#define _RXF5EIDL_EID7          0x80

//==============================================================================


//==============================================================================
//        RXM0SIDH Bits

extern __at(0x0EF8) __sfr RXM0SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __RXM0SIDHbits_t;

extern __at(0x0EF8) volatile __RXM0SIDHbits_t RXM0SIDHbits;

#define _RXM0SIDH_SID3          0x01
#define _RXM0SIDH_SID4          0x02
#define _RXM0SIDH_SID5          0x04
#define _RXM0SIDH_SID6          0x08
#define _RXM0SIDH_SID7          0x10
#define _RXM0SIDH_SID8          0x20
#define _RXM0SIDH_SID9          0x40
#define _RXM0SIDH_SID10         0x80

//==============================================================================


//==============================================================================
//        RXM0SIDL Bits

extern __at(0x0EF9) __sfr RXM0SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDEN             : 1;
    unsigned                    : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __RXM0SIDLbits_t;

extern __at(0x0EF9) volatile __RXM0SIDLbits_t RXM0SIDLbits;

#define _RXM0SIDL_EID16         0x01
#define _RXM0SIDL_EID17         0x02
#define _RXM0SIDL_EXIDEN        0x08
#define _RXM0SIDL_SID0          0x20
#define _RXM0SIDL_SID1          0x40
#define _RXM0SIDL_SID2          0x80

//==============================================================================


//==============================================================================
//        RXM0EIDH Bits

extern __at(0x0EFA) __sfr RXM0EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __RXM0EIDHbits_t;

extern __at(0x0EFA) volatile __RXM0EIDHbits_t RXM0EIDHbits;

#define _RXM0EIDH_EID8          0x01
#define _RXM0EIDH_EID9          0x02
#define _RXM0EIDH_EID10         0x04
#define _RXM0EIDH_EID11         0x08
#define _RXM0EIDH_EID12         0x10
#define _RXM0EIDH_EID13         0x20
#define _RXM0EIDH_EID14         0x40
#define _RXM0EIDH_EID15         0x80

//==============================================================================


//==============================================================================
//        RXM0EIDL Bits

extern __at(0x0EFB) __sfr RXM0EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __RXM0EIDLbits_t;

extern __at(0x0EFB) volatile __RXM0EIDLbits_t RXM0EIDLbits;

#define _RXM0EIDL_EID0          0x01
#define _RXM0EIDL_EID1          0x02
#define _RXM0EIDL_EID2          0x04
#define _RXM0EIDL_EID3          0x08
#define _RXM0EIDL_EID4          0x10
#define _RXM0EIDL_EID5          0x20
#define _RXM0EIDL_EID6          0x40
#define _RXM0EIDL_EID7          0x80

//==============================================================================


//==============================================================================
//        RXM1SIDH Bits

extern __at(0x0EFC) __sfr RXM1SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __RXM1SIDHbits_t;

extern __at(0x0EFC) volatile __RXM1SIDHbits_t RXM1SIDHbits;

#define _RXM1SIDH_SID3          0x01
#define _RXM1SIDH_SID4          0x02
#define _RXM1SIDH_SID5          0x04
#define _RXM1SIDH_SID6          0x08
#define _RXM1SIDH_SID7          0x10
#define _RXM1SIDH_SID8          0x20
#define _RXM1SIDH_SID9          0x40
#define _RXM1SIDH_SID10         0x80

//==============================================================================


//==============================================================================
//        RXM1SIDL Bits

extern __at(0x0EFD) __sfr RXM1SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDEN             : 1;
    unsigned                    : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __RXM1SIDLbits_t;

extern __at(0x0EFD) volatile __RXM1SIDLbits_t RXM1SIDLbits;

#define _RXM1SIDL_EID16         0x01
#define _RXM1SIDL_EID17         0x02
#define _RXM1SIDL_EXIDEN        0x08
#define _RXM1SIDL_SID0          0x20
#define _RXM1SIDL_SID1          0x40
#define _RXM1SIDL_SID2          0x80

//==============================================================================


//==============================================================================
//        RXM1EIDH Bits

extern __at(0x0EFE) __sfr RXM1EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __RXM1EIDHbits_t;

extern __at(0x0EFE) volatile __RXM1EIDHbits_t RXM1EIDHbits;

#define _RXM1EIDH_EID8          0x01
#define _RXM1EIDH_EID9          0x02
#define _RXM1EIDH_EID10         0x04
#define _RXM1EIDH_EID11         0x08
#define _RXM1EIDH_EID12         0x10
#define _RXM1EIDH_EID13         0x20
#define _RXM1EIDH_EID14         0x40
#define _RXM1EIDH_EID15         0x80

//==============================================================================


//==============================================================================
//        RXM1EIDL Bits

extern __at(0x0EFF) __sfr RXM1EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __RXM1EIDLbits_t;

extern __at(0x0EFF) volatile __RXM1EIDLbits_t RXM1EIDLbits;

#define _RXM1EIDL_EID0          0x01
#define _RXM1EIDL_EID1          0x02
#define _RXM1EIDL_EID2          0x04
#define _RXM1EIDL_EID3          0x08
#define _RXM1EIDL_EID4          0x10
#define _RXM1EIDL_EID5          0x20
#define _RXM1EIDL_EID6          0x40
#define _RXM1EIDL_EID7          0x80

//==============================================================================


//==============================================================================
//        TXB2CON Bits

extern __at(0x0F00) __sfr TXB2CON;

typedef union
  {
  struct
    {
    unsigned TXPRI0             : 1;
    unsigned TXPRI1             : 1;
    unsigned                    : 1;
    unsigned TXREQ              : 1;
    unsigned TXERR              : 1;
    unsigned TXLARB             : 1;
    unsigned TXABT              : 1;
    unsigned TXBIF              : 1;
    };

  struct
    {
    unsigned TXPRI              : 2;
    unsigned                    : 6;
    };
  } __TXB2CONbits_t;

extern __at(0x0F00) volatile __TXB2CONbits_t TXB2CONbits;

#define _TXB2CON_TXPRI0         0x01
#define _TXB2CON_TXPRI1         0x02
#define _TXB2CON_TXREQ          0x08
#define _TXB2CON_TXERR          0x10
#define _TXB2CON_TXLARB         0x20
#define _TXB2CON_TXABT          0x40
#define _TXB2CON_TXBIF          0x80

//==============================================================================


//==============================================================================
//        TXB2SIDH Bits

extern __at(0x0F01) __sfr TXB2SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __TXB2SIDHbits_t;

extern __at(0x0F01) volatile __TXB2SIDHbits_t TXB2SIDHbits;

#define _TXB2SIDH_SID3          0x01
#define _TXB2SIDH_SID4          0x02
#define _TXB2SIDH_SID5          0x04
#define _TXB2SIDH_SID6          0x08
#define _TXB2SIDH_SID7          0x10
#define _TXB2SIDH_SID8          0x20
#define _TXB2SIDH_SID9          0x40
#define _TXB2SIDH_SID10         0x80

//==============================================================================


//==============================================================================
//        TXB2SIDL Bits

extern __at(0x0F02) __sfr TXB2SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDE              : 1;
    unsigned SRR                : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __TXB2SIDLbits_t;

extern __at(0x0F02) volatile __TXB2SIDLbits_t TXB2SIDLbits;

#define _TXB2SIDL_EID16         0x01
#define _TXB2SIDL_EID17         0x02
#define _TXB2SIDL_EXIDE         0x08
#define _TXB2SIDL_SRR           0x10
#define _TXB2SIDL_SID0          0x20
#define _TXB2SIDL_SID1          0x40
#define _TXB2SIDL_SID2          0x80

//==============================================================================


//==============================================================================
//        TXB2EIDH Bits

extern __at(0x0F03) __sfr TXB2EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __TXB2EIDHbits_t;

extern __at(0x0F03) volatile __TXB2EIDHbits_t TXB2EIDHbits;

#define _TXB2EIDH_EID8          0x01
#define _TXB2EIDH_EID9          0x02
#define _TXB2EIDH_EID10         0x04
#define _TXB2EIDH_EID11         0x08
#define _TXB2EIDH_EID12         0x10
#define _TXB2EIDH_EID13         0x20
#define _TXB2EIDH_EID14         0x40
#define _TXB2EIDH_EID15         0x80

//==============================================================================


//==============================================================================
//        TXB2EIDL Bits

extern __at(0x0F04) __sfr TXB2EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __TXB2EIDLbits_t;

extern __at(0x0F04) volatile __TXB2EIDLbits_t TXB2EIDLbits;

#define _TXB2EIDL_EID0          0x01
#define _TXB2EIDL_EID1          0x02
#define _TXB2EIDL_EID2          0x04
#define _TXB2EIDL_EID3          0x08
#define _TXB2EIDL_EID4          0x10
#define _TXB2EIDL_EID5          0x20
#define _TXB2EIDL_EID6          0x40
#define _TXB2EIDL_EID7          0x80

//==============================================================================


//==============================================================================
//        TXB2DLC Bits

extern __at(0x0F05) __sfr TXB2DLC;

typedef union
  {
  struct
    {
    unsigned DLC0               : 1;
    unsigned DLC1               : 1;
    unsigned DLC2               : 1;
    unsigned DLC3               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TXRTR              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DLC                : 4;
    unsigned                    : 4;
    };
  } __TXB2DLCbits_t;

extern __at(0x0F05) volatile __TXB2DLCbits_t TXB2DLCbits;

#define _TXB2DLC_DLC0           0x01
#define _TXB2DLC_DLC1           0x02
#define _TXB2DLC_DLC2           0x04
#define _TXB2DLC_DLC3           0x08
#define _TXB2DLC_TXRTR          0x40

//==============================================================================


//==============================================================================
//        TXB2D0 Bits

extern __at(0x0F06) __sfr TXB2D0;

typedef struct
  {
  unsigned TXB2D00              : 1;
  unsigned TXB2D01              : 1;
  unsigned TXB2D02              : 1;
  unsigned TXB2D03              : 1;
  unsigned TXB2D04              : 1;
  unsigned TXB2D05              : 1;
  unsigned TXB2D06              : 1;
  unsigned TXB2D07              : 1;
  } __TXB2D0bits_t;

extern __at(0x0F06) volatile __TXB2D0bits_t TXB2D0bits;

#define _TXB2D00                0x01
#define _TXB2D01                0x02
#define _TXB2D02                0x04
#define _TXB2D03                0x08
#define _TXB2D04                0x10
#define _TXB2D05                0x20
#define _TXB2D06                0x40
#define _TXB2D07                0x80

//==============================================================================


//==============================================================================
//        TXB2D1 Bits

extern __at(0x0F07) __sfr TXB2D1;

typedef struct
  {
  unsigned TXB2D10              : 1;
  unsigned TXB2D11              : 1;
  unsigned TXB2D12              : 1;
  unsigned TXB2D13              : 1;
  unsigned TXB2D14              : 1;
  unsigned TXB2D15              : 1;
  unsigned TXB2D16              : 1;
  unsigned TXB2D17              : 1;
  } __TXB2D1bits_t;

extern __at(0x0F07) volatile __TXB2D1bits_t TXB2D1bits;

#define _TXB2D10                0x01
#define _TXB2D11                0x02
#define _TXB2D12                0x04
#define _TXB2D13                0x08
#define _TXB2D14                0x10
#define _TXB2D15                0x20
#define _TXB2D16                0x40
#define _TXB2D17                0x80

//==============================================================================


//==============================================================================
//        TXB2D2 Bits

extern __at(0x0F08) __sfr TXB2D2;

typedef struct
  {
  unsigned TXB2D20              : 1;
  unsigned TXB2D21              : 1;
  unsigned TXB2D22              : 1;
  unsigned TXB2D23              : 1;
  unsigned TXB2D24              : 1;
  unsigned TXB2D25              : 1;
  unsigned TXB2D26              : 1;
  unsigned TXB2D27              : 1;
  } __TXB2D2bits_t;

extern __at(0x0F08) volatile __TXB2D2bits_t TXB2D2bits;

#define _TXB2D20                0x01
#define _TXB2D21                0x02
#define _TXB2D22                0x04
#define _TXB2D23                0x08
#define _TXB2D24                0x10
#define _TXB2D25                0x20
#define _TXB2D26                0x40
#define _TXB2D27                0x80

//==============================================================================


//==============================================================================
//        TXB2D3 Bits

extern __at(0x0F09) __sfr TXB2D3;

typedef struct
  {
  unsigned TXB2D30              : 1;
  unsigned TXB2D31              : 1;
  unsigned TXB2D32              : 1;
  unsigned TXB2D33              : 1;
  unsigned TXB2D34              : 1;
  unsigned TXB2D35              : 1;
  unsigned TXB2D36              : 1;
  unsigned TXB2D37              : 1;
  } __TXB2D3bits_t;

extern __at(0x0F09) volatile __TXB2D3bits_t TXB2D3bits;

#define _TXB2D30                0x01
#define _TXB2D31                0x02
#define _TXB2D32                0x04
#define _TXB2D33                0x08
#define _TXB2D34                0x10
#define _TXB2D35                0x20
#define _TXB2D36                0x40
#define _TXB2D37                0x80

//==============================================================================


//==============================================================================
//        TXB2D4 Bits

extern __at(0x0F0A) __sfr TXB2D4;

typedef struct
  {
  unsigned TXB2D40              : 1;
  unsigned TXB2D41              : 1;
  unsigned TXB2D42              : 1;
  unsigned TXB2D43              : 1;
  unsigned TXB2D44              : 1;
  unsigned TXB2D45              : 1;
  unsigned TXB2D46              : 1;
  unsigned TXB2D47              : 1;
  } __TXB2D4bits_t;

extern __at(0x0F0A) volatile __TXB2D4bits_t TXB2D4bits;

#define _TXB2D40                0x01
#define _TXB2D41                0x02
#define _TXB2D42                0x04
#define _TXB2D43                0x08
#define _TXB2D44                0x10
#define _TXB2D45                0x20
#define _TXB2D46                0x40
#define _TXB2D47                0x80

//==============================================================================


//==============================================================================
//        TXB2D5 Bits

extern __at(0x0F0B) __sfr TXB2D5;

typedef struct
  {
  unsigned TXB2D50              : 1;
  unsigned TXB2D51              : 1;
  unsigned TXB2D52              : 1;
  unsigned TXB2D53              : 1;
  unsigned TXB2D54              : 1;
  unsigned TXB2D55              : 1;
  unsigned TXB2D56              : 1;
  unsigned TXB2D57              : 1;
  } __TXB2D5bits_t;

extern __at(0x0F0B) volatile __TXB2D5bits_t TXB2D5bits;

#define _TXB2D50                0x01
#define _TXB2D51                0x02
#define _TXB2D52                0x04
#define _TXB2D53                0x08
#define _TXB2D54                0x10
#define _TXB2D55                0x20
#define _TXB2D56                0x40
#define _TXB2D57                0x80

//==============================================================================


//==============================================================================
//        TXB2D6 Bits

extern __at(0x0F0C) __sfr TXB2D6;

typedef struct
  {
  unsigned TXB2D60              : 1;
  unsigned TXB2D61              : 1;
  unsigned TXB2D62              : 1;
  unsigned TXB2D63              : 1;
  unsigned TXB2D64              : 1;
  unsigned TXB2D65              : 1;
  unsigned TXB2D66              : 1;
  unsigned TXB2D67              : 1;
  } __TXB2D6bits_t;

extern __at(0x0F0C) volatile __TXB2D6bits_t TXB2D6bits;

#define _TXB2D60                0x01
#define _TXB2D61                0x02
#define _TXB2D62                0x04
#define _TXB2D63                0x08
#define _TXB2D64                0x10
#define _TXB2D65                0x20
#define _TXB2D66                0x40
#define _TXB2D67                0x80

//==============================================================================


//==============================================================================
//        TXB2D7 Bits

extern __at(0x0F0D) __sfr TXB2D7;

typedef struct
  {
  unsigned TXB2D70              : 1;
  unsigned TXB2D71              : 1;
  unsigned TXB2D72              : 1;
  unsigned TXB2D73              : 1;
  unsigned TXB2D74              : 1;
  unsigned TXB2D75              : 1;
  unsigned TXB2D76              : 1;
  unsigned TXB2D77              : 1;
  } __TXB2D7bits_t;

extern __at(0x0F0D) volatile __TXB2D7bits_t TXB2D7bits;

#define _TXB2D70                0x01
#define _TXB2D71                0x02
#define _TXB2D72                0x04
#define _TXB2D73                0x08
#define _TXB2D74                0x10
#define _TXB2D75                0x20
#define _TXB2D76                0x40
#define _TXB2D77                0x80

//==============================================================================


//==============================================================================
//        CANSTAT_RO3 Bits

extern __at(0x0F0E) __sfr CANSTAT_RO3;

typedef union
  {
  struct
    {
    unsigned EICODE0            : 1;
    unsigned EICODE1_ICODE0     : 1;
    unsigned EICODE2_ICODE1     : 1;
    unsigned EICODE3_ICODE2     : 1;
    unsigned EICODE4            : 1;
    unsigned OPMODE0            : 1;
    unsigned OPMODE1            : 1;
    unsigned OPMODE2            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned EICODE1            : 1;
    unsigned EICODE2            : 1;
    unsigned EICODE3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ICODE0             : 1;
    unsigned ICODE1             : 1;
    unsigned ICODE2             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned EICODE             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ICODE              : 3;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 5;
    unsigned OPMODE             : 3;
    };
  } __CANSTAT_RO3bits_t;

extern __at(0x0F0E) volatile __CANSTAT_RO3bits_t CANSTAT_RO3bits;

#define _CANSTAT_RO3_EICODE0    0x01
#define _CANSTAT_RO3_EICODE1_ICODE0 0x02
#define _CANSTAT_RO3_EICODE1    0x02
#define _CANSTAT_RO3_ICODE0     0x02
#define _CANSTAT_RO3_EICODE2_ICODE1 0x04
#define _CANSTAT_RO3_EICODE2    0x04
#define _CANSTAT_RO3_ICODE1     0x04
#define _CANSTAT_RO3_EICODE3_ICODE2 0x08
#define _CANSTAT_RO3_EICODE3    0x08
#define _CANSTAT_RO3_ICODE2     0x08
#define _CANSTAT_RO3_EICODE4    0x10
#define _CANSTAT_RO3_OPMODE0    0x20
#define _CANSTAT_RO3_OPMODE1    0x40
#define _CANSTAT_RO3_OPMODE2    0x80

//==============================================================================


//==============================================================================
//        CANCON_RO3 Bits

extern __at(0x0F0F) __sfr CANCON_RO3;

typedef union
  {
  struct
    {
    unsigned FP0                : 1;
    unsigned WIN0_FP1           : 1;
    unsigned WIN1_FP2           : 1;
    unsigned WIN2_FP3           : 1;
    unsigned ABAT               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WIN0               : 1;
    unsigned WIN1               : 1;
    unsigned WIN2               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned FP1                : 1;
    unsigned FP2                : 1;
    unsigned FP3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned FP                 : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WIN                : 3;
    unsigned                    : 4;
    };
  } __CANCON_RO3bits_t;

extern __at(0x0F0F) volatile __CANCON_RO3bits_t CANCON_RO3bits;

#define _CANCON_RO3_FP0         0x01
#define _CANCON_RO3_WIN0_FP1    0x02
#define _CANCON_RO3_WIN0        0x02
#define _CANCON_RO3_FP1         0x02
#define _CANCON_RO3_WIN1_FP2    0x04
#define _CANCON_RO3_WIN1        0x04
#define _CANCON_RO3_FP2         0x04
#define _CANCON_RO3_WIN2_FP3    0x08
#define _CANCON_RO3_WIN2        0x08
#define _CANCON_RO3_FP3         0x08
#define _CANCON_RO3_ABAT        0x10

//==============================================================================


//==============================================================================
//        TXB1CON Bits

extern __at(0x0F10) __sfr TXB1CON;

typedef union
  {
  struct
    {
    unsigned TXPRI0             : 1;
    unsigned TXPRI1             : 1;
    unsigned                    : 1;
    unsigned TXREQ              : 1;
    unsigned TXERR              : 1;
    unsigned TXLARB             : 1;
    unsigned TXABT              : 1;
    unsigned TXBIF              : 1;
    };

  struct
    {
    unsigned TXPRI              : 2;
    unsigned                    : 6;
    };
  } __TXB1CONbits_t;

extern __at(0x0F10) volatile __TXB1CONbits_t TXB1CONbits;

#define _TXB1CON_TXPRI0         0x01
#define _TXB1CON_TXPRI1         0x02
#define _TXB1CON_TXREQ          0x08
#define _TXB1CON_TXERR          0x10
#define _TXB1CON_TXLARB         0x20
#define _TXB1CON_TXABT          0x40
#define _TXB1CON_TXBIF          0x80

//==============================================================================


//==============================================================================
//        TXB1SIDH Bits

extern __at(0x0F11) __sfr TXB1SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __TXB1SIDHbits_t;

extern __at(0x0F11) volatile __TXB1SIDHbits_t TXB1SIDHbits;

#define _TXB1SIDH_SID3          0x01
#define _TXB1SIDH_SID4          0x02
#define _TXB1SIDH_SID5          0x04
#define _TXB1SIDH_SID6          0x08
#define _TXB1SIDH_SID7          0x10
#define _TXB1SIDH_SID8          0x20
#define _TXB1SIDH_SID9          0x40
#define _TXB1SIDH_SID10         0x80

//==============================================================================


//==============================================================================
//        TXB1SIDL Bits

extern __at(0x0F12) __sfr TXB1SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDE              : 1;
    unsigned SRR                : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __TXB1SIDLbits_t;

extern __at(0x0F12) volatile __TXB1SIDLbits_t TXB1SIDLbits;

#define _TXB1SIDL_EID16         0x01
#define _TXB1SIDL_EID17         0x02
#define _TXB1SIDL_EXIDE         0x08
#define _TXB1SIDL_SRR           0x10
#define _TXB1SIDL_SID0          0x20
#define _TXB1SIDL_SID1          0x40
#define _TXB1SIDL_SID2          0x80

//==============================================================================


//==============================================================================
//        TXB1EIDH Bits

extern __at(0x0F13) __sfr TXB1EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __TXB1EIDHbits_t;

extern __at(0x0F13) volatile __TXB1EIDHbits_t TXB1EIDHbits;

#define _TXB1EIDH_EID8          0x01
#define _TXB1EIDH_EID9          0x02
#define _TXB1EIDH_EID10         0x04
#define _TXB1EIDH_EID11         0x08
#define _TXB1EIDH_EID12         0x10
#define _TXB1EIDH_EID13         0x20
#define _TXB1EIDH_EID14         0x40
#define _TXB1EIDH_EID15         0x80

//==============================================================================


//==============================================================================
//        TXB1EIDL Bits

extern __at(0x0F14) __sfr TXB1EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __TXB1EIDLbits_t;

extern __at(0x0F14) volatile __TXB1EIDLbits_t TXB1EIDLbits;

#define _TXB1EIDL_EID0          0x01
#define _TXB1EIDL_EID1          0x02
#define _TXB1EIDL_EID2          0x04
#define _TXB1EIDL_EID3          0x08
#define _TXB1EIDL_EID4          0x10
#define _TXB1EIDL_EID5          0x20
#define _TXB1EIDL_EID6          0x40
#define _TXB1EIDL_EID7          0x80

//==============================================================================


//==============================================================================
//        TXB1DLC Bits

extern __at(0x0F15) __sfr TXB1DLC;

typedef union
  {
  struct
    {
    unsigned DLC0               : 1;
    unsigned DLC1               : 1;
    unsigned DLC2               : 1;
    unsigned DLC3               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TXRTR              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DLC                : 4;
    unsigned                    : 4;
    };
  } __TXB1DLCbits_t;

extern __at(0x0F15) volatile __TXB1DLCbits_t TXB1DLCbits;

#define _TXB1DLC_DLC0           0x01
#define _TXB1DLC_DLC1           0x02
#define _TXB1DLC_DLC2           0x04
#define _TXB1DLC_DLC3           0x08
#define _TXB1DLC_TXRTR          0x40

//==============================================================================


//==============================================================================
//        TXB1D0 Bits

extern __at(0x0F16) __sfr TXB1D0;

typedef struct
  {
  unsigned TXB1D00              : 1;
  unsigned TXB1D01              : 1;
  unsigned TXB1D02              : 1;
  unsigned TXB1D03              : 1;
  unsigned TXB1D04              : 1;
  unsigned TXB1D05              : 1;
  unsigned TXB1D06              : 1;
  unsigned TXB1D07              : 1;
  } __TXB1D0bits_t;

extern __at(0x0F16) volatile __TXB1D0bits_t TXB1D0bits;

#define _TXB1D00                0x01
#define _TXB1D01                0x02
#define _TXB1D02                0x04
#define _TXB1D03                0x08
#define _TXB1D04                0x10
#define _TXB1D05                0x20
#define _TXB1D06                0x40
#define _TXB1D07                0x80

//==============================================================================


//==============================================================================
//        TXB1D1 Bits

extern __at(0x0F17) __sfr TXB1D1;

typedef struct
  {
  unsigned TXB1D10              : 1;
  unsigned TXB1D11              : 1;
  unsigned TXB1D12              : 1;
  unsigned TXB1D13              : 1;
  unsigned TXB1D14              : 1;
  unsigned TXB1D15              : 1;
  unsigned TXB1D16              : 1;
  unsigned TXB1D17              : 1;
  } __TXB1D1bits_t;

extern __at(0x0F17) volatile __TXB1D1bits_t TXB1D1bits;

#define _TXB1D10                0x01
#define _TXB1D11                0x02
#define _TXB1D12                0x04
#define _TXB1D13                0x08
#define _TXB1D14                0x10
#define _TXB1D15                0x20
#define _TXB1D16                0x40
#define _TXB1D17                0x80

//==============================================================================


//==============================================================================
//        TXB1D2 Bits

extern __at(0x0F18) __sfr TXB1D2;

typedef struct
  {
  unsigned TXB1D20              : 1;
  unsigned TXB1D21              : 1;
  unsigned TXB1D22              : 1;
  unsigned TXB1D23              : 1;
  unsigned TXB1D24              : 1;
  unsigned TXB1D25              : 1;
  unsigned TXB1D26              : 1;
  unsigned TXB1D27              : 1;
  } __TXB1D2bits_t;

extern __at(0x0F18) volatile __TXB1D2bits_t TXB1D2bits;

#define _TXB1D20                0x01
#define _TXB1D21                0x02
#define _TXB1D22                0x04
#define _TXB1D23                0x08
#define _TXB1D24                0x10
#define _TXB1D25                0x20
#define _TXB1D26                0x40
#define _TXB1D27                0x80

//==============================================================================


//==============================================================================
//        TXB1D3 Bits

extern __at(0x0F19) __sfr TXB1D3;

typedef struct
  {
  unsigned TXB1D30              : 1;
  unsigned TXB1D31              : 1;
  unsigned TXB1D32              : 1;
  unsigned TXB1D33              : 1;
  unsigned TXB1D34              : 1;
  unsigned TXB1D35              : 1;
  unsigned TXB1D36              : 1;
  unsigned TXB1D37              : 1;
  } __TXB1D3bits_t;

extern __at(0x0F19) volatile __TXB1D3bits_t TXB1D3bits;

#define _TXB1D30                0x01
#define _TXB1D31                0x02
#define _TXB1D32                0x04
#define _TXB1D33                0x08
#define _TXB1D34                0x10
#define _TXB1D35                0x20
#define _TXB1D36                0x40
#define _TXB1D37                0x80

//==============================================================================


//==============================================================================
//        TXB1D4 Bits

extern __at(0x0F1A) __sfr TXB1D4;

typedef struct
  {
  unsigned TXB1D40              : 1;
  unsigned TXB1D41              : 1;
  unsigned TXB1D42              : 1;
  unsigned TXB1D43              : 1;
  unsigned TXB1D44              : 1;
  unsigned TXB1D45              : 1;
  unsigned TXB1D46              : 1;
  unsigned TXB1D47              : 1;
  } __TXB1D4bits_t;

extern __at(0x0F1A) volatile __TXB1D4bits_t TXB1D4bits;

#define _TXB1D40                0x01
#define _TXB1D41                0x02
#define _TXB1D42                0x04
#define _TXB1D43                0x08
#define _TXB1D44                0x10
#define _TXB1D45                0x20
#define _TXB1D46                0x40
#define _TXB1D47                0x80

//==============================================================================


//==============================================================================
//        TXB1D5 Bits

extern __at(0x0F1B) __sfr TXB1D5;

typedef struct
  {
  unsigned TXB1D50              : 1;
  unsigned TXB1D51              : 1;
  unsigned TXB1D52              : 1;
  unsigned TXB1D53              : 1;
  unsigned TXB1D54              : 1;
  unsigned TXB1D55              : 1;
  unsigned TXB1D56              : 1;
  unsigned TXB1D57              : 1;
  } __TXB1D5bits_t;

extern __at(0x0F1B) volatile __TXB1D5bits_t TXB1D5bits;

#define _TXB1D50                0x01
#define _TXB1D51                0x02
#define _TXB1D52                0x04
#define _TXB1D53                0x08
#define _TXB1D54                0x10
#define _TXB1D55                0x20
#define _TXB1D56                0x40
#define _TXB1D57                0x80

//==============================================================================


//==============================================================================
//        TXB1D6 Bits

extern __at(0x0F1C) __sfr TXB1D6;

typedef struct
  {
  unsigned TXB1D60              : 1;
  unsigned TXB1D61              : 1;
  unsigned TXB1D62              : 1;
  unsigned TXB1D63              : 1;
  unsigned TXB1D64              : 1;
  unsigned TXB1D65              : 1;
  unsigned TXB1D66              : 1;
  unsigned TXB1D67              : 1;
  } __TXB1D6bits_t;

extern __at(0x0F1C) volatile __TXB1D6bits_t TXB1D6bits;

#define _TXB1D60                0x01
#define _TXB1D61                0x02
#define _TXB1D62                0x04
#define _TXB1D63                0x08
#define _TXB1D64                0x10
#define _TXB1D65                0x20
#define _TXB1D66                0x40
#define _TXB1D67                0x80

//==============================================================================


//==============================================================================
//        TXB1D7 Bits

extern __at(0x0F1D) __sfr TXB1D7;

typedef struct
  {
  unsigned TXB1D70              : 1;
  unsigned TXB1D71              : 1;
  unsigned TXB1D72              : 1;
  unsigned TXB1D73              : 1;
  unsigned TXB1D74              : 1;
  unsigned TXB1D75              : 1;
  unsigned TXB1D76              : 1;
  unsigned TXB1D77              : 1;
  } __TXB1D7bits_t;

extern __at(0x0F1D) volatile __TXB1D7bits_t TXB1D7bits;

#define _TXB1D70                0x01
#define _TXB1D71                0x02
#define _TXB1D72                0x04
#define _TXB1D73                0x08
#define _TXB1D74                0x10
#define _TXB1D75                0x20
#define _TXB1D76                0x40
#define _TXB1D77                0x80

//==============================================================================


//==============================================================================
//        CANSTAT_RO2 Bits

extern __at(0x0F1E) __sfr CANSTAT_RO2;

typedef union
  {
  struct
    {
    unsigned EICODE0            : 1;
    unsigned EICODE1_ICODE0     : 1;
    unsigned EICODE2_ICODE1     : 1;
    unsigned EICODE3_ICODE2     : 1;
    unsigned EICODE4            : 1;
    unsigned OPMODE0            : 1;
    unsigned OPMODE1            : 1;
    unsigned OPMODE2            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned EICODE1            : 1;
    unsigned EICODE2            : 1;
    unsigned EICODE3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ICODE20            : 1;
    unsigned ICODE21            : 1;
    unsigned ICODE2             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned EICODE             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned                    : 5;
    unsigned OPMODE             : 3;
    };
  } __CANSTAT_RO2bits_t;

extern __at(0x0F1E) volatile __CANSTAT_RO2bits_t CANSTAT_RO2bits;

#define _CANSTAT_RO2_EICODE0    0x01
#define _CANSTAT_RO2_EICODE1_ICODE0 0x02
#define _CANSTAT_RO2_EICODE1    0x02
#define _CANSTAT_RO2_ICODE20    0x02
#define _CANSTAT_RO2_EICODE2_ICODE1 0x04
#define _CANSTAT_RO2_EICODE2    0x04
#define _CANSTAT_RO2_ICODE21    0x04
#define _CANSTAT_RO2_EICODE3_ICODE2 0x08
#define _CANSTAT_RO2_EICODE3    0x08
#define _CANSTAT_RO2_ICODE2     0x08
#define _CANSTAT_RO2_EICODE4    0x10
#define _CANSTAT_RO2_OPMODE0    0x20
#define _CANSTAT_RO2_OPMODE1    0x40
#define _CANSTAT_RO2_OPMODE2    0x80

//==============================================================================


//==============================================================================
//        CANCON_RO2 Bits

extern __at(0x0F1F) __sfr CANCON_RO2;

typedef union
  {
  struct
    {
    unsigned FP0                : 1;
    unsigned WIN0_FP1           : 1;
    unsigned WIN1_FP2           : 1;
    unsigned WIN2_FP3           : 1;
    unsigned ABAT               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WIN0               : 1;
    unsigned WIN1               : 1;
    unsigned WIN2               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned FP1                : 1;
    unsigned FP2                : 1;
    unsigned FP3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned FP                 : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WIN                : 3;
    unsigned                    : 4;
    };
  } __CANCON_RO2bits_t;

extern __at(0x0F1F) volatile __CANCON_RO2bits_t CANCON_RO2bits;

#define _CANCON_RO2_FP0         0x01
#define _CANCON_RO2_WIN0_FP1    0x02
#define _CANCON_RO2_WIN0        0x02
#define _CANCON_RO2_FP1         0x02
#define _CANCON_RO2_WIN1_FP2    0x04
#define _CANCON_RO2_WIN1        0x04
#define _CANCON_RO2_FP2         0x04
#define _CANCON_RO2_WIN2_FP3    0x08
#define _CANCON_RO2_WIN2        0x08
#define _CANCON_RO2_FP3         0x08
#define _CANCON_RO2_ABAT        0x10

//==============================================================================


//==============================================================================
//        TXB0CON Bits

extern __at(0x0F20) __sfr TXB0CON;

typedef union
  {
  struct
    {
    unsigned TXPRI0             : 1;
    unsigned TXPRI1             : 1;
    unsigned                    : 1;
    unsigned TXREQ              : 1;
    unsigned TXERR              : 1;
    unsigned TXLARB             : 1;
    unsigned TXABT              : 1;
    unsigned TXBIF              : 1;
    };

  struct
    {
    unsigned TXPRI              : 2;
    unsigned                    : 6;
    };
  } __TXB0CONbits_t;

extern __at(0x0F20) volatile __TXB0CONbits_t TXB0CONbits;

#define _TXB0CON_TXPRI0         0x01
#define _TXB0CON_TXPRI1         0x02
#define _TXB0CON_TXREQ          0x08
#define _TXB0CON_TXERR          0x10
#define _TXB0CON_TXLARB         0x20
#define _TXB0CON_TXABT          0x40
#define _TXB0CON_TXBIF          0x80

//==============================================================================


//==============================================================================
//        TXB0SIDH Bits

extern __at(0x0F21) __sfr TXB0SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __TXB0SIDHbits_t;

extern __at(0x0F21) volatile __TXB0SIDHbits_t TXB0SIDHbits;

#define _TXB0SIDH_SID3          0x01
#define _TXB0SIDH_SID4          0x02
#define _TXB0SIDH_SID5          0x04
#define _TXB0SIDH_SID6          0x08
#define _TXB0SIDH_SID7          0x10
#define _TXB0SIDH_SID8          0x20
#define _TXB0SIDH_SID9          0x40
#define _TXB0SIDH_SID10         0x80

//==============================================================================


//==============================================================================
//        TXB0SIDL Bits

extern __at(0x0F22) __sfr TXB0SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXIDE              : 1;
    unsigned SRR                : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __TXB0SIDLbits_t;

extern __at(0x0F22) volatile __TXB0SIDLbits_t TXB0SIDLbits;

#define _TXB0SIDL_EID16         0x01
#define _TXB0SIDL_EID17         0x02
#define _TXB0SIDL_EXIDE         0x08
#define _TXB0SIDL_SRR           0x10
#define _TXB0SIDL_SID0          0x20
#define _TXB0SIDL_SID1          0x40
#define _TXB0SIDL_SID2          0x80

//==============================================================================


//==============================================================================
//        TXB0EIDH Bits

extern __at(0x0F23) __sfr TXB0EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __TXB0EIDHbits_t;

extern __at(0x0F23) volatile __TXB0EIDHbits_t TXB0EIDHbits;

#define _TXB0EIDH_EID8          0x01
#define _TXB0EIDH_EID9          0x02
#define _TXB0EIDH_EID10         0x04
#define _TXB0EIDH_EID11         0x08
#define _TXB0EIDH_EID12         0x10
#define _TXB0EIDH_EID13         0x20
#define _TXB0EIDH_EID14         0x40
#define _TXB0EIDH_EID15         0x80

//==============================================================================


//==============================================================================
//        TXB0EIDL Bits

extern __at(0x0F24) __sfr TXB0EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __TXB0EIDLbits_t;

extern __at(0x0F24) volatile __TXB0EIDLbits_t TXB0EIDLbits;

#define _TXB0EIDL_EID0          0x01
#define _TXB0EIDL_EID1          0x02
#define _TXB0EIDL_EID2          0x04
#define _TXB0EIDL_EID3          0x08
#define _TXB0EIDL_EID4          0x10
#define _TXB0EIDL_EID5          0x20
#define _TXB0EIDL_EID6          0x40
#define _TXB0EIDL_EID7          0x80

//==============================================================================


//==============================================================================
//        TXB0DLC Bits

extern __at(0x0F25) __sfr TXB0DLC;

typedef union
  {
  struct
    {
    unsigned DLC0               : 1;
    unsigned DLC1               : 1;
    unsigned DLC2               : 1;
    unsigned DLC3               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TXRTR              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DLC                : 4;
    unsigned                    : 4;
    };
  } __TXB0DLCbits_t;

extern __at(0x0F25) volatile __TXB0DLCbits_t TXB0DLCbits;

#define _TXB0DLC_DLC0           0x01
#define _TXB0DLC_DLC1           0x02
#define _TXB0DLC_DLC2           0x04
#define _TXB0DLC_DLC3           0x08
#define _TXB0DLC_TXRTR          0x40

//==============================================================================


//==============================================================================
//        TXB0D0 Bits

extern __at(0x0F26) __sfr TXB0D0;

typedef struct
  {
  unsigned TXB0D00              : 1;
  unsigned TXB0D01              : 1;
  unsigned TXB0D02              : 1;
  unsigned TXB0D03              : 1;
  unsigned TXB0D04              : 1;
  unsigned TXB0D05              : 1;
  unsigned TXB0D06              : 1;
  unsigned TXB0D07              : 1;
  } __TXB0D0bits_t;

extern __at(0x0F26) volatile __TXB0D0bits_t TXB0D0bits;

#define _TXB0D00                0x01
#define _TXB0D01                0x02
#define _TXB0D02                0x04
#define _TXB0D03                0x08
#define _TXB0D04                0x10
#define _TXB0D05                0x20
#define _TXB0D06                0x40
#define _TXB0D07                0x80

//==============================================================================


//==============================================================================
//        TXB0D1 Bits

extern __at(0x0F27) __sfr TXB0D1;

typedef struct
  {
  unsigned TXB0D10              : 1;
  unsigned TXB0D11              : 1;
  unsigned TXB0D12              : 1;
  unsigned TXB0D13              : 1;
  unsigned TXB0D14              : 1;
  unsigned TXB0D15              : 1;
  unsigned TXB0D16              : 1;
  unsigned TXB0D17              : 1;
  } __TXB0D1bits_t;

extern __at(0x0F27) volatile __TXB0D1bits_t TXB0D1bits;

#define _TXB0D10                0x01
#define _TXB0D11                0x02
#define _TXB0D12                0x04
#define _TXB0D13                0x08
#define _TXB0D14                0x10
#define _TXB0D15                0x20
#define _TXB0D16                0x40
#define _TXB0D17                0x80

//==============================================================================


//==============================================================================
//        TXB0D2 Bits

extern __at(0x0F28) __sfr TXB0D2;

typedef struct
  {
  unsigned TXB0D20              : 1;
  unsigned TXB0D21              : 1;
  unsigned TXB0D22              : 1;
  unsigned TXB0D23              : 1;
  unsigned TXB0D24              : 1;
  unsigned TXB0D25              : 1;
  unsigned TXB0D26              : 1;
  unsigned TXB0D27              : 1;
  } __TXB0D2bits_t;

extern __at(0x0F28) volatile __TXB0D2bits_t TXB0D2bits;

#define _TXB0D20                0x01
#define _TXB0D21                0x02
#define _TXB0D22                0x04
#define _TXB0D23                0x08
#define _TXB0D24                0x10
#define _TXB0D25                0x20
#define _TXB0D26                0x40
#define _TXB0D27                0x80

//==============================================================================


//==============================================================================
//        TXB0D3 Bits

extern __at(0x0F29) __sfr TXB0D3;

typedef struct
  {
  unsigned TXB0D30              : 1;
  unsigned TXB0D31              : 1;
  unsigned TXB0D32              : 1;
  unsigned TXB0D33              : 1;
  unsigned TXB0D34              : 1;
  unsigned TXB0D35              : 1;
  unsigned TXB0D36              : 1;
  unsigned TXB0D37              : 1;
  } __TXB0D3bits_t;

extern __at(0x0F29) volatile __TXB0D3bits_t TXB0D3bits;

#define _TXB0D30                0x01
#define _TXB0D31                0x02
#define _TXB0D32                0x04
#define _TXB0D33                0x08
#define _TXB0D34                0x10
#define _TXB0D35                0x20
#define _TXB0D36                0x40
#define _TXB0D37                0x80

//==============================================================================


//==============================================================================
//        TXB0D4 Bits

extern __at(0x0F2A) __sfr TXB0D4;

typedef struct
  {
  unsigned TXB0D40              : 1;
  unsigned TXB0D41              : 1;
  unsigned TXB0D42              : 1;
  unsigned TXB0D43              : 1;
  unsigned TXB0D44              : 1;
  unsigned TXB0D45              : 1;
  unsigned TXB0D46              : 1;
  unsigned TXB0D47              : 1;
  } __TXB0D4bits_t;

extern __at(0x0F2A) volatile __TXB0D4bits_t TXB0D4bits;

#define _TXB0D40                0x01
#define _TXB0D41                0x02
#define _TXB0D42                0x04
#define _TXB0D43                0x08
#define _TXB0D44                0x10
#define _TXB0D45                0x20
#define _TXB0D46                0x40
#define _TXB0D47                0x80

//==============================================================================


//==============================================================================
//        TXB0D5 Bits

extern __at(0x0F2B) __sfr TXB0D5;

typedef struct
  {
  unsigned TXB0D50              : 1;
  unsigned TXB0D51              : 1;
  unsigned TXB0D52              : 1;
  unsigned TXB0D53              : 1;
  unsigned TXB0D54              : 1;
  unsigned TXB0D55              : 1;
  unsigned TXB0D56              : 1;
  unsigned TXB0D57              : 1;
  } __TXB0D5bits_t;

extern __at(0x0F2B) volatile __TXB0D5bits_t TXB0D5bits;

#define _TXB0D50                0x01
#define _TXB0D51                0x02
#define _TXB0D52                0x04
#define _TXB0D53                0x08
#define _TXB0D54                0x10
#define _TXB0D55                0x20
#define _TXB0D56                0x40
#define _TXB0D57                0x80

//==============================================================================


//==============================================================================
//        TXB0D6 Bits

extern __at(0x0F2C) __sfr TXB0D6;

typedef struct
  {
  unsigned TXB0D60              : 1;
  unsigned TXB0D61              : 1;
  unsigned TXB0D62              : 1;
  unsigned TXB0D63              : 1;
  unsigned TXB0D64              : 1;
  unsigned TXB0D65              : 1;
  unsigned TXB0D66              : 1;
  unsigned TXB0D67              : 1;
  } __TXB0D6bits_t;

extern __at(0x0F2C) volatile __TXB0D6bits_t TXB0D6bits;

#define _TXB0D60                0x01
#define _TXB0D61                0x02
#define _TXB0D62                0x04
#define _TXB0D63                0x08
#define _TXB0D64                0x10
#define _TXB0D65                0x20
#define _TXB0D66                0x40
#define _TXB0D67                0x80

//==============================================================================


//==============================================================================
//        TXB0D7 Bits

extern __at(0x0F2D) __sfr TXB0D7;

typedef struct
  {
  unsigned TXB0D70              : 1;
  unsigned TXB0D71              : 1;
  unsigned TXB0D72              : 1;
  unsigned TXB0D73              : 1;
  unsigned TXB0D74              : 1;
  unsigned TXB0D75              : 1;
  unsigned TXB0D76              : 1;
  unsigned TXB0D77              : 1;
  } __TXB0D7bits_t;

extern __at(0x0F2D) volatile __TXB0D7bits_t TXB0D7bits;

#define _TXB0D70                0x01
#define _TXB0D71                0x02
#define _TXB0D72                0x04
#define _TXB0D73                0x08
#define _TXB0D74                0x10
#define _TXB0D75                0x20
#define _TXB0D76                0x40
#define _TXB0D77                0x80

//==============================================================================


//==============================================================================
//        CANSTAT_RO1 Bits

extern __at(0x0F2E) __sfr CANSTAT_RO1;

typedef union
  {
  struct
    {
    unsigned EICODE0            : 1;
    unsigned EICODE1_ICODE0     : 1;
    unsigned EICODE2_ICODE1     : 1;
    unsigned EICODE3_ICODE2     : 1;
    unsigned EICODE4            : 1;
    unsigned OPMODE0            : 1;
    unsigned OPMODE1            : 1;
    unsigned OPMODE2            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned EICODE1            : 1;
    unsigned EICODE2            : 1;
    unsigned EICODE3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ICODE0             : 1;
    unsigned ICODE1             : 1;
    unsigned ICODE2             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned EICODE             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ICODE              : 3;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 5;
    unsigned OPMODE             : 3;
    };
  } __CANSTAT_RO1bits_t;

extern __at(0x0F2E) volatile __CANSTAT_RO1bits_t CANSTAT_RO1bits;

#define _CANSTAT_RO1_EICODE0    0x01
#define _CANSTAT_RO1_EICODE1_ICODE0 0x02
#define _CANSTAT_RO1_EICODE1    0x02
#define _CANSTAT_RO1_ICODE0     0x02
#define _CANSTAT_RO1_EICODE2_ICODE1 0x04
#define _CANSTAT_RO1_EICODE2    0x04
#define _CANSTAT_RO1_ICODE1     0x04
#define _CANSTAT_RO1_EICODE3_ICODE2 0x08
#define _CANSTAT_RO1_EICODE3    0x08
#define _CANSTAT_RO1_ICODE2     0x08
#define _CANSTAT_RO1_EICODE4    0x10
#define _CANSTAT_RO1_OPMODE0    0x20
#define _CANSTAT_RO1_OPMODE1    0x40
#define _CANSTAT_RO1_OPMODE2    0x80

//==============================================================================


//==============================================================================
//        CANCON_RO1 Bits

extern __at(0x0F2F) __sfr CANCON_RO1;

typedef union
  {
  struct
    {
    unsigned FP0                : 1;
    unsigned WIN0_FP1           : 1;
    unsigned WIN1_FP2           : 1;
    unsigned WIN2_FP3           : 1;
    unsigned ABAT               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WIN0               : 1;
    unsigned WIN1               : 1;
    unsigned WIN2               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned FP1                : 1;
    unsigned FP2                : 1;
    unsigned FP3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned FP                 : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WIN                : 3;
    unsigned                    : 4;
    };
  } __CANCON_RO1bits_t;

extern __at(0x0F2F) volatile __CANCON_RO1bits_t CANCON_RO1bits;

#define _CANCON_RO1_FP0         0x01
#define _CANCON_RO1_WIN0_FP1    0x02
#define _CANCON_RO1_WIN0        0x02
#define _CANCON_RO1_FP1         0x02
#define _CANCON_RO1_WIN1_FP2    0x04
#define _CANCON_RO1_WIN1        0x04
#define _CANCON_RO1_FP2         0x04
#define _CANCON_RO1_WIN2_FP3    0x08
#define _CANCON_RO1_WIN2        0x08
#define _CANCON_RO1_FP3         0x08
#define _CANCON_RO1_ABAT        0x10

//==============================================================================


//==============================================================================
//        RXB1CON Bits

extern __at(0x0F30) __sfr RXB1CON;

typedef union
  {
  struct
    {
    unsigned FILHIT0            : 1;
    unsigned FILHIT1            : 1;
    unsigned FILHIT2            : 1;
    unsigned RXRTRRO_FILHIT3    : 1;
    unsigned FILHIT4            : 1;
    unsigned RXM0_RTRRO         : 1;
    unsigned RXM1               : 1;
    unsigned RXFUL              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RXRTRRO            : 1;
    unsigned                    : 1;
    unsigned RXM0               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned FILHIT3            : 1;
    unsigned                    : 1;
    unsigned RTRRO              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned FILHIT             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned                    : 5;
    unsigned RXM                : 2;
    unsigned                    : 1;
    };
  } __RXB1CONbits_t;

extern __at(0x0F30) volatile __RXB1CONbits_t RXB1CONbits;

#define _RXB1CON_FILHIT0        0x01
#define _RXB1CON_FILHIT1        0x02
#define _RXB1CON_FILHIT2        0x04
#define _RXB1CON_RXRTRRO_FILHIT3 0x08
#define _RXB1CON_RXRTRRO        0x08
#define _RXB1CON_FILHIT3        0x08
#define _RXB1CON_FILHIT4        0x10
#define _RXB1CON_RXM0_RTRRO     0x20
#define _RXB1CON_RXM0           0x20
#define _RXB1CON_RTRRO          0x20
#define _RXB1CON_RXM1           0x40
#define _RXB1CON_RXFUL          0x80

//==============================================================================


//==============================================================================
//        RXB1SIDH Bits

extern __at(0x0F31) __sfr RXB1SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __RXB1SIDHbits_t;

extern __at(0x0F31) volatile __RXB1SIDHbits_t RXB1SIDHbits;

#define _RXB1SIDH_SID3          0x01
#define _RXB1SIDH_SID4          0x02
#define _RXB1SIDH_SID5          0x04
#define _RXB1SIDH_SID6          0x08
#define _RXB1SIDH_SID7          0x10
#define _RXB1SIDH_SID8          0x20
#define _RXB1SIDH_SID9          0x40
#define _RXB1SIDH_SID10         0x80

//==============================================================================


//==============================================================================
//        RXB1SIDL Bits

extern __at(0x0F32) __sfr RXB1SIDL;

typedef union
  {
  struct
    {
    unsigned EDI16              : 1;
    unsigned EDI17              : 1;
    unsigned                    : 1;
    unsigned EXID               : 1;
    unsigned SRR                : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __RXB1SIDLbits_t;

extern __at(0x0F32) volatile __RXB1SIDLbits_t RXB1SIDLbits;

#define _RXB1SIDL_EDI16         0x01
#define _RXB1SIDL_EDI17         0x02
#define _RXB1SIDL_EXID          0x08
#define _RXB1SIDL_SRR           0x10
#define _RXB1SIDL_SID0          0x20
#define _RXB1SIDL_SID1          0x40
#define _RXB1SIDL_SID2          0x80

//==============================================================================


//==============================================================================
//        RXB1EIDH Bits

extern __at(0x0F33) __sfr RXB1EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __RXB1EIDHbits_t;

extern __at(0x0F33) volatile __RXB1EIDHbits_t RXB1EIDHbits;

#define _RXB1EIDH_EID8          0x01
#define _RXB1EIDH_EID9          0x02
#define _RXB1EIDH_EID10         0x04
#define _RXB1EIDH_EID11         0x08
#define _RXB1EIDH_EID12         0x10
#define _RXB1EIDH_EID13         0x20
#define _RXB1EIDH_EID14         0x40
#define _RXB1EIDH_EID15         0x80

//==============================================================================


//==============================================================================
//        RXB1EIDL Bits

extern __at(0x0F34) __sfr RXB1EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __RXB1EIDLbits_t;

extern __at(0x0F34) volatile __RXB1EIDLbits_t RXB1EIDLbits;

#define _RXB1EIDL_EID0          0x01
#define _RXB1EIDL_EID1          0x02
#define _RXB1EIDL_EID2          0x04
#define _RXB1EIDL_EID3          0x08
#define _RXB1EIDL_EID4          0x10
#define _RXB1EIDL_EID5          0x20
#define _RXB1EIDL_EID6          0x40
#define _RXB1EIDL_EID7          0x80

//==============================================================================


//==============================================================================
//        RXB1DLC Bits

extern __at(0x0F35) __sfr RXB1DLC;

typedef union
  {
  struct
    {
    unsigned DLC0               : 1;
    unsigned DLC1               : 1;
    unsigned DLC2               : 1;
    unsigned DLC3               : 1;
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RXRTR              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DLC                : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned RB                 : 2;
    unsigned                    : 2;
    };
  } __RXB1DLCbits_t;

extern __at(0x0F35) volatile __RXB1DLCbits_t RXB1DLCbits;

#define _RXB1DLC_DLC0           0x01
#define _RXB1DLC_DLC1           0x02
#define _RXB1DLC_DLC2           0x04
#define _RXB1DLC_DLC3           0x08
#define _RXB1DLC_RB0            0x10
#define _RXB1DLC_RB1            0x20
#define _RXB1DLC_RXRTR          0x40

//==============================================================================


//==============================================================================
//        RXB1D0 Bits

extern __at(0x0F36) __sfr RXB1D0;

typedef struct
  {
  unsigned RXB1D00              : 1;
  unsigned RXB1D01              : 1;
  unsigned RXB1D02              : 1;
  unsigned RXB1D03              : 1;
  unsigned RXB1D04              : 1;
  unsigned RXB1D05              : 1;
  unsigned RXB1D06              : 1;
  unsigned RXB1D07              : 1;
  } __RXB1D0bits_t;

extern __at(0x0F36) volatile __RXB1D0bits_t RXB1D0bits;

#define _RXB1D00                0x01
#define _RXB1D01                0x02
#define _RXB1D02                0x04
#define _RXB1D03                0x08
#define _RXB1D04                0x10
#define _RXB1D05                0x20
#define _RXB1D06                0x40
#define _RXB1D07                0x80

//==============================================================================


//==============================================================================
//        RXB1D1 Bits

extern __at(0x0F37) __sfr RXB1D1;

typedef struct
  {
  unsigned RXB1D10              : 1;
  unsigned RXB1D11              : 1;
  unsigned RXB1D12              : 1;
  unsigned RXB1D13              : 1;
  unsigned RXB1D14              : 1;
  unsigned RXB1D15              : 1;
  unsigned RXB1D16              : 1;
  unsigned RXB1D17              : 1;
  } __RXB1D1bits_t;

extern __at(0x0F37) volatile __RXB1D1bits_t RXB1D1bits;

#define _RXB1D10                0x01
#define _RXB1D11                0x02
#define _RXB1D12                0x04
#define _RXB1D13                0x08
#define _RXB1D14                0x10
#define _RXB1D15                0x20
#define _RXB1D16                0x40
#define _RXB1D17                0x80

//==============================================================================


//==============================================================================
//        RXB1D2 Bits

extern __at(0x0F38) __sfr RXB1D2;

typedef struct
  {
  unsigned RXB1D20              : 1;
  unsigned RXB1D21              : 1;
  unsigned RXB1D22              : 1;
  unsigned RXB1D23              : 1;
  unsigned RXB1D24              : 1;
  unsigned RXB1D25              : 1;
  unsigned RXB1D26              : 1;
  unsigned RXB1D27              : 1;
  } __RXB1D2bits_t;

extern __at(0x0F38) volatile __RXB1D2bits_t RXB1D2bits;

#define _RXB1D20                0x01
#define _RXB1D21                0x02
#define _RXB1D22                0x04
#define _RXB1D23                0x08
#define _RXB1D24                0x10
#define _RXB1D25                0x20
#define _RXB1D26                0x40
#define _RXB1D27                0x80

//==============================================================================


//==============================================================================
//        RXB1D3 Bits

extern __at(0x0F39) __sfr RXB1D3;

typedef struct
  {
  unsigned RXB1D30              : 1;
  unsigned RXB1D31              : 1;
  unsigned RXB1D32              : 1;
  unsigned RXB1D33              : 1;
  unsigned RXB1D34              : 1;
  unsigned RXB1D35              : 1;
  unsigned RXB1D36              : 1;
  unsigned RXB1D37              : 1;
  } __RXB1D3bits_t;

extern __at(0x0F39) volatile __RXB1D3bits_t RXB1D3bits;

#define _RXB1D30                0x01
#define _RXB1D31                0x02
#define _RXB1D32                0x04
#define _RXB1D33                0x08
#define _RXB1D34                0x10
#define _RXB1D35                0x20
#define _RXB1D36                0x40
#define _RXB1D37                0x80

//==============================================================================


//==============================================================================
//        RXB1D4 Bits

extern __at(0x0F3A) __sfr RXB1D4;

typedef struct
  {
  unsigned RXB1D40              : 1;
  unsigned RXB1D41              : 1;
  unsigned RXB1D42              : 1;
  unsigned RXB1D43              : 1;
  unsigned RXB1D44              : 1;
  unsigned RXB1D45              : 1;
  unsigned RXB1D46              : 1;
  unsigned RXB1D47              : 1;
  } __RXB1D4bits_t;

extern __at(0x0F3A) volatile __RXB1D4bits_t RXB1D4bits;

#define _RXB1D40                0x01
#define _RXB1D41                0x02
#define _RXB1D42                0x04
#define _RXB1D43                0x08
#define _RXB1D44                0x10
#define _RXB1D45                0x20
#define _RXB1D46                0x40
#define _RXB1D47                0x80

//==============================================================================


//==============================================================================
//        RXB1D5 Bits

extern __at(0x0F3B) __sfr RXB1D5;

typedef struct
  {
  unsigned RXB1D50              : 1;
  unsigned RXB1D51              : 1;
  unsigned RXB1D52              : 1;
  unsigned RXB1D53              : 1;
  unsigned RXB1D54              : 1;
  unsigned RXB1D55              : 1;
  unsigned RXB1D56              : 1;
  unsigned RXB1D57              : 1;
  } __RXB1D5bits_t;

extern __at(0x0F3B) volatile __RXB1D5bits_t RXB1D5bits;

#define _RXB1D50                0x01
#define _RXB1D51                0x02
#define _RXB1D52                0x04
#define _RXB1D53                0x08
#define _RXB1D54                0x10
#define _RXB1D55                0x20
#define _RXB1D56                0x40
#define _RXB1D57                0x80

//==============================================================================


//==============================================================================
//        RXB1D6 Bits

extern __at(0x0F3C) __sfr RXB1D6;

typedef struct
  {
  unsigned RXB1D60              : 1;
  unsigned RXB1D61              : 1;
  unsigned RXB1D62              : 1;
  unsigned RXB1D63              : 1;
  unsigned RXB1D64              : 1;
  unsigned RXB1D65              : 1;
  unsigned RXB1D66              : 1;
  unsigned RXB1D67              : 1;
  } __RXB1D6bits_t;

extern __at(0x0F3C) volatile __RXB1D6bits_t RXB1D6bits;

#define _RXB1D60                0x01
#define _RXB1D61                0x02
#define _RXB1D62                0x04
#define _RXB1D63                0x08
#define _RXB1D64                0x10
#define _RXB1D65                0x20
#define _RXB1D66                0x40
#define _RXB1D67                0x80

//==============================================================================


//==============================================================================
//        RXB1D7 Bits

extern __at(0x0F3D) __sfr RXB1D7;

typedef struct
  {
  unsigned RXB1D70              : 1;
  unsigned RXB1D71              : 1;
  unsigned RXB1D72              : 1;
  unsigned RXB1D73              : 1;
  unsigned RXB1D74              : 1;
  unsigned RXB1D75              : 1;
  unsigned RXB1D76              : 1;
  unsigned RXB1D77              : 1;
  } __RXB1D7bits_t;

extern __at(0x0F3D) volatile __RXB1D7bits_t RXB1D7bits;

#define _RXB1D70                0x01
#define _RXB1D71                0x02
#define _RXB1D72                0x04
#define _RXB1D73                0x08
#define _RXB1D74                0x10
#define _RXB1D75                0x20
#define _RXB1D76                0x40
#define _RXB1D77                0x80

//==============================================================================


//==============================================================================
//        CANSTAT_RO0 Bits

extern __at(0x0F3E) __sfr CANSTAT_RO0;

typedef union
  {
  struct
    {
    unsigned EICODE0            : 1;
    unsigned EICODE1_ICODE0     : 1;
    unsigned EICODE2_ICODE1     : 1;
    unsigned EICODE3_ICODE2     : 1;
    unsigned EICODE4            : 1;
    unsigned OPMODE0            : 1;
    unsigned OPMODE1            : 1;
    unsigned OPMODE2            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned EICODE1            : 1;
    unsigned EICODE2            : 1;
    unsigned EICODE3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ICODE0             : 1;
    unsigned ICODE1             : 1;
    unsigned ICODE2             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned EICODE             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ICODE              : 3;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 5;
    unsigned OPMODE             : 3;
    };
  } __CANSTAT_RO0bits_t;

extern __at(0x0F3E) volatile __CANSTAT_RO0bits_t CANSTAT_RO0bits;

#define _CANSTAT_RO0_EICODE0    0x01
#define _CANSTAT_RO0_EICODE1_ICODE0 0x02
#define _CANSTAT_RO0_EICODE1    0x02
#define _CANSTAT_RO0_ICODE0     0x02
#define _CANSTAT_RO0_EICODE2_ICODE1 0x04
#define _CANSTAT_RO0_EICODE2    0x04
#define _CANSTAT_RO0_ICODE1     0x04
#define _CANSTAT_RO0_EICODE3_ICODE2 0x08
#define _CANSTAT_RO0_EICODE3    0x08
#define _CANSTAT_RO0_ICODE2     0x08
#define _CANSTAT_RO0_EICODE4    0x10
#define _CANSTAT_RO0_OPMODE0    0x20
#define _CANSTAT_RO0_OPMODE1    0x40
#define _CANSTAT_RO0_OPMODE2    0x80

//==============================================================================


//==============================================================================
//        CANCON_RO0 Bits

extern __at(0x0F3F) __sfr CANCON_RO0;

typedef union
  {
  struct
    {
    unsigned FP0                : 1;
    unsigned WIN0_FP1           : 1;
    unsigned WIN1_FP2           : 1;
    unsigned WIN2_FP3           : 1;
    unsigned ABAT               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WIN0               : 1;
    unsigned WIN1               : 1;
    unsigned WIN2               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned FP1                : 1;
    unsigned FP2                : 1;
    unsigned FP3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned FP                 : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WIN                : 3;
    unsigned                    : 4;
    };
  } __CANCON_RO0bits_t;

extern __at(0x0F3F) volatile __CANCON_RO0bits_t CANCON_RO0bits;

#define _CANCON_RO0_FP0         0x01
#define _CANCON_RO0_WIN0_FP1    0x02
#define _CANCON_RO0_WIN0        0x02
#define _CANCON_RO0_FP1         0x02
#define _CANCON_RO0_WIN1_FP2    0x04
#define _CANCON_RO0_WIN1        0x04
#define _CANCON_RO0_FP2         0x04
#define _CANCON_RO0_WIN2_FP3    0x08
#define _CANCON_RO0_WIN2        0x08
#define _CANCON_RO0_FP3         0x08
#define _CANCON_RO0_ABAT        0x10

//==============================================================================


//==============================================================================
//        MDCARL Bits

extern __at(0x0F42) __sfr MDCARL;

typedef union
  {
  struct
    {
    unsigned MDCL0              : 1;
    unsigned MDCL1              : 1;
    unsigned MDCL2              : 1;
    unsigned MDCL3              : 1;
    unsigned                    : 1;
    unsigned MDCLSYNC           : 1;
    unsigned MDCLPOL            : 1;
    unsigned MDCLODIS           : 1;
    };

  struct
    {
    unsigned MDCL               : 4;
    unsigned                    : 4;
    };
  } __MDCARLbits_t;

extern __at(0x0F42) volatile __MDCARLbits_t MDCARLbits;

#define _MDCL0                  0x01
#define _MDCL1                  0x02
#define _MDCL2                  0x04
#define _MDCL3                  0x08
#define _MDCLSYNC               0x20
#define _MDCLPOL                0x40
#define _MDCLODIS               0x80

//==============================================================================


//==============================================================================
//        MDCARH Bits

extern __at(0x0F43) __sfr MDCARH;

typedef union
  {
  struct
    {
    unsigned MDCH0              : 1;
    unsigned MDCH1              : 1;
    unsigned MDCH2              : 1;
    unsigned MDCH3              : 1;
    unsigned                    : 1;
    unsigned MDCHSYNC           : 1;
    unsigned MDCHPOL            : 1;
    unsigned MDCHODIS           : 1;
    };

  struct
    {
    unsigned MDCH               : 4;
    unsigned                    : 4;
    };
  } __MDCARHbits_t;

extern __at(0x0F43) volatile __MDCARHbits_t MDCARHbits;

#define _MDCH0                  0x01
#define _MDCH1                  0x02
#define _MDCH2                  0x04
#define _MDCH3                  0x08
#define _MDCHSYNC               0x20
#define _MDCHPOL                0x40
#define _MDCHODIS               0x80

//==============================================================================


//==============================================================================
//        MDSRC Bits

extern __at(0x0F44) __sfr MDSRC;

typedef union
  {
  struct
    {
    unsigned MDSRC0             : 1;
    unsigned MDSRC1             : 1;
    unsigned MDSRC2             : 1;
    unsigned MDSRC3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned MDSODIS            : 1;
    };

  struct
    {
    unsigned MDSRC              : 4;
    unsigned                    : 4;
    };
  } __MDSRCbits_t;

extern __at(0x0F44) volatile __MDSRCbits_t MDSRCbits;

#define _MDSRC0                 0x01
#define _MDSRC1                 0x02
#define _MDSRC2                 0x04
#define _MDSRC3                 0x08
#define _MDSODIS                0x80

//==============================================================================


//==============================================================================
//        MDCON Bits

extern __at(0x0F45) __sfr MDCON;

typedef struct
  {
  unsigned MDBIT                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned MDO                  : 1;
  unsigned MDOPOL               : 1;
  unsigned MDSLR                : 1;
  unsigned MDOE                 : 1;
  unsigned MDEN                 : 1;
  } __MDCONbits_t;

extern __at(0x0F45) volatile __MDCONbits_t MDCONbits;

#define _MDBIT                  0x01
#define _MDO                    0x08
#define _MDOPOL                 0x10
#define _MDSLR                  0x20
#define _MDOE                   0x40
#define _MDEN                   0x80

//==============================================================================


//==============================================================================
//        PSPCON Bits

extern __at(0x0F46) __sfr PSPCON;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PSPMODE              : 1;
  unsigned IBOV                 : 1;
  unsigned OBF                  : 1;
  unsigned IBF                  : 1;
  } __PSPCONbits_t;

extern __at(0x0F46) volatile __PSPCONbits_t PSPCONbits;

#define _PSPMODE                0x10
#define _IBOV                   0x20
#define _OBF                    0x40
#define _IBF                    0x80

//==============================================================================


//==============================================================================
//        CCP5CON Bits

extern __at(0x0F47) __sfr CCP5CON;

typedef union
  {
  struct
    {
    unsigned CCP5M0             : 1;
    unsigned CCP5M1             : 1;
    unsigned CCP5M2             : 1;
    unsigned CCP5M3             : 1;
    unsigned DC5B0              : 1;
    unsigned DC5B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP5Y              : 1;
    unsigned CCP5X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP5M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC5B               : 2;
    unsigned                    : 2;
    };
  } __CCP5CONbits_t;

extern __at(0x0F47) volatile __CCP5CONbits_t CCP5CONbits;

#define _CCP5M0                 0x01
#define _CCP5M1                 0x02
#define _CCP5M2                 0x04
#define _CCP5M3                 0x08
#define _DC5B0                  0x10
#define _CCP5Y                  0x10
#define _DC5B1                  0x20
#define _CCP5X                  0x20

//==============================================================================

extern __at(0x0F48) __sfr CCPR5;
extern __at(0x0F48) __sfr CCPR5L;
extern __at(0x0F49) __sfr CCPR5H;

//==============================================================================
//        CCP4CON Bits

extern __at(0x0F4A) __sfr CCP4CON;

typedef union
  {
  struct
    {
    unsigned CCP4M0             : 1;
    unsigned CCP4M1             : 1;
    unsigned CCP4M2             : 1;
    unsigned CCP4M3             : 1;
    unsigned DC4B0              : 1;
    unsigned DC4B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP4Y              : 1;
    unsigned CCP4X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP4M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC4B               : 2;
    unsigned                    : 2;
    };
  } __CCP4CONbits_t;

extern __at(0x0F4A) volatile __CCP4CONbits_t CCP4CONbits;

#define _CCP4M0                 0x01
#define _CCP4M1                 0x02
#define _CCP4M2                 0x04
#define _CCP4M3                 0x08
#define _DC4B0                  0x10
#define _CCP4Y                  0x10
#define _DC4B1                  0x20
#define _CCP4X                  0x20

//==============================================================================

extern __at(0x0F4B) __sfr CCPR4;
extern __at(0x0F4B) __sfr CCPR4L;
extern __at(0x0F4C) __sfr CCPR4H;

//==============================================================================
//        CCP3CON Bits

extern __at(0x0F4D) __sfr CCP3CON;

typedef union
  {
  struct
    {
    unsigned CCP3M0             : 1;
    unsigned CCP3M1             : 1;
    unsigned CCP3M2             : 1;
    unsigned CCP3M3             : 1;
    unsigned DC3B0              : 1;
    unsigned DC3B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP3Y              : 1;
    unsigned CCP3X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP3M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC3B               : 2;
    unsigned                    : 2;
    };
  } __CCP3CONbits_t;

extern __at(0x0F4D) volatile __CCP3CONbits_t CCP3CONbits;

#define _CCP3M0                 0x01
#define _CCP3M1                 0x02
#define _CCP3M2                 0x04
#define _CCP3M3                 0x08
#define _DC3B0                  0x10
#define _CCP3Y                  0x10
#define _DC3B1                  0x20
#define _CCP3X                  0x20

//==============================================================================

extern __at(0x0F4E) __sfr CCPR3;
extern __at(0x0F4E) __sfr CCPR3L;
extern __at(0x0F4F) __sfr CCPR3H;

//==============================================================================
//        CCP2CON Bits

extern __at(0x0F50) __sfr CCP2CON;

typedef union
  {
  struct
    {
    unsigned CCP2M0             : 1;
    unsigned CCP2M1             : 1;
    unsigned CCP2M2             : 1;
    unsigned CCP2M3             : 1;
    unsigned DC2B0              : 1;
    unsigned DC2B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP2Y              : 1;
    unsigned CCP2X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP2M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC2B               : 2;
    unsigned                    : 2;
    };
  } __CCP2CONbits_t;

extern __at(0x0F50) volatile __CCP2CONbits_t CCP2CONbits;

#define _CCP2M0                 0x01
#define _CCP2M1                 0x02
#define _CCP2M2                 0x04
#define _CCP2M3                 0x08
#define _DC2B0                  0x10
#define _CCP2Y                  0x10
#define _DC2B1                  0x20
#define _CCP2X                  0x20

//==============================================================================


//==============================================================================
//        ECCP2CON Bits

extern __at(0x0F50) __sfr ECCP2CON;

typedef union
  {
  struct
    {
    unsigned CCP2M0             : 1;
    unsigned CCP2M1             : 1;
    unsigned CCP2M2             : 1;
    unsigned CCP2M3             : 1;
    unsigned DC2B0              : 1;
    unsigned DC2B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP2Y              : 1;
    unsigned CCP2X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP2M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC2B               : 2;
    unsigned                    : 2;
    };
  } __ECCP2CONbits_t;

extern __at(0x0F50) volatile __ECCP2CONbits_t ECCP2CONbits;

#define _ECCP2CON_CCP2M0        0x01
#define _ECCP2CON_CCP2M1        0x02
#define _ECCP2CON_CCP2M2        0x04
#define _ECCP2CON_CCP2M3        0x08
#define _ECCP2CON_DC2B0         0x10
#define _ECCP2CON_CCP2Y         0x10
#define _ECCP2CON_DC2B1         0x20
#define _ECCP2CON_CCP2X         0x20

//==============================================================================

extern __at(0x0F51) __sfr CCPR2;
extern __at(0x0F51) __sfr CCPR2L;
extern __at(0x0F52) __sfr CCPR2H;

//==============================================================================
//        CTMUICON Bits

extern __at(0x0F53) __sfr CTMUICON;

typedef union
  {
  struct
    {
    unsigned IRNG0              : 1;
    unsigned IRNG1              : 1;
    unsigned ITRIM0             : 1;
    unsigned ITRIM1             : 1;
    unsigned ITRIM2             : 1;
    unsigned ITRIM3             : 1;
    unsigned ITRIM4             : 1;
    unsigned ITRIM5             : 1;
    };

  struct
    {
    unsigned IRNG               : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned ITRIM              : 6;
    };
  } __CTMUICONbits_t;

extern __at(0x0F53) volatile __CTMUICONbits_t CTMUICONbits;

#define _IRNG0                  0x01
#define _IRNG1                  0x02
#define _ITRIM0                 0x04
#define _ITRIM1                 0x08
#define _ITRIM2                 0x10
#define _ITRIM3                 0x20
#define _ITRIM4                 0x40
#define _ITRIM5                 0x80

//==============================================================================


//==============================================================================
//        CTMUCONL Bits

extern __at(0x0F54) __sfr CTMUCONL;

typedef union
  {
  struct
    {
    unsigned EDG1STAT           : 1;
    unsigned EDG2STAT           : 1;
    unsigned EDG1SEL0           : 1;
    unsigned EDG1SEL1           : 1;
    unsigned EDG1POL            : 1;
    unsigned EDG2SEL0           : 1;
    unsigned EDG2SEL1           : 1;
    unsigned EDG2POL            : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned EDG1SEL            : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 5;
    unsigned EDG2SEL            : 2;
    unsigned                    : 1;
    };
  } __CTMUCONLbits_t;

extern __at(0x0F54) volatile __CTMUCONLbits_t CTMUCONLbits;

#define _EDG1STAT               0x01
#define _EDG2STAT               0x02
#define _EDG1SEL0               0x04
#define _EDG1SEL1               0x08
#define _EDG1POL                0x10
#define _EDG2SEL0               0x20
#define _EDG2SEL1               0x40
#define _EDG2POL                0x80

//==============================================================================


//==============================================================================
//        CTMUCONH Bits

extern __at(0x0F55) __sfr CTMUCONH;

typedef struct
  {
  unsigned CTTRIG               : 1;
  unsigned IDISSEN              : 1;
  unsigned EDGSEQEN             : 1;
  unsigned EDGEN                : 1;
  unsigned TGEN                 : 1;
  unsigned CTMUSIDL             : 1;
  unsigned                      : 1;
  unsigned CTMUEN               : 1;
  } __CTMUCONHbits_t;

extern __at(0x0F55) volatile __CTMUCONHbits_t CTMUCONHbits;

#define _CTTRIG                 0x01
#define _IDISSEN                0x02
#define _EDGSEQEN               0x04
#define _EDGEN                  0x08
#define _TGEN                   0x10
#define _CTMUSIDL               0x20
#define _CTMUEN                 0x80

//==============================================================================


//==============================================================================
//        PADCFG1 Bits

extern __at(0x0F56) __sfr PADCFG1;

typedef struct
  {
  unsigned CTMUDS               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned RGPU                 : 1;
  unsigned RFPU                 : 1;
  unsigned REPU                 : 1;
  unsigned RDPU                 : 1;
  } __PADCFG1bits_t;

extern __at(0x0F56) volatile __PADCFG1bits_t PADCFG1bits;

#define _CTMUDS                 0x01
#define _RGPU                   0x10
#define _RFPU                   0x20
#define _REPU                   0x40
#define _RDPU                   0x80

//==============================================================================


//==============================================================================
//        PMD2 Bits

extern __at(0x0F57) __sfr PMD2;

typedef struct
  {
  unsigned CMP1MD               : 1;
  unsigned CMP2MD               : 1;
  unsigned ECANMD               : 1;
  unsigned MODMD                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PMD2bits_t;

extern __at(0x0F57) volatile __PMD2bits_t PMD2bits;

#define _CMP1MD                 0x01
#define _CMP2MD                 0x02
#define _ECANMD                 0x04
#define _MODMD                  0x08

//==============================================================================


//==============================================================================
//        PMD1 Bits

extern __at(0x0F58) __sfr PMD1;

typedef struct
  {
  unsigned TMR0MD               : 1;
  unsigned TMR1MD               : 1;
  unsigned TMR2MD               : 1;
  unsigned TMR3MD               : 1;
  unsigned TMR4MD               : 1;
  unsigned ADCMD                : 1;
  unsigned CTMUMD               : 1;
  unsigned PSPMD                : 1;
  } __PMD1bits_t;

extern __at(0x0F58) volatile __PMD1bits_t PMD1bits;

#define _TMR0MD                 0x01
#define _TMR1MD                 0x02
#define _TMR2MD                 0x04
#define _TMR3MD                 0x08
#define _TMR4MD                 0x10
#define _ADCMD                  0x20
#define _CTMUMD                 0x40
#define _PSPMD                  0x80

//==============================================================================


//==============================================================================
//        PMD0 Bits

extern __at(0x0F59) __sfr PMD0;

typedef struct
  {
  unsigned SSPMD                : 1;
  unsigned UART1MD              : 1;
  unsigned UART2MD              : 1;
  unsigned CCP1MD               : 1;
  unsigned CCP2MD               : 1;
  unsigned CCP3MD               : 1;
  unsigned CCP4MD               : 1;
  unsigned CCP5MD               : 1;
  } __PMD0bits_t;

extern __at(0x0F59) volatile __PMD0bits_t PMD0bits;

#define _SSPMD                  0x01
#define _UART1MD                0x02
#define _UART2MD                0x04
#define _CCP1MD                 0x08
#define _CCP2MD                 0x10
#define _CCP3MD                 0x20
#define _CCP4MD                 0x40
#define _CCP5MD                 0x80

//==============================================================================


//==============================================================================
//        IOCB Bits

extern __at(0x0F5A) __sfr IOCB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCB4                : 1;
  unsigned IOCB5                : 1;
  unsigned IOCB6                : 1;
  unsigned IOCB7                : 1;
  } __IOCBbits_t;

extern __at(0x0F5A) volatile __IOCBbits_t IOCBbits;

#define _IOCB4                  0x10
#define _IOCB5                  0x20
#define _IOCB6                  0x40
#define _IOCB7                  0x80

//==============================================================================


//==============================================================================
//        WPUB Bits

extern __at(0x0F5B) __sfr WPUB;

typedef struct
  {
  unsigned WPUB0                : 1;
  unsigned WPUB1                : 1;
  unsigned WPUB2                : 1;
  unsigned WPUB3                : 1;
  unsigned WPUB4                : 1;
  unsigned WPUB5                : 1;
  unsigned WPUB6                : 1;
  unsigned WPUB7                : 1;
  } __WPUBbits_t;

extern __at(0x0F5B) volatile __WPUBbits_t WPUBbits;

#define _WPUB0                  0x01
#define _WPUB1                  0x02
#define _WPUB2                  0x04
#define _WPUB3                  0x08
#define _WPUB4                  0x10
#define _WPUB5                  0x20
#define _WPUB6                  0x40
#define _WPUB7                  0x80

//==============================================================================


//==============================================================================
//        ANCON1 Bits

extern __at(0x0F5C) __sfr ANCON1;

typedef struct
  {
  unsigned ANSEL8               : 1;
  unsigned ANSEL9               : 1;
  unsigned ANSEL10              : 1;
  unsigned ANSEL11              : 1;
  unsigned ANSEL12              : 1;
  unsigned ANSEL13              : 1;
  unsigned ANSEL14              : 1;
  unsigned                      : 1;
  } __ANCON1bits_t;

extern __at(0x0F5C) volatile __ANCON1bits_t ANCON1bits;

#define _ANSEL8                 0x01
#define _ANSEL9                 0x02
#define _ANSEL10                0x04
#define _ANSEL11                0x08
#define _ANSEL12                0x10
#define _ANSEL13                0x20
#define _ANSEL14                0x40

//==============================================================================


//==============================================================================
//        ANCON0 Bits

extern __at(0x0F5D) __sfr ANCON0;

typedef struct
  {
  unsigned ANSEL0               : 1;
  unsigned ANSEL1               : 1;
  unsigned ANSEL2               : 1;
  unsigned ANSEL3               : 1;
  unsigned ANSEL4               : 1;
  unsigned ANSEL5               : 1;
  unsigned ANSEL6               : 1;
  unsigned ANSEL7               : 1;
  } __ANCON0bits_t;

extern __at(0x0F5D) volatile __ANCON0bits_t ANCON0bits;

#define _ANSEL0                 0x01
#define _ANSEL1                 0x02
#define _ANSEL2                 0x04
#define _ANSEL3                 0x08
#define _ANSEL4                 0x10
#define _ANSEL5                 0x20
#define _ANSEL6                 0x40
#define _ANSEL7                 0x80

//==============================================================================


//==============================================================================
//        CM2CON Bits

extern __at(0x0F5E) __sfr CM2CON;

typedef union
  {
  struct
    {
    unsigned CCH0               : 1;
    unsigned CCH1               : 1;
    unsigned CREF               : 1;
    unsigned EVPOL0             : 1;
    unsigned EVPOL1             : 1;
    unsigned CPOL               : 1;
    unsigned COE                : 1;
    unsigned CON                : 1;
    };

  struct
    {
    unsigned CCH                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned EVPOL              : 2;
    unsigned                    : 3;
    };
  } __CM2CONbits_t;

extern __at(0x0F5E) volatile __CM2CONbits_t CM2CONbits;

#define _CM2CON_CCH0            0x01
#define _CM2CON_CCH1            0x02
#define _CM2CON_CREF            0x04
#define _CM2CON_EVPOL0          0x08
#define _CM2CON_EVPOL1          0x10
#define _CM2CON_CPOL            0x20
#define _CM2CON_COE             0x40
#define _CM2CON_CON             0x80

//==============================================================================


//==============================================================================
//        CM2CON1 Bits

extern __at(0x0F5E) __sfr CM2CON1;

typedef union
  {
  struct
    {
    unsigned CCH0               : 1;
    unsigned CCH1               : 1;
    unsigned CREF               : 1;
    unsigned EVPOL0             : 1;
    unsigned EVPOL1             : 1;
    unsigned CPOL               : 1;
    unsigned COE                : 1;
    unsigned CON                : 1;
    };

  struct
    {
    unsigned CCH                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned EVPOL              : 2;
    unsigned                    : 3;
    };
  } __CM2CON1bits_t;

extern __at(0x0F5E) volatile __CM2CON1bits_t CM2CON1bits;

#define _CM2CON1_CCH0           0x01
#define _CM2CON1_CCH1           0x02
#define _CM2CON1_CREF           0x04
#define _CM2CON1_EVPOL0         0x08
#define _CM2CON1_EVPOL1         0x10
#define _CM2CON1_CPOL           0x20
#define _CM2CON1_COE            0x40
#define _CM2CON1_CON            0x80

//==============================================================================


//==============================================================================
//        CM1CON Bits

extern __at(0x0F5F) __sfr CM1CON;

typedef union
  {
  struct
    {
    unsigned CCH0               : 1;
    unsigned CCH1               : 1;
    unsigned CREF               : 1;
    unsigned EVPOL0             : 1;
    unsigned EVPOL1             : 1;
    unsigned CPOL               : 1;
    unsigned COE                : 1;
    unsigned CON                : 1;
    };

  struct
    {
    unsigned CCH                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned EVPOL              : 2;
    unsigned                    : 3;
    };
  } __CM1CONbits_t;

extern __at(0x0F5F) volatile __CM1CONbits_t CM1CONbits;

#define _CCH0                   0x01
#define _CCH1                   0x02
#define _CREF                   0x04
#define _EVPOL0                 0x08
#define _EVPOL1                 0x10
#define _CPOL                   0x20
#define _COE                    0x40
#define _CON                    0x80

//==============================================================================


//==============================================================================
//        CM1CON1 Bits

extern __at(0x0F5F) __sfr CM1CON1;

typedef union
  {
  struct
    {
    unsigned CCH0               : 1;
    unsigned CCH1               : 1;
    unsigned CREF               : 1;
    unsigned EVPOL0             : 1;
    unsigned EVPOL1             : 1;
    unsigned CPOL               : 1;
    unsigned COE                : 1;
    unsigned CON                : 1;
    };

  struct
    {
    unsigned CCH                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned EVPOL              : 2;
    unsigned                    : 3;
    };
  } __CM1CON1bits_t;

extern __at(0x0F5F) volatile __CM1CON1bits_t CM1CON1bits;

#define _CM1CON1_CCH0           0x01
#define _CM1CON1_CCH1           0x02
#define _CM1CON1_CREF           0x04
#define _CM1CON1_EVPOL0         0x08
#define _CM1CON1_EVPOL1         0x10
#define _CM1CON1_CPOL           0x20
#define _CM1CON1_COE            0x40
#define _CM1CON1_CON            0x80

//==============================================================================


//==============================================================================
//        RXB0CON Bits

extern __at(0x0F60) __sfr RXB0CON;

typedef union
  {
  struct
    {
    unsigned FILHIT0            : 1;
    unsigned JTOFF_FILHIT1      : 1;
    unsigned RB0DBEN_FILHIT2    : 1;
    unsigned RXRTRRO_FILHIT3    : 1;
    unsigned FILHIT4            : 1;
    unsigned RXM0_RTRRO         : 1;
    unsigned RXM1               : 1;
    unsigned RXFUL              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned JTOFF              : 1;
    unsigned RB0DBEN            : 1;
    unsigned RXRTRRO            : 1;
    unsigned                    : 1;
    unsigned RTRRO              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned FILHIT1            : 1;
    unsigned FILHIT2            : 1;
    unsigned FILHIT3            : 1;
    unsigned                    : 1;
    unsigned RXM0               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned FILHIT             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned                    : 5;
    unsigned RXM                : 2;
    unsigned                    : 1;
    };
  } __RXB0CONbits_t;

extern __at(0x0F60) volatile __RXB0CONbits_t RXB0CONbits;

#define _RXB0CON_FILHIT0        0x01
#define _RXB0CON_JTOFF_FILHIT1  0x02
#define _RXB0CON_JTOFF          0x02
#define _RXB0CON_FILHIT1        0x02
#define _RXB0CON_RB0DBEN_FILHIT2 0x04
#define _RXB0CON_RB0DBEN        0x04
#define _RXB0CON_FILHIT2        0x04
#define _RXB0CON_RXRTRRO_FILHIT3 0x08
#define _RXB0CON_RXRTRRO        0x08
#define _RXB0CON_FILHIT3        0x08
#define _RXB0CON_FILHIT4        0x10
#define _RXB0CON_RXM0_RTRRO     0x20
#define _RXB0CON_RTRRO          0x20
#define _RXB0CON_RXM0           0x20
#define _RXB0CON_RXM1           0x40
#define _RXB0CON_RXFUL          0x80

//==============================================================================


//==============================================================================
//        RXB0SIDH Bits

extern __at(0x0F61) __sfr RXB0SIDH;

typedef struct
  {
  unsigned SID3                 : 1;
  unsigned SID4                 : 1;
  unsigned SID5                 : 1;
  unsigned SID6                 : 1;
  unsigned SID7                 : 1;
  unsigned SID8                 : 1;
  unsigned SID9                 : 1;
  unsigned SID10                : 1;
  } __RXB0SIDHbits_t;

extern __at(0x0F61) volatile __RXB0SIDHbits_t RXB0SIDHbits;

#define _RXB0SIDH_SID3          0x01
#define _RXB0SIDH_SID4          0x02
#define _RXB0SIDH_SID5          0x04
#define _RXB0SIDH_SID6          0x08
#define _RXB0SIDH_SID7          0x10
#define _RXB0SIDH_SID8          0x20
#define _RXB0SIDH_SID9          0x40
#define _RXB0SIDH_SID10         0x80

//==============================================================================


//==============================================================================
//        RXB0SIDL Bits

extern __at(0x0F62) __sfr RXB0SIDL;

typedef union
  {
  struct
    {
    unsigned EID16              : 1;
    unsigned EID17              : 1;
    unsigned                    : 1;
    unsigned EXID               : 1;
    unsigned SRR                : 1;
    unsigned SID0               : 1;
    unsigned SID1               : 1;
    unsigned SID2               : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned SID                : 3;
    };
  } __RXB0SIDLbits_t;

extern __at(0x0F62) volatile __RXB0SIDLbits_t RXB0SIDLbits;

#define _RXB0SIDL_EID16         0x01
#define _RXB0SIDL_EID17         0x02
#define _RXB0SIDL_EXID          0x08
#define _RXB0SIDL_SRR           0x10
#define _RXB0SIDL_SID0          0x20
#define _RXB0SIDL_SID1          0x40
#define _RXB0SIDL_SID2          0x80

//==============================================================================


//==============================================================================
//        RXB0EIDH Bits

extern __at(0x0F63) __sfr RXB0EIDH;

typedef struct
  {
  unsigned EID8                 : 1;
  unsigned EID9                 : 1;
  unsigned EID10                : 1;
  unsigned EID11                : 1;
  unsigned EID12                : 1;
  unsigned EID13                : 1;
  unsigned EID14                : 1;
  unsigned EID15                : 1;
  } __RXB0EIDHbits_t;

extern __at(0x0F63) volatile __RXB0EIDHbits_t RXB0EIDHbits;

#define _RXB0EIDH_EID8          0x01
#define _RXB0EIDH_EID9          0x02
#define _RXB0EIDH_EID10         0x04
#define _RXB0EIDH_EID11         0x08
#define _RXB0EIDH_EID12         0x10
#define _RXB0EIDH_EID13         0x20
#define _RXB0EIDH_EID14         0x40
#define _RXB0EIDH_EID15         0x80

//==============================================================================


//==============================================================================
//        RXB0EIDL Bits

extern __at(0x0F64) __sfr RXB0EIDL;

typedef struct
  {
  unsigned EID0                 : 1;
  unsigned EID1                 : 1;
  unsigned EID2                 : 1;
  unsigned EID3                 : 1;
  unsigned EID4                 : 1;
  unsigned EID5                 : 1;
  unsigned EID6                 : 1;
  unsigned EID7                 : 1;
  } __RXB0EIDLbits_t;

extern __at(0x0F64) volatile __RXB0EIDLbits_t RXB0EIDLbits;

#define _RXB0EIDL_EID0          0x01
#define _RXB0EIDL_EID1          0x02
#define _RXB0EIDL_EID2          0x04
#define _RXB0EIDL_EID3          0x08
#define _RXB0EIDL_EID4          0x10
#define _RXB0EIDL_EID5          0x20
#define _RXB0EIDL_EID6          0x40
#define _RXB0EIDL_EID7          0x80

//==============================================================================


//==============================================================================
//        RXB0DLC Bits

extern __at(0x0F65) __sfr RXB0DLC;

typedef union
  {
  struct
    {
    unsigned DLC0               : 1;
    unsigned DLC1               : 1;
    unsigned DLC2               : 1;
    unsigned DLC3               : 1;
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RXRTR              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DLC                : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned RB                 : 2;
    unsigned                    : 2;
    };
  } __RXB0DLCbits_t;

extern __at(0x0F65) volatile __RXB0DLCbits_t RXB0DLCbits;

#define _RXB0DLC_DLC0           0x01
#define _RXB0DLC_DLC1           0x02
#define _RXB0DLC_DLC2           0x04
#define _RXB0DLC_DLC3           0x08
#define _RXB0DLC_RB0            0x10
#define _RXB0DLC_RB1            0x20
#define _RXB0DLC_RXRTR          0x40

//==============================================================================


//==============================================================================
//        RXB0D0 Bits

extern __at(0x0F66) __sfr RXB0D0;

typedef struct
  {
  unsigned RXB0D00              : 1;
  unsigned RXB0D01              : 1;
  unsigned RXB0D02              : 1;
  unsigned RXB0D03              : 1;
  unsigned RXB0D04              : 1;
  unsigned RXB0D05              : 1;
  unsigned RXB0D06              : 1;
  unsigned RXB0D07              : 1;
  } __RXB0D0bits_t;

extern __at(0x0F66) volatile __RXB0D0bits_t RXB0D0bits;

#define _RXB0D00                0x01
#define _RXB0D01                0x02
#define _RXB0D02                0x04
#define _RXB0D03                0x08
#define _RXB0D04                0x10
#define _RXB0D05                0x20
#define _RXB0D06                0x40
#define _RXB0D07                0x80

//==============================================================================


//==============================================================================
//        RXB0D1 Bits

extern __at(0x0F67) __sfr RXB0D1;

typedef struct
  {
  unsigned RXB0D10              : 1;
  unsigned RXB0D11              : 1;
  unsigned RXB0D12              : 1;
  unsigned RXB0D13              : 1;
  unsigned RXB0D14              : 1;
  unsigned RXB0D15              : 1;
  unsigned RXB0D16              : 1;
  unsigned RXB0D17              : 1;
  } __RXB0D1bits_t;

extern __at(0x0F67) volatile __RXB0D1bits_t RXB0D1bits;

#define _RXB0D10                0x01
#define _RXB0D11                0x02
#define _RXB0D12                0x04
#define _RXB0D13                0x08
#define _RXB0D14                0x10
#define _RXB0D15                0x20
#define _RXB0D16                0x40
#define _RXB0D17                0x80

//==============================================================================


//==============================================================================
//        RXB0D2 Bits

extern __at(0x0F68) __sfr RXB0D2;

typedef struct
  {
  unsigned RXB0D20              : 1;
  unsigned RXB0D21              : 1;
  unsigned RXB0D22              : 1;
  unsigned RXB0D23              : 1;
  unsigned RXB0D24              : 1;
  unsigned RXB0D25              : 1;
  unsigned RXB0D26              : 1;
  unsigned RXB0D27              : 1;
  } __RXB0D2bits_t;

extern __at(0x0F68) volatile __RXB0D2bits_t RXB0D2bits;

#define _RXB0D20                0x01
#define _RXB0D21                0x02
#define _RXB0D22                0x04
#define _RXB0D23                0x08
#define _RXB0D24                0x10
#define _RXB0D25                0x20
#define _RXB0D26                0x40
#define _RXB0D27                0x80

//==============================================================================


//==============================================================================
//        RXB0D3 Bits

extern __at(0x0F69) __sfr RXB0D3;

typedef struct
  {
  unsigned RXB0D30              : 1;
  unsigned RXB0D31              : 1;
  unsigned RXB0D32              : 1;
  unsigned RXB0D33              : 1;
  unsigned RXB0D34              : 1;
  unsigned RXB0D35              : 1;
  unsigned RXB0D36              : 1;
  unsigned RXB0D37              : 1;
  } __RXB0D3bits_t;

extern __at(0x0F69) volatile __RXB0D3bits_t RXB0D3bits;

#define _RXB0D30                0x01
#define _RXB0D31                0x02
#define _RXB0D32                0x04
#define _RXB0D33                0x08
#define _RXB0D34                0x10
#define _RXB0D35                0x20
#define _RXB0D36                0x40
#define _RXB0D37                0x80

//==============================================================================


//==============================================================================
//        RXB0D4 Bits

extern __at(0x0F6A) __sfr RXB0D4;

typedef struct
  {
  unsigned RXB0D40              : 1;
  unsigned RXB0D41              : 1;
  unsigned RXB0D42              : 1;
  unsigned RXB0D43              : 1;
  unsigned RXB0D44              : 1;
  unsigned RXB0D45              : 1;
  unsigned RXB0D46              : 1;
  unsigned RXB0D47              : 1;
  } __RXB0D4bits_t;

extern __at(0x0F6A) volatile __RXB0D4bits_t RXB0D4bits;

#define _RXB0D40                0x01
#define _RXB0D41                0x02
#define _RXB0D42                0x04
#define _RXB0D43                0x08
#define _RXB0D44                0x10
#define _RXB0D45                0x20
#define _RXB0D46                0x40
#define _RXB0D47                0x80

//==============================================================================


//==============================================================================
//        RXB0D5 Bits

extern __at(0x0F6B) __sfr RXB0D5;

typedef struct
  {
  unsigned RXB0D50              : 1;
  unsigned RXB0D51              : 1;
  unsigned RXB0D52              : 1;
  unsigned RXB0D53              : 1;
  unsigned RXB0D54              : 1;
  unsigned RXB0D55              : 1;
  unsigned RXB0D56              : 1;
  unsigned RXB0D57              : 1;
  } __RXB0D5bits_t;

extern __at(0x0F6B) volatile __RXB0D5bits_t RXB0D5bits;

#define _RXB0D50                0x01
#define _RXB0D51                0x02
#define _RXB0D52                0x04
#define _RXB0D53                0x08
#define _RXB0D54                0x10
#define _RXB0D55                0x20
#define _RXB0D56                0x40
#define _RXB0D57                0x80

//==============================================================================


//==============================================================================
//        RXB0D6 Bits

extern __at(0x0F6C) __sfr RXB0D6;

typedef struct
  {
  unsigned RXB0D60              : 1;
  unsigned RXB0D61              : 1;
  unsigned RXB0D62              : 1;
  unsigned RXB0D63              : 1;
  unsigned RXB0D64              : 1;
  unsigned RXB0D65              : 1;
  unsigned RXB0D66              : 1;
  unsigned RXB0D67              : 1;
  } __RXB0D6bits_t;

extern __at(0x0F6C) volatile __RXB0D6bits_t RXB0D6bits;

#define _RXB0D60                0x01
#define _RXB0D61                0x02
#define _RXB0D62                0x04
#define _RXB0D63                0x08
#define _RXB0D64                0x10
#define _RXB0D65                0x20
#define _RXB0D66                0x40
#define _RXB0D67                0x80

//==============================================================================


//==============================================================================
//        RXB0D7 Bits

extern __at(0x0F6D) __sfr RXB0D7;

typedef struct
  {
  unsigned RXB0D70              : 1;
  unsigned RXB0D71              : 1;
  unsigned RXB0D72              : 1;
  unsigned RXB0D73              : 1;
  unsigned RXB0D74              : 1;
  unsigned RXB0D75              : 1;
  unsigned RXB0D76              : 1;
  unsigned RXB0D77              : 1;
  } __RXB0D7bits_t;

extern __at(0x0F6D) volatile __RXB0D7bits_t RXB0D7bits;

#define _RXB0D70                0x01
#define _RXB0D71                0x02
#define _RXB0D72                0x04
#define _RXB0D73                0x08
#define _RXB0D74                0x10
#define _RXB0D75                0x20
#define _RXB0D76                0x40
#define _RXB0D77                0x80

//==============================================================================


//==============================================================================
//        CANSTAT Bits

extern __at(0x0F6E) __sfr CANSTAT;

typedef union
  {
  struct
    {
    unsigned EICODE0            : 1;
    unsigned EICODE1_ICODE0     : 1;
    unsigned EICODE2_ICODE1     : 1;
    unsigned EICODE3_ICODE2     : 1;
    unsigned EICODE4            : 1;
    unsigned OPMODE0            : 1;
    unsigned OPMODE1            : 1;
    unsigned OPMODE2            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned EICODE1            : 1;
    unsigned EICODE2            : 1;
    unsigned EICODE3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ICODE0             : 1;
    unsigned ICODE1             : 1;
    unsigned ICODE2             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned EICODE             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ICODE              : 3;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 5;
    unsigned OPMODE             : 3;
    };
  } __CANSTATbits_t;

extern __at(0x0F6E) volatile __CANSTATbits_t CANSTATbits;

#define _EICODE0                0x01
#define _EICODE1_ICODE0         0x02
#define _EICODE1                0x02
#define _ICODE0                 0x02
#define _EICODE2_ICODE1         0x04
#define _EICODE2                0x04
#define _ICODE1                 0x04
#define _EICODE3_ICODE2         0x08
#define _EICODE3                0x08
#define _ICODE2                 0x08
#define _EICODE4                0x10
#define _OPMODE0                0x20
#define _OPMODE1                0x40
#define _OPMODE2                0x80

//==============================================================================


//==============================================================================
//        CANCON Bits

extern __at(0x0F6F) __sfr CANCON;

typedef union
  {
  struct
    {
    unsigned FP0                : 1;
    unsigned WIN0_FP1           : 1;
    unsigned WIN1_FP2           : 1;
    unsigned WIN2_FP3           : 1;
    unsigned ABAT               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WIN0               : 1;
    unsigned WIN1               : 1;
    unsigned WIN2               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned FP1                : 1;
    unsigned FP2                : 1;
    unsigned FP3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned FP                 : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WIN                : 3;
    unsigned                    : 4;
    };
  } __CANCONbits_t;

extern __at(0x0F6F) volatile __CANCONbits_t CANCONbits;

#define _FP0                    0x01
#define _WIN0_FP1               0x02
#define _WIN0                   0x02
#define _FP1                    0x02
#define _WIN1_FP2               0x04
#define _WIN1                   0x04
#define _FP2                    0x04
#define _WIN2_FP3               0x08
#define _WIN2                   0x08
#define _FP3                    0x08
#define _ABAT                   0x10

//==============================================================================


//==============================================================================
//        CIOCON Bits

extern __at(0x0F70) __sfr CIOCON;

typedef struct
  {
  unsigned CLKSEL               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned CANCAP               : 1;
  unsigned ENDRHI               : 1;
  unsigned TX2EN                : 1;
  unsigned TX2SRC               : 1;
  } __CIOCONbits_t;

extern __at(0x0F70) volatile __CIOCONbits_t CIOCONbits;

#define _CLKSEL                 0x01
#define _CANCAP                 0x10
#define _ENDRHI                 0x20
#define _TX2EN                  0x40
#define _TX2SRC                 0x80

//==============================================================================


//==============================================================================
//        COMSTAT Bits

extern __at(0x0F71) __sfr COMSTAT;

typedef union
  {
  struct
    {
    unsigned EWARN              : 1;
    unsigned RXWARN             : 1;
    unsigned TXWARN             : 1;
    unsigned RXBP               : 1;
    unsigned TXBP               : 1;
    unsigned TXBO               : 1;
    unsigned RXB1OVFL           : 1;
    unsigned RXB0OVFL           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_FIFOEMPTY      : 1;
    };
  } __COMSTATbits_t;

extern __at(0x0F71) volatile __COMSTATbits_t COMSTATbits;

#define _EWARN                  0x01
#define _RXWARN                 0x02
#define _TXWARN                 0x04
#define _RXBP                   0x08
#define _TXBP                   0x10
#define _TXBO                   0x20
#define _RXB1OVFL               0x40
#define _RXB0OVFL               0x80
#define _NOT_FIFOEMPTY          0x80

//==============================================================================


//==============================================================================
//        ECANCON Bits

extern __at(0x0F72) __sfr ECANCON;

typedef union
  {
  struct
    {
    unsigned EWIN0              : 1;
    unsigned EWIN1              : 1;
    unsigned EWIN2              : 1;
    unsigned EWIN3              : 1;
    unsigned EWIN4              : 1;
    unsigned FIFOWM             : 1;
    unsigned MDSEL0             : 1;
    unsigned MDSEL1             : 1;
    };

  struct
    {
    unsigned EWIN               : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned                    : 6;
    unsigned MDSEL              : 2;
    };
  } __ECANCONbits_t;

extern __at(0x0F72) volatile __ECANCONbits_t ECANCONbits;

#define _EWIN0                  0x01
#define _EWIN1                  0x02
#define _EWIN2                  0x04
#define _EWIN3                  0x08
#define _EWIN4                  0x10
#define _FIFOWM                 0x20
#define _MDSEL0                 0x40
#define _MDSEL1                 0x80

//==============================================================================

extern __at(0x0F73) __sfr EEDATA;
extern __at(0x0F74) __sfr EEADR;
extern __at(0x0F75) __sfr EEADRH;

//==============================================================================
//        PIE5 Bits

extern __at(0x0F76) __sfr PIE5;

typedef union
  {
  struct
    {
    unsigned RXB0IE             : 1;
    unsigned RXB1IE             : 1;
    unsigned TXB0IE             : 1;
    unsigned TXB1IE             : 1;
    unsigned TXB2IE             : 1;
    unsigned ERRIE              : 1;
    unsigned WAKIE              : 1;
    unsigned IRXIE              : 1;
    };

  struct
    {
    unsigned FIFOWMIE           : 1;
    unsigned RXBnIE             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TXBnIE             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIE5bits_t;

extern __at(0x0F76) volatile __PIE5bits_t PIE5bits;

#define _PIE5_RXB0IE            0x01
#define _PIE5_FIFOWMIE          0x01
#define _PIE5_RXB1IE            0x02
#define _PIE5_RXBnIE            0x02
#define _PIE5_TXB0IE            0x04
#define _PIE5_TXB1IE            0x08
#define _PIE5_TXB2IE            0x10
#define _PIE5_TXBnIE            0x10
#define _PIE5_ERRIE             0x20
#define _PIE5_WAKIE             0x40
#define _PIE5_IRXIE             0x80

//==============================================================================


//==============================================================================
//        PIR5 Bits

extern __at(0x0F77) __sfr PIR5;

typedef union
  {
  struct
    {
    unsigned RXB0IF             : 1;
    unsigned RXB1IF             : 1;
    unsigned TXB0IF             : 1;
    unsigned TXB1IF             : 1;
    unsigned TXB2IF             : 1;
    unsigned ERRIF              : 1;
    unsigned WAKIF              : 1;
    unsigned IRXIF              : 1;
    };

  struct
    {
    unsigned FIFOWMIF           : 1;
    unsigned RXBnIF             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TXBnIF             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIR5bits_t;

extern __at(0x0F77) volatile __PIR5bits_t PIR5bits;

#define _RXB0IF                 0x01
#define _FIFOWMIF               0x01
#define _RXB1IF                 0x02
#define _RXBnIF                 0x02
#define _TXB0IF                 0x04
#define _TXB1IF                 0x08
#define _TXB2IF                 0x10
#define _TXBnIF                 0x10
#define _ERRIF                  0x20
#define _WAKIF                  0x40
#define _IRXIF                  0x80

//==============================================================================


//==============================================================================
//        IPR5 Bits

extern __at(0x0F78) __sfr IPR5;

typedef union
  {
  struct
    {
    unsigned RXB0IP             : 1;
    unsigned RXB1IP             : 1;
    unsigned TXB0IP             : 1;
    unsigned TXB1IP             : 1;
    unsigned TXB2IP             : 1;
    unsigned ERRIP              : 1;
    unsigned WAKIP              : 1;
    unsigned IRXIP              : 1;
    };

  struct
    {
    unsigned FIFOWMIP           : 1;
    unsigned RXBnIP             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TXBnIP             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __IPR5bits_t;

extern __at(0x0F78) volatile __IPR5bits_t IPR5bits;

#define _RXB0IP                 0x01
#define _FIFOWMIP               0x01
#define _RXB1IP                 0x02
#define _RXBnIP                 0x02
#define _TXB0IP                 0x04
#define _TXB1IP                 0x08
#define _TXB2IP                 0x10
#define _TXBnIP                 0x10
#define _ERRIP                  0x20
#define _WAKIP                  0x40
#define _IRXIP                  0x80

//==============================================================================

extern __at(0x0F79) __sfr TXREG2;
extern __at(0x0F7A) __sfr RCREG2;
extern __at(0x0F7B) __sfr SPBRG2;
extern __at(0x0F7C) __sfr SPBRGH2;
extern __at(0x0F7D) __sfr SPBRGH1;
extern __at(0x0F7E) __sfr EECON2;

//==============================================================================
//        EECON1 Bits

extern __at(0x0F7F) __sfr EECON1;

typedef struct
  {
  unsigned RD                   : 1;
  unsigned WR                   : 1;
  unsigned WREN                 : 1;
  unsigned WRERR                : 1;
  unsigned FREE                 : 1;
  unsigned                      : 1;
  unsigned CFGS                 : 1;
  unsigned EEPGD                : 1;
  } __EECON1bits_t;

extern __at(0x0F7F) volatile __EECON1bits_t EECON1bits;

#define _RD                     0x01
#define _WR                     0x02
#define _WREN                   0x04
#define _WRERR                  0x08
#define _FREE                   0x10
#define _CFGS                   0x40
#define _EEPGD                  0x80

//==============================================================================


//==============================================================================
//        PORTA Bits

extern __at(0x0F80) __sfr PORTA;

typedef struct
  {
  unsigned RA0                  : 1;
  unsigned RA1                  : 1;
  unsigned RA2                  : 1;
  unsigned RA3                  : 1;
  unsigned                      : 1;
  unsigned RA5                  : 1;
  unsigned RA6                  : 1;
  unsigned RA7                  : 1;
  } __PORTAbits_t;

extern __at(0x0F80) volatile __PORTAbits_t PORTAbits;

#define _RA0                    0x01
#define _RA1                    0x02
#define _RA2                    0x04
#define _RA3                    0x08
#define _RA5                    0x20
#define _RA6                    0x40
#define _RA7                    0x80

//==============================================================================


//==============================================================================
//        PORTB Bits

extern __at(0x0F81) __sfr PORTB;

typedef struct
  {
  unsigned RB0                  : 1;
  unsigned RB1                  : 1;
  unsigned RB2                  : 1;
  unsigned RB3                  : 1;
  unsigned RB4                  : 1;
  unsigned RB5                  : 1;
  unsigned RB6                  : 1;
  unsigned RB7                  : 1;
  } __PORTBbits_t;

extern __at(0x0F81) volatile __PORTBbits_t PORTBbits;

#define _PORTB_RB0              0x01
#define _PORTB_RB1              0x02
#define _PORTB_RB2              0x04
#define _PORTB_RB3              0x08
#define _PORTB_RB4              0x10
#define _PORTB_RB5              0x20
#define _PORTB_RB6              0x40
#define _PORTB_RB7              0x80

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x0F82) __sfr PORTC;

typedef struct
  {
  unsigned RC0                  : 1;
  unsigned RC1                  : 1;
  unsigned RC2                  : 1;
  unsigned RC3                  : 1;
  unsigned RC4                  : 1;
  unsigned RC5                  : 1;
  unsigned RC6                  : 1;
  unsigned RC7                  : 1;
  } __PORTCbits_t;

extern __at(0x0F82) volatile __PORTCbits_t PORTCbits;

#define _RC0                    0x01
#define _RC1                    0x02
#define _RC2                    0x04
#define _RC3                    0x08
#define _RC4                    0x10
#define _RC5                    0x20
#define _RC6                    0x40
#define _RC7                    0x80

//==============================================================================


//==============================================================================
//        PORTD Bits

extern __at(0x0F83) __sfr PORTD;

typedef struct
  {
  unsigned RD0                  : 1;
  unsigned RD1                  : 1;
  unsigned RD2                  : 1;
  unsigned RD3                  : 1;
  unsigned RD4                  : 1;
  unsigned RD5                  : 1;
  unsigned RD6                  : 1;
  unsigned RD7                  : 1;
  } __PORTDbits_t;

extern __at(0x0F83) volatile __PORTDbits_t PORTDbits;

#define _RD0                    0x01
#define _RD1                    0x02
#define _RD2                    0x04
#define _RD3                    0x08
#define _RD4                    0x10
#define _RD5                    0x20
#define _RD6                    0x40
#define _RD7                    0x80

//==============================================================================


//==============================================================================
//        PORTE Bits

extern __at(0x0F84) __sfr PORTE;

typedef struct
  {
  unsigned RE0                  : 1;
  unsigned RE1                  : 1;
  unsigned RE2                  : 1;
  unsigned RE3                  : 1;
  unsigned RE4                  : 1;
  unsigned RE5                  : 1;
  unsigned RE6                  : 1;
  unsigned RE7                  : 1;
  } __PORTEbits_t;

extern __at(0x0F84) volatile __PORTEbits_t PORTEbits;

#define _RE0                    0x01
#define _RE1                    0x02
#define _RE2                    0x04
#define _RE3                    0x08
#define _RE4                    0x10
#define _RE5                    0x20
#define _RE6                    0x40
#define _RE7                    0x80

//==============================================================================


//==============================================================================
//        PORTF Bits

extern __at(0x0F85) __sfr PORTF;

typedef struct
  {
  unsigned RF0                  : 1;
  unsigned RF1                  : 1;
  unsigned RF2                  : 1;
  unsigned RF3                  : 1;
  unsigned RF4                  : 1;
  unsigned RF5                  : 1;
  unsigned RF6                  : 1;
  unsigned RF7                  : 1;
  } __PORTFbits_t;

extern __at(0x0F85) volatile __PORTFbits_t PORTFbits;

#define _RF0                    0x01
#define _RF1                    0x02
#define _RF2                    0x04
#define _RF3                    0x08
#define _RF4                    0x10
#define _RF5                    0x20
#define _RF6                    0x40
#define _RF7                    0x80

//==============================================================================


//==============================================================================
//        PORTG Bits

extern __at(0x0F86) __sfr PORTG;

typedef union
  {
  struct
    {
    unsigned RG0                : 1;
    unsigned RG1                : 1;
    unsigned RG2                : 1;
    unsigned RG3                : 1;
    unsigned RG4                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG                 : 5;
    unsigned                    : 3;
    };
  } __PORTGbits_t;

extern __at(0x0F86) volatile __PORTGbits_t PORTGbits;

#define _RG0                    0x01
#define _RG1                    0x02
#define _RG2                    0x04
#define _RG3                    0x08
#define _RG4                    0x10

//==============================================================================

extern __at(0x0F87) __sfr TMR4;

//==============================================================================
//        T4CON Bits

extern __at(0x0F88) __sfr T4CON;

typedef union
  {
  struct
    {
    unsigned T4CKPS0            : 1;
    unsigned T4CKPS1            : 1;
    unsigned TMR4ON             : 1;
    unsigned T4OUTPS0           : 1;
    unsigned T4OUTPS1           : 1;
    unsigned T4OUTPS2           : 1;
    unsigned T4OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T4CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T4OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T4CONbits_t;

extern __at(0x0F88) volatile __T4CONbits_t T4CONbits;

#define _T4CKPS0                0x01
#define _T4CKPS1                0x02
#define _TMR4ON                 0x04
#define _T4OUTPS0               0x08
#define _T4OUTPS1               0x10
#define _T4OUTPS2               0x20
#define _T4OUTPS3               0x40

//==============================================================================


//==============================================================================
//        LATA Bits

extern __at(0x0F89) __sfr LATA;

typedef struct
  {
  unsigned LATA0                : 1;
  unsigned LATA1                : 1;
  unsigned LATA2                : 1;
  unsigned LATA3                : 1;
  unsigned                      : 1;
  unsigned LATA5                : 1;
  unsigned LATA6                : 1;
  unsigned LATA7                : 1;
  } __LATAbits_t;

extern __at(0x0F89) volatile __LATAbits_t LATAbits;

#define _LATA0                  0x01
#define _LATA1                  0x02
#define _LATA2                  0x04
#define _LATA3                  0x08
#define _LATA5                  0x20
#define _LATA6                  0x40
#define _LATA7                  0x80

//==============================================================================


//==============================================================================
//        LATB Bits

extern __at(0x0F8A) __sfr LATB;

typedef struct
  {
  unsigned LATB0                : 1;
  unsigned LATB1                : 1;
  unsigned LATB2                : 1;
  unsigned LATB3                : 1;
  unsigned LATB4                : 1;
  unsigned LATB5                : 1;
  unsigned LATB6                : 1;
  unsigned LATB7                : 1;
  } __LATBbits_t;

extern __at(0x0F8A) volatile __LATBbits_t LATBbits;

#define _LATB0                  0x01
#define _LATB1                  0x02
#define _LATB2                  0x04
#define _LATB3                  0x08
#define _LATB4                  0x10
#define _LATB5                  0x20
#define _LATB6                  0x40
#define _LATB7                  0x80

//==============================================================================


//==============================================================================
//        LATC Bits

extern __at(0x0F8B) __sfr LATC;

typedef struct
  {
  unsigned LATC0                : 1;
  unsigned LATC1                : 1;
  unsigned LATC2                : 1;
  unsigned LATC3                : 1;
  unsigned LATC4                : 1;
  unsigned LATC5                : 1;
  unsigned LATC6                : 1;
  unsigned LATC7                : 1;
  } __LATCbits_t;

extern __at(0x0F8B) volatile __LATCbits_t LATCbits;

#define _LATC0                  0x01
#define _LATC1                  0x02
#define _LATC2                  0x04
#define _LATC3                  0x08
#define _LATC4                  0x10
#define _LATC5                  0x20
#define _LATC6                  0x40
#define _LATC7                  0x80

//==============================================================================


//==============================================================================
//        LATD Bits

extern __at(0x0F8C) __sfr LATD;

typedef struct
  {
  unsigned LATD0                : 1;
  unsigned LATD1                : 1;
  unsigned LATD2                : 1;
  unsigned LATD3                : 1;
  unsigned LATD4                : 1;
  unsigned LATD5                : 1;
  unsigned LATD6                : 1;
  unsigned LATD7                : 1;
  } __LATDbits_t;

extern __at(0x0F8C) volatile __LATDbits_t LATDbits;

#define _LATD0                  0x01
#define _LATD1                  0x02
#define _LATD2                  0x04
#define _LATD3                  0x08
#define _LATD4                  0x10
#define _LATD5                  0x20
#define _LATD6                  0x40
#define _LATD7                  0x80

//==============================================================================


//==============================================================================
//        LATE Bits

extern __at(0x0F8D) __sfr LATE;

typedef struct
  {
  unsigned LATE0                : 1;
  unsigned LATE1                : 1;
  unsigned LATE2                : 1;
  unsigned                      : 1;
  unsigned LATE4                : 1;
  unsigned LATE5                : 1;
  unsigned LATE6                : 1;
  unsigned LATE7                : 1;
  } __LATEbits_t;

extern __at(0x0F8D) volatile __LATEbits_t LATEbits;

#define _LATE0                  0x01
#define _LATE1                  0x02
#define _LATE2                  0x04
#define _LATE4                  0x10
#define _LATE5                  0x20
#define _LATE6                  0x40
#define _LATE7                  0x80

//==============================================================================


//==============================================================================
//        LATF Bits

extern __at(0x0F8E) __sfr LATF;

typedef struct
  {
  unsigned LATF0                : 1;
  unsigned LATF1                : 1;
  unsigned LATF2                : 1;
  unsigned LATF3                : 1;
  unsigned LATF4                : 1;
  unsigned LATF5                : 1;
  unsigned LATF6                : 1;
  unsigned LATF7                : 1;
  } __LATFbits_t;

extern __at(0x0F8E) volatile __LATFbits_t LATFbits;

#define _LATF0                  0x01
#define _LATF1                  0x02
#define _LATF2                  0x04
#define _LATF3                  0x08
#define _LATF4                  0x10
#define _LATF5                  0x20
#define _LATF6                  0x40
#define _LATF7                  0x80

//==============================================================================


//==============================================================================
//        LATG Bits

extern __at(0x0F8F) __sfr LATG;

typedef union
  {
  struct
    {
    unsigned LATG0              : 1;
    unsigned LATG1              : 1;
    unsigned LATG2              : 1;
    unsigned LATG3              : 1;
    unsigned LATG4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LATG               : 5;
    unsigned                    : 3;
    };
  } __LATGbits_t;

extern __at(0x0F8F) volatile __LATGbits_t LATGbits;

#define _LATG0                  0x01
#define _LATG1                  0x02
#define _LATG2                  0x04
#define _LATG3                  0x08
#define _LATG4                  0x10

//==============================================================================


//==============================================================================
//        SLRCON Bits

extern __at(0x0F90) __sfr SLRCON;

typedef struct
  {
  unsigned SLRA                 : 1;
  unsigned SLRB                 : 1;
  unsigned SLRC                 : 1;
  unsigned SLRD                 : 1;
  unsigned SLRE                 : 1;
  unsigned SLRF                 : 1;
  unsigned SLRG                 : 1;
  unsigned                      : 1;
  } __SLRCONbits_t;

extern __at(0x0F90) volatile __SLRCONbits_t SLRCONbits;

#define _SLRA                   0x01
#define _SLRB                   0x02
#define _SLRC                   0x04
#define _SLRD                   0x08
#define _SLRE                   0x10
#define _SLRF                   0x20
#define _SLRG                   0x40

//==============================================================================


//==============================================================================
//        ODCON Bits

extern __at(0x0F91) __sfr ODCON;

typedef struct
  {
  unsigned U1OD                 : 1;
  unsigned U2OD                 : 1;
  unsigned CCP1OD               : 1;
  unsigned CCP2OD               : 1;
  unsigned CCP3OD               : 1;
  unsigned CCP4OD               : 1;
  unsigned CCP5OD               : 1;
  unsigned SSPOD                : 1;
  } __ODCONbits_t;

extern __at(0x0F91) volatile __ODCONbits_t ODCONbits;

#define _U1OD                   0x01
#define _U2OD                   0x02
#define _CCP1OD                 0x04
#define _CCP2OD                 0x08
#define _CCP3OD                 0x10
#define _CCP4OD                 0x20
#define _CCP5OD                 0x40
#define _SSPOD                  0x80

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x0F92) __sfr TRISA;

typedef struct
  {
  unsigned TRISA0               : 1;
  unsigned TRISA1               : 1;
  unsigned TRISA2               : 1;
  unsigned TRISA3               : 1;
  unsigned                      : 1;
  unsigned TRISA5               : 1;
  unsigned TRISA6               : 1;
  unsigned TRISA7               : 1;
  } __TRISAbits_t;

extern __at(0x0F92) volatile __TRISAbits_t TRISAbits;

#define _TRISA0                 0x01
#define _TRISA1                 0x02
#define _TRISA2                 0x04
#define _TRISA3                 0x08
#define _TRISA5                 0x20
#define _TRISA6                 0x40
#define _TRISA7                 0x80

//==============================================================================


//==============================================================================
//        TRISB Bits

extern __at(0x0F93) __sfr TRISB;

typedef struct
  {
  unsigned TRISB0               : 1;
  unsigned TRISB1               : 1;
  unsigned TRISB2               : 1;
  unsigned TRISB3               : 1;
  unsigned TRISB4               : 1;
  unsigned TRISB5               : 1;
  unsigned TRISB6               : 1;
  unsigned TRISB7               : 1;
  } __TRISBbits_t;

extern __at(0x0F93) volatile __TRISBbits_t TRISBbits;

#define _TRISB0                 0x01
#define _TRISB1                 0x02
#define _TRISB2                 0x04
#define _TRISB3                 0x08
#define _TRISB4                 0x10
#define _TRISB5                 0x20
#define _TRISB6                 0x40
#define _TRISB7                 0x80

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x0F94) __sfr TRISC;

typedef struct
  {
  unsigned TRISC0               : 1;
  unsigned TRISC1               : 1;
  unsigned TRISC2               : 1;
  unsigned TRISC3               : 1;
  unsigned TRISC4               : 1;
  unsigned TRISC5               : 1;
  unsigned TRISC6               : 1;
  unsigned TRISC7               : 1;
  } __TRISCbits_t;

extern __at(0x0F94) volatile __TRISCbits_t TRISCbits;

#define _TRISC0                 0x01
#define _TRISC1                 0x02
#define _TRISC2                 0x04
#define _TRISC3                 0x08
#define _TRISC4                 0x10
#define _TRISC5                 0x20
#define _TRISC6                 0x40
#define _TRISC7                 0x80

//==============================================================================


//==============================================================================
//        TRISD Bits

extern __at(0x0F95) __sfr TRISD;

typedef struct
  {
  unsigned TRISD0               : 1;
  unsigned TRISD1               : 1;
  unsigned TRISD2               : 1;
  unsigned TRISD3               : 1;
  unsigned TRISD4               : 1;
  unsigned TRISD5               : 1;
  unsigned TRISD6               : 1;
  unsigned TRISD7               : 1;
  } __TRISDbits_t;

extern __at(0x0F95) volatile __TRISDbits_t TRISDbits;

#define _TRISD0                 0x01
#define _TRISD1                 0x02
#define _TRISD2                 0x04
#define _TRISD3                 0x08
#define _TRISD4                 0x10
#define _TRISD5                 0x20
#define _TRISD6                 0x40
#define _TRISD7                 0x80

//==============================================================================


//==============================================================================
//        TRISE Bits

extern __at(0x0F96) __sfr TRISE;

typedef struct
  {
  unsigned TRISE0               : 1;
  unsigned TRISE1               : 1;
  unsigned TRISE2               : 1;
  unsigned                      : 1;
  unsigned TRISE4               : 1;
  unsigned TRISE5               : 1;
  unsigned TRISE6               : 1;
  unsigned TRISE7               : 1;
  } __TRISEbits_t;

extern __at(0x0F96) volatile __TRISEbits_t TRISEbits;

#define _TRISE0                 0x01
#define _TRISE1                 0x02
#define _TRISE2                 0x04
#define _TRISE4                 0x10
#define _TRISE5                 0x20
#define _TRISE6                 0x40
#define _TRISE7                 0x80

//==============================================================================


//==============================================================================
//        TRISF Bits

extern __at(0x0F97) __sfr TRISF;

typedef struct
  {
  unsigned TRISF0               : 1;
  unsigned TRISF1               : 1;
  unsigned TRISF2               : 1;
  unsigned TRISF3               : 1;
  unsigned TRISF4               : 1;
  unsigned TRISF5               : 1;
  unsigned TRISF6               : 1;
  unsigned TRISF7               : 1;
  } __TRISFbits_t;

extern __at(0x0F97) volatile __TRISFbits_t TRISFbits;

#define _TRISF0                 0x01
#define _TRISF1                 0x02
#define _TRISF2                 0x04
#define _TRISF3                 0x08
#define _TRISF4                 0x10
#define _TRISF5                 0x20
#define _TRISF6                 0x40
#define _TRISF7                 0x80

//==============================================================================


//==============================================================================
//        TRISG Bits

extern __at(0x0F98) __sfr TRISG;

typedef union
  {
  struct
    {
    unsigned TRISG0             : 1;
    unsigned TRISG1             : 1;
    unsigned TRISG2             : 1;
    unsigned TRISG3             : 1;
    unsigned TRISG4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISG              : 5;
    unsigned                    : 3;
    };
  } __TRISGbits_t;

extern __at(0x0F98) volatile __TRISGbits_t TRISGbits;

#define _TRISG0                 0x01
#define _TRISG1                 0x02
#define _TRISG2                 0x04
#define _TRISG3                 0x08
#define _TRISG4                 0x10

//==============================================================================


//==============================================================================
//        CCPTMRS Bits

extern __at(0x0F99) __sfr CCPTMRS;

typedef struct
  {
  unsigned C1TSEL               : 1;
  unsigned C2TSEL               : 1;
  unsigned C3TSEL               : 1;
  unsigned C4TSEL               : 1;
  unsigned C5TSEL               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __CCPTMRSbits_t;

extern __at(0x0F99) volatile __CCPTMRSbits_t CCPTMRSbits;

#define _C1TSEL                 0x01
#define _C2TSEL                 0x02
#define _C3TSEL                 0x04
#define _C4TSEL                 0x08
#define _C5TSEL                 0x10

//==============================================================================


//==============================================================================
//        REFOCON Bits

extern __at(0x0F9A) __sfr REFOCON;

typedef union
  {
  struct
    {
    unsigned RODIV0             : 1;
    unsigned RODIV1             : 1;
    unsigned RODIV2             : 1;
    unsigned RODIV3             : 1;
    unsigned ROSEL              : 1;
    unsigned ROSSLP             : 1;
    unsigned                    : 1;
    unsigned ROON               : 1;
    };

  struct
    {
    unsigned RODIV              : 4;
    unsigned                    : 4;
    };
  } __REFOCONbits_t;

extern __at(0x0F9A) volatile __REFOCONbits_t REFOCONbits;

#define _RODIV0                 0x01
#define _RODIV1                 0x02
#define _RODIV2                 0x04
#define _RODIV3                 0x08
#define _ROSEL                  0x10
#define _ROSSLP                 0x20
#define _ROON                   0x80

//==============================================================================


//==============================================================================
//        OSCTUNE Bits

extern __at(0x0F9B) __sfr OSCTUNE;

typedef union
  {
  struct
    {
    unsigned TUN0               : 1;
    unsigned TUN1               : 1;
    unsigned TUN2               : 1;
    unsigned TUN3               : 1;
    unsigned TUN4               : 1;
    unsigned TUN5               : 1;
    unsigned PLLEN              : 1;
    unsigned INTSRC             : 1;
    };

  struct
    {
    unsigned TUN                : 6;
    unsigned                    : 2;
    };
  } __OSCTUNEbits_t;

extern __at(0x0F9B) volatile __OSCTUNEbits_t OSCTUNEbits;

#define _TUN0                   0x01
#define _TUN1                   0x02
#define _TUN2                   0x04
#define _TUN3                   0x08
#define _TUN4                   0x10
#define _TUN5                   0x20
#define _PLLEN                  0x40
#define _INTSRC                 0x80

//==============================================================================


//==============================================================================
//        PSTR1CON Bits

extern __at(0x0F9C) __sfr PSTR1CON;

typedef union
  {
  struct
    {
    unsigned STRA               : 1;
    unsigned STRB               : 1;
    unsigned STRC               : 1;
    unsigned STRD               : 1;
    unsigned STRSYNC            : 1;
    unsigned                    : 1;
    unsigned CMPL0              : 1;
    unsigned CMPL1              : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned CMPL               : 2;
    };
  } __PSTR1CONbits_t;

extern __at(0x0F9C) volatile __PSTR1CONbits_t PSTR1CONbits;

#define _STRA                   0x01
#define _STRB                   0x02
#define _STRC                   0x04
#define _STRD                   0x08
#define _STRSYNC                0x10
#define _CMPL0                  0x40
#define _CMPL1                  0x80

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x0F9D) __sfr PIE1;

typedef union
  {
  struct
    {
    unsigned TMR1IE             : 1;
    unsigned TMR2IE             : 1;
    unsigned TMR1GIE            : 1;
    unsigned SSPIE              : 1;
    unsigned TX1IE              : 1;
    unsigned RC1IE              : 1;
    unsigned ADIE               : 1;
    unsigned PSPIE              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TXIE               : 1;
    unsigned RCIE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIE1bits_t;

extern __at(0x0F9D) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _TMR1GIE                0x04
#define _SSPIE                  0x08
#define _TX1IE                  0x10
#define _TXIE                   0x10
#define _RC1IE                  0x20
#define _RCIE                   0x20
#define _ADIE                   0x40
#define _PSPIE                  0x80

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x0F9E) __sfr PIR1;

typedef union
  {
  struct
    {
    unsigned TMR1IF             : 1;
    unsigned TMR2IF             : 1;
    unsigned TMR1GIF            : 1;
    unsigned SSPIF              : 1;
    unsigned TX1IF              : 1;
    unsigned RC1IF              : 1;
    unsigned ADIF               : 1;
    unsigned PSPIF              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TXIF               : 1;
    unsigned RCIF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIR1bits_t;

extern __at(0x0F9E) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _TMR1GIF                0x04
#define _SSPIF                  0x08
#define _TX1IF                  0x10
#define _TXIF                   0x10
#define _RC1IF                  0x20
#define _RCIF                   0x20
#define _ADIF                   0x40
#define _PSPIF                  0x80

//==============================================================================


//==============================================================================
//        IPR1 Bits

extern __at(0x0F9F) __sfr IPR1;

typedef union
  {
  struct
    {
    unsigned TMR1IP             : 1;
    unsigned TMR2IP             : 1;
    unsigned TMR1GIP            : 1;
    unsigned SSPIP              : 1;
    unsigned TX1IP              : 1;
    unsigned RC1IP              : 1;
    unsigned ADIP               : 1;
    unsigned PSPIP              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TXIP               : 1;
    unsigned RCIP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __IPR1bits_t;

extern __at(0x0F9F) volatile __IPR1bits_t IPR1bits;

#define _TMR1IP                 0x01
#define _TMR2IP                 0x02
#define _TMR1GIP                0x04
#define _SSPIP                  0x08
#define _TX1IP                  0x10
#define _TXIP                   0x10
#define _RC1IP                  0x20
#define _RCIP                   0x20
#define _ADIP                   0x40
#define _PSPIP                  0x80

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x0FA0) __sfr PIE2;

typedef union
  {
  struct
    {
    unsigned TMR3GIE            : 1;
    unsigned TMR3IE             : 1;
    unsigned HLVDIE             : 1;
    unsigned BCLIE              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned OSCFIE             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LVDIE              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIE2bits_t;

extern __at(0x0FA0) volatile __PIE2bits_t PIE2bits;

#define _TMR3GIE                0x01
#define _TMR3IE                 0x02
#define _HLVDIE                 0x04
#define _LVDIE                  0x04
#define _BCLIE                  0x08
#define _OSCFIE                 0x80

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x0FA1) __sfr PIR2;

typedef union
  {
  struct
    {
    unsigned TMR3GIF            : 1;
    unsigned TMR3IF             : 1;
    unsigned HLVDIF             : 1;
    unsigned BCLIF              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned OSCFIF             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LVDIF              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIR2bits_t;

extern __at(0x0FA1) volatile __PIR2bits_t PIR2bits;

#define _TMR3GIF                0x01
#define _TMR3IF                 0x02
#define _HLVDIF                 0x04
#define _LVDIF                  0x04
#define _BCLIF                  0x08
#define _OSCFIF                 0x80

//==============================================================================


//==============================================================================
//        IPR2 Bits

extern __at(0x0FA2) __sfr IPR2;

typedef union
  {
  struct
    {
    unsigned TMR3GIP            : 1;
    unsigned TMR3IP             : 1;
    unsigned HLVDIP             : 1;
    unsigned BCLIP              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned OSCFIP             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LVDIP              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __IPR2bits_t;

extern __at(0x0FA2) volatile __IPR2bits_t IPR2bits;

#define _TMR3GIP                0x01
#define _TMR3IP                 0x02
#define _HLVDIP                 0x04
#define _LVDIP                  0x04
#define _BCLIP                  0x08
#define _OSCFIP                 0x80

//==============================================================================


//==============================================================================
//        PIE3 Bits

extern __at(0x0FA3) __sfr PIE3;

typedef struct
  {
  unsigned                      : 1;
  unsigned CCP1IE               : 1;
  unsigned CCP2IE               : 1;
  unsigned CTMUIE               : 1;
  unsigned TX2IE                : 1;
  unsigned RC2IE                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIE3bits_t;

extern __at(0x0FA3) volatile __PIE3bits_t PIE3bits;

#define _CCP1IE                 0x02
#define _CCP2IE                 0x04
#define _CTMUIE                 0x08
#define _TX2IE                  0x10
#define _RC2IE                  0x20

//==============================================================================


//==============================================================================
//        PIR3 Bits

extern __at(0x0FA4) __sfr PIR3;

typedef struct
  {
  unsigned                      : 1;
  unsigned CCP1IF               : 1;
  unsigned CCP2IF               : 1;
  unsigned CTMUIF               : 1;
  unsigned TX2IF                : 1;
  unsigned RC2IF                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIR3bits_t;

extern __at(0x0FA4) volatile __PIR3bits_t PIR3bits;

#define _CCP1IF                 0x02
#define _CCP2IF                 0x04
#define _CTMUIF                 0x08
#define _TX2IF                  0x10
#define _RC2IF                  0x20

//==============================================================================


//==============================================================================
//        IPR3 Bits

extern __at(0x0FA5) __sfr IPR3;

typedef struct
  {
  unsigned                      : 1;
  unsigned CCP1IP               : 1;
  unsigned CCP2IP               : 1;
  unsigned CTMUIP               : 1;
  unsigned TX2IP                : 1;
  unsigned RC2IP                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __IPR3bits_t;

extern __at(0x0FA5) volatile __IPR3bits_t IPR3bits;

#define _CCP1IP                 0x02
#define _CCP2IP                 0x04
#define _CTMUIP                 0x08
#define _TX2IP                  0x10
#define _RC2IP                  0x20

//==============================================================================


//==============================================================================
//        RCSTA2 Bits

extern __at(0x0FA6) __sfr RCSTA2;

typedef union
  {
  struct
    {
    unsigned RX9D               : 1;
    unsigned OERR               : 1;
    unsigned FERR               : 1;
    unsigned ADDEN              : 1;
    unsigned CREN               : 1;
    unsigned SREN               : 1;
    unsigned RX9                : 1;
    unsigned SPEN               : 1;
    };

  struct
    {
    unsigned RX9D2              : 1;
    unsigned OERR2              : 1;
    unsigned FERR2              : 1;
    unsigned ADDEN2             : 1;
    unsigned CREN2              : 1;
    unsigned SREN2              : 1;
    unsigned RX92               : 1;
    unsigned SPEN2              : 1;
    };
  } __RCSTA2bits_t;

extern __at(0x0FA6) volatile __RCSTA2bits_t RCSTA2bits;

#define _RCSTA2_RX9D            0x01
#define _RCSTA2_RX9D2           0x01
#define _RCSTA2_OERR            0x02
#define _RCSTA2_OERR2           0x02
#define _RCSTA2_FERR            0x04
#define _RCSTA2_FERR2           0x04
#define _RCSTA2_ADDEN           0x08
#define _RCSTA2_ADDEN2          0x08
#define _RCSTA2_CREN            0x10
#define _RCSTA2_CREN2           0x10
#define _RCSTA2_SREN            0x20
#define _RCSTA2_SREN2           0x20
#define _RCSTA2_RX9             0x40
#define _RCSTA2_RX92            0x40
#define _RCSTA2_SPEN            0x80
#define _RCSTA2_SPEN2           0x80

//==============================================================================


//==============================================================================
//        BAUDCON1 Bits

extern __at(0x0FA7) __sfr BAUDCON1;

typedef union
  {
  struct
    {
    unsigned ABDEN              : 1;
    unsigned WUE                : 1;
    unsigned                    : 1;
    unsigned BRG16              : 1;
    unsigned TXCKP              : 1;
    unsigned RXDTP              : 1;
    unsigned RCIDL              : 1;
    unsigned ABDOVF             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RCMT               : 1;
    unsigned                    : 1;
    };
  } __BAUDCON1bits_t;

extern __at(0x0FA7) volatile __BAUDCON1bits_t BAUDCON1bits;

#define _ABDEN                  0x01
#define _WUE                    0x02
#define _BRG16                  0x08
#define _TXCKP                  0x10
#define _RXDTP                  0x20
#define _RCIDL                  0x40
#define _RCMT                   0x40
#define _ABDOVF                 0x80

//==============================================================================


//==============================================================================
//        HLVDCON Bits

extern __at(0x0FA8) __sfr HLVDCON;

typedef union
  {
  struct
    {
    unsigned HLVDL0             : 1;
    unsigned HLVDL1             : 1;
    unsigned HLVDL2             : 1;
    unsigned HLVDL3             : 1;
    unsigned HLVDEN             : 1;
    unsigned IRVST              : 1;
    unsigned BGVST              : 1;
    unsigned VDIRMAG            : 1;
    };

  struct
    {
    unsigned HLVDL              : 4;
    unsigned                    : 4;
    };
  } __HLVDCONbits_t;

extern __at(0x0FA8) volatile __HLVDCONbits_t HLVDCONbits;

#define _HLVDL0                 0x01
#define _HLVDL1                 0x02
#define _HLVDL2                 0x04
#define _HLVDL3                 0x08
#define _HLVDEN                 0x10
#define _IRVST                  0x20
#define _BGVST                  0x40
#define _VDIRMAG                0x80

//==============================================================================

extern __at(0x0FA9) __sfr PR4;

//==============================================================================
//        T1GCON Bits

extern __at(0x0FAA) __sfr T1GCON;

typedef union
  {
  struct
    {
    unsigned T1GSS0             : 1;
    unsigned T1GSS1             : 1;
    unsigned T1GVAL             : 1;
    unsigned T1GGO_NOT_T1DONE   : 1;
    unsigned T1GSPM             : 1;
    unsigned T1GTM              : 1;
    unsigned T1GPOL             : 1;
    unsigned TMR1GE             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1GGO              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_T1DONE         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T1GSS              : 2;
    unsigned                    : 6;
    };
  } __T1GCONbits_t;

extern __at(0x0FAA) volatile __T1GCONbits_t T1GCONbits;

#define _T1GSS0                 0x01
#define _T1GSS1                 0x02
#define _T1GVAL                 0x04
#define _T1GGO_NOT_T1DONE       0x08
#define _T1GGO                  0x08
#define _NOT_T1DONE             0x08
#define _T1GSPM                 0x10
#define _T1GTM                  0x20
#define _T1GPOL                 0x40
#define _TMR1GE                 0x80

//==============================================================================


//==============================================================================
//        RCSTA Bits

extern __at(0x0FAB) __sfr RCSTA;

typedef union
  {
  struct
    {
    unsigned RX9D               : 1;
    unsigned OERR               : 1;
    unsigned FERR               : 1;
    unsigned ADDEN              : 1;
    unsigned CREN               : 1;
    unsigned SREN               : 1;
    unsigned RX9                : 1;
    unsigned SPEN               : 1;
    };

  struct
    {
    unsigned RCD8               : 1;
    unsigned OERR1              : 1;
    unsigned FERR1              : 1;
    unsigned ADEN               : 1;
    unsigned CREN1              : 1;
    unsigned SREN1              : 1;
    unsigned RC9                : 1;
    unsigned SPEN1              : 1;
    };

  struct
    {
    unsigned RX9D1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADDEN1             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_RC8            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RC8_9              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RX91               : 1;
    unsigned                    : 1;
    };
  } __RCSTAbits_t;

extern __at(0x0FAB) volatile __RCSTAbits_t RCSTAbits;

#define _RX9D                   0x01
#define _RCD8                   0x01
#define _RX9D1                  0x01
#define _OERR                   0x02
#define _OERR1                  0x02
#define _FERR                   0x04
#define _FERR1                  0x04
#define _ADDEN                  0x08
#define _ADEN                   0x08
#define _ADDEN1                 0x08
#define _CREN                   0x10
#define _CREN1                  0x10
#define _SREN                   0x20
#define _SREN1                  0x20
#define _RX9                    0x40
#define _RC9                    0x40
#define _NOT_RC8                0x40
#define _RC8_9                  0x40
#define _RX91                   0x40
#define _SPEN                   0x80
#define _SPEN1                  0x80

//==============================================================================


//==============================================================================
//        RCSTA1 Bits

extern __at(0x0FAB) __sfr RCSTA1;

typedef union
  {
  struct
    {
    unsigned RX9D               : 1;
    unsigned OERR               : 1;
    unsigned FERR               : 1;
    unsigned ADDEN              : 1;
    unsigned CREN               : 1;
    unsigned SREN               : 1;
    unsigned RX9                : 1;
    unsigned SPEN               : 1;
    };

  struct
    {
    unsigned RCD8               : 1;
    unsigned OERR1              : 1;
    unsigned FERR1              : 1;
    unsigned ADEN               : 1;
    unsigned CREN1              : 1;
    unsigned SREN1              : 1;
    unsigned RC9                : 1;
    unsigned SPEN1              : 1;
    };

  struct
    {
    unsigned RX9D1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADDEN1             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_RC8            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RC8_9              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RX91               : 1;
    unsigned                    : 1;
    };
  } __RCSTA1bits_t;

extern __at(0x0FAB) volatile __RCSTA1bits_t RCSTA1bits;

#define _RCSTA1_RX9D            0x01
#define _RCSTA1_RCD8            0x01
#define _RCSTA1_RX9D1           0x01
#define _RCSTA1_OERR            0x02
#define _RCSTA1_OERR1           0x02
#define _RCSTA1_FERR            0x04
#define _RCSTA1_FERR1           0x04
#define _RCSTA1_ADDEN           0x08
#define _RCSTA1_ADEN            0x08
#define _RCSTA1_ADDEN1          0x08
#define _RCSTA1_CREN            0x10
#define _RCSTA1_CREN1           0x10
#define _RCSTA1_SREN            0x20
#define _RCSTA1_SREN1           0x20
#define _RCSTA1_RX9             0x40
#define _RCSTA1_RC9             0x40
#define _RCSTA1_NOT_RC8         0x40
#define _RCSTA1_RC8_9           0x40
#define _RCSTA1_RX91            0x40
#define _RCSTA1_SPEN            0x80
#define _RCSTA1_SPEN1           0x80

//==============================================================================


//==============================================================================
//        TXSTA Bits

extern __at(0x0FAC) __sfr TXSTA;

typedef union
  {
  struct
    {
    unsigned TX9D               : 1;
    unsigned TRMT               : 1;
    unsigned BRGH               : 1;
    unsigned SENDB              : 1;
    unsigned SYNC               : 1;
    unsigned TXEN               : 1;
    unsigned TX9                : 1;
    unsigned CSRC               : 1;
    };

  struct
    {
    unsigned TXD8               : 1;
    unsigned TRMT1              : 1;
    unsigned BRGH1              : 1;
    unsigned SENDB1             : 1;
    unsigned SYNC1              : 1;
    unsigned TXEN1              : 1;
    unsigned TX8_9              : 1;
    unsigned CSRC1              : 1;
    };

  struct
    {
    unsigned TX9D1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_TX8            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TX91               : 1;
    unsigned                    : 1;
    };
  } __TXSTAbits_t;

extern __at(0x0FAC) volatile __TXSTAbits_t TXSTAbits;

#define _TX9D                   0x01
#define _TXD8                   0x01
#define _TX9D1                  0x01
#define _TRMT                   0x02
#define _TRMT1                  0x02
#define _BRGH                   0x04
#define _BRGH1                  0x04
#define _SENDB                  0x08
#define _SENDB1                 0x08
#define _SYNC                   0x10
#define _SYNC1                  0x10
#define _TXEN                   0x20
#define _TXEN1                  0x20
#define _TX9                    0x40
#define _TX8_9                  0x40
#define _NOT_TX8                0x40
#define _TX91                   0x40
#define _CSRC                   0x80
#define _CSRC1                  0x80

//==============================================================================


//==============================================================================
//        TXSTA1 Bits

extern __at(0x0FAC) __sfr TXSTA1;

typedef union
  {
  struct
    {
    unsigned TX9D               : 1;
    unsigned TRMT               : 1;
    unsigned BRGH               : 1;
    unsigned SENDB              : 1;
    unsigned SYNC               : 1;
    unsigned TXEN               : 1;
    unsigned TX9                : 1;
    unsigned CSRC               : 1;
    };

  struct
    {
    unsigned TXD8               : 1;
    unsigned TRMT1              : 1;
    unsigned BRGH1              : 1;
    unsigned SENDB1             : 1;
    unsigned SYNC1              : 1;
    unsigned TXEN1              : 1;
    unsigned TX8_9              : 1;
    unsigned CSRC1              : 1;
    };

  struct
    {
    unsigned TX9D1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_TX8            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TX91               : 1;
    unsigned                    : 1;
    };
  } __TXSTA1bits_t;

extern __at(0x0FAC) volatile __TXSTA1bits_t TXSTA1bits;

#define _TXSTA1_TX9D            0x01
#define _TXSTA1_TXD8            0x01
#define _TXSTA1_TX9D1           0x01
#define _TXSTA1_TRMT            0x02
#define _TXSTA1_TRMT1           0x02
#define _TXSTA1_BRGH            0x04
#define _TXSTA1_BRGH1           0x04
#define _TXSTA1_SENDB           0x08
#define _TXSTA1_SENDB1          0x08
#define _TXSTA1_SYNC            0x10
#define _TXSTA1_SYNC1           0x10
#define _TXSTA1_TXEN            0x20
#define _TXSTA1_TXEN1           0x20
#define _TXSTA1_TX9             0x40
#define _TXSTA1_TX8_9           0x40
#define _TXSTA1_NOT_TX8         0x40
#define _TXSTA1_TX91            0x40
#define _TXSTA1_CSRC            0x80
#define _TXSTA1_CSRC1           0x80

//==============================================================================

extern __at(0x0FAD) __sfr TXREG;
extern __at(0x0FAD) __sfr TXREG1;
extern __at(0x0FAE) __sfr RCREG;
extern __at(0x0FAE) __sfr RCREG1;
extern __at(0x0FAF) __sfr SPBRG;
extern __at(0x0FAF) __sfr SPBRG1;

//==============================================================================
//        T3GCON Bits

extern __at(0x0FB0) __sfr T3GCON;

typedef union
  {
  struct
    {
    unsigned T3GSS0             : 1;
    unsigned T3GSS1             : 1;
    unsigned T3GVAL             : 1;
    unsigned T3GGO_NOT_T3DONE   : 1;
    unsigned T3GSPM             : 1;
    unsigned T3GTM              : 1;
    unsigned T3GPOL             : 1;
    unsigned TMR3GE             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T3GGO              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_T3DONE         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T3GSS              : 2;
    unsigned                    : 6;
    };
  } __T3GCONbits_t;

extern __at(0x0FB0) volatile __T3GCONbits_t T3GCONbits;

#define _T3GSS0                 0x01
#define _T3GSS1                 0x02
#define _T3GVAL                 0x04
#define _T3GGO_NOT_T3DONE       0x08
#define _T3GGO                  0x08
#define _NOT_T3DONE             0x08
#define _T3GSPM                 0x10
#define _T3GTM                  0x20
#define _T3GPOL                 0x40
#define _TMR3GE                 0x80

//==============================================================================


//==============================================================================
//        T3CON Bits

extern __at(0x0FB1) __sfr T3CON;

typedef union
  {
  struct
    {
    unsigned TMR3ON             : 1;
    unsigned RD16               : 1;
    unsigned NOT_T3SYNC         : 1;
    unsigned SOSCEN             : 1;
    unsigned T3CKPS0            : 1;
    unsigned T3CKPS1            : 1;
    unsigned TMR3CS0            : 1;
    unsigned TMR3CS1            : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T3CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR3CS             : 2;
    };
  } __T3CONbits_t;

extern __at(0x0FB1) volatile __T3CONbits_t T3CONbits;

#define _T3CON_TMR3ON           0x01
#define _T3CON_RD16             0x02
#define _T3CON_NOT_T3SYNC       0x04
#define _T3CON_SOSCEN           0x08
#define _T3CON_T3CKPS0          0x10
#define _T3CON_T3CKPS1          0x20
#define _T3CON_TMR3CS0          0x40
#define _T3CON_TMR3CS1          0x80

//==============================================================================

extern __at(0x0FB2) __sfr TMR3;
extern __at(0x0FB2) __sfr TMR3L;
extern __at(0x0FB3) __sfr TMR3H;

//==============================================================================
//        CMSTAT Bits

extern __at(0x0FB4) __sfr CMSTAT;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned CMP1OUT              : 1;
  unsigned CMP2OUT              : 1;
  } __CMSTATbits_t;

extern __at(0x0FB4) volatile __CMSTATbits_t CMSTATbits;

#define _CMP1OUT                0x40
#define _CMP2OUT                0x80

//==============================================================================


//==============================================================================
//        CMSTATUS Bits

extern __at(0x0FB4) __sfr CMSTATUS;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned CMP1OUT              : 1;
  unsigned CMP2OUT              : 1;
  } __CMSTATUSbits_t;

extern __at(0x0FB4) volatile __CMSTATUSbits_t CMSTATUSbits;

#define _CMSTATUS_CMP1OUT       0x40
#define _CMSTATUS_CMP2OUT       0x80

//==============================================================================


//==============================================================================
//        CVRCON Bits

extern __at(0x0FB5) __sfr CVRCON;

typedef union
  {
  struct
    {
    unsigned CVR0               : 1;
    unsigned CVR1               : 1;
    unsigned CVR2               : 1;
    unsigned CVR3               : 1;
    unsigned CVR4               : 1;
    unsigned CVRSS              : 1;
    unsigned CVROE              : 1;
    unsigned CVREN              : 1;
    };

  struct
    {
    unsigned CVR                : 5;
    unsigned                    : 3;
    };
  } __CVRCONbits_t;

extern __at(0x0FB5) volatile __CVRCONbits_t CVRCONbits;

#define _CVR0                   0x01
#define _CVR1                   0x02
#define _CVR2                   0x04
#define _CVR3                   0x08
#define _CVR4                   0x10
#define _CVRSS                  0x20
#define _CVROE                  0x40
#define _CVREN                  0x80

//==============================================================================


//==============================================================================
//        PIE4 Bits

extern __at(0x0FB6) __sfr PIE4;

typedef struct
  {
  unsigned CCP3IE               : 1;
  unsigned CCP4IE               : 1;
  unsigned CCP5IE               : 1;
  unsigned                      : 1;
  unsigned CMP1IE               : 1;
  unsigned CMP2IE               : 1;
  unsigned EEIE                 : 1;
  unsigned TMR4IE               : 1;
  } __PIE4bits_t;

extern __at(0x0FB6) volatile __PIE4bits_t PIE4bits;

#define _CCP3IE                 0x01
#define _CCP4IE                 0x02
#define _CCP5IE                 0x04
#define _CMP1IE                 0x10
#define _CMP2IE                 0x20
#define _EEIE                   0x40
#define _TMR4IE                 0x80

//==============================================================================


//==============================================================================
//        PIR4 Bits

extern __at(0x0FB7) __sfr PIR4;

typedef struct
  {
  unsigned CCP3IF               : 1;
  unsigned CCP4IF               : 1;
  unsigned CCP5IF               : 1;
  unsigned                      : 1;
  unsigned CMP1IF               : 1;
  unsigned CMP2IF               : 1;
  unsigned EEIF                 : 1;
  unsigned TMR4IF               : 1;
  } __PIR4bits_t;

extern __at(0x0FB7) volatile __PIR4bits_t PIR4bits;

#define _CCP3IF                 0x01
#define _CCP4IF                 0x02
#define _CCP5IF                 0x04
#define _CMP1IF                 0x10
#define _CMP2IF                 0x20
#define _EEIF                   0x40
#define _TMR4IF                 0x80

//==============================================================================


//==============================================================================
//        IPR4 Bits

extern __at(0x0FB8) __sfr IPR4;

typedef struct
  {
  unsigned CCP3IP               : 1;
  unsigned CCP4IP               : 1;
  unsigned CCP5IP               : 1;
  unsigned                      : 1;
  unsigned CMP1IP               : 1;
  unsigned CMP2IP               : 1;
  unsigned EEIP                 : 1;
  unsigned TMR4IP               : 1;
  } __IPR4bits_t;

extern __at(0x0FB8) volatile __IPR4bits_t IPR4bits;

#define _CCP3IP                 0x01
#define _CCP4IP                 0x02
#define _CCP5IP                 0x04
#define _CMP1IP                 0x10
#define _CMP2IP                 0x20
#define _EEIP                   0x40
#define _TMR4IP                 0x80

//==============================================================================


//==============================================================================
//        BAUDCON2 Bits

extern __at(0x0FB9) __sfr BAUDCON2;

typedef union
  {
  struct
    {
    unsigned ABDEN              : 1;
    unsigned WUE                : 1;
    unsigned                    : 1;
    unsigned BRG16              : 1;
    unsigned TXCKP              : 1;
    unsigned RXDTP              : 1;
    unsigned RCIDL              : 1;
    unsigned ABDOVF             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RCMT               : 1;
    unsigned                    : 1;
    };
  } __BAUDCON2bits_t;

extern __at(0x0FB9) volatile __BAUDCON2bits_t BAUDCON2bits;

#define _BAUDCON2_ABDEN         0x01
#define _BAUDCON2_WUE           0x02
#define _BAUDCON2_BRG16         0x08
#define _BAUDCON2_TXCKP         0x10
#define _BAUDCON2_RXDTP         0x20
#define _BAUDCON2_RCIDL         0x40
#define _BAUDCON2_RCMT          0x40
#define _BAUDCON2_ABDOVF        0x80

//==============================================================================


//==============================================================================
//        TXSTA2 Bits

extern __at(0x0FBA) __sfr TXSTA2;

typedef union
  {
  struct
    {
    unsigned TX9D               : 1;
    unsigned TRMT               : 1;
    unsigned BRGH               : 1;
    unsigned SENDB              : 1;
    unsigned SYNC               : 1;
    unsigned TXEN               : 1;
    unsigned TX9                : 1;
    unsigned CSRC               : 1;
    };

  struct
    {
    unsigned TX9D2              : 1;
    unsigned TRMT2              : 1;
    unsigned BRGH2              : 1;
    unsigned SENDB2             : 1;
    unsigned SYNC2              : 1;
    unsigned TXEN2              : 1;
    unsigned TX92               : 1;
    unsigned CSRC2              : 1;
    };
  } __TXSTA2bits_t;

extern __at(0x0FBA) volatile __TXSTA2bits_t TXSTA2bits;

#define _TXSTA2_TX9D            0x01
#define _TXSTA2_TX9D2           0x01
#define _TXSTA2_TRMT            0x02
#define _TXSTA2_TRMT2           0x02
#define _TXSTA2_BRGH            0x04
#define _TXSTA2_BRGH2           0x04
#define _TXSTA2_SENDB           0x08
#define _TXSTA2_SENDB2          0x08
#define _TXSTA2_SYNC            0x10
#define _TXSTA2_SYNC2           0x10
#define _TXSTA2_TXEN            0x20
#define _TXSTA2_TXEN2           0x20
#define _TXSTA2_TX9             0x40
#define _TXSTA2_TX92            0x40
#define _TXSTA2_CSRC            0x80
#define _TXSTA2_CSRC2           0x80

//==============================================================================


//==============================================================================
//        CCP1CON Bits

extern __at(0x0FBB) __sfr CCP1CON;

typedef union
  {
  struct
    {
    unsigned CCP1M0             : 1;
    unsigned CCP1M1             : 1;
    unsigned CCP1M2             : 1;
    unsigned CCP1M3             : 1;
    unsigned DC1B0              : 1;
    unsigned DC1B1              : 1;
    unsigned P1M0               : 1;
    unsigned P1M1               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP1Y              : 1;
    unsigned CCP1X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC1B               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned P1M                : 2;
    };
  } __CCP1CONbits_t;

extern __at(0x0FBB) volatile __CCP1CONbits_t CCP1CONbits;

#define _CCP1M0                 0x01
#define _CCP1M1                 0x02
#define _CCP1M2                 0x04
#define _CCP1M3                 0x08
#define _DC1B0                  0x10
#define _CCP1Y                  0x10
#define _DC1B1                  0x20
#define _CCP1X                  0x20
#define _P1M0                   0x40
#define _P1M1                   0x80

//==============================================================================


//==============================================================================
//        ECCP1CON Bits

extern __at(0x0FBB) __sfr ECCP1CON;

typedef union
  {
  struct
    {
    unsigned CCP1M0             : 1;
    unsigned CCP1M1             : 1;
    unsigned CCP1M2             : 1;
    unsigned CCP1M3             : 1;
    unsigned DC1B0              : 1;
    unsigned DC1B1              : 1;
    unsigned P1M0               : 1;
    unsigned P1M1               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP1Y              : 1;
    unsigned CCP1X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC1B               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned P1M                : 2;
    };
  } __ECCP1CONbits_t;

extern __at(0x0FBB) volatile __ECCP1CONbits_t ECCP1CONbits;

#define _ECCP1CON_CCP1M0        0x01
#define _ECCP1CON_CCP1M1        0x02
#define _ECCP1CON_CCP1M2        0x04
#define _ECCP1CON_CCP1M3        0x08
#define _ECCP1CON_DC1B0         0x10
#define _ECCP1CON_CCP1Y         0x10
#define _ECCP1CON_DC1B1         0x20
#define _ECCP1CON_CCP1X         0x20
#define _ECCP1CON_P1M0          0x40
#define _ECCP1CON_P1M1          0x80

//==============================================================================

extern __at(0x0FBC) __sfr CCPR1;
extern __at(0x0FBC) __sfr CCPR1L;
extern __at(0x0FBD) __sfr CCPR1H;

//==============================================================================
//        ECCP1DEL Bits

extern __at(0x0FBE) __sfr ECCP1DEL;

typedef union
  {
  struct
    {
    unsigned P1DC0              : 1;
    unsigned P1DC1              : 1;
    unsigned P1DC2              : 1;
    unsigned P1DC3              : 1;
    unsigned P1DC4              : 1;
    unsigned P1DC5              : 1;
    unsigned P1DC6              : 1;
    unsigned P1RSEN             : 1;
    };

  struct
    {
    unsigned P1DC               : 7;
    unsigned                    : 1;
    };
  } __ECCP1DELbits_t;

extern __at(0x0FBE) volatile __ECCP1DELbits_t ECCP1DELbits;

#define _P1DC0                  0x01
#define _P1DC1                  0x02
#define _P1DC2                  0x04
#define _P1DC3                  0x08
#define _P1DC4                  0x10
#define _P1DC5                  0x20
#define _P1DC6                  0x40
#define _P1RSEN                 0x80

//==============================================================================


//==============================================================================
//        PWM1CON Bits

extern __at(0x0FBE) __sfr PWM1CON;

typedef union
  {
  struct
    {
    unsigned P1DC0              : 1;
    unsigned P1DC1              : 1;
    unsigned P1DC2              : 1;
    unsigned P1DC3              : 1;
    unsigned P1DC4              : 1;
    unsigned P1DC5              : 1;
    unsigned P1DC6              : 1;
    unsigned P1RSEN             : 1;
    };

  struct
    {
    unsigned P1DC               : 7;
    unsigned                    : 1;
    };
  } __PWM1CONbits_t;

extern __at(0x0FBE) volatile __PWM1CONbits_t PWM1CONbits;

#define _PWM1CON_P1DC0          0x01
#define _PWM1CON_P1DC1          0x02
#define _PWM1CON_P1DC2          0x04
#define _PWM1CON_P1DC3          0x08
#define _PWM1CON_P1DC4          0x10
#define _PWM1CON_P1DC5          0x20
#define _PWM1CON_P1DC6          0x40
#define _PWM1CON_P1RSEN         0x80

//==============================================================================


//==============================================================================
//        ECCP1AS Bits

extern __at(0x0FBF) __sfr ECCP1AS;

typedef union
  {
  struct
    {
    unsigned PSS1BD0            : 1;
    unsigned PSS1BD1            : 1;
    unsigned PSS1AC0            : 1;
    unsigned PSS1AC1            : 1;
    unsigned ECCP1AS0           : 1;
    unsigned ECCP1AS1           : 1;
    unsigned ECCP1AS2           : 1;
    unsigned ECCP1ASE           : 1;
    };

  struct
    {
    unsigned PSS1BD             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS1AC             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ECCP1AS            : 3;
    unsigned                    : 1;
    };
  } __ECCP1ASbits_t;

extern __at(0x0FBF) volatile __ECCP1ASbits_t ECCP1ASbits;

#define _PSS1BD0                0x01
#define _PSS1BD1                0x02
#define _PSS1AC0                0x04
#define _PSS1AC1                0x08
#define _ECCP1AS0               0x10
#define _ECCP1AS1               0x20
#define _ECCP1AS2               0x40
#define _ECCP1ASE               0x80

//==============================================================================


//==============================================================================
//        ADCON2 Bits

extern __at(0x0FC0) __sfr ADCON2;

typedef union
  {
  struct
    {
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    unsigned ADCS2              : 1;
    unsigned ACQT0              : 1;
    unsigned ACQT1              : 1;
    unsigned ACQT2              : 1;
    unsigned                    : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned ADCS               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned ACQT               : 3;
    unsigned                    : 2;
    };
  } __ADCON2bits_t;

extern __at(0x0FC0) volatile __ADCON2bits_t ADCON2bits;

#define _ADCS0                  0x01
#define _ADCS1                  0x02
#define _ADCS2                  0x04
#define _ACQT0                  0x08
#define _ACQT1                  0x10
#define _ACQT2                  0x20
#define _ADFM                   0x80

//==============================================================================


//==============================================================================
//        ADCON1 Bits

extern __at(0x0FC1) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned CHSN0              : 1;
    unsigned CHSN1              : 1;
    unsigned CHSN2              : 1;
    unsigned VNCFG              : 1;
    unsigned VCFG0              : 1;
    unsigned VCFG1              : 1;
    unsigned TRIGSEL0           : 1;
    unsigned TRIGSEL1           : 1;
    };

  struct
    {
    unsigned CHSN               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 4;
    unsigned VCFG               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TRIGSEL            : 2;
    };
  } __ADCON1bits_t;

extern __at(0x0FC1) volatile __ADCON1bits_t ADCON1bits;

#define _CHSN0                  0x01
#define _CHSN1                  0x02
#define _CHSN2                  0x04
#define _VNCFG                  0x08
#define _VCFG0                  0x10
#define _VCFG1                  0x20
#define _TRIGSEL0               0x40
#define _TRIGSEL1               0x80

//==============================================================================


//==============================================================================
//        ADCON0 Bits

extern __at(0x0FC2) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned CHS4               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned DONE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned NOT_DONE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 5;
    unsigned                    : 1;
    };
  } __ADCON0bits_t;

extern __at(0x0FC2) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _GO_NOT_DONE            0x02
#define _DONE                   0x02
#define _GO                     0x02
#define _NOT_DONE               0x02
#define _CHS0                   0x04
#define _CHS1                   0x08
#define _CHS2                   0x10
#define _CHS3                   0x20
#define _CHS4                   0x40

//==============================================================================

extern __at(0x0FC3) __sfr ADRES;
extern __at(0x0FC3) __sfr ADRESL;
extern __at(0x0FC4) __sfr ADRESH;

//==============================================================================
//        SSPCON2 Bits

extern __at(0x0FC5) __sfr SSPCON2;

typedef union
  {
  struct
    {
    unsigned SEN                : 1;
    unsigned RSEN               : 1;
    unsigned PEN                : 1;
    unsigned RCEN               : 1;
    unsigned ACKEN              : 1;
    unsigned ACKDT              : 1;
    unsigned ACKSTAT            : 1;
    unsigned GCEN               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ADMSK1             : 1;
    unsigned ADMSK2             : 1;
    unsigned ADMSK3             : 1;
    unsigned ADMSK4             : 1;
    unsigned ADMSK5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __SSPCON2bits_t;

extern __at(0x0FC5) volatile __SSPCON2bits_t SSPCON2bits;

#define _SEN                    0x01
#define _RSEN                   0x02
#define _ADMSK1                 0x02
#define _PEN                    0x04
#define _ADMSK2                 0x04
#define _RCEN                   0x08
#define _ADMSK3                 0x08
#define _ACKEN                  0x10
#define _ADMSK4                 0x10
#define _ACKDT                  0x20
#define _ADMSK5                 0x20
#define _ACKSTAT                0x40
#define _GCEN                   0x80

//==============================================================================


//==============================================================================
//        SSPCON1 Bits

extern __at(0x0FC6) __sfr SSPCON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCON1bits_t;

extern __at(0x0FC6) volatile __SSPCON1bits_t SSPCON1bits;

#define _SSPM0                  0x01
#define _SSPM1                  0x02
#define _SSPM2                  0x04
#define _SSPM3                  0x08
#define _CKP                    0x10
#define _SSPEN                  0x20
#define _SSPOV                  0x40
#define _WCOL                   0x80

//==============================================================================


//==============================================================================
//        SSPSTAT Bits

extern __at(0x0FC7) __sfr SSPSTAT;

typedef union
  {
  struct
    {
    unsigned BF                 : 1;
    unsigned UA                 : 1;
    unsigned R_NOT_W            : 1;
    unsigned S                  : 1;
    unsigned P                  : 1;
    unsigned D_NOT_A            : 1;
    unsigned CKE                : 1;
    unsigned SMP                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R_W                : 1;
    unsigned I2C_START          : 1;
    unsigned I2C_STOP           : 1;
    unsigned D_A                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_W              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_A              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_WRITE          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_ADDRESS        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned READ_WRITE         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DATA_ADDRESS       : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned I2C_READ           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned I2C_DAT            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __SSPSTATbits_t;

extern __at(0x0FC7) volatile __SSPSTATbits_t SSPSTATbits;

#define _BF                     0x01
#define _UA                     0x02
#define _R_NOT_W                0x04
#define _R_W                    0x04
#define _NOT_W                  0x04
#define _NOT_WRITE              0x04
#define _READ_WRITE             0x04
#define _I2C_READ               0x04
#define _S                      0x08
#define _I2C_START              0x08
#define _P                      0x10
#define _I2C_STOP               0x10
#define _D_NOT_A                0x20
#define _D_A                    0x20
#define _NOT_A                  0x20
#define _NOT_ADDRESS            0x20
#define _DATA_ADDRESS           0x20
#define _I2C_DAT                0x20
#define _CKE                    0x40
#define _SMP                    0x80

//==============================================================================


//==============================================================================
//        SSPADD Bits

extern __at(0x0FC8) __sfr SSPADD;

typedef struct
  {
  unsigned MSK0                 : 1;
  unsigned MSK1                 : 1;
  unsigned MSK2                 : 1;
  unsigned MSK3                 : 1;
  unsigned MSK4                 : 1;
  unsigned MSK5                 : 1;
  unsigned MSK6                 : 1;
  unsigned MSK7                 : 1;
  } __SSPADDbits_t;

extern __at(0x0FC8) volatile __SSPADDbits_t SSPADDbits;

#define _MSK0                   0x01
#define _MSK1                   0x02
#define _MSK2                   0x04
#define _MSK3                   0x08
#define _MSK4                   0x10
#define _MSK5                   0x20
#define _MSK6                   0x40
#define _MSK7                   0x80

//==============================================================================

extern __at(0x0FC9) __sfr SSPBUF;

//==============================================================================
//        T2CON Bits

extern __at(0x0FCA) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned TMR2ON             : 1;
    unsigned T2OUTPS0           : 1;
    unsigned T2OUTPS1           : 1;
    unsigned T2OUTPS2           : 1;
    unsigned T2OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T2OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x0FCA) volatile __T2CONbits_t T2CONbits;

#define _T2CKPS0                0x01
#define _T2CKPS1                0x02
#define _TMR2ON                 0x04
#define _T2OUTPS0               0x08
#define _T2OUTPS1               0x10
#define _T2OUTPS2               0x20
#define _T2OUTPS3               0x40

//==============================================================================

extern __at(0x0FCB) __sfr PR2;
extern __at(0x0FCC) __sfr TMR2;

//==============================================================================
//        T1CON Bits

extern __at(0x0FCD) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned RD16               : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned SOSCEN             : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned TMR1CS0            : 1;
    unsigned TMR1CS1            : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR1CS             : 2;
    };
  } __T1CONbits_t;

extern __at(0x0FCD) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _RD16                   0x02
#define _NOT_T1SYNC             0x04
#define _SOSCEN                 0x08
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20
#define _TMR1CS0                0x40
#define _TMR1CS1                0x80

//==============================================================================

extern __at(0x0FCE) __sfr TMR1;
extern __at(0x0FCE) __sfr TMR1L;
extern __at(0x0FCF) __sfr TMR1H;

//==============================================================================
//        RCON Bits

extern __at(0x0FD0) __sfr RCON;

typedef union
  {
  struct
    {
    unsigned NOT_BOR            : 1;
    unsigned NOT_POR            : 1;
    unsigned NOT_PD             : 1;
    unsigned NOT_TO             : 1;
    unsigned NOT_RI             : 1;
    unsigned NOT_CM             : 1;
    unsigned SBOREN             : 1;
    unsigned IPEN               : 1;
    };

  struct
    {
    unsigned BOR                : 1;
    unsigned POR                : 1;
    unsigned PD                 : 1;
    unsigned TO                 : 1;
    unsigned RI                 : 1;
    unsigned CM                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __RCONbits_t;

extern __at(0x0FD0) volatile __RCONbits_t RCONbits;

#define _NOT_BOR                0x01
#define _BOR                    0x01
#define _NOT_POR                0x02
#define _POR                    0x02
#define _NOT_PD                 0x04
#define _PD                     0x04
#define _NOT_TO                 0x08
#define _TO                     0x08
#define _NOT_RI                 0x10
#define _RI                     0x10
#define _NOT_CM                 0x20
#define _CM                     0x20
#define _SBOREN                 0x40
#define _IPEN                   0x80

//==============================================================================


//==============================================================================
//        WDTCON Bits

extern __at(0x0FD1) __sfr WDTCON;

typedef union
  {
  struct
    {
    unsigned SWDTEN             : 1;
    unsigned ULPSINK            : 1;
    unsigned ULPEN              : 1;
    unsigned                    : 1;
    unsigned SRETEN             : 1;
    unsigned ULPLVL             : 1;
    unsigned                    : 1;
    unsigned REGSLP             : 1;
    };

  struct
    {
    unsigned SWDTE              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __WDTCONbits_t;

extern __at(0x0FD1) volatile __WDTCONbits_t WDTCONbits;

#define _SWDTEN                 0x01
#define _SWDTE                  0x01
#define _ULPSINK                0x02
#define _ULPEN                  0x04
#define _SRETEN                 0x10
#define _ULPLVL                 0x20
#define _REGSLP                 0x80

//==============================================================================


//==============================================================================
//        OSCCON2 Bits

extern __at(0x0FD2) __sfr OSCCON2;

typedef union
  {
  struct
    {
    unsigned MFIOSEL            : 1;
    unsigned MFIOFS             : 1;
    unsigned LVDL2              : 1;
    unsigned SOSCGO             : 1;
    unsigned SOSCDRV            : 1;
    unsigned                    : 1;
    unsigned SOSCRUN            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LVDL0              : 1;
    unsigned LVDL1              : 1;
    unsigned                    : 1;
    unsigned LVDL3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LVDL               : 4;
    unsigned                    : 4;
    };
  } __OSCCON2bits_t;

extern __at(0x0FD2) volatile __OSCCON2bits_t OSCCON2bits;

#define _MFIOSEL                0x01
#define _LVDL0                  0x01
#define _MFIOFS                 0x02
#define _LVDL1                  0x02
#define _LVDL2                  0x04
#define _SOSCGO                 0x08
#define _LVDL3                  0x08
#define _SOSCDRV                0x10
#define _SOSCRUN                0x40

//==============================================================================


//==============================================================================
//        OSCCON Bits

extern __at(0x0FD3) __sfr OSCCON;

typedef union
  {
  struct
    {
    unsigned SCS0               : 1;
    unsigned SCS1               : 1;
    unsigned HFIOFS             : 1;
    unsigned OSTS               : 1;
    unsigned IRCF0              : 1;
    unsigned IRCF1              : 1;
    unsigned IRCF2              : 1;
    unsigned IDLEN              : 1;
    };

  struct
    {
    unsigned SCS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned IRCF               : 3;
    unsigned                    : 1;
    };
  } __OSCCONbits_t;

extern __at(0x0FD3) volatile __OSCCONbits_t OSCCONbits;

#define _SCS0                   0x01
#define _SCS1                   0x02
#define _HFIOFS                 0x04
#define _OSTS                   0x08
#define _IRCF0                  0x10
#define _IRCF1                  0x20
#define _IRCF2                  0x40
#define _IDLEN                  0x80

//==============================================================================


//==============================================================================
//        T0CON Bits

extern __at(0x0FD5) __sfr T0CON;

typedef union
  {
  struct
    {
    unsigned T0PS0              : 1;
    unsigned T0PS1              : 1;
    unsigned T0PS2              : 1;
    unsigned PSA                : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned T08BIT             : 1;
    unsigned TMR0ON             : 1;
    };

  struct
    {
    unsigned T0PS               : 3;
    unsigned                    : 5;
    };
  } __T0CONbits_t;

extern __at(0x0FD5) volatile __T0CONbits_t T0CONbits;

#define _T0PS0                  0x01
#define _T0PS1                  0x02
#define _T0PS2                  0x04
#define _PSA                    0x08
#define _T0SE                   0x10
#define _T0CS                   0x20
#define _T08BIT                 0x40
#define _TMR0ON                 0x80

//==============================================================================

extern __at(0x0FD6) __sfr TMR0;
extern __at(0x0FD6) __sfr TMR0L;
extern __at(0x0FD7) __sfr TMR0H;

//==============================================================================
//        STATUS Bits

extern __at(0x0FD8) __sfr STATUS;

typedef struct
  {
  unsigned C                    : 1;
  unsigned DC                   : 1;
  unsigned Z                    : 1;
  unsigned OV                   : 1;
  unsigned N                    : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUSbits_t;

extern __at(0x0FD8) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _OV                     0x08
#define _N                      0x10

//==============================================================================

extern __at(0x0FD9) __sfr FSR2L;
extern __at(0x0FDA) __sfr FSR2H;
extern __at(0x0FDB) __sfr PLUSW2;
extern __at(0x0FDC) __sfr PREINC2;
extern __at(0x0FDD) __sfr POSTDEC2;
extern __at(0x0FDE) __sfr POSTINC2;
extern __at(0x0FDF) __sfr INDF2;
extern __at(0x0FE0) __sfr BSR;
extern __at(0x0FE1) __sfr FSR1L;
extern __at(0x0FE2) __sfr FSR1H;
extern __at(0x0FE3) __sfr PLUSW1;
extern __at(0x0FE4) __sfr PREINC1;
extern __at(0x0FE5) __sfr POSTDEC1;
extern __at(0x0FE6) __sfr POSTINC1;
extern __at(0x0FE7) __sfr INDF1;
extern __at(0x0FE8) __sfr WREG;
extern __at(0x0FE9) __sfr FSR0L;
extern __at(0x0FEA) __sfr FSR0H;
extern __at(0x0FEB) __sfr PLUSW0;
extern __at(0x0FEC) __sfr PREINC0;
extern __at(0x0FED) __sfr POSTDEC0;
extern __at(0x0FEE) __sfr POSTINC0;
extern __at(0x0FEF) __sfr INDF0;

//==============================================================================
//        INTCON3 Bits

extern __at(0x0FF0) __sfr INTCON3;

typedef union
  {
  struct
    {
    unsigned INT1IF             : 1;
    unsigned INT2IF             : 1;
    unsigned INT3IF             : 1;
    unsigned INT1IE             : 1;
    unsigned INT2IE             : 1;
    unsigned INT3IE             : 1;
    unsigned INT1IP             : 1;
    unsigned INT2IP             : 1;
    };

  struct
    {
    unsigned INT1F              : 1;
    unsigned INT2F              : 1;
    unsigned INT3F              : 1;
    unsigned INT1E              : 1;
    unsigned INT2E              : 1;
    unsigned INT3E              : 1;
    unsigned INT1P              : 1;
    unsigned INT2P              : 1;
    };
  } __INTCON3bits_t;

extern __at(0x0FF0) volatile __INTCON3bits_t INTCON3bits;

#define _INT1IF                 0x01
#define _INT1F                  0x01
#define _INT2IF                 0x02
#define _INT2F                  0x02
#define _INT3IF                 0x04
#define _INT3F                  0x04
#define _INT1IE                 0x08
#define _INT1E                  0x08
#define _INT2IE                 0x10
#define _INT2E                  0x10
#define _INT3IE                 0x20
#define _INT3E                  0x20
#define _INT1IP                 0x40
#define _INT1P                  0x40
#define _INT2IP                 0x80
#define _INT2P                  0x80

//==============================================================================


//==============================================================================
//        INTCON2 Bits

extern __at(0x0FF1) __sfr INTCON2;

typedef union
  {
  struct
    {
    unsigned RBIP               : 1;
    unsigned INT3IP             : 1;
    unsigned TMR0IP             : 1;
    unsigned INTEDG3            : 1;
    unsigned INTEDG2            : 1;
    unsigned INTEDG1            : 1;
    unsigned INTEDG0            : 1;
    unsigned NOT_RBPU           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned INT3P              : 1;
    unsigned T0IP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RBPU               : 1;
    };
  } __INTCON2bits_t;

extern __at(0x0FF1) volatile __INTCON2bits_t INTCON2bits;

#define _RBIP                   0x01
#define _INT3IP                 0x02
#define _INT3P                  0x02
#define _TMR0IP                 0x04
#define _T0IP                   0x04
#define _INTEDG3                0x08
#define _INTEDG2                0x10
#define _INTEDG1                0x20
#define _INTEDG0                0x40
#define _NOT_RBPU               0x80
#define _RBPU                   0x80

//==============================================================================


//==============================================================================
//        INTCON Bits

extern __at(0x0FF2) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned RBIF               : 1;
    unsigned INT0IF             : 1;
    unsigned TMR0IF             : 1;
    unsigned RBIE               : 1;
    unsigned INT0IE             : 1;
    unsigned TMR0IE             : 1;
    unsigned PEIE_GIEL          : 1;
    unsigned GIE_GIEH           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned INT0F              : 1;
    unsigned T0IF               : 1;
    unsigned                    : 1;
    unsigned INT0E              : 1;
    unsigned T0IE               : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GIEL               : 1;
    unsigned GIEH               : 1;
    };
  } __INTCONbits_t;

extern __at(0x0FF2) volatile __INTCONbits_t INTCONbits;

#define _RBIF                   0x01
#define _INT0IF                 0x02
#define _INT0F                  0x02
#define _TMR0IF                 0x04
#define _T0IF                   0x04
#define _RBIE                   0x08
#define _INT0IE                 0x10
#define _INT0E                  0x10
#define _TMR0IE                 0x20
#define _T0IE                   0x20
#define _PEIE_GIEL              0x40
#define _PEIE                   0x40
#define _GIEL                   0x40
#define _GIE_GIEH               0x80
#define _GIE                    0x80
#define _GIEH                   0x80

//==============================================================================


//==============================================================================
//        INTCON1 Bits

extern __at(0x0FF2) __sfr INTCON1;

typedef union
  {
  struct
    {
    unsigned RBIF               : 1;
    unsigned INT0IF             : 1;
    unsigned TMR0IF             : 1;
    unsigned RBIE               : 1;
    unsigned INT0IE             : 1;
    unsigned TMR0IE             : 1;
    unsigned PEIE_GIEL          : 1;
    unsigned GIE_GIEH           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned INT0F              : 1;
    unsigned T0IF               : 1;
    unsigned                    : 1;
    unsigned INT0E              : 1;
    unsigned T0IE               : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GIEL               : 1;
    unsigned GIEH               : 1;
    };
  } __INTCON1bits_t;

extern __at(0x0FF2) volatile __INTCON1bits_t INTCON1bits;

#define _INTCON1_RBIF           0x01
#define _INTCON1_INT0IF         0x02
#define _INTCON1_INT0F          0x02
#define _INTCON1_TMR0IF         0x04
#define _INTCON1_T0IF           0x04
#define _INTCON1_RBIE           0x08
#define _INTCON1_INT0IE         0x10
#define _INTCON1_INT0E          0x10
#define _INTCON1_TMR0IE         0x20
#define _INTCON1_T0IE           0x20
#define _INTCON1_PEIE_GIEL      0x40
#define _INTCON1_PEIE           0x40
#define _INTCON1_GIEL           0x40
#define _INTCON1_GIE_GIEH       0x80
#define _INTCON1_GIE            0x80
#define _INTCON1_GIEH           0x80

//==============================================================================

extern __at(0x0FF3) __sfr PROD;
extern __at(0x0FF3) __sfr PRODL;
extern __at(0x0FF4) __sfr PRODH;
extern __at(0x0FF5) __sfr TABLAT;
extern __at(0x0FF6) __sfr TBLPTR;
extern __at(0x0FF6) __sfr TBLPTRL;
extern __at(0x0FF7) __sfr TBLPTRH;
extern __at(0x0FF8) __sfr TBLPTRU;
extern __at(0x0FF9) __sfr PC;
extern __at(0x0FF9) __sfr PCL;
extern __at(0x0FFA) __sfr PCLATH;
extern __at(0x0FFB) __sfr PCLATU;

//==============================================================================
//        STKPTR Bits

extern __at(0x0FFC) __sfr STKPTR;

typedef union
  {
  struct
    {
    unsigned SP0                : 1;
    unsigned SP1                : 1;
    unsigned SP2                : 1;
    unsigned SP3                : 1;
    unsigned SP4                : 1;
    unsigned                    : 1;
    unsigned STKUNF             : 1;
    unsigned STKFUL             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned STKOVF             : 1;
    };

  struct
    {
    unsigned SP                 : 5;
    unsigned                    : 3;
    };
  } __STKPTRbits_t;

extern __at(0x0FFC) volatile __STKPTRbits_t STKPTRbits;

#define _SP0                    0x01
#define _SP1                    0x02
#define _SP2                    0x04
#define _SP3                    0x08
#define _SP4                    0x10
#define _STKUNF                 0x40
#define _STKFUL                 0x80
#define _STKOVF                 0x80

//==============================================================================

extern __at(0x0FFD) __sfr TOS;
extern __at(0x0FFD) __sfr TOSL;
extern __at(0x0FFE) __sfr TOSH;
extern __at(0x0FFF) __sfr TOSU;

//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define __CONFIG1L              0x300000
#define __CONFIG1H              0x300001
#define __CONFIG2L              0x300002
#define __CONFIG2H              0x300003
#define __CONFIG3H              0x300005
#define __CONFIG4L              0x300006
#define __CONFIG5L              0x300008
#define __CONFIG5H              0x300009
#define __CONFIG6L              0x30000A
#define __CONFIG6H              0x30000B
#define __CONFIG7L              0x30000C
#define __CONFIG7H              0x30000D

//----------------------------- CONFIG1L Options -------------------------------

#define _RETEN_ON_1L            0xFE    // Ultra low-power regulator is Enabled (Controlled by SRETEN bit).
#define _RETEN_OFF_1L           0xFF    // Ultra low-power regulator is Disabled (Controlled by REGSLP bit).
#define _INTOSCSEL_LOW_1L       0xFB    // LF-INTOSC in Low-power mode during Sleep.
#define _INTOSCSEL_HIGH_1L      0xFF    // LF-INTOSC in High-power mode during Sleep.
#define _SOSCSEL_LOW_1L         0xEF    // Low Power SOSC circuit selected.
#define _SOSCSEL_DIG_1L         0xF7    // Digital (SCLKI) mode.
#define _SOSCSEL_HIGH_1L        0xFF    // High Power SOSC circuit selected.
#define _XINST_OFF_1L           0xBF    // Disabled.
#define _XINST_ON_1L            0xFF    // Enabled.

//----------------------------- CONFIG1H Options -------------------------------

#define _FOSC_LP_1H             0xF0    // LP oscillator.
#define _FOSC_XT_1H             0xF1    // XT oscillator.
#define _FOSC_HS2_1H            0xF2    // HS oscillator (High power, 16 MHz - 25 MHz).
#define _FOSC_HS1_1H            0xF3    // HS oscillator (Medium power, 4 MHz - 16 MHz).
#define _FOSC_EC3IO_1H          0xF4    // EC oscillator, CLKOUT function on OSC2 (High power, 16 MHz - 64 MHz).
#define _FOSC_EC3_1H            0xF5    // EC oscillator (High power, 16 MHz - 64 MHz).
#define _FOSC_RC_1H             0xF6    // External RC oscillator, CLKOUT function on OSC2.
#define _FOSC_RCIO_1H           0xF7    // External RC oscillator.
#define _FOSC_INTIO2_1H         0xF8    // Internal RC oscillator.
#define _FOSC_INTIO1_1H         0xF9    // Internal RC oscillator, CLKOUT function on OSC2.
#define _FOSC_EC2IO_1H          0xFA    // EC oscillator, CLKOUT function on OSC2 (Medium power, 160 kHz - 16 MHz).
#define _FOSC_EC2_1H            0xFB    // EC oscillator (Medium power, 160 kHz - 16 MHz).
#define _FOSC_EC1IO_1H          0xFC    // EC oscillator, CLKOUT function on OSC2 (Low power, DC - 160 kHz).
#define _FOSC_EC1_1H            0xFD    // EC oscillator (Low power, DC - 160 kHz).
#define _PLLCFG_OFF_1H          0xEF    // Disabled.
#define _PLLCFG_ON_1H           0xFF    // Enabled.
#define _FCMEN_OFF_1H           0xBF    // Disabled.
#define _FCMEN_ON_1H            0xFF    // Enabled.
#define _IESO_OFF_1H            0x7F    // Disabled.
#define _IESO_ON_1H             0xFF    // Enabled.

//----------------------------- CONFIG2L Options -------------------------------

#define _PWRTEN_ON_2L           0xFE    // Enabled.
#define _PWRTEN_OFF_2L          0xFF    // Disabled.
#define _BOREN_OFF_2L           0xF9    // Disabled in hardware, SBOREN disabled.
#define _BOREN_ON_2L            0xFB    // Controlled with SBOREN bit.
#define _BOREN_NOSLP_2L         0xFD    // Enabled while active, disabled in SLEEP, SBOREN disabled.
#define _BOREN_SBORDIS_2L       0xFF    // Enabled in hardware, SBOREN disabled.
#define _BORV_0_2L              0xE7    // 3.0V.
#define _BORV_1_2L              0xEF    // 2.7V.
#define _BORV_2_2L              0xF7    // 2.0V.
#define _BORV_3_2L              0xFF    // 1.8V.
#define _BORPWR_LOW_2L          0x9F    // BORMV set to low power level.
#define _BORPWR_MEDIUM_2L       0xBF    // BORMV set to medium power level.
#define _BORPWR_HIGH_2L         0xDF    // BORMV set to high power level.
#define _BORPWR_ZPBORMV_2L      0xFF    // ZPBORMV instead of BORMV is selected.

//----------------------------- CONFIG2H Options -------------------------------

#define _WDTEN_OFF_2H           0xFC    // WDT disabled in hardware; SWDTEN bit disabled.
#define _WDTEN_NOSLP_2H         0xFD    // WDT enabled only while device is active and disabled in Sleep mode; SWDTEN bit disabled.
#define _WDTEN_ON_2H            0xFE    // WDT controlled by SWDTEN bit setting.
#define _WDTEN_SWDTDIS_2H       0xFF    // WDT enabled in hardware; SWDTEN bit disabled.
#define _WDTPS_1_2H             0x83    // 1:1.
#define _WDTPS_2_2H             0x87    // 1:2.
#define _WDTPS_4_2H             0x8B    // 1:4.
#define _WDTPS_8_2H             0x8F    // 1:8.
#define _WDTPS_16_2H            0x93    // 1:16.
#define _WDTPS_32_2H            0x97    // 1:32.
#define _WDTPS_64_2H            0x9B    // 1:64.
#define _WDTPS_128_2H           0x9F    // 1:128.
#define _WDTPS_256_2H           0xA3    // 1:256.
#define _WDTPS_512_2H           0xA7    // 1:512.
#define _WDTPS_1024_2H          0xAB    // 1:1024.
#define _WDTPS_2048_2H          0xAF    // 1:2048.
#define _WDTPS_4096_2H          0xB3    // 1:4096.
#define _WDTPS_8192_2H          0xB7    // 1:8192.
#define _WDTPS_16384_2H         0xBB    // 1:16384.
#define _WDTPS_32768_2H         0xBF    // 1:32768.
#define _WDTPS_65536_2H         0xC3    // 1:65536.
#define _WDTPS_131072_2H        0xC7    // 1:131072.
#define _WDTPS_262144_2H        0xCB    // 1:262144.
#define _WDTPS_524288_2H        0xCF    // 1:524288.
#define _WDTPS_1048576_2H       0xFF    // 1:1048576.

//----------------------------- CONFIG3H Options -------------------------------

#define _CANMX_PORTE_3H         0xFE    // ECAN TX and RX pins are located on RE5 and RE4, respectively.
#define _CANMX_PORTB_3H         0xFF    // ECAN TX and RX pins are located on RB2 and RB3, respectively.
#define _T0CKMX_PORTG_3H        0xFD    // Timer0 gets its clock input from the RG4/T0CKI pin on 64-pin packages.
#define _T0CKMX_PORTB_3H        0xFF    // Timer0 gets its clock input from the RB5/T0CKI pin on 64-pin packages.
#define _T3CKMX_PORTB_3H        0xFB    // Timer3 gets its clock input from the RB5/T3CKI pin on 64-pin packages.
#define _T3CKMX_PORTG_3H        0xFF    // Timer3 gets its clock input from the RG2/T3CKI pin on 64-pin packages.
#define _MSSPMSK_MSK5_3H        0xF7    // 5 bit address masking mode.
#define _MSSPMSK_MSK7_3H        0xFF    // 7 Bit address masking mode.
#define _MCLRE_OFF_3H           0x7F    // MCLR Disabled, RG5 Enabled.
#define _MCLRE_ON_3H            0xFF    // MCLR Enabled, RE3 Disabled.

//----------------------------- CONFIG4L Options -------------------------------

#define _STVREN_OFF_4L          0xFE    // Disabled.
#define _STVREN_ON_4L           0xFF    // Enabled.
#define _BBSIZ_BB1K_4L          0xEF    // 1K word Boot Block size.
#define _BBSIZ_BB2K_4L          0xFF    // 2K word Boot Block size.

//----------------------------- CONFIG5L Options -------------------------------

#define _CP0_ON_5L              0xFE    // Enabled.
#define _CP0_OFF_5L             0xFF    // Disabled.
#define _CP1_ON_5L              0xFD    // Enabled.
#define _CP1_OFF_5L             0xFF    // Disabled.
#define _CP2_ON_5L              0xFB    // Enabled.
#define _CP2_OFF_5L             0xFF    // Disabled.
#define _CP3_ON_5L              0xF7    // Enabled.
#define _CP3_OFF_5L             0xFF    // Disabled.

//----------------------------- CONFIG5H Options -------------------------------

#define _CPB_ON_5H              0xBF    // Enabled.
#define _CPB_OFF_5H             0xFF    // Disabled.
#define _CPD_ON_5H              0x7F    // Enabled.
#define _CPD_OFF_5H             0xFF    // Disabled.

//----------------------------- CONFIG6L Options -------------------------------

#define _WRT0_ON_6L             0xFE    // Enabled.
#define _WRT0_OFF_6L            0xFF    // Disabled.
#define _WRT1_ON_6L             0xFD    // Enabled.
#define _WRT1_OFF_6L            0xFF    // Disabled.
#define _WRT2_ON_6L             0xFB    // Enabled.
#define _WRT2_OFF_6L            0xFF    // Disabled.
#define _WRT3_ON_6L             0xF7    // Enabled.
#define _WRT3_OFF_6L            0xFF    // Disabled.

//----------------------------- CONFIG6H Options -------------------------------

#define _WRTC_ON_6H             0xDF    // Enabled.
#define _WRTC_OFF_6H            0xFF    // Disabled.
#define _WRTB_ON_6H             0xBF    // Enabled.
#define _WRTB_OFF_6H            0xFF    // Disabled.
#define _WRTD_ON_6H             0x7F    // Enabled.
#define _WRTD_OFF_6H            0xFF    // Disabled.

//----------------------------- CONFIG7L Options -------------------------------

#define _EBTR0_ON_7L            0xFE    // Enabled.
#define _EBTR0_OFF_7L           0xFF    // Disabled.
#define _EBTR1_ON_7L            0xFD    // Enabled.
#define _EBTR1_OFF_7L           0xFF    // Disabled.
#define _EBTR2_ON_7L            0xFB    // Enabled.
#define _EBTR2_OFF_7L           0xFF    // Disabled.
#define _EBTR3_ON_7L            0xF7    // Enabled.
#define _EBTR3_OFF_7L           0xFF    // Disabled.

//----------------------------- CONFIG7H Options -------------------------------

#define _EBTRB_ON_7H            0xBF    // Enabled.
#define _EBTRB_OFF_7H           0xFF    // Disabled.

//==============================================================================

#define __DEVID1                0x3FFFFE
#define __DEVID2                0x3FFFFF

#define __IDLOC0                0x200000
#define __IDLOC1                0x200001
#define __IDLOC2                0x200002
#define __IDLOC3                0x200003
#define __IDLOC4                0x200004
#define __IDLOC5                0x200005
#define __IDLOC6                0x200006
#define __IDLOC7                0x200007

#endif // #ifndef __PIC18F66K80_H__
