/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import java.io.EOFException;
import java.io.IOException;

public class SequentialByteArrayReader
extends SequentialReader {
    @NotNull
    private final byte[] _bytes;
    private int _index;

    public SequentialByteArrayReader(@NotNull byte[] byArray) {
        this(byArray, 0);
    }

    public SequentialByteArrayReader(@NotNull byte[] byArray, int n) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        this._bytes = byArray;
        this._index = n;
    }

    @Override
    protected byte getByte() throws IOException {
        if (this._index >= this._bytes.length) {
            throw new EOFException("End of data reached.");
        }
        return this._bytes[this._index++];
    }

    @Override
    @NotNull
    public byte[] getBytes(int n) throws IOException {
        if (this._index + n > this._bytes.length) {
            throw new EOFException("End of data reached.");
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this._bytes, this._index, byArray, 0, n);
        this._index += n;
        return byArray;
    }

    @Override
    public void skip(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("n must be zero or greater.");
        }
        if ((long)this._index + l > (long)this._bytes.length) {
            throw new EOFException("End of data reached.");
        }
        this._index = (int)((long)this._index + l);
    }

    @Override
    public boolean trySkip(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("n must be zero or greater.");
        }
        this._index = (int)((long)this._index + l);
        if (this._index > this._bytes.length) {
            this._index = this._bytes.length;
            return false;
        }
        return true;
    }
}

