/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.UpdatePrimitivesTask;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class UpdateSelectionAction
extends JosmAction {
    public static void handlePrimitiveGoneException(long l, OsmPrimitiveType osmPrimitiveType) {
        MultiFetchServerObjectReader multiFetchServerObjectReader = MultiFetchServerObjectReader.create();
        multiFetchServerObjectReader.append(UpdateSelectionAction.getCurrentDataSet(), l, osmPrimitiveType);
        try {
            DataSet dataSet = multiFetchServerObjectReader.parseOsm(NullProgressMonitor.INSTANCE);
            Main.main.getEditLayer().mergeFrom(dataSet);
        }
        catch (Exception exception) {
            ExceptionDialogUtil.explainException(exception);
        }
    }

    public static void updatePrimitives(Collection<OsmPrimitive> collection) {
        UpdatePrimitivesTask updatePrimitivesTask = new UpdatePrimitivesTask(Main.main.getEditLayer(), collection);
        Main.worker.submit(updatePrimitivesTask);
    }

    public static void updatePrimitive(PrimitiveId primitiveId) {
        CheckParameterUtil.ensureParameterNotNull(primitiveId, "id");
        if (UpdateSelectionAction.getEditLayer() == null) {
            throw new IllegalStateException(I18n.tr("No current dataset found", new Object[0]));
        }
        OsmPrimitive osmPrimitive = UpdateSelectionAction.getEditLayer().data.getPrimitiveById(primitiveId);
        if (osmPrimitive == null) {
            throw new IllegalStateException(I18n.tr("Did not find an object with id {0} in the current dataset", primitiveId));
        }
        UpdateSelectionAction.updatePrimitives(Collections.singleton(osmPrimitive));
    }

    public UpdateSelectionAction() {
        super(I18n.tr("Update selection", new Object[0]), "updatedata", I18n.tr("Updates the currently selected objects from the server (re-downloads data)", new Object[0]), Shortcut.registerShortcut("file:updateselection", I18n.tr("File: {0}", I18n.tr("Update selection", new Object[0])), 85, 5008), true, "updateselection", true);
        this.putValue("help", HelpUtil.ht("/Action/UpdateSelection"));
    }

    public UpdateSelectionAction(String string, String string2, String string3, Shortcut shortcut, boolean bl, String string4) {
        super(string, string2, string3, shortcut, bl, string4, true);
    }

    @Override
    protected void updateEnabledState() {
        if (UpdateSelectionAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(UpdateSelectionAction.getCurrentDataSet().getAllSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty() && !Main.isOffline(OnlineResource.OSM_API));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        Collection<OsmPrimitive> collection = this.getData();
        if (collection.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("There are no selected objects to update.", new Object[0]), I18n.tr("Selection empty", new Object[0]), 1);
            return;
        }
        UpdateSelectionAction.updatePrimitives(collection);
    }

    public Collection<OsmPrimitive> getData() {
        return UpdateSelectionAction.getCurrentDataSet().getAllSelected();
    }
}

