/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.awt.Component;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.AbstractChangesetDownloadTask;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class ChangesetHeaderDownloadTask
extends AbstractChangesetDownloadTask {
    private final DownloadTask downloadTask;

    public ChangesetHeaderDownloadTask(Collection<Integer> collection) {
        this(Main.parent, collection, false);
    }

    public ChangesetHeaderDownloadTask(Component component, Collection<Integer> collection) {
        this(component, collection, false);
    }

    public ChangesetHeaderDownloadTask(Component component, Collection<Integer> collection, boolean bl) {
        this.downloadTask = new DownloadTask(component, collection, bl);
        this.setDownloadTask(this.downloadTask);
    }

    public static ChangesetHeaderDownloadTask buildTaskForChangesets(Collection<Changeset> collection) {
        return ChangesetHeaderDownloadTask.buildTaskForChangesets(Main.parent, collection);
    }

    public static ChangesetHeaderDownloadTask buildTaskForChangesets(Component component, Collection<Changeset> collection) {
        CheckParameterUtil.ensureParameterNotNull(component, "parent");
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Changeset changeset : collection != null ? collection : Collections.emptyList()) {
            if (changeset == null || changeset.isNew()) continue;
            hashSet.add(changeset.getId());
        }
        return new ChangesetHeaderDownloadTask(component, hashSet);
    }

    class DownloadTask
    extends AbstractChangesetDownloadTask.RunnableDownloadTask {
        private final Set<Integer> toDownload;
        private final boolean includeDiscussion;

        DownloadTask(Component component, Collection<Integer> collection, boolean bl) {
            super(ChangesetHeaderDownloadTask.this, component, I18n.tr("Download changesets", new Object[0]));
            this.toDownload = new HashSet<Integer>();
            this.includeDiscussion = bl;
            for (int n : collection != null ? collection : Collections.emptyList()) {
                if (n <= 0) continue;
                this.toDownload.add(n);
            }
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            try {
                this.downloadedChangesets.addAll(this.reader.readChangesets(this.toDownload, this.includeDiscussion, this.getProgressMonitor().createSubTaskMonitor(0, false)));
            }
            catch (OsmTransferException osmTransferException) {
                if (ChangesetHeaderDownloadTask.this.isCanceled()) {
                    return;
                }
                this.rememberLastException(osmTransferException);
            }
        }

        @Override
        protected void finish() {
            ChangesetHeaderDownloadTask.this.rememberDownloadedData(this.downloadedChangesets);
            if (ChangesetHeaderDownloadTask.this.isCanceled()) {
                return;
            }
            if (this.lastException != null) {
                ExceptionDialogUtil.explainException(this.lastException);
            }
            this.updateChangesets();
        }
    }
}

