/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.datum;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.projection.datum.NTV2GridShift;
import org.openstreetmap.josm.data.projection.datum.NTV2SubGrid;
import org.openstreetmap.josm.data.projection.datum.NTV2Util;

public class NTV2GridShiftFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int overviewHeaderCount;
    private int subGridHeaderCount;
    private int subGridCount;
    private String shiftType;
    private String version;
    private String fromEllipsoid = "";
    private String toEllipsoid = "";
    private double fromSemiMajorAxis;
    private double fromSemiMinorAxis;
    private double toSemiMajorAxis;
    private double toSemiMinorAxis;
    private NTV2SubGrid[] topLevelSubGrid;
    private NTV2SubGrid lastSubGrid;

    private static void readBytes(InputStream inputStream, byte[] byArray) throws IOException {
        if (inputStream.read(byArray) < byArray.length) {
            Main.error("Failed to read expected amount of bytes (" + byArray.length + ") from stream");
        }
    }

    public void loadGridShiftFile(InputStream inputStream, boolean bl) throws IOException {
        byte[] byArray = new byte[8];
        boolean bl2 = true;
        this.fromEllipsoid = "";
        this.toEllipsoid = "";
        this.topLevelSubGrid = null;
        NTV2GridShiftFile.readBytes(inputStream, byArray);
        String string = new String(byArray, StandardCharsets.UTF_8);
        if (!"NUM_OREC".equals(string)) {
            throw new IllegalArgumentException("Input file is not an NTv2 grid shift file");
        }
        NTV2GridShiftFile.readBytes(inputStream, byArray);
        this.overviewHeaderCount = NTV2Util.getIntBE(byArray, 0);
        if (this.overviewHeaderCount == 11) {
            bl2 = true;
        } else {
            this.overviewHeaderCount = NTV2Util.getIntLE(byArray, 0);
            if (this.overviewHeaderCount == 11) {
                bl2 = false;
            } else {
                throw new IllegalArgumentException("Input file is not an NTv2 grid shift file");
            }
        }
        NTV2GridShiftFile.readBytes(inputStream, byArray);
        NTV2GridShiftFile.readBytes(inputStream, byArray);
        this.subGridHeaderCount = NTV2Util.getInt(byArray, bl2);
        NTV2GridShiftFile.readBytes(inputStream, byArray);
        NTV2GridShiftFile.readBytes(inputStream, byArray);
        this.subGridCount = NTV2Util.getInt(byArray, bl2);
        NTV2SubGrid[] nTV2SubGridArray = new NTV2SubGrid[this.subGridCount];
        NTV2GridShiftFile.readBytes(inputStream, byArray);
        NTV2GridShiftFile.readBytes(inputStream, byArray);
        this.shiftType = new String(byArray, StandardCharsets.UTF_8);
        NTV2GridShiftFile.readBytes(inputStream, byArray);
        NTV2GridShiftFile.readBytes(inputStream, byArray);
        this.version = new String(byArray, StandardCharsets.UTF_8);
        NTV2GridShiftFile.readBytes(inputStream, byArray);
        NTV2GridShiftFile.readBytes(inputStream, byArray);
        this.fromEllipsoid = new String(byArray, StandardCharsets.UTF_8);
        NTV2GridShiftFile.readBytes(inputStream, byArray);
        NTV2GridShiftFile.readBytes(inputStream, byArray);
        this.toEllipsoid = new String(byArray, StandardCharsets.UTF_8);
        NTV2GridShiftFile.readBytes(inputStream, byArray);
        NTV2GridShiftFile.readBytes(inputStream, byArray);
        this.fromSemiMajorAxis = NTV2Util.getDouble(byArray, bl2);
        NTV2GridShiftFile.readBytes(inputStream, byArray);
        NTV2GridShiftFile.readBytes(inputStream, byArray);
        this.fromSemiMinorAxis = NTV2Util.getDouble(byArray, bl2);
        NTV2GridShiftFile.readBytes(inputStream, byArray);
        NTV2GridShiftFile.readBytes(inputStream, byArray);
        this.toSemiMajorAxis = NTV2Util.getDouble(byArray, bl2);
        NTV2GridShiftFile.readBytes(inputStream, byArray);
        NTV2GridShiftFile.readBytes(inputStream, byArray);
        this.toSemiMinorAxis = NTV2Util.getDouble(byArray, bl2);
        for (int i = 0; i < this.subGridCount; ++i) {
            nTV2SubGridArray[i] = new NTV2SubGrid(inputStream, bl2, bl);
        }
        this.topLevelSubGrid = NTV2GridShiftFile.createSubGridTree(nTV2SubGridArray);
        this.lastSubGrid = this.topLevelSubGrid[0];
    }

    private static NTV2SubGrid[] createSubGridTree(NTV2SubGrid[] nTV2SubGridArray) {
        int n = 0;
        HashMap hashMap = new HashMap();
        for (int i = 0; i < nTV2SubGridArray.length; ++i) {
            if ("NONE".equalsIgnoreCase(nTV2SubGridArray[i].getParentSubGridName())) {
                ++n;
            }
            hashMap.put(nTV2SubGridArray[i].getSubGridName(), new ArrayList());
        }
        NTV2SubGrid[] nTV2SubGridArray2 = new NTV2SubGrid[n];
        n = 0;
        for (int i = 0; i < nTV2SubGridArray.length; ++i) {
            if ("NONE".equalsIgnoreCase(nTV2SubGridArray[i].getParentSubGridName())) {
                nTV2SubGridArray2[n++] = nTV2SubGridArray[i];
                continue;
            }
            List list = (List)hashMap.get(nTV2SubGridArray[i].getParentSubGridName());
            list.add(nTV2SubGridArray[i]);
        }
        NTV2SubGrid[] nTV2SubGridArray3 = new NTV2SubGrid[]{};
        for (int i = 0; i < nTV2SubGridArray.length; ++i) {
            List list = (List)hashMap.get(nTV2SubGridArray[i].getSubGridName());
            if (list.isEmpty()) continue;
            NTV2SubGrid[] nTV2SubGridArray4 = list.toArray(nTV2SubGridArray3);
            nTV2SubGridArray[i].setSubGridArray(nTV2SubGridArray4);
        }
        return nTV2SubGridArray2;
    }

    public boolean gridShiftForward(NTV2GridShift nTV2GridShift) {
        NTV2SubGrid nTV2SubGrid = this.lastSubGrid.getSubGridForCoord(nTV2GridShift.getLonPositiveWestSeconds(), nTV2GridShift.getLatSeconds());
        if (nTV2SubGrid == null) {
            nTV2SubGrid = this.getSubGrid(nTV2GridShift.getLonPositiveWestSeconds(), nTV2GridShift.getLatSeconds());
        }
        if (nTV2SubGrid == null) {
            return false;
        }
        nTV2SubGrid.interpolateGridShift(nTV2GridShift);
        nTV2GridShift.setSubGridName(nTV2SubGrid.getSubGridName());
        this.lastSubGrid = nTV2SubGrid;
        return true;
    }

    public boolean gridShiftReverse(NTV2GridShift nTV2GridShift) {
        NTV2GridShift nTV2GridShift2 = new NTV2GridShift();
        nTV2GridShift2.setLonPositiveWestSeconds(nTV2GridShift.getLonPositiveWestSeconds());
        nTV2GridShift2.setLatSeconds(nTV2GridShift.getLatSeconds());
        for (int i = 0; i < 4; ++i) {
            if (!this.gridShiftForward(nTV2GridShift2)) {
                return false;
            }
            nTV2GridShift2.setLonPositiveWestSeconds(nTV2GridShift.getLonPositiveWestSeconds() - nTV2GridShift2.getLonShiftPositiveWestSeconds());
            nTV2GridShift2.setLatSeconds(nTV2GridShift.getLatSeconds() - nTV2GridShift2.getLatShiftSeconds());
        }
        nTV2GridShift.setLonShiftPositiveWestSeconds(-nTV2GridShift2.getLonShiftPositiveWestSeconds());
        nTV2GridShift.setLatShiftSeconds(-nTV2GridShift2.getLatShiftSeconds());
        nTV2GridShift.setLonAccuracyAvailable(nTV2GridShift2.isLonAccuracyAvailable());
        if (nTV2GridShift2.isLonAccuracyAvailable()) {
            nTV2GridShift.setLonAccuracySeconds(nTV2GridShift2.getLonAccuracySeconds());
        }
        nTV2GridShift.setLatAccuracyAvailable(nTV2GridShift2.isLatAccuracyAvailable());
        if (nTV2GridShift2.isLatAccuracyAvailable()) {
            nTV2GridShift.setLatAccuracySeconds(nTV2GridShift2.getLatAccuracySeconds());
        }
        return true;
    }

    private NTV2SubGrid getSubGrid(double d, double d2) {
        NTV2SubGrid nTV2SubGrid = null;
        for (int i = 0; i < this.topLevelSubGrid.length && (nTV2SubGrid = this.topLevelSubGrid[i].getSubGridForCoord(d, d2)) == null; ++i) {
        }
        return nTV2SubGrid;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Headers  : ");
        stringBuilder.append(this.overviewHeaderCount).append("\nSub Hdrs : ").append(this.subGridHeaderCount).append("\nSub Grids: ").append(this.subGridCount).append("\nType     : ").append(this.shiftType).append("\nVersion  : ").append(this.version).append("\nFr Ellpsd: ").append(this.fromEllipsoid).append("\nTo Ellpsd: ").append(this.toEllipsoid).append("\nFr Maj Ax: ").append(this.fromSemiMajorAxis).append("\nFr Min Ax: ").append(this.fromSemiMinorAxis).append("\nTo Maj Ax: ").append(this.toSemiMajorAxis).append("\nTo Min Ax: ").append(this.toSemiMinorAxis);
        return stringBuilder.toString();
    }

    public String getFromEllipsoid() {
        return this.fromEllipsoid;
    }

    public String getToEllipsoid() {
        return this.toEllipsoid;
    }
}

