/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.proj;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.proj.AbstractProj;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.I18n;

public class AlbersEqualArea
extends AbstractProj {
    private static final int MAXIMUM_ITERATIONS = 15;
    private static final double ITERATION_TOLERANCE = 1.0E-10;
    private static final double EPSILON = 1.0E-6;
    private double n;
    private double c;
    private double rho0;
    private double ec;

    @Override
    public String getName() {
        return I18n.tr("Albers Equal Area", new Object[0]);
    }

    @Override
    public String getProj4Id() {
        return "aea";
    }

    @Override
    public void initialize(ProjParameters projParameters) throws ProjectionConfigurationException {
        double d;
        super.initialize(projParameters);
        if (projParameters.lat0 == null) {
            throw new ProjectionConfigurationException(I18n.tr("Parameter ''{0}'' required.", "lat_0"));
        }
        if (projParameters.lat1 == null) {
            throw new ProjectionConfigurationException(I18n.tr("Parameter ''{0}'' required.", "lat_1"));
        }
        double d2 = Math.toRadians(projParameters.lat0);
        double d3 = Math.toRadians(projParameters.lat1);
        double d4 = d = projParameters.lat2 == null ? d3 : Math.toRadians(projParameters.lat2);
        if (Math.abs(d3 + d) < 1.0E-6) {
            throw new ProjectionConfigurationException(I18n.tr("standard parallels are opposite", new Object[0]));
        }
        double d5 = Math.sin(d3);
        double d6 = Math.cos(d3);
        double d7 = d5;
        boolean bl = Math.abs(d3 - d) >= 1.0E-6;
        double d8 = this.msfn(d5, d6);
        double d9 = this.qsfn(d5);
        if (bl) {
            d5 = Math.sin(d);
            d6 = Math.cos(d);
            double d10 = this.msfn(d5, d6);
            double d11 = this.qsfn(d5);
            d7 = (d8 * d8 - d10 * d10) / (d11 - d9);
        }
        this.c = d8 * d8 + d7 * d9;
        this.rho0 = Math.sqrt(this.c - d7 * this.qsfn(Math.sin(d2))) / d7;
        this.ec = 1.0 - 0.5 * (1.0 - this.e2) * Math.log((1.0 - this.e) / (1.0 + this.e)) / this.e;
        this.n = d7;
    }

    @Override
    public double[] project(double d, double d2) {
        d2 *= this.n;
        double d3 = this.c - this.n * this.qsfn(Math.sin(d));
        if (d3 < 0.0) {
            if (d3 > -1.0E-6) {
                d3 = 0.0;
            } else {
                throw new RuntimeException();
            }
        }
        d3 = Math.sqrt(d3) / this.n;
        d = this.rho0 - d3 * Math.cos(d2);
        d2 = d3 * Math.sin(d2);
        return new double[]{d2, d};
    }

    @Override
    public double[] invproject(double d, double d2) {
        double d3 = Math.hypot(d, d2 = this.rho0 - d2);
        if (d3 > 1.0E-6) {
            if (this.n < 0.0) {
                d3 = -d3;
                d = -d;
                d2 = -d2;
            }
            d = Math.atan2(d, d2) / this.n;
            d2 = d3 * this.n;
            d2 = Math.abs(d2 = (this.c - d2 * d2) / this.n) <= this.ec ? this.phi1(d2) : (d2 < 0.0 ? -1.5707963267948966 : 1.5707963267948966);
        } else {
            d = 0.0;
            d2 = this.n > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        return new double[]{d2, d};
    }

    public double phi1(double d) {
        double d2 = 1.0 - this.e2;
        double d3 = Math.asin(0.5 * d);
        if (this.e < 1.0E-6) {
            return d3;
        }
        for (int i = 0; i < 15; ++i) {
            double d4 = Math.sin(d3);
            double d5 = Math.cos(d3);
            double d6 = this.e * d4;
            double d7 = 1.0 - d6 * d6;
            double d8 = 0.5 * d7 * d7 / d5 * (d / d2 - d4 / d7 + 0.5 / this.e * Math.log((1.0 - d6) / (1.0 + d6)));
            d3 += d8;
            if (!(Math.abs(d8) <= 1.0E-10)) continue;
            return d3;
        }
        throw new RuntimeException("no convergence for q=" + d);
    }

    private double qsfn(double d) {
        double d2 = 1.0 - this.e2;
        if (this.e >= 1.0E-6) {
            double d3 = this.e * d;
            return d2 * (d / (1.0 - d3 * d3) - 0.5 / this.e * Math.log((1.0 - d3) / (1.0 + d3)));
        }
        return d + d;
    }

    @Override
    public Bounds getAlgorithmBounds() {
        return new Bounds(-89.0, -180.0, 89.0, 180.0, false);
    }
}

