/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.command.conflict.ModifiedConflictResolveCommand;
import org.openstreetmap.josm.command.conflict.VersionConflictResolveCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.conflict.pair.IConflictResolver;
import org.openstreetmap.josm.gui.conflict.pair.ListMergeModel;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.gui.conflict.pair.nodes.NodeListMergeModel;
import org.openstreetmap.josm.gui.conflict.pair.nodes.NodeListMerger;
import org.openstreetmap.josm.gui.conflict.pair.properties.PropertiesMergeModel;
import org.openstreetmap.josm.gui.conflict.pair.properties.PropertiesMerger;
import org.openstreetmap.josm.gui.conflict.pair.relation.RelationMemberListMergeModel;
import org.openstreetmap.josm.gui.conflict.pair.relation.RelationMemberMerger;
import org.openstreetmap.josm.gui.conflict.pair.tags.TagMergeModel;
import org.openstreetmap.josm.gui.conflict.pair.tags.TagMerger;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ConflictResolver
extends JPanel
implements PropertyChangeListener {
    public static final String RESOLVED_COMPLETELY_PROP = ConflictResolver.class.getName() + ".resolvedCompletely";
    public static final String MY_PRIMITIVE_PROP = ConflictResolver.class.getName() + ".myPrimitive";
    public static final String THEIR_PRIMITIVE_PROP = ConflictResolver.class.getName() + ".theirPrimitive";
    private JTabbedPane tabbedPane;
    private TagMerger tagMerger;
    private NodeListMerger nodeListMerger;
    private RelationMemberMerger relationMemberMerger;
    private PropertiesMerger propertiesMerger;
    private final transient List<IConflictResolver> conflictResolvers = new ArrayList<IConflictResolver>();
    private transient OsmPrimitive my;
    private transient OsmPrimitive their;
    private transient Conflict<? extends OsmPrimitive> conflict;
    private ImageIcon mergeComplete;
    private ImageIcon mergeIncomplete;
    private boolean resolvedCompletely = false;

    protected final void loadIcons() {
        this.mergeComplete = ImageProvider.get("dialogs", "valid");
        this.mergeIncomplete = ImageProvider.get("dialogs/conflict", "mergeincomplete");
    }

    protected final void build() {
        this.tabbedPane = new JTabbedPane();
        this.propertiesMerger = new PropertiesMerger();
        this.propertiesMerger.setName("panel.propertiesmerger");
        this.propertiesMerger.getModel().addPropertyChangeListener(this);
        this.tabbedPane.add(I18n.tr("Properties", new Object[0]), this.propertiesMerger);
        this.tagMerger = new TagMerger();
        this.tagMerger.setName("panel.tagmerger");
        this.tagMerger.getModel().addPropertyChangeListener(this);
        this.tabbedPane.add(I18n.tr("Tags", new Object[0]), this.tagMerger);
        this.nodeListMerger = new NodeListMerger();
        this.nodeListMerger.setName("panel.nodelistmerger");
        this.nodeListMerger.getModel().addPropertyChangeListener(this);
        this.tabbedPane.add(I18n.tr("Nodes", new Object[0]), this.nodeListMerger);
        this.relationMemberMerger = new RelationMemberMerger();
        this.relationMemberMerger.setName("panel.relationmembermerger");
        this.relationMemberMerger.getModel().addPropertyChangeListener(this);
        this.tabbedPane.add(I18n.tr("Members", new Object[0]), this.relationMemberMerger);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        this.conflictResolvers.add(this.propertiesMerger);
        this.conflictResolvers.add(this.tagMerger);
        this.conflictResolvers.add(this.nodeListMerger);
        this.conflictResolvers.add(this.relationMemberMerger);
    }

    public ConflictResolver() {
        this.build();
        this.loadIcons();
    }

    protected void setMy(OsmPrimitive osmPrimitive) {
        OsmPrimitive osmPrimitive2 = this.my;
        this.my = osmPrimitive;
        if (osmPrimitive2 != this.my) {
            this.firePropertyChange(MY_PRIMITIVE_PROP, osmPrimitive2, this.my);
        }
    }

    protected void setTheir(OsmPrimitive osmPrimitive) {
        OsmPrimitive osmPrimitive2 = this.their;
        this.their = osmPrimitive;
        if (osmPrimitive2 != this.their) {
            this.firePropertyChange(THEIR_PRIMITIVE_PROP, osmPrimitive2, this.their);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(TagMergeModel.PROP_NUM_UNDECIDED_TAGS)) {
            int n = (Integer)propertyChangeEvent.getNewValue();
            if (n == 0) {
                this.tabbedPane.setTitleAt(1, I18n.tr("Tags", new Object[0]));
                this.tabbedPane.setToolTipTextAt(1, I18n.tr("No pending tag conflicts to be resolved", new Object[0]));
                this.tabbedPane.setIconAt(1, this.mergeComplete);
            } else {
                this.tabbedPane.setTitleAt(1, I18n.trn("Tags({0} conflict)", "Tags({0} conflicts)", n, n));
                this.tabbedPane.setToolTipTextAt(1, I18n.trn("{0} pending tag conflict to be resolved", "{0} pending tag conflicts to be resolved", n, n));
                this.tabbedPane.setIconAt(1, this.mergeIncomplete);
            }
            this.updateResolvedCompletely();
        } else if (propertyChangeEvent.getPropertyName().equals(ListMergeModel.FROZEN_PROP)) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            if (propertyChangeEvent.getSource() == this.nodeListMerger.getModel() && this.my instanceof Way) {
                if (bl) {
                    this.tabbedPane.setTitleAt(2, I18n.tr("Nodes(resolved)", new Object[0]));
                    this.tabbedPane.setToolTipTextAt(2, I18n.tr("Merged node list frozen. No pending conflicts in the node list of this way", new Object[0]));
                    this.tabbedPane.setIconAt(2, this.mergeComplete);
                } else {
                    this.tabbedPane.setTitleAt(2, I18n.tr("Nodes(with conflicts)", new Object[0]));
                    this.tabbedPane.setToolTipTextAt(2, I18n.tr("Pending conflicts in the node list of this way", new Object[0]));
                    this.tabbedPane.setIconAt(2, this.mergeIncomplete);
                }
            } else if (propertyChangeEvent.getSource() == this.relationMemberMerger.getModel() && this.my instanceof Relation) {
                if (bl) {
                    this.tabbedPane.setTitleAt(3, I18n.tr("Members(resolved)", new Object[0]));
                    this.tabbedPane.setToolTipTextAt(3, I18n.tr("Merged member list frozen. No pending conflicts in the member list of this relation", new Object[0]));
                    this.tabbedPane.setIconAt(3, this.mergeComplete);
                } else {
                    this.tabbedPane.setTitleAt(3, I18n.tr("Members(with conflicts)", new Object[0]));
                    this.tabbedPane.setToolTipTextAt(3, I18n.tr("Pending conflicts in the member list of this relation", new Object[0]));
                    this.tabbedPane.setIconAt(3, this.mergeIncomplete);
                }
            }
            this.updateResolvedCompletely();
        } else if (propertyChangeEvent.getPropertyName().equals(PropertiesMergeModel.RESOLVED_COMPLETELY_PROP)) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            if (bl) {
                this.tabbedPane.setTitleAt(0, I18n.tr("Properties", new Object[0]));
                this.tabbedPane.setToolTipTextAt(0, I18n.tr("No pending property conflicts", new Object[0]));
                this.tabbedPane.setIconAt(0, this.mergeComplete);
            } else {
                this.tabbedPane.setTitleAt(0, I18n.tr("Properties(with conflicts)", new Object[0]));
                this.tabbedPane.setToolTipTextAt(0, I18n.tr("Pending property conflicts to be resolved", new Object[0]));
                this.tabbedPane.setIconAt(0, this.mergeIncomplete);
            }
            this.updateResolvedCompletely();
        } else if (PropertiesMergeModel.DELETE_PRIMITIVE_PROP.equals(propertyChangeEvent.getPropertyName())) {
            for (IConflictResolver iConflictResolver : this.conflictResolvers) {
                iConflictResolver.deletePrimitive((Boolean)propertyChangeEvent.getNewValue());
            }
        }
    }

    public void populate(Conflict<? extends OsmPrimitive> conflict) {
        this.setMy(conflict.getMy());
        this.setTheir(conflict.getTheir());
        this.conflict = conflict;
        this.propertiesMerger.populate(conflict);
        this.tabbedPane.setEnabledAt(0, true);
        this.tagMerger.populate(conflict);
        this.tabbedPane.setEnabledAt(1, true);
        if (this.my instanceof Node) {
            this.tabbedPane.setEnabledAt(2, false);
            this.tabbedPane.setEnabledAt(3, false);
        } else if (this.my instanceof Way) {
            this.nodeListMerger.populate(conflict);
            this.tabbedPane.setEnabledAt(2, true);
            this.tabbedPane.setEnabledAt(3, false);
            this.tabbedPane.setTitleAt(3, I18n.tr("Members", new Object[0]));
            this.tabbedPane.setIconAt(3, null);
        } else if (this.my instanceof Relation) {
            this.relationMemberMerger.populate(conflict);
            this.tabbedPane.setEnabledAt(2, false);
            this.tabbedPane.setTitleAt(2, I18n.tr("Nodes", new Object[0]));
            this.tabbedPane.setIconAt(2, null);
            this.tabbedPane.setEnabledAt(3, true);
        }
        this.updateResolvedCompletely();
        this.selectFirstTabWithConflicts();
    }

    public void selectFirstTabWithConflicts() {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            if (!this.tabbedPane.isEnabledAt(i) || !this.mergeIncomplete.equals(this.tabbedPane.getIconAt(i))) continue;
            this.tabbedPane.setSelectedIndex(i);
            break;
        }
    }

    public Command buildResolveCommand() {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        if (this.tagMerger.getModel().getNumResolvedConflicts() > 0) {
            arrayList.add(this.tagMerger.getModel().buildResolveCommand(this.conflict));
        }
        arrayList.addAll(this.propertiesMerger.getModel().buildResolveCommand(this.conflict));
        if (this.my instanceof Way && this.nodeListMerger.getModel().isFrozen()) {
            NodeListMergeModel nodeListMergeModel = (NodeListMergeModel)this.nodeListMerger.getModel();
            arrayList.add(nodeListMergeModel.buildResolveCommand(this.conflict));
        } else if (this.my instanceof Relation && this.relationMemberMerger.getModel().isFrozen()) {
            RelationMemberListMergeModel relationMemberListMergeModel = (RelationMemberListMergeModel)this.relationMemberMerger.getModel();
            arrayList.add(relationMemberListMergeModel.buildResolveCommand((Relation)this.my, (Relation)this.their));
        }
        if (this.isResolvedCompletely()) {
            arrayList.add(new VersionConflictResolveCommand(this.conflict));
            arrayList.add(new ModifiedConflictResolveCommand(this.conflict));
        }
        return new SequenceCommand(I18n.tr("Conflict Resolution", new Object[0]), arrayList);
    }

    protected void updateResolvedCompletely() {
        boolean bl = this.resolvedCompletely;
        if (this.my instanceof Node) {
            this.resolvedCompletely = this.tagMerger.getModel().isResolvedCompletely() && this.propertiesMerger.getModel().isResolvedCompletely();
        } else if (this.my instanceof Way) {
            this.resolvedCompletely = this.tagMerger.getModel().isResolvedCompletely() && this.propertiesMerger.getModel().isResolvedCompletely() && this.nodeListMerger.getModel().isFrozen();
        } else if (this.my instanceof Relation) {
            boolean bl2 = this.resolvedCompletely = this.tagMerger.getModel().isResolvedCompletely() && this.propertiesMerger.getModel().isResolvedCompletely() && this.relationMemberMerger.getModel().isFrozen();
        }
        if (this.resolvedCompletely != bl) {
            this.firePropertyChange(RESOLVED_COMPLETELY_PROP, bl, this.resolvedCompletely);
        }
    }

    public boolean isResolvedCompletely() {
        return this.resolvedCompletely;
    }

    public void unregisterListeners() {
        this.nodeListMerger.unlinkAsListener();
        this.relationMemberMerger.unlinkAsListener();
    }

    public void decideRemaining(MergeDecisionType mergeDecisionType) {
        this.propertiesMerger.decideRemaining(mergeDecisionType);
        this.tagMerger.decideRemaining(mergeDecisionType);
        if (this.my instanceof Way) {
            this.nodeListMerger.decideRemaining(mergeDecisionType);
        } else if (this.my instanceof Relation) {
            this.relationMemberMerger.decideRemaining(mergeDecisionType);
        }
        this.updateResolvedCompletely();
        if (!this.isResolvedCompletely()) {
            throw new AssertionError((Object)"The conflict could not be resolved completely!");
        }
    }
}

