/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTable;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.actions.AbstractRelationEditorAction;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class EditAction
extends AbstractRelationEditorAction {
    public EditAction(MemberTable memberTable, MemberTableModel memberTableModel, OsmDataLayer osmDataLayer) {
        super(memberTable, memberTableModel, null, osmDataLayer, null);
        this.putValue("ShortDescription", I18n.tr("Edit the relation the currently selected relation member refers to", new Object[0]));
        this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
        this.updateEnabledState();
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.memberTable.getSelectedRowCount() == 1 && this.memberTableModel.isEditableRelation(this.memberTable.getSelectedRow()));
    }

    protected Collection<RelationMember> getMembersForCurrentSelection(Relation relation) {
        HashSet<RelationMember> hashSet = new HashSet<RelationMember>();
        Collection<OsmPrimitive> collection = this.layer.data.getSelected();
        for (RelationMember relationMember : relation.getMembers()) {
            if (!collection.contains(relationMember.getMember())) continue;
            hashSet.add(relationMember);
        }
        return hashSet;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        int n = this.memberTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        OsmPrimitive osmPrimitive = this.memberTableModel.getReferredPrimitive(n);
        if (!(osmPrimitive instanceof Relation)) {
            return;
        }
        Relation relation = (Relation)osmPrimitive;
        if (relation.isIncomplete()) {
            return;
        }
        RelationEditor.getEditor(this.layer, relation, this.getMembersForCurrentSelection(relation)).setVisible(true);
    }
}

