/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.gui.history.DiffTableModel;
import org.openstreetmap.josm.gui.history.HistoryBrowserDialogManager;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.HistoryLoadTask;
import org.openstreetmap.josm.gui.history.NodeListTableColumnModel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.history.SelectionSynchronizer;
import org.openstreetmap.josm.gui.history.VersionInfoPanel;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.AdjustmentSynchronizer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class NodeListViewer
extends JPanel {
    private transient HistoryBrowserModel model;
    private VersionInfoPanel referenceInfoPanel;
    private VersionInfoPanel currentInfoPanel;
    private transient AdjustmentSynchronizer adjustmentSynchronizer;
    private transient SelectionSynchronizer selectionSynchronizer;
    private NodeListPopupMenu popupMenu;

    public NodeListViewer(HistoryBrowserModel historyBrowserModel) {
        this.setModel(historyBrowserModel);
        this.build();
    }

    protected JScrollPane embeddInScrollPane(JTable jTable) {
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.adjustmentSynchronizer.participateInSynchronizedScrolling(jScrollPane.getVerticalScrollBar());
        return jScrollPane;
    }

    protected JTable buildReferenceNodeListTable() {
        DiffTableModel diffTableModel = this.model.getNodeListTableModel(PointInTimeType.REFERENCE_POINT_IN_TIME);
        NodeListTableColumnModel nodeListTableColumnModel = new NodeListTableColumnModel();
        JTable jTable = new JTable(diffTableModel, nodeListTableColumnModel);
        diffTableModel.addTableModelListener(this.newReversedChangeListener(jTable, nodeListTableColumnModel));
        jTable.setName("table.referencenodelisttable");
        jTable.setSelectionMode(0);
        this.selectionSynchronizer.participateInSynchronizedSelection(jTable.getSelectionModel());
        jTable.addMouseListener(new InternalPopupMenuLauncher());
        jTable.addMouseListener(new DoubleClickAdapter(jTable));
        return jTable;
    }

    protected JTable buildCurrentNodeListTable() {
        DiffTableModel diffTableModel = this.model.getNodeListTableModel(PointInTimeType.CURRENT_POINT_IN_TIME);
        NodeListTableColumnModel nodeListTableColumnModel = new NodeListTableColumnModel();
        JTable jTable = new JTable(diffTableModel, nodeListTableColumnModel);
        diffTableModel.addTableModelListener(this.newReversedChangeListener(jTable, nodeListTableColumnModel));
        jTable.setName("table.currentnodelisttable");
        jTable.setSelectionMode(0);
        this.selectionSynchronizer.participateInSynchronizedSelection(jTable.getSelectionModel());
        jTable.addMouseListener(new InternalPopupMenuLauncher());
        jTable.addMouseListener(new DoubleClickAdapter(jTable));
        return jTable;
    }

    protected TableModelListener newReversedChangeListener(final JTable jTable, final NodeListTableColumnModel nodeListTableColumnModel) {
        return new TableModelListener(){
            private Boolean reversed;
            private final String nonReversedText;
            private final String reversedText;
            {
                this.nonReversedText = I18n.tr("Nodes", new Object[0]) + (jTable.getFont().canDisplay('\u25bc') ? " \u25bc" : " (1-n)");
                this.reversedText = I18n.tr("Nodes", new Object[0]) + (jTable.getFont().canDisplay('\u25b2') ? " \u25b2" : " (n-1)");
            }

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getSource() instanceof DiffTableModel) {
                    DiffTableModel diffTableModel = (DiffTableModel)tableModelEvent.getSource();
                    if (this.reversed == null || this.reversed.booleanValue() != diffTableModel.isReversed()) {
                        this.reversed = diffTableModel.isReversed();
                        nodeListTableColumnModel.getColumn(0).setHeaderValue(this.reversed != false ? this.reversedText : this.nonReversedText);
                        jTable.getTableHeader().setToolTipText(this.reversed != false ? I18n.tr("The nodes of this way are in reverse order", new Object[0]) : null);
                        jTable.getTableHeader().repaint();
                    }
                }
            }
        };
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        this.referenceInfoPanel = new VersionInfoPanel(this.model, PointInTimeType.REFERENCE_POINT_IN_TIME);
        this.add((Component)this.referenceInfoPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 23;
        this.currentInfoPanel = new VersionInfoPanel(this.model, PointInTimeType.CURRENT_POINT_IN_TIME);
        this.add((Component)this.currentInfoPanel, gridBagConstraints);
        this.adjustmentSynchronizer = new AdjustmentSynchronizer();
        this.selectionSynchronizer = new SelectionSynchronizer();
        this.popupMenu = new NodeListPopupMenu();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.embeddInScrollPane(this.buildReferenceNodeListTable()), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.embeddInScrollPane(this.buildCurrentNodeListTable()), gridBagConstraints);
    }

    protected void unregisterAsObserver(HistoryBrowserModel historyBrowserModel) {
        if (this.currentInfoPanel != null) {
            historyBrowserModel.deleteObserver(this.currentInfoPanel);
        }
        if (this.referenceInfoPanel != null) {
            historyBrowserModel.deleteObserver(this.referenceInfoPanel);
        }
    }

    protected void registerAsObserver(HistoryBrowserModel historyBrowserModel) {
        if (this.currentInfoPanel != null) {
            historyBrowserModel.addObserver(this.currentInfoPanel);
        }
        if (this.referenceInfoPanel != null) {
            historyBrowserModel.addObserver(this.referenceInfoPanel);
        }
    }

    public void setModel(HistoryBrowserModel historyBrowserModel) {
        if (this.model != null) {
            this.unregisterAsObserver(historyBrowserModel);
        }
        this.model = historyBrowserModel;
        if (this.model != null) {
            this.registerAsObserver(historyBrowserModel);
        }
    }

    private static PrimitiveId primitiveIdAtRow(TableModel tableModel, int n) {
        DiffTableModel diffTableModel = (DiffTableModel)tableModel;
        Long l = (Long)diffTableModel.getValueAt((int)n, (int)0).value;
        return l == null ? null : new SimplePrimitiveId(l, OsmPrimitiveType.NODE);
    }

    static class DoubleClickAdapter
    extends MouseAdapter {
        private final JTable table;
        private final ShowHistoryAction showHistoryAction;

        DoubleClickAdapter(JTable jTable) {
            this.table = jTable;
            this.showHistoryAction = new ShowHistoryAction();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() < 2) {
                return;
            }
            int n = this.table.rowAtPoint(mouseEvent.getPoint());
            if (n <= 0) {
                return;
            }
            PrimitiveId primitiveId = NodeListViewer.primitiveIdAtRow(this.table.getModel(), n);
            if (primitiveId == null || primitiveId.isNew()) {
                return;
            }
            this.showHistoryAction.setPrimitiveId(primitiveId);
            this.showHistoryAction.run();
        }
    }

    class InternalPopupMenuLauncher
    extends PopupMenuLauncher {
        InternalPopupMenuLauncher() {
            super(NodeListViewer.this.popupMenu);
        }

        @Override
        protected int checkTableSelection(JTable jTable, Point point) {
            int n = super.checkTableSelection(jTable, point);
            NodeListViewer.this.popupMenu.prepare(NodeListViewer.primitiveIdAtRow(jTable.getModel(), n));
            return n;
        }
    }

    static class ShowHistoryAction
    extends AbstractAction {
        private transient PrimitiveId primitiveId;

        ShowHistoryAction() {
            this.putValue("Name", I18n.tr("Show history", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Open a history browser with the history of this node", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "history"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.isEnabled()) {
                this.run();
            }
        }

        public void setPrimitiveId(PrimitiveId primitiveId) {
            this.primitiveId = primitiveId;
            this.updateEnabledState();
        }

        public void run() {
            if (HistoryDataSet.getInstance().getHistory(this.primitiveId) == null) {
                Main.worker.submit(new HistoryLoadTask().add(this.primitiveId));
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    final History history = HistoryDataSet.getInstance().getHistory(ShowHistoryAction.this.primitiveId);
                    if (history == null) {
                        return;
                    }
                    GuiHelper.runInEDT(new Runnable(){

                        @Override
                        public void run() {
                            HistoryBrowserDialogManager.getInstance().show(history);
                        }
                    });
                }
            };
            Main.worker.submit(runnable);
        }

        public void updateEnabledState() {
            this.setEnabled(this.primitiveId != null && !this.primitiveId.isNew());
        }
    }

    static class ZoomToNodeAction
    extends AbstractAction {
        private transient PrimitiveId primitiveId;

        ZoomToNodeAction() {
            this.putValue("Name", I18n.tr("Zoom to node", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Zoom to this node in the current data layer", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "zoomin"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OsmDataLayer osmDataLayer;
            if (!this.isEnabled()) {
                return;
            }
            OsmPrimitive osmPrimitive = this.getPrimitiveToZoom();
            if (osmPrimitive != null && (osmDataLayer = Main.main.getEditLayer()) != null) {
                osmDataLayer.data.setSelected(osmPrimitive.getPrimitiveId());
                AutoScaleAction.autoScale("selection");
            }
        }

        public void setPrimitiveId(PrimitiveId primitiveId) {
            this.primitiveId = primitiveId;
            this.updateEnabledState();
        }

        protected OsmPrimitive getPrimitiveToZoom() {
            if (this.primitiveId == null) {
                return null;
            }
            OsmDataLayer osmDataLayer = Main.main.getEditLayer();
            if (osmDataLayer == null) {
                return null;
            }
            return osmDataLayer.data.getPrimitiveById(this.primitiveId);
        }

        public void updateEnabledState() {
            if (!Main.main.hasEditLayer()) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(this.getPrimitiveToZoom() != null);
        }
    }

    static class NodeListPopupMenu
    extends JPopupMenu {
        private final ZoomToNodeAction zoomToNodeAction = new ZoomToNodeAction();
        private final ShowHistoryAction showHistoryAction;

        NodeListPopupMenu() {
            this.add(this.zoomToNodeAction);
            this.showHistoryAction = new ShowHistoryAction();
            this.add(this.showHistoryAction);
        }

        public void prepare(PrimitiveId primitiveId) {
            this.zoomToNodeAction.setPrimitiveId(primitiveId);
            this.zoomToNodeAction.updateEnabledState();
            this.showHistoryAction.setPrimitiveId(primitiveId);
            this.showHistoryAction.updateEnabledState();
        }
    }
}

