/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.gui.NavigatableComponent;

public interface NativeScaleLayer {
    public ScaleList getNativeScales();

    public static class ScaleList {
        private List<Scale> scales = new ArrayList<Scale>();

        protected ScaleList(double[] dArray) {
            for (int i = 0; i < dArray.length; ++i) {
                this.scales.add(new Scale(dArray[i], i));
            }
        }

        protected ScaleList() {
        }

        public ScaleList(Collection<Double> collection) {
            int n = 0;
            for (Double d : collection) {
                this.scales.add(new Scale(d, n++));
            }
        }

        protected void addScale(Scale scale) {
            this.scales.add(scale);
        }

        public ScaleList withIntermediateSteps(double d) {
            ScaleList scaleList = new ScaleList();
            Scale scale = null;
            for (Scale scale2 : this.scales) {
                double d2;
                double d3;
                int n;
                if (scale != null && (n = (int)Math.round(d3 = Math.log(d2 = scale.scale / scale2.scale) / Math.log(d))) != 0) {
                    double d4 = Math.pow(d2, 1.0 / (double)n);
                    for (int i = 1; i < n; ++i) {
                        double d5 = scale.scale / Math.pow(d4, i);
                        scaleList.addScale(new Scale(d5, false, scale2.index));
                    }
                }
                scaleList.addScale(scale2);
                scale = scale2;
            }
            return scaleList;
        }

        public Scale getSnapScale(double d, boolean bl) {
            return this.getSnapScale(d, NavigatableComponent.PROP_ZOOM_RATIO.get(), bl);
        }

        public Scale getSnapScale(double d, double d2, boolean bl) {
            if (this.scales.isEmpty()) {
                return null;
            }
            int n = this.scales.size();
            Scale scale = this.scales.get(0);
            Scale scale2 = this.scales.get(n - 1);
            if (d > scale.scale) {
                double d3 = d / scale.scale;
                double d4 = Math.log(d3) / Math.log(d2);
                int n2 = (int)(bl ? Math.floor(d4) : (double)Math.round(d4));
                if (n2 == 0) {
                    return new Scale(scale.scale, scale.isNative, n2);
                }
                return new Scale(scale.scale * Math.pow(d2, n2), false, n2);
            }
            if (d < scale2.scale) {
                double d5 = scale2.scale / d;
                double d6 = Math.log(d5) / Math.log(d2);
                int n3 = (int)(bl ? Math.floor(d6) : (double)Math.round(d6));
                if (n3 == 0) {
                    return new Scale(scale2.scale, scale2.isNative, n - 1 + n3);
                }
                return new Scale(scale2.scale / Math.pow(d2, n3), false, n - 1 + n3);
            }
            Scale scale3 = null;
            for (int i = 0; i < n; ++i) {
                Scale scale4 = this.scales.get(i);
                if (scale3 != null && d <= scale3.scale && d >= scale4.scale) {
                    if (bl || scale3.scale / d < d / scale4.scale) {
                        return new Scale(scale3.scale, scale3.isNative, i - 1);
                    }
                    return new Scale(scale4.scale, scale4.isNative, i);
                }
                scale3 = scale4;
            }
            return null;
        }

        public Scale scaleZoomTimes(double d, double d2, int n) {
            Scale scale = this.getSnapScale(d, d2, false);
            int n2 = Math.abs(n);
            for (int i = 0; i < n2; ++i) {
                scale = n < 0 ? this.getNextIn(scale, d2) : this.getNextOut(scale, d2);
            }
            return scale;
        }

        public Scale scaleZoomIn(double d, double d2) {
            Scale scale = this.getSnapScale(d, d2, false);
            return this.getNextIn(scale, d2);
        }

        public Scale scaleZoomOut(double d, double d2) {
            Scale scale = this.getSnapScale(d, d2, false);
            return this.getNextOut(scale, d2);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (Scale scale : this.scales) {
                stringBuilder.append(scale + "\n");
            }
            return stringBuilder.toString();
        }

        private Scale getNextIn(Scale scale, double d) {
            if (scale == null) {
                return null;
            }
            int n = scale.getIndex() + 1;
            if (n <= 0 || n > this.scales.size() - 1) {
                return new Scale(scale.scale / d, n == 0, n);
            }
            Scale scale2 = this.scales.get(n);
            return new Scale(scale2.scale, scale2.isNative, n);
        }

        private Scale getNextOut(Scale scale, double d) {
            if (scale == null) {
                return null;
            }
            int n = scale.getIndex() - 1;
            if (n < 0 || n >= this.scales.size() - 1) {
                return new Scale(scale.scale * d, n == this.scales.size() - 1, n);
            }
            Scale scale2 = this.scales.get(n);
            return new Scale(scale2.scale, scale2.isNative, n);
        }
    }

    public static class Scale {
        private double scale;
        private boolean isNative;
        private int index;

        public Scale(double d, int n) {
            this.scale = d;
            this.isNative = true;
            this.index = n;
        }

        public Scale(double d, boolean bl, int n) {
            this.scale = d;
            this.isNative = bl;
            this.index = n;
        }

        public String toString() {
            return String.format("%f [%s]", this.scale, this.isNative);
        }

        public int getIndex() {
            return this.index;
        }

        public double getScale() {
            return this.scale;
        }
    }
}

