/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.SourceEntry;
import org.openstreetmap.josm.gui.preferences.SourceProvider;
import org.openstreetmap.josm.gui.preferences.SourceType;
import org.openstreetmap.josm.gui.util.FileFilterAllFiles;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.TableHelper;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.gui.widgets.FileChooserManager;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageOverlay;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public abstract class SourceEditor
extends JPanel {
    protected final SourceType sourceType;
    protected final boolean canEnable;
    protected final JTable tblActiveSources;
    protected final ActiveSourcesModel activeSourcesModel;
    protected final JList<ExtendedSourceEntry> lstAvailableSources;
    protected final AvailableSourcesListModel availableSourcesModel;
    protected final String availableSourcesUrl;
    protected final transient List<SourceProvider> sourceProviders;
    private JTable tblIconPaths;
    private IconPathTableModel iconPathsModel;
    protected boolean sourcesInitiallyLoaded;

    public SourceEditor(SourceType sourceType, String string, List<SourceProvider> list, boolean bl) {
        this.sourceType = sourceType;
        this.canEnable = sourceType.equals((Object)SourceType.MAP_PAINT_STYLE) || sourceType.equals((Object)SourceType.TAGCHECKER_RULE);
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        this.availableSourcesModel = new AvailableSourcesListModel(defaultListSelectionModel);
        this.lstAvailableSources = new JList<ExtendedSourceEntry>(this.availableSourcesModel);
        this.lstAvailableSources.setSelectionModel(defaultListSelectionModel);
        final SourceEntryListCellRenderer sourceEntryListCellRenderer = new SourceEntryListCellRenderer();
        this.lstAvailableSources.setCellRenderer(sourceEntryListCellRenderer);
        GuiHelper.extendTooltipDelay(this.lstAvailableSources);
        this.availableSourcesUrl = string;
        this.sourceProviders = list;
        defaultListSelectionModel = new DefaultListSelectionModel();
        this.activeSourcesModel = new ActiveSourcesModel(defaultListSelectionModel);
        this.tblActiveSources = new JTable(this.activeSourcesModel){

            @Override
            public void scrollRectToVisible(Rectangle rectangle) {
                super.scrollRectToVisible(new Rectangle(0, rectangle.y, rectangle.width, rectangle.height));
            }
        };
        this.tblActiveSources.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.tblActiveSources.setSelectionModel(defaultListSelectionModel);
        this.tblActiveSources.setSelectionMode(2);
        this.tblActiveSources.setShowGrid(false);
        this.tblActiveSources.setIntercellSpacing(new Dimension(0, 0));
        this.tblActiveSources.setTableHeader(null);
        this.tblActiveSources.setAutoResizeMode(0);
        SourceEntryTableCellRenderer sourceEntryTableCellRenderer = new SourceEntryTableCellRenderer();
        if (this.canEnable) {
            this.tblActiveSources.getColumnModel().getColumn(0).setMaxWidth(1);
            this.tblActiveSources.getColumnModel().getColumn(0).setResizable(false);
            this.tblActiveSources.getColumnModel().getColumn(1).setCellRenderer(sourceEntryTableCellRenderer);
        } else {
            this.tblActiveSources.getColumnModel().getColumn(0).setCellRenderer(sourceEntryTableCellRenderer);
        }
        this.activeSourcesModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                sourceEntryListCellRenderer.updateSources(SourceEditor.this.activeSourcesModel.getSources());
                SourceEditor.this.lstAvailableSources.repaint();
            }
        });
        this.tblActiveSources.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                sourceEntryListCellRenderer.updateSources(SourceEditor.this.activeSourcesModel.getSources());
                SourceEditor.this.lstAvailableSources.repaint();
            }
        });
        this.activeSourcesModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                TableHelper.adjustColumnWidth(SourceEditor.this.tblActiveSources, SourceEditor.this.canEnable ? 1 : 0, 800);
            }
        });
        this.activeSourcesModel.setActiveSources(this.getInitialSourcesList());
        final EditActiveSourceAction editActiveSourceAction = new EditActiveSourceAction();
        this.tblActiveSources.getSelectionModel().addListSelectionListener(editActiveSourceAction);
        this.tblActiveSources.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int n = SourceEditor.this.tblActiveSources.rowAtPoint(mouseEvent.getPoint());
                    int n2 = SourceEditor.this.tblActiveSources.columnAtPoint(mouseEvent.getPoint());
                    if (n < 0 || n >= SourceEditor.this.tblActiveSources.getRowCount()) {
                        return;
                    }
                    if (SourceEditor.this.canEnable && n2 != 1) {
                        return;
                    }
                    editActiveSourceAction.actionPerformed(null);
                }
            }
        });
        RemoveActiveSourcesAction removeActiveSourcesAction = new RemoveActiveSourcesAction();
        this.tblActiveSources.getSelectionModel().addListSelectionListener(removeActiveSourcesAction);
        this.tblActiveSources.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.tblActiveSources.getActionMap().put("delete", removeActiveSourcesAction);
        MoveUpDownAction moveUpDownAction = null;
        MoveUpDownAction moveUpDownAction2 = null;
        if (sourceType.equals((Object)SourceType.MAP_PAINT_STYLE)) {
            moveUpDownAction = new MoveUpDownAction(false);
            moveUpDownAction2 = new MoveUpDownAction(true);
            this.tblActiveSources.getSelectionModel().addListSelectionListener(moveUpDownAction);
            this.tblActiveSources.getSelectionModel().addListSelectionListener(moveUpDownAction2);
            this.activeSourcesModel.addTableModelListener(moveUpDownAction);
            this.activeSourcesModel.addTableModelListener(moveUpDownAction2);
        }
        ActivateSourcesAction activateSourcesAction = new ActivateSourcesAction();
        this.lstAvailableSources.addListSelectionListener(activateSourcesAction);
        JButton jButton = new JButton(activateSourcesAction);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 11, 0, 0);
        this.add((Component)new JLabel(this.getStr(I18nString.AVAILABLE_SOURCES)), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 6);
        this.add((Component)new JLabel(this.getStr(I18nString.ACTIVE_SOURCES)), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 11, 0, 0);
        JScrollPane jScrollPane = new JScrollPane(this.lstAvailableSources);
        this.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setBorderPainted(false);
        jToolBar.setOpaque(false);
        jToolBar.add(Box.createHorizontalGlue());
        jToolBar.add(jButton);
        jToolBar.add(Box.createHorizontalGlue());
        this.add((Component)jToolBar, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane2 = new JScrollPane(this.tblActiveSources);
        this.add((Component)jScrollPane2, gridBagConstraints);
        jScrollPane2.setColumnHeaderView(null);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        JToolBar jToolBar2 = new JToolBar(1);
        jToolBar2.setFloatable(false);
        jToolBar2.setBorderPainted(false);
        jToolBar2.setOpaque(false);
        jToolBar2.add(new NewActiveSourceAction());
        jToolBar2.add(editActiveSourceAction);
        jToolBar2.add(removeActiveSourcesAction);
        jToolBar2.addSeparator(new Dimension(12, 30));
        if (sourceType.equals((Object)SourceType.MAP_PAINT_STYLE)) {
            jToolBar2.add(moveUpDownAction);
            jToolBar2.add(moveUpDownAction2);
        }
        this.add((Component)jToolBar2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 11, 0, 0);
        JToolBar jToolBar3 = new JToolBar();
        jToolBar3.setFloatable(false);
        jToolBar3.setBorderPainted(false);
        jToolBar3.setOpaque(false);
        jToolBar3.add(new ReloadSourcesAction(string, list));
        jToolBar3.add(Box.createHorizontalGlue());
        this.add((Component)jToolBar3, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JToolBar jToolBar4 = new JToolBar();
        jToolBar4.setFloatable(false);
        jToolBar4.setBorderPainted(false);
        jToolBar4.setOpaque(false);
        jToolBar4.add(Box.createHorizontalGlue());
        jToolBar4.add(new JButton(new ResetAction()));
        this.add((Component)jToolBar4, gridBagConstraints);
        if (bl) {
            this.buildIcons(gridBagConstraints);
        }
    }

    private void buildIcons(GridBagConstraints gridBagConstraints) {
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        this.iconPathsModel = new IconPathTableModel(defaultListSelectionModel);
        this.tblIconPaths = new JTable(this.iconPathsModel);
        this.tblIconPaths.setSelectionModel(defaultListSelectionModel);
        this.tblIconPaths.setSelectionMode(2);
        this.tblIconPaths.setTableHeader(null);
        this.tblIconPaths.getColumnModel().getColumn(0).setCellEditor(new FileOrUrlCellEditor(false));
        this.tblIconPaths.setRowHeight(20);
        this.tblIconPaths.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.iconPathsModel.setIconPaths(this.getInitialIconPathsList());
        EditIconPathAction editIconPathAction = new EditIconPathAction();
        this.tblIconPaths.getSelectionModel().addListSelectionListener(editIconPathAction);
        RemoveIconPathAction removeIconPathAction = new RemoveIconPathAction();
        this.tblIconPaths.getSelectionModel().addListSelectionListener(removeIconPathAction);
        this.tblIconPaths.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.tblIconPaths.getActionMap().put("delete", removeIconPathAction);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(8, 11, 8, 6);
        this.add((Component)new JSeparator(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 11, 0, 6);
        this.add((Component)new JLabel(I18n.tr("Icon paths:", new Object[0])), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 11, 0, 0);
        JScrollPane jScrollPane = new JScrollPane(this.tblIconPaths);
        this.add((Component)jScrollPane, gridBagConstraints);
        jScrollPane.setColumnHeaderView(null);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        jToolBar.setBorderPainted(false);
        jToolBar.setOpaque(false);
        jToolBar.add(new NewIconPathAction());
        jToolBar.add(editIconPathAction);
        jToolBar.add(removeIconPathAction);
        this.add((Component)jToolBar, gridBagConstraints);
    }

    public abstract Collection<? extends SourceEntry> getInitialSourcesList();

    public abstract Collection<String> getInitialIconPathsList();

    public abstract Collection<ExtendedSourceEntry> getDefault();

    public abstract boolean finish();

    protected boolean doFinish(SourcePrefHelper sourcePrefHelper, String string) {
        boolean bl = sourcePrefHelper.put(this.activeSourcesModel.getSources());
        if (this.tblIconPaths != null) {
            List<String> list = this.iconPathsModel.getIconPaths();
            if (!list.isEmpty()) {
                if (Main.pref.putCollection(string, list)) {
                    bl = true;
                }
            } else if (Main.pref.putCollection(string, null)) {
                bl = true;
            }
        }
        return bl;
    }

    protected abstract String getStr(I18nString var1);

    public boolean hasActiveSourcesChanged() {
        Collection<? extends SourceEntry> collection = this.getInitialSourcesList();
        List<SourceEntry> list = this.activeSourcesModel.getSources();
        if (collection.size() != list.size()) {
            return true;
        }
        Iterator<? extends SourceEntry> iterator = collection.iterator();
        Iterator<SourceEntry> iterator2 = list.iterator();
        while (iterator.hasNext()) {
            SourceEntry sourceEntry = iterator.next();
            SourceEntry sourceEntry2 = iterator2.next();
            if (Objects.equals(sourceEntry.url, sourceEntry2.url) && Objects.equals(sourceEntry.name, sourceEntry2.name) && sourceEntry.active == sourceEntry2.active) continue;
            return true;
        }
        return false;
    }

    public Collection<SourceEntry> getActiveSources() {
        return this.activeSourcesModel.getSources();
    }

    public final Collection<ExtendedSourceEntry> loadAndGetAvailableSources() {
        try {
            SourceLoader sourceLoader = new SourceLoader(this.availableSourcesUrl, this.sourceProviders);
            sourceLoader.realRun();
            return sourceLoader.sources;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void removeSources(Collection<Integer> collection) {
        this.activeSourcesModel.removeIdxs(collection);
    }

    protected void reloadAvailableSources(String string, List<SourceProvider> list) {
        Main.worker.submit(new SourceLoader(string, list));
    }

    public void initiallyLoadAvailableSources() {
        if (!this.sourcesInitiallyLoaded) {
            this.reloadAvailableSources(this.availableSourcesUrl, this.sourceProviders);
        }
        this.sourcesInitiallyLoaded = true;
    }

    private static void prepareFileChooser(String string, AbstractFileChooser abstractFileChooser) {
        if (string == null || string.trim().isEmpty()) {
            return;
        }
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            if (file.isFile()) {
                file = file.getParentFile();
            }
            if (file != null) {
                abstractFileChooser.setCurrentDirectory(file);
            }
            return;
        }
        if (uRL.getProtocol().startsWith("file")) {
            File file = new File(uRL.getPath());
            if (file.isFile()) {
                file = file.getParentFile();
            }
            if (file != null) {
                abstractFileChooser.setCurrentDirectory(file);
            }
        }
    }

    public final void deferLoading(final DefaultTabPreferenceSetting defaultTabPreferenceSetting, final Component component) {
        defaultTabPreferenceSetting.getTabPane().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (defaultTabPreferenceSetting.getTabPane().getSelectedComponent() == component) {
                    SourceEditor.this.initiallyLoadAvailableSources();
                }
            }
        });
    }

    protected String getTitleForSourceEntry(SourceEntry sourceEntry) {
        return "".equals(sourceEntry.title) ? null : sourceEntry.title;
    }

    public static abstract class SourcePrefHelper {
        private final String pref;

        public SourcePrefHelper(String string) {
            this.pref = string;
        }

        public abstract Collection<ExtendedSourceEntry> getDefault();

        public abstract Map<String, String> serialize(SourceEntry var1);

        public abstract SourceEntry deserialize(Map<String, String> var1);

        public List<SourceEntry> get() {
            Collection<Map<String, String>> collection = Main.pref.getListOfStructs(this.pref, (Collection<Map<String, String>>)null);
            if (collection == null) {
                return new ArrayList<SourceEntry>(this.getDefault());
            }
            ArrayList<SourceEntry> arrayList = new ArrayList<SourceEntry>();
            for (Map<String, String> map : collection) {
                SourceEntry sourceEntry = this.deserialize(new HashMap<String, String>(map));
                if (sourceEntry == null) continue;
                arrayList.add(sourceEntry);
            }
            return arrayList;
        }

        public boolean put(Collection<? extends SourceEntry> collection) {
            ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>(collection.size());
            for (SourceEntry sourceEntry : collection) {
                arrayList.add(this.serialize(sourceEntry));
            }
            return Main.pref.putListOfStructs(this.pref, arrayList);
        }

        public final Set<String> getActiveUrls() {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            for (SourceEntry sourceEntry : this.get()) {
                if (!sourceEntry.active) continue;
                linkedHashSet.add(sourceEntry.url);
            }
            return linkedHashSet;
        }
    }

    class FileOrUrlCellEditor
    extends JPanel
    implements TableCellEditor {
        private JosmTextField tfFileName;
        private final CopyOnWriteArrayList<CellEditorListener> listeners;
        private String value;
        private final boolean isFile;

        protected final void build() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.tfFileName = new JosmTextField();
            this.add((Component)this.tfFileName, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            this.add(new JButton(new LaunchFileChooserAction()));
            this.tfFileName.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    FileOrUrlCellEditor.this.tfFileName.selectAll();
                }
            });
        }

        FileOrUrlCellEditor(boolean bl) {
            this.isFile = bl;
            this.listeners = new CopyOnWriteArrayList();
            this.build();
        }

        @Override
        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            if (cellEditorListener != null) {
                this.listeners.addIfAbsent(cellEditorListener);
            }
        }

        protected void fireEditingCanceled() {
            for (CellEditorListener cellEditorListener : this.listeners) {
                cellEditorListener.editingCanceled(new ChangeEvent(this));
            }
        }

        protected void fireEditingStopped() {
            for (CellEditorListener cellEditorListener : this.listeners) {
                cellEditorListener.editingStopped(new ChangeEvent(this));
            }
        }

        @Override
        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                return ((MouseEvent)eventObject).getClickCount() >= 2;
            }
            return true;
        }

        @Override
        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.listeners.remove(cellEditorListener);
        }

        @Override
        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            this.value = this.tfFileName.getText();
            this.fireEditingStopped();
            return true;
        }

        public void setInitialValue(String string) {
            this.value = string;
            if (string == null) {
                this.tfFileName.setText("");
            } else {
                this.tfFileName.setText(string);
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.setInitialValue((String)object);
            this.tfFileName.selectAll();
            return this;
        }

        class LaunchFileChooserAction
        extends AbstractAction {
            LaunchFileChooserAction() {
                this.putValue("Name", "...");
                this.putValue("ShortDescription", I18n.tr("Launch a file chooser to select a file", new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileChooserManager fileChooserManager = new FileChooserManager(true).createFileChooser();
                if (!FileOrUrlCellEditor.this.isFile) {
                    fileChooserManager.getFileChooser().setFileSelectionMode(1);
                }
                SourceEditor.prepareFileChooser(FileOrUrlCellEditor.this.tfFileName.getText(), fileChooserManager.getFileChooser());
                AbstractFileChooser abstractFileChooser = fileChooserManager.openFileChooser(GuiHelper.getFrameForComponent(SourceEditor.this));
                if (abstractFileChooser != null) {
                    FileOrUrlCellEditor.this.tfFileName.setText(abstractFileChooser.getSelectedFile().toString());
                }
            }
        }
    }

    static class SourceEntryTableCellRenderer
    extends DefaultTableCellRenderer {
        SourceEntryTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return this;
            }
            return super.getTableCellRendererComponent(jTable, SourceEntryTableCellRenderer.fromSourceEntry((SourceEntry)object), bl, bl2, n, n2);
        }

        private static String fromSourceEntry(SourceEntry sourceEntry) {
            if (sourceEntry == null) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder("<html><b>");
            if (sourceEntry.title != null) {
                stringBuilder.append(sourceEntry.title).append("</b> <span color=\"gray\">");
            }
            stringBuilder.append(sourceEntry.url);
            if (sourceEntry.title != null) {
                stringBuilder.append("</span>");
            }
            stringBuilder.append("</html>");
            return stringBuilder.toString();
        }
    }

    class SourceLoader
    extends PleaseWaitRunnable {
        private final String url;
        private final List<SourceProvider> sourceProviders;
        private CachedFile cachedFile;
        private boolean canceled;
        private final List<ExtendedSourceEntry> sources;

        SourceLoader(String string, List<SourceProvider> list) {
            super(I18n.tr(SourceEditor.this.getStr(I18nString.LOADING_SOURCES_FROM), string));
            this.sources = new ArrayList<ExtendedSourceEntry>();
            this.url = string;
            this.sourceProviders = list;
        }

        @Override
        protected void cancel() {
            this.canceled = true;
            Utils.close(this.cachedFile);
        }

        protected void warn(Exception exception) {
            String string = Utils.escapeReservedCharactersHTML(exception.getMessage() != null ? exception.getMessage() : exception.toString());
            final String string2 = I18n.tr(SourceEditor.this.getStr(I18nString.FAILED_TO_LOAD_SOURCES_FROM), this.url, string);
            GuiHelper.runInEDT(new Runnable(){

                @Override
                public void run() {
                    HelpAwareOptionPane.showOptionDialog(Main.parent, string2, I18n.tr("Error", new Object[0]), 0, HelpUtil.ht(SourceEditor.this.getStr(I18nString.FAILED_TO_LOAD_SOURCES_FROM_HELP_TOPIC)));
                }
            });
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            try {
                this.sources.addAll(SourceEditor.this.getDefault());
                for (SourceProvider sourceProvider : this.sourceProviders) {
                    for (SourceEntry sourceEntry : sourceProvider.getSources()) {
                        if (!(sourceEntry instanceof ExtendedSourceEntry)) continue;
                        this.sources.add((ExtendedSourceEntry)sourceEntry);
                    }
                }
                this.readFile();
                Iterator<Object> iterator = this.sources.iterator();
                while (iterator.hasNext()) {
                    if (!"xml".equals(((ExtendedSourceEntry)iterator.next()).styleType)) continue;
                    Main.debug("Removing XML source entry");
                    iterator.remove();
                }
            }
            catch (IOException iOException) {
                if (this.canceled) {
                    return;
                }
                OsmTransferException osmTransferException = new OsmTransferException(iOException);
                osmTransferException.setUrl(this.url);
                this.warn(osmTransferException);
            }
        }

        protected void readFile() throws IOException {
            String string = LanguageInfo.getLanguageCodeXML();
            this.cachedFile = new CachedFile(this.url);
            try (BufferedReader bufferedReader = this.cachedFile.getContentReader();){
                String string2;
                ExtendedSourceEntry extendedSourceEntry = null;
                while ((string2 = bufferedReader.readLine()) != null && !this.canceled) {
                    Matcher matcher;
                    if (string2.trim().isEmpty()) continue;
                    if (string2.startsWith("\t")) {
                        matcher = Pattern.compile("^\t([^:]+): *(.+)$").matcher(string2);
                        if (!matcher.matches()) {
                            Main.error(I18n.tr(SourceEditor.this.getStr(I18nString.ILLEGAL_FORMAT_OF_ENTRY), this.url, string2));
                            continue;
                        }
                        if (extendedSourceEntry == null) continue;
                        String string3 = matcher.group(1);
                        String string4 = matcher.group(2);
                        if ("author".equals(string3) && extendedSourceEntry.author == null) {
                            extendedSourceEntry.author = string4;
                            continue;
                        }
                        if ("version".equals(string3)) {
                            extendedSourceEntry.version = string4;
                            continue;
                        }
                        if ("link".equals(string3) && extendedSourceEntry.link == null) {
                            extendedSourceEntry.link = string4;
                            continue;
                        }
                        if ("description".equals(string3) && extendedSourceEntry.description == null) {
                            extendedSourceEntry.description = string4;
                            continue;
                        }
                        if ((string + "shortdescription").equals(string3) && extendedSourceEntry.title == null) {
                            extendedSourceEntry.title = string4;
                            continue;
                        }
                        if ("shortdescription".equals(string3) && extendedSourceEntry.title == null) {
                            extendedSourceEntry.title = string4;
                            continue;
                        }
                        if ((string + "title").equals(string3) && extendedSourceEntry.title == null) {
                            extendedSourceEntry.title = string4;
                            continue;
                        }
                        if ("title".equals(string3) && extendedSourceEntry.title == null) {
                            extendedSourceEntry.title = string4;
                            continue;
                        }
                        if ("name".equals(string3) && extendedSourceEntry.name == null) {
                            extendedSourceEntry.name = string4;
                            continue;
                        }
                        if ((string + "author").equals(string3)) {
                            extendedSourceEntry.author = string4;
                            continue;
                        }
                        if ((string + "link").equals(string3)) {
                            extendedSourceEntry.link = string4;
                            continue;
                        }
                        if ((string + "description").equals(string3)) {
                            extendedSourceEntry.description = string4;
                            continue;
                        }
                        if ("min-josm-version".equals(string3)) {
                            try {
                                extendedSourceEntry.minJosmVersion = Integer.valueOf(string4);
                            }
                            catch (NumberFormatException numberFormatException) {
                                if (!Main.isTraceEnabled()) continue;
                                Main.trace(numberFormatException.getMessage());
                            }
                            continue;
                        }
                        if (!"style-type".equals(string3)) continue;
                        extendedSourceEntry.styleType = string4;
                        continue;
                    }
                    extendedSourceEntry = null;
                    matcher = Pattern.compile("^(.+);(.+)$").matcher(string2);
                    if (matcher.matches()) {
                        extendedSourceEntry = new ExtendedSourceEntry(matcher.group(1), matcher.group(2));
                        this.sources.add(extendedSourceEntry);
                        continue;
                    }
                    Main.error(I18n.tr(SourceEditor.this.getStr(I18nString.ILLEGAL_FORMAT_OF_ENTRY), this.url, string2));
                }
            }
        }

        @Override
        protected void finish() {
            Collections.sort(this.sources);
            SourceEditor.this.availableSourcesModel.setSources(this.sources);
        }
    }

    static class SourceEntryListCellRenderer
    extends JLabel
    implements ListCellRenderer<ExtendedSourceEntry> {
        private final ImageIcon GREEN_CHECK = ImageProvider.getIfAvailable("misc", "green_check");
        private final ImageIcon GRAY_CHECK = ImageProvider.getIfAvailable("misc", "gray_check");
        private final Map<String, SourceEntry> entryByUrl = new HashMap<String, SourceEntry>();

        SourceEntryListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ExtendedSourceEntry> jList, ExtendedSourceEntry extendedSourceEntry, int n, boolean bl, boolean bl2) {
            String string = extendedSourceEntry.toString();
            this.setText(string);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setFont(this.getFont().deriveFont(0));
            this.setOpaque(true);
            this.setToolTipText(extendedSourceEntry.getTooltip());
            SourceEntry sourceEntry = this.entryByUrl.get(extendedSourceEntry.url);
            this.setIcon(sourceEntry == null ? null : (sourceEntry.active ? this.GREEN_CHECK : this.GRAY_CHECK));
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateSources(List<SourceEntry> list) {
            Map<String, SourceEntry> map = this.entryByUrl;
            synchronized (map) {
                this.entryByUrl.clear();
                for (SourceEntry sourceEntry : list) {
                    this.entryByUrl.put(sourceEntry.url, sourceEntry);
                }
            }
        }
    }

    class EditIconPathAction
    extends AbstractAction
    implements ListSelectionListener {
        EditIconPathAction() {
            this.putValue("Name", I18n.tr("Edit", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Edit the selected icon path", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
            this.updateEnabledState();
        }

        protected final void updateEnabledState() {
            this.setEnabled(SourceEditor.this.tblIconPaths.getSelectedRowCount() == 1);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = SourceEditor.this.tblIconPaths.getSelectedRow();
            SourceEditor.this.tblIconPaths.editCellAt(n, 0);
        }
    }

    class RemoveIconPathAction
    extends AbstractAction
    implements ListSelectionListener {
        RemoveIconPathAction() {
            this.putValue("Name", I18n.tr("Remove", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Remove the selected icon paths", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.updateEnabledState();
        }

        protected final void updateEnabledState() {
            this.setEnabled(SourceEditor.this.tblIconPaths.getSelectedRowCount() > 0);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SourceEditor.this.iconPathsModel.removeSelected();
        }
    }

    class NewIconPathAction
    extends AbstractAction {
        NewIconPathAction() {
            this.putValue("Name", I18n.tr("New", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Add a new icon path", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "add"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SourceEditor.this.iconPathsModel.addPath("");
            SourceEditor.this.tblIconPaths.editCellAt(SourceEditor.this.iconPathsModel.getRowCount() - 1, 0);
        }
    }

    protected static class IconPathTableModel
    extends AbstractTableModel {
        private final List<String> data;
        private final DefaultListSelectionModel selectionModel;

        public IconPathTableModel(DefaultListSelectionModel defaultListSelectionModel) {
            this.selectionModel = defaultListSelectionModel;
            this.data = new ArrayList<String>();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return this.data == null ? 0 : this.data.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.data.get(n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.updatePath(n, (String)object);
        }

        public void setIconPaths(Collection<String> collection) {
            this.data.clear();
            if (collection != null) {
                this.data.addAll(collection);
            }
            this.sort();
            this.fireTableDataChanged();
        }

        public void addPath(String string) {
            if (string == null) {
                return;
            }
            this.data.add(string);
            this.sort();
            this.fireTableDataChanged();
            int n = this.data.indexOf(string);
            if (n >= 0) {
                this.selectionModel.setSelectionInterval(n, n);
            }
        }

        public void updatePath(int n, String string) {
            if (string == null) {
                return;
            }
            if (n < 0 || n >= this.getRowCount()) {
                return;
            }
            this.data.set(n, string);
            this.sort();
            this.fireTableDataChanged();
            int n2 = this.data.indexOf(string);
            if (n2 >= 0) {
                this.selectionModel.setSelectionInterval(n2, n2);
            }
        }

        public void removeSelected() {
            Iterator<String> iterator = this.data.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                iterator.next();
                if (this.selectionModel.isSelectedIndex(n)) {
                    iterator.remove();
                }
                ++n;
            }
            this.fireTableDataChanged();
            this.selectionModel.clearSelection();
        }

        protected void sort() {
            Collections.sort(this.data, new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    if (string.isEmpty() && string2.isEmpty()) {
                        return 0;
                    }
                    if (string.isEmpty()) {
                        return 1;
                    }
                    if (string2.isEmpty()) {
                        return -1;
                    }
                    return string.compareTo(string2);
                }
            });
        }

        public List<String> getIconPaths() {
            return new ArrayList<String>(this.data);
        }
    }

    class ReloadSourcesAction
    extends AbstractAction {
        private final String url;
        private final transient List<SourceProvider> sourceProviders;

        ReloadSourcesAction(String string, List<SourceProvider> list) {
            this.putValue("Name", I18n.tr("Reload", new Object[0]));
            this.putValue("ShortDescription", I18n.tr(SourceEditor.this.getStr(I18nString.RELOAD_ALL_AVAILABLE), string));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "refresh"));
            this.url = string;
            this.sourceProviders = list;
            this.setEnabled(!Main.isOffline(OnlineResource.JOSM_WEBSITE));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CachedFile.cleanup(this.url);
            SourceEditor.this.reloadAvailableSources(this.url, this.sourceProviders);
        }
    }

    class ResetAction
    extends AbstractAction {
        ResetAction() {
            this.putValue("Name", I18n.tr("Reset", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Reset to default", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("preferences", "reset"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SourceEditor.this.activeSourcesModel.setActiveSources(SourceEditor.this.getDefault());
        }
    }

    class ActivateSourcesAction
    extends AbstractAction
    implements ListSelectionListener {
        ActivateSourcesAction() {
            this.putValue("ShortDescription", SourceEditor.this.getStr(I18nString.ACTIVATE_TOOLTIP));
            this.putValue("SmallIcon", ImageProvider.get("preferences", "activate-right"));
            this.updateEnabledState();
        }

        protected final void updateEnabledState() {
            this.setEnabled(SourceEditor.this.lstAvailableSources.getSelectedIndices().length > 0);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            List<ExtendedSourceEntry> list = SourceEditor.this.availableSourcesModel.getSelected();
            int n = Version.getInstance().getVersion();
            if (n != 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (ExtendedSourceEntry extendedSourceEntry : list) {
                    if (extendedSourceEntry.minJosmVersion == null || extendedSourceEntry.minJosmVersion <= n) continue;
                    arrayList.add(I18n.tr("Entry ''{0}'' requires JOSM Version {1}. (Currently running: {2})", extendedSourceEntry.title, Integer.toString(extendedSourceEntry.minJosmVersion), Integer.toString(n)));
                }
                if (!arrayList.isEmpty()) {
                    ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Warning", new Object[0]), new String[]{I18n.tr("Cancel", new Object[0]), I18n.tr("Continue anyway", new Object[0])});
                    extendedDialog.setButtonIcons(new Icon[]{ImageProvider.get("cancel"), new ImageProvider("ok").setMaxSize(ImageProvider.ImageSizes.LARGEICON).addOverlay(new ImageOverlay(new ImageProvider("warning-small"), 0.5, 0.5, 1.0, 1.0)).get()});
                    extendedDialog.setToolTipTexts(new String[]{I18n.tr("Cancel and return to the previous dialog", new Object[0]), I18n.tr("Ignore warning and install style anyway", new Object[0])});
                    extendedDialog.setContent("<html>" + I18n.tr("Some entries have unmet dependencies:", new Object[0]) + "<br>" + Utils.join("<br>", arrayList) + "</html>");
                    extendedDialog.setIcon(2);
                    if (extendedDialog.showDialog().getValue() != 2) {
                        return;
                    }
                }
            }
            SourceEditor.this.activeSourcesModel.addExtendedSourceEntries(list);
        }
    }

    class MoveUpDownAction
    extends AbstractAction
    implements ListSelectionListener,
    TableModelListener {
        private final int increment;

        MoveUpDownAction(boolean bl) {
            this.increment = bl ? 1 : -1;
            this.putValue("SmallIcon", bl ? ImageProvider.get("dialogs", "down") : ImageProvider.get("dialogs", "up"));
            this.putValue("ShortDescription", bl ? I18n.tr("Move the selected entry one row down.", new Object[0]) : I18n.tr("Move the selected entry one row up.", new Object[0]));
            this.updateEnabledState();
        }

        public final void updateEnabledState() {
            this.setEnabled(SourceEditor.this.activeSourcesModel.canMove(this.increment));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SourceEditor.this.activeSourcesModel.move(this.increment);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            this.updateEnabledState();
        }
    }

    class EditActiveSourceAction
    extends AbstractAction
    implements ListSelectionListener {
        EditActiveSourceAction() {
            this.putValue("Name", I18n.tr("Edit", new Object[0]));
            this.putValue("ShortDescription", SourceEditor.this.getStr(I18nString.EDIT_SOURCE_TOOLTIP));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
            this.updateEnabledState();
        }

        protected final void updateEnabledState() {
            this.setEnabled(SourceEditor.this.tblActiveSources.getSelectedRowCount() == 1);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = SourceEditor.this.tblActiveSources.getSelectedRow();
            if (n < 0 || n >= SourceEditor.this.tblActiveSources.getRowCount()) {
                return;
            }
            SourceEntry sourceEntry = (SourceEntry)SourceEditor.this.activeSourcesModel.getValueAt(n, 1);
            EditSourceEntryDialog editSourceEntryDialog = new EditSourceEntryDialog(SourceEditor.this, I18n.tr("Edit source entry:", new Object[0]), sourceEntry);
            editSourceEntryDialog.showDialog();
            if (editSourceEntryDialog.getValue() == 1) {
                if (sourceEntry.title != null || !"".equals(editSourceEntryDialog.getTitle())) {
                    sourceEntry.title = editSourceEntryDialog.getTitle();
                    sourceEntry.title = SourceEditor.this.getTitleForSourceEntry(sourceEntry);
                }
                sourceEntry.url = editSourceEntryDialog.getURL();
                if (SourceEditor.this.canEnable) {
                    sourceEntry.active = editSourceEntryDialog.active();
                }
                SourceEditor.this.activeSourcesModel.fireTableRowsUpdated(n, n);
            }
        }
    }

    class RemoveActiveSourcesAction
    extends AbstractAction
    implements ListSelectionListener {
        RemoveActiveSourcesAction() {
            this.putValue("Name", I18n.tr("Remove", new Object[0]));
            this.putValue("ShortDescription", SourceEditor.this.getStr(I18nString.REMOVE_SOURCE_TOOLTIP));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.updateEnabledState();
        }

        protected final void updateEnabledState() {
            this.setEnabled(SourceEditor.this.tblActiveSources.getSelectedRowCount() > 0);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SourceEditor.this.activeSourcesModel.removeSelected();
        }
    }

    class NewActiveSourceAction
    extends AbstractAction {
        NewActiveSourceAction() {
            this.putValue("Name", I18n.tr("New", new Object[0]));
            this.putValue("ShortDescription", SourceEditor.this.getStr(I18nString.NEW_SOURCE_ENTRY_TOOLTIP));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "add"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EditSourceEntryDialog editSourceEntryDialog = new EditSourceEntryDialog(SourceEditor.this, SourceEditor.this.getStr(I18nString.NEW_SOURCE_ENTRY), null);
            editSourceEntryDialog.showDialog();
            if (editSourceEntryDialog.getValue() == 1) {
                boolean bl = true;
                if (SourceEditor.this.canEnable) {
                    bl = editSourceEntryDialog.active();
                }
                SourceEntry sourceEntry = new SourceEntry(editSourceEntryDialog.getURL(), null, editSourceEntryDialog.getTitle(), bl);
                sourceEntry.title = SourceEditor.this.getTitleForSourceEntry(sourceEntry);
                SourceEditor.this.activeSourcesModel.addSource(sourceEntry);
                SourceEditor.this.activeSourcesModel.fireTableDataChanged();
            }
        }
    }

    protected class EditSourceEntryDialog
    extends ExtendedDialog {
        private final JosmTextField tfTitle;
        private final JosmTextField tfURL;
        private JCheckBox cbActive;

        public EditSourceEntryDialog(Component component, String string, SourceEntry sourceEntry) {
            super(component, string, new String[]{I18n.tr("Ok", new Object[0]), I18n.tr("Cancel", new Object[0])});
            JPanel jPanel = new JPanel(new GridBagLayout());
            this.tfTitle = new JosmTextField(60);
            jPanel.add((Component)new JLabel(I18n.tr("Name (optional):", new Object[0])), GBC.std().insets(15, 0, 5, 5));
            jPanel.add((Component)this.tfTitle, GBC.eol().insets(0, 0, 5, 5));
            this.tfURL = new JosmTextField(60);
            jPanel.add((Component)new JLabel(I18n.tr("URL / File:", new Object[0])), GBC.std().insets(15, 0, 5, 0));
            jPanel.add((Component)this.tfURL, GBC.std().insets(0, 0, 5, 5));
            JButton jButton = new JButton(new LaunchFileChooserAction());
            jButton.setMargin(new Insets(0, 0, 0, 0));
            jPanel.add((Component)jButton, GBC.eol().insets(0, 0, 5, 5));
            if (sourceEntry != null) {
                if (sourceEntry.title != null) {
                    this.tfTitle.setText(sourceEntry.title);
                }
                this.tfURL.setText(sourceEntry.url);
            }
            if (SourceEditor.this.canEnable) {
                this.cbActive = new JCheckBox(I18n.tr("active", new Object[0]), sourceEntry == null || sourceEntry.active);
                jPanel.add((Component)this.cbActive, GBC.eol().insets(15, 0, 5, 0));
            }
            this.setButtonIcons(new String[]{"ok", "cancel"});
            this.setContent(jPanel);
            this.tfURL.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    EditSourceEntryDialog.this.updateOkButtonState();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    EditSourceEntryDialog.this.updateOkButtonState();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    EditSourceEntryDialog.this.updateOkButtonState();
                }
            });
        }

        private void updateOkButtonState() {
            ((JButton)this.buttons.get(0)).setEnabled(!Utils.strip(this.tfURL.getText()).isEmpty());
        }

        @Override
        public void setupDialog() {
            super.setupDialog();
            this.updateOkButtonState();
        }

        @Override
        public String getTitle() {
            return this.tfTitle.getText();
        }

        public String getURL() {
            return this.tfURL.getText();
        }

        public boolean active() {
            if (!SourceEditor.this.canEnable) {
                throw new UnsupportedOperationException();
            }
            return this.cbActive.isSelected();
        }

        class LaunchFileChooserAction
        extends AbstractAction {
            LaunchFileChooserAction() {
                this.putValue("SmallIcon", ImageProvider.get("open"));
                this.putValue("ShortDescription", I18n.tr("Launch a file chooser to select a file", new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExtensionFileFilter extensionFileFilter;
                switch (SourceEditor.this.sourceType) {
                    case MAP_PAINT_STYLE: {
                        extensionFileFilter = new ExtensionFileFilter("xml,mapcss,css,zip", "xml", I18n.tr("Map paint style file (*.xml, *.mapcss, *.zip)", new Object[0]));
                        break;
                    }
                    case TAGGING_PRESET: {
                        extensionFileFilter = new ExtensionFileFilter("xml,zip", "xml", I18n.tr("Preset definition file (*.xml, *.zip)", new Object[0]));
                        break;
                    }
                    case TAGCHECKER_RULE: {
                        extensionFileFilter = new ExtensionFileFilter("validator.mapcss,zip", "validator.mapcss", I18n.tr("Tag checker rule (*.validator.mapcss, *.zip)", new Object[0]));
                        break;
                    }
                    default: {
                        Main.error("Unsupported source type: " + (Object)((Object)SourceEditor.this.sourceType));
                        return;
                    }
                }
                FileChooserManager fileChooserManager = new FileChooserManager(true).createFileChooser(true, null, Arrays.asList(extensionFileFilter, FileFilterAllFiles.getInstance()), extensionFileFilter, 0);
                SourceEditor.prepareFileChooser(EditSourceEntryDialog.this.tfURL.getText(), fileChooserManager.getFileChooser());
                AbstractFileChooser abstractFileChooser = fileChooserManager.openFileChooser(GuiHelper.getFrameForComponent(SourceEditor.this));
                if (abstractFileChooser != null) {
                    EditSourceEntryDialog.this.tfURL.setText(abstractFileChooser.getSelectedFile().toString());
                }
            }
        }
    }

    public static class ExtendedSourceEntry
    extends SourceEntry
    implements Comparable<ExtendedSourceEntry> {
        public String simpleFileName;
        public String version;
        public String author;
        public String link;
        public String description;
        public String styleType;
        public Integer minJosmVersion;

        public ExtendedSourceEntry(String string, String string2) {
            super(string2, null, null, true);
            this.simpleFileName = string;
        }

        public String getDisplayName() {
            return this.title == null ? this.simpleFileName : this.title;
        }

        private static void appendRow(StringBuilder stringBuilder, String string, String string2) {
            stringBuilder.append("<tr><th>").append(string).append("</th><td>").append(string2).append("</td</tr>");
        }

        public String getTooltip() {
            StringBuilder stringBuilder = new StringBuilder();
            ExtendedSourceEntry.appendRow(stringBuilder, I18n.tr("Short Description:", new Object[0]), this.getDisplayName());
            ExtendedSourceEntry.appendRow(stringBuilder, I18n.tr("URL:", new Object[0]), this.url);
            if (this.author != null) {
                ExtendedSourceEntry.appendRow(stringBuilder, I18n.tr("Author:", new Object[0]), this.author);
            }
            if (this.link != null) {
                ExtendedSourceEntry.appendRow(stringBuilder, I18n.tr("Webpage:", new Object[0]), this.link);
            }
            if (this.description != null) {
                ExtendedSourceEntry.appendRow(stringBuilder, I18n.tr("Description:", new Object[0]), this.description);
            }
            if (this.version != null) {
                ExtendedSourceEntry.appendRow(stringBuilder, I18n.tr("Version:", new Object[0]), this.version);
            }
            if (this.minJosmVersion != null) {
                ExtendedSourceEntry.appendRow(stringBuilder, I18n.tr("Minimum JOSM Version:", new Object[0]), Integer.toString(this.minJosmVersion));
            }
            return "<html><style>th{text-align:right}td{width:400px}</style><table>" + stringBuilder + "</table></html>";
        }

        @Override
        public String toString() {
            return "<html><b>" + this.getDisplayName() + "</b>" + (this.author == null ? "" : " <span color=\"gray\">" + I18n.tr("by {0}", this.author) + "</color>") + "</html>";
        }

        @Override
        public int compareTo(ExtendedSourceEntry extendedSourceEntry) {
            if (this.url.startsWith("resource") && !extendedSourceEntry.url.startsWith("resource")) {
                return -1;
            }
            if (extendedSourceEntry.url.startsWith("resource")) {
                return 1;
            }
            return this.getDisplayName().compareToIgnoreCase(extendedSourceEntry.getDisplayName());
        }
    }

    protected class ActiveSourcesModel
    extends AbstractTableModel {
        private transient List<SourceEntry> data;
        private final DefaultListSelectionModel selectionModel;

        public ActiveSourcesModel(DefaultListSelectionModel defaultListSelectionModel) {
            this.selectionModel = defaultListSelectionModel;
            this.data = new ArrayList<SourceEntry>();
        }

        @Override
        public int getColumnCount() {
            return SourceEditor.this.canEnable ? 2 : 1;
        }

        @Override
        public int getRowCount() {
            return this.data == null ? 0 : this.data.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (SourceEditor.this.canEnable && n2 == 0) {
                return this.data.get((int)n).active;
            }
            return this.data.get(n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return SourceEditor.this.canEnable && n2 == 0;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (SourceEditor.this.canEnable && n == 0) {
                return Boolean.class;
            }
            return SourceEntry.class;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n < 0 || n >= this.getRowCount() || object == null) {
                return;
            }
            if (SourceEditor.this.canEnable && n2 == 0) {
                this.data.get((int)n).active = !this.data.get((int)n).active;
            }
        }

        public void setActiveSources(Collection<? extends SourceEntry> collection) {
            this.data.clear();
            if (collection != null) {
                for (SourceEntry sourceEntry : collection) {
                    this.data.add(new SourceEntry(sourceEntry));
                }
            }
            this.fireTableDataChanged();
        }

        public void addSource(SourceEntry sourceEntry) {
            if (sourceEntry == null) {
                return;
            }
            this.data.add(sourceEntry);
            this.fireTableDataChanged();
            int n = this.data.indexOf(sourceEntry);
            if (n >= 0) {
                this.selectionModel.setSelectionInterval(n, n);
            }
        }

        public void removeSelected() {
            Iterator<SourceEntry> iterator = this.data.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                iterator.next();
                if (this.selectionModel.isSelectedIndex(n)) {
                    iterator.remove();
                }
                ++n;
            }
            this.fireTableDataChanged();
        }

        public void removeIdxs(Collection<Integer> collection) {
            ArrayList<SourceEntry> arrayList = new ArrayList<SourceEntry>();
            for (int i = 0; i < this.data.size(); ++i) {
                if (collection.contains(i)) continue;
                arrayList.add(this.data.get(i));
            }
            this.data = arrayList;
            this.fireTableDataChanged();
        }

        public void addExtendedSourceEntries(List<ExtendedSourceEntry> list) {
            if (list == null) {
                return;
            }
            for (ExtendedSourceEntry extendedSourceEntry : list) {
                this.data.add(new SourceEntry(extendedSourceEntry.url, extendedSourceEntry.name, extendedSourceEntry.getDisplayName(), true));
            }
            this.fireTableDataChanged();
            this.selectionModel.clearSelection();
            for (ExtendedSourceEntry extendedSourceEntry : list) {
                int n = this.data.indexOf(extendedSourceEntry);
                if (n < 0) continue;
                this.selectionModel.addSelectionInterval(n, n);
            }
        }

        public List<SourceEntry> getSources() {
            return new ArrayList<SourceEntry>(this.data);
        }

        public boolean canMove(int n) {
            int[] nArray = SourceEditor.this.tblActiveSources.getSelectedRows();
            if (nArray.length == 0) {
                return false;
            }
            if (n < 0) {
                return nArray[0] >= -n;
            }
            if (n > 0) {
                return nArray[nArray.length - 1] <= this.getRowCount() - 1 - n;
            }
            return true;
        }

        public void move(int n) {
            int[] nArray;
            if (!this.canMove(n)) {
                return;
            }
            for (int n2 : nArray = SourceEditor.this.tblActiveSources.getSelectedRows()) {
                SourceEntry sourceEntry = this.data.get(n2);
                SourceEntry sourceEntry2 = this.data.get(n2 + n);
                this.data.set(n2, sourceEntry2);
                this.data.set(n2 + n, sourceEntry);
            }
            this.selectionModel.clearSelection();
            for (int n2 : nArray) {
                this.selectionModel.addSelectionInterval(n2 + n, n2 + n);
            }
        }
    }

    protected static class AvailableSourcesListModel
    extends DefaultListModel<ExtendedSourceEntry> {
        private final transient List<ExtendedSourceEntry> data = new ArrayList<ExtendedSourceEntry>();
        private final DefaultListSelectionModel selectionModel;

        public AvailableSourcesListModel(DefaultListSelectionModel defaultListSelectionModel) {
            this.selectionModel = defaultListSelectionModel;
        }

        public void setSources(List<ExtendedSourceEntry> list) {
            this.data.clear();
            if (list != null) {
                this.data.addAll(list);
            }
            this.fireContentsChanged(this, 0, this.data.size());
        }

        @Override
        public ExtendedSourceEntry getElementAt(int n) {
            return this.data.get(n);
        }

        @Override
        public int getSize() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        public void deleteSelected() {
            Iterator<ExtendedSourceEntry> iterator = this.data.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                iterator.next();
                if (this.selectionModel.isSelectedIndex(n)) {
                    iterator.remove();
                }
                ++n;
            }
            this.fireContentsChanged(this, 0, this.data.size());
        }

        public List<ExtendedSourceEntry> getSelected() {
            ArrayList<ExtendedSourceEntry> arrayList = new ArrayList<ExtendedSourceEntry>();
            for (int i = 0; i < this.data.size(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                arrayList.add(this.data.get(i));
            }
            return arrayList;
        }
    }

    public static enum I18nString {
        AVAILABLE_SOURCES,
        ACTIVE_SOURCES,
        NEW_SOURCE_ENTRY_TOOLTIP,
        NEW_SOURCE_ENTRY,
        REMOVE_SOURCE_TOOLTIP,
        EDIT_SOURCE_TOOLTIP,
        ACTIVATE_TOOLTIP,
        RELOAD_ALL_AVAILABLE,
        LOADING_SOURCES_FROM,
        FAILED_TO_LOAD_SOURCES_FROM,
        FAILED_TO_LOAD_SOURCES_FROM_HELP_TOPIC,
        ILLEGAL_FORMAT_OF_ENTRY;

    }
}

