/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.ac;

import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.im.InputContext;
import java.util.Collection;
import java.util.Locale;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyleConstants;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionItemPriority;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionListItem;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.tools.Utils;

public class AutoCompletingComboBox
extends JosmComboBox<AutoCompletionListItem> {
    private boolean autocompleteEnabled = true;
    private int maxTextLength = -1;
    private boolean useFixedLocale;
    private final InputContext privateInputContext = InputContext.getInstance();

    public AutoCompletingComboBox() {
        this("Foo");
    }

    public AutoCompletingComboBox(String string) {
        super(new AutoCompletionListItem(string));
        this.setRenderer(new AutoCompleteListCellRenderer());
        final JTextField jTextField = this.getEditorComponent();
        ((JTextComponent)jTextField).setDocument(new AutoCompletingComboBoxDocument(this));
        jTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (Main.map != null) {
                    Main.map.keyDetector.setEnabled(true);
                }
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                Clipboard clipboard;
                if (Main.map != null) {
                    Main.map.keyDetector.setEnabled(false);
                }
                if ((clipboard = GuiHelper.getSystemSelection()) != null) {
                    Transferable transferable = Utils.getTransferableContent(clipboard);
                    jTextField.selectAll();
                    if (transferable != null) {
                        clipboard.setContents(transferable, null);
                    }
                } else {
                    jTextField.selectAll();
                }
            }
        });
    }

    public void setMaxTextLength(int n) {
        this.maxTextLength = n;
    }

    @Override
    public void configureEditor(ComboBoxEditor comboBoxEditor, Object object) {
        if (object == null) {
            comboBoxEditor.setItem(null);
        } else if (object instanceof String) {
            comboBoxEditor.setItem(object);
        } else if (object instanceof AutoCompletionListItem) {
            comboBoxEditor.setItem(((AutoCompletionListItem)object).getValue());
        } else {
            throw new IllegalArgumentException("Unsupported item: " + object);
        }
    }

    @Override
    public void setSelectedItem(Object object) {
        if (object == null) {
            super.setSelectedItem(null);
        } else if (object instanceof AutoCompletionListItem) {
            super.setSelectedItem(object);
        } else if (object instanceof String) {
            String string = (String)object;
            for (int i = 0; i < this.getModel().getSize(); ++i) {
                AutoCompletionListItem autoCompletionListItem = (AutoCompletionListItem)this.getModel().getElementAt(i);
                if (!string.equals(autoCompletionListItem.getValue())) continue;
                super.setSelectedItem(autoCompletionListItem);
                return;
            }
            super.setSelectedItem(new AutoCompletionListItem(string, AutoCompletionItemPriority.UNKNOWN));
        } else {
            throw new IllegalArgumentException("Unsupported item: " + object);
        }
    }

    public void setPossibleItems(Collection<String> collection) {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.getModel();
        Object object = this.getEditor().getItem();
        defaultComboBoxModel.removeAllElements();
        for (String string : collection) {
            defaultComboBoxModel.addElement(new AutoCompletionListItem(string, AutoCompletionItemPriority.UNKNOWN));
        }
        this.autocompleteEnabled = false;
        this.getEditor().setItem(object);
        this.autocompleteEnabled = true;
    }

    public void setPossibleACItems(Collection<AutoCompletionListItem> collection) {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.getModel();
        Object object = this.getSelectedItem();
        Object object2 = this.getEditor().getItem();
        defaultComboBoxModel.removeAllElements();
        for (AutoCompletionListItem autoCompletionListItem : collection) {
            defaultComboBoxModel.addElement(autoCompletionListItem);
        }
        this.setSelectedItem(object);
        this.getEditor().setItem(object2);
    }

    public final boolean isAutocompleteEnabled() {
        return this.autocompleteEnabled;
    }

    protected void setAutocompleteEnabled(boolean bl) {
        this.autocompleteEnabled = bl;
    }

    public void setFixedLocale(boolean bl) {
        this.useFixedLocale = bl;
        if (this.useFixedLocale) {
            Locale locale = this.privateInputContext.getLocale();
            Main.info("Using English input method");
            if (!this.privateInputContext.selectInputMethod(new Locale("en", "US"))) {
                Main.warn("Unable to use English input method");
                this.useFixedLocale = false;
                if (locale != null) {
                    Main.info("Restoring input method to " + locale);
                    if (!this.privateInputContext.selectInputMethod(locale)) {
                        Main.warn("Unable to restore input method to " + locale);
                    }
                }
            }
        }
    }

    @Override
    public InputContext getInputContext() {
        if (this.useFixedLocale) {
            return this.privateInputContext;
        }
        return super.getInputContext();
    }

    public static class AutoCompleteListCellRenderer
    extends JLabel
    implements ListCellRenderer<AutoCompletionListItem> {
        public AutoCompleteListCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends AutoCompletionListItem> jList, AutoCompletionListItem autoCompletionListItem, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setText(autoCompletionListItem.getValue());
            return this;
        }
    }

    class AutoCompletingComboBoxDocument
    extends PlainDocument {
        private final JosmComboBox<AutoCompletionListItem> comboBox;
        private boolean selecting;

        AutoCompletingComboBoxDocument(JosmComboBox<AutoCompletionListItem> josmComboBox) {
            this.comboBox = josmComboBox;
        }

        @Override
        public void remove(int n, int n2) throws BadLocationException {
            if (this.selecting) {
                return;
            }
            super.remove(n, n2);
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            Object object;
            int n2;
            if (this.selecting || n == 0 && string.equals(this.getText(0, this.getLength()))) {
                return;
            }
            if (AutoCompletingComboBox.this.maxTextLength > -1 && string.length() + this.getLength() > AutoCompletingComboBox.this.maxTextLength) {
                return;
            }
            boolean bl = n == 0 && this.getLength() == 0 && string.length() > 1;
            super.insertString(n, string, attributeSet);
            if (this.selecting) {
                return;
            }
            if (!AutoCompletingComboBox.this.autocompleteEnabled) {
                return;
            }
            if (attributeSet != null && attributeSet.isDefined(StyleConstants.ComposedTextAttribute)) {
                return;
            }
            if (n + string.length() < this.getLength()) {
                return;
            }
            int n3 = this.getLength();
            int n4 = n2 = n + string.length();
            String string2 = this.getText(0, n3);
            Object object2 = null;
            if (Main.pref.getBoolean("autocomplete.dont_complete_numbers", true)) {
                try {
                    Long.parseLong(string);
                    if (!string2.isEmpty()) {
                        Long.parseLong(string2);
                    }
                    object2 = this.lookupItem(string2, true);
                }
                catch (NumberFormatException numberFormatException) {
                    object2 = this.lookupItem(string2, false);
                }
            } else {
                object2 = this.lookupItem(string2, false);
            }
            this.setSelectedItem(object2);
            if (bl) {
                n2 = 0;
            }
            if (object2 != null && !((String)(object = ((AutoCompletionListItem)object2).getValue())).equals(string2)) {
                this.selecting = true;
                super.remove(0, n3);
                super.insertString(0, (String)object, attributeSet);
                this.selecting = false;
                n2 = n3;
                n4 = this.getLength();
            }
            object = this.comboBox.getEditorComponent();
            Clipboard clipboard = GuiHelper.getSystemSelection();
            if (clipboard != null) {
                Transferable transferable = Utils.getTransferableContent(clipboard);
                ((JTextComponent)object).select(n2, n4);
                if (transferable != null) {
                    clipboard.setContents(transferable, null);
                }
            } else {
                ((JTextComponent)object).select(n2, n4);
            }
        }

        private void setSelectedItem(Object object) {
            this.selecting = true;
            this.comboBox.setSelectedItem(object);
            this.selecting = false;
        }

        private Object lookupItem(String string, boolean bl) {
            ComboBoxModel comboBoxModel = this.comboBox.getModel();
            AutoCompletionListItem autoCompletionListItem = null;
            int n = comboBoxModel.getSize();
            for (int i = 0; i < n; ++i) {
                AutoCompletionListItem autoCompletionListItem2 = (AutoCompletionListItem)comboBoxModel.getElementAt(i);
                if (autoCompletionListItem2.getValue().equals(string)) {
                    return autoCompletionListItem2;
                }
                if (bl || !autoCompletionListItem2.getValue().startsWith(string) || autoCompletionListItem != null && autoCompletionListItem2.getPriority().compareTo(autoCompletionListItem.getPriority()) <= 0) continue;
                autoCompletionListItem = autoCompletionListItem2;
            }
            return autoCompletionListItem;
        }
    }
}

