# -*- coding: iso-8859-1 -*-
# -----------------------------------------------------------------------
# ListItem.py - the primary component of a ListBox
# -----------------------------------------------------------------------
# $Id: ListItem.py 10845 2008-07-09 20:09:41Z duncan $
#
# Notes:
# Todo:
#
# -----------------------------------------------------------------------
# Freevo - A Home Theater PC framework
# Copyright (C) 2003 Krister Lagerstrom, et al.
# Please see the file freevo/Docs/CREDITS for a complete list of authors.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MER-
# CHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
# Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#
# -----------------------------------------------------------------------


import config

from GUIObject import *
from Button    import *


class ListItem(Button):
    """
    width     Integer
    height    Integer
    text      Letter to hold.
    bg_color  Background color (Color)
    fg_color  Foreground color (Color)
    border    Border
    bd_color  Border color (Color)
    bd_width  Border width Integer
    """


    def __init__(self, text=' ', value=None, width=75, height=None,
                 bg_color=None, fg_color=None, selected_bg_color=None,
                 selected_fg_color=None, border=None, bd_color=None,
                 bd_width=None, h_margin=None):

        handler = None
        left = 0
        top = 0
        rect = pygame.Rect((left, top), (width, height))

        Button.__init__(self, text, handler, left, top, width, height, bg_color,
                        fg_color, selected_bg_color, selected_fg_color,
                        border, bd_color, bd_width)

        self.value = value
        if h_margin:
            self.h_margin = h_margin
        else:
            self.h_margin = 20

        self.v_margin = 2
        self.label.set_v_align(Align.CENTER)
        self.label.set_h_align(Align.LEFT)


    def _draw(self, surface=None):
        if not self.width or not self.height or not self.text:
            raise TypeError, 'Not all needed variables set.'

        if self.selected:
            c = self.selected_bg_color.get_color_sdl()
            a = self.selected_bg_color.get_alpha()
        else:
            c = self.bg_color.get_color_sdl()
            a = self.bg_color.get_alpha()

        self.surface = self.osd.Surface(self.get_size(), 0, 32)
        self.surface.fill(c)
        self.surface.set_alpha(a)

        Container._draw(self)

        self.parent.region_surface.blit(self.surface, self.get_position())
