/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.gsp.io;

import grails.core.GrailsApplication;
import grails.core.GrailsClass;
import grails.core.GrailsControllerClass;
import grails.core.support.GrailsApplicationAware;
import grails.util.GrailsNameUtils;
import grails.web.mime.MimeType;
import grails.web.mime.MimeTypeResolver;
import grails.web.pages.GroovyPagesUriService;
import javax.servlet.http.HttpServletRequest;
import org.grails.gsp.io.DefaultGroovyPageLocator;
import org.grails.gsp.io.GroovyPageScriptSource;
import org.grails.io.support.GrailsResourceUtils;
import org.grails.taglib.TemplateVariableBinding;
import org.grails.web.pages.DefaultGroovyPagesUriService;
import org.grails.web.servlet.mvc.GrailsWebRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class GrailsConventionGroovyPageLocator
extends DefaultGroovyPageLocator
implements GrailsApplicationAware {
    private static final char DOT = '.';
    private GroovyPagesUriService uriService = new DefaultGroovyPagesUriService();
    private MimeTypeResolver mimeTypeResolver;
    private GrailsApplication grailsApplication;

    @Autowired(required=false)
    public void setMimeTypeResolver(MimeTypeResolver mimeTypeResolver) {
        this.mimeTypeResolver = mimeTypeResolver;
    }

    public GroovyPageScriptSource findViewByPath(String uri) {
        return uri == null ? null : this.findPage(this.uriService.getAbsoluteViewURI(uri));
    }

    public GroovyPageScriptSource findView(String controllerName, String viewName) {
        return this.findView(controllerName, viewName, this.lookupRequestFormat());
    }

    public GroovyPageScriptSource findView(String controllerName, String viewName, String format) {
        GroovyPageScriptSource scriptSource = this.findViewForFormat(controllerName, viewName, format);
        if (scriptSource == null) {
            scriptSource = this.findPage(this.uriService.getViewURI(controllerName, viewName));
        }
        return scriptSource;
    }

    public GroovyPageScriptSource findViewForFormat(String controllerName, String viewName, String format) {
        String viewNameWithFormat = this.getViewNameWithFormat(viewName, format);
        return this.findPage(this.uriService.getViewURI(controllerName, viewNameWithFormat));
    }

    public String resolveViewFormat(String viewName) {
        String format = this.lookupRequestFormat();
        return this.getViewNameWithFormat(viewName, format);
    }

    private String getViewNameWithFormat(String viewName, String format) {
        if (format == null || format.equals("all")) {
            return viewName;
        }
        return viewName + '.' + format;
    }

    public GroovyPageScriptSource findView(Object controller, String viewName) {
        String pathToView;
        GrailsControllerClass gcc;
        String namespace;
        GrailsClass controllerArtefact;
        if (controller == null || viewName == null) {
            return null;
        }
        String controllerName = this.getNameForController(controller);
        String viewNameWithFormat = this.resolveViewFormat(viewName);
        GroovyPageScriptSource scriptSource = null;
        String controllerClassName = GrailsNameUtils.getFullClassName(controller.getClass());
        GrailsClass grailsClass = controllerArtefact = this.grailsApplication != null ? this.grailsApplication.getArtefact("Controller", controllerClassName) : null;
        if (controllerArtefact instanceof GrailsControllerClass && (namespace = (gcc = (GrailsControllerClass)controllerArtefact).getNamespace()) != null && (scriptSource = this.findPage("/" + namespace + this.uriService.getViewURI(controllerName, viewNameWithFormat))) == null) {
            scriptSource = this.findPage("/" + namespace + this.uriService.getViewURI(controllerName, viewName));
        }
        if (scriptSource == null) {
            scriptSource = this.findPage(this.uriService.getViewURI(controllerName, viewNameWithFormat));
        }
        if (scriptSource == null) {
            scriptSource = this.findPage(this.uriService.getViewURI(controllerName, viewName));
        }
        if (scriptSource == null && this.pluginManager != null && (pathToView = this.pluginManager.getPluginViewsPathForInstance(controller)) != null) {
            scriptSource = this.findViewByPath(GrailsResourceUtils.appendPiecesForUri((String[])new String[]{pathToView, viewName}));
        }
        if (scriptSource == null) {
            scriptSource = this.findView(controllerName, viewName);
        }
        return scriptSource;
    }

    public GroovyPageScriptSource findTemplate(String controllerName, String templateName) {
        return this.findPage(this.uriService.getTemplateURI(controllerName, templateName));
    }

    public GroovyPageScriptSource findTemplate(Object controller, String templateName) {
        GrailsControllerClass gcc;
        String namespace;
        GrailsClass controllerArtefact;
        String controllerName = this.getNameForController(controller);
        GroovyPageScriptSource scriptSource = null;
        String templateURI = this.uriService.getTemplateURI(controllerName, templateName);
        String fullClassName = GrailsNameUtils.getFullClassName(controller.getClass());
        GrailsClass grailsClass = controllerArtefact = this.grailsApplication != null ? this.grailsApplication.getArtefact("Controller", fullClassName) : null;
        if (controllerArtefact instanceof GrailsControllerClass && (namespace = (gcc = (GrailsControllerClass)controllerArtefact).getNamespace()) != null) {
            scriptSource = this.findPage("/" + namespace + templateURI);
        }
        if (scriptSource == null) {
            scriptSource = this.findPage(templateURI);
        }
        return scriptSource;
    }

    public GroovyPageScriptSource findView(String viewName) {
        GrailsWebRequest webRequest = GrailsWebRequest.lookup();
        if (webRequest == null) {
            return this.findViewByPath(viewName);
        }
        return this.findView(webRequest.getControllerName(), viewName);
    }

    public GroovyPageScriptSource findTemplate(String templateName) {
        GrailsWebRequest webRequest = GrailsWebRequest.lookup();
        if (webRequest == null) {
            return this.findTemplateByPath(templateName);
        }
        return this.findTemplate(webRequest.getControllerName(), templateName);
    }

    public GroovyPageScriptSource findTemplateInBinding(Object controller, String templateName, TemplateVariableBinding binding) {
        return this.findTemplateInBinding(controller, null, templateName, binding);
    }

    public GroovyPageScriptSource findTemplateInBinding(Object controller, String pluginName, String templateName, TemplateVariableBinding binding) {
        String templateURI;
        if (controller == null) {
            GrailsWebRequest webRequest = GrailsWebRequest.lookup();
            if (webRequest == null) {
                return this.findPageInBinding(pluginName, this.uriService.getAbsoluteTemplateURI(templateName), binding);
            }
            return this.findPageInBinding(pluginName, this.uriService.getTemplateURI(webRequest.getControllerName(), templateName), binding);
        }
        GrailsControllerClass controllerClass = (GrailsControllerClass)this.grailsApplication.getArtefact("Controller", GrailsNameUtils.getFullClassName(controller.getClass()));
        String ns = controllerClass.getNamespace();
        GroovyPageScriptSource scriptSource = null;
        String controllerName = controllerClass.getLogicalPropertyName();
        if (ns != null) {
            templateURI = '/' + ns + this.uriService.getTemplateURI(controllerName, templateName);
            scriptSource = this.findPageInBinding(pluginName, templateURI, binding);
        }
        if (scriptSource == null) {
            templateURI = this.uriService.getTemplateURI(controllerName, templateName);
            scriptSource = this.findPageInBinding(pluginName, templateURI, binding);
        }
        return scriptSource;
    }

    public GroovyPageScriptSource findTemplateInBinding(String templateName, TemplateVariableBinding binding) {
        GrailsWebRequest webRequest = GrailsWebRequest.lookup();
        if (webRequest == null) {
            return this.findPageInBinding(this.uriService.getAbsoluteTemplateURI(templateName), binding);
        }
        return this.findPageInBinding(this.uriService.getTemplateURI(webRequest.getControllerName(), templateName), binding);
    }

    public GroovyPageScriptSource findTemplateInBinding(String pluginName, String templateName, TemplateVariableBinding binding) {
        GrailsWebRequest webRequest = GrailsWebRequest.lookup();
        if (webRequest == null) {
            return this.findPageInBinding(pluginName, this.uriService.getAbsoluteTemplateURI(templateName), binding);
        }
        return this.findPageInBinding(pluginName, this.uriService.getTemplateURI(webRequest.getControllerName(), templateName), binding);
    }

    public GroovyPageScriptSource findTemplateByPath(String uri) {
        return this.findPage(this.uriService.getAbsoluteTemplateURI(uri));
    }

    protected String lookupRequestFormat() {
        if (this.mimeTypeResolver != null) {
            MimeType mimeType = this.mimeTypeResolver.resolveResponseMimeType();
            if (mimeType != null) {
                return mimeType.getExtension();
            }
        } else {
            GrailsWebRequest webRequest = GrailsWebRequest.lookup();
            if (webRequest != null) {
                HttpServletRequest request = webRequest.getCurrentRequest();
                Object format = request.getAttribute("org.grails.RESPONSE_FORMAT");
                return format == null ? null : format.toString();
            }
        }
        return null;
    }

    protected String getNameForController(Object controller) {
        Class<?> cls = controller.getClass();
        return GrailsNameUtils.getLogicalPropertyName((String)GrailsNameUtils.getFullClassName(cls), (String)"Controller");
    }

    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }
}

