// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Geom_Geometry_HeaderFile
#define _Geom_Geometry_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_Geom_Geometry.hxx>

#include <MMgt_TShared.hxx>
#include <Standard_Real.hxx>
class Standard_ConstructionError;
class gp_Pnt;
class gp_Ax1;
class gp_Ax2;
class gp_Vec;
class gp_Trsf;


//! The abstract class Geometry for 3D space is the root
//! class of all geometric objects from the Geom
//! package. It describes the common behavior of these objects when:
//! - applying geometric transformations to objects, and
//! - constructing objects by geometric transformation (including copying).
//! Warning
//! Only transformations which do not modify the nature
//! of the geometry can be applied to Geom objects: this
//! is the case with translations, rotations, symmetries
//! and scales; this is also the case with gp_Trsf
//! composite transformations which are used to define
//! the geometric transformations applied using the
//! Transform or Transformed functions.
//! Note: Geometry defines the "prototype" of the
//! abstract method Transform which is defined for each
//! concrete type of derived object. All other
//! transformations are implemented using the Transform method.
class Geom_Geometry : public MMgt_TShared
{

public:

  

  //! Performs the symmetrical transformation of a Geometry
  //! with respect to the point P which is the center of the
  //! symmetry.
  Standard_EXPORT   void Mirror (const gp_Pnt& P) ;
  

  //! Performs the symmetrical transformation of a Geometry
  //! with respect to an axis placement which is the axis of the
  //! symmetry.
  Standard_EXPORT   void Mirror (const gp_Ax1& A1) ;
  

  //! Performs the symmetrical transformation of a Geometry
  //! with respect to a plane. The axis placement A2 locates
  //! the plane of the symmetry : (Location, XDirection, YDirection).
  Standard_EXPORT   void Mirror (const gp_Ax2& A2) ;
  

  //! Rotates a Geometry. A1 is the axis of the rotation.
  //! Ang is the angular value of the rotation in radians.
  Standard_EXPORT   void Rotate (const gp_Ax1& A1, const Standard_Real Ang) ;
  

  //! Scales a Geometry. S is the scaling value.
  Standard_EXPORT   void Scale (const gp_Pnt& P, const Standard_Real S) ;
  

  //! Translates a Geometry.  V is the vector of the tanslation.
  Standard_EXPORT   void Translate (const gp_Vec& V) ;
  

  //! Translates a Geometry from the point P1 to the point P2.
  Standard_EXPORT   void Translate (const gp_Pnt& P1, const gp_Pnt& P2) ;
  

  //! Transformation of a geometric object. This tansformation
  //! can be a translation, a rotation, a symmetry, a scaling
  //! or a complex transformation obtained by combination of
  //! the previous elementaries transformations.
  //! (see class Transformation of the package Geom).
  Standard_EXPORT virtual   void Transform (const gp_Trsf& T)  = 0;
  
  Standard_EXPORT   Handle(Geom_Geometry) Mirrored (const gp_Pnt& P)  const;
  
  Standard_EXPORT   Handle(Geom_Geometry) Mirrored (const gp_Ax1& A1)  const;
  
  Standard_EXPORT   Handle(Geom_Geometry) Mirrored (const gp_Ax2& A2)  const;
  
  Standard_EXPORT   Handle(Geom_Geometry) Rotated (const gp_Ax1& A1, const Standard_Real Ang)  const;
  
  Standard_EXPORT   Handle(Geom_Geometry) Scaled (const gp_Pnt& P, const Standard_Real S)  const;
  
  Standard_EXPORT   Handle(Geom_Geometry) Transformed (const gp_Trsf& T)  const;
  
  Standard_EXPORT   Handle(Geom_Geometry) Translated (const gp_Vec& V)  const;
  
  Standard_EXPORT   Handle(Geom_Geometry) Translated (const gp_Pnt& P1, const gp_Pnt& P2)  const;
  
  //! Creates a new object which is a copy of this geometric object.
  Standard_EXPORT virtual   Handle(Geom_Geometry) Copy()  const = 0;




  DEFINE_STANDARD_RTTI(Geom_Geometry)

protected:




private: 




};







#endif // _Geom_Geometry_HeaderFile
