#ifndef EFL_GENERATED_ELM_COLOR_ITEM_HH
#define EFL_GENERATED_ELM_COLOR_ITEM_HH

extern "C"
{
#include <Efl.h>
}
#include <Eo.hh>

#include <eo_cxx_interop.hh>

extern "C"
{
#include "elm_color_item.eo.h"
}

#include "elm_widget_item.eo.hh"

namespace elm {

struct color_item;

}

/// @cond EO_CXX_ABSTRACT
namespace eo_cxx {

namespace elm {

struct color_item
{
   void color_get(int* r_, int* g_, int* b_, int* a_) const;

   void color_set(int r_, int g_, int b_, int a_) const;

   bool selected_get() const;

   void selected_set(bool selected_) const;



   static Eo_Class const* _eo_class()
   {
      return(ELM_COLOR_ITEM_CLASS);
   }

   operator ::elm::color_item() const;
   operator ::elm::color_item&();
   operator ::elm::color_item const&() const;

   /// @cond LOCAL
   template <typename D>
   struct address_of
   {
      operator ::elm::color_item*() const { return static_cast<::elm::color_item*>(static_cast<D const*>(this)->p); }
      operator ::elm::color_item const*() const { return static_cast<::elm::color_item const*>(static_cast<D const*>(this)->p); }
   };

   template <typename D>
   struct address_const_of
   {
      operator ::elm::color_item const*() const { return static_cast<::elm::color_item const*>(static_cast<D const*>(this)->p); }
   };
   /// @endcond

private:

   /// @internal
   Eo* _concrete_eo_ptr() const
   {
      return static_cast<::efl::eo::concrete const*>(static_cast<void const*>(this))->_eo_ptr();
   }

};

}

}
/// @endcond

namespace elm {

/// @brief Class color_item
struct color_item
      : ::efl::eo::concrete
      , EO_CXX_INHERIT(elm::widget_item)
      , EO_CXX_INHERIT(elm_interface_atspi_accessible)
      , EO_CXX_INHERIT(elm_interface_atspi_component)
      , EO_CXX_INHERIT(eo::base)
{
   //@{
   /**
      @brief Constructs a new elm::color_item object.

      Constructs a new elm::color_item object. If you want this object to be a child
      of another Eo object, use an @ref efl::eo::parent expression, like the example.

      Example:
      @code
      elm::color_item my_color_item(efl::eo::parent = parent_object);
      @endcode

      @see color_item(Eo* eo)
   */
   explicit color_item(::efl::eo::parent_type _p)
      : color_item(_ctors_call(_p))
   {}

   explicit color_item()
      : color_item(_ctors_call(::efl::eo::parent = nullptr))
   {}
   //@}

   /// @brief Eo Constructor.
   ///
   /// Constructs the object from an Eo* pointer stealing its ownership.
   ///
   /// @param eo The Eo object pointer.
   ///
   explicit color_item(Eo* eo)
      : ::efl::eo::concrete(eo)
   {}

   /// @brief nullptr_t Constructor.
   ///
   /// Constructs an empty (null) object.
   ///
   explicit color_item(std::nullptr_t)
      : ::efl::eo::concrete(nullptr)
   {}

   /// @brief Copy Constructor.
   ///
   color_item(color_item const& other)
      : color_item(eo_ref(other._eo_ptr()))
   {}

   ~color_item() {}

   void color_get(int* r_, int* g_, int* b_, int* a_) const;

   void color_set(int r_, int g_, int b_, int a_) const;

   bool selected_get() const;

   void selected_set(bool selected_) const;

   template <typename F>
   ::efl::eo::signal_connection
   callback_active_descendant_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_ACTIVE_DESCENDANT_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::color_item, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::color_item, function_type>,
         ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_ACTIVE_DESCENDANT_CHANGED );
   }

   template <typename T>
   void
   callback_active_descendant_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_ACTIVE_DESCENDANT_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_added_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_ADDED, priority_,
            &::efl::eo::_detail::event_callback<::elm::color_item, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::color_item, function_type>,
         ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_ADDED );
   }

   template <typename T>
   void
   callback_added_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_ADDED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_callback_add_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EO_BASE_EVENT_CALLBACK_ADD, priority_,
            &::efl::eo::_detail::event_callback<::elm::color_item, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::color_item, function_type>,
         EO_BASE_EVENT_CALLBACK_ADD );
   }

   template <typename T>
   void
   callback_callback_add_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EO_BASE_EVENT_CALLBACK_ADD, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_callback_del_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EO_BASE_EVENT_CALLBACK_DEL, priority_,
            &::efl::eo::_detail::event_callback<::elm::color_item, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::color_item, function_type>,
         EO_BASE_EVENT_CALLBACK_DEL );
   }

   template <typename T>
   void
   callback_callback_del_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EO_BASE_EVENT_CALLBACK_DEL, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_children_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_CHILDREN_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::color_item, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::color_item, function_type>,
         ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_CHILDREN_CHANGED );
   }

   template <typename T>
   void
   callback_children_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_CHILDREN_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_del_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EO_BASE_EVENT_DEL, priority_,
            &::efl::eo::_detail::event_callback<::elm::color_item, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::color_item, function_type>,
         EO_BASE_EVENT_DEL );
   }

   template <typename T>
   void
   callback_del_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EO_BASE_EVENT_DEL, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_property_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_PROPERTY_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::color_item, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::color_item, function_type>,
         ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_PROPERTY_CHANGED );
   }

   template <typename T>
   void
   callback_property_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_PROPERTY_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_removed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_REMOVED, priority_,
            &::efl::eo::_detail::event_callback<::elm::color_item, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::color_item, function_type>,
         ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_REMOVED );
   }

   template <typename T>
   void
   callback_removed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_REMOVED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_state_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_STATE_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::color_item, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::color_item, function_type>,
         ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_STATE_CHANGED );
   }

   template <typename T>
   void
   callback_state_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_STATE_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_visible_data_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_VISIBLE_DATA_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::color_item, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::color_item, function_type>,
         ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_VISIBLE_DATA_CHANGED );
   }

   template <typename T>
   void
   callback_visible_data_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_VISIBLE_DATA_CHANGED, info));
   }



   static Eo_Class const* _eo_class()
   {
      return(ELM_COLOR_ITEM_CLASS);
   }

   /// @cond LOCAL
   struct address_of
      : ::eo_cxx::elm::color_item::address_of<address_of>
      , ::eo_cxx::elm::widget_item::address_of<address_of>
      , ::eo_cxx::elm_interface_atspi_accessible::address_of<address_of>
      , ::eo_cxx::elm_interface_atspi_component::address_of<address_of>
      , ::eo_cxx::eo::base::address_of<address_of>
      , ::efl::eo::detail::concrete_address_of
   {
      explicit address_of(::elm::color_item* p)
         : ::efl::eo::detail::concrete_address_of(p)
      {}
   };
   address_of operator&() { return address_of(this); }

   struct address_const_of
      : ::eo_cxx::elm::color_item::address_const_of<address_const_of>
      , ::eo_cxx::elm::widget_item::address_const_of<address_const_of>
      , ::eo_cxx::elm_interface_atspi_accessible::address_const_of<address_const_of>
      , ::eo_cxx::elm_interface_atspi_component::address_const_of<address_const_of>
      , ::eo_cxx::eo::base::address_const_of<address_const_of>
      , ::efl::eo::detail::concrete_address_const_of
   {
      explicit address_const_of(::elm::color_item const* p)
         : ::efl::eo::detail::concrete_address_const_of(p)
      {}
   };
   address_const_of operator&() const { return address_const_of(this); }

   /// @endcond

private:

   /// @internal
   static Eo* _ctors_call(::efl::eo::parent_type _p)
   {
      Eo* _ret_eo = eo_add_ref(ELM_COLOR_ITEM_CLASS, _p._eo_raw);

      return _ret_eo;
   }

   /// @internal
   Eo* _concrete_eo_ptr() const { return _eo_ptr(); }
};

static_assert(sizeof(::elm::color_item) == sizeof(Eo*), "");
static_assert(std::is_standard_layout<::elm::color_item>::value, "");

}


#include "elm_color_item.eo.impl.hh"

#endif // EFL_GENERATED_ELM_COLOR_ITEM_HH

