/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.FilterPlugin;
import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.PluginConfig;
import de.mud.jta.VisualPlugin;
import de.mud.jta.event.AppletListener;
import de.mud.jta.event.ConfigurationListener;
import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class URLFilter
extends Plugin
implements FilterPlugin,
VisualPlugin,
Runnable {
    private static final int debug = 0;
    protected Vector protocols = new Vector();
    protected JList urlList = new JList();
    protected JPanel urlPanel;
    protected JMenu urlMenu;
    protected PipedInputStream pin;
    protected PipedOutputStream pout;
    protected AppletContext context;
    private Vector urlCache = new Vector();
    protected FilterPlugin source;

    public URLFilter(PluginBus bus, final String id) {
        super(bus, id);
        this.urlPanel = new JPanel(new BorderLayout());
        this.urlList.setVisibleRowCount(4);
        this.urlList.setSelectionMode(0);
        this.urlList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                URLFilter.this.showURL((String)((JList)e.getSource()).getSelectedValue());
            }
        });
        this.urlPanel.add("Center", this.urlList);
        JPanel p = new JPanel(new GridLayout(3, 1));
        JButton b = new JButton("Clear List");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                URLFilter.this.urlCache.removeAllElements();
                URLFilter.this.urlList.removeAll();
            }
        });
        p.add(b);
        b = new JButton("Remove URL");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String item = (String)URLFilter.this.urlList.getSelectedValue();
                if (item != null) {
                    URLFilter.this.urlCache.removeElement(item);
                    URLFilter.this.urlList.remove(URLFilter.this.urlList.getSelectedIndex());
                }
            }
        });
        p.add(b);
        b = new JButton("Show URL");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String item = (String)URLFilter.this.urlList.getSelectedValue();
                if (item != null) {
                    URLFilter.this.showURL(item);
                }
            }
        });
        p.add(b);
        this.urlPanel.add("East", p);
        bus.registerPluginListener(new AppletListener(){

            public void setApplet(JApplet applet) {
                URLFilter.this.context = applet.getAppletContext();
            }
        });
        bus.registerPluginListener(new ConfigurationListener(){

            public void setConfiguration(PluginConfig config) {
                String s = config.getProperty("URLFilter", id, "protocols");
                if (s != null) {
                    int old = -1;
                    int idx = s.indexOf(44);
                    while (idx >= 0) {
                        System.out.println("URLFilter: adding protocol '" + s.substring(old + 1, idx) + "'");
                        URLFilter.this.protocols.addElement(s.substring(old + 1, idx));
                        old = idx;
                        idx = s.indexOf(44, old + 1);
                    }
                    System.out.println("URLFilter: adding protocol '" + s.substring(old + 1) + "'");
                    URLFilter.this.protocols.addElement(s.substring(old + 1));
                } else {
                    URLFilter.this.protocols.addElement("http");
                    URLFilter.this.protocols.addElement("ftp");
                    URLFilter.this.protocols.addElement("gopher");
                    URLFilter.this.protocols.addElement("file");
                }
            }
        });
        this.pin = new PipedInputStream();
        this.pout = new PipedOutputStream();
        try {
            this.pout.connect(this.pin);
        }
        catch (IOException e) {
            System.err.println("URLFilter: error installing recognizer: " + e);
        }
        Thread recognizer = new Thread(this);
        recognizer.start();
    }

    public void run() {
        try {
            int token;
            StreamTokenizer st = new StreamTokenizer(new BufferedReader(new InputStreamReader(this.pin)));
            st.eolIsSignificant(true);
            st.slashSlashComments(false);
            st.slashStarComments(false);
            st.whitespaceChars(0, 31);
            st.ordinaryChar(34);
            st.ordinaryChar(60);
            st.ordinaryChar(62);
            st.ordinaryChar(47);
            st.ordinaryChar(58);
            while ((token = st.nextToken()) != -1) {
                String word;
                if (token != -3 || !this.protocols.contains(word = st.sval.toLowerCase()) || st.nextToken() != 58 || st.nextToken() != 47) continue;
                String url = word + ":/";
                while ((token = st.nextToken()) == -3 || token == 47) {
                    if (token == -3) {
                        url = url + st.sval;
                        continue;
                    }
                    url = url + (char)token;
                }
                if (url.endsWith(".")) {
                    url = url.substring(0, url.length() - 1);
                }
                if (this.urlCache.contains(url)) continue;
                this.urlCache.addElement(url);
                this.urlList.add(url, new JLabel(url));
                System.out.println("URLFilter: found \"" + url + "\"");
            }
        }
        catch (IOException e) {
            System.err.println("URLFilter: recognition aborted: " + e);
        }
    }

    protected void showURL(String url) {
        if (this.context == null) {
            System.err.println("URLFilter: no url-viewer available\n");
            return;
        }
        try {
            this.context.showDocument(new URL(url), "URLFilter");
        }
        catch (Exception e) {
            System.err.println("URLFilter: cannot load url: " + e);
        }
    }

    public void setFilterSource(FilterPlugin plugin) {
        this.source = plugin;
    }

    public FilterPlugin getFilterSource() {
        return this.source;
    }

    public int read(byte[] b) throws IOException {
        int n = this.source.read(b);
        if (n > 0) {
            this.pout.write(b, 0, n);
        }
        return n;
    }

    public void write(byte[] b) throws IOException {
        this.source.write(b);
    }

    public JComponent getPluginVisual() {
        return this.urlPanel;
    }

    public JMenu getPluginMenu() {
        return this.urlMenu;
    }
}

