/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;

@NodeChild(value="child", type=RubyNode.class)
public abstract class ToFNode
extends RubyNode {
    @Node.Child
    private CallDispatchHeadNode toFNode;

    public ToFNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public double doDouble(VirtualFrame frame, Object value) {
        Object doubleObject = this.executeDouble(frame, value);
        if (doubleObject instanceof Double) {
            return (Double)doubleObject;
        }
        CompilerDirectives.transferToInterpreter();
        throw new UnsupportedOperationException("executeDouble must return a double, instead it returned a " + doubleObject.getClass().getName());
    }

    public abstract Object executeDouble(VirtualFrame var1, Object var2);

    @Specialization
    public double coerceInt(int value) {
        return value;
    }

    @Specialization
    public double coerceLong(long value) {
        return value;
    }

    @Specialization
    public double coerceDouble(double value) {
        return value;
    }

    @Specialization
    public double coerceBoolean(VirtualFrame frame, boolean value) {
        return this.coerceObject(frame, value);
    }

    @Specialization
    public double coerceDynamicObject(VirtualFrame frame, DynamicObject object) {
        return this.coerceObject(frame, object);
    }

    private double coerceObject(VirtualFrame frame, Object object) {
        Object coerced;
        if (this.toFNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.toFNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true));
        }
        try {
            coerced = this.toFNode.call(frame, object, "to_f", null, new Object[0]);
        }
        catch (RaiseException e) {
            if (Layouts.BASIC_OBJECT.getLogicalClass(e.getException()) == this.coreLibrary().getNoMethodErrorClass()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().typeErrorNoImplicitConversion(object, "Float", this));
            }
            throw e;
        }
        if (this.coreLibrary().getLogicalClass(coerced) == this.coreLibrary().getFloatClass()) {
            return (Double)coerced;
        }
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.coreExceptions().typeErrorBadCoercion(object, "Float", "to_f", coerced, this));
    }
}

