/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.kernel;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.Collection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.objects.LogicalClassNode;
import org.jruby.truffle.language.objects.LogicalClassNodeGen;
import org.jruby.truffle.language.yield.YieldNode;

public class TraceManager {
    private final RubyContext context;
    private final Instrumenter instrumenter;
    private Collection<EventBinding<?>> instruments;
    private boolean isInTraceFunc = false;

    public TraceManager(RubyContext context, Instrumenter instrumenter) {
        this.context = context;
        this.instrumenter = instrumenter;
    }

    public void setTraceFunc(final DynamicObject traceFunc) {
        assert (RubyGuards.isRubyProc(traceFunc));
        if (this.instruments != null) {
            for (EventBinding<?> instrument : this.instruments) {
                instrument.dispose();
            }
        }
        if (traceFunc == null) {
            this.instruments = null;
            return;
        }
        this.instruments = new ArrayList();
        this.instruments.add(this.instrumenter.attachFactory(SourceSectionFilter.newBuilder().tagIs(LineTag.class).build(), new ExecutionEventNodeFactory(){

            @Override
            public ExecutionEventNode create(EventContext eventContext) {
                return new BaseEventEventNode(TraceManager.this.context, traceFunc, ((TraceManager)TraceManager.this).context.getCoreStrings().LINE.createInstance());
            }
        }));
        this.instruments.add(this.instrumenter.attachFactory(SourceSectionFilter.newBuilder().tagIs(CallTag.class).build(), new ExecutionEventNodeFactory(){

            @Override
            public ExecutionEventNode create(EventContext eventContext) {
                return new CallEventEventNode(TraceManager.this.context, traceFunc, ((TraceManager)TraceManager.this).context.getCoreStrings().CALL.createInstance());
            }
        }));
        this.instruments.add(this.instrumenter.attachFactory(SourceSectionFilter.newBuilder().tagIs(ClassTag.class).build(), new ExecutionEventNodeFactory(){

            @Override
            public ExecutionEventNode create(EventContext eventContext) {
                return new BaseEventEventNode(TraceManager.this.context, traceFunc, ((TraceManager)TraceManager.this).context.getCoreStrings().CLASS.createInstance());
            }
        }));
    }

    private class CallEventEventNode
    extends BaseEventEventNode {
        @Node.Child
        private LogicalClassNode logicalClassNode;

        public CallEventEventNode(RubyContext context, DynamicObject traceFunc, Object event) {
            super(context, traceFunc, event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onEnter(VirtualFrame frame) {
            int line;
            String file;
            if (this.inTraceFuncProfile.profile(TraceManager.this.isInTraceFunc)) {
                return;
            }
            SourceSection sourceSection = this.getCallerSourceSection();
            if (sourceSection != null && sourceSection.getSource() != null) {
                file = sourceSection.getSource().getName();
                line = sourceSection.getStartLine();
            } else {
                file = "<internal>";
                line = -1;
            }
            TraceManager.this.isInTraceFunc = true;
            try {
                this.getYieldNode().dispatch(frame, this.traceFunc, this.event, this.getFile(file), line, this.context.getSymbolTable().getSymbol(RubyArguments.getMethod(frame).getName()), Layouts.BINDING.createBinding(this.context.getCoreLibrary().getBindingFactory(), frame.materialize()), this.getLogicalClass(RubyArguments.getSelf(frame)));
            }
            finally {
                TraceManager.this.isInTraceFunc = false;
            }
        }

        @CompilerDirectives.TruffleBoundary
        private SourceSection getCallerSourceSection() {
            Node callNode = Truffle.getRuntime().getCallerFrame().getCallNode();
            if (callNode == null) {
                return null;
            }
            return callNode.getEncapsulatingSourceSection();
        }

        @CompilerDirectives.TruffleBoundary
        private DynamicObject getFile(String file) {
            return StringOperations.createString(this.context, this.context.getRopeTable().getRopeUTF8(file));
        }

        private DynamicObject getLogicalClass(Object object) {
            if (this.logicalClassNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.logicalClassNode = this.insert(LogicalClassNodeGen.create(this.context, null, null));
            }
            return this.logicalClassNode.executeLogicalClass(object);
        }
    }

    private class BaseEventEventNode
    extends ExecutionEventNode {
        protected final ConditionProfile inTraceFuncProfile = ConditionProfile.createBinaryProfile();
        protected final RubyContext context;
        protected final DynamicObject traceFunc;
        protected final Object event;
        @Node.Child
        private YieldNode yieldNode;
        @CompilerDirectives.CompilationFinal
        private DynamicObject file;
        @CompilerDirectives.CompilationFinal
        private int line;

        public BaseEventEventNode(RubyContext context, DynamicObject traceFunc, Object event) {
            this.context = context;
            this.traceFunc = traceFunc;
            this.event = event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onEnter(VirtualFrame frame) {
            if (this.inTraceFuncProfile.profile(TraceManager.this.isInTraceFunc)) {
                return;
            }
            TraceManager.this.isInTraceFunc = true;
            try {
                this.getYieldNode().dispatch(frame, this.traceFunc, this.event, this.getFile(), this.getLine(), this.context.getCoreLibrary().getNilObject(), Layouts.BINDING.createBinding(this.context.getCoreLibrary().getBindingFactory(), frame.materialize()), this.context.getCoreLibrary().getNilObject());
            }
            finally {
                TraceManager.this.isInTraceFunc = false;
            }
        }

        private DynamicObject getFile() {
            if (this.file == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.file = StringOperations.createString(this.context, this.context.getRopeTable().getRopeUTF8(this.getEncapsulatingSourceSection().getSource().getName()));
            }
            return this.file;
        }

        private int getLine() {
            if (this.line == 0) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.line = this.getEncapsulatingSourceSection().getStartLine();
            }
            return this.line;
        }

        protected YieldNode getYieldNode() {
            if (this.yieldNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.yieldNode = this.insert(new YieldNode(this.context));
            }
            return this.yieldNode;
        }
    }

    public static @interface ClassTag {
    }

    public static @interface CallTag {
    }

    public static @interface LineTag {
    }
}

