/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.regexp;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.regexp.RegexpNodes;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypesGen;

@GeneratedBy(value=RegexpNodes.class)
public final class RegexpNodesFactory {
    public static List<NodeFactory<? extends CoreMethodArrayArgumentsNode>> getFactories() {
        return Arrays.asList(MatchOperatorNodeFactory.getInstance(), HashNodeFactory.getInstance(), MatchStartNodeFactory.getInstance(), QuoteNodeFactory.getInstance(), SearchFromNodeFactory.getInstance(), SourceNodeFactory.getInstance(), ToSNodeFactory.getInstance(), AllocateNodeFactory.getInstance());
    }

    @GeneratedBy(value=RegexpNodes.AllocateNode.class)
    public static final class AllocateNodeFactory
    extends NodeFactoryBase<RegexpNodes.AllocateNode> {
        private static AllocateNodeFactory allocateNodeFactoryInstance;

        private AllocateNodeFactory() {
            super(RegexpNodes.AllocateNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public RegexpNodes.AllocateNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AllocateNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<RegexpNodes.AllocateNode> getInstance() {
            if (allocateNodeFactoryInstance == null) {
                allocateNodeFactoryInstance = new AllocateNodeFactory();
            }
            return allocateNodeFactoryInstance;
        }

        public static RegexpNodes.AllocateNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new AllocateNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=RegexpNodes.AllocateNode.class)
        public static final class AllocateNodeGen
        extends RegexpNodes.AllocateNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AllocateNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.allocate(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=RegexpNodes.RubiniusNamesNode.class)
    public static final class RubiniusNamesNodeGen
    extends RegexpNodes.RubiniusNamesNode
    implements SpecializedNode {
        @Node.Child
        private RubyNode self_;
        @Node.Child
        private BaseNode_ specialization_;

        private RubiniusNamesNodeGen(RubyNode self) {
            this.self_ = self;
            this.specialization_ = UninitializedNode_.create(this);
        }

        @Override
        public NodeCost getCost() {
            return this.specialization_.getNodeCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.specialization_.execute(frameValue);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.specialization_.executeVoid(frameValue);
        }

        @Override
        public SpecializationNode getSpecializationNode() {
            return this.specialization_;
        }

        @Override
        public Node deepCopy() {
            return SpecializationNode.updateRoot(super.deepCopy());
        }

        public static RegexpNodes.RubiniusNamesNode create(RubyNode self) {
            return new RubiniusNamesNodeGen(self);
        }

        @GeneratedBy(methodName="rubiniusNames(VirtualFrame, DynamicObject)", value=RegexpNodes.RubiniusNamesNode.class)
        private static final class RubiniusNamesNode_
        extends BaseNode_ {
            RubiniusNamesNode_(RubiniusNamesNodeGen root) {
                super(root, 2);
            }

            @Override
            public Object execute_(VirtualFrame frameValue, Object selfValue) {
                DynamicObject selfValue_;
                if (selfValue instanceof DynamicObject && RegexpNodes.RubiniusNamesNode.anyNames(selfValue_ = (DynamicObject)selfValue)) {
                    return this.root.rubiniusNames(frameValue, selfValue_);
                }
                return this.getNext().execute_(frameValue, selfValue);
            }

            static BaseNode_ create(RubiniusNamesNodeGen root) {
                return new RubiniusNamesNode_(root);
            }
        }

        @GeneratedBy(methodName="rubiniusNamesNoCaptures(DynamicObject)", value=RegexpNodes.RubiniusNamesNode.class)
        private static final class RubiniusNamesNoCapturesNode_
        extends BaseNode_ {
            RubiniusNamesNoCapturesNode_(RubiniusNamesNodeGen root) {
                super(root, 1);
            }

            @Override
            public Object execute_(VirtualFrame frameValue, Object selfValue) {
                DynamicObject selfValue_;
                if (selfValue instanceof DynamicObject && !RegexpNodes.RubiniusNamesNode.anyNames(selfValue_ = (DynamicObject)selfValue)) {
                    return this.root.rubiniusNamesNoCaptures(selfValue_);
                }
                return this.getNext().execute_(frameValue, selfValue);
            }

            static BaseNode_ create(RubiniusNamesNodeGen root) {
                return new RubiniusNamesNoCapturesNode_(root);
            }
        }

        @GeneratedBy(value=RegexpNodes.RubiniusNamesNode.class)
        private static final class PolymorphicNode_
        extends BaseNode_ {
            PolymorphicNode_(RubiniusNamesNodeGen root) {
                super(root, 0);
            }

            @Override
            public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object selfValue) {
                return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, selfValue));
            }

            @Override
            public Object execute_(VirtualFrame frameValue, Object selfValue) {
                return this.getNext().execute_(frameValue, selfValue);
            }

            static BaseNode_ create(RubiniusNamesNodeGen root) {
                return new PolymorphicNode_(root);
            }
        }

        @GeneratedBy(value=RegexpNodes.RubiniusNamesNode.class)
        private static final class UninitializedNode_
        extends BaseNode_ {
            UninitializedNode_(RubiniusNamesNodeGen root) {
                super(root, Integer.MAX_VALUE);
            }

            @Override
            public Object execute_(VirtualFrame frameValue, Object selfValue) {
                return this.uninitialized((Frame)frameValue, selfValue);
            }

            static BaseNode_ create(RubiniusNamesNodeGen root) {
                return new UninitializedNode_(root);
            }
        }

        @GeneratedBy(value=RegexpNodes.RubiniusNamesNode.class)
        private static abstract class BaseNode_
        extends SpecializationNode {
            @CompilerDirectives.CompilationFinal
            protected RubiniusNamesNodeGen root;

            BaseNode_(RubiniusNamesNodeGen root, int index) {
                super(index);
                this.root = root;
            }

            @Override
            protected final void setRoot(Node root) {
                this.root = (RubiniusNamesNodeGen)root;
            }

            @Override
            protected final Node[] getSuppliedChildren() {
                return new Node[]{this.root.self_};
            }

            @Override
            public final Object acceptAndExecute(Frame frameValue, Object selfValue) {
                return this.execute_((VirtualFrame)frameValue, selfValue);
            }

            public abstract Object execute_(VirtualFrame var1, Object var2);

            public Object execute(VirtualFrame frameValue) {
                Object selfValue_ = this.root.self_.execute(frameValue);
                return this.execute_(frameValue, selfValue_);
            }

            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            @Override
            protected final SpecializationNode createNext(Frame frameValue, Object selfValue) {
                if (selfValue instanceof DynamicObject) {
                    DynamicObject selfValue_ = (DynamicObject)selfValue;
                    if (!RegexpNodes.RubiniusNamesNode.anyNames(selfValue_)) {
                        return RubiniusNamesNoCapturesNode_.create(this.root);
                    }
                    return RubiniusNamesNode_.create(this.root);
                }
                return null;
            }

            @Override
            protected final SpecializationNode createPolymorphic() {
                return PolymorphicNode_.create(this.root);
            }

            protected final BaseNode_ getNext() {
                return (BaseNode_)this.next;
            }
        }
    }

    @GeneratedBy(value=RegexpNodes.ToSNode.class)
    public static final class ToSNodeFactory
    extends NodeFactoryBase<RegexpNodes.ToSNode> {
        private static ToSNodeFactory toSNodeFactoryInstance;

        private ToSNodeFactory() {
            super(RegexpNodes.ToSNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public RegexpNodes.ToSNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ToSNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<RegexpNodes.ToSNode> getInstance() {
            if (toSNodeFactoryInstance == null) {
                toSNodeFactoryInstance = new ToSNodeFactory();
            }
            return toSNodeFactoryInstance;
        }

        public static RegexpNodes.ToSNode create(RubyNode[] arguments) {
            return new ToSNodeGen(arguments);
        }

        @GeneratedBy(value=RegexpNodes.ToSNode.class)
        public static final class ToSNodeGen
        extends RegexpNodes.ToSNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ToSNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.toS(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=RegexpNodes.SourceNode.class)
    public static final class SourceNodeFactory
    extends NodeFactoryBase<RegexpNodes.SourceNode> {
        private static SourceNodeFactory sourceNodeFactoryInstance;

        private SourceNodeFactory() {
            super(RegexpNodes.SourceNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public RegexpNodes.SourceNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SourceNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<RegexpNodes.SourceNode> getInstance() {
            if (sourceNodeFactoryInstance == null) {
                sourceNodeFactoryInstance = new SourceNodeFactory();
            }
            return sourceNodeFactoryInstance;
        }

        public static RegexpNodes.SourceNode create(RubyNode[] arguments) {
            return new SourceNodeGen(arguments);
        }

        @GeneratedBy(value=RegexpNodes.SourceNode.class)
        public static final class SourceNodeGen
        extends RegexpNodes.SourceNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private SourceNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.source(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=RegexpNodes.SearchFromNode.class)
    public static final class SearchFromNodeFactory
    extends NodeFactoryBase<RegexpNodes.SearchFromNode> {
        private static SearchFromNodeFactory searchFromNodeFactoryInstance;

        private SearchFromNodeFactory() {
            super(RegexpNodes.SearchFromNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public RegexpNodes.SearchFromNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SearchFromNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<RegexpNodes.SearchFromNode> getInstance() {
            if (searchFromNodeFactoryInstance == null) {
                searchFromNodeFactoryInstance = new SearchFromNodeFactory();
            }
            return searchFromNodeFactoryInstance;
        }

        public static RegexpNodes.SearchFromNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SearchFromNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=RegexpNodes.SearchFromNode.class)
        public static final class SearchFromNodeGen
        extends RegexpNodes.SearchFromNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private SearchFromNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="searchFrom(DynamicObject, DynamicObject, int)", value=RegexpNodes.SearchFromNode.class)
            private static final class SearchFromNode_
            extends BaseNode_ {
                private final Class<?> arguments2ImplicitType;

                SearchFromNode_(SearchFromNodeGen root, Object arguments2Value) {
                    super(root, 1);
                    this.arguments2ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments2Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments2ImplicitType == ((SearchFromNode_)other).arguments2ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments2Value_;
                    DynamicObject arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    try {
                        if (this.arguments2ImplicitType == Integer.TYPE) {
                            arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                        } else {
                            Object arguments2Value__ = this.executeArguments2_(frameValue);
                            arguments2Value_ = RubyTypesGen.expectImplicitInteger(arguments2Value__, this.arguments2ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyString(arguments1Value_)) {
                        return this.root.searchFrom(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments2Value, this.arguments2ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        int arguments2Value_ = RubyTypesGen.asImplicitInteger(arguments2Value, this.arguments2ImplicitType);
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.searchFrom(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(SearchFromNodeGen root, Object arguments2Value) {
                    return new SearchFromNode_(root, arguments2Value);
                }
            }

            @GeneratedBy(value=RegexpNodes.SearchFromNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SearchFromNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(SearchFromNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=RegexpNodes.SearchFromNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SearchFromNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(SearchFromNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=RegexpNodes.SearchFromNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected SearchFromNodeGen root;

                BaseNode_(SearchFromNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (SearchFromNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.executeArguments2_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    DynamicObject arguments1Value_;
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments2Value) && RubyGuards.isRubyString(arguments1Value_ = (DynamicObject)arguments1Value)) {
                        return SearchFromNode_.create(this.root, arguments2Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments2_(Frame frameValue) {
                    Object object;
                    Class arguments2Type_ = this.root.arguments2Type_;
                    if (arguments2Type_ == Integer.TYPE) {
                        return this.root.arguments2_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments2Type_ != null) return this.root.arguments2_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments2_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments2Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments2Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments2Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=RegexpNodes.QuoteNode.class)
    public static final class QuoteNodeFactory
    extends NodeFactoryBase<RegexpNodes.QuoteNode> {
        private static QuoteNodeFactory quoteNodeFactoryInstance;

        private QuoteNodeFactory() {
            super(RegexpNodes.QuoteNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public RegexpNodes.QuoteNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return QuoteNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<RegexpNodes.QuoteNode> getInstance() {
            if (quoteNodeFactoryInstance == null) {
                quoteNodeFactoryInstance = new QuoteNodeFactory();
            }
            return quoteNodeFactoryInstance;
        }

        public static RegexpNodes.QuoteNode create(RubyNode[] arguments) {
            return new QuoteNodeGen(arguments);
        }

        @GeneratedBy(value=RegexpNodes.QuoteNode.class)
        public static final class QuoteNodeGen
        extends RegexpNodes.QuoteNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private QuoteNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="quoteSymbol(DynamicObject)", value=RegexpNodes.QuoteNode.class)
            private static final class QuoteSymbolNode_
            extends BaseNode_ {
                QuoteSymbolNode_(QuoteNodeGen root) {
                    super(root, 2);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubySymbol(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.quoteSymbol(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(QuoteNodeGen root) {
                    return new QuoteSymbolNode_(root);
                }
            }

            @GeneratedBy(methodName="quoteString(DynamicObject)", value=RegexpNodes.QuoteNode.class)
            private static final class QuoteStringNode_
            extends BaseNode_ {
                QuoteStringNode_(QuoteNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyString(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.quoteString(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(QuoteNodeGen root) {
                    return new QuoteStringNode_(root);
                }
            }

            @GeneratedBy(value=RegexpNodes.QuoteNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(QuoteNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(QuoteNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=RegexpNodes.QuoteNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(QuoteNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(QuoteNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=RegexpNodes.QuoteNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected QuoteNodeGen root;

                BaseNode_(QuoteNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (QuoteNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (RubyGuards.isRubyString(arguments0Value_)) {
                            return QuoteStringNode_.create(this.root);
                        }
                        if (RubyGuards.isRubySymbol(arguments0Value_)) {
                            return QuoteSymbolNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=RegexpNodes.MatchStartNode.class)
    public static final class MatchStartNodeFactory
    extends NodeFactoryBase<RegexpNodes.MatchStartNode> {
        private static MatchStartNodeFactory matchStartNodeFactoryInstance;

        private MatchStartNodeFactory() {
            super(RegexpNodes.MatchStartNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public RegexpNodes.MatchStartNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MatchStartNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<RegexpNodes.MatchStartNode> getInstance() {
            if (matchStartNodeFactoryInstance == null) {
                matchStartNodeFactoryInstance = new MatchStartNodeFactory();
            }
            return matchStartNodeFactoryInstance;
        }

        public static RegexpNodes.MatchStartNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new MatchStartNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=RegexpNodes.MatchStartNode.class)
        public static final class MatchStartNodeGen
        extends RegexpNodes.MatchStartNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private MatchStartNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="matchStart(DynamicObject, DynamicObject, int)", value=RegexpNodes.MatchStartNode.class)
            private static final class MatchStartNode_
            extends BaseNode_ {
                private final Class<?> arguments2ImplicitType;

                MatchStartNode_(MatchStartNodeGen root, Object arguments2Value) {
                    super(root, 1);
                    this.arguments2ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments2Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments2ImplicitType == ((MatchStartNode_)other).arguments2ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments2Value_;
                    DynamicObject arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    try {
                        if (this.arguments2ImplicitType == Integer.TYPE) {
                            arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                        } else {
                            Object arguments2Value__ = this.executeArguments2_(frameValue);
                            arguments2Value_ = RubyTypesGen.expectImplicitInteger(arguments2Value__, this.arguments2ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyString(arguments1Value_)) {
                        return this.root.matchStart(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments2Value, this.arguments2ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        int arguments2Value_ = RubyTypesGen.asImplicitInteger(arguments2Value, this.arguments2ImplicitType);
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.matchStart(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(MatchStartNodeGen root, Object arguments2Value) {
                    return new MatchStartNode_(root, arguments2Value);
                }
            }

            @GeneratedBy(value=RegexpNodes.MatchStartNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(MatchStartNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(MatchStartNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=RegexpNodes.MatchStartNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(MatchStartNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(MatchStartNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=RegexpNodes.MatchStartNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected MatchStartNodeGen root;

                BaseNode_(MatchStartNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (MatchStartNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.executeArguments2_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    DynamicObject arguments1Value_;
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments2Value) && RubyGuards.isRubyString(arguments1Value_ = (DynamicObject)arguments1Value)) {
                        return MatchStartNode_.create(this.root, arguments2Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments2_(Frame frameValue) {
                    Object object;
                    Class arguments2Type_ = this.root.arguments2Type_;
                    if (arguments2Type_ == Integer.TYPE) {
                        return this.root.arguments2_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments2Type_ != null) return this.root.arguments2_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments2_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments2Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments2Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments2Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=RegexpNodes.HashNode.class)
    public static final class HashNodeFactory
    extends NodeFactoryBase<RegexpNodes.HashNode> {
        private static HashNodeFactory hashNodeFactoryInstance;

        private HashNodeFactory() {
            super(RegexpNodes.HashNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public RegexpNodes.HashNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return HashNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<RegexpNodes.HashNode> getInstance() {
            if (hashNodeFactoryInstance == null) {
                hashNodeFactoryInstance = new HashNodeFactory();
            }
            return hashNodeFactoryInstance;
        }

        public static RegexpNodes.HashNode create(RubyNode[] arguments) {
            return new HashNodeGen(arguments);
        }

        @GeneratedBy(value=RegexpNodes.HashNode.class)
        public static final class HashNodeGen
        extends RegexpNodes.HashNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private HashNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.hash(arguments0Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=RegexpNodes.MatchOperatorNode.class)
    public static final class MatchOperatorNodeFactory
    extends NodeFactoryBase<RegexpNodes.MatchOperatorNode> {
        private static MatchOperatorNodeFactory matchOperatorNodeFactoryInstance;

        private MatchOperatorNodeFactory() {
            super(RegexpNodes.MatchOperatorNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public RegexpNodes.MatchOperatorNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MatchOperatorNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<RegexpNodes.MatchOperatorNode> getInstance() {
            if (matchOperatorNodeFactoryInstance == null) {
                matchOperatorNodeFactoryInstance = new MatchOperatorNodeFactory();
            }
            return matchOperatorNodeFactoryInstance;
        }

        public static RegexpNodes.MatchOperatorNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new MatchOperatorNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=RegexpNodes.MatchOperatorNode.class)
        public static final class MatchOperatorNodeGen
        extends RegexpNodes.MatchOperatorNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private MatchOperatorNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="matchGeneric(VirtualFrame, DynamicObject, DynamicObject)", value=RegexpNodes.MatchOperatorNode.class)
            private static final class MatchGenericNode_
            extends BaseNode_ {
                MatchGenericNode_(MatchOperatorNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (!(RubyGuards.isRubyString(arguments1Value_) || RubyGuards.isRubySymbol(arguments1Value_) || this.root.isNil(arguments1Value_))) {
                            return this.root.matchGeneric(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MatchOperatorNodeGen root) {
                    return new MatchGenericNode_(root);
                }
            }

            @GeneratedBy(methodName="match(DynamicObject, Object)", value=RegexpNodes.MatchOperatorNode.class)
            private static final class Match2Node_
            extends BaseNode_ {
                Match2Node_(MatchOperatorNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (this.root.isNil(arguments1Value)) {
                            return this.root.match(arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MatchOperatorNodeGen root) {
                    return new Match2Node_(root);
                }
            }

            @GeneratedBy(methodName="match(VirtualFrame, DynamicObject, DynamicObject)", value=RegexpNodes.MatchOperatorNode.class)
            private static final class Match1Node_
            extends BaseNode_ {
                Match1Node_(MatchOperatorNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubySymbol(arguments1Value_)) {
                            return this.root.match(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MatchOperatorNodeGen root) {
                    return new Match1Node_(root);
                }
            }

            @GeneratedBy(methodName="match(DynamicObject, DynamicObject)", value=RegexpNodes.MatchOperatorNode.class)
            private static final class Match0Node_
            extends BaseNode_ {
                Match0Node_(MatchOperatorNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.match(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MatchOperatorNodeGen root) {
                    return new Match0Node_(root);
                }
            }

            @GeneratedBy(value=RegexpNodes.MatchOperatorNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(MatchOperatorNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MatchOperatorNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=RegexpNodes.MatchOperatorNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(MatchOperatorNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MatchOperatorNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=RegexpNodes.MatchOperatorNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected MatchOperatorNodeGen root;

                BaseNode_(MatchOperatorNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (MatchOperatorNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments1Value_;
                        if (arguments1Value instanceof DynamicObject) {
                            arguments1Value_ = (DynamicObject)arguments1Value;
                            if (RubyGuards.isRubyString(arguments1Value_)) {
                                return Match0Node_.create(this.root);
                            }
                            if (RubyGuards.isRubySymbol(arguments1Value_)) {
                                return Match1Node_.create(this.root);
                            }
                        }
                        if (this.root.isNil(arguments1Value)) {
                            return Match2Node_.create(this.root);
                        }
                        if (arguments1Value instanceof DynamicObject && !RubyGuards.isRubyString(arguments1Value_ = (DynamicObject)arguments1Value) && !RubyGuards.isRubySymbol(arguments1Value_) && !this.root.isNil(arguments1Value_)) {
                            return MatchGenericNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }
}

