/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.string;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.CoreClass;
import org.jruby.truffle.core.CoreMethod;
import org.jruby.truffle.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.CoreMethodNode;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.YieldingCoreMethodNode;
import org.jruby.truffle.core.array.ArrayCoreMethodNode;
import org.jruby.truffle.core.cast.CmpIntNode;
import org.jruby.truffle.core.cast.CmpIntNodeGen;
import org.jruby.truffle.core.cast.TaintResultNode;
import org.jruby.truffle.core.cast.ToIntNode;
import org.jruby.truffle.core.cast.ToIntNodeGen;
import org.jruby.truffle.core.cast.ToStrNode;
import org.jruby.truffle.core.cast.ToStrNodeGen;
import org.jruby.truffle.core.encoding.EncodingNodes;
import org.jruby.truffle.core.encoding.EncodingOperations;
import org.jruby.truffle.core.format.FormatExceptionTranslator;
import org.jruby.truffle.core.format.exceptions.FormatException;
import org.jruby.truffle.core.format.unpack.ArrayResult;
import org.jruby.truffle.core.format.unpack.UnpackCompiler;
import org.jruby.truffle.core.kernel.KernelNodes;
import org.jruby.truffle.core.kernel.KernelNodesFactory;
import org.jruby.truffle.core.numeric.FixnumLowerNodeGen;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.LeafRope;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeBuffer;
import org.jruby.truffle.core.rope.RopeConstants;
import org.jruby.truffle.core.rope.RopeNodes;
import org.jruby.truffle.core.rope.RopeNodesFactory;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.rubinius.StringPrimitiveNodes;
import org.jruby.truffle.core.rubinius.StringPrimitiveNodesFactory;
import org.jruby.truffle.core.string.StringCachingGuards;
import org.jruby.truffle.core.string.StringCodeRangeableWrapper;
import org.jruby.truffle.core.string.StringGuards;
import org.jruby.truffle.core.string.StringNodesFactory;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.SnippetNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.objects.AllocateObjectNode;
import org.jruby.truffle.language.objects.AllocateObjectNodeGen;
import org.jruby.truffle.language.objects.IsFrozenNode;
import org.jruby.truffle.language.objects.IsFrozenNodeGen;
import org.jruby.truffle.language.objects.TaintNode;
import org.jruby.truffle.language.objects.TaintNodeGen;
import org.jruby.truffle.platform.posix.TrufflePosix;
import org.jruby.util.ByteList;
import org.jruby.util.CodeRangeable;
import org.jruby.util.ConvertDouble;
import org.jruby.util.StringSupport;

@CoreClass(name="String")
public abstract class StringNodes {

    public static class StringNodesHelper {
        public static int checkIndex(int length, int index, RubyNode node) {
            if (index > length) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(node.getContext().getCoreExceptions().indexError(String.format("index %d out of string", index), node));
            }
            if (index < 0) {
                if (-index > length) {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(node.getContext().getCoreExceptions().indexError(String.format("index %d out of string", index), node));
                }
                index += length;
            }
            return index;
        }

        public static int checkIndexForRef(DynamicObject string, int index, RubyNode node) {
            assert (RubyGuards.isRubyString(string));
            int length = StringOperations.rope(string).byteLength();
            if (index >= length) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(node.getContext().getCoreExceptions().indexError(String.format("index %d out of string", index), node));
            }
            if (index < 0) {
                if (-index > length) {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(node.getContext().getCoreExceptions().indexError(String.format("index %d out of string", index), node));
                }
                index += length;
            }
            return index;
        }

        @CompilerDirectives.TruffleBoundary
        private static Object trTransHelper(RubyContext context, DynamicObject self, DynamicObject fromStr, DynamicObject toStr, boolean sFlag) {
            assert (RubyGuards.isRubyString(self));
            assert (RubyGuards.isRubyString(fromStr));
            assert (RubyGuards.isRubyString(toStr));
            StringCodeRangeableWrapper buffer = StringOperations.getCodeRangeableReadWrite(self);
            CodeRangeable ret = StringSupport.trTransHelper((Ruby)context.getJRubyRuntime(), (CodeRangeable)buffer, (CodeRangeable)StringOperations.getCodeRangeableReadOnly(fromStr), (CodeRangeable)StringOperations.getCodeRangeableReadOnly(toStr), (boolean)sFlag);
            if (ret == null) {
                return context.getCoreLibrary().getNilObject();
            }
            StringOperations.setRope(self, StringOperations.ropeFromByteList(buffer.getByteList(), buffer.getCodeRange()));
            return self;
        }
    }

    @CoreMethod(names={"clear"}, raiseIfFrozenSelf=true)
    public static abstract class ClearNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeSubstringNode makeSubstringNode = RopeNodes.MakeSubstringNode.createX();

        public ClearNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject clear(DynamicObject string) {
            StringOperations.setRope(string, this.makeSubstringNode.executeMake(StringOperations.rope(string), 0, 0));
            return string;
        }
    }

    @CoreMethod(names={"capitalize!"}, raiseIfFrozenSelf=true)
    public static abstract class CapitalizeBangNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeLeafRopeNode makeLeafRopeNode = RopeNodesFactory.MakeLeafRopeNodeGen.create(null, null, null, null);

        public CapitalizeBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        public DynamicObject capitalizeBang(DynamicObject string) {
            Rope rope = StringOperations.rope(string);
            Encoding enc = rope.getEncoding();
            if (enc.isDummy()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().encodingCompatibilityError(String.format("incompatible encoding with this operation: %s", enc), this));
            }
            if (rope.isEmpty()) {
                return this.nil();
            }
            StringOperations.modifyAndKeepCodeRange(string);
            int s = 0;
            int end = s + rope.byteLength();
            byte[] bytes = rope.getBytesCopy();
            boolean modify = false;
            int c = StringSupport.codePoint((Ruby)this.getContext().getJRubyRuntime(), (Encoding)enc, (byte[])bytes, (int)s, (int)end);
            if (enc.isLower(c)) {
                enc.codeToMbc(StringSupport.toUpper((Encoding)enc, (int)c), bytes, s);
                modify = true;
            }
            s += StringSupport.codeLength((Encoding)enc, (int)c);
            while (s < end) {
                c = StringSupport.codePoint((Ruby)this.getContext().getJRubyRuntime(), (Encoding)enc, (byte[])bytes, (int)s, (int)end);
                if (enc.isUpper(c)) {
                    enc.codeToMbc(StringSupport.toLower((Encoding)enc, (int)c), bytes, s);
                    modify = true;
                }
                s += StringSupport.codeLength((Encoding)enc, (int)c);
            }
            if (modify) {
                StringOperations.setRope(string, this.makeLeafRopeNode.executeMake(bytes, rope.getEncoding(), rope.getCodeRange(), rope.characterLength()));
                return string;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"valid_encoding?"})
    @ImportStatic(value={StringGuards.class})
    public static abstract class ValidEncodingQueryNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isBrokenCodeRange(string)"})
        public boolean validEncodingQueryBroken(DynamicObject string) {
            return false;
        }

        @Specialization(guards={"!isBrokenCodeRange(string)"})
        public boolean validEncodingQuery(DynamicObject string) {
            return true;
        }
    }

    @CoreMethod(names={"upcase!"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class UpcaseBangNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeLeafRopeNode makeLeafRopeNode = RopeNodesFactory.MakeLeafRopeNodeGen.create(null, null, null, null);

        public UpcaseBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isSingleByteOptimizable(string)"})
        public DynamicObject upcaseSingleByte(DynamicObject string, @Cached(value="createBinaryProfile()") ConditionProfile isEmptyProfile, @Cached(value="createBinaryProfile()") ConditionProfile modifiedProfile) {
            Rope rope = StringOperations.rope(string);
            if (isEmptyProfile.profile(rope.isEmpty())) {
                return this.nil();
            }
            byte[] bytes = rope.getBytesCopy();
            boolean modified = this.singleByteUpcase(bytes, 0, bytes.length);
            if (modifiedProfile.profile(modified)) {
                LeafRope newRope = this.makeLeafRopeNode.executeMake(bytes, rope.getEncoding(), rope.getCodeRange(), rope.characterLength());
                StringOperations.setRope(string, newRope);
                return string;
            }
            return this.nil();
        }

        @Specialization(guards={"!isSingleByteOptimizable(string)"})
        public DynamicObject upcase(DynamicObject string) {
            Rope rope = StringOperations.rope(string);
            Encoding encoding = rope.getEncoding();
            if (encoding.isDummy()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().encodingCompatibilityError(String.format("incompatible encoding with this operation: %s", encoding), this));
            }
            if (rope.isEmpty()) {
                return this.nil();
            }
            ByteList bytes = RopeOperations.toByteListCopy(rope);
            try {
                boolean modified = this.multiByteUpcase(encoding, bytes.unsafeBytes(), bytes.begin(), bytes.realSize());
                if (modified) {
                    StringOperations.setRope(string, StringOperations.ropeFromByteList(bytes, rope.getCodeRange()));
                    return string;
                }
                return this.nil();
            }
            catch (IllegalArgumentException e) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().argumentError(e.getMessage(), this));
            }
        }

        @CompilerDirectives.TruffleBoundary
        private boolean singleByteUpcase(byte[] bytes, int s, int end) {
            return StringSupport.singleByteUpcase((byte[])bytes, (int)s, (int)end);
        }

        @CompilerDirectives.TruffleBoundary
        private boolean multiByteUpcase(Encoding encoding, byte[] bytes, int s, int end) {
            return StringSupport.multiByteUpcase((Encoding)encoding, (byte[])bytes, (int)s, (int)end);
        }
    }

    @CoreMethod(names={"upcase"}, taintFromSelf=true)
    public static abstract class UpcaseNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        CallDispatchHeadNode dupNode;
        @Node.Child
        CallDispatchHeadNode upcaseBangNode;

        public UpcaseNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.dupNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.upcaseBangNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public Object upcase(VirtualFrame frame, DynamicObject string) {
            Object duped = this.dupNode.call(frame, string, "dup", null, new Object[0]);
            this.upcaseBangNode.call(frame, duped, "upcase!", null, new Object[0]);
            return duped;
        }
    }

    @CoreMethod(names={"unpack"}, required=1, taintFromParameter=0)
    @ImportStatic(value={StringCachingGuards.class})
    public static abstract class UnpackNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private TaintNode taintNode;
        private final BranchProfile exceptionProfile = BranchProfile.create();

        @Specialization(guards={"isRubyString(format)", "ropesEqual(format, cachedFormat)"}, limit="getCacheLimit()")
        public DynamicObject unpackCached(VirtualFrame frame, DynamicObject string, DynamicObject format, @Cached(value="privatizeRope(format)") Rope cachedFormat, @Cached(value="create(compileFormat(format))") DirectCallNode callUnpackNode) {
            ArrayResult result;
            Rope rope = StringOperations.rope(string);
            try {
                result = (ArrayResult)callUnpackNode.call(frame, new Object[]{rope.getBytes(), rope.byteLength()});
            }
            catch (FormatException e) {
                this.exceptionProfile.enter();
                throw FormatExceptionTranslator.translate(this, e);
            }
            return this.finishUnpack(result);
        }

        @Specialization(contains={"unpackCached"}, guards={"isRubyString(format)"})
        public DynamicObject unpackUncached(VirtualFrame frame, DynamicObject string, DynamicObject format, @Cached(value="create()") IndirectCallNode callUnpackNode) {
            ArrayResult result;
            Rope rope = StringOperations.rope(string);
            try {
                result = (ArrayResult)callUnpackNode.call(frame, this.compileFormat(format), new Object[]{rope.getBytes(), rope.byteLength()});
            }
            catch (FormatException e) {
                this.exceptionProfile.enter();
                throw FormatExceptionTranslator.translate(this, e);
            }
            return this.finishUnpack(result);
        }

        private DynamicObject finishUnpack(ArrayResult result) {
            DynamicObject array = Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), result.getOutput(), result.getOutputLength());
            if (result.isTainted()) {
                if (this.taintNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.taintNode = this.insert(TaintNodeGen.create(this.getContext(), this.getEncapsulatingSourceSection(), null));
                }
                this.taintNode.executeTaint(array);
            }
            return array;
        }

        @Specialization(guards={"!isRubyString(format)", "!isBoolean(format)", "!isInteger(format)", "!isLong(format)", "!isNil(format)"})
        public Object unpack(VirtualFrame frame, DynamicObject array, Object format, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "unpack(format.to_str)", "format", format);
        }

        @CompilerDirectives.TruffleBoundary
        protected CallTarget compileFormat(DynamicObject format) {
            return new UnpackCompiler(this.getContext(), this).compile(format.toString());
        }

        protected int getCacheLimit() {
            return this.getContext().getOptions().UNPACK_CACHE;
        }
    }

    @CoreMethod(names={"tr_s!"}, required=2, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="self"), @NodeChild(type=RubyNode.class, value="fromStr"), @NodeChild(type=RubyNode.class, value="toStrNode")})
    public static abstract class TrSBangNode
    extends CoreMethodNode {
        @Node.Child
        private DeleteBangNode deleteBangNode;

        @CreateCast(value={"fromStr"})
        public RubyNode coerceFromStrToString(RubyNode fromStr) {
            return ToStrNodeGen.create(null, null, fromStr);
        }

        @CreateCast(value={"toStrNode"})
        public RubyNode coerceToStrToString(RubyNode toStr) {
            return ToStrNodeGen.create(null, null, toStr);
        }

        @Specialization(guards={"isEmpty(self)"})
        public DynamicObject trSBangEmpty(DynamicObject self, DynamicObject fromStr, DynamicObject toStr) {
            return this.nil();
        }

        @Specialization(guards={"!isEmpty(self)", "isRubyString(fromStr)", "isRubyString(toStr)"})
        public Object trSBang(VirtualFrame frame, DynamicObject self, DynamicObject fromStr, DynamicObject toStr) {
            if (StringOperations.rope(toStr).isEmpty()) {
                if (this.deleteBangNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.deleteBangNode = this.insert(StringNodesFactory.DeleteBangNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[0]));
                }
                return this.deleteBangNode.deleteBang(frame, self, fromStr);
            }
            return StringNodesHelper.trTransHelper(this.getContext(), self, fromStr, toStr, true);
        }
    }

    @CoreMethod(names={"tr!"}, required=2, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="self"), @NodeChild(type=RubyNode.class, value="fromStr"), @NodeChild(type=RubyNode.class, value="toStrNode")})
    public static abstract class TrBangNode
    extends CoreMethodNode {
        @Node.Child
        private DeleteBangNode deleteBangNode;

        @CreateCast(value={"fromStr"})
        public RubyNode coerceFromStrToString(RubyNode fromStr) {
            return ToStrNodeGen.create(null, null, fromStr);
        }

        @CreateCast(value={"toStrNode"})
        public RubyNode coerceToStrToString(RubyNode toStr) {
            return ToStrNodeGen.create(null, null, toStr);
        }

        @Specialization(guards={"isEmpty(self)"})
        public Object trBangEmpty(DynamicObject self, DynamicObject fromStr, DynamicObject toStr) {
            return this.nil();
        }

        @Specialization(guards={"!isEmpty(self)", "isRubyString(fromStr)", "isRubyString(toStr)"})
        public Object trBang(VirtualFrame frame, DynamicObject self, DynamicObject fromStr, DynamicObject toStr) {
            if (StringOperations.rope(toStr).isEmpty()) {
                if (this.deleteBangNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.deleteBangNode = this.insert(StringNodesFactory.DeleteBangNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[0]));
                }
                return this.deleteBangNode.deleteBang(frame, self, fromStr);
            }
            return StringNodesHelper.trTransHelper(this.getContext(), self, fromStr, toStr, false);
        }
    }

    @CoreMethod(names={"reverse!"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class ReverseBangNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeLeafRopeNode makeLeafRopeNode = RopeNodesFactory.MakeLeafRopeNodeGen.create(null, null, null, null);

        public ReverseBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"reverseIsEqualToSelf(string)"})
        public DynamicObject reverseNoOp(DynamicObject string) {
            return string;
        }

        @Specialization(guards={"!reverseIsEqualToSelf(string)", "isSingleByteOptimizable(string)"})
        public DynamicObject reverseSingleByteOptimizable(DynamicObject string) {
            Rope rope = StringOperations.rope(string);
            byte[] originalBytes = rope.getBytes();
            int len = originalBytes.length;
            byte[] reversedBytes = new byte[len];
            for (int i = 0; i < len; ++i) {
                reversedBytes[len - i - 1] = originalBytes[i];
            }
            StringOperations.setRope(string, this.makeLeafRopeNode.executeMake(reversedBytes, rope.getEncoding(), rope.getCodeRange(), rope.characterLength()));
            return string;
        }

        @Specialization(guards={"!reverseIsEqualToSelf(string)", "!isSingleByteOptimizable(string)"})
        public DynamicObject reverse(DynamicObject string) {
            Rope rope = StringOperations.rope(string);
            byte[] originalBytes = rope.getBytes();
            int p = 0;
            int len = originalBytes.length;
            Encoding enc = rope.getEncoding();
            int end = p + len;
            int op = len;
            byte[] reversedBytes = new byte[len];
            while (p < end) {
                int cl = StringSupport.length((Encoding)enc, (byte[])originalBytes, (int)p, (int)end);
                if (cl > 1 || (originalBytes[p] & 0x80) != 0) {
                    System.arraycopy(originalBytes, p, reversedBytes, op -= cl, cl);
                    p += cl;
                    continue;
                }
                reversedBytes[--op] = originalBytes[p++];
            }
            StringOperations.setRope(string, this.makeLeafRopeNode.executeMake(reversedBytes, rope.getEncoding(), rope.getCodeRange(), rope.characterLength()));
            return string;
        }

        public static boolean reverseIsEqualToSelf(DynamicObject string) {
            assert (RubyGuards.isRubyString(string));
            return StringOperations.rope(string).characterLength() <= 1;
        }
    }

    @CoreMethod(names={"to_sym", "intern"})
    public static abstract class ToSymNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject toSym(DynamicObject string) {
            return this.getSymbol(StringOperations.rope(string));
        }
    }

    @CoreMethod(names={"to_s", "to_str"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"!isStringSubclass(string)"})
        public DynamicObject toS(DynamicObject string) {
            return string;
        }

        @Specialization(guards={"isStringSubclass(string)"})
        public Object toSOnSubclass(VirtualFrame frame, DynamicObject string, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "''.replace(self)", "self", string);
        }

        public boolean isStringSubclass(DynamicObject string) {
            return Layouts.BASIC_OBJECT.getLogicalClass(string) != this.coreLibrary().getStringClass();
        }
    }

    @CoreMethod(names={"to_f"})
    public static abstract class ToFNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        public double toF(DynamicObject string) {
            try {
                return this.convertToDouble(string);
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }

        @CompilerDirectives.TruffleBoundary
        private double convertToDouble(DynamicObject string) {
            return ConvertDouble.byteListToDouble19((ByteList)StringOperations.getByteListReadOnly(string), (boolean)false);
        }
    }

    @CoreMethod(names={"sum"}, optional=1)
    public static abstract class SumNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode addNode;
        @Node.Child
        private CallDispatchHeadNode subNode;
        @Node.Child
        private CallDispatchHeadNode shiftNode;
        @Node.Child
        private CallDispatchHeadNode andNode;

        public SumNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.addNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.subNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.shiftNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.andNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public Object sum(VirtualFrame frame, DynamicObject string, int bits) {
            return this.sum(frame, string, (long)bits);
        }

        @Specialization
        public Object sum(VirtualFrame frame, DynamicObject string, long bits) {
            Rope rope = StringOperations.rope(string);
            byte[] bytes = rope.getBytes();
            int p = 0;
            int len = rope.byteLength();
            int end = p + len;
            if (bits >= 64L) {
                Object sum = 0;
                while (p < end) {
                    sum = this.addNode.call(frame, sum, "+", null, bytes[p++] & 0xFF);
                }
                if (bits != 0L) {
                    Object mod = this.shiftNode.call(frame, 1, "<<", null, bits);
                    sum = this.andNode.call(frame, sum, "&", null, this.subNode.call(frame, mod, "-", null, 1));
                }
                return sum;
            }
            long sum = 0L;
            while (p < end) {
                sum += (long)(bytes[p++] & 0xFF);
            }
            return bits == 0L ? sum : sum & (1L << (int)bits) - 1L;
        }

        @Specialization
        public Object sum(VirtualFrame frame, DynamicObject string, NotProvided bits) {
            return this.sum(frame, string, 16);
        }

        @Specialization(guards={"!isInteger(bits)", "!isLong(bits)", "wasProvided(bits)"})
        public Object sum(VirtualFrame frame, DynamicObject string, Object bits, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "sum Rubinius::Type.coerce_to(bits, Fixnum, :to_int)", "bits", bits);
        }
    }

    @CoreMethod(names={"succ!"}, raiseIfFrozenSelf=true)
    public static abstract class SuccBangNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject succBang(DynamicObject string) {
            Rope rope = StringOperations.rope(string);
            if (!rope.isEmpty()) {
                ByteList succByteList = StringSupport.succCommon((Ruby)this.getContext().getJRubyRuntime(), (ByteList)StringOperations.getByteListReadOnly(string));
                StringOperations.setRope(string, StringOperations.ropeFromByteList(succByteList, rope.getCodeRange()));
            }
            return string;
        }
    }

    @CoreMethod(names={"squeeze!"}, rest=true, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class SqueezeBangNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ToStrNode toStrNode;

        @Specialization(guards={"isEmpty(string)"})
        public DynamicObject squeezeBangEmptyString(DynamicObject string, Object[] args) {
            return this.nil();
        }

        @Specialization(guards={"!isEmpty(string)", "zeroArgs(args)"})
        @CompilerDirectives.TruffleBoundary
        public Object squeezeBangZeroArgs(DynamicObject string, Object[] args, @Cached(value="createBinaryProfile()") ConditionProfile singleByteOptimizableProfile) {
            Rope rope = StringOperations.rope(string);
            ByteList buffer = RopeOperations.toByteListCopy(rope);
            boolean[] squeeze = new boolean[256];
            for (int i = 0; i < 256; ++i) {
                squeeze[i] = true;
            }
            if (singleByteOptimizableProfile.profile(rope.isSingleByteOptimizable())) {
                if (!StringSupport.singleByteSqueeze((ByteList)buffer, (boolean[])squeeze)) {
                    return this.nil();
                }
                StringOperations.setRope(string, StringOperations.ropeFromByteList(buffer));
            } else {
                if (!this.squeezeCommonMultiByte(buffer, squeeze, null, StringOperations.encoding(string), false)) {
                    return this.nil();
                }
                StringOperations.setRope(string, StringOperations.ropeFromByteList(buffer));
            }
            return string;
        }

        @Specialization(guards={"!isEmpty(string)", "!zeroArgs(args)"})
        public Object squeezeBang(VirtualFrame frame, DynamicObject string, Object[] args, @Cached(value="createBinaryProfile()") ConditionProfile singleByteOptimizableProfile) {
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toStrNode = this.insert(ToStrNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            DynamicObject[] otherStrings = new DynamicObject[args.length];
            for (int i = 0; i < args.length; ++i) {
                otherStrings[i] = this.toStrNode.executeToStr(frame, args[i]);
            }
            return this.performSqueezeBang(string, otherStrings, singleByteOptimizableProfile);
        }

        @CompilerDirectives.TruffleBoundary
        private Object performSqueezeBang(DynamicObject string, DynamicObject[] otherStrings, @Cached(value="createBinaryProfile()") ConditionProfile singleByteOptimizableProfile) {
            Rope rope = StringOperations.rope(string);
            ByteList buffer = RopeOperations.toByteListCopy(rope);
            DynamicObject otherStr = otherStrings[0];
            Rope otherRope = StringOperations.rope(otherStr);
            Encoding enc = StringOperations.checkEncoding(this.getContext(), string, otherStr, this);
            boolean[] squeeze = new boolean[257];
            StringSupport.TrTables tables = StringSupport.trSetupTable((ByteList)RopeOperations.getByteListReadOnly(otherRope), (Ruby)this.getContext().getJRubyRuntime(), (boolean[])squeeze, null, (boolean)true, (Encoding)enc);
            boolean singlebyte = rope.isSingleByteOptimizable() && otherRope.isSingleByteOptimizable();
            for (int i = 1; i < otherStrings.length; ++i) {
                otherStr = otherStrings[i];
                otherRope = StringOperations.rope(otherStr);
                enc = StringOperations.checkEncoding(this.getContext(), string, otherStr, this);
                singlebyte = singlebyte && otherRope.isSingleByteOptimizable();
                tables = StringSupport.trSetupTable((ByteList)RopeOperations.getByteListReadOnly(otherRope), (Ruby)this.getContext().getJRubyRuntime(), (boolean[])squeeze, (StringSupport.TrTables)tables, (boolean)false, (Encoding)enc);
            }
            if (singleByteOptimizableProfile.profile(singlebyte)) {
                if (!StringSupport.singleByteSqueeze((ByteList)buffer, (boolean[])squeeze)) {
                    return this.nil();
                }
                StringOperations.setRope(string, StringOperations.ropeFromByteList(buffer));
            } else {
                if (!StringSupport.multiByteSqueeze((Ruby)this.getContext().getJRubyRuntime(), (ByteList)buffer, (boolean[])squeeze, (StringSupport.TrTables)tables, (Encoding)enc, (boolean)true)) {
                    return this.nil();
                }
                StringOperations.setRope(string, StringOperations.ropeFromByteList(buffer));
            }
            return string;
        }

        @CompilerDirectives.TruffleBoundary
        private boolean squeezeCommonMultiByte(ByteList value, boolean[] squeeze, StringSupport.TrTables tables, Encoding enc, boolean isArg) {
            return StringSupport.multiByteSqueeze((Ruby)this.getContext().getJRubyRuntime(), (ByteList)value, (boolean[])squeeze, (StringSupport.TrTables)tables, (Encoding)enc, (boolean)isArg);
        }

        public static boolean zeroArgs(Object[] args) {
            return args.length == 0;
        }
    }

    @CoreMethod(names={"size", "length"})
    @ImportStatic(value={StringGuards.class})
    public static abstract class SizeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int size(DynamicObject string, @Cached(value="createBinaryProfile()") ConditionProfile ropeBufferProfile, @Cached(value="createBinaryProfile()") ConditionProfile isSingleByteOptimizableRopeBufferProfile) {
            Rope rope = StringOperations.rope(string);
            if (ropeBufferProfile.profile(rope instanceof RopeBuffer)) {
                if (isSingleByteOptimizableRopeBufferProfile.profile(rope.isSingleByteOptimizable())) {
                    return ((RopeBuffer)rope).getByteList().realSize();
                }
                ByteList byteList = ((RopeBuffer)rope).getByteList();
                return RopeOperations.strLength(rope.getEncoding(), byteList.unsafeBytes(), byteList.begin(), byteList.realSize());
            }
            return rope.characterLength();
        }
    }

    @CoreMethod(names={"setbyte"}, required=2, raiseIfFrozenSelf=true)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="index"), @NodeChild(type=RubyNode.class, value="value")})
    public static abstract class SetByteNode
    extends CoreMethodNode {
        @Node.Child
        private RopeNodes.MakeConcatNode composedMakeConcatNode = RopeNodesFactory.MakeConcatNodeGen.create(null, null, null);
        @Node.Child
        private RopeNodes.MakeConcatNode middleMakeConcatNode = RopeNodesFactory.MakeConcatNodeGen.create(null, null, null);
        @Node.Child
        private RopeNodes.MakeLeafRopeNode makeLeafRopeNode = RopeNodesFactory.MakeLeafRopeNodeGen.create(null, null, null, null);
        @Node.Child
        private RopeNodes.MakeSubstringNode leftMakeSubstringNode = RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);
        @Node.Child
        private RopeNodes.MakeSubstringNode rightMakeSubstringNode = RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);

        public SetByteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"index"})
        public RubyNode coerceIndexToInt(RubyNode index) {
            return FixnumLowerNodeGen.create(null, null, ToIntNodeGen.create(index));
        }

        @CreateCast(value={"value"})
        public RubyNode coerceValueToInt(RubyNode value) {
            return FixnumLowerNodeGen.create(null, null, ToIntNodeGen.create(value));
        }

        @Specialization(guards={"!isRopeBuffer(string)"})
        public int setByte(DynamicObject string, int index, int value) {
            int normalizedIndex = StringNodesHelper.checkIndexForRef(string, index, this);
            Rope rope = StringOperations.rope(string);
            Rope left = this.leftMakeSubstringNode.executeMake(rope, 0, normalizedIndex);
            Rope right = this.rightMakeSubstringNode.executeMake(rope, normalizedIndex + 1, rope.byteLength() - normalizedIndex - 1);
            LeafRope middle = this.makeLeafRopeNode.executeMake(new byte[]{(byte)value}, rope.getEncoding(), CodeRange.CR_UNKNOWN, NotProvided.INSTANCE);
            Rope composed = this.composedMakeConcatNode.executeMake(this.middleMakeConcatNode.executeMake(left, middle, rope.getEncoding()), right, rope.getEncoding());
            StringOperations.setRope(string, composed);
            return value;
        }

        @Specialization(guards={"isRopeBuffer(string)"})
        public int setByteRopeBuffer(DynamicObject string, int index, int value) {
            int normalizedIndex = StringNodesHelper.checkIndexForRef(string, index, this);
            RopeBuffer rope = (RopeBuffer)StringOperations.rope(string);
            rope.getByteList().set(normalizedIndex, value);
            return value;
        }

        protected boolean isRopeBuffer(DynamicObject string) {
            assert (RubyGuards.isRubyString(string));
            return StringOperations.rope(string) instanceof RopeBuffer;
        }
    }

    @CoreMethod(names={"dump"}, taintFromSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class DumpNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode;

        public DumpNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization(guards={"isAsciiCompatible(string)"})
        public DynamicObject dumpAsciiCompatible(DynamicObject string) {
            ByteList outputBytes = this.dumpCommon(string);
            outputBytes.setEncoding(StringOperations.encoding(string));
            DynamicObject result = this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), StringOperations.ropeFromByteList(outputBytes, CodeRange.CR_7BIT), null);
            return result;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isAsciiCompatible(string)"})
        public DynamicObject dump(DynamicObject string) {
            ByteList outputBytes = this.dumpCommon(string);
            try {
                outputBytes.append(".force_encoding(\"".getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new UnsupportedOperationException(e);
            }
            outputBytes.append(StringOperations.encoding(string).getName());
            outputBytes.append((byte)34);
            outputBytes.append((byte)41);
            outputBytes.setEncoding((Encoding)ASCIIEncoding.INSTANCE);
            DynamicObject result = this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), StringOperations.ropeFromByteList(outputBytes, CodeRange.CR_7BIT), null);
            return result;
        }

        @CompilerDirectives.TruffleBoundary
        private ByteList dumpCommon(DynamicObject string) {
            assert (RubyGuards.isRubyString(string));
            return StringSupport.dumpCommon((Ruby)this.getContext().getJRubyRuntime(), (ByteList)StringOperations.getByteListReadOnly(string));
        }
    }

    @CoreMethod(names={"swapcase!"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class SwapcaseBangNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeLeafRopeNode makeLeafRopeNode = RopeNodesFactory.MakeLeafRopeNodeGen.create(null, null, null, null);

        public SwapcaseBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject swapcaseSingleByte(DynamicObject string, @Cached(value="createBinaryProfile()") ConditionProfile emptyStringProfile, @Cached(value="createBinaryProfile()") ConditionProfile singleByteOptimizableProfile) {
            Rope rope = StringOperations.rope(string);
            Encoding enc = rope.getEncoding();
            if (enc.isDummy()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().encodingCompatibilityError(String.format("incompatible encoding with this operation: %s", enc), this));
            }
            if (emptyStringProfile.profile(rope.isEmpty())) {
                return this.nil();
            }
            boolean s = false;
            int end = 0 + rope.byteLength();
            byte[] bytes = rope.getBytesCopy();
            if (singleByteOptimizableProfile.profile(rope.isSingleByteOptimizable())) {
                if (StringSupport.singleByteSwapcase((byte[])bytes, (int)0, (int)end)) {
                    StringOperations.setRope(string, this.makeLeafRopeNode.executeMake(bytes, rope.getEncoding(), rope.getCodeRange(), rope.characterLength()));
                    return string;
                }
            } else if (StringSupport.multiByteSwapcase((Ruby)this.getContext().getJRubyRuntime(), (Encoding)enc, (byte[])bytes, (int)0, (int)end)) {
                StringOperations.setRope(string, this.makeLeafRopeNode.executeMake(bytes, rope.getEncoding(), rope.getCodeRange(), rope.characterLength()));
                return string;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"rstrip!"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class RstripBangNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeSubstringNode makeSubstringNode = RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);

        public RstripBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isEmpty(string)"})
        public DynamicObject rstripBangEmptyString(DynamicObject string) {
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isEmpty(string)", "isSingleByteOptimizable(string)"})
        public Object rstripBangSingleByte(DynamicObject string) {
            int endp;
            Rope rope = StringOperations.rope(string);
            byte[] bytes = rope.getBytes();
            boolean start = false;
            int end = rope.byteLength();
            for (endp = end - 1; endp >= 0 && (bytes[endp] == 0 || ASCIIEncoding.INSTANCE.isSpace(bytes[endp] & 0xFF)); --endp) {
            }
            if (endp < end - 1) {
                StringOperations.setRope(string, this.makeSubstringNode.executeMake(rope, 0, endp - 0 + 1));
                return string;
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isEmpty(string)", "!isSingleByteOptimizable(string)"})
        public Object rstripBang(DynamicObject string) {
            int point;
            int prev;
            int end;
            Rope rope = StringOperations.rope(string);
            Encoding enc = RopeOperations.STR_ENC_GET(rope);
            byte[] bytes = rope.getBytes();
            boolean start = false;
            int endp = end = rope.byteLength();
            while ((prev = this.prevCharHead(enc, bytes, 0, endp, end)) != -1 && ((point = StringSupport.codePoint((Ruby)this.getContext().getJRubyRuntime(), (Encoding)enc, (byte[])bytes, (int)prev, (int)end)) == 0 || ASCIIEncoding.INSTANCE.isSpace(point))) {
                endp = prev;
            }
            if (endp < end) {
                StringOperations.setRope(string, this.makeSubstringNode.executeMake(rope, 0, endp - 0));
                return string;
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        private int prevCharHead(Encoding enc, byte[] bytes, int p, int s, int end) {
            return enc.prevCharHead(bytes, p, s, end);
        }
    }

    @CoreMethod(names={"replace"}, required=1, raiseIfFrozenSelf=true, taintFromParameter=0)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="other")})
    public static abstract class ReplaceNode
    extends CoreMethodNode {
        @CreateCast(value={"other"})
        public RubyNode coerceOtherToString(RubyNode other) {
            return ToStrNodeGen.create(null, null, other);
        }

        @Specialization(guards={"string == other"})
        public DynamicObject replaceStringIsSameAsOther(DynamicObject string, DynamicObject other) {
            return string;
        }

        @Specialization(guards={"string != other", "isRubyString(other)"})
        public DynamicObject replace(DynamicObject string, DynamicObject other) {
            StringOperations.setRope(string, StringOperations.rope(other));
            return string;
        }
    }

    @CoreMethod(names={"ord"})
    @ImportStatic(value={StringGuards.class})
    public static abstract class OrdNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.GetByteNode ropeGetByteNode;

        @Specialization(guards={"isEmpty(string)"})
        @CompilerDirectives.TruffleBoundary
        public int ordEmpty(DynamicObject string) {
            throw new RaiseException(this.coreExceptions().argumentError("empty string", this));
        }

        @Specialization(guards={"!isEmpty(string)", "isSingleByteOptimizable(string)"})
        public int ordAsciiOnly(DynamicObject string) {
            if (this.ropeGetByteNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.ropeGetByteNode = this.insert(RopeNodes.GetByteNode.create());
            }
            return this.ropeGetByteNode.executeGetByte(StringOperations.rope(string), 0);
        }

        @Specialization(guards={"!isEmpty(string)", "!isSingleByteOptimizable(string)"})
        public int ord(DynamicObject string) {
            Rope rope = StringOperations.rope(string);
            try {
                return this.codePoint(rope.getEncoding(), rope.getBytes(), 0, rope.byteLength());
            }
            catch (IllegalArgumentException e) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().argumentError(e.getMessage(), this));
            }
        }

        @CompilerDirectives.TruffleBoundary
        private int codePoint(Encoding encoding, byte[] bytes, int p, int end) {
            return StringSupport.codePoint((Encoding)encoding, (byte[])bytes, (int)p, (int)end);
        }
    }

    @CoreMethod(names={"num_bytes="}, lowerFixnumParameters={0}, required=1)
    public static abstract class SetNumBytesNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeSubstringNode makeSubstringNode = RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);

        public SetNumBytesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject setNumBytes(DynamicObject string, int count) {
            Rope rope = StringOperations.rope(string);
            if (count > rope.byteLength()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().argumentError(String.format("Invalid byte count: %d exceeds string size of %d bytes", count, rope.byteLength()), this));
            }
            StringOperations.setRope(string, this.makeSubstringNode.executeMake(rope, 0, count));
            return string;
        }
    }

    @CoreMethod(names={"modify!"}, raiseIfFrozenSelf=true)
    public static abstract class ModifyBangNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject modifyBang(DynamicObject string) {
            StringOperations.modify(string);
            return string;
        }
    }

    @CoreMethod(names={"lstrip!"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class LstripBangNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeSubstringNode makeSubstringNode = RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);

        public LstripBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isEmpty(string)"})
        public DynamicObject lstripBangEmptyString(DynamicObject string) {
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isEmpty(string)", "isSingleByteOptimizable(string)"})
        public Object lstripBangSingleByte(DynamicObject string) {
            int p;
            Rope rope = StringOperations.rope(string);
            boolean s = false;
            int end = 0 + rope.byteLength();
            byte[] bytes = rope.getBytes();
            for (p = 0; p < end && ASCIIEncoding.INSTANCE.isSpace(bytes[p] & 0xFF); ++p) {
            }
            if (p > 0) {
                StringOperations.setRope(string, this.makeSubstringNode.executeMake(rope, p - 0, end - p));
                return string;
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isEmpty(string)", "!isSingleByteOptimizable(string)"})
        public Object lstripBang(DynamicObject string) {
            int p;
            int c;
            Rope rope = StringOperations.rope(string);
            Encoding enc = RopeOperations.STR_ENC_GET(rope);
            boolean s = false;
            int end = 0 + rope.byteLength();
            byte[] bytes = rope.getBytes();
            for (p = 0; p < end && ASCIIEncoding.INSTANCE.isSpace(c = StringSupport.codePoint((Ruby)this.getContext().getJRubyRuntime(), (Encoding)enc, (byte[])bytes, (int)p, (int)end)); p += StringSupport.codeLength((Encoding)enc, (int)c)) {
            }
            if (p > 0) {
                StringOperations.setRope(string, this.makeSubstringNode.executeMake(rope, p - 0, end - p));
                return string;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"insert"}, required=2, lowerFixnumParameters={0}, raiseIfFrozenSelf=true)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="index"), @NodeChild(type=RubyNode.class, value="otherString")})
    public static abstract class InsertNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode appendNode;
        @Node.Child
        private StringPrimitiveNodes.CharacterByteIndexNode characterByteIndexNode = StringPrimitiveNodesFactory.CharacterByteIndexNodeFactory.create(new RubyNode[0]);
        @Node.Child
        private RopeNodes.MakeConcatNode prependMakeConcatNode;
        @Node.Child
        private RopeNodes.MakeConcatNode leftMakeConcatNode = RopeNodesFactory.MakeConcatNodeGen.create(null, null, null);
        @Node.Child
        private RopeNodes.MakeConcatNode rightMakeConcatNode = RopeNodesFactory.MakeConcatNodeGen.create(null, null, null);
        @Node.Child
        private RopeNodes.MakeSubstringNode leftMakeSubstringNode = RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);
        @Node.Child
        private RopeNodes.MakeSubstringNode rightMakeSubstringNode = RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);
        @Node.Child
        private TaintResultNode taintResultNode;

        public InsertNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.taintResultNode = new TaintResultNode(context, sourceSection);
        }

        @CreateCast(value={"index"})
        public RubyNode coerceIndexToInt(RubyNode index) {
            return ToIntNodeGen.create(index);
        }

        @CreateCast(value={"otherString"})
        public RubyNode coerceOtherToString(RubyNode other) {
            return ToStrNodeGen.create(null, null, other);
        }

        @Specialization(guards={"indexAtStartBound(index)", "isRubyString(other)"})
        public Object insertPrepend(DynamicObject string, int index, DynamicObject other) {
            Rope left = StringOperations.rope(other);
            Rope right = StringOperations.rope(string);
            Encoding compatibleEncoding = EncodingNodes.CompatibleQueryNode.compatibleEncodingForStrings(string, other);
            if (compatibleEncoding == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().encodingCompatibilityError(String.format("incompatible encodings: %s and %s", left.getEncoding(), right.getEncoding()), this));
            }
            if (this.prependMakeConcatNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.prependMakeConcatNode = this.insert(RopeNodesFactory.MakeConcatNodeGen.create(null, null, null));
            }
            StringOperations.setRope(string, this.prependMakeConcatNode.executeMake(left, right, compatibleEncoding));
            return this.taintResultNode.maybeTaint(other, string);
        }

        @Specialization(guards={"indexAtEndBound(index)", "isRubyString(other)"})
        public Object insertAppend(VirtualFrame frame, DynamicObject string, int index, DynamicObject other) {
            if (this.appendNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.appendNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            this.appendNode.call(frame, string, "append", null, other);
            return this.taintResultNode.maybeTaint(other, string);
        }

        @Specialization(guards={"!indexAtEitherBounds(index)", "isRubyString(other)"})
        public Object insert(VirtualFrame frame, DynamicObject string, int index, DynamicObject other, @Cached(value="createBinaryProfile()") ConditionProfile negativeIndexProfile) {
            if (negativeIndexProfile.profile(index < 0)) {
                ++index;
            }
            Rope source = StringOperations.rope(string);
            Rope insert = StringOperations.rope(other);
            Encoding compatibleEncoding = EncodingNodes.CompatibleQueryNode.compatibleEncodingForStrings(string, other);
            if (compatibleEncoding == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().encodingCompatibilityError(String.format("incompatible encodings: %s and %s", source.getEncoding(), insert.getEncoding()), this));
            }
            int stringLength = source.characterLength();
            int normalizedIndex = StringNodesHelper.checkIndex(stringLength, index, this);
            int byteIndex = this.characterByteIndexNode.executeInt(frame, string, normalizedIndex, 0);
            Rope splitLeft = this.leftMakeSubstringNode.executeMake(source, 0, byteIndex);
            Rope splitRight = this.rightMakeSubstringNode.executeMake(source, byteIndex, source.byteLength() - byteIndex);
            Rope joinedLeft = this.leftMakeConcatNode.executeMake(splitLeft, insert, compatibleEncoding);
            Rope joinedRight = this.rightMakeConcatNode.executeMake(joinedLeft, splitRight, compatibleEncoding);
            StringOperations.setRope(string, joinedRight);
            return this.taintResultNode.maybeTaint(other, string);
        }

        protected boolean indexAtStartBound(int index) {
            return index == 0;
        }

        protected boolean indexAtEndBound(int index) {
            return index == -1;
        }

        protected boolean indexAtEitherBounds(int index) {
            return this.indexAtStartBound(index) || this.indexAtEndBound(index);
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1)
    public static abstract class InitializeCopyNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"self == from"})
        public Object initializeCopySelfIsSameAsFrom(DynamicObject self, DynamicObject from) {
            return self;
        }

        @Specialization(guards={"self != from", "isRubyString(from)"})
        public Object initializeCopy(DynamicObject self, DynamicObject from) {
            StringOperations.setRope(self, StringOperations.rope(from));
            return self;
        }
    }

    @CoreMethod(names={"initialize"}, optional=1, taintFromParameter=0)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private IsFrozenNode isFrozenNode;
        @Node.Child
        private ToStrNode toStrNode;

        @Specialization
        public DynamicObject initialize(DynamicObject self, NotProvided from) {
            return self;
        }

        @Specialization(guards={"isRubyString(from)"})
        public DynamicObject initialize(DynamicObject self, DynamicObject from) {
            if (this.isFrozen(self)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().frozenError(self, this));
            }
            StringOperations.setRope(self, StringOperations.rope(from));
            return self;
        }

        @Specialization(guards={"!isRubyString(from)", "wasProvided(from)"})
        public DynamicObject initialize(VirtualFrame frame, DynamicObject self, Object from) {
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toStrNode = this.insert(ToStrNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.initialize(self, this.toStrNode.executeToStr(frame, from));
        }

        protected boolean isFrozen(Object object) {
            if (this.isFrozenNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.isFrozenNode = this.insert(IsFrozenNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.isFrozenNode.executeIsFrozen(object);
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int hash(DynamicObject string) {
            return StringOperations.rope(string).hashCode();
        }
    }

    @CoreMethod(names={"getbyte"}, required=1, lowerFixnumParameters={0})
    public static abstract class GetByteNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.GetByteNode ropeGetByteNode = RopeNodesFactory.GetByteNodeGen.create(null, null);

        public GetByteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object getByte(DynamicObject string, int index, @Cached(value="createBinaryProfile()") ConditionProfile negativeIndexProfile, @Cached(value="createBinaryProfile()") ConditionProfile indexOutOfBoundsProfile) {
            Rope rope = StringOperations.rope(string);
            if (negativeIndexProfile.profile(index < 0)) {
                index += rope.byteLength();
            }
            if (indexOutOfBoundsProfile.profile(index < 0 || index >= rope.byteLength())) {
                return this.nil();
            }
            return this.ropeGetByteNode.executeGetByte(rope, index);
        }
    }

    @CoreMethod(names={"force_encoding"}, required=1, raiseIfFrozenSelf=true)
    public static abstract class ForceEncodingNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.WithEncodingNode withEncodingNode = RopeNodesFactory.WithEncodingNodeGen.create(null, null, null);
        @Node.Child
        private ToStrNode toStrNode;

        public ForceEncodingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(encodingName)"})
        public DynamicObject forceEncodingString(DynamicObject string, DynamicObject encodingName, @Cached(value="createBinaryProfile()") ConditionProfile differentEncodingProfile, @Cached(value="createBinaryProfile()") ConditionProfile mutableRopeProfile) {
            DynamicObject encoding = EncodingNodes.getEncoding(encodingName.toString());
            return this.forceEncodingEncoding(string, encoding, differentEncodingProfile, mutableRopeProfile);
        }

        @Specialization(guards={"isRubyEncoding(rubyEncoding)"})
        public DynamicObject forceEncodingEncoding(DynamicObject string, DynamicObject rubyEncoding, @Cached(value="createBinaryProfile()") ConditionProfile differentEncodingProfile, @Cached(value="createBinaryProfile()") ConditionProfile mutableRopeProfile) {
            Encoding encoding = EncodingOperations.getEncoding(rubyEncoding);
            Rope rope = StringOperations.rope(string);
            if (differentEncodingProfile.profile(rope.getEncoding() != encoding)) {
                if (mutableRopeProfile.profile(rope instanceof RopeBuffer)) {
                    ((RopeBuffer)rope).getByteList().setEncoding(encoding);
                } else {
                    Rope newRope = this.withEncodingNode.executeWithEncoding(rope, encoding, CodeRange.CR_UNKNOWN);
                    StringOperations.setRope(string, newRope);
                }
            }
            return string;
        }

        @Specialization(guards={"!isRubyString(encoding)", "!isRubyEncoding(encoding)"})
        public DynamicObject forceEncoding(VirtualFrame frame, DynamicObject string, Object encoding, @Cached(value="createBinaryProfile()") ConditionProfile differentEncodingProfile, @Cached(value="createBinaryProfile()") ConditionProfile mutableRopeProfile) {
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toStrNode = this.insert(ToStrNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.forceEncodingString(string, this.toStrNode.executeToStr(frame, encoding), differentEncodingProfile, mutableRopeProfile);
        }
    }

    @CoreMethod(names={"encoding"})
    public static abstract class EncodingNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject encoding(DynamicObject string) {
            return EncodingNodes.getEncoding(StringOperations.encoding(string));
        }
    }

    @CoreMethod(names={"empty?"})
    public static abstract class EmptyNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public boolean empty(DynamicObject string) {
            return StringOperations.rope(string).isEmpty();
        }
    }

    @CoreMethod(names={"each_char"}, needsBlock=true, returnsEnumeratorIfNoBlock=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class EachCharNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode;
        @Node.Child
        private RopeNodes.MakeSubstringNode makeSubstringNode;
        @Node.Child
        private TaintResultNode taintResultNode;

        public EachCharNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
            this.makeSubstringNode = RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);
        }

        @Specialization(guards={"isValidOr7BitEncoding(string)"})
        public DynamicObject eachChar(VirtualFrame frame, DynamicObject string, DynamicObject block) {
            int n;
            Rope rope = StringOperations.rope(string);
            byte[] ptrBytes = rope.getBytes();
            int len = ptrBytes.length;
            Encoding enc = rope.getEncoding();
            for (int i = 0; i < len; i += n) {
                n = StringSupport.encFastMBCLen((byte[])ptrBytes, (int)i, (int)len, (Encoding)enc);
                this.yield(frame, block, this.substr(rope, string, i, n));
            }
            return string;
        }

        @Specialization(guards={"!isValidOr7BitEncoding(string)"})
        public DynamicObject eachCharMultiByteEncoding(VirtualFrame frame, DynamicObject string, DynamicObject block) {
            int n;
            Rope rope = StringOperations.rope(string);
            byte[] ptrBytes = rope.getBytes();
            int len = ptrBytes.length;
            Encoding enc = rope.getEncoding();
            for (int i = 0; i < len; i += n) {
                n = this.multiByteStringLength(enc, ptrBytes, i, len);
                this.yield(frame, block, this.substr(rope, string, i, n));
            }
            return string;
        }

        @CompilerDirectives.TruffleBoundary
        private int multiByteStringLength(Encoding enc, byte[] bytes, int p, int end) {
            return StringSupport.length((Encoding)enc, (byte[])bytes, (int)p, (int)end);
        }

        private Object substr(Rope rope, DynamicObject string, int beg, int len) {
            int length = rope.byteLength();
            if (len < 0 || beg > length) {
                return this.nil();
            }
            if (beg < 0 && (beg += length) < 0) {
                return this.nil();
            }
            int end = Math.min(length, beg + len);
            Rope substringRope = this.makeSubstringNode.executeMake(rope, beg, end - beg);
            if (this.taintResultNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.taintResultNode = this.insert(new TaintResultNode(this.getContext(), this.getSourceSection()));
            }
            DynamicObject ret = this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), substringRope, null);
            return this.taintResultNode.maybeTaint(string, ret);
        }
    }

    @CoreMethod(names={"each_byte"}, needsBlock=true, returnsEnumeratorIfNoBlock=true)
    public static abstract class EachByteNode
    extends YieldingCoreMethodNode {
        @Specialization
        public DynamicObject eachByte(VirtualFrame frame, DynamicObject string, DynamicObject block, @Cached(value="createBinaryProfile()") ConditionProfile ropeChangedProfile) {
            Rope rope = StringOperations.rope(string);
            byte[] bytes = rope.getBytes();
            for (int i = 0; i < bytes.length; ++i) {
                this.yield(frame, block, bytes[i] & 0xFF);
                Rope updatedRope = StringOperations.rope(string);
                if (!ropeChangedProfile.profile(rope != updatedRope)) continue;
                rope = updatedRope;
                bytes = updatedRope.getBytes();
            }
            return string;
        }
    }

    @CoreMethod(names={"downcase!"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class DowncaseBangNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeLeafRopeNode makeLeafRopeNode = RopeNodesFactory.MakeLeafRopeNodeGen.create(null, null, null, null);

        public DowncaseBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isEmpty(string)", "isSingleByteOptimizable(string)"})
        public DynamicObject downcaseSingleByteEmpty(DynamicObject string) {
            return this.nil();
        }

        @Specialization(guards={"!isEmpty(string)", "isSingleByteOptimizable(string)"})
        public DynamicObject downcaseSingleByte(DynamicObject string, @Cached(value="createBinaryProfile()") ConditionProfile modifiedProfile) {
            Rope rope = StringOperations.rope(string);
            byte[] outputBytes = rope.getBytesCopy();
            boolean modified = this.singleByteDowncase(outputBytes, 0, outputBytes.length);
            if (modifiedProfile.profile(modified)) {
                StringOperations.setRope(string, this.makeLeafRopeNode.executeMake(outputBytes, rope.getEncoding(), rope.getCodeRange(), rope.characterLength()));
                return string;
            }
            return this.nil();
        }

        @Specialization(guards={"!isSingleByteOptimizable(string)"})
        public DynamicObject downcase(DynamicObject string, @Cached(value="createBinaryProfile()") ConditionProfile emptyStringProfile, @Cached(value="createBinaryProfile()") ConditionProfile modifiedProfile) {
            Rope rope = StringOperations.rope(string);
            Encoding encoding = rope.getEncoding();
            if (encoding.isDummy()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().encodingCompatibilityError(String.format("incompatible encoding with this operation: %s", encoding), this));
            }
            if (emptyStringProfile.profile(rope.isEmpty())) {
                return this.nil();
            }
            byte[] outputBytes = rope.getBytesCopy();
            try {
                boolean modified = this.multiByteDowncase(encoding, outputBytes, 0, outputBytes.length);
                if (modifiedProfile.profile(modified)) {
                    StringOperations.setRope(string, this.makeLeafRopeNode.executeMake(outputBytes, rope.getEncoding(), rope.getCodeRange(), rope.characterLength()));
                    return string;
                }
                return this.nil();
            }
            catch (IllegalArgumentException e) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().argumentError(e.getMessage(), this));
            }
        }

        @CompilerDirectives.TruffleBoundary
        private boolean singleByteDowncase(byte[] bytes, int s, int end) {
            return StringSupport.singleByteDowncase((byte[])bytes, (int)s, (int)end);
        }

        @CompilerDirectives.TruffleBoundary
        private boolean multiByteDowncase(Encoding encoding, byte[] bytes, int s, int end) {
            return StringSupport.multiByteDowncase((Encoding)encoding, (byte[])bytes, (int)s, (int)end);
        }
    }

    @CoreMethod(names={"delete!"}, rest=true, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class DeleteBangNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ToStrNode toStr;

        public DeleteBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.toStr = ToStrNodeGen.create(context, sourceSection, null);
        }

        @Specialization(guards={"isEmpty(string)"})
        public DynamicObject deleteBangEmpty(DynamicObject string, Object ... args) {
            return this.nil();
        }

        @Specialization(guards={"!isEmpty(string)"})
        public Object deleteBang(VirtualFrame frame, DynamicObject string, Object ... args) {
            if (args.length == 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().argumentErrorEmptyVarargs(this));
            }
            DynamicObject[] otherStrings = new DynamicObject[args.length];
            for (int i = 0; i < args.length; ++i) {
                otherStrings[i] = this.toStr.executeToStr(frame, args[i]);
            }
            return this.deleteBangSlow(string, otherStrings);
        }

        @CompilerDirectives.TruffleBoundary
        private Object deleteBangSlow(DynamicObject string, DynamicObject ... otherStrings) {
            assert (RubyGuards.isRubyString(string));
            DynamicObject otherString = otherStrings[0];
            Encoding enc = StringOperations.checkEncoding(this.getContext(), string, otherString, this);
            boolean[] squeeze = new boolean[257];
            StringSupport.TrTables tables = StringSupport.trSetupTable((ByteList)StringOperations.getByteListReadOnly(otherString), (Ruby)this.getContext().getJRubyRuntime(), (boolean[])squeeze, null, (boolean)true, (Encoding)enc);
            for (int i = 1; i < otherStrings.length; ++i) {
                assert (RubyGuards.isRubyString(otherStrings[i]));
                enc = StringOperations.checkEncoding(this.getContext(), string, otherStrings[i], this);
                tables = StringSupport.trSetupTable((ByteList)StringOperations.getByteListReadOnly(otherStrings[i]), (Ruby)this.getContext().getJRubyRuntime(), (boolean[])squeeze, (StringSupport.TrTables)tables, (boolean)false, (Encoding)enc);
            }
            StringCodeRangeableWrapper buffer = StringOperations.getCodeRangeableReadWrite(string);
            if (StringSupport.delete_bangCommon19((CodeRangeable)buffer, (Ruby)this.getContext().getJRubyRuntime(), (boolean[])squeeze, (StringSupport.TrTables)tables, (Encoding)enc) == null) {
                return this.nil();
            }
            StringOperations.setRope(string, StringOperations.ropeFromByteList(buffer.getByteList(), buffer.getCodeRange()));
            return string;
        }
    }

    @CoreMethod(names={"crypt"}, required=1, taintFromSelf=true, taintFromParameter=0)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="salt")})
    public static abstract class CryptNode
    extends CoreMethodNode {
        @Node.Child
        private TaintResultNode taintResultNode;

        @CreateCast(value={"salt"})
        public RubyNode coerceSaltToString(RubyNode other) {
            return ToStrNodeGen.create(null, null, other);
        }

        @Specialization(guards={"isRubyString(salt)"})
        @CompilerDirectives.TruffleBoundary
        public Object crypt(DynamicObject string, DynamicObject salt) {
            Rope value = StringOperations.rope(string);
            Rope other = StringOperations.rope(salt);
            Encoding ascii8bit = this.getContext().getJRubyRuntime().getEncodingService().getAscii8bitEncoding();
            if (other.byteLength() < 2) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().argumentError("salt too short (need >= 2 bytes)", this));
            }
            TrufflePosix posix = this.posix();
            byte[] keyBytes = Arrays.copyOfRange(value.getBytes(), 0, value.byteLength());
            byte[] saltBytes = Arrays.copyOfRange(other.getBytes(), 0, other.byteLength());
            if (saltBytes[0] == 0 || saltBytes[1] == 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().argumentError("salt too short (need >= 2 bytes)", this));
            }
            byte[] cryptedString = posix.crypt(keyBytes, saltBytes);
            if (cryptedString == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().errnoError(posix.errno(), this));
            }
            if (this.taintResultNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.taintResultNode = this.insert(new TaintResultNode(this.getContext(), this.getSourceSection()));
            }
            DynamicObject ret = this.createString(StringOperations.ropeFromByteList(new ByteList(cryptedString, 0, cryptedString.length - 1, ascii8bit, false)));
            this.taintResultNode.maybeTaint(string, ret);
            this.taintResultNode.maybeTaint(salt, ret);
            return ret;
        }
    }

    @CoreMethod(names={"count"}, rest=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class CountNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ToStrNode toStr;

        public CountNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.toStr = ToStrNodeGen.create(context, sourceSection, null);
        }

        @Specialization(guards={"isEmpty(string)"})
        public int count(DynamicObject string, Object[] args) {
            return 0;
        }

        @Specialization(guards={"!isEmpty(string)"})
        public int count(VirtualFrame frame, DynamicObject string, Object[] args) {
            if (args.length == 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().argumentErrorEmptyVarargs(this));
            }
            DynamicObject[] otherStrings = new DynamicObject[args.length];
            for (int i = 0; i < args.length; ++i) {
                otherStrings[i] = this.toStr.executeToStr(frame, args[i]);
            }
            return this.countSlow(string, otherStrings);
        }

        @CompilerDirectives.TruffleBoundary
        private int countSlow(DynamicObject string, DynamicObject ... otherStrings) {
            assert (RubyGuards.isRubyString(string));
            DynamicObject otherStr = otherStrings[0];
            Encoding enc = StringOperations.encoding(otherStr);
            boolean[] table = new boolean[257];
            StringSupport.TrTables tables = StringSupport.trSetupTable((ByteList)StringOperations.getByteListReadOnly(otherStr), (Ruby)this.getContext().getJRubyRuntime(), (boolean[])table, null, (boolean)true, (Encoding)enc);
            for (int i = 1; i < otherStrings.length; ++i) {
                otherStr = otherStrings[i];
                assert (RubyGuards.isRubyString(otherStr));
                enc = StringOperations.checkEncoding(this.getContext(), string, otherStr, this);
                tables = StringSupport.trSetupTable((ByteList)StringOperations.getByteListReadOnly(otherStr), (Ruby)this.getContext().getJRubyRuntime(), (boolean[])table, (StringSupport.TrTables)tables, (boolean)false, (Encoding)enc);
            }
            return StringSupport.strCount((ByteList)StringOperations.getByteListReadOnly(string), (Ruby)this.getContext().getJRubyRuntime(), (boolean[])table, (StringSupport.TrTables)tables, (Encoding)enc);
        }
    }

    @CoreMethod(names={"casecmp"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="other")})
    public static abstract class CaseCmpNode
    extends CoreMethodNode {
        @CreateCast(value={"other"})
        public RubyNode coerceOtherToString(RubyNode other) {
            return ToStrNodeGen.create(null, null, other);
        }

        @Specialization(guards={"isRubyString(other)", "bothSingleByteOptimizable(string, other)"})
        @CompilerDirectives.TruffleBoundary
        public Object caseCmpSingleByte(DynamicObject string, DynamicObject other) {
            if (RopeOperations.areCompatible(StringOperations.rope(string), StringOperations.rope(other)) == null) {
                return this.nil();
            }
            return StringOperations.getByteListReadOnly(string).caseInsensitiveCmp(StringOperations.getByteListReadOnly(other));
        }

        @Specialization(guards={"isRubyString(other)", "!bothSingleByteOptimizable(string, other)"})
        @CompilerDirectives.TruffleBoundary
        public Object caseCmp(DynamicObject string, DynamicObject other) {
            Encoding encoding = RopeOperations.areCompatible(StringOperations.rope(string), StringOperations.rope(other));
            if (encoding == null) {
                return this.nil();
            }
            return this.multiByteCasecmp(encoding, StringOperations.getByteListReadOnly(string), StringOperations.getByteListReadOnly(other));
        }

        @CompilerDirectives.TruffleBoundary
        private int multiByteCasecmp(Encoding enc, ByteList value, ByteList otherValue) {
            return StringSupport.multiByteCasecmp((Encoding)enc, (ByteList)value, (ByteList)otherValue);
        }

        public static boolean bothSingleByteOptimizable(DynamicObject string, DynamicObject other) {
            assert (RubyGuards.isRubyString(string));
            assert (RubyGuards.isRubyString(other));
            return StringOperations.rope(string).isSingleByteOptimizable() && StringOperations.rope(other).isSingleByteOptimizable();
        }
    }

    @CoreMethod(names={"bytesize"})
    public static abstract class ByteSizeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int byteSize(DynamicObject string) {
            return StringOperations.rope(string).byteLength();
        }
    }

    @CoreMethod(names={"bytes"}, needsBlock=true)
    public static abstract class BytesNode
    extends YieldingCoreMethodNode {
        @Specialization
        public DynamicObject bytes(VirtualFrame frame, DynamicObject string, NotProvided block) {
            Rope rope = StringOperations.rope(string);
            byte[] bytes = rope.getBytes();
            int[] store = new int[bytes.length];
            for (int n = 0; n < store.length; ++n) {
                store[n] = bytes[n] & 0xFF;
            }
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), store, store.length);
        }

        @Specialization
        public DynamicObject bytes(VirtualFrame frame, DynamicObject string, DynamicObject block) {
            Rope rope = StringOperations.rope(string);
            byte[] bytes = rope.getBytes();
            for (int i = 0; i < bytes.length; ++i) {
                this.yield(frame, block, bytes[i] & 0xFF);
            }
            return string;
        }
    }

    @CoreMethod(names={"b"}, taintFromSelf=true)
    public static abstract class BNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.WithEncodingNode withEncodingNode = RopeNodesFactory.WithEncodingNodeGen.create(null, null, null);

        public BNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject b(DynamicObject string) {
            Rope newRope = this.withEncodingNode.executeWithEncoding(StringOperations.rope(string), (Encoding)ASCIIEncoding.INSTANCE, CodeRange.CR_UNKNOWN);
            return this.createString(newRope);
        }
    }

    @CoreMethod(names={"ascii_only?"})
    @ImportStatic(value={StringGuards.class})
    public static abstract class ASCIIOnlyNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isAsciiCompatible(string)", "is7Bit(string)"})
        public boolean asciiOnlyAsciiCompatible7BitCR(DynamicObject string) {
            return true;
        }

        @Specialization(guards={"isAsciiCompatible(string)", "!is7Bit(string)"})
        public boolean asciiOnlyAsciiCompatible(DynamicObject string) {
            return false;
        }

        @Specialization(guards={"!isAsciiCompatible(string)"})
        public boolean asciiOnly(DynamicObject string) {
            return false;
        }
    }

    @CoreMethod(names={"[]", "slice"}, required=1, optional=1, lowerFixnumParameters={0, 1}, taintFromSelf=true)
    public static abstract class GetIndexNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ToIntNode toIntNode;
        @Node.Child
        private CallDispatchHeadNode includeNode;
        @Node.Child
        private CallDispatchHeadNode dupNode;
        @Node.Child
        private StringPrimitiveNodes.StringSubstringPrimitiveNode substringNode;
        @Node.Child
        private AllocateObjectNode allocateObjectNode;
        private final BranchProfile outOfBounds = BranchProfile.create();

        public GetIndexNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization(guards={"wasNotProvided(length) || isRubiniusUndefined(length)"})
        public Object getIndex(VirtualFrame frame, DynamicObject string, int index, Object length) {
            Rope rope = StringOperations.rope(string);
            int stringLength = rope.characterLength();
            int normalizedIndex = StringOperations.normalizeIndex(stringLength, index);
            if (normalizedIndex < 0 || normalizedIndex >= rope.characterLength()) {
                this.outOfBounds.enter();
                return this.nil();
            }
            return this.getSubstringNode().execute(frame, string, index, 1);
        }

        @Specialization(guards={"!isRubyRange(index)", "!isRubyRegexp(index)", "!isRubyString(index)", "wasNotProvided(length) || isRubiniusUndefined(length)"})
        public Object getIndex(VirtualFrame frame, DynamicObject string, Object index, Object length) {
            return this.getIndex(frame, string, this.getToIntNode().doInt(frame, index), length);
        }

        @Specialization(guards={"isIntegerFixnumRange(range)", "wasNotProvided(length) || isRubiniusUndefined(length)"})
        public Object sliceIntegerRange(VirtualFrame frame, DynamicObject string, DynamicObject range, Object length) {
            return this.sliceRange(frame, string, Layouts.INTEGER_FIXNUM_RANGE.getBegin(range), Layouts.INTEGER_FIXNUM_RANGE.getEnd(range), Layouts.INTEGER_FIXNUM_RANGE.getExcludedEnd(range));
        }

        @Specialization(guards={"isLongFixnumRange(range)", "wasNotProvided(length) || isRubiniusUndefined(length)"})
        public Object sliceLongRange(VirtualFrame frame, DynamicObject string, DynamicObject range, Object length) {
            return this.sliceRange(frame, string, (int)Layouts.LONG_FIXNUM_RANGE.getBegin(range), (int)Layouts.LONG_FIXNUM_RANGE.getEnd(range), Layouts.LONG_FIXNUM_RANGE.getExcludedEnd(range));
        }

        @Specialization(guards={"isObjectRange(range)", "wasNotProvided(length) || isRubiniusUndefined(length)"})
        public Object sliceObjectRange(VirtualFrame frame, DynamicObject string, DynamicObject range, Object length) {
            int coercedBegin = this.getToIntNode().doInt(frame, Layouts.OBJECT_RANGE.getBegin(range));
            int coercedEnd = this.getToIntNode().doInt(frame, Layouts.OBJECT_RANGE.getEnd(range));
            return this.sliceRange(frame, string, coercedBegin, coercedEnd, Layouts.OBJECT_RANGE.getExcludedEnd(range));
        }

        private Object sliceRange(VirtualFrame frame, DynamicObject string, int begin, int end, boolean doesExcludeEnd) {
            assert (RubyGuards.isRubyString(string));
            int stringLength = StringOperations.rope(string).characterLength();
            begin = StringOperations.normalizeIndex(stringLength, begin);
            if (begin < 0 || begin > stringLength) {
                this.outOfBounds.enter();
                return this.nil();
            }
            if (begin == stringLength) {
                ByteList byteList = new ByteList();
                byteList.setEncoding(StringOperations.encoding(string));
                return this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), RopeOperations.withEncodingVerySlow(RopeConstants.EMPTY_ASCII_8BIT_ROPE, StringOperations.encoding(string)), null);
            }
            end = StringOperations.normalizeIndex(stringLength, end);
            int length = StringOperations.clampExclusiveIndex(string, doesExcludeEnd ? end : end + 1);
            if (length > stringLength) {
                length = stringLength;
            }
            if ((length -= begin) < 0) {
                length = 0;
            }
            return this.getSubstringNode().execute(frame, string, begin, length);
        }

        @Specialization
        public Object slice(VirtualFrame frame, DynamicObject string, int start, int length) {
            return this.getSubstringNode().execute(frame, string, start, length);
        }

        @Specialization(guards={"wasProvided(length)"})
        public Object slice(VirtualFrame frame, DynamicObject string, int start, Object length) {
            return this.slice(frame, string, start, this.getToIntNode().doInt(frame, length));
        }

        @Specialization(guards={"!isRubyRange(start)", "!isRubyRegexp(start)", "!isRubyString(start)", "wasProvided(length)"})
        public Object slice(VirtualFrame frame, DynamicObject string, Object start, Object length) {
            return this.slice(frame, string, this.getToIntNode().doInt(frame, start), this.getToIntNode().doInt(frame, length));
        }

        @Specialization(guards={"isRubyRegexp(regexp)", "wasNotProvided(capture) || isRubiniusUndefined(capture)"})
        public Object slice1(VirtualFrame frame, DynamicObject string, DynamicObject regexp, Object capture, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "match, str = subpattern(index, 0); Regexp.last_match = match; str", "index", regexp);
        }

        @Specialization(guards={"isRubyRegexp(regexp)", "wasProvided(capture)"})
        public Object sliceCapture(VirtualFrame frame, DynamicObject string, DynamicObject regexp, Object capture, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "match, str = subpattern(index, other); Regexp.last_match = match; str", "index", regexp, "other", capture);
        }

        @Specialization(guards={"wasNotProvided(length) || isRubiniusUndefined(length)", "isRubyString(matchStr)"})
        public Object slice2(VirtualFrame frame, DynamicObject string, DynamicObject matchStr, Object length) {
            boolean result;
            if (this.includeNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.includeNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            if (result = this.includeNode.callBoolean(frame, string, "include?", null, matchStr)) {
                if (this.dupNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.dupNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
                }
                throw new TaintResultNode.DoNotTaint(this.dupNode.call(frame, matchStr, "dup", null, new Object[0]));
            }
            return this.nil();
        }

        private ToIntNode getToIntNode() {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = this.insert(ToIntNode.create());
            }
            return this.toIntNode;
        }

        private StringPrimitiveNodes.StringSubstringPrimitiveNode getSubstringNode() {
            if (this.substringNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.substringNode = this.insert(StringPrimitiveNodesFactory.StringSubstringPrimitiveNodeFactory.create(new RubyNode[]{null, null, null}));
            }
            return this.substringNode;
        }

        @Override
        protected boolean isRubiniusUndefined(Object object) {
            return object == this.coreLibrary().getRubiniusUndefined();
        }
    }

    @CoreMethod(names={"<<", "concat"}, required=1, taintFromParameter=0, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="other")})
    public static abstract class ConcatNode
    extends CoreMethodNode {
        @Node.Child
        private RopeNodes.MakeConcatNode makeConcatNode;
        @Node.Child
        private StringPrimitiveNodes.StringAppendPrimitiveNode stringAppendNode;

        @Specialization(guards={"isRubyString(other)", "is7Bit(string)", "is7Bit(other)"})
        public DynamicObject concatStringSingleByte(DynamicObject string, DynamicObject other) {
            Rope left = StringOperations.rope(string);
            Rope right = StringOperations.rope(other);
            if (this.makeConcatNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.makeConcatNode = this.insert(RopeNodesFactory.MakeConcatNodeGen.create(null, null, null));
            }
            StringOperations.setRope(string, this.makeConcatNode.executeMake(left, right, left.getEncoding()));
            return string;
        }

        @Specialization(guards={"isRubyString(other)", "!is7Bit(string) || !is7Bit(other)"})
        public Object concatString(DynamicObject string, DynamicObject other) {
            if (this.stringAppendNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.stringAppendNode = this.insert(StringPrimitiveNodesFactory.StringAppendPrimitiveNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[0]));
            }
            return this.stringAppendNode.executeStringAppend(string, other);
        }

        @Specialization(guards={"!isRubyString(other)"})
        public Object concat(VirtualFrame frame, DynamicObject string, Object other, @Cached(value="createMethodCall()") CallDispatchHeadNode callNode) {
            return callNode.call(frame, string, "concat_internal", null, other);
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode cmpNode;
        @Node.Child
        private CmpIntNode cmpIntNode;
        @Node.Child
        private KernelNodes.RespondToNode respondToCmpNode;
        @Node.Child
        private KernelNodes.RespondToNode respondToToStrNode;
        @Node.Child
        private ToStrNode toStrNode;

        @Specialization(guards={"isRubyString(b)"})
        public int compare(DynamicObject a, DynamicObject b) {
            Rope secondRope;
            Rope firstRope = StringOperations.rope(a);
            int ret = RopeOperations.cmp(firstRope, secondRope = StringOperations.rope(b));
            if (ret == 0 && !RopeOperations.areComparable(firstRope, secondRope)) {
                return firstRope.getEncoding().getIndex() > secondRope.getEncoding().getIndex() ? 1 : -1;
            }
            return ret;
        }

        @Specialization(guards={"!isRubyString(b)"})
        public Object compare(VirtualFrame frame, DynamicObject a, Object b) {
            if (this.respondToToStrNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.respondToToStrNode = this.insert(KernelNodesFactory.RespondToNodeFactory.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            if (this.respondToToStrNode.doesRespondToString(frame, b, this.create7BitString("to_str", (Encoding)UTF8Encoding.INSTANCE), false)) {
                if (this.toStrNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.toStrNode = this.insert(ToStrNodeGen.create(this.getContext(), this.getSourceSection(), null));
                }
                try {
                    DynamicObject coerced = this.toStrNode.executeToStr(frame, b);
                    return this.compare(a, coerced);
                }
                catch (RaiseException e) {
                    if (Layouts.BASIC_OBJECT.getLogicalClass(e.getException()) == this.coreLibrary().getTypeErrorClass()) {
                        return this.nil();
                    }
                    throw e;
                }
            }
            if (this.respondToCmpNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.respondToCmpNode = this.insert(KernelNodesFactory.RespondToNodeFactory.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            if (this.respondToCmpNode.doesRespondToString(frame, b, this.create7BitString("<=>", (Encoding)UTF8Encoding.INSTANCE), false)) {
                Object cmpResult;
                if (this.cmpNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.cmpNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
                }
                if ((cmpResult = this.cmpNode.call(frame, b, "<=>", null, a)) == this.nil()) {
                    return this.nil();
                }
                if (this.cmpIntNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.cmpIntNode = this.insert(CmpIntNodeGen.create(this.getContext(), this.getSourceSection(), null, null, null));
                }
                return -this.cmpIntNode.executeCmpInt(frame, cmpResult, a, b);
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"==", "===", "eql?"}, required=1)
    public static abstract class EqualNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private StringPrimitiveNodes.StringEqualPrimitiveNode stringEqualNode = StringPrimitiveNodesFactory.StringEqualPrimitiveNodeFactory.create(new RubyNode[0]);
        @Node.Child
        private KernelNodes.RespondToNode respondToNode;
        @Node.Child
        private CallDispatchHeadNode objectEqualNode;

        public EqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(b)"})
        public boolean equal(DynamicObject a, DynamicObject b) {
            return this.stringEqualNode.executeStringEqual(a, b);
        }

        @Specialization(guards={"!isRubyString(b)"})
        public boolean equal(VirtualFrame frame, DynamicObject a, Object b) {
            if (this.respondToNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.respondToNode = this.insert(KernelNodesFactory.RespondToNodeFactory.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            if (this.respondToNode.doesRespondToString(frame, b, this.create7BitString("to_str", (Encoding)UTF8Encoding.INSTANCE), false)) {
                if (this.objectEqualNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.objectEqualNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
                }
                return this.objectEqualNode.callBoolean(frame, b, "==", null, a);
            }
            return false;
        }
    }

    @CoreMethod(names={"*"}, required=1, lowerFixnumParameters={0}, taintFromSelf=true)
    public static abstract class MulNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode;
        @Node.Child
        private RopeNodes.MakeConcatNode makeConcatNode;
        @Node.Child
        private RopeNodes.MakeLeafRopeNode makeLeafRopeNode;
        @Node.Child
        private ToIntNode toIntNode;

        public MulNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        public abstract DynamicObject executeInt(VirtualFrame var1, DynamicObject var2, int var3);

        @Specialization(guards={"times < 0"})
        @CompilerDirectives.TruffleBoundary
        public DynamicObject multiplyTimesNegative(DynamicObject string, int times) {
            throw new RaiseException(this.coreExceptions().argumentError("negative argument", this));
        }

        @Specialization(guards={"times >= 0"})
        public DynamicObject multiply(DynamicObject string, int times, @Cached(value="create()") RopeNodes.MakeRepeatingNode makeRepeatingNode) {
            Rope repeated = makeRepeatingNode.executeMake(StringOperations.rope(string), times);
            return this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), repeated, null);
        }

        @Specialization(guards={"isRubyBignum(times)"})
        @CompilerDirectives.TruffleBoundary
        public DynamicObject multiply(DynamicObject string, DynamicObject times) {
            throw new RaiseException(this.coreExceptions().rangeError("bignum too big to convert into `long'", (Node)this));
        }

        @Specialization(guards={"!isRubyBignum(times)", "!isInteger(times)"})
        public DynamicObject multiply(VirtualFrame frame, DynamicObject string, Object times) {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = this.insert(ToIntNode.create());
            }
            return this.executeInt(frame, string, this.toIntNode.doInt(frame, times));
        }

        protected static boolean isSingleByteString(DynamicObject string) {
            assert (RubyGuards.isRubyString(string));
            return StringOperations.rope(string).byteLength() == 1;
        }
    }

    @CoreMethod(names={"+"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="other")})
    public static abstract class AddNode
    extends CoreMethodNode {
        @Node.Child
        private RopeNodes.MakeConcatNode makeConcatNode = RopeNodesFactory.MakeConcatNodeGen.create(null, null, null);
        @Node.Child
        private TaintResultNode taintResultNode = new TaintResultNode(null, null);

        public AddNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"other"})
        public RubyNode coerceOtherToString(RubyNode other) {
            return ToStrNodeGen.create(null, null, other);
        }

        @Specialization(guards={"isRubyString(other)", "getEncoding(string) == getEncoding(other)"})
        public DynamicObject addSameEncoding(DynamicObject string, DynamicObject other) {
            return this.add(string, other, this.getEncoding(string));
        }

        @Specialization(guards={"isRubyString(other)", "getEncoding(string) != getEncoding(other)", "isUTF8AndUSASCII(string, other)"})
        public DynamicObject addUTF8AndUSASCII(DynamicObject string, DynamicObject other) {
            return this.add(string, other, (Encoding)UTF8Encoding.INSTANCE);
        }

        @Specialization(guards={"isRubyString(other)", "getEncoding(string) != getEncoding(other)", "!isUTF8AndUSASCII(string, other)"})
        public DynamicObject addDifferentEncodings(DynamicObject string, DynamicObject other) {
            Encoding enc = StringOperations.checkEncoding(this.getContext(), string, other, this);
            return this.add(string, other, enc);
        }

        private DynamicObject add(DynamicObject string, DynamicObject other, Encoding encoding) {
            Rope left = StringOperations.rope(string);
            Rope right = StringOperations.rope(other);
            Rope concatRope = this.makeConcatNode.executeMake(left, right, encoding);
            DynamicObject ret = Layouts.STRING.createString(this.coreLibrary().getStringFactory(), concatRope);
            this.taintResultNode.maybeTaint(string, ret);
            this.taintResultNode.maybeTaint(other, ret);
            return ret;
        }

        protected Encoding getEncoding(DynamicObject string) {
            return Layouts.STRING.getRope(string).getEncoding();
        }

        protected boolean isUTF8AndUSASCII(DynamicObject string, DynamicObject other) {
            Encoding stringEncoding = this.getEncoding(string);
            Encoding otherEncoding = this.getEncoding(other);
            if (stringEncoding != UTF8Encoding.INSTANCE && otherEncoding != UTF8Encoding.INSTANCE) {
                return false;
            }
            return stringEncoding == USASCIIEncoding.INSTANCE || otherEncoding == USASCIIEncoding.INSTANCE;
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode;

        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return this.allocateObjectNode.allocate(rubyClass, RopeConstants.EMPTY_ASCII_8BIT_ROPE, null);
        }
    }
}

