/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.string;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.dsl.internal.SuppressFBWarnings;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.CoreMethodNode;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeNodes;
import org.jruby.truffle.core.string.StringCachingGuards;
import org.jruby.truffle.core.string.StringGuards;
import org.jruby.truffle.core.string.StringNodes;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypes;
import org.jruby.truffle.language.RubyTypesGen;
import org.jruby.truffle.language.SnippetNode;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;

@GeneratedBy(value=StringNodes.class)
public final class StringNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(AllocateNodeFactory.getInstance(), AddNodeFactory.getInstance(), MulNodeFactory.getInstance(), EqualNodeFactory.getInstance(), CompareNodeFactory.getInstance(), ConcatNodeFactory.getInstance(), GetIndexNodeFactory.getInstance(), ASCIIOnlyNodeFactory.getInstance(), BNodeFactory.getInstance(), BytesNodeFactory.getInstance(), ByteSizeNodeFactory.getInstance(), CaseCmpNodeFactory.getInstance(), CountNodeFactory.getInstance(), CryptNodeFactory.getInstance(), DeleteBangNodeFactory.getInstance(), DowncaseBangNodeFactory.getInstance(), EachByteNodeFactory.getInstance(), EachCharNodeFactory.getInstance(), EmptyNodeFactory.getInstance(), EncodingNodeFactory.getInstance(), ForceEncodingNodeFactory.getInstance(), GetByteNodeFactory.getInstance(), HashNodeFactory.getInstance(), InitializeNodeFactory.getInstance(), InitializeCopyNodeFactory.getInstance(), InsertNodeFactory.getInstance(), LstripBangNodeFactory.getInstance(), ModifyBangNodeFactory.getInstance(), SetNumBytesNodeFactory.getInstance(), OrdNodeFactory.getInstance(), ReplaceNodeFactory.getInstance(), RstripBangNodeFactory.getInstance(), SwapcaseBangNodeFactory.getInstance(), DumpNodeFactory.getInstance(), SetByteNodeFactory.getInstance(), SizeNodeFactory.getInstance(), SqueezeBangNodeFactory.getInstance(), SuccBangNodeFactory.getInstance(), SumNodeFactory.getInstance(), ToFNodeFactory.getInstance(), ToSNodeFactory.getInstance(), ToSymNodeFactory.getInstance(), ReverseBangNodeFactory.getInstance(), TrBangNodeFactory.getInstance(), TrSBangNodeFactory.getInstance(), UnpackNodeFactory.getInstance(), UpcaseNodeFactory.getInstance(), UpcaseBangNodeFactory.getInstance(), ValidEncodingQueryNodeFactory.getInstance(), CapitalizeBangNodeFactory.getInstance(), ClearNodeFactory.getInstance());
    }

    @GeneratedBy(value=StringNodes.ClearNode.class)
    public static final class ClearNodeFactory
    extends NodeFactoryBase<StringNodes.ClearNode> {
        private static ClearNodeFactory clearNodeFactoryInstance;

        private ClearNodeFactory() {
            super(StringNodes.ClearNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public StringNodes.ClearNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ClearNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.ClearNode> getInstance() {
            if (clearNodeFactoryInstance == null) {
                clearNodeFactoryInstance = new ClearNodeFactory();
            }
            return clearNodeFactoryInstance;
        }

        public static StringNodes.ClearNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ClearNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.ClearNode.class)
        public static final class ClearNodeGen
        extends StringNodes.ClearNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ClearNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.clear(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=StringNodes.CapitalizeBangNode.class)
    public static final class CapitalizeBangNodeFactory
    extends NodeFactoryBase<StringNodes.CapitalizeBangNode> {
        private static CapitalizeBangNodeFactory capitalizeBangNodeFactoryInstance;

        private CapitalizeBangNodeFactory() {
            super(StringNodes.CapitalizeBangNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public StringNodes.CapitalizeBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CapitalizeBangNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.CapitalizeBangNode> getInstance() {
            if (capitalizeBangNodeFactoryInstance == null) {
                capitalizeBangNodeFactoryInstance = new CapitalizeBangNodeFactory();
            }
            return capitalizeBangNodeFactoryInstance;
        }

        public static StringNodes.CapitalizeBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CapitalizeBangNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.CapitalizeBangNode.class)
        public static final class CapitalizeBangNodeGen
        extends StringNodes.CapitalizeBangNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private CapitalizeBangNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.capitalizeBang(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=StringNodes.ValidEncodingQueryNode.class)
    public static final class ValidEncodingQueryNodeFactory
    extends NodeFactoryBase<StringNodes.ValidEncodingQueryNode> {
        private static ValidEncodingQueryNodeFactory validEncodingQueryNodeFactoryInstance;

        private ValidEncodingQueryNodeFactory() {
            super(StringNodes.ValidEncodingQueryNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public StringNodes.ValidEncodingQueryNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ValidEncodingQueryNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.ValidEncodingQueryNode> getInstance() {
            if (validEncodingQueryNodeFactoryInstance == null) {
                validEncodingQueryNodeFactoryInstance = new ValidEncodingQueryNodeFactory();
            }
            return validEncodingQueryNodeFactoryInstance;
        }

        public static StringNodes.ValidEncodingQueryNode create(RubyNode[] arguments) {
            return new ValidEncodingQueryNodeGen(arguments);
        }

        @GeneratedBy(value=StringNodes.ValidEncodingQueryNode.class)
        public static final class ValidEncodingQueryNodeGen
        extends StringNodes.ValidEncodingQueryNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private ValidEncodingQueryNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="validEncodingQuery(DynamicObject)", value=StringNodes.ValidEncodingQueryNode.class)
            private static final class ValidEncodingQueryNode_
            extends BaseNode_ {
                ValidEncodingQueryNode_(ValidEncodingQueryNodeGen root) {
                    super(root, 2);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    if (!StringGuards.isBrokenCodeRange(arguments0Value_)) {
                        return this.root.validEncodingQuery(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && !StringGuards.isBrokenCodeRange(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.validEncodingQuery(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ValidEncodingQueryNodeGen root) {
                    return new ValidEncodingQueryNode_(root);
                }
            }

            @GeneratedBy(methodName="validEncodingQueryBroken(DynamicObject)", value=StringNodes.ValidEncodingQueryNode.class)
            private static final class ValidEncodingQueryBrokenNode_
            extends BaseNode_ {
                ValidEncodingQueryBrokenNode_(ValidEncodingQueryNodeGen root) {
                    super(root, 1);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    if (StringGuards.isBrokenCodeRange(arguments0Value_)) {
                        return this.root.validEncodingQueryBroken(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && StringGuards.isBrokenCodeRange(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.validEncodingQueryBroken(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ValidEncodingQueryNodeGen root) {
                    return new ValidEncodingQueryBrokenNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.ValidEncodingQueryNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ValidEncodingQueryNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ValidEncodingQueryNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.ValidEncodingQueryNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ValidEncodingQueryNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ValidEncodingQueryNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.ValidEncodingQueryNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ValidEncodingQueryNodeGen root;

                BaseNode_(ValidEncodingQueryNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (ValidEncodingQueryNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeBoolean_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeBoolean_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (StringGuards.isBrokenCodeRange(arguments0Value_)) {
                            return ValidEncodingQueryBrokenNode_.create(this.root);
                        }
                        return ValidEncodingQueryNode_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.UpcaseBangNode.class)
    public static final class UpcaseBangNodeFactory
    extends NodeFactoryBase<StringNodes.UpcaseBangNode> {
        private static UpcaseBangNodeFactory upcaseBangNodeFactoryInstance;

        private UpcaseBangNodeFactory() {
            super(StringNodes.UpcaseBangNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public StringNodes.UpcaseBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return UpcaseBangNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.UpcaseBangNode> getInstance() {
            if (upcaseBangNodeFactoryInstance == null) {
                upcaseBangNodeFactoryInstance = new UpcaseBangNodeFactory();
            }
            return upcaseBangNodeFactoryInstance;
        }

        public static StringNodes.UpcaseBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new UpcaseBangNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.UpcaseBangNode.class)
        public static final class UpcaseBangNodeGen
        extends StringNodes.UpcaseBangNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private UpcaseBangNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="upcase(DynamicObject)", value=StringNodes.UpcaseBangNode.class)
            private static final class UpcaseNode_
            extends BaseNode_ {
                UpcaseNode_(UpcaseBangNodeGen root) {
                    super(root, 2);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && !StringGuards.isSingleByteOptimizable(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.upcase(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(UpcaseBangNodeGen root) {
                    return new UpcaseNode_(root);
                }
            }

            @GeneratedBy(methodName="upcaseSingleByte(DynamicObject, ConditionProfile, ConditionProfile)", value=StringNodes.UpcaseBangNode.class)
            private static final class UpcaseSingleByteNode_
            extends BaseNode_ {
                private final ConditionProfile isEmptyProfile;
                private final ConditionProfile modifiedProfile;

                UpcaseSingleByteNode_(UpcaseBangNodeGen root, ConditionProfile isEmptyProfile, ConditionProfile modifiedProfile) {
                    super(root, 1);
                    this.isEmptyProfile = isEmptyProfile;
                    this.modifiedProfile = modifiedProfile;
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && StringGuards.isSingleByteOptimizable(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.upcaseSingleByte(arguments0Value_, this.isEmptyProfile, this.modifiedProfile);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(UpcaseBangNodeGen root, ConditionProfile isEmptyProfile, ConditionProfile modifiedProfile) {
                    return new UpcaseSingleByteNode_(root, isEmptyProfile, modifiedProfile);
                }
            }

            @GeneratedBy(value=StringNodes.UpcaseBangNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(UpcaseBangNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(UpcaseBangNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.UpcaseBangNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(UpcaseBangNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(UpcaseBangNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.UpcaseBangNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected UpcaseBangNodeGen root;

                BaseNode_(UpcaseBangNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (UpcaseBangNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (StringGuards.isSingleByteOptimizable(arguments0Value_)) {
                            ConditionProfile isEmptyProfile1 = ConditionProfile.createBinaryProfile();
                            ConditionProfile modifiedProfile1 = ConditionProfile.createBinaryProfile();
                            return UpcaseSingleByteNode_.create(this.root, isEmptyProfile1, modifiedProfile1);
                        }
                        return UpcaseNode_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.UpcaseNode.class)
    public static final class UpcaseNodeFactory
    extends NodeFactoryBase<StringNodes.UpcaseNode> {
        private static UpcaseNodeFactory upcaseNodeFactoryInstance;

        private UpcaseNodeFactory() {
            super(StringNodes.UpcaseNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public StringNodes.UpcaseNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return UpcaseNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.UpcaseNode> getInstance() {
            if (upcaseNodeFactoryInstance == null) {
                upcaseNodeFactoryInstance = new UpcaseNodeFactory();
            }
            return upcaseNodeFactoryInstance;
        }

        public static StringNodes.UpcaseNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new UpcaseNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.UpcaseNode.class)
        public static final class UpcaseNodeGen
        extends StringNodes.UpcaseNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private UpcaseNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.upcase(frameValue, arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=StringNodes.UnpackNode.class)
    public static final class UnpackNodeFactory
    extends NodeFactoryBase<StringNodes.UnpackNode> {
        private static UnpackNodeFactory unpackNodeFactoryInstance;

        private UnpackNodeFactory() {
            super(StringNodes.UnpackNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public StringNodes.UnpackNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return UnpackNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.UnpackNode> getInstance() {
            if (unpackNodeFactoryInstance == null) {
                unpackNodeFactoryInstance = new UnpackNodeFactory();
            }
            return unpackNodeFactoryInstance;
        }

        public static StringNodes.UnpackNode create(RubyNode[] arguments) {
            return new UnpackNodeGen(arguments);
        }

        @GeneratedBy(value=StringNodes.UnpackNode.class)
        public static final class UnpackNodeGen
        extends StringNodes.UnpackNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeUnpackCached_;
            @Node.Child
            private BaseNode_ specialization_;

            private UnpackNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="unpack(VirtualFrame, DynamicObject, Object, SnippetNode)", value=StringNodes.UnpackNode.class)
            private static final class UnpackNode_
            extends BaseNode_ {
                @Node.Child
                private SnippetNode snippetNode;

                UnpackNode_(UnpackNodeGen root, SnippetNode snippetNode) {
                    super(root, 3);
                    this.snippetNode = snippetNode;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (!(RubyGuards.isRubyString(arguments1Value) || RubyGuards.isBoolean(arguments1Value) || RubyGuards.isInteger(arguments1Value) || RubyGuards.isLong(arguments1Value) || this.root.isNil(arguments1Value))) {
                            return this.root.unpack(frameValue, arguments0Value_, arguments1Value, this.snippetNode);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(UnpackNodeGen root, SnippetNode snippetNode) {
                    return new UnpackNode_(root, snippetNode);
                }
            }

            @GeneratedBy(methodName="unpackUncached(VirtualFrame, DynamicObject, DynamicObject, IndirectCallNode)", value=StringNodes.UnpackNode.class)
            private static final class UnpackUncachedNode_
            extends BaseNode_ {
                @Node.Child
                private IndirectCallNode callUnpackNode;

                UnpackUncachedNode_(UnpackNodeGen root, IndirectCallNode callUnpackNode) {
                    super(root, 2);
                    this.callUnpackNode = callUnpackNode;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.unpackUncached(frameValue, arguments0Value_, arguments1Value_, this.callUnpackNode);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(UnpackNodeGen root, IndirectCallNode callUnpackNode) {
                    return new UnpackUncachedNode_(root, callUnpackNode);
                }
            }

            @GeneratedBy(methodName="unpackCached(VirtualFrame, DynamicObject, DynamicObject, Rope, DirectCallNode)", value=StringNodes.UnpackNode.class)
            private static final class UnpackCachedNode_
            extends BaseNode_ {
                private final Rope cachedFormat;
                @Node.Child
                private DirectCallNode callUnpackNode;

                UnpackCachedNode_(UnpackNodeGen root, Rope cachedFormat, DirectCallNode callUnpackNode) {
                    super(root, 1);
                    this.cachedFormat = cachedFormat;
                    this.callUnpackNode = callUnpackNode;
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (newNode.getClass() == UnpackUncachedNode_.class) {
                        this.removeSame("Contained by unpackUncached(VirtualFrame, DynamicObject, DynamicObject, IndirectCallNode)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments1Value_;
                    return arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && RubyGuards.isRubyString(arguments1Value_ = (DynamicObject)arguments1Value) && StringCachingGuards.ropesEqual(arguments1Value_, this.cachedFormat);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments1Value_) && StringCachingGuards.ropesEqual(arguments1Value_, this.cachedFormat)) {
                            return this.root.unpackCached(frameValue, arguments0Value_, arguments1Value_, this.cachedFormat, this.callUnpackNode);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(UnpackNodeGen root, Rope cachedFormat, DirectCallNode callUnpackNode) {
                    return new UnpackCachedNode_(root, cachedFormat, callUnpackNode);
                }
            }

            @GeneratedBy(value=StringNodes.UnpackNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(UnpackNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(UnpackNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.UnpackNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(UnpackNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(UnpackNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.UnpackNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected UnpackNodeGen root;

                BaseNode_(UnpackNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (UnpackNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        if (arguments1Value instanceof DynamicObject) {
                            DirectCallNode callUnpackNode1;
                            BaseNode_ s;
                            DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                            Rope cachedFormat1 = StringCachingGuards.privatizeRope(arguments1Value_);
                            if (RubyGuards.isRubyString(arguments1Value_) && StringCachingGuards.ropesEqual(arguments1Value_, cachedFormat1) && !this.root.excludeUnpackCached_ && this.countSame(s = UnpackCachedNode_.create(this.root, cachedFormat1, callUnpackNode1 = DirectCallNode.create(this.root.compileFormat(arguments1Value_)))) < this.root.getCacheLimit()) {
                                return s;
                            }
                            if (RubyGuards.isRubyString(arguments1Value_)) {
                                IndirectCallNode callUnpackNode2 = IndirectCallNode.create();
                                this.root.excludeUnpackCached_ = true;
                                return UnpackUncachedNode_.create(this.root, callUnpackNode2);
                            }
                        }
                        if (!(RubyGuards.isRubyString(arguments1Value) || RubyGuards.isBoolean(arguments1Value) || RubyGuards.isInteger(arguments1Value) || RubyGuards.isLong(arguments1Value) || this.root.isNil(arguments1Value))) {
                            SnippetNode snippetNode3 = new SnippetNode();
                            return UnpackNode_.create(this.root, snippetNode3);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.TrSBangNode.class)
    public static final class TrSBangNodeFactory
    extends NodeFactoryBase<StringNodes.TrSBangNode> {
        private static TrSBangNodeFactory trSBangNodeFactoryInstance;

        private TrSBangNodeFactory() {
            super(StringNodes.TrSBangNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public StringNodes.TrSBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyNode) || arguments[1] != null && !(arguments[1] instanceof RubyNode) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return TrSBangNodeFactory.create((RubyNode)arguments[0], (RubyNode)arguments[1], (RubyNode)arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.TrSBangNode> getInstance() {
            if (trSBangNodeFactoryInstance == null) {
                trSBangNodeFactoryInstance = new TrSBangNodeFactory();
            }
            return trSBangNodeFactoryInstance;
        }

        public static StringNodes.TrSBangNode create(RubyNode self, RubyNode fromStr, RubyNode toStrNode) {
            return new TrSBangNodeGen(self, fromStr, toStrNode);
        }

        @GeneratedBy(value=StringNodes.TrSBangNode.class)
        public static final class TrSBangNodeGen
        extends StringNodes.TrSBangNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode self_;
            @Node.Child
            private RubyNode fromStr_;
            @Node.Child
            private RubyNode toStrNode_;
            @Node.Child
            private BaseNode_ specialization_;

            private TrSBangNodeGen(RubyNode self, RubyNode fromStr, RubyNode toStrNode) {
                this.self_ = self;
                this.fromStr_ = this.coerceFromStrToString(fromStr);
                this.toStrNode_ = this.coerceToStrToString(toStrNode);
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="trSBang(VirtualFrame, DynamicObject, DynamicObject, DynamicObject)", value=StringNodes.TrSBangNode.class)
            private static final class TrSBangNode_
            extends BaseNode_ {
                TrSBangNode_(TrSBangNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object selfValue, Object fromStrValue, Object toStrNodeValue) {
                    if (selfValue instanceof DynamicObject && fromStrValue instanceof DynamicObject && toStrNodeValue instanceof DynamicObject) {
                        DynamicObject selfValue_ = (DynamicObject)selfValue;
                        DynamicObject fromStrValue_ = (DynamicObject)fromStrValue;
                        DynamicObject toStrNodeValue_ = (DynamicObject)toStrNodeValue;
                        if (!StringGuards.isEmpty(selfValue_) && RubyGuards.isRubyString(fromStrValue_) && RubyGuards.isRubyString(toStrNodeValue_)) {
                            return this.root.trSBang(frameValue, selfValue_, fromStrValue_, toStrNodeValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, selfValue, fromStrValue, toStrNodeValue);
                }

                static BaseNode_ create(TrSBangNodeGen root) {
                    return new TrSBangNode_(root);
                }
            }

            @GeneratedBy(methodName="trSBangEmpty(DynamicObject, DynamicObject, DynamicObject)", value=StringNodes.TrSBangNode.class)
            private static final class TrSBangEmptyNode_
            extends BaseNode_ {
                TrSBangEmptyNode_(TrSBangNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object selfValue, Object fromStrValue, Object toStrNodeValue) {
                    if (selfValue instanceof DynamicObject && fromStrValue instanceof DynamicObject && toStrNodeValue instanceof DynamicObject) {
                        DynamicObject selfValue_ = (DynamicObject)selfValue;
                        DynamicObject fromStrValue_ = (DynamicObject)fromStrValue;
                        DynamicObject toStrNodeValue_ = (DynamicObject)toStrNodeValue;
                        if (StringGuards.isEmpty(selfValue_)) {
                            return this.root.trSBangEmpty(selfValue_, fromStrValue_, toStrNodeValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, selfValue, fromStrValue, toStrNodeValue);
                }

                static BaseNode_ create(TrSBangNodeGen root) {
                    return new TrSBangEmptyNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.TrSBangNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(TrSBangNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object selfValue, Object fromStrValue, Object toStrNodeValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, selfValue, fromStrValue, toStrNodeValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object selfValue, Object fromStrValue, Object toStrNodeValue) {
                    return this.getNext().execute_(frameValue, selfValue, fromStrValue, toStrNodeValue);
                }

                static BaseNode_ create(TrSBangNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.TrSBangNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(TrSBangNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object selfValue, Object fromStrValue, Object toStrNodeValue) {
                    return this.uninitialized((Frame)frameValue, selfValue, fromStrValue, toStrNodeValue);
                }

                static BaseNode_ create(TrSBangNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.TrSBangNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected TrSBangNodeGen root;

                BaseNode_(TrSBangNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (TrSBangNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.self_, this.root.fromStr_, this.root.toStrNode_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object selfValue, Object fromStrValue, Object toStrNodeValue) {
                    return this.execute_((VirtualFrame)frameValue, selfValue, fromStrValue, toStrNodeValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object selfValue_ = this.root.self_.execute(frameValue);
                    Object fromStrValue_ = this.root.fromStr_.execute(frameValue);
                    Object toStrNodeValue_ = this.root.toStrNode_.execute(frameValue);
                    return this.execute_(frameValue, selfValue_, fromStrValue_, toStrNodeValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object selfValue, Object fromStrValue, Object toStrNodeValue) {
                    if (selfValue instanceof DynamicObject && fromStrValue instanceof DynamicObject && toStrNodeValue instanceof DynamicObject) {
                        DynamicObject selfValue_ = (DynamicObject)selfValue;
                        DynamicObject fromStrValue_ = (DynamicObject)fromStrValue;
                        DynamicObject toStrNodeValue_ = (DynamicObject)toStrNodeValue;
                        if (StringGuards.isEmpty(selfValue_)) {
                            return TrSBangEmptyNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyString(fromStrValue_) && RubyGuards.isRubyString(toStrNodeValue_)) {
                            return TrSBangNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.TrBangNode.class)
    public static final class TrBangNodeFactory
    extends NodeFactoryBase<StringNodes.TrBangNode> {
        private static TrBangNodeFactory trBangNodeFactoryInstance;

        private TrBangNodeFactory() {
            super(StringNodes.TrBangNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public StringNodes.TrBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyNode) || arguments[1] != null && !(arguments[1] instanceof RubyNode) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return TrBangNodeFactory.create((RubyNode)arguments[0], (RubyNode)arguments[1], (RubyNode)arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.TrBangNode> getInstance() {
            if (trBangNodeFactoryInstance == null) {
                trBangNodeFactoryInstance = new TrBangNodeFactory();
            }
            return trBangNodeFactoryInstance;
        }

        public static StringNodes.TrBangNode create(RubyNode self, RubyNode fromStr, RubyNode toStrNode) {
            return new TrBangNodeGen(self, fromStr, toStrNode);
        }

        @GeneratedBy(value=StringNodes.TrBangNode.class)
        public static final class TrBangNodeGen
        extends StringNodes.TrBangNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode self_;
            @Node.Child
            private RubyNode fromStr_;
            @Node.Child
            private RubyNode toStrNode_;
            @Node.Child
            private BaseNode_ specialization_;

            private TrBangNodeGen(RubyNode self, RubyNode fromStr, RubyNode toStrNode) {
                this.self_ = self;
                this.fromStr_ = this.coerceFromStrToString(fromStr);
                this.toStrNode_ = this.coerceToStrToString(toStrNode);
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="trBang(VirtualFrame, DynamicObject, DynamicObject, DynamicObject)", value=StringNodes.TrBangNode.class)
            private static final class TrBangNode_
            extends BaseNode_ {
                TrBangNode_(TrBangNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object selfValue, Object fromStrValue, Object toStrNodeValue) {
                    if (selfValue instanceof DynamicObject && fromStrValue instanceof DynamicObject && toStrNodeValue instanceof DynamicObject) {
                        DynamicObject selfValue_ = (DynamicObject)selfValue;
                        DynamicObject fromStrValue_ = (DynamicObject)fromStrValue;
                        DynamicObject toStrNodeValue_ = (DynamicObject)toStrNodeValue;
                        if (!StringGuards.isEmpty(selfValue_) && RubyGuards.isRubyString(fromStrValue_) && RubyGuards.isRubyString(toStrNodeValue_)) {
                            return this.root.trBang(frameValue, selfValue_, fromStrValue_, toStrNodeValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, selfValue, fromStrValue, toStrNodeValue);
                }

                static BaseNode_ create(TrBangNodeGen root) {
                    return new TrBangNode_(root);
                }
            }

            @GeneratedBy(methodName="trBangEmpty(DynamicObject, DynamicObject, DynamicObject)", value=StringNodes.TrBangNode.class)
            private static final class TrBangEmptyNode_
            extends BaseNode_ {
                TrBangEmptyNode_(TrBangNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object selfValue, Object fromStrValue, Object toStrNodeValue) {
                    if (selfValue instanceof DynamicObject && fromStrValue instanceof DynamicObject && toStrNodeValue instanceof DynamicObject) {
                        DynamicObject selfValue_ = (DynamicObject)selfValue;
                        DynamicObject fromStrValue_ = (DynamicObject)fromStrValue;
                        DynamicObject toStrNodeValue_ = (DynamicObject)toStrNodeValue;
                        if (StringGuards.isEmpty(selfValue_)) {
                            return this.root.trBangEmpty(selfValue_, fromStrValue_, toStrNodeValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, selfValue, fromStrValue, toStrNodeValue);
                }

                static BaseNode_ create(TrBangNodeGen root) {
                    return new TrBangEmptyNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.TrBangNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(TrBangNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object selfValue, Object fromStrValue, Object toStrNodeValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, selfValue, fromStrValue, toStrNodeValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object selfValue, Object fromStrValue, Object toStrNodeValue) {
                    return this.getNext().execute_(frameValue, selfValue, fromStrValue, toStrNodeValue);
                }

                static BaseNode_ create(TrBangNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.TrBangNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(TrBangNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object selfValue, Object fromStrValue, Object toStrNodeValue) {
                    return this.uninitialized((Frame)frameValue, selfValue, fromStrValue, toStrNodeValue);
                }

                static BaseNode_ create(TrBangNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.TrBangNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected TrBangNodeGen root;

                BaseNode_(TrBangNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (TrBangNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.self_, this.root.fromStr_, this.root.toStrNode_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object selfValue, Object fromStrValue, Object toStrNodeValue) {
                    return this.execute_((VirtualFrame)frameValue, selfValue, fromStrValue, toStrNodeValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object selfValue_ = this.root.self_.execute(frameValue);
                    Object fromStrValue_ = this.root.fromStr_.execute(frameValue);
                    Object toStrNodeValue_ = this.root.toStrNode_.execute(frameValue);
                    return this.execute_(frameValue, selfValue_, fromStrValue_, toStrNodeValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object selfValue, Object fromStrValue, Object toStrNodeValue) {
                    if (selfValue instanceof DynamicObject && fromStrValue instanceof DynamicObject && toStrNodeValue instanceof DynamicObject) {
                        DynamicObject selfValue_ = (DynamicObject)selfValue;
                        DynamicObject fromStrValue_ = (DynamicObject)fromStrValue;
                        DynamicObject toStrNodeValue_ = (DynamicObject)toStrNodeValue;
                        if (StringGuards.isEmpty(selfValue_)) {
                            return TrBangEmptyNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyString(fromStrValue_) && RubyGuards.isRubyString(toStrNodeValue_)) {
                            return TrBangNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.ReverseBangNode.class)
    public static final class ReverseBangNodeFactory
    extends NodeFactoryBase<StringNodes.ReverseBangNode> {
        private static ReverseBangNodeFactory reverseBangNodeFactoryInstance;

        private ReverseBangNodeFactory() {
            super(StringNodes.ReverseBangNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public StringNodes.ReverseBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ReverseBangNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.ReverseBangNode> getInstance() {
            if (reverseBangNodeFactoryInstance == null) {
                reverseBangNodeFactoryInstance = new ReverseBangNodeFactory();
            }
            return reverseBangNodeFactoryInstance;
        }

        public static StringNodes.ReverseBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ReverseBangNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.ReverseBangNode.class)
        public static final class ReverseBangNodeGen
        extends StringNodes.ReverseBangNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private ReverseBangNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="reverse(DynamicObject)", value=StringNodes.ReverseBangNode.class)
            private static final class ReverseNode_
            extends BaseNode_ {
                ReverseNode_(ReverseBangNodeGen root) {
                    super(root, 3);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && !StringNodes.ReverseBangNode.reverseIsEqualToSelf(arguments0Value_ = (DynamicObject)arguments0Value) && !StringGuards.isSingleByteOptimizable(arguments0Value_)) {
                        return this.root.reverse(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ReverseBangNodeGen root) {
                    return new ReverseNode_(root);
                }
            }

            @GeneratedBy(methodName="reverseSingleByteOptimizable(DynamicObject)", value=StringNodes.ReverseBangNode.class)
            private static final class ReverseSingleByteOptimizableNode_
            extends BaseNode_ {
                ReverseSingleByteOptimizableNode_(ReverseBangNodeGen root) {
                    super(root, 2);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && !StringNodes.ReverseBangNode.reverseIsEqualToSelf(arguments0Value_ = (DynamicObject)arguments0Value) && StringGuards.isSingleByteOptimizable(arguments0Value_)) {
                        return this.root.reverseSingleByteOptimizable(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ReverseBangNodeGen root) {
                    return new ReverseSingleByteOptimizableNode_(root);
                }
            }

            @GeneratedBy(methodName="reverseNoOp(DynamicObject)", value=StringNodes.ReverseBangNode.class)
            private static final class ReverseNoOpNode_
            extends BaseNode_ {
                ReverseNoOpNode_(ReverseBangNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && StringNodes.ReverseBangNode.reverseIsEqualToSelf(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.reverseNoOp(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ReverseBangNodeGen root) {
                    return new ReverseNoOpNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.ReverseBangNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ReverseBangNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ReverseBangNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.ReverseBangNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ReverseBangNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ReverseBangNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.ReverseBangNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ReverseBangNodeGen root;

                BaseNode_(ReverseBangNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (ReverseBangNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (StringNodes.ReverseBangNode.reverseIsEqualToSelf(arguments0Value_)) {
                            return ReverseNoOpNode_.create(this.root);
                        }
                        if (StringGuards.isSingleByteOptimizable(arguments0Value_)) {
                            return ReverseSingleByteOptimizableNode_.create(this.root);
                        }
                        if (!StringNodes.ReverseBangNode.reverseIsEqualToSelf(arguments0Value_) && !StringGuards.isSingleByteOptimizable(arguments0Value_)) {
                            return ReverseNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.ToSymNode.class)
    public static final class ToSymNodeFactory
    extends NodeFactoryBase<StringNodes.ToSymNode> {
        private static ToSymNodeFactory toSymNodeFactoryInstance;

        private ToSymNodeFactory() {
            super(StringNodes.ToSymNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public StringNodes.ToSymNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ToSymNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.ToSymNode> getInstance() {
            if (toSymNodeFactoryInstance == null) {
                toSymNodeFactoryInstance = new ToSymNodeFactory();
            }
            return toSymNodeFactoryInstance;
        }

        public static StringNodes.ToSymNode create(RubyNode[] arguments) {
            return new ToSymNodeGen(arguments);
        }

        @GeneratedBy(value=StringNodes.ToSymNode.class)
        public static final class ToSymNodeGen
        extends StringNodes.ToSymNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ToSymNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.toSym(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=StringNodes.ToSNode.class)
    public static final class ToSNodeFactory
    extends NodeFactoryBase<StringNodes.ToSNode> {
        private static ToSNodeFactory toSNodeFactoryInstance;

        private ToSNodeFactory() {
            super(StringNodes.ToSNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public StringNodes.ToSNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ToSNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.ToSNode> getInstance() {
            if (toSNodeFactoryInstance == null) {
                toSNodeFactoryInstance = new ToSNodeFactory();
            }
            return toSNodeFactoryInstance;
        }

        public static StringNodes.ToSNode create(RubyNode[] arguments) {
            return new ToSNodeGen(arguments);
        }

        @GeneratedBy(value=StringNodes.ToSNode.class)
        public static final class ToSNodeGen
        extends StringNodes.ToSNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private ToSNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="toSOnSubclass(VirtualFrame, DynamicObject, SnippetNode)", value=StringNodes.ToSNode.class)
            private static final class ToSOnSubclassNode_
            extends BaseNode_ {
                @Node.Child
                private SnippetNode snippetNode;

                ToSOnSubclassNode_(ToSNodeGen root, SnippetNode snippetNode) {
                    super(root, 2);
                    this.snippetNode = snippetNode;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && this.root.isStringSubclass(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.toSOnSubclass(frameValue, arguments0Value_, this.snippetNode);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ToSNodeGen root, SnippetNode snippetNode) {
                    return new ToSOnSubclassNode_(root, snippetNode);
                }
            }

            @GeneratedBy(methodName="toS(DynamicObject)", value=StringNodes.ToSNode.class)
            private static final class ToSNode_
            extends BaseNode_ {
                ToSNode_(ToSNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && !this.root.isStringSubclass(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.toS(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ToSNodeGen root) {
                    return new ToSNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.ToSNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ToSNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ToSNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.ToSNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ToSNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ToSNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.ToSNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ToSNodeGen root;

                BaseNode_(ToSNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (ToSNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (!this.root.isStringSubclass(arguments0Value_)) {
                            return ToSNode_.create(this.root);
                        }
                        SnippetNode snippetNode2 = new SnippetNode();
                        return ToSOnSubclassNode_.create(this.root, snippetNode2);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.ToFNode.class)
    public static final class ToFNodeFactory
    extends NodeFactoryBase<StringNodes.ToFNode> {
        private static ToFNodeFactory toFNodeFactoryInstance;

        private ToFNodeFactory() {
            super(StringNodes.ToFNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public StringNodes.ToFNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ToFNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.ToFNode> getInstance() {
            if (toFNodeFactoryInstance == null) {
                toFNodeFactoryInstance = new ToFNodeFactory();
            }
            return toFNodeFactoryInstance;
        }

        public static StringNodes.ToFNode create(RubyNode[] arguments) {
            return new ToFNodeGen(arguments);
        }

        @GeneratedBy(value=StringNodes.ToFNode.class)
        public static final class ToFNodeGen
        extends StringNodes.ToFNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ToFNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeDouble(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeDouble(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.toF(arguments0Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=StringNodes.SumNode.class)
    public static final class SumNodeFactory
    extends NodeFactoryBase<StringNodes.SumNode> {
        private static SumNodeFactory sumNodeFactoryInstance;

        private SumNodeFactory() {
            super(StringNodes.SumNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public StringNodes.SumNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SumNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.SumNode> getInstance() {
            if (sumNodeFactoryInstance == null) {
                sumNodeFactoryInstance = new SumNodeFactory();
            }
            return sumNodeFactoryInstance;
        }

        public static StringNodes.SumNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SumNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.SumNode.class)
        public static final class SumNodeGen
        extends StringNodes.SumNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private SumNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="sum(VirtualFrame, DynamicObject, Object, SnippetNode)", value=StringNodes.SumNode.class)
            private static final class Sum3Node_
            extends BaseNode_ {
                @Node.Child
                private SnippetNode snippetNode;

                Sum3Node_(SumNodeGen root, SnippetNode snippetNode) {
                    super(root, 4);
                    this.snippetNode = snippetNode;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (!RubyGuards.isInteger(arguments1Value) && !RubyGuards.isLong(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                            return this.root.sum(frameValue, arguments0Value_, arguments1Value, this.snippetNode);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SumNodeGen root, SnippetNode snippetNode) {
                    return new Sum3Node_(root, snippetNode);
                }
            }

            @GeneratedBy(methodName="sum(VirtualFrame, DynamicObject, NotProvided)", value=StringNodes.SumNode.class)
            private static final class Sum2Node_
            extends BaseNode_ {
                Sum2Node_(SumNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.sum(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SumNodeGen root) {
                    return new Sum2Node_(root);
                }
            }

            @GeneratedBy(methodName="sum(VirtualFrame, DynamicObject, long)", value=StringNodes.SumNode.class)
            private static final class Sum1Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Sum1Node_(SumNodeGen root, Object arguments1Value) {
                    super(root, 2);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Sum1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    long arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Long.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                        } else if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = RubyTypes.promoteToLong(this.root.arguments1_.executeInteger(frameValue));
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitLong(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.sum(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.sum(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SumNodeGen root, Object arguments1Value) {
                    return new Sum1Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="sum(VirtualFrame, DynamicObject, int)", value=StringNodes.SumNode.class)
            private static final class Sum0Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Sum0Node_(SumNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Sum0Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.sum(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        return this.root.sum(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SumNodeGen root, Object arguments1Value) {
                    return new Sum0Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=StringNodes.SumNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SumNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SumNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.SumNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SumNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SumNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.SumNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected SumNodeGen root;

                BaseNode_(SumNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (SumNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        if (RubyTypesGen.isImplicitInteger(arguments1Value)) {
                            return Sum0Node_.create(this.root, arguments1Value);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Sum1Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof NotProvided) {
                            return Sum2Node_.create(this.root);
                        }
                        if (!RubyGuards.isInteger(arguments1Value) && !RubyGuards.isLong(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                            SnippetNode snippetNode4 = new SnippetNode();
                            return Sum3Node_.create(this.root, snippetNode4);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.SuccBangNode.class)
    public static final class SuccBangNodeFactory
    extends NodeFactoryBase<StringNodes.SuccBangNode> {
        private static SuccBangNodeFactory succBangNodeFactoryInstance;

        private SuccBangNodeFactory() {
            super(StringNodes.SuccBangNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public StringNodes.SuccBangNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SuccBangNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.SuccBangNode> getInstance() {
            if (succBangNodeFactoryInstance == null) {
                succBangNodeFactoryInstance = new SuccBangNodeFactory();
            }
            return succBangNodeFactoryInstance;
        }

        public static StringNodes.SuccBangNode create(RubyNode[] arguments) {
            return new SuccBangNodeGen(arguments);
        }

        @GeneratedBy(value=StringNodes.SuccBangNode.class)
        public static final class SuccBangNodeGen
        extends StringNodes.SuccBangNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private SuccBangNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.succBang(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=StringNodes.SqueezeBangNode.class)
    public static final class SqueezeBangNodeFactory
    extends NodeFactoryBase<StringNodes.SqueezeBangNode> {
        private static SqueezeBangNodeFactory squeezeBangNodeFactoryInstance;

        private SqueezeBangNodeFactory() {
            super(StringNodes.SqueezeBangNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public StringNodes.SqueezeBangNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SqueezeBangNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.SqueezeBangNode> getInstance() {
            if (squeezeBangNodeFactoryInstance == null) {
                squeezeBangNodeFactoryInstance = new SqueezeBangNodeFactory();
            }
            return squeezeBangNodeFactoryInstance;
        }

        public static StringNodes.SqueezeBangNode create(RubyNode[] arguments) {
            return new SqueezeBangNodeGen(arguments);
        }

        @GeneratedBy(value=StringNodes.SqueezeBangNode.class)
        public static final class SqueezeBangNodeGen
        extends StringNodes.SqueezeBangNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private SqueezeBangNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="squeezeBang(VirtualFrame, DynamicObject, Object[], ConditionProfile)", value=StringNodes.SqueezeBangNode.class)
            private static final class SqueezeBangNode_
            extends BaseNode_ {
                private final ConditionProfile singleByteOptimizableProfile;

                SqueezeBangNode_(SqueezeBangNodeGen root, ConditionProfile singleByteOptimizableProfile) {
                    super(root, 3);
                    this.singleByteOptimizableProfile = singleByteOptimizableProfile;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        if (!StringGuards.isEmpty(arguments0Value_) && !StringNodes.SqueezeBangNode.zeroArgs(arguments1Value_)) {
                            return this.root.squeezeBang(frameValue, arguments0Value_, arguments1Value_, this.singleByteOptimizableProfile);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SqueezeBangNodeGen root, ConditionProfile singleByteOptimizableProfile) {
                    return new SqueezeBangNode_(root, singleByteOptimizableProfile);
                }
            }

            @GeneratedBy(methodName="squeezeBangZeroArgs(DynamicObject, Object[], ConditionProfile)", value=StringNodes.SqueezeBangNode.class)
            private static final class SqueezeBangZeroArgsNode_
            extends BaseNode_ {
                private final ConditionProfile singleByteOptimizableProfile;

                SqueezeBangZeroArgsNode_(SqueezeBangNodeGen root, ConditionProfile singleByteOptimizableProfile) {
                    super(root, 2);
                    this.singleByteOptimizableProfile = singleByteOptimizableProfile;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        if (!StringGuards.isEmpty(arguments0Value_) && StringNodes.SqueezeBangNode.zeroArgs(arguments1Value_)) {
                            return this.root.squeezeBangZeroArgs(arguments0Value_, arguments1Value_, this.singleByteOptimizableProfile);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SqueezeBangNodeGen root, ConditionProfile singleByteOptimizableProfile) {
                    return new SqueezeBangZeroArgsNode_(root, singleByteOptimizableProfile);
                }
            }

            @GeneratedBy(methodName="squeezeBangEmptyString(DynamicObject, Object[])", value=StringNodes.SqueezeBangNode.class)
            private static final class SqueezeBangEmptyStringNode_
            extends BaseNode_ {
                SqueezeBangEmptyStringNode_(SqueezeBangNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        if (StringGuards.isEmpty(arguments0Value_)) {
                            return this.root.squeezeBangEmptyString(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SqueezeBangNodeGen root) {
                    return new SqueezeBangEmptyStringNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.SqueezeBangNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SqueezeBangNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SqueezeBangNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.SqueezeBangNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SqueezeBangNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SqueezeBangNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.SqueezeBangNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected SqueezeBangNodeGen root;

                BaseNode_(SqueezeBangNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (SqueezeBangNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        if (StringGuards.isEmpty(arguments0Value_)) {
                            return SqueezeBangEmptyStringNode_.create(this.root);
                        }
                        if (StringNodes.SqueezeBangNode.zeroArgs(arguments1Value_)) {
                            ConditionProfile singleByteOptimizableProfile2 = ConditionProfile.createBinaryProfile();
                            return SqueezeBangZeroArgsNode_.create(this.root, singleByteOptimizableProfile2);
                        }
                        if (!StringGuards.isEmpty(arguments0Value_) && !StringNodes.SqueezeBangNode.zeroArgs(arguments1Value_)) {
                            ConditionProfile singleByteOptimizableProfile3 = ConditionProfile.createBinaryProfile();
                            return SqueezeBangNode_.create(this.root, singleByteOptimizableProfile3);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.SizeNode.class)
    public static final class SizeNodeFactory
    extends NodeFactoryBase<StringNodes.SizeNode> {
        private static SizeNodeFactory sizeNodeFactoryInstance;

        private SizeNodeFactory() {
            super(StringNodes.SizeNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public StringNodes.SizeNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SizeNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.SizeNode> getInstance() {
            if (sizeNodeFactoryInstance == null) {
                sizeNodeFactoryInstance = new SizeNodeFactory();
            }
            return sizeNodeFactoryInstance;
        }

        public static StringNodes.SizeNode create(RubyNode[] arguments) {
            return new SizeNodeGen(arguments);
        }

        @GeneratedBy(value=StringNodes.SizeNode.class)
        public static final class SizeNodeGen
        extends StringNodes.SizeNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private SizeNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="size(DynamicObject, ConditionProfile, ConditionProfile)", value=StringNodes.SizeNode.class)
            private static final class SizeNode_
            extends BaseNode_ {
                private final ConditionProfile ropeBufferProfile;
                private final ConditionProfile isSingleByteOptimizableRopeBufferProfile;

                SizeNode_(SizeNodeGen root, ConditionProfile ropeBufferProfile, ConditionProfile isSingleByteOptimizableRopeBufferProfile) {
                    super(root, 1);
                    this.ropeBufferProfile = ropeBufferProfile;
                    this.isSingleByteOptimizableRopeBufferProfile = isSingleByteOptimizableRopeBufferProfile;
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    return this.root.size(arguments0Value_, this.ropeBufferProfile, this.isSingleByteOptimizableRopeBufferProfile);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        return this.root.size(arguments0Value_, this.ropeBufferProfile, this.isSingleByteOptimizableRopeBufferProfile);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SizeNodeGen root, ConditionProfile ropeBufferProfile, ConditionProfile isSingleByteOptimizableRopeBufferProfile) {
                    return new SizeNode_(root, ropeBufferProfile, isSingleByteOptimizableRopeBufferProfile);
                }
            }

            @GeneratedBy(value=StringNodes.SizeNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SizeNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Integer)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(SizeNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.SizeNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected SizeNodeGen root;

                BaseNode_(SizeNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (SizeNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeInt_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract int executeInt_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeInt_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) {
                    return (Integer)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        ConditionProfile ropeBufferProfile1 = ConditionProfile.createBinaryProfile();
                        ConditionProfile isSingleByteOptimizableRopeBufferProfile1 = ConditionProfile.createBinaryProfile();
                        return SizeNode_.create(this.root, ropeBufferProfile1, isSingleByteOptimizableRopeBufferProfile1);
                    }
                    return null;
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.SetByteNode.class)
    public static final class SetByteNodeFactory
    extends NodeFactoryBase<StringNodes.SetByteNode> {
        private static SetByteNodeFactory setByteNodeFactoryInstance;

        private SetByteNodeFactory() {
            super(StringNodes.SetByteNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public StringNodes.SetByteNode createNode(Object ... arguments) {
            if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
                return SetByteNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3], (RubyNode)arguments[4]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.SetByteNode> getInstance() {
            if (setByteNodeFactoryInstance == null) {
                setByteNodeFactoryInstance = new SetByteNodeFactory();
            }
            return setByteNodeFactoryInstance;
        }

        public static StringNodes.SetByteNode create(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode index, RubyNode value) {
            return new SetByteNodeGen(context, sourceSection, string, index, value);
        }

        @GeneratedBy(value=StringNodes.SetByteNode.class)
        public static final class SetByteNodeGen
        extends StringNodes.SetByteNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode string_;
            @Node.Child
            private RubyNode index_;
            @Node.Child
            private RubyNode value_;
            @CompilerDirectives.CompilationFinal
            private Class<?> indexType_;
            @CompilerDirectives.CompilationFinal
            private Class<?> valueType_;
            @Node.Child
            private BaseNode_ specialization_;

            private SetByteNodeGen(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode index, RubyNode value) {
                super(context, sourceSection);
                this.string_ = string;
                this.index_ = this.coerceIndexToInt(index);
                this.value_ = this.coerceValueToInt(value);
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="setByteRopeBuffer(DynamicObject, int, int)", value=StringNodes.SetByteNode.class)
            private static final class SetByteRopeBufferNode_
            extends BaseNode_ {
                private final Class<?> indexImplicitType;
                private final Class<?> valueImplicitType;

                SetByteRopeBufferNode_(SetByteNodeGen root, Object indexValue, Object valueValue) {
                    super(root, 2);
                    this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
                    this.valueImplicitType = RubyTypesGen.getImplicitIntegerClass(valueValue);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.indexImplicitType == ((SetByteRopeBufferNode_)other).indexImplicitType && this.valueImplicitType == ((SetByteRopeBufferNode_)other).valueImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeInt(frameValue);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    int valueValue_;
                    int indexValue_;
                    DynamicObject stringValue_;
                    try {
                        stringValue_ = this.root.string_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object indexValue = this.executeIndex_(frameValue);
                        Object valueValue = this.executeValue_(frameValue);
                        return this.getNext().executeInt_(frameValue, ex.getResult(), indexValue, valueValue);
                    }
                    try {
                        if (this.indexImplicitType == Integer.TYPE) {
                            indexValue_ = this.root.index_.executeInteger(frameValue);
                        } else {
                            Object indexValue__ = this.executeIndex_(frameValue);
                            indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object valueValue = this.executeValue_(frameValue);
                        return this.getNext().executeInt_(frameValue, stringValue_, ex.getResult(), valueValue);
                    }
                    try {
                        if (this.valueImplicitType == Integer.TYPE) {
                            valueValue_ = this.root.value_.executeInteger(frameValue);
                        } else {
                            Object valueValue__ = this.executeValue_(frameValue);
                            valueValue_ = RubyTypesGen.expectImplicitInteger(valueValue__, this.valueImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, stringValue_, indexValue_, ex.getResult());
                    }
                    if (this.root.isRopeBuffer(stringValue_)) {
                        return this.root.setByteRopeBuffer(stringValue_, indexValue_, valueValue_);
                    }
                    return this.getNext().executeInt_(frameValue, stringValue_, indexValue_, valueValue_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object stringValue, Object indexValue, Object valueValue) {
                    if (stringValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && RubyTypesGen.isImplicitInteger(valueValue, this.valueImplicitType)) {
                        DynamicObject stringValue_ = (DynamicObject)stringValue;
                        int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                        int valueValue_ = RubyTypesGen.asImplicitInteger(valueValue, this.valueImplicitType);
                        if (this.root.isRopeBuffer(stringValue_)) {
                            return this.root.setByteRopeBuffer(stringValue_, indexValue_, valueValue_);
                        }
                    }
                    return this.getNext().executeInt_(frameValue, stringValue, indexValue, valueValue);
                }

                static BaseNode_ create(SetByteNodeGen root, Object indexValue, Object valueValue) {
                    return new SetByteRopeBufferNode_(root, indexValue, valueValue);
                }
            }

            @GeneratedBy(methodName="setByte(DynamicObject, int, int)", value=StringNodes.SetByteNode.class)
            private static final class SetByteNode_
            extends BaseNode_ {
                private final Class<?> indexImplicitType;
                private final Class<?> valueImplicitType;

                SetByteNode_(SetByteNodeGen root, Object indexValue, Object valueValue) {
                    super(root, 1);
                    this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
                    this.valueImplicitType = RubyTypesGen.getImplicitIntegerClass(valueValue);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.indexImplicitType == ((SetByteNode_)other).indexImplicitType && this.valueImplicitType == ((SetByteNode_)other).valueImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeInt(frameValue);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    int valueValue_;
                    int indexValue_;
                    DynamicObject stringValue_;
                    try {
                        stringValue_ = this.root.string_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object indexValue = this.executeIndex_(frameValue);
                        Object valueValue = this.executeValue_(frameValue);
                        return this.getNext().executeInt_(frameValue, ex.getResult(), indexValue, valueValue);
                    }
                    try {
                        if (this.indexImplicitType == Integer.TYPE) {
                            indexValue_ = this.root.index_.executeInteger(frameValue);
                        } else {
                            Object indexValue__ = this.executeIndex_(frameValue);
                            indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object valueValue = this.executeValue_(frameValue);
                        return this.getNext().executeInt_(frameValue, stringValue_, ex.getResult(), valueValue);
                    }
                    try {
                        if (this.valueImplicitType == Integer.TYPE) {
                            valueValue_ = this.root.value_.executeInteger(frameValue);
                        } else {
                            Object valueValue__ = this.executeValue_(frameValue);
                            valueValue_ = RubyTypesGen.expectImplicitInteger(valueValue__, this.valueImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, stringValue_, indexValue_, ex.getResult());
                    }
                    if (!this.root.isRopeBuffer(stringValue_)) {
                        return this.root.setByte(stringValue_, indexValue_, valueValue_);
                    }
                    return this.getNext().executeInt_(frameValue, stringValue_, indexValue_, valueValue_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object stringValue, Object indexValue, Object valueValue) {
                    if (stringValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && RubyTypesGen.isImplicitInteger(valueValue, this.valueImplicitType)) {
                        DynamicObject stringValue_ = (DynamicObject)stringValue;
                        int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                        int valueValue_ = RubyTypesGen.asImplicitInteger(valueValue, this.valueImplicitType);
                        if (!this.root.isRopeBuffer(stringValue_)) {
                            return this.root.setByte(stringValue_, indexValue_, valueValue_);
                        }
                    }
                    return this.getNext().executeInt_(frameValue, stringValue, indexValue, valueValue);
                }

                static BaseNode_ create(SetByteNodeGen root, Object indexValue, Object valueValue) {
                    return new SetByteNode_(root, indexValue, valueValue);
                }
            }

            @GeneratedBy(value=StringNodes.SetByteNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SetByteNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object stringValue, Object indexValue, Object valueValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, stringValue, indexValue, valueValue));
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    Object stringValue_ = this.root.string_.execute(frameValue);
                    Object indexValue_ = this.executeIndex_(frameValue);
                    Object valueValue_ = this.executeValue_(frameValue);
                    return this.getNext().executeInt_(frameValue, stringValue_, indexValue_, valueValue_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object stringValue, Object indexValue, Object valueValue) {
                    return this.getNext().executeInt_(frameValue, stringValue, indexValue, valueValue);
                }

                static BaseNode_ create(SetByteNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.SetByteNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SetByteNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object stringValue, Object indexValue, Object valueValue) {
                    return (Integer)this.uninitialized((Frame)frameValue, stringValue, indexValue, valueValue);
                }

                static BaseNode_ create(SetByteNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.SetByteNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected SetByteNodeGen root;

                BaseNode_(SetByteNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (SetByteNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.string_, this.root.index_, this.root.value_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object stringValue, Object indexValue, Object valueValue) {
                    return this.executeInt_((VirtualFrame)frameValue, stringValue, indexValue, valueValue);
                }

                public abstract int executeInt_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object stringValue_ = this.root.string_.execute(frameValue);
                    Object indexValue_ = this.executeIndex_(frameValue);
                    Object valueValue_ = this.executeValue_(frameValue);
                    return this.executeInt_(frameValue, stringValue_, indexValue_, valueValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) {
                    return (Integer)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object stringValue, Object indexValue, Object valueValue) {
                    if (stringValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue) && RubyTypesGen.isImplicitInteger(valueValue)) {
                        DynamicObject stringValue_ = (DynamicObject)stringValue;
                        if (!this.root.isRopeBuffer(stringValue_)) {
                            return SetByteNode_.create(this.root, indexValue, valueValue);
                        }
                        return SetByteRopeBufferNode_.create(this.root, indexValue, valueValue);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeIndex_(Frame frameValue) {
                    Object object;
                    Class indexType_ = this.root.indexType_;
                    if (indexType_ == Integer.TYPE) {
                        return this.root.index_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (indexType_ != null) return this.root.index_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.index_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.indexType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.indexType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.indexType_ = _type;
                    return object;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeValue_(Frame frameValue) {
                    Object object;
                    Class valueType_ = this.root.valueType_;
                    if (valueType_ == Integer.TYPE) {
                        return this.root.value_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (valueType_ != null) return this.root.value_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.value_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.valueType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.valueType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.valueType_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.DumpNode.class)
    public static final class DumpNodeFactory
    extends NodeFactoryBase<StringNodes.DumpNode> {
        private static DumpNodeFactory dumpNodeFactoryInstance;

        private DumpNodeFactory() {
            super(StringNodes.DumpNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public StringNodes.DumpNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DumpNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.DumpNode> getInstance() {
            if (dumpNodeFactoryInstance == null) {
                dumpNodeFactoryInstance = new DumpNodeFactory();
            }
            return dumpNodeFactoryInstance;
        }

        public static StringNodes.DumpNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new DumpNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.DumpNode.class)
        public static final class DumpNodeGen
        extends StringNodes.DumpNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private DumpNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="dump(DynamicObject)", value=StringNodes.DumpNode.class)
            private static final class DumpNode_
            extends BaseNode_ {
                DumpNode_(DumpNodeGen root) {
                    super(root, 2);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && !StringGuards.isAsciiCompatible(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.dump(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(DumpNodeGen root) {
                    return new DumpNode_(root);
                }
            }

            @GeneratedBy(methodName="dumpAsciiCompatible(DynamicObject)", value=StringNodes.DumpNode.class)
            private static final class DumpAsciiCompatibleNode_
            extends BaseNode_ {
                DumpAsciiCompatibleNode_(DumpNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && StringGuards.isAsciiCompatible(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.dumpAsciiCompatible(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(DumpNodeGen root) {
                    return new DumpAsciiCompatibleNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.DumpNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(DumpNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(DumpNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.DumpNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(DumpNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(DumpNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.DumpNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected DumpNodeGen root;

                BaseNode_(DumpNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (DumpNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (StringGuards.isAsciiCompatible(arguments0Value_)) {
                            return DumpAsciiCompatibleNode_.create(this.root);
                        }
                        return DumpNode_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.SwapcaseBangNode.class)
    public static final class SwapcaseBangNodeFactory
    extends NodeFactoryBase<StringNodes.SwapcaseBangNode> {
        private static SwapcaseBangNodeFactory swapcaseBangNodeFactoryInstance;

        private SwapcaseBangNodeFactory() {
            super(StringNodes.SwapcaseBangNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public StringNodes.SwapcaseBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SwapcaseBangNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.SwapcaseBangNode> getInstance() {
            if (swapcaseBangNodeFactoryInstance == null) {
                swapcaseBangNodeFactoryInstance = new SwapcaseBangNodeFactory();
            }
            return swapcaseBangNodeFactoryInstance;
        }

        public static StringNodes.SwapcaseBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SwapcaseBangNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.SwapcaseBangNode.class)
        public static final class SwapcaseBangNodeGen
        extends StringNodes.SwapcaseBangNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private SwapcaseBangNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="swapcaseSingleByte(DynamicObject, ConditionProfile, ConditionProfile)", value=StringNodes.SwapcaseBangNode.class)
            private static final class SwapcaseSingleByteNode_
            extends BaseNode_ {
                private final ConditionProfile emptyStringProfile;
                private final ConditionProfile singleByteOptimizableProfile;

                SwapcaseSingleByteNode_(SwapcaseBangNodeGen root, ConditionProfile emptyStringProfile, ConditionProfile singleByteOptimizableProfile) {
                    super(root, 1);
                    this.emptyStringProfile = emptyStringProfile;
                    this.singleByteOptimizableProfile = singleByteOptimizableProfile;
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        return this.root.swapcaseSingleByte(arguments0Value_, this.emptyStringProfile, this.singleByteOptimizableProfile);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SwapcaseBangNodeGen root, ConditionProfile emptyStringProfile, ConditionProfile singleByteOptimizableProfile) {
                    return new SwapcaseSingleByteNode_(root, emptyStringProfile, singleByteOptimizableProfile);
                }
            }

            @GeneratedBy(value=StringNodes.SwapcaseBangNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SwapcaseBangNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(SwapcaseBangNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.SwapcaseBangNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected SwapcaseBangNodeGen root;

                BaseNode_(SwapcaseBangNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (SwapcaseBangNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        ConditionProfile emptyStringProfile1 = ConditionProfile.createBinaryProfile();
                        ConditionProfile singleByteOptimizableProfile1 = ConditionProfile.createBinaryProfile();
                        return SwapcaseSingleByteNode_.create(this.root, emptyStringProfile1, singleByteOptimizableProfile1);
                    }
                    return null;
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.RstripBangNode.class)
    public static final class RstripBangNodeFactory
    extends NodeFactoryBase<StringNodes.RstripBangNode> {
        private static RstripBangNodeFactory rstripBangNodeFactoryInstance;

        private RstripBangNodeFactory() {
            super(StringNodes.RstripBangNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public StringNodes.RstripBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RstripBangNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.RstripBangNode> getInstance() {
            if (rstripBangNodeFactoryInstance == null) {
                rstripBangNodeFactoryInstance = new RstripBangNodeFactory();
            }
            return rstripBangNodeFactoryInstance;
        }

        public static StringNodes.RstripBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new RstripBangNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.RstripBangNode.class)
        public static final class RstripBangNodeGen
        extends StringNodes.RstripBangNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private RstripBangNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="rstripBang(DynamicObject)", value=StringNodes.RstripBangNode.class)
            private static final class RstripBangNode_
            extends BaseNode_ {
                RstripBangNode_(RstripBangNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && !StringGuards.isEmpty(arguments0Value_ = (DynamicObject)arguments0Value) && !StringGuards.isSingleByteOptimizable(arguments0Value_)) {
                        return this.root.rstripBang(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(RstripBangNodeGen root) {
                    return new RstripBangNode_(root);
                }
            }

            @GeneratedBy(methodName="rstripBangSingleByte(DynamicObject)", value=StringNodes.RstripBangNode.class)
            private static final class RstripBangSingleByteNode_
            extends BaseNode_ {
                RstripBangSingleByteNode_(RstripBangNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && !StringGuards.isEmpty(arguments0Value_ = (DynamicObject)arguments0Value) && StringGuards.isSingleByteOptimizable(arguments0Value_)) {
                        return this.root.rstripBangSingleByte(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(RstripBangNodeGen root) {
                    return new RstripBangSingleByteNode_(root);
                }
            }

            @GeneratedBy(methodName="rstripBangEmptyString(DynamicObject)", value=StringNodes.RstripBangNode.class)
            private static final class RstripBangEmptyStringNode_
            extends BaseNode_ {
                RstripBangEmptyStringNode_(RstripBangNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && StringGuards.isEmpty(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.rstripBangEmptyString(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(RstripBangNodeGen root) {
                    return new RstripBangEmptyStringNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.RstripBangNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(RstripBangNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(RstripBangNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.RstripBangNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(RstripBangNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(RstripBangNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.RstripBangNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected RstripBangNodeGen root;

                BaseNode_(RstripBangNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (RstripBangNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (StringGuards.isEmpty(arguments0Value_)) {
                            return RstripBangEmptyStringNode_.create(this.root);
                        }
                        if (StringGuards.isSingleByteOptimizable(arguments0Value_)) {
                            return RstripBangSingleByteNode_.create(this.root);
                        }
                        if (!StringGuards.isEmpty(arguments0Value_) && !StringGuards.isSingleByteOptimizable(arguments0Value_)) {
                            return RstripBangNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.ReplaceNode.class)
    public static final class ReplaceNodeFactory
    extends NodeFactoryBase<StringNodes.ReplaceNode> {
        private static ReplaceNodeFactory replaceNodeFactoryInstance;

        private ReplaceNodeFactory() {
            super(StringNodes.ReplaceNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode.class, RubyNode.class}});
        }

        @Override
        public StringNodes.ReplaceNode createNode(Object ... arguments) {
            if (arguments.length == 2 && (arguments[0] == null || arguments[0] instanceof RubyNode) && (arguments[1] == null || arguments[1] instanceof RubyNode)) {
                return ReplaceNodeFactory.create((RubyNode)arguments[0], (RubyNode)arguments[1]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.ReplaceNode> getInstance() {
            if (replaceNodeFactoryInstance == null) {
                replaceNodeFactoryInstance = new ReplaceNodeFactory();
            }
            return replaceNodeFactoryInstance;
        }

        public static StringNodes.ReplaceNode create(RubyNode string, RubyNode other) {
            return new ReplaceNodeGen(string, other);
        }

        @GeneratedBy(value=StringNodes.ReplaceNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class ReplaceNodeGen
        extends StringNodes.ReplaceNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode string_;
            @Node.Child
            private RubyNode other_;
            @Node.Child
            private BaseNode_ specialization_;

            private ReplaceNodeGen(RubyNode string, RubyNode other) {
                this.string_ = string;
                this.other_ = this.coerceOtherToString(other);
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="replace(DynamicObject, DynamicObject)", value=StringNodes.ReplaceNode.class)
            private static final class ReplaceNode_
            extends BaseNode_ {
                ReplaceNode_(ReplaceNodeGen root) {
                    super(root, 2);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                    DynamicObject otherValue_;
                    DynamicObject stringValue_;
                    if (stringValue instanceof DynamicObject && otherValue instanceof DynamicObject && (stringValue_ = (DynamicObject)stringValue) != (otherValue_ = (DynamicObject)otherValue) && RubyGuards.isRubyString(otherValue_)) {
                        return this.root.replace(stringValue_, otherValue_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, stringValue, otherValue);
                }

                static BaseNode_ create(ReplaceNodeGen root) {
                    return new ReplaceNode_(root);
                }
            }

            @GeneratedBy(methodName="replaceStringIsSameAsOther(DynamicObject, DynamicObject)", value=StringNodes.ReplaceNode.class)
            private static final class ReplaceStringIsSameAsOtherNode_
            extends BaseNode_ {
                ReplaceStringIsSameAsOtherNode_(ReplaceNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                    DynamicObject otherValue_;
                    DynamicObject stringValue_;
                    if (stringValue instanceof DynamicObject && otherValue instanceof DynamicObject && (stringValue_ = (DynamicObject)stringValue) == (otherValue_ = (DynamicObject)otherValue)) {
                        return this.root.replaceStringIsSameAsOther(stringValue_, otherValue_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, stringValue, otherValue);
                }

                static BaseNode_ create(ReplaceNodeGen root) {
                    return new ReplaceStringIsSameAsOtherNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.ReplaceNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ReplaceNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object stringValue, Object otherValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, stringValue, otherValue));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                    return this.getNext().executeDynamicObject_(frameValue, stringValue, otherValue);
                }

                static BaseNode_ create(ReplaceNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.ReplaceNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ReplaceNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, stringValue, otherValue);
                }

                static BaseNode_ create(ReplaceNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.ReplaceNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ReplaceNodeGen root;

                BaseNode_(ReplaceNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (ReplaceNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.string_, this.root.other_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object stringValue, Object otherValue) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, stringValue, otherValue);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object stringValue_ = this.root.string_.execute(frameValue);
                    Object otherValue_ = this.root.other_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, stringValue_, otherValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object stringValue, Object otherValue) {
                    if (stringValue instanceof DynamicObject && otherValue instanceof DynamicObject) {
                        DynamicObject stringValue_ = (DynamicObject)stringValue;
                        DynamicObject otherValue_ = (DynamicObject)otherValue;
                        if (stringValue_ == otherValue_) {
                            return ReplaceStringIsSameAsOtherNode_.create(this.root);
                        }
                        if (stringValue_ != otherValue_ && RubyGuards.isRubyString(otherValue_)) {
                            return ReplaceNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.OrdNode.class)
    public static final class OrdNodeFactory
    extends NodeFactoryBase<StringNodes.OrdNode> {
        private static OrdNodeFactory ordNodeFactoryInstance;

        private OrdNodeFactory() {
            super(StringNodes.OrdNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public StringNodes.OrdNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return OrdNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.OrdNode> getInstance() {
            if (ordNodeFactoryInstance == null) {
                ordNodeFactoryInstance = new OrdNodeFactory();
            }
            return ordNodeFactoryInstance;
        }

        public static StringNodes.OrdNode create(RubyNode[] arguments) {
            return new OrdNodeGen(arguments);
        }

        @GeneratedBy(value=StringNodes.OrdNode.class)
        public static final class OrdNodeGen
        extends StringNodes.OrdNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private OrdNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="ord(DynamicObject)", value=StringNodes.OrdNode.class)
            private static final class OrdNode_
            extends BaseNode_ {
                OrdNode_(OrdNodeGen root) {
                    super(root, 3);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    if (!StringGuards.isEmpty(arguments0Value_) && !StringGuards.isSingleByteOptimizable(arguments0Value_)) {
                        return this.root.ord(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && !StringGuards.isEmpty(arguments0Value_ = (DynamicObject)arguments0Value) && !StringGuards.isSingleByteOptimizable(arguments0Value_)) {
                        return this.root.ord(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(OrdNodeGen root) {
                    return new OrdNode_(root);
                }
            }

            @GeneratedBy(methodName="ordAsciiOnly(DynamicObject)", value=StringNodes.OrdNode.class)
            private static final class OrdAsciiOnlyNode_
            extends BaseNode_ {
                OrdAsciiOnlyNode_(OrdNodeGen root) {
                    super(root, 2);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    if (!StringGuards.isEmpty(arguments0Value_) && StringGuards.isSingleByteOptimizable(arguments0Value_)) {
                        return this.root.ordAsciiOnly(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && !StringGuards.isEmpty(arguments0Value_ = (DynamicObject)arguments0Value) && StringGuards.isSingleByteOptimizable(arguments0Value_)) {
                        return this.root.ordAsciiOnly(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(OrdNodeGen root) {
                    return new OrdAsciiOnlyNode_(root);
                }
            }

            @GeneratedBy(methodName="ordEmpty(DynamicObject)", value=StringNodes.OrdNode.class)
            private static final class OrdEmptyNode_
            extends BaseNode_ {
                OrdEmptyNode_(OrdNodeGen root) {
                    super(root, 1);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    if (StringGuards.isEmpty(arguments0Value_)) {
                        return this.root.ordEmpty(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && StringGuards.isEmpty(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.ordEmpty(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(OrdNodeGen root) {
                    return new OrdEmptyNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.OrdNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(OrdNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.getNext().executeInt_(frameValue, arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(OrdNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.OrdNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(OrdNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Integer)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(OrdNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.OrdNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected OrdNodeGen root;

                BaseNode_(OrdNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (OrdNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeInt_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract int executeInt_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeInt_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) {
                    return (Integer)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (StringGuards.isEmpty(arguments0Value_)) {
                            return OrdEmptyNode_.create(this.root);
                        }
                        if (StringGuards.isSingleByteOptimizable(arguments0Value_)) {
                            return OrdAsciiOnlyNode_.create(this.root);
                        }
                        if (!StringGuards.isEmpty(arguments0Value_) && !StringGuards.isSingleByteOptimizable(arguments0Value_)) {
                            return OrdNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.SetNumBytesNode.class)
    public static final class SetNumBytesNodeFactory
    extends NodeFactoryBase<StringNodes.SetNumBytesNode> {
        private static SetNumBytesNodeFactory setNumBytesNodeFactoryInstance;

        private SetNumBytesNodeFactory() {
            super(StringNodes.SetNumBytesNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public StringNodes.SetNumBytesNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SetNumBytesNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.SetNumBytesNode> getInstance() {
            if (setNumBytesNodeFactoryInstance == null) {
                setNumBytesNodeFactoryInstance = new SetNumBytesNodeFactory();
            }
            return setNumBytesNodeFactoryInstance;
        }

        public static StringNodes.SetNumBytesNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SetNumBytesNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.SetNumBytesNode.class)
        public static final class SetNumBytesNodeGen
        extends StringNodes.SetNumBytesNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private SetNumBytesNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                return this.specialization_.executeDynamicObject(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="setNumBytes(DynamicObject, int)", value=StringNodes.SetNumBytesNode.class)
            private static final class SetNumBytesNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                SetNumBytesNode_(SetNumBytesNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((SetNumBytesNode_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDynamicObject(frameValue);
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeDynamicObject_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.setNumBytes(arguments0Value_, arguments1Value_);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        return this.root.setNumBytes(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SetNumBytesNodeGen root, Object arguments1Value) {
                    return new SetNumBytesNode_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=StringNodes.SetNumBytesNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SetNumBytesNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SetNumBytesNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.SetNumBytesNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SetNumBytesNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SetNumBytesNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.SetNumBytesNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected SetNumBytesNodeGen root;

                BaseNode_(SetNumBytesNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (SetNumBytesNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    return (DynamicObject)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value)) {
                        return SetNumBytesNode_.create(this.root, arguments1Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.ModifyBangNode.class)
    public static final class ModifyBangNodeFactory
    extends NodeFactoryBase<StringNodes.ModifyBangNode> {
        private static ModifyBangNodeFactory modifyBangNodeFactoryInstance;

        private ModifyBangNodeFactory() {
            super(StringNodes.ModifyBangNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public StringNodes.ModifyBangNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ModifyBangNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.ModifyBangNode> getInstance() {
            if (modifyBangNodeFactoryInstance == null) {
                modifyBangNodeFactoryInstance = new ModifyBangNodeFactory();
            }
            return modifyBangNodeFactoryInstance;
        }

        public static StringNodes.ModifyBangNode create(RubyNode[] arguments) {
            return new ModifyBangNodeGen(arguments);
        }

        @GeneratedBy(value=StringNodes.ModifyBangNode.class)
        public static final class ModifyBangNodeGen
        extends StringNodes.ModifyBangNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ModifyBangNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.modifyBang(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=StringNodes.LstripBangNode.class)
    public static final class LstripBangNodeFactory
    extends NodeFactoryBase<StringNodes.LstripBangNode> {
        private static LstripBangNodeFactory lstripBangNodeFactoryInstance;

        private LstripBangNodeFactory() {
            super(StringNodes.LstripBangNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public StringNodes.LstripBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LstripBangNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.LstripBangNode> getInstance() {
            if (lstripBangNodeFactoryInstance == null) {
                lstripBangNodeFactoryInstance = new LstripBangNodeFactory();
            }
            return lstripBangNodeFactoryInstance;
        }

        public static StringNodes.LstripBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new LstripBangNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.LstripBangNode.class)
        public static final class LstripBangNodeGen
        extends StringNodes.LstripBangNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private LstripBangNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="lstripBang(DynamicObject)", value=StringNodes.LstripBangNode.class)
            private static final class LstripBangNode_
            extends BaseNode_ {
                LstripBangNode_(LstripBangNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && !StringGuards.isEmpty(arguments0Value_ = (DynamicObject)arguments0Value) && !StringGuards.isSingleByteOptimizable(arguments0Value_)) {
                        return this.root.lstripBang(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(LstripBangNodeGen root) {
                    return new LstripBangNode_(root);
                }
            }

            @GeneratedBy(methodName="lstripBangSingleByte(DynamicObject)", value=StringNodes.LstripBangNode.class)
            private static final class LstripBangSingleByteNode_
            extends BaseNode_ {
                LstripBangSingleByteNode_(LstripBangNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && !StringGuards.isEmpty(arguments0Value_ = (DynamicObject)arguments0Value) && StringGuards.isSingleByteOptimizable(arguments0Value_)) {
                        return this.root.lstripBangSingleByte(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(LstripBangNodeGen root) {
                    return new LstripBangSingleByteNode_(root);
                }
            }

            @GeneratedBy(methodName="lstripBangEmptyString(DynamicObject)", value=StringNodes.LstripBangNode.class)
            private static final class LstripBangEmptyStringNode_
            extends BaseNode_ {
                LstripBangEmptyStringNode_(LstripBangNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && StringGuards.isEmpty(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.lstripBangEmptyString(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(LstripBangNodeGen root) {
                    return new LstripBangEmptyStringNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.LstripBangNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(LstripBangNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(LstripBangNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.LstripBangNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(LstripBangNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(LstripBangNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.LstripBangNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected LstripBangNodeGen root;

                BaseNode_(LstripBangNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (LstripBangNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (StringGuards.isEmpty(arguments0Value_)) {
                            return LstripBangEmptyStringNode_.create(this.root);
                        }
                        if (StringGuards.isSingleByteOptimizable(arguments0Value_)) {
                            return LstripBangSingleByteNode_.create(this.root);
                        }
                        if (!StringGuards.isEmpty(arguments0Value_) && !StringGuards.isSingleByteOptimizable(arguments0Value_)) {
                            return LstripBangNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.InsertNode.class)
    public static final class InsertNodeFactory
    extends NodeFactoryBase<StringNodes.InsertNode> {
        private static InsertNodeFactory insertNodeFactoryInstance;

        private InsertNodeFactory() {
            super(StringNodes.InsertNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public StringNodes.InsertNode createNode(Object ... arguments) {
            if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
                return InsertNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3], (RubyNode)arguments[4]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.InsertNode> getInstance() {
            if (insertNodeFactoryInstance == null) {
                insertNodeFactoryInstance = new InsertNodeFactory();
            }
            return insertNodeFactoryInstance;
        }

        public static StringNodes.InsertNode create(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode index, RubyNode otherString) {
            return new InsertNodeGen(context, sourceSection, string, index, otherString);
        }

        @GeneratedBy(value=StringNodes.InsertNode.class)
        public static final class InsertNodeGen
        extends StringNodes.InsertNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode string_;
            @Node.Child
            private RubyNode index_;
            @Node.Child
            private RubyNode otherString_;
            @CompilerDirectives.CompilationFinal
            private Class<?> indexType_;
            @Node.Child
            private BaseNode_ specialization_;

            private InsertNodeGen(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode index, RubyNode otherString) {
                super(context, sourceSection);
                this.string_ = string;
                this.index_ = this.coerceIndexToInt(index);
                this.otherString_ = this.coerceOtherToString(otherString);
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="insert(VirtualFrame, DynamicObject, int, DynamicObject, ConditionProfile)", value=StringNodes.InsertNode.class)
            private static final class InsertNode_
            extends BaseNode_ {
                private final ConditionProfile negativeIndexProfile;
                private final Class<?> indexImplicitType;

                InsertNode_(InsertNodeGen root, Object indexValue, ConditionProfile negativeIndexProfile) {
                    super(root, 3);
                    this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
                    this.negativeIndexProfile = negativeIndexProfile;
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.indexImplicitType == ((InsertNode_)other).indexImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    DynamicObject otherStringValue_;
                    int indexValue_;
                    DynamicObject stringValue_;
                    try {
                        stringValue_ = this.root.string_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object indexValue = this.executeIndex_(frameValue);
                        Object otherStringValue = this.root.otherString_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), indexValue, otherStringValue);
                    }
                    try {
                        if (this.indexImplicitType == Integer.TYPE) {
                            indexValue_ = this.root.index_.executeInteger(frameValue);
                        } else {
                            Object indexValue__ = this.executeIndex_(frameValue);
                            indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object otherStringValue = this.root.otherString_.execute(frameValue);
                        return this.getNext().execute_(frameValue, stringValue_, ex.getResult(), otherStringValue);
                    }
                    try {
                        otherStringValue_ = this.root.otherString_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, stringValue_, indexValue_, ex.getResult());
                    }
                    if (!this.root.indexAtEitherBounds(indexValue_) && RubyGuards.isRubyString(otherStringValue_)) {
                        return this.root.insert(frameValue, stringValue_, indexValue_, otherStringValue_, this.negativeIndexProfile);
                    }
                    return this.getNext().execute_(frameValue, stringValue_, indexValue_, otherStringValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object stringValue, Object indexValue, Object otherStringValue) {
                    if (stringValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && otherStringValue instanceof DynamicObject) {
                        DynamicObject stringValue_ = (DynamicObject)stringValue;
                        int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                        DynamicObject otherStringValue_ = (DynamicObject)otherStringValue;
                        if (!this.root.indexAtEitherBounds(indexValue_) && RubyGuards.isRubyString(otherStringValue_)) {
                            return this.root.insert(frameValue, stringValue_, indexValue_, otherStringValue_, this.negativeIndexProfile);
                        }
                    }
                    return this.getNext().execute_(frameValue, stringValue, indexValue, otherStringValue);
                }

                static BaseNode_ create(InsertNodeGen root, Object indexValue, ConditionProfile negativeIndexProfile) {
                    return new InsertNode_(root, indexValue, negativeIndexProfile);
                }
            }

            @GeneratedBy(methodName="insertAppend(VirtualFrame, DynamicObject, int, DynamicObject)", value=StringNodes.InsertNode.class)
            private static final class InsertAppendNode_
            extends BaseNode_ {
                private final Class<?> indexImplicitType;

                InsertAppendNode_(InsertNodeGen root, Object indexValue) {
                    super(root, 2);
                    this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.indexImplicitType == ((InsertAppendNode_)other).indexImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    DynamicObject otherStringValue_;
                    int indexValue_;
                    DynamicObject stringValue_;
                    try {
                        stringValue_ = this.root.string_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object indexValue = this.executeIndex_(frameValue);
                        Object otherStringValue = this.root.otherString_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), indexValue, otherStringValue);
                    }
                    try {
                        if (this.indexImplicitType == Integer.TYPE) {
                            indexValue_ = this.root.index_.executeInteger(frameValue);
                        } else {
                            Object indexValue__ = this.executeIndex_(frameValue);
                            indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object otherStringValue = this.root.otherString_.execute(frameValue);
                        return this.getNext().execute_(frameValue, stringValue_, ex.getResult(), otherStringValue);
                    }
                    try {
                        otherStringValue_ = this.root.otherString_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, stringValue_, indexValue_, ex.getResult());
                    }
                    if (this.root.indexAtEndBound(indexValue_) && RubyGuards.isRubyString(otherStringValue_)) {
                        return this.root.insertAppend(frameValue, stringValue_, indexValue_, otherStringValue_);
                    }
                    return this.getNext().execute_(frameValue, stringValue_, indexValue_, otherStringValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object stringValue, Object indexValue, Object otherStringValue) {
                    if (stringValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && otherStringValue instanceof DynamicObject) {
                        DynamicObject stringValue_ = (DynamicObject)stringValue;
                        int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                        DynamicObject otherStringValue_ = (DynamicObject)otherStringValue;
                        if (this.root.indexAtEndBound(indexValue_) && RubyGuards.isRubyString(otherStringValue_)) {
                            return this.root.insertAppend(frameValue, stringValue_, indexValue_, otherStringValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, stringValue, indexValue, otherStringValue);
                }

                static BaseNode_ create(InsertNodeGen root, Object indexValue) {
                    return new InsertAppendNode_(root, indexValue);
                }
            }

            @GeneratedBy(methodName="insertPrepend(DynamicObject, int, DynamicObject)", value=StringNodes.InsertNode.class)
            private static final class InsertPrependNode_
            extends BaseNode_ {
                private final Class<?> indexImplicitType;

                InsertPrependNode_(InsertNodeGen root, Object indexValue) {
                    super(root, 1);
                    this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.indexImplicitType == ((InsertPrependNode_)other).indexImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    DynamicObject otherStringValue_;
                    int indexValue_;
                    DynamicObject stringValue_;
                    try {
                        stringValue_ = this.root.string_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object indexValue = this.executeIndex_(frameValue);
                        Object otherStringValue = this.root.otherString_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), indexValue, otherStringValue);
                    }
                    try {
                        if (this.indexImplicitType == Integer.TYPE) {
                            indexValue_ = this.root.index_.executeInteger(frameValue);
                        } else {
                            Object indexValue__ = this.executeIndex_(frameValue);
                            indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object otherStringValue = this.root.otherString_.execute(frameValue);
                        return this.getNext().execute_(frameValue, stringValue_, ex.getResult(), otherStringValue);
                    }
                    try {
                        otherStringValue_ = this.root.otherString_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, stringValue_, indexValue_, ex.getResult());
                    }
                    if (this.root.indexAtStartBound(indexValue_) && RubyGuards.isRubyString(otherStringValue_)) {
                        return this.root.insertPrepend(stringValue_, indexValue_, otherStringValue_);
                    }
                    return this.getNext().execute_(frameValue, stringValue_, indexValue_, otherStringValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object stringValue, Object indexValue, Object otherStringValue) {
                    if (stringValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && otherStringValue instanceof DynamicObject) {
                        DynamicObject stringValue_ = (DynamicObject)stringValue;
                        int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                        DynamicObject otherStringValue_ = (DynamicObject)otherStringValue;
                        if (this.root.indexAtStartBound(indexValue_) && RubyGuards.isRubyString(otherStringValue_)) {
                            return this.root.insertPrepend(stringValue_, indexValue_, otherStringValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, stringValue, indexValue, otherStringValue);
                }

                static BaseNode_ create(InsertNodeGen root, Object indexValue) {
                    return new InsertPrependNode_(root, indexValue);
                }
            }

            @GeneratedBy(value=StringNodes.InsertNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(InsertNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object stringValue, Object indexValue, Object otherStringValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, stringValue, indexValue, otherStringValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object stringValue, Object indexValue, Object otherStringValue) {
                    return this.getNext().execute_(frameValue, stringValue, indexValue, otherStringValue);
                }

                static BaseNode_ create(InsertNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.InsertNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InsertNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object stringValue, Object indexValue, Object otherStringValue) {
                    return this.uninitialized((Frame)frameValue, stringValue, indexValue, otherStringValue);
                }

                static BaseNode_ create(InsertNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.InsertNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected InsertNodeGen root;

                BaseNode_(InsertNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (InsertNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.string_, this.root.index_, this.root.otherString_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object stringValue, Object indexValue, Object otherStringValue) {
                    return this.execute_((VirtualFrame)frameValue, stringValue, indexValue, otherStringValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object stringValue_ = this.root.string_.execute(frameValue);
                    Object indexValue_ = this.executeIndex_(frameValue);
                    Object otherStringValue_ = this.root.otherString_.execute(frameValue);
                    return this.execute_(frameValue, stringValue_, indexValue_, otherStringValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object stringValue, Object indexValue, Object otherStringValue) {
                    if (stringValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue) && otherStringValue instanceof DynamicObject) {
                        int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue);
                        DynamicObject otherStringValue_ = (DynamicObject)otherStringValue;
                        if (this.root.indexAtStartBound(indexValue_) && RubyGuards.isRubyString(otherStringValue_)) {
                            return InsertPrependNode_.create(this.root, indexValue);
                        }
                        if (this.root.indexAtEndBound(indexValue_) && RubyGuards.isRubyString(otherStringValue_)) {
                            return InsertAppendNode_.create(this.root, indexValue);
                        }
                        if (!this.root.indexAtEitherBounds(indexValue_) && RubyGuards.isRubyString(otherStringValue_)) {
                            ConditionProfile negativeIndexProfile3 = ConditionProfile.createBinaryProfile();
                            return InsertNode_.create(this.root, indexValue, negativeIndexProfile3);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeIndex_(Frame frameValue) {
                    Object object;
                    Class indexType_ = this.root.indexType_;
                    if (indexType_ == Integer.TYPE) {
                        return this.root.index_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (indexType_ != null) return this.root.index_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.index_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.indexType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.indexType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.indexType_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.InitializeCopyNode.class)
    public static final class InitializeCopyNodeFactory
    extends NodeFactoryBase<StringNodes.InitializeCopyNode> {
        private static InitializeCopyNodeFactory initializeCopyNodeFactoryInstance;

        private InitializeCopyNodeFactory() {
            super(StringNodes.InitializeCopyNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public StringNodes.InitializeCopyNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return InitializeCopyNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.InitializeCopyNode> getInstance() {
            if (initializeCopyNodeFactoryInstance == null) {
                initializeCopyNodeFactoryInstance = new InitializeCopyNodeFactory();
            }
            return initializeCopyNodeFactoryInstance;
        }

        public static StringNodes.InitializeCopyNode create(RubyNode[] arguments) {
            return new InitializeCopyNodeGen(arguments);
        }

        @GeneratedBy(value=StringNodes.InitializeCopyNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class InitializeCopyNodeGen
        extends StringNodes.InitializeCopyNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private InitializeCopyNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="initializeCopy(DynamicObject, DynamicObject)", value=StringNodes.InitializeCopyNode.class)
            private static final class InitializeCopyNode_
            extends BaseNode_ {
                InitializeCopyNode_(InitializeCopyNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments1Value_;
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && (arguments0Value_ = (DynamicObject)arguments0Value) != (arguments1Value_ = (DynamicObject)arguments1Value) && RubyGuards.isRubyString(arguments1Value_)) {
                        return this.root.initializeCopy(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeCopyNodeGen root) {
                    return new InitializeCopyNode_(root);
                }
            }

            @GeneratedBy(methodName="initializeCopySelfIsSameAsFrom(DynamicObject, DynamicObject)", value=StringNodes.InitializeCopyNode.class)
            private static final class InitializeCopySelfIsSameAsFromNode_
            extends BaseNode_ {
                InitializeCopySelfIsSameAsFromNode_(InitializeCopyNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments1Value_;
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && (arguments0Value_ = (DynamicObject)arguments0Value) == (arguments1Value_ = (DynamicObject)arguments1Value)) {
                        return this.root.initializeCopySelfIsSameAsFrom(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeCopyNodeGen root) {
                    return new InitializeCopySelfIsSameAsFromNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.InitializeCopyNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(InitializeCopyNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeCopyNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.InitializeCopyNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InitializeCopyNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeCopyNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.InitializeCopyNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected InitializeCopyNodeGen root;

                BaseNode_(InitializeCopyNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (InitializeCopyNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (arguments0Value_ == arguments1Value_) {
                            return InitializeCopySelfIsSameAsFromNode_.create(this.root);
                        }
                        if (arguments0Value_ != arguments1Value_ && RubyGuards.isRubyString(arguments1Value_)) {
                            return InitializeCopyNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.InitializeNode.class)
    public static final class InitializeNodeFactory
    extends NodeFactoryBase<StringNodes.InitializeNode> {
        private static InitializeNodeFactory initializeNodeFactoryInstance;

        private InitializeNodeFactory() {
            super(StringNodes.InitializeNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public StringNodes.InitializeNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return InitializeNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.InitializeNode> getInstance() {
            if (initializeNodeFactoryInstance == null) {
                initializeNodeFactoryInstance = new InitializeNodeFactory();
            }
            return initializeNodeFactoryInstance;
        }

        public static StringNodes.InitializeNode create(RubyNode[] arguments) {
            return new InitializeNodeGen(arguments);
        }

        @GeneratedBy(value=StringNodes.InitializeNode.class)
        public static final class InitializeNodeGen
        extends StringNodes.InitializeNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private InitializeNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="initialize(VirtualFrame, DynamicObject, Object)", value=StringNodes.InitializeNode.class)
            private static final class Initialize2Node_
            extends BaseNode_ {
                Initialize2Node_(InitializeNodeGen root) {
                    super(root, 3);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (!RubyGuards.isRubyString(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                            return this.root.initialize(frameValue, arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize2Node_(root);
                }
            }

            @GeneratedBy(methodName="initialize(DynamicObject, DynamicObject)", value=StringNodes.InitializeNode.class)
            private static final class Initialize1Node_
            extends BaseNode_ {
                Initialize1Node_(InitializeNodeGen root) {
                    super(root, 2);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.initialize(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize1Node_(root);
                }
            }

            @GeneratedBy(methodName="initialize(DynamicObject, NotProvided)", value=StringNodes.InitializeNode.class)
            private static final class Initialize0Node_
            extends BaseNode_ {
                Initialize0Node_(InitializeNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.initialize(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize0Node_(root);
                }
            }

            @GeneratedBy(value=StringNodes.InitializeNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(InitializeNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.InitializeNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InitializeNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.InitializeNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected InitializeNodeGen root;

                BaseNode_(InitializeNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (InitializeNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments1Value_;
                        if (arguments1Value instanceof NotProvided) {
                            return Initialize0Node_.create(this.root);
                        }
                        if (arguments1Value instanceof DynamicObject && RubyGuards.isRubyString(arguments1Value_ = (DynamicObject)arguments1Value)) {
                            return Initialize1Node_.create(this.root);
                        }
                        if (!RubyGuards.isRubyString(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                            return Initialize2Node_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.HashNode.class)
    public static final class HashNodeFactory
    extends NodeFactoryBase<StringNodes.HashNode> {
        private static HashNodeFactory hashNodeFactoryInstance;

        private HashNodeFactory() {
            super(StringNodes.HashNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public StringNodes.HashNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return HashNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.HashNode> getInstance() {
            if (hashNodeFactoryInstance == null) {
                hashNodeFactoryInstance = new HashNodeFactory();
            }
            return hashNodeFactoryInstance;
        }

        public static StringNodes.HashNode create(RubyNode[] arguments) {
            return new HashNodeGen(arguments);
        }

        @GeneratedBy(value=StringNodes.HashNode.class)
        public static final class HashNodeGen
        extends StringNodes.HashNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private HashNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.hash(arguments0Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=StringNodes.GetByteNode.class)
    public static final class GetByteNodeFactory
    extends NodeFactoryBase<StringNodes.GetByteNode> {
        private static GetByteNodeFactory getByteNodeFactoryInstance;

        private GetByteNodeFactory() {
            super(StringNodes.GetByteNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public StringNodes.GetByteNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GetByteNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.GetByteNode> getInstance() {
            if (getByteNodeFactoryInstance == null) {
                getByteNodeFactoryInstance = new GetByteNodeFactory();
            }
            return getByteNodeFactoryInstance;
        }

        public static StringNodes.GetByteNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new GetByteNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.GetByteNode.class)
        public static final class GetByteNodeGen
        extends StringNodes.GetByteNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private GetByteNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="getByte(DynamicObject, int, ConditionProfile, ConditionProfile)", value=StringNodes.GetByteNode.class)
            private static final class GetByteNode_
            extends BaseNode_ {
                private final ConditionProfile negativeIndexProfile;
                private final ConditionProfile indexOutOfBoundsProfile;
                private final Class<?> arguments1ImplicitType;

                GetByteNode_(GetByteNodeGen root, Object arguments1Value, ConditionProfile negativeIndexProfile, ConditionProfile indexOutOfBoundsProfile) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                    this.negativeIndexProfile = negativeIndexProfile;
                    this.indexOutOfBoundsProfile = indexOutOfBoundsProfile;
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((GetByteNode_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.getByte(arguments0Value_, arguments1Value_, this.negativeIndexProfile, this.indexOutOfBoundsProfile);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        return this.root.getByte(arguments0Value_, arguments1Value_, this.negativeIndexProfile, this.indexOutOfBoundsProfile);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GetByteNodeGen root, Object arguments1Value, ConditionProfile negativeIndexProfile, ConditionProfile indexOutOfBoundsProfile) {
                    return new GetByteNode_(root, arguments1Value, negativeIndexProfile, indexOutOfBoundsProfile);
                }
            }

            @GeneratedBy(value=StringNodes.GetByteNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(GetByteNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GetByteNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.GetByteNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(GetByteNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GetByteNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.GetByteNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected GetByteNodeGen root;

                BaseNode_(GetByteNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (GetByteNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value)) {
                        ConditionProfile negativeIndexProfile1 = ConditionProfile.createBinaryProfile();
                        ConditionProfile indexOutOfBoundsProfile1 = ConditionProfile.createBinaryProfile();
                        return GetByteNode_.create(this.root, arguments1Value, negativeIndexProfile1, indexOutOfBoundsProfile1);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.ForceEncodingNode.class)
    public static final class ForceEncodingNodeFactory
    extends NodeFactoryBase<StringNodes.ForceEncodingNode> {
        private static ForceEncodingNodeFactory forceEncodingNodeFactoryInstance;

        private ForceEncodingNodeFactory() {
            super(StringNodes.ForceEncodingNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public StringNodes.ForceEncodingNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ForceEncodingNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.ForceEncodingNode> getInstance() {
            if (forceEncodingNodeFactoryInstance == null) {
                forceEncodingNodeFactoryInstance = new ForceEncodingNodeFactory();
            }
            return forceEncodingNodeFactoryInstance;
        }

        public static StringNodes.ForceEncodingNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ForceEncodingNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.ForceEncodingNode.class)
        public static final class ForceEncodingNodeGen
        extends StringNodes.ForceEncodingNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private ForceEncodingNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="forceEncoding(VirtualFrame, DynamicObject, Object, ConditionProfile, ConditionProfile)", value=StringNodes.ForceEncodingNode.class)
            private static final class ForceEncodingNode_
            extends BaseNode_ {
                private final ConditionProfile differentEncodingProfile;
                private final ConditionProfile mutableRopeProfile;

                ForceEncodingNode_(ForceEncodingNodeGen root, ConditionProfile differentEncodingProfile, ConditionProfile mutableRopeProfile) {
                    super(root, 3);
                    this.differentEncodingProfile = differentEncodingProfile;
                    this.mutableRopeProfile = mutableRopeProfile;
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (!RubyGuards.isRubyString(arguments1Value) && !RubyGuards.isRubyEncoding(arguments1Value)) {
                            return this.root.forceEncoding(frameValue, arguments0Value_, arguments1Value, this.differentEncodingProfile, this.mutableRopeProfile);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ForceEncodingNodeGen root, ConditionProfile differentEncodingProfile, ConditionProfile mutableRopeProfile) {
                    return new ForceEncodingNode_(root, differentEncodingProfile, mutableRopeProfile);
                }
            }

            @GeneratedBy(methodName="forceEncodingEncoding(DynamicObject, DynamicObject, ConditionProfile, ConditionProfile)", value=StringNodes.ForceEncodingNode.class)
            private static final class ForceEncodingEncodingNode_
            extends BaseNode_ {
                private final ConditionProfile differentEncodingProfile;
                private final ConditionProfile mutableRopeProfile;

                ForceEncodingEncodingNode_(ForceEncodingNodeGen root, ConditionProfile differentEncodingProfile, ConditionProfile mutableRopeProfile) {
                    super(root, 2);
                    this.differentEncodingProfile = differentEncodingProfile;
                    this.mutableRopeProfile = mutableRopeProfile;
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyEncoding(arguments1Value_)) {
                            return this.root.forceEncodingEncoding(arguments0Value_, arguments1Value_, this.differentEncodingProfile, this.mutableRopeProfile);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ForceEncodingNodeGen root, ConditionProfile differentEncodingProfile, ConditionProfile mutableRopeProfile) {
                    return new ForceEncodingEncodingNode_(root, differentEncodingProfile, mutableRopeProfile);
                }
            }

            @GeneratedBy(methodName="forceEncodingString(DynamicObject, DynamicObject, ConditionProfile, ConditionProfile)", value=StringNodes.ForceEncodingNode.class)
            private static final class ForceEncodingStringNode_
            extends BaseNode_ {
                private final ConditionProfile differentEncodingProfile;
                private final ConditionProfile mutableRopeProfile;

                ForceEncodingStringNode_(ForceEncodingNodeGen root, ConditionProfile differentEncodingProfile, ConditionProfile mutableRopeProfile) {
                    super(root, 1);
                    this.differentEncodingProfile = differentEncodingProfile;
                    this.mutableRopeProfile = mutableRopeProfile;
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.forceEncodingString(arguments0Value_, arguments1Value_, this.differentEncodingProfile, this.mutableRopeProfile);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ForceEncodingNodeGen root, ConditionProfile differentEncodingProfile, ConditionProfile mutableRopeProfile) {
                    return new ForceEncodingStringNode_(root, differentEncodingProfile, mutableRopeProfile);
                }
            }

            @GeneratedBy(value=StringNodes.ForceEncodingNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ForceEncodingNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ForceEncodingNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.ForceEncodingNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ForceEncodingNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ForceEncodingNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.ForceEncodingNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ForceEncodingNodeGen root;

                BaseNode_(ForceEncodingNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (ForceEncodingNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        if (arguments1Value instanceof DynamicObject) {
                            DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                            if (RubyGuards.isRubyString(arguments1Value_)) {
                                ConditionProfile differentEncodingProfile1 = ConditionProfile.createBinaryProfile();
                                ConditionProfile mutableRopeProfile1 = ConditionProfile.createBinaryProfile();
                                return ForceEncodingStringNode_.create(this.root, differentEncodingProfile1, mutableRopeProfile1);
                            }
                            if (RubyGuards.isRubyEncoding(arguments1Value_)) {
                                ConditionProfile differentEncodingProfile2 = ConditionProfile.createBinaryProfile();
                                ConditionProfile mutableRopeProfile2 = ConditionProfile.createBinaryProfile();
                                return ForceEncodingEncodingNode_.create(this.root, differentEncodingProfile2, mutableRopeProfile2);
                            }
                        }
                        if (!RubyGuards.isRubyString(arguments1Value) && !RubyGuards.isRubyEncoding(arguments1Value)) {
                            ConditionProfile differentEncodingProfile3 = ConditionProfile.createBinaryProfile();
                            ConditionProfile mutableRopeProfile3 = ConditionProfile.createBinaryProfile();
                            return ForceEncodingNode_.create(this.root, differentEncodingProfile3, mutableRopeProfile3);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.EncodingNode.class)
    public static final class EncodingNodeFactory
    extends NodeFactoryBase<StringNodes.EncodingNode> {
        private static EncodingNodeFactory encodingNodeFactoryInstance;

        private EncodingNodeFactory() {
            super(StringNodes.EncodingNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public StringNodes.EncodingNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return EncodingNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.EncodingNode> getInstance() {
            if (encodingNodeFactoryInstance == null) {
                encodingNodeFactoryInstance = new EncodingNodeFactory();
            }
            return encodingNodeFactoryInstance;
        }

        public static StringNodes.EncodingNode create(RubyNode[] arguments) {
            return new EncodingNodeGen(arguments);
        }

        @GeneratedBy(value=StringNodes.EncodingNode.class)
        public static final class EncodingNodeGen
        extends StringNodes.EncodingNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private EncodingNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.encoding(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=StringNodes.EmptyNode.class)
    public static final class EmptyNodeFactory
    extends NodeFactoryBase<StringNodes.EmptyNode> {
        private static EmptyNodeFactory emptyNodeFactoryInstance;

        private EmptyNodeFactory() {
            super(StringNodes.EmptyNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public StringNodes.EmptyNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return EmptyNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.EmptyNode> getInstance() {
            if (emptyNodeFactoryInstance == null) {
                emptyNodeFactoryInstance = new EmptyNodeFactory();
            }
            return emptyNodeFactoryInstance;
        }

        public static StringNodes.EmptyNode create(RubyNode[] arguments) {
            return new EmptyNodeGen(arguments);
        }

        @GeneratedBy(value=StringNodes.EmptyNode.class)
        public static final class EmptyNodeGen
        extends StringNodes.EmptyNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private EmptyNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.empty(arguments0Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=StringNodes.EachCharNode.class)
    public static final class EachCharNodeFactory
    extends NodeFactoryBase<StringNodes.EachCharNode> {
        private static EachCharNodeFactory eachCharNodeFactoryInstance;

        private EachCharNodeFactory() {
            super(StringNodes.EachCharNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public StringNodes.EachCharNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EachCharNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.EachCharNode> getInstance() {
            if (eachCharNodeFactoryInstance == null) {
                eachCharNodeFactoryInstance = new EachCharNodeFactory();
            }
            return eachCharNodeFactoryInstance;
        }

        public static StringNodes.EachCharNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new EachCharNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.EachCharNode.class)
        public static final class EachCharNodeGen
        extends StringNodes.EachCharNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private EachCharNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="eachCharMultiByteEncoding(VirtualFrame, DynamicObject, DynamicObject)", value=StringNodes.EachCharNode.class)
            private static final class EachCharMultiByteEncodingNode_
            extends BaseNode_ {
                EachCharMultiByteEncodingNode_(EachCharNodeGen root) {
                    super(root, 2);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (!StringGuards.isValidOr7BitEncoding(arguments0Value_)) {
                            return this.root.eachCharMultiByteEncoding(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachCharNodeGen root) {
                    return new EachCharMultiByteEncodingNode_(root);
                }
            }

            @GeneratedBy(methodName="eachChar(VirtualFrame, DynamicObject, DynamicObject)", value=StringNodes.EachCharNode.class)
            private static final class EachCharNode_
            extends BaseNode_ {
                EachCharNode_(EachCharNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (StringGuards.isValidOr7BitEncoding(arguments0Value_)) {
                            return this.root.eachChar(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachCharNodeGen root) {
                    return new EachCharNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.EachCharNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(EachCharNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachCharNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.EachCharNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(EachCharNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachCharNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.EachCharNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected EachCharNodeGen root;

                BaseNode_(EachCharNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (EachCharNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (StringGuards.isValidOr7BitEncoding(arguments0Value_)) {
                            return EachCharNode_.create(this.root);
                        }
                        return EachCharMultiByteEncodingNode_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.EachByteNode.class)
    public static final class EachByteNodeFactory
    extends NodeFactoryBase<StringNodes.EachByteNode> {
        private static EachByteNodeFactory eachByteNodeFactoryInstance;

        private EachByteNodeFactory() {
            super(StringNodes.EachByteNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public StringNodes.EachByteNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return EachByteNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.EachByteNode> getInstance() {
            if (eachByteNodeFactoryInstance == null) {
                eachByteNodeFactoryInstance = new EachByteNodeFactory();
            }
            return eachByteNodeFactoryInstance;
        }

        public static StringNodes.EachByteNode create(RubyNode[] arguments) {
            return new EachByteNodeGen(arguments);
        }

        @GeneratedBy(value=StringNodes.EachByteNode.class)
        public static final class EachByteNodeGen
        extends StringNodes.EachByteNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private EachByteNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="eachByte(VirtualFrame, DynamicObject, DynamicObject, ConditionProfile)", value=StringNodes.EachByteNode.class)
            private static final class EachByteNode_
            extends BaseNode_ {
                private final ConditionProfile ropeChangedProfile;

                EachByteNode_(EachByteNodeGen root, ConditionProfile ropeChangedProfile) {
                    super(root, 1);
                    this.ropeChangedProfile = ropeChangedProfile;
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        return this.root.eachByte(frameValue, arguments0Value_, arguments1Value_, this.ropeChangedProfile);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachByteNodeGen root, ConditionProfile ropeChangedProfile) {
                    return new EachByteNode_(root, ropeChangedProfile);
                }
            }

            @GeneratedBy(value=StringNodes.EachByteNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(EachByteNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachByteNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.EachByteNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected EachByteNodeGen root;

                BaseNode_(EachByteNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (EachByteNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        ConditionProfile ropeChangedProfile1 = ConditionProfile.createBinaryProfile();
                        return EachByteNode_.create(this.root, ropeChangedProfile1);
                    }
                    return null;
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.DowncaseBangNode.class)
    public static final class DowncaseBangNodeFactory
    extends NodeFactoryBase<StringNodes.DowncaseBangNode> {
        private static DowncaseBangNodeFactory downcaseBangNodeFactoryInstance;

        private DowncaseBangNodeFactory() {
            super(StringNodes.DowncaseBangNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public StringNodes.DowncaseBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DowncaseBangNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.DowncaseBangNode> getInstance() {
            if (downcaseBangNodeFactoryInstance == null) {
                downcaseBangNodeFactoryInstance = new DowncaseBangNodeFactory();
            }
            return downcaseBangNodeFactoryInstance;
        }

        public static StringNodes.DowncaseBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new DowncaseBangNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.DowncaseBangNode.class)
        public static final class DowncaseBangNodeGen
        extends StringNodes.DowncaseBangNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private DowncaseBangNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="downcase(DynamicObject, ConditionProfile, ConditionProfile)", value=StringNodes.DowncaseBangNode.class)
            private static final class WncaseNode_
            extends BaseNode_ {
                private final ConditionProfile emptyStringProfile;
                private final ConditionProfile modifiedProfile;

                WncaseNode_(DowncaseBangNodeGen root, ConditionProfile emptyStringProfile, ConditionProfile modifiedProfile) {
                    super(root, 3);
                    this.emptyStringProfile = emptyStringProfile;
                    this.modifiedProfile = modifiedProfile;
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && !StringGuards.isSingleByteOptimizable(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.downcase(arguments0Value_, this.emptyStringProfile, this.modifiedProfile);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(DowncaseBangNodeGen root, ConditionProfile emptyStringProfile, ConditionProfile modifiedProfile) {
                    return new WncaseNode_(root, emptyStringProfile, modifiedProfile);
                }
            }

            @GeneratedBy(methodName="downcaseSingleByte(DynamicObject, ConditionProfile)", value=StringNodes.DowncaseBangNode.class)
            private static final class WncaseSingleByteNode_
            extends BaseNode_ {
                private final ConditionProfile modifiedProfile;

                WncaseSingleByteNode_(DowncaseBangNodeGen root, ConditionProfile modifiedProfile) {
                    super(root, 2);
                    this.modifiedProfile = modifiedProfile;
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && !StringGuards.isEmpty(arguments0Value_ = (DynamicObject)arguments0Value) && StringGuards.isSingleByteOptimizable(arguments0Value_)) {
                        return this.root.downcaseSingleByte(arguments0Value_, this.modifiedProfile);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(DowncaseBangNodeGen root, ConditionProfile modifiedProfile) {
                    return new WncaseSingleByteNode_(root, modifiedProfile);
                }
            }

            @GeneratedBy(methodName="downcaseSingleByteEmpty(DynamicObject)", value=StringNodes.DowncaseBangNode.class)
            private static final class WncaseSingleByteEmptyNode_
            extends BaseNode_ {
                WncaseSingleByteEmptyNode_(DowncaseBangNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && StringGuards.isEmpty(arguments0Value_ = (DynamicObject)arguments0Value) && StringGuards.isSingleByteOptimizable(arguments0Value_)) {
                        return this.root.downcaseSingleByteEmpty(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(DowncaseBangNodeGen root) {
                    return new WncaseSingleByteEmptyNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.DowncaseBangNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(DowncaseBangNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(DowncaseBangNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.DowncaseBangNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(DowncaseBangNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(DowncaseBangNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.DowncaseBangNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected DowncaseBangNodeGen root;

                BaseNode_(DowncaseBangNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (DowncaseBangNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (StringGuards.isEmpty(arguments0Value_) && StringGuards.isSingleByteOptimizable(arguments0Value_)) {
                            return WncaseSingleByteEmptyNode_.create(this.root);
                        }
                        if (!StringGuards.isEmpty(arguments0Value_) && StringGuards.isSingleByteOptimizable(arguments0Value_)) {
                            ConditionProfile modifiedProfile2 = ConditionProfile.createBinaryProfile();
                            return WncaseSingleByteNode_.create(this.root, modifiedProfile2);
                        }
                        if (!StringGuards.isSingleByteOptimizable(arguments0Value_)) {
                            ConditionProfile emptyStringProfile3 = ConditionProfile.createBinaryProfile();
                            ConditionProfile modifiedProfile3 = ConditionProfile.createBinaryProfile();
                            return WncaseNode_.create(this.root, emptyStringProfile3, modifiedProfile3);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.DeleteBangNode.class)
    public static final class DeleteBangNodeFactory
    extends NodeFactoryBase<StringNodes.DeleteBangNode> {
        private static DeleteBangNodeFactory deleteBangNodeFactoryInstance;

        private DeleteBangNodeFactory() {
            super(StringNodes.DeleteBangNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public StringNodes.DeleteBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DeleteBangNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.DeleteBangNode> getInstance() {
            if (deleteBangNodeFactoryInstance == null) {
                deleteBangNodeFactoryInstance = new DeleteBangNodeFactory();
            }
            return deleteBangNodeFactoryInstance;
        }

        public static StringNodes.DeleteBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new DeleteBangNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.DeleteBangNode.class)
        public static final class DeleteBangNodeGen
        extends StringNodes.DeleteBangNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private DeleteBangNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="deleteBang(VirtualFrame, DynamicObject, Object[])", value=StringNodes.DeleteBangNode.class)
            private static final class DeleteBangNode_
            extends BaseNode_ {
                DeleteBangNode_(DeleteBangNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        if (!StringGuards.isEmpty(arguments0Value_)) {
                            return this.root.deleteBang(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DeleteBangNodeGen root) {
                    return new DeleteBangNode_(root);
                }
            }

            @GeneratedBy(methodName="deleteBangEmpty(DynamicObject, Object[])", value=StringNodes.DeleteBangNode.class)
            private static final class DeleteBangEmptyNode_
            extends BaseNode_ {
                DeleteBangEmptyNode_(DeleteBangNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        if (StringGuards.isEmpty(arguments0Value_)) {
                            return this.root.deleteBangEmpty(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DeleteBangNodeGen root) {
                    return new DeleteBangEmptyNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.DeleteBangNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(DeleteBangNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DeleteBangNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.DeleteBangNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(DeleteBangNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DeleteBangNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.DeleteBangNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected DeleteBangNodeGen root;

                BaseNode_(DeleteBangNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (DeleteBangNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (StringGuards.isEmpty(arguments0Value_)) {
                            return DeleteBangEmptyNode_.create(this.root);
                        }
                        return DeleteBangNode_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.CryptNode.class)
    public static final class CryptNodeFactory
    extends NodeFactoryBase<StringNodes.CryptNode> {
        private static CryptNodeFactory cryptNodeFactoryInstance;

        private CryptNodeFactory() {
            super(StringNodes.CryptNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode.class, RubyNode.class}});
        }

        @Override
        public StringNodes.CryptNode createNode(Object ... arguments) {
            if (arguments.length == 2 && (arguments[0] == null || arguments[0] instanceof RubyNode) && (arguments[1] == null || arguments[1] instanceof RubyNode)) {
                return CryptNodeFactory.create((RubyNode)arguments[0], (RubyNode)arguments[1]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.CryptNode> getInstance() {
            if (cryptNodeFactoryInstance == null) {
                cryptNodeFactoryInstance = new CryptNodeFactory();
            }
            return cryptNodeFactoryInstance;
        }

        public static StringNodes.CryptNode create(RubyNode string, RubyNode salt) {
            return new CryptNodeGen(string, salt);
        }

        @GeneratedBy(value=StringNodes.CryptNode.class)
        public static final class CryptNodeGen
        extends StringNodes.CryptNode {
            @Node.Child
            private RubyNode string_;
            @Node.Child
            private RubyNode salt_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private CryptNodeGen(RubyNode string, RubyNode salt) {
                this.string_ = string;
                this.salt_ = this.coerceSaltToString(salt);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject saltValue_;
                DynamicObject stringValue_;
                try {
                    stringValue_ = this.string_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object saltValue = this.salt_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), saltValue);
                }
                try {
                    saltValue_ = this.salt_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(stringValue_, ex.getResult());
                }
                if (RubyGuards.isRubyString(saltValue_)) {
                    return this.crypt(stringValue_, saltValue_);
                }
                throw this.unsupported(stringValue_, saltValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object stringValue, Object saltValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.string_, this.salt_}, stringValue, saltValue);
            }
        }
    }

    @GeneratedBy(value=StringNodes.CountNode.class)
    public static final class CountNodeFactory
    extends NodeFactoryBase<StringNodes.CountNode> {
        private static CountNodeFactory countNodeFactoryInstance;

        private CountNodeFactory() {
            super(StringNodes.CountNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public StringNodes.CountNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CountNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.CountNode> getInstance() {
            if (countNodeFactoryInstance == null) {
                countNodeFactoryInstance = new CountNodeFactory();
            }
            return countNodeFactoryInstance;
        }

        public static StringNodes.CountNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CountNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.CountNode.class)
        public static final class CountNodeGen
        extends StringNodes.CountNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private CountNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="count(VirtualFrame, DynamicObject, Object[])", value=StringNodes.CountNode.class)
            private static final class Count1Node_
            extends BaseNode_ {
                Count1Node_(CountNodeGen root) {
                    super(root, 2);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    Object[] arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        return this.getNext().executeInt_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeObjectArray(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (!StringGuards.isEmpty(arguments0Value_)) {
                        return this.root.count(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        if (!StringGuards.isEmpty(arguments0Value_)) {
                            return this.root.count(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CountNodeGen root) {
                    return new Count1Node_(root);
                }
            }

            @GeneratedBy(methodName="count(DynamicObject, Object[])", value=StringNodes.CountNode.class)
            private static final class Count0Node_
            extends BaseNode_ {
                Count0Node_(CountNodeGen root) {
                    super(root, 1);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    Object[] arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        return this.getNext().executeInt_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeObjectArray(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (StringGuards.isEmpty(arguments0Value_)) {
                        return this.root.count(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        if (StringGuards.isEmpty(arguments0Value_)) {
                            return this.root.count(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CountNodeGen root) {
                    return new Count0Node_(root);
                }
            }

            @GeneratedBy(value=StringNodes.CountNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(CountNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.getNext().executeInt_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeInt_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CountNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.CountNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(CountNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (Integer)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CountNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.CountNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected CountNodeGen root;

                BaseNode_(CountNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (CountNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeInt_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract int executeInt_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.executeInt_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) {
                    return (Integer)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (StringGuards.isEmpty(arguments0Value_)) {
                            return Count0Node_.create(this.root);
                        }
                        return Count1Node_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.CaseCmpNode.class)
    public static final class CaseCmpNodeFactory
    extends NodeFactoryBase<StringNodes.CaseCmpNode> {
        private static CaseCmpNodeFactory caseCmpNodeFactoryInstance;

        private CaseCmpNodeFactory() {
            super(StringNodes.CaseCmpNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode.class, RubyNode.class}});
        }

        @Override
        public StringNodes.CaseCmpNode createNode(Object ... arguments) {
            if (arguments.length == 2 && (arguments[0] == null || arguments[0] instanceof RubyNode) && (arguments[1] == null || arguments[1] instanceof RubyNode)) {
                return CaseCmpNodeFactory.create((RubyNode)arguments[0], (RubyNode)arguments[1]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.CaseCmpNode> getInstance() {
            if (caseCmpNodeFactoryInstance == null) {
                caseCmpNodeFactoryInstance = new CaseCmpNodeFactory();
            }
            return caseCmpNodeFactoryInstance;
        }

        public static StringNodes.CaseCmpNode create(RubyNode string, RubyNode other) {
            return new CaseCmpNodeGen(string, other);
        }

        @GeneratedBy(value=StringNodes.CaseCmpNode.class)
        public static final class CaseCmpNodeGen
        extends StringNodes.CaseCmpNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode string_;
            @Node.Child
            private RubyNode other_;
            @Node.Child
            private BaseNode_ specialization_;

            private CaseCmpNodeGen(RubyNode string, RubyNode other) {
                this.string_ = string;
                this.other_ = this.coerceOtherToString(other);
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="caseCmp(DynamicObject, DynamicObject)", value=StringNodes.CaseCmpNode.class)
            private static final class CaseCmpNode_
            extends BaseNode_ {
                CaseCmpNode_(CaseCmpNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                    if (stringValue instanceof DynamicObject && otherValue instanceof DynamicObject) {
                        DynamicObject stringValue_ = (DynamicObject)stringValue;
                        DynamicObject otherValue_ = (DynamicObject)otherValue;
                        if (RubyGuards.isRubyString(otherValue_) && !StringNodes.CaseCmpNode.bothSingleByteOptimizable(stringValue_, otherValue_)) {
                            return this.root.caseCmp(stringValue_, otherValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, stringValue, otherValue);
                }

                static BaseNode_ create(CaseCmpNodeGen root) {
                    return new CaseCmpNode_(root);
                }
            }

            @GeneratedBy(methodName="caseCmpSingleByte(DynamicObject, DynamicObject)", value=StringNodes.CaseCmpNode.class)
            private static final class CaseCmpSingleByteNode_
            extends BaseNode_ {
                CaseCmpSingleByteNode_(CaseCmpNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                    if (stringValue instanceof DynamicObject && otherValue instanceof DynamicObject) {
                        DynamicObject stringValue_ = (DynamicObject)stringValue;
                        DynamicObject otherValue_ = (DynamicObject)otherValue;
                        if (RubyGuards.isRubyString(otherValue_) && StringNodes.CaseCmpNode.bothSingleByteOptimizable(stringValue_, otherValue_)) {
                            return this.root.caseCmpSingleByte(stringValue_, otherValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, stringValue, otherValue);
                }

                static BaseNode_ create(CaseCmpNodeGen root) {
                    return new CaseCmpSingleByteNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.CaseCmpNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(CaseCmpNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object stringValue, Object otherValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, stringValue, otherValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                    return this.getNext().execute_(frameValue, stringValue, otherValue);
                }

                static BaseNode_ create(CaseCmpNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.CaseCmpNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(CaseCmpNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                    return this.uninitialized((Frame)frameValue, stringValue, otherValue);
                }

                static BaseNode_ create(CaseCmpNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.CaseCmpNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected CaseCmpNodeGen root;

                BaseNode_(CaseCmpNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (CaseCmpNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.string_, this.root.other_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object stringValue, Object otherValue) {
                    return this.execute_((VirtualFrame)frameValue, stringValue, otherValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object stringValue_ = this.root.string_.execute(frameValue);
                    Object otherValue_ = this.root.other_.execute(frameValue);
                    return this.execute_(frameValue, stringValue_, otherValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object stringValue, Object otherValue) {
                    if (stringValue instanceof DynamicObject && otherValue instanceof DynamicObject) {
                        DynamicObject stringValue_ = (DynamicObject)stringValue;
                        DynamicObject otherValue_ = (DynamicObject)otherValue;
                        if (RubyGuards.isRubyString(otherValue_) && StringNodes.CaseCmpNode.bothSingleByteOptimizable(stringValue_, otherValue_)) {
                            return CaseCmpSingleByteNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyString(otherValue_) && !StringNodes.CaseCmpNode.bothSingleByteOptimizable(stringValue_, otherValue_)) {
                            return CaseCmpNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.ByteSizeNode.class)
    public static final class ByteSizeNodeFactory
    extends NodeFactoryBase<StringNodes.ByteSizeNode> {
        private static ByteSizeNodeFactory byteSizeNodeFactoryInstance;

        private ByteSizeNodeFactory() {
            super(StringNodes.ByteSizeNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public StringNodes.ByteSizeNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ByteSizeNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.ByteSizeNode> getInstance() {
            if (byteSizeNodeFactoryInstance == null) {
                byteSizeNodeFactoryInstance = new ByteSizeNodeFactory();
            }
            return byteSizeNodeFactoryInstance;
        }

        public static StringNodes.ByteSizeNode create(RubyNode[] arguments) {
            return new ByteSizeNodeGen(arguments);
        }

        @GeneratedBy(value=StringNodes.ByteSizeNode.class)
        public static final class ByteSizeNodeGen
        extends StringNodes.ByteSizeNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ByteSizeNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.byteSize(arguments0Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=StringNodes.BytesNode.class)
    public static final class BytesNodeFactory
    extends NodeFactoryBase<StringNodes.BytesNode> {
        private static BytesNodeFactory bytesNodeFactoryInstance;

        private BytesNodeFactory() {
            super(StringNodes.BytesNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public StringNodes.BytesNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return BytesNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.BytesNode> getInstance() {
            if (bytesNodeFactoryInstance == null) {
                bytesNodeFactoryInstance = new BytesNodeFactory();
            }
            return bytesNodeFactoryInstance;
        }

        public static StringNodes.BytesNode create(RubyNode[] arguments) {
            return new BytesNodeGen(arguments);
        }

        @GeneratedBy(value=StringNodes.BytesNode.class)
        public static final class BytesNodeGen
        extends StringNodes.BytesNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private BytesNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="bytes(VirtualFrame, DynamicObject, DynamicObject)", value=StringNodes.BytesNode.class)
            private static final class Bytes1Node_
            extends BaseNode_ {
                Bytes1Node_(BytesNodeGen root) {
                    super(root, 2);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        return this.root.bytes(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BytesNodeGen root) {
                    return new Bytes1Node_(root);
                }
            }

            @GeneratedBy(methodName="bytes(VirtualFrame, DynamicObject, NotProvided)", value=StringNodes.BytesNode.class)
            private static final class Bytes0Node_
            extends BaseNode_ {
                Bytes0Node_(BytesNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.bytes(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BytesNodeGen root) {
                    return new Bytes0Node_(root);
                }
            }

            @GeneratedBy(value=StringNodes.BytesNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(BytesNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BytesNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.BytesNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(BytesNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BytesNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.BytesNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected BytesNodeGen root;

                BaseNode_(BytesNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (BytesNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        if (arguments1Value instanceof NotProvided) {
                            return Bytes0Node_.create(this.root);
                        }
                        if (arguments1Value instanceof DynamicObject) {
                            return Bytes1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.BNode.class)
    public static final class BNodeFactory
    extends NodeFactoryBase<StringNodes.BNode> {
        private static BNodeFactory bNodeFactoryInstance;

        private BNodeFactory() {
            super(StringNodes.BNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public StringNodes.BNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.BNode> getInstance() {
            if (bNodeFactoryInstance == null) {
                bNodeFactoryInstance = new BNodeFactory();
            }
            return bNodeFactoryInstance;
        }

        public static StringNodes.BNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new BNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.BNode.class)
        public static final class BNodeGen
        extends StringNodes.BNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private BNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.b(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=StringNodes.ASCIIOnlyNode.class)
    public static final class ASCIIOnlyNodeFactory
    extends NodeFactoryBase<StringNodes.ASCIIOnlyNode> {
        private static ASCIIOnlyNodeFactory aSCIIOnlyNodeFactoryInstance;

        private ASCIIOnlyNodeFactory() {
            super(StringNodes.ASCIIOnlyNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public StringNodes.ASCIIOnlyNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ASCIIOnlyNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.ASCIIOnlyNode> getInstance() {
            if (aSCIIOnlyNodeFactoryInstance == null) {
                aSCIIOnlyNodeFactoryInstance = new ASCIIOnlyNodeFactory();
            }
            return aSCIIOnlyNodeFactoryInstance;
        }

        public static StringNodes.ASCIIOnlyNode create(RubyNode[] arguments) {
            return new ASCIIOnlyNodeGen(arguments);
        }

        @GeneratedBy(value=StringNodes.ASCIIOnlyNode.class)
        public static final class ASCIIOnlyNodeGen
        extends StringNodes.ASCIIOnlyNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private ASCIIOnlyNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="asciiOnly(DynamicObject)", value=StringNodes.ASCIIOnlyNode.class)
            private static final class AsciiOnlyNode_
            extends BaseNode_ {
                AsciiOnlyNode_(ASCIIOnlyNodeGen root) {
                    super(root, 3);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    if (!StringGuards.isAsciiCompatible(arguments0Value_)) {
                        return this.root.asciiOnly(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && !StringGuards.isAsciiCompatible(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.asciiOnly(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASCIIOnlyNodeGen root) {
                    return new AsciiOnlyNode_(root);
                }
            }

            @GeneratedBy(methodName="asciiOnlyAsciiCompatible(DynamicObject)", value=StringNodes.ASCIIOnlyNode.class)
            private static final class AsciiOnlyAsciiCompatibleNode_
            extends BaseNode_ {
                AsciiOnlyAsciiCompatibleNode_(ASCIIOnlyNodeGen root) {
                    super(root, 2);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    if (StringGuards.isAsciiCompatible(arguments0Value_) && !StringGuards.is7Bit(arguments0Value_)) {
                        return this.root.asciiOnlyAsciiCompatible(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && StringGuards.isAsciiCompatible(arguments0Value_ = (DynamicObject)arguments0Value) && !StringGuards.is7Bit(arguments0Value_)) {
                        return this.root.asciiOnlyAsciiCompatible(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASCIIOnlyNodeGen root) {
                    return new AsciiOnlyAsciiCompatibleNode_(root);
                }
            }

            @GeneratedBy(methodName="asciiOnlyAsciiCompatible7BitCR(DynamicObject)", value=StringNodes.ASCIIOnlyNode.class)
            private static final class AsciiOnlyAsciiCompatible7BitCRNode_
            extends BaseNode_ {
                AsciiOnlyAsciiCompatible7BitCRNode_(ASCIIOnlyNodeGen root) {
                    super(root, 1);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    if (StringGuards.isAsciiCompatible(arguments0Value_) && StringGuards.is7Bit(arguments0Value_)) {
                        return this.root.asciiOnlyAsciiCompatible7BitCR(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && StringGuards.isAsciiCompatible(arguments0Value_ = (DynamicObject)arguments0Value) && StringGuards.is7Bit(arguments0Value_)) {
                        return this.root.asciiOnlyAsciiCompatible7BitCR(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASCIIOnlyNodeGen root) {
                    return new AsciiOnlyAsciiCompatible7BitCRNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.ASCIIOnlyNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ASCIIOnlyNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASCIIOnlyNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.ASCIIOnlyNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ASCIIOnlyNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ASCIIOnlyNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.ASCIIOnlyNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ASCIIOnlyNodeGen root;

                BaseNode_(ASCIIOnlyNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (ASCIIOnlyNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeBoolean_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeBoolean_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (StringGuards.isAsciiCompatible(arguments0Value_) && StringGuards.is7Bit(arguments0Value_)) {
                            return AsciiOnlyAsciiCompatible7BitCRNode_.create(this.root);
                        }
                        if (StringGuards.isAsciiCompatible(arguments0Value_) && !StringGuards.is7Bit(arguments0Value_)) {
                            return AsciiOnlyAsciiCompatibleNode_.create(this.root);
                        }
                        if (!StringGuards.isAsciiCompatible(arguments0Value_)) {
                            return AsciiOnlyNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.GetIndexNode.class)
    public static final class GetIndexNodeFactory
    extends NodeFactoryBase<StringNodes.GetIndexNode> {
        private static GetIndexNodeFactory getIndexNodeFactoryInstance;

        private GetIndexNodeFactory() {
            super(StringNodes.GetIndexNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public StringNodes.GetIndexNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GetIndexNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.GetIndexNode> getInstance() {
            if (getIndexNodeFactoryInstance == null) {
                getIndexNodeFactoryInstance = new GetIndexNodeFactory();
            }
            return getIndexNodeFactoryInstance;
        }

        public static StringNodes.GetIndexNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new GetIndexNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.GetIndexNode.class)
        public static final class GetIndexNodeGen
        extends StringNodes.GetIndexNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private GetIndexNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="slice2(VirtualFrame, DynamicObject, DynamicObject, Object)", value=StringNodes.GetIndexNode.class)
            private static final class Slice21Node_
            extends BaseNode_ {
                Slice21Node_(GetIndexNodeGen root) {
                    super(root, 11);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if ((RubyGuards.wasNotProvided(arguments2Value) || this.root.isRubiniusUndefined(arguments2Value)) && RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.slice2(frameValue, arguments0Value_, arguments1Value_, arguments2Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(GetIndexNodeGen root) {
                    return new Slice21Node_(root);
                }
            }

            @GeneratedBy(methodName="sliceCapture(VirtualFrame, DynamicObject, DynamicObject, Object, SnippetNode)", value=StringNodes.GetIndexNode.class)
            private static final class SliceCaptureNode_
            extends BaseNode_ {
                @Node.Child
                private SnippetNode snippetNode;

                SliceCaptureNode_(GetIndexNodeGen root, SnippetNode snippetNode) {
                    super(root, 10);
                    this.snippetNode = snippetNode;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyRegexp(arguments1Value_) && RubyGuards.wasProvided(arguments2Value)) {
                            return this.root.sliceCapture(frameValue, arguments0Value_, arguments1Value_, arguments2Value, this.snippetNode);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(GetIndexNodeGen root, SnippetNode snippetNode) {
                    return new SliceCaptureNode_(root, snippetNode);
                }
            }

            @GeneratedBy(methodName="slice1(VirtualFrame, DynamicObject, DynamicObject, Object, SnippetNode)", value=StringNodes.GetIndexNode.class)
            private static final class Slice11Node_
            extends BaseNode_ {
                @Node.Child
                private SnippetNode snippetNode;

                Slice11Node_(GetIndexNodeGen root, SnippetNode snippetNode) {
                    super(root, 9);
                    this.snippetNode = snippetNode;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyRegexp(arguments1Value_) && (RubyGuards.wasNotProvided(arguments2Value) || this.root.isRubiniusUndefined(arguments2Value))) {
                            return this.root.slice1(frameValue, arguments0Value_, arguments1Value_, arguments2Value, this.snippetNode);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(GetIndexNodeGen root, SnippetNode snippetNode) {
                    return new Slice11Node_(root, snippetNode);
                }
            }

            @GeneratedBy(methodName="slice(VirtualFrame, DynamicObject, Object, Object)", value=StringNodes.GetIndexNode.class)
            private static final class Slice20Node_
            extends BaseNode_ {
                Slice20Node_(GetIndexNodeGen root) {
                    super(root, 8);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (!RubyGuards.isRubyRange(arguments1Value) && !RubyGuards.isRubyRegexp(arguments1Value) && !RubyGuards.isRubyString(arguments1Value) && RubyGuards.wasProvided(arguments2Value)) {
                            return this.root.slice(frameValue, arguments0Value_, arguments1Value, arguments2Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(GetIndexNodeGen root) {
                    return new Slice20Node_(root);
                }
            }

            @GeneratedBy(methodName="slice(VirtualFrame, DynamicObject, int, Object)", value=StringNodes.GetIndexNode.class)
            private static final class Slice10Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Slice10Node_(GetIndexNodeGen root, Object arguments1Value) {
                    super(root, 7);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Slice10Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    Object arguments2Value_ = this.executeArguments2_(frameValue);
                    if (RubyGuards.wasProvided(arguments2Value_)) {
                        return this.root.slice(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        if (RubyGuards.wasProvided(arguments2Value)) {
                            return this.root.slice(frameValue, arguments0Value_, arguments1Value_, arguments2Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(GetIndexNodeGen root, Object arguments1Value) {
                    return new Slice10Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="slice(VirtualFrame, DynamicObject, int, int)", value=StringNodes.GetIndexNode.class)
            private static final class Slice0Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;
                private final Class<?> arguments2ImplicitType;

                Slice0Node_(GetIndexNodeGen root, Object arguments1Value, Object arguments2Value) {
                    super(root, 6);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                    this.arguments2ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments2Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Slice0Node_)other).arguments1ImplicitType && this.arguments2ImplicitType == ((Slice0Node_)other).arguments2ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    try {
                        if (this.arguments2ImplicitType == Integer.TYPE) {
                            arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                        } else {
                            Object arguments2Value__ = this.executeArguments2_(frameValue);
                            arguments2Value_ = RubyTypesGen.expectImplicitInteger(arguments2Value__, this.arguments2ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult());
                    }
                    return this.root.slice(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && RubyTypesGen.isImplicitInteger(arguments2Value, this.arguments2ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        int arguments2Value_ = RubyTypesGen.asImplicitInteger(arguments2Value, this.arguments2ImplicitType);
                        return this.root.slice(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(GetIndexNodeGen root, Object arguments1Value, Object arguments2Value) {
                    return new Slice0Node_(root, arguments1Value, arguments2Value);
                }
            }

            @GeneratedBy(methodName="sliceObjectRange(VirtualFrame, DynamicObject, DynamicObject, Object)", value=StringNodes.GetIndexNode.class)
            private static final class SliceObjectRangeNode_
            extends BaseNode_ {
                SliceObjectRangeNode_(GetIndexNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isObjectRange(arguments1Value_) && (RubyGuards.wasNotProvided(arguments2Value) || this.root.isRubiniusUndefined(arguments2Value))) {
                            return this.root.sliceObjectRange(frameValue, arguments0Value_, arguments1Value_, arguments2Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(GetIndexNodeGen root) {
                    return new SliceObjectRangeNode_(root);
                }
            }

            @GeneratedBy(methodName="sliceLongRange(VirtualFrame, DynamicObject, DynamicObject, Object)", value=StringNodes.GetIndexNode.class)
            private static final class SliceLongRangeNode_
            extends BaseNode_ {
                SliceLongRangeNode_(GetIndexNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isLongFixnumRange(arguments1Value_) && (RubyGuards.wasNotProvided(arguments2Value) || this.root.isRubiniusUndefined(arguments2Value))) {
                            return this.root.sliceLongRange(frameValue, arguments0Value_, arguments1Value_, arguments2Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(GetIndexNodeGen root) {
                    return new SliceLongRangeNode_(root);
                }
            }

            @GeneratedBy(methodName="sliceIntegerRange(VirtualFrame, DynamicObject, DynamicObject, Object)", value=StringNodes.GetIndexNode.class)
            private static final class SliceIntegerRangeNode_
            extends BaseNode_ {
                SliceIntegerRangeNode_(GetIndexNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isIntegerFixnumRange(arguments1Value_) && (RubyGuards.wasNotProvided(arguments2Value) || this.root.isRubiniusUndefined(arguments2Value))) {
                            return this.root.sliceIntegerRange(frameValue, arguments0Value_, arguments1Value_, arguments2Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(GetIndexNodeGen root) {
                    return new SliceIntegerRangeNode_(root);
                }
            }

            @GeneratedBy(methodName="getIndex(VirtualFrame, DynamicObject, Object, Object)", value=StringNodes.GetIndexNode.class)
            private static final class GetIndex1Node_
            extends BaseNode_ {
                GetIndex1Node_(GetIndexNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (!(RubyGuards.isRubyRange(arguments1Value) || RubyGuards.isRubyRegexp(arguments1Value) || RubyGuards.isRubyString(arguments1Value) || !RubyGuards.wasNotProvided(arguments2Value) && !this.root.isRubiniusUndefined(arguments2Value))) {
                            return this.root.getIndex(frameValue, arguments0Value_, arguments1Value, arguments2Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(GetIndexNodeGen root) {
                    return new GetIndex1Node_(root);
                }
            }

            @GeneratedBy(methodName="getIndex(VirtualFrame, DynamicObject, int, Object)", value=StringNodes.GetIndexNode.class)
            private static final class GetIndex0Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                GetIndex0Node_(GetIndexNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((GetIndex0Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    Object arguments2Value_ = this.executeArguments2_(frameValue);
                    if (RubyGuards.wasNotProvided(arguments2Value_) || this.root.isRubiniusUndefined(arguments2Value_)) {
                        return this.root.getIndex(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        if (RubyGuards.wasNotProvided(arguments2Value) || this.root.isRubiniusUndefined(arguments2Value)) {
                            return this.root.getIndex(frameValue, arguments0Value_, arguments1Value_, arguments2Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(GetIndexNodeGen root, Object arguments1Value) {
                    return new GetIndex0Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=StringNodes.GetIndexNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(GetIndexNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(GetIndexNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.GetIndexNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(GetIndexNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(GetIndexNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.GetIndexNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected GetIndexNodeGen root;

                BaseNode_(GetIndexNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (GetIndexNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    Object arguments2Value_ = this.executeArguments2_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments1Value_;
                        if (RubyTypesGen.isImplicitInteger(arguments1Value) && (RubyGuards.wasNotProvided(arguments2Value) || this.root.isRubiniusUndefined(arguments2Value))) {
                            return GetIndex0Node_.create(this.root, arguments1Value);
                        }
                        if (!(RubyGuards.isRubyRange(arguments1Value) || RubyGuards.isRubyRegexp(arguments1Value) || RubyGuards.isRubyString(arguments1Value) || !RubyGuards.wasNotProvided(arguments2Value) && !this.root.isRubiniusUndefined(arguments2Value))) {
                            return GetIndex1Node_.create(this.root);
                        }
                        if (arguments1Value instanceof DynamicObject) {
                            arguments1Value_ = (DynamicObject)arguments1Value;
                            if (RubyGuards.isIntegerFixnumRange(arguments1Value_) && (RubyGuards.wasNotProvided(arguments2Value) || this.root.isRubiniusUndefined(arguments2Value))) {
                                return SliceIntegerRangeNode_.create(this.root);
                            }
                            if (RubyGuards.isLongFixnumRange(arguments1Value_) && (RubyGuards.wasNotProvided(arguments2Value) || this.root.isRubiniusUndefined(arguments2Value))) {
                                return SliceLongRangeNode_.create(this.root);
                            }
                            if (RubyGuards.isObjectRange(arguments1Value_) && (RubyGuards.wasNotProvided(arguments2Value) || this.root.isRubiniusUndefined(arguments2Value))) {
                                return SliceObjectRangeNode_.create(this.root);
                            }
                        }
                        if (RubyTypesGen.isImplicitInteger(arguments1Value)) {
                            if (RubyTypesGen.isImplicitInteger(arguments2Value)) {
                                return Slice0Node_.create(this.root, arguments1Value, arguments2Value);
                            }
                            if (RubyGuards.wasProvided(arguments2Value)) {
                                return Slice10Node_.create(this.root, arguments1Value);
                            }
                        }
                        if (!RubyGuards.isRubyRange(arguments1Value) && !RubyGuards.isRubyRegexp(arguments1Value) && !RubyGuards.isRubyString(arguments1Value) && RubyGuards.wasProvided(arguments2Value)) {
                            return Slice20Node_.create(this.root);
                        }
                        if (arguments1Value instanceof DynamicObject) {
                            arguments1Value_ = (DynamicObject)arguments1Value;
                            if (RubyGuards.isRubyRegexp(arguments1Value_) && (RubyGuards.wasNotProvided(arguments2Value) || this.root.isRubiniusUndefined(arguments2Value))) {
                                SnippetNode snippetNode9 = new SnippetNode();
                                return Slice11Node_.create(this.root, snippetNode9);
                            }
                            if (RubyGuards.isRubyRegexp(arguments1Value_) && RubyGuards.wasProvided(arguments2Value)) {
                                SnippetNode snippetNode10 = new SnippetNode();
                                return SliceCaptureNode_.create(this.root, snippetNode10);
                            }
                            if ((RubyGuards.wasNotProvided(arguments2Value) || this.root.isRubiniusUndefined(arguments2Value)) && RubyGuards.isRubyString(arguments1Value_)) {
                                return Slice21Node_.create(this.root);
                            }
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments2_(Frame frameValue) {
                    Object object;
                    Class arguments2Type_ = this.root.arguments2Type_;
                    if (arguments2Type_ == Integer.TYPE) {
                        return this.root.arguments2_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments2Type_ != null) return this.root.arguments2_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments2_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments2Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments2Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments2Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.ConcatNode.class)
    public static final class ConcatNodeFactory
    extends NodeFactoryBase<StringNodes.ConcatNode> {
        private static ConcatNodeFactory concatNodeFactoryInstance;

        private ConcatNodeFactory() {
            super(StringNodes.ConcatNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode.class, RubyNode.class}});
        }

        @Override
        public StringNodes.ConcatNode createNode(Object ... arguments) {
            if (arguments.length == 2 && (arguments[0] == null || arguments[0] instanceof RubyNode) && (arguments[1] == null || arguments[1] instanceof RubyNode)) {
                return ConcatNodeFactory.create((RubyNode)arguments[0], (RubyNode)arguments[1]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.ConcatNode> getInstance() {
            if (concatNodeFactoryInstance == null) {
                concatNodeFactoryInstance = new ConcatNodeFactory();
            }
            return concatNodeFactoryInstance;
        }

        public static StringNodes.ConcatNode create(RubyNode string, RubyNode other) {
            return new ConcatNodeGen(string, other);
        }

        @GeneratedBy(value=StringNodes.ConcatNode.class)
        public static final class ConcatNodeGen
        extends StringNodes.ConcatNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode string_;
            @Node.Child
            private RubyNode other_;
            @Node.Child
            private BaseNode_ specialization_;

            private ConcatNodeGen(RubyNode string, RubyNode other) {
                this.string_ = string;
                this.other_ = other;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="concat(VirtualFrame, DynamicObject, Object, CallDispatchHeadNode)", value=StringNodes.ConcatNode.class)
            private static final class ConcatNode_
            extends BaseNode_ {
                @Node.Child
                private CallDispatchHeadNode callNode;

                ConcatNode_(ConcatNodeGen root, CallDispatchHeadNode callNode) {
                    super(root, 3);
                    this.callNode = callNode;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                    if (stringValue instanceof DynamicObject) {
                        DynamicObject stringValue_ = (DynamicObject)stringValue;
                        if (!RubyGuards.isRubyString(otherValue)) {
                            return this.root.concat(frameValue, stringValue_, otherValue, this.callNode);
                        }
                    }
                    return this.getNext().execute_(frameValue, stringValue, otherValue);
                }

                static BaseNode_ create(ConcatNodeGen root, CallDispatchHeadNode callNode) {
                    return new ConcatNode_(root, callNode);
                }
            }

            @GeneratedBy(methodName="concatString(DynamicObject, DynamicObject)", value=StringNodes.ConcatNode.class)
            private static final class ConcatStringNode_
            extends BaseNode_ {
                ConcatStringNode_(ConcatNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                    if (stringValue instanceof DynamicObject && otherValue instanceof DynamicObject) {
                        DynamicObject stringValue_ = (DynamicObject)stringValue;
                        DynamicObject otherValue_ = (DynamicObject)otherValue;
                        if (!(!RubyGuards.isRubyString(otherValue_) || StringGuards.is7Bit(stringValue_) && StringGuards.is7Bit(otherValue_))) {
                            return this.root.concatString(stringValue_, otherValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, stringValue, otherValue);
                }

                static BaseNode_ create(ConcatNodeGen root) {
                    return new ConcatStringNode_(root);
                }
            }

            @GeneratedBy(methodName="concatStringSingleByte(DynamicObject, DynamicObject)", value=StringNodes.ConcatNode.class)
            private static final class ConcatStringSingleByteNode_
            extends BaseNode_ {
                ConcatStringSingleByteNode_(ConcatNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                    if (stringValue instanceof DynamicObject && otherValue instanceof DynamicObject) {
                        DynamicObject stringValue_ = (DynamicObject)stringValue;
                        DynamicObject otherValue_ = (DynamicObject)otherValue;
                        if (RubyGuards.isRubyString(otherValue_) && StringGuards.is7Bit(stringValue_) && StringGuards.is7Bit(otherValue_)) {
                            return this.root.concatStringSingleByte(stringValue_, otherValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, stringValue, otherValue);
                }

                static BaseNode_ create(ConcatNodeGen root) {
                    return new ConcatStringSingleByteNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.ConcatNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ConcatNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object stringValue, Object otherValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, stringValue, otherValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                    return this.getNext().execute_(frameValue, stringValue, otherValue);
                }

                static BaseNode_ create(ConcatNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.ConcatNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ConcatNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                    return this.uninitialized((Frame)frameValue, stringValue, otherValue);
                }

                static BaseNode_ create(ConcatNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.ConcatNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ConcatNodeGen root;

                BaseNode_(ConcatNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (ConcatNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.string_, this.root.other_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object stringValue, Object otherValue) {
                    return this.execute_((VirtualFrame)frameValue, stringValue, otherValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object stringValue_ = this.root.string_.execute(frameValue);
                    Object otherValue_ = this.root.other_.execute(frameValue);
                    return this.execute_(frameValue, stringValue_, otherValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object stringValue, Object otherValue) {
                    if (stringValue instanceof DynamicObject) {
                        DynamicObject stringValue_ = (DynamicObject)stringValue;
                        if (otherValue instanceof DynamicObject) {
                            DynamicObject otherValue_ = (DynamicObject)otherValue;
                            if (RubyGuards.isRubyString(otherValue_) && StringGuards.is7Bit(stringValue_) && StringGuards.is7Bit(otherValue_)) {
                                return ConcatStringSingleByteNode_.create(this.root);
                            }
                            if (!(!RubyGuards.isRubyString(otherValue_) || StringGuards.is7Bit(stringValue_) && StringGuards.is7Bit(otherValue_))) {
                                return ConcatStringNode_.create(this.root);
                            }
                        }
                        if (!RubyGuards.isRubyString(otherValue)) {
                            CallDispatchHeadNode callNode3 = CallDispatchHeadNode.createMethodCall();
                            return ConcatNode_.create(this.root, callNode3);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.CompareNode.class)
    public static final class CompareNodeFactory
    extends NodeFactoryBase<StringNodes.CompareNode> {
        private static CompareNodeFactory compareNodeFactoryInstance;

        private CompareNodeFactory() {
            super(StringNodes.CompareNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public StringNodes.CompareNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return CompareNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.CompareNode> getInstance() {
            if (compareNodeFactoryInstance == null) {
                compareNodeFactoryInstance = new CompareNodeFactory();
            }
            return compareNodeFactoryInstance;
        }

        public static StringNodes.CompareNode create(RubyNode[] arguments) {
            return new CompareNodeGen(arguments);
        }

        @GeneratedBy(value=StringNodes.CompareNode.class)
        public static final class CompareNodeGen
        extends StringNodes.CompareNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private CompareNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="compare(VirtualFrame, DynamicObject, Object)", value=StringNodes.CompareNode.class)
            private static final class Compare1Node_
            extends BaseNode_ {
                Compare1Node_(CompareNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (!RubyGuards.isRubyString(arguments1Value)) {
                            return this.root.compare(frameValue, arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new Compare1Node_(root);
                }
            }

            @GeneratedBy(methodName="compare(DynamicObject, DynamicObject)", value=StringNodes.CompareNode.class)
            private static final class Compare0Node_
            extends BaseNode_ {
                Compare0Node_(CompareNodeGen root) {
                    super(root, 1);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    DynamicObject arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        return CompareNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return CompareNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    if (RubyGuards.isRubyString(arguments1Value_)) {
                        return this.root.compare(arguments0Value_, arguments1Value_);
                    }
                    return CompareNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.compare(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new Compare0Node_(root);
                }
            }

            @GeneratedBy(value=StringNodes.CompareNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(CompareNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.CompareNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(CompareNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompareNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.CompareNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected CompareNodeGen root;

                BaseNode_(CompareNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (CompareNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return CompareNodeGen.expectInteger(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments1Value_;
                        if (arguments1Value instanceof DynamicObject && RubyGuards.isRubyString(arguments1Value_ = (DynamicObject)arguments1Value)) {
                            return Compare0Node_.create(this.root);
                        }
                        if (!RubyGuards.isRubyString(arguments1Value)) {
                            return Compare1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.EqualNode.class)
    public static final class EqualNodeFactory
    extends NodeFactoryBase<StringNodes.EqualNode> {
        private static EqualNodeFactory equalNodeFactoryInstance;

        private EqualNodeFactory() {
            super(StringNodes.EqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public StringNodes.EqualNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EqualNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.EqualNode> getInstance() {
            if (equalNodeFactoryInstance == null) {
                equalNodeFactoryInstance = new EqualNodeFactory();
            }
            return equalNodeFactoryInstance;
        }

        public static StringNodes.EqualNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new EqualNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.EqualNode.class)
        public static final class EqualNodeGen
        extends StringNodes.EqualNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private EqualNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="equal(VirtualFrame, DynamicObject, Object)", value=StringNodes.EqualNode.class)
            private static final class Equal1Node_
            extends BaseNode_ {
                Equal1Node_(EqualNodeGen root) {
                    super(root, 2);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        return this.getNext().executeBoolean_(frameValue, ex.getResult(), arguments1Value);
                    }
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    if (!RubyGuards.isRubyString(arguments1Value_)) {
                        return this.root.equal(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (!RubyGuards.isRubyString(arguments1Value)) {
                            return this.root.equal(frameValue, arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EqualNodeGen root) {
                    return new Equal1Node_(root);
                }
            }

            @GeneratedBy(methodName="equal(DynamicObject, DynamicObject)", value=StringNodes.EqualNode.class)
            private static final class Equal0Node_
            extends BaseNode_ {
                Equal0Node_(EqualNodeGen root) {
                    super(root, 1);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    DynamicObject arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        return this.getNext().executeBoolean_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyString(arguments1Value_)) {
                        return this.root.equal(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.equal(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EqualNodeGen root) {
                    return new Equal0Node_(root);
                }
            }

            @GeneratedBy(value=StringNodes.EqualNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(EqualNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EqualNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.EqualNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(EqualNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EqualNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.EqualNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected EqualNodeGen root;

                BaseNode_(EqualNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (EqualNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeBoolean_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments1Value_;
                        if (arguments1Value instanceof DynamicObject && RubyGuards.isRubyString(arguments1Value_ = (DynamicObject)arguments1Value)) {
                            return Equal0Node_.create(this.root);
                        }
                        if (!RubyGuards.isRubyString(arguments1Value)) {
                            return Equal1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.MulNode.class)
    public static final class MulNodeFactory
    extends NodeFactoryBase<StringNodes.MulNode> {
        private static MulNodeFactory mulNodeFactoryInstance;

        private MulNodeFactory() {
            super(StringNodes.MulNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public StringNodes.MulNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MulNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.MulNode> getInstance() {
            if (mulNodeFactoryInstance == null) {
                mulNodeFactoryInstance = new MulNodeFactory();
            }
            return mulNodeFactoryInstance;
        }

        public static StringNodes.MulNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new MulNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.MulNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class MulNodeGen
        extends StringNodes.MulNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private MulNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public DynamicObject executeInt(VirtualFrame frameValue, DynamicObject arguments0Value, int arguments1Value) {
                return this.specialization_.executeDynamicObject1(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                return this.specialization_.executeDynamicObject0(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="multiply(VirtualFrame, DynamicObject, Object)", value=StringNodes.MulNode.class)
            private static final class Multiply2Node_
            extends BaseNode_ {
                Multiply2Node_(MulNodeGen root) {
                    super(root, 4);
                }

                @Override
                public DynamicObject executeDynamicObject1(VirtualFrame frameValue, DynamicObject arguments0Value, int arguments1Value) {
                    if (!RubyGuards.isRubyBignum(arguments1Value) && !RubyGuards.isInteger(arguments1Value)) {
                        return this.root.multiply(frameValue, arguments0Value, arguments1Value);
                    }
                    return this.getNext().executeDynamicObject1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (!RubyGuards.isRubyBignum(arguments1Value) && !RubyGuards.isInteger(arguments1Value)) {
                            return this.root.multiply(frameValue, arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root) {
                    return new Multiply2Node_(root);
                }
            }

            @GeneratedBy(methodName="multiply(DynamicObject, DynamicObject)", value=StringNodes.MulNode.class)
            private static final class Multiply1Node_
            extends BaseNode_ {
                Multiply1Node_(MulNodeGen root) {
                    super(root, 3);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.multiply(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root) {
                    return new Multiply1Node_(root);
                }
            }

            @GeneratedBy(methodName="multiply(DynamicObject, int, MakeRepeatingNode)", value=StringNodes.MulNode.class)
            private static final class Multiply0Node_
            extends BaseNode_ {
                @Node.Child
                private RopeNodes.MakeRepeatingNode makeRepeatingNode;
                private final Class<?> arguments1ImplicitType;

                Multiply0Node_(MulNodeGen root, Object arguments1Value, RopeNodes.MakeRepeatingNode makeRepeatingNode) {
                    super(root, 2);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                    this.makeRepeatingNode = makeRepeatingNode;
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Multiply0Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDynamicObject0(frameValue);
                }

                @Override
                public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeDynamicObject_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (arguments1Value_ >= 0) {
                        return this.root.multiply(arguments0Value_, arguments1Value_, this.makeRepeatingNode);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public DynamicObject executeDynamicObject1(VirtualFrame frameValue, DynamicObject arguments0Value, int arguments1Value) {
                    if (arguments1Value >= 0) {
                        return this.root.multiply(arguments0Value, arguments1Value, this.makeRepeatingNode);
                    }
                    return this.getNext().executeDynamicObject1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        if (arguments1Value_ >= 0) {
                            return this.root.multiply(arguments0Value_, arguments1Value_, this.makeRepeatingNode);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root, Object arguments1Value, RopeNodes.MakeRepeatingNode makeRepeatingNode) {
                    return new Multiply0Node_(root, arguments1Value, makeRepeatingNode);
                }
            }

            @GeneratedBy(methodName="multiplyTimesNegative(DynamicObject, int)", value=StringNodes.MulNode.class)
            private static final class MultiplyTimesNegativeNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                MultiplyTimesNegativeNode_(MulNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((MultiplyTimesNegativeNode_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDynamicObject0(frameValue);
                }

                @Override
                public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeDynamicObject_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (arguments1Value_ < 0) {
                        return this.root.multiplyTimesNegative(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public DynamicObject executeDynamicObject1(VirtualFrame frameValue, DynamicObject arguments0Value, int arguments1Value) {
                    if (arguments1Value < 0) {
                        return this.root.multiplyTimesNegative(arguments0Value, arguments1Value);
                    }
                    return this.getNext().executeDynamicObject1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        if (arguments1Value_ < 0) {
                            return this.root.multiplyTimesNegative(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root, Object arguments1Value) {
                    return new MultiplyTimesNegativeNode_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=StringNodes.MulNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(MulNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.MulNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(MulNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MulNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.MulNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected MulNodeGen root;

                BaseNode_(MulNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (MulNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3);

                public DynamicObject executeDynamicObject1(VirtualFrame frameValue, DynamicObject arguments0Value, int arguments1Value) {
                    return this.executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
                    return (DynamicObject)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments1Value_;
                        if (RubyTypesGen.isImplicitInteger(arguments1Value)) {
                            int arguments1Value_2 = RubyTypesGen.asImplicitInteger(arguments1Value);
                            if (arguments1Value_2 < 0) {
                                return MultiplyTimesNegativeNode_.create(this.root, arguments1Value);
                            }
                            if (arguments1Value_2 >= 0) {
                                RopeNodes.MakeRepeatingNode makeRepeatingNode2 = RopeNodes.MakeRepeatingNode.create();
                                return Multiply0Node_.create(this.root, arguments1Value, makeRepeatingNode2);
                            }
                        }
                        if (arguments1Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments1Value_ = (DynamicObject)arguments1Value)) {
                            return Multiply1Node_.create(this.root);
                        }
                        if (!RubyGuards.isRubyBignum(arguments1Value) && !RubyGuards.isInteger(arguments1Value)) {
                            return Multiply2Node_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.AddNode.class)
    public static final class AddNodeFactory
    extends NodeFactoryBase<StringNodes.AddNode> {
        private static AddNodeFactory addNodeFactoryInstance;

        private AddNodeFactory() {
            super(StringNodes.AddNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public StringNodes.AddNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return AddNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.AddNode> getInstance() {
            if (addNodeFactoryInstance == null) {
                addNodeFactoryInstance = new AddNodeFactory();
            }
            return addNodeFactoryInstance;
        }

        public static StringNodes.AddNode create(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode other) {
            return new AddNodeGen(context, sourceSection, string, other);
        }

        @GeneratedBy(value=StringNodes.AddNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class AddNodeGen
        extends StringNodes.AddNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode string_;
            @Node.Child
            private RubyNode other_;
            @Node.Child
            private BaseNode_ specialization_;

            private AddNodeGen(RubyContext context, SourceSection sourceSection, RubyNode string, RubyNode other) {
                super(context, sourceSection);
                this.string_ = string;
                this.other_ = this.coerceOtherToString(other);
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="addDifferentEncodings(DynamicObject, DynamicObject)", value=StringNodes.AddNode.class)
            private static final class AddDifferentEncodingsNode_
            extends BaseNode_ {
                AddDifferentEncodingsNode_(AddNodeGen root) {
                    super(root, 3);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                    if (stringValue instanceof DynamicObject && otherValue instanceof DynamicObject) {
                        DynamicObject stringValue_ = (DynamicObject)stringValue;
                        DynamicObject otherValue_ = (DynamicObject)otherValue;
                        if (RubyGuards.isRubyString(otherValue_) && this.root.getEncoding(stringValue_) != this.root.getEncoding(otherValue_) && !this.root.isUTF8AndUSASCII(stringValue_, otherValue_)) {
                            return this.root.addDifferentEncodings(stringValue_, otherValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, stringValue, otherValue);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new AddDifferentEncodingsNode_(root);
                }
            }

            @GeneratedBy(methodName="addUTF8AndUSASCII(DynamicObject, DynamicObject)", value=StringNodes.AddNode.class)
            private static final class AddUTF8AndUSASCIINode_
            extends BaseNode_ {
                AddUTF8AndUSASCIINode_(AddNodeGen root) {
                    super(root, 2);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                    if (stringValue instanceof DynamicObject && otherValue instanceof DynamicObject) {
                        DynamicObject stringValue_ = (DynamicObject)stringValue;
                        DynamicObject otherValue_ = (DynamicObject)otherValue;
                        if (RubyGuards.isRubyString(otherValue_) && this.root.getEncoding(stringValue_) != this.root.getEncoding(otherValue_) && this.root.isUTF8AndUSASCII(stringValue_, otherValue_)) {
                            return this.root.addUTF8AndUSASCII(stringValue_, otherValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, stringValue, otherValue);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new AddUTF8AndUSASCIINode_(root);
                }
            }

            @GeneratedBy(methodName="addSameEncoding(DynamicObject, DynamicObject)", value=StringNodes.AddNode.class)
            private static final class AddSameEncodingNode_
            extends BaseNode_ {
                AddSameEncodingNode_(AddNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                    if (stringValue instanceof DynamicObject && otherValue instanceof DynamicObject) {
                        DynamicObject stringValue_ = (DynamicObject)stringValue;
                        DynamicObject otherValue_ = (DynamicObject)otherValue;
                        if (RubyGuards.isRubyString(otherValue_) && this.root.getEncoding(stringValue_) == this.root.getEncoding(otherValue_)) {
                            return this.root.addSameEncoding(stringValue_, otherValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, stringValue, otherValue);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new AddSameEncodingNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.AddNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(AddNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object stringValue, Object otherValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, stringValue, otherValue));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                    return this.getNext().executeDynamicObject_(frameValue, stringValue, otherValue);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.AddNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(AddNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object stringValue, Object otherValue) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, stringValue, otherValue);
                }

                static BaseNode_ create(AddNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=StringNodes.AddNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected AddNodeGen root;

                BaseNode_(AddNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (AddNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.string_, this.root.other_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object stringValue, Object otherValue) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, stringValue, otherValue);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object stringValue_ = this.root.string_.execute(frameValue);
                    Object otherValue_ = this.root.other_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, stringValue_, otherValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object stringValue, Object otherValue) {
                    if (stringValue instanceof DynamicObject && otherValue instanceof DynamicObject) {
                        DynamicObject stringValue_ = (DynamicObject)stringValue;
                        DynamicObject otherValue_ = (DynamicObject)otherValue;
                        if (RubyGuards.isRubyString(otherValue_) && this.root.getEncoding(stringValue_) == this.root.getEncoding(otherValue_)) {
                            return AddSameEncodingNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyString(otherValue_) && this.root.getEncoding(stringValue_) != this.root.getEncoding(otherValue_) && this.root.isUTF8AndUSASCII(stringValue_, otherValue_)) {
                            return AddUTF8AndUSASCIINode_.create(this.root);
                        }
                        if (RubyGuards.isRubyString(otherValue_) && this.root.getEncoding(stringValue_) != this.root.getEncoding(otherValue_) && !this.root.isUTF8AndUSASCII(stringValue_, otherValue_)) {
                            return AddDifferentEncodingsNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=StringNodes.AllocateNode.class)
    public static final class AllocateNodeFactory
    extends NodeFactoryBase<StringNodes.AllocateNode> {
        private static AllocateNodeFactory allocateNodeFactoryInstance;

        private AllocateNodeFactory() {
            super(StringNodes.AllocateNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public StringNodes.AllocateNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AllocateNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<StringNodes.AllocateNode> getInstance() {
            if (allocateNodeFactoryInstance == null) {
                allocateNodeFactoryInstance = new AllocateNodeFactory();
            }
            return allocateNodeFactoryInstance;
        }

        public static StringNodes.AllocateNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new AllocateNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=StringNodes.AllocateNode.class)
        public static final class AllocateNodeGen
        extends StringNodes.AllocateNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AllocateNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.allocate(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }
}

